/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.RuntimeIOException;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.CursorImpl;
import com.healthmarketscience.jackcess.impl.IndexData;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.impl.RowIdImpl;
import com.healthmarketscience.jackcess.impl.RowImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.util.CaseInsensitiveColumnMatcher;
import com.healthmarketscience.jackcess.util.ColumnMatcher;
import com.healthmarketscience.jackcess.util.EntryIterableBuilder;
import com.healthmarketscience.jackcess.util.SimpleColumnMatcher;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexCursorImpl
extends CursorImpl
implements IndexCursor {
    private static final Log LOG = LogFactory.getLog(IndexCursorImpl.class);
    private final IndexDirHandler _forwardDirHandler = new ForwardIndexDirHandler();
    private final IndexDirHandler _reverseDirHandler = new ReverseIndexDirHandler();
    private final IndexImpl _index;
    private final IndexData.EntryCursor _entryCursor;
    private Set<String> _indexEntryPattern;

    private IndexCursorImpl(TableImpl table, IndexImpl index, IndexData.EntryCursor entryCursor) throws IOException {
        super(new CursorImpl.IdImpl(table, index), table, new IndexPosition(entryCursor.getFirstEntry()), new IndexPosition(entryCursor.getLastEntry()));
        this._index = index;
        this._index.initialize();
        this._entryCursor = entryCursor;
    }

    public static IndexCursorImpl createCursor(TableImpl table, IndexImpl index, Object[] startRow, boolean startInclusive, Object[] endRow, boolean endInclusive) throws IOException {
        if (table != index.getTable()) {
            throw new IllegalArgumentException("Given index is not for given table: " + index + ", " + table);
        }
        if (!table.getFormat().INDEXES_SUPPORTED) {
            throw new IllegalArgumentException("JetFormat " + table.getFormat() + " does not currently support index lookups");
        }
        if (index.getIndexData().getUnsupportedReason() != null) {
            throw new IllegalArgumentException("Given index " + index + " is not usable for indexed lookups due to " + index.getIndexData().getUnsupportedReason());
        }
        IndexCursorImpl cursor = new IndexCursorImpl(table, index, index.cursor(startRow, startInclusive, endRow, endInclusive));
        cursor.setColumnMatcher(null);
        return cursor;
    }

    private Set<String> getIndexEntryPattern() {
        if (this._indexEntryPattern == null) {
            this._indexEntryPattern = new HashSet<String>();
            for (IndexData.ColumnDescriptor col : this.getIndex().getColumns()) {
                this._indexEntryPattern.add(col.getName());
            }
        }
        return this._indexEntryPattern;
    }

    @Override
    public IndexImpl getIndex() {
        return this._index;
    }

    @Override
    public Row findRowByEntry(Object ... entryValues) throws IOException {
        if (this.findFirstRowByEntry(entryValues)) {
            return this.getCurrentRow();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findFirstRowByEntry(Object ... entryValues) throws IOException {
        CursorImpl.PositionImpl curPos = this._curPos;
        CursorImpl.PositionImpl prevPos = this._prevPos;
        boolean found = false;
        try {
            boolean bl = found = this.findFirstRowByEntryImpl(this.toRowValues(entryValues), true, this._columnMatcher);
            return bl;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findClosestRowByEntry(Object ... entryValues) throws IOException {
        CursorImpl.PositionImpl curPos = this._curPos;
        CursorImpl.PositionImpl prevPos = this._prevPos;
        boolean found = false;
        try {
            this.findFirstRowByEntryImpl(this.toRowValues(entryValues), false, this._columnMatcher);
            found = true;
        }
        finally {
            if (!found) {
                try {
                    this.restorePosition(curPos, prevPos);
                }
                catch (IOException e) {
                    LOG.error((Object)"Failed restoring position", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean currentRowMatchesEntry(Object ... entryValues) throws IOException {
        return this.currentRowMatchesEntryImpl(this.toRowValues(entryValues), this._columnMatcher);
    }

    @Override
    public EntryIterableBuilder newEntryIterable(Object ... entryValues) {
        return new EntryIterableBuilder(this, entryValues);
    }

    public Iterator<Row> entryIterator(EntryIterableBuilder iterBuilder) {
        return new EntryIterator(iterBuilder.getColumnNames(), this.toRowValues(iterBuilder.getEntryValues()), iterBuilder.getColumnMatcher());
    }

    @Override
    protected IndexDirHandler getDirHandler(boolean moveForward) {
        return moveForward ? this._forwardDirHandler : this._reverseDirHandler;
    }

    @Override
    protected boolean isUpToDate() {
        return super.isUpToDate() && this._entryCursor.isUpToDate();
    }

    @Override
    protected void reset(boolean moveForward) {
        this._entryCursor.reset(moveForward);
        super.reset(moveForward);
    }

    @Override
    protected void restorePositionImpl(CursorImpl.PositionImpl curPos, CursorImpl.PositionImpl prevPos) throws IOException {
        if (!(curPos instanceof IndexPosition) || !(prevPos instanceof IndexPosition)) {
            throw new IllegalArgumentException("Restored positions must be index positions");
        }
        this._entryCursor.restorePosition(((IndexPosition)curPos).getEntry(), ((IndexPosition)prevPos).getEntry());
        super.restorePositionImpl(curPos, prevPos);
    }

    @Override
    protected CursorImpl.PositionImpl getRowPosition(RowIdImpl rowId) throws IOException {
        RowImpl row = this.getTable().getRow(this.getRowState(), rowId, this.getIndexEntryPattern());
        this._entryCursor.beforeEntry(this.getTable().asRow(row));
        return new IndexPosition(this._entryCursor.getNextEntry());
    }

    @Override
    protected boolean findAnotherRowImpl(ColumnImpl columnPattern, Object valuePattern, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        Object[] rowValues = (Object[])searchInfo;
        if (rowValues == null || !this.isAtBeginning(moveForward)) {
            return super.findAnotherRowImpl(columnPattern, valuePattern, moveForward, columnMatcher, rowValues);
        }
        if (!this.findPotentialRow(rowValues, true)) {
            return false;
        }
        return this.currentRowMatchesImpl(columnPattern, valuePattern, columnMatcher);
    }

    protected boolean findFirstRowByEntryImpl(Object[] rowValues, boolean requireMatch, ColumnMatcher columnMatcher) throws IOException {
        if (!this.findPotentialRow(rowValues, requireMatch)) {
            return false;
        }
        if (!requireMatch) {
            return true;
        }
        return this.currentRowMatchesEntryImpl(rowValues, columnMatcher);
    }

    @Override
    protected boolean findAnotherRowImpl(Map<String, ?> rowPattern, boolean moveForward, ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        Object[] rowValues = (Object[])searchInfo;
        if (rowValues == null || !this.isAtBeginning(moveForward)) {
            return super.findAnotherRowImpl(rowPattern, moveForward, columnMatcher, rowValues);
        }
        if (!this.findPotentialRow(rowValues, true)) {
            return false;
        }
        boolean exactColumnMatch = ((Object)rowPattern.keySet()).equals(this.getIndexEntryPattern());
        while (this.currentRowMatchesEntryImpl(rowValues, columnMatcher)) {
            if (exactColumnMatch || this.currentRowMatchesImpl(rowPattern, columnMatcher)) {
                return true;
            }
            if (this.moveToAnotherRow(moveForward)) continue;
        }
        return false;
    }

    private boolean currentRowMatchesEntryImpl(Object[] rowValues, ColumnMatcher columnMatcher) throws IOException {
        Row row = this.getCurrentRow(this.getIndexEntryPattern());
        for (IndexData.ColumnDescriptor col : this.getIndex().getColumns()) {
            Object patValue = rowValues[col.getColumnIndex()];
            if (patValue == IndexData.MIN_VALUE || patValue == IndexData.MAX_VALUE) {
                return true;
            }
            String columnName = col.getName();
            Object rowValue = row.get(columnName);
            if (columnMatcher.matches(this.getTable(), columnName, patValue, rowValue)) continue;
            return false;
        }
        return true;
    }

    private boolean findPotentialRow(Object[] rowValues, boolean requireMatch) throws IOException {
        this._entryCursor.beforeEntry(rowValues);
        IndexData.Entry startEntry = this._entryCursor.getNextEntry();
        if (requireMatch && !startEntry.getRowId().isValid()) {
            return false;
        }
        this.restorePosition(new IndexPosition(startEntry));
        return true;
    }

    @Override
    protected Object prepareSearchInfo(ColumnImpl columnPattern, Object valuePattern) {
        return this._entryCursor.getIndexData().constructPartialIndexRow(IndexData.MIN_VALUE, columnPattern.getName(), valuePattern);
    }

    @Override
    protected Object prepareSearchInfo(Map<String, ?> rowPattern) {
        return this._entryCursor.getIndexData().constructPartialIndexRow(IndexData.MIN_VALUE, rowPattern);
    }

    @Override
    protected boolean keepSearching(ColumnMatcher columnMatcher, Object searchInfo) throws IOException {
        if (searchInfo instanceof Object[]) {
            return this.currentRowMatchesEntryImpl((Object[])searchInfo, columnMatcher);
        }
        return true;
    }

    private Object[] toRowValues(Object[] entryValues) {
        return this._entryCursor.getIndexData().constructPartialIndexRowFromEntry(IndexData.MIN_VALUE, entryValues);
    }

    @Override
    protected CursorImpl.PositionImpl findAnotherPosition(TableImpl.RowState rowState, CursorImpl.PositionImpl curPos, boolean moveForward) throws IOException {
        IndexDirHandler handler = this.getDirHandler(moveForward);
        IndexPosition endPos = (IndexPosition)handler.getEndPosition();
        IndexData.Entry entry = handler.getAnotherEntry();
        return !entry.equals(endPos.getEntry()) ? new IndexPosition(entry) : endPos;
    }

    @Override
    protected ColumnMatcher getDefaultColumnMatcher() {
        if (this.getIndex().isUnique()) {
            return CaseInsensitiveColumnMatcher.INSTANCE;
        }
        return SimpleColumnMatcher.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends CursorImpl.BaseIterator {
        private final Object[] _rowValues;

        private EntryIterator(Collection<String> columnNames, Object[] rowValues, ColumnMatcher columnMatcher) {
            super(IndexCursorImpl.this, columnNames, false, true, columnMatcher);
            this._rowValues = rowValues;
            try {
                this._hasNext = IndexCursorImpl.this.findFirstRowByEntryImpl(rowValues, true, IndexCursorImpl.this._columnMatcher);
                this._validRow = this._hasNext;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        @Override
        protected boolean findNext() throws IOException {
            return IndexCursorImpl.this.moveToNextRow() && IndexCursorImpl.this.currentRowMatchesEntryImpl(this._rowValues, this._colMatcher);
        }
    }

    private static final class IndexPosition
    extends CursorImpl.PositionImpl {
        private final IndexData.Entry _entry;

        private IndexPosition(IndexData.Entry entry) {
            this._entry = entry;
        }

        public RowIdImpl getRowId() {
            return this.getEntry().getRowId();
        }

        public IndexData.Entry getEntry() {
            return this._entry;
        }

        protected boolean equalsImpl(Object o) {
            return this.getEntry().equals(((IndexPosition)o).getEntry());
        }

        public String toString() {
            return "Entry = " + this.getEntry();
        }
    }

    private final class ReverseIndexDirHandler
    extends IndexDirHandler {
        private ReverseIndexDirHandler() {
        }

        public CursorImpl.PositionImpl getBeginningPosition() {
            return IndexCursorImpl.this.getLastPosition();
        }

        public CursorImpl.PositionImpl getEndPosition() {
            return IndexCursorImpl.this.getFirstPosition();
        }

        public IndexData.Entry getAnotherEntry() throws IOException {
            return IndexCursorImpl.this._entryCursor.getPreviousEntry();
        }
    }

    private final class ForwardIndexDirHandler
    extends IndexDirHandler {
        private ForwardIndexDirHandler() {
        }

        public CursorImpl.PositionImpl getBeginningPosition() {
            return IndexCursorImpl.this.getFirstPosition();
        }

        public CursorImpl.PositionImpl getEndPosition() {
            return IndexCursorImpl.this.getLastPosition();
        }

        public IndexData.Entry getAnotherEntry() throws IOException {
            return IndexCursorImpl.this._entryCursor.getNextEntry();
        }
    }

    private abstract class IndexDirHandler
    extends CursorImpl.DirHandler {
        private IndexDirHandler() {
            super(IndexCursorImpl.this);
        }

        public abstract IndexData.Entry getAnotherEntry() throws IOException;
    }
}

