/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import translator.AppPreferences;
import translator.Frequencer;
import translator.MainView;
import translator.Project;
import translator.ResourceView;
import translator.TextResource;
import translator.TranslationUnitMap;
import translator.text.ParagraphStyledDocument;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;
import translator.tmx.TMXView;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class Abbreviations {
    private MainView topui;
    private JTextPane pane;
    private ParagraphStyledDocument document;
    static String path = AppPreferences.packagePath + "resources" + AppPreferences.fs + "abbreviations";
    private static Set abbreviationsSet;
    private static Set newAbbreviationsSet;
    private static String filePath;
    private Pattern pattern;
    private Set scanSet;
    private static boolean isEmpy;

    public Abbreviations(MainView topui) {
        this.topui = topui;
        this.pattern = Pattern.compile("\\s(\\D{1,3}\\. *)+");
        this.scanSet = new HashSet();
        this.setPane();
    }

    public static boolean endsWithAbbreviation(String segment) {
        boolean ends = false;
        if (newAbbreviationsSet != null) {
            for (String abbr : newAbbreviationsSet) {
                int i;
                char c;
                int alen;
                int slen;
                if (!segment.endsWith(abbr) || (slen = segment.length()) <= (alen = abbr.length()) || Character.isLetter(c = segment.charAt(i = slen - alen - 1))) continue;
                ends = true;
                break;
            }
        }
        return ends;
    }

    public static Set getAbbreviationsSet() {
        return abbreviationsSet;
    }

    public static void resetAbbrievations() {
        if (abbreviationsSet != null) {
            abbreviationsSet.clear();
        }
        if (newAbbreviationsSet != null) {
            newAbbreviationsSet.clear();
        }
        filePath = null;
    }

    public static String getAbbreviationsPath() {
        if (filePath != null) {
            return filePath;
        }
        String lang = AppPreferences.fileSLang.replace('-', '_');
        String p = path + AppPreferences.fs + "abbreviations-" + lang + ".txt";
        return p;
    }

    public static void addAbbreviation(String ab) {
        boolean b;
        if (newAbbreviationsSet == null) {
            newAbbreviationsSet = new HashSet();
        }
        if ((b = newAbbreviationsSet.add(ab)) && filePath != null) {
            Abbreviations.saveAbbreviations(ab);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAbbreviations(String lang) {
        String s = path + AppPreferences.fs + "abbreviations-" + lang + ".txt";
        if (filePath != null && filePath.equals(s)) {
            return;
        }
        filePath = s;
        File file = new File(filePath);
        abbreviationsSet = new HashSet();
        if (!file.exists()) {
            boolean b;
            File fdir = new File(path);
            if (!fdir.exists() && (b = fdir.mkdir())) {
                try {
                    file.createNewFile();
                }
                catch (IOException ex) {
                    Logger.getLogger(Abbreviations.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            FileInputStream fis = null;
            try {
                String eline;
                fis = new FileInputStream(file);
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                while ((eline = r.readLine()) != null) {
                    int hash = eline.indexOf(35);
                    if (hash != -1) {
                        if (eline.charAt(0) == '#') continue;
                        eline = eline.substring(0, hash);
                    }
                    if (eline.length() <= 0) continue;
                    abbreviationsSet.add(eline);
                }
                if (!abbreviationsSet.isEmpty()) {
                    isEmpy = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + file.getPath());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public static void saveAbbreviations(String pl) {
        String con;
        if (!isEmpy) {
            con = AppPreferences.ls + pl;
        } else {
            con = pl;
            isEmpy = false;
        }
        try {
            File file = new File(filePath);
            Charset charset = Charset.forName("UTF-8");
            CharsetEncoder encoder = charset.newEncoder();
            FileOutputStream foss = new FileOutputStream(file, true);
            FileChannel fc = foss.getChannel();
            CharBuffer cb = CharBuffer.wrap(con);
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            foss.close();
            fc.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void findProjectAbbreviations() {
        Project project = this.topui.getProjectView().getProject();
        if (project != null) {
            int no = 0;
            XLIFF xliff = project.getXLIFF();
            if (xliff != null) {
                List tunits = xliff.getView().getFilteredUnits();
                if (tunits == null && (tunits = xliff.getView().getGluedUnits()) == null) {
                    XliffFile file = xliff.getCurrentFile();
                    tunits = file.getBody().getTransUnits();
                }
                if (tunits != null) {
                    for (XLIFFUnit tu : tunits) {
                        if (!tu.translate) continue;
                        String segment = tu.getSourceText();
                        this.findAbbrInSegment(segment);
                        ++no;
                    }
                }
            } else {
                TMX tmx = project.getTMX();
                if (tmx != null) {
                    ArrayList tunits = TMXView.getFilteredUnits();
                    if (tunits == null && (tunits = tmx.getView().getGluedUnits()) == null) {
                        Collection col = tmx.getTranslationUnits();
                        if (col instanceof List) {
                            tunits = (List)col;
                        } else {
                            tunits = new ArrayList(col.size());
                            tunits.addAll(col);
                        }
                    }
                    if (tunits != null) {
                        TranslationUnitMap map = tmx.getTUMap();
                        String slang = map.getSourceLang();
                        for (TMXUnit tu : tunits) {
                            TMXUnitVariant tuv = tu.getTUV(slang);
                            if (tuv == null) continue;
                            String segment = tuv.getSegmentText();
                            this.findAbbrInSegment(segment);
                            ++no;
                        }
                    }
                }
            }
            this.showInTextPane();
        }
    }

    private void findAbbrInSegment(String segment) {
        Matcher m = this.pattern.matcher(segment);
        while (m.find()) {
            String group = m.group().trim();
            if (group.length() <= 0 || abbreviationsSet != null && abbreviationsSet.contains(group) || newAbbreviationsSet != null && newAbbreviationsSet.contains(group)) continue;
            this.scanSet.add(group);
        }
    }

    private void showInTextPane() {
        try {
            String toolTip = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SELECTION TO ABBREVIATIONS");
            boolean isMacLF = false;
            if (AppPreferences.laf.equals("Mac OS")) {
                isMacLF = true;
            }
            for (String abb : this.scanSet) {
                JButton buttonAdd = new JButton(abb);
                if (!isMacLF) {
                    buttonAdd.setOpaque(false);
                } else {
                    buttonAdd.setOpaque(true);
                    buttonAdd.setBorder(BorderFactory.createRaisedSoftBevelBorder());
                }
                buttonAdd.setHorizontalTextPosition(2);
                buttonAdd.setActionCommand(abb);
                buttonAdd.setToolTipText(toolTip);
                buttonAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton button = (JButton)e.getSource();
                        button.setEnabled(false);
                        String key = e.getActionCommand();
                        Abbreviations.addAbbreviation(key);
                    }
                });
                buttonAdd.setPreferredSize(new Dimension(160, 28));
                buttonAdd.setMaximumSize(new Dimension(160, 28));
                this.pane.insertComponent(buttonAdd);
                this.document.insertString(this.document.getLength(), " ", null);
                this.pane.setCaretPosition(this.document.getLength());
            }
            this.pane.validate();
            if (this.document.getLength() > 0) {
                this.pane.setCaretPosition(0);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    private void setPane() {
        if (this.pane == null || !this.pane.isVisible()) {
            ResourceView rv = this.topui.getResourceView();
            TextResource res = rv.newTextResource(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ABBREVIATIONS"));
            this.pane = res.getTextPane();
            this.pane.setEditable(false);
            this.document = (ParagraphStyledDocument)this.pane.getDocument();
            this.document.putProperty("path", "");
        } else {
            try {
                this.document.remove(0, this.document.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Frequencer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static {
        isEmpy = true;
    }
}

