/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.CaseInsensitiveString;
import translator.FragmentMatch;
import translator.GlossaryResource;
import translator.MainClass;
import translator.Prompter;
import translator.SegmentPatternString;
import translator.TranslateEvent;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.Workflow;
import translator.WorkflowView;
import translator.XMLHelper;
import translator.mt.MTRefinement;
import translator.tmx.Memory;
import translator.tmx.TMXResult;
import translator.tmx.TMXUnit;
import translator.ui.HTMLFormat;

public final class AssembleParser {
    private String[][] keysArray;
    private String[][] fullkeysArray;
    private static Pattern matchPattern;
    private static String wordSeparatorSource;
    private static String wordSeparatorTarget;
    private int i;
    private Map memoryMap;
    private static Map matchedPatternsMap;
    private static Map superglossaryMap;
    public static Map segmentPatternsMap;
    public static Map termPatternsMap;
    private StringBuffer translatedEntry;
    private StringBuffer translatedEntryFormat;
    private StringBuffer targetSegment;
    private String exactSegmentNoPrefix;
    private StringBuffer targetFormat;
    private boolean running;
    private boolean found;
    private static int matchType;
    private int fragmentPriority;
    private String sourceSegmentTagged;
    private String sourceSegment;
    private String exactSegment;
    private boolean matchFound = false;
    private static boolean prefixMatch;
    private static List localMemories;
    private static List glossaries;
    private Object[] bestFuzzies;
    private Object[][] extraChars;
    private List perfectTUs;
    private int contextProc;
    private float totalproc;
    private float proc;
    private float step;
    private float length;
    private Prompter autocomplete;
    private int tagsNumber;
    private boolean tagsInserted;
    public static String tags;
    public static Pattern patternSegment;
    public static Pattern patternWildcard;
    private TranslateEvent event;

    public AssembleParser(TranslateEvent event) {
        this.event = event;
        this.initParser();
    }

    public static void addToSegmentPatterns(String source, String target, boolean term) {
        int start;
        String g;
        int i;
        String originalSource = source;
        char q = source.charAt(0);
        if (q == '?') {
            source = source.substring(1);
        }
        if ((q = target.charAt(0)) == '?') {
            target = target.substring(1);
        }
        boolean regularExpression = false;
        if (source.length() > 0 && source.charAt(0) == '|') {
            regularExpression = true;
            source = source.substring(1);
        }
        if (!regularExpression && (i = source.indexOf("*")) != -1) {
            regularExpression = true;
            Matcher matcher = patternWildcard.matcher(source);
            StringBuffer sbb = new StringBuffer();
            while (matcher.find()) {
                StringBuilder sr = new StringBuilder();
                String g2 = matcher.group();
                if (g2.length() > 1) {
                    sr.append("\\\\Q");
                    sr.append(g2.substring(0, g2.length() - 1));
                    sr.append("\\\\E");
                }
                sr.append(".+?");
                matcher.appendReplacement(sbb, sr.toString());
            }
            matcher.appendTail(sbb);
            source = sbb.toString();
        }
        boolean match = false;
        boolean defaultSource = false;
        boolean defaultTarget = false;
        Matcher m = patternSegment.matcher(source);
        StringBuffer sourcePattern = new StringBuffer();
        StringBuffer source2 = new StringBuffer();
        StringBuffer target2 = new StringBuffer();
        int end = 0;
        while (m.find()) {
            int e;
            g = m.group();
            start = m.start();
            if (end > 0) {
                String s = source.substring(end, start);
                source2.append(s);
            }
            if ((e = g.indexOf(61)) == -1) {
                e = g.length() - 1;
            } else {
                String s = g.substring(e + 1, g.length() - 1);
                source2.append(s);
                defaultSource = true;
            }
            String d = g.substring(1, e);
            m.appendReplacement(sourcePattern, "{" + d + "}");
            match = true;
            end = m.end();
        }
        m.appendTail(sourcePattern);
        if (end < source.length()) {
            source2.append(source.substring(end));
        }
        end = 0;
        m = patternSegment.matcher(target);
        while (m.find()) {
            String d;
            int e;
            g = m.group();
            start = m.start();
            if (end > 0) {
                String s = target.substring(end, start);
                target2.append(s);
            }
            if ((e = g.indexOf(61)) == -1) {
                e = g.length() - 1;
                d = g.substring(1, e);
            } else {
                String s = g.substring(e + 1, g.length() - 1);
                target2.append(s);
                defaultTarget = true;
                d = g.substring(1, e);
            }
            end = m.end();
        }
        if (end < target.length()) {
            target2.append(target.substring(end));
        }
        if (match) {
            SegmentPatternString sps = new SegmentPatternString(sourcePattern.toString(), target, true, regularExpression);
            sps.setSegmentPattern(originalSource);
            if (!term) {
                segmentPatternsMap.put(sps, sps);
            } else {
                termPatternsMap.put(sps, sps);
            }
            if (defaultSource && defaultTarget) {
                sps.setDefaultSource(source2.toString());
                sps.setDefaultTarget(target2.toString());
            }
        }
    }

    public static void removeTermPattern(String seg) {
        Set set = termPatternsMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SegmentPatternString sps = (SegmentPatternString)iterator.next();
            String segPattern = sps.getSegmentPattern();
            if (segPattern == null || !segPattern.equals(seg)) continue;
            iterator.remove();
        }
    }

    public static void addToSuperGlossary(String key, String value) {
        String nkey = key.replaceAll(AppPreferences.punctuation, "");
        nkey = nkey.trim();
        nkey = nkey.replaceAll("\\s+", " ");
        if (key.equals(value)) {
            value = value.replaceAll(AppPreferences.punctuation, "");
            value = value.trim();
            value = value.replaceAll("\\s+", " ");
        }
        if (prefixMatch) {
            nkey = AssembleParser.makePrefixes(nkey);
        }
        CaseInsensitiveString cisKey = new CaseInsensitiveString(nkey, false);
        superglossaryMap.put(cisKey, value);
    }

    public static void removeFromSuperGlossary(String key) {
        String nkey = key.replaceAll(AppPreferences.punctuation, "");
        nkey = nkey.trim();
        nkey = nkey.replaceAll("\\s+", " ");
        if (prefixMatch) {
            nkey = AssembleParser.makePrefixes(nkey);
        }
        CaseInsensitiveString cisKey = new CaseInsensitiveString(nkey, false);
        superglossaryMap.remove(cisKey);
    }

    public void initParser() {
        this.translatedEntry = new StringBuffer();
        this.translatedEntryFormat = new StringBuffer();
        this.memoryMap = new HashMap();
        prefixMatch = !AppPreferences.noWordSeparatorSourceLanguage && (AppPreferences.memoryPrefixMatch || AppPreferences.glossaryPrefixMatch);
        this.running = false;
        this.found = false;
        this.sourceSegment = null;
        this.matchFound = false;
        this.extraChars = null;
        this.contextProc = 0;
        this.totalproc = 0.0f;
        this.proc = 0.0f;
        this.step = 0.0f;
        this.length = 0.0f;
        this.autocomplete = null;
        this.tagsNumber = 0;
        this.tagsInserted = false;
    }

    public static void setLocalMemories(List mems) {
        localMemories = mems;
    }

    public static void setGlossaries(List gloss) {
        glossaries = gloss;
    }

    public static void setMatchingType(int type) {
        matchType = AppPreferences.noWordSeparatorSourceLanguage ? 2 : (type == 2 ? 0 : type);
        if (matchType == 2) {
            matchPattern = Pattern.compile("", 16);
            wordSeparatorSource = "";
        } else {
            if (AppPreferences.wordDividers.length() > 0) {
                StringBuilder sb = new StringBuilder();
                char[] ch = AppPreferences.wordDividers.toCharArray();
                for (int i = 0; i < ch.length; ++i) {
                    char c = ch[i];
                    if (c == '-' || c == '\\' || c == '[' || c == ']') {
                        sb.append('\\').append(c);
                        continue;
                    }
                    sb.append(c);
                }
                matchPattern = Pattern.compile("[ " + sb.toString() + "]+");
            } else {
                matchPattern = Pattern.compile("[ ]+");
            }
            wordSeparatorSource = " ";
        }
        wordSeparatorTarget = AppPreferences.noWordSeparatorTargetLanguage ? "" : " ";
    }

    public void addFragmentMatch(FragmentMatch fmatch) {
        CaseInsensitiveString cisKey;
        FragmentMatch fmatch2;
        String key = fmatch.getSource();
        int rt = fmatch.getResourceType();
        String nkey = key.replaceAll(AppPreferences.punctuation, "");
        nkey = nkey.trim();
        nkey = nkey.replaceAll("\\s+", " ");
        if (rt == 1 && nkey.indexOf(124) != -1) {
            nkey = nkey.replaceAll("\\|", "");
        }
        if (prefixMatch) {
            nkey = AssembleParser.makePrefixes(nkey);
        }
        if ((fmatch2 = this.memoryMap.put(cisKey = new CaseInsensitiveString(nkey, false), fmatch)) != null) {
            int w2;
            int w = fmatch.getWeight();
            if (w == (w2 = fmatch2.getWeight())) {
                int p2;
                int p = fmatch.getPriority();
                if (p == (p2 = fmatch2.getPriority())) {
                    int a = fmatch.getAltenative();
                    int a2 = fmatch2.getAltenative();
                    if (a2 < a) {
                        this.memoryMap.put(cisKey, fmatch2);
                    }
                } else if (p2 > p) {
                    this.memoryMap.put(cisKey, fmatch2);
                }
            } else if (w2 > w) {
                this.memoryMap.put(cisKey, fmatch2);
            }
        }
    }

    public void setPrefectTUS(List list) {
        this.perfectTUs = list;
    }

    public void setBestFuzzies(Object[] o) {
        this.bestFuzzies = o;
    }

    public void setAutocomplete(Prompter auto) {
        this.autocomplete = auto;
    }

    public String selectExactMatch(String sent) {
        String pm;
        this.sourceSegment = sent;
        sent = XMLHelper.normalizeSpace(sent);
        this.tagsNumber = XMLHelper.countTagGroups(sent);
        String e = null;
        boolean perfectMatch = false;
        this.totalproc = 0.0f;
        this.contextProc = 0;
        block0: for (int j = 0; j < this.perfectTUs.size(); ++j) {
            TMXResult result = (TMXResult)this.perfectTUs.get(j);
            TranslationUnit tu = result.getPerfectTranslationUnit();
            if (!(tu instanceof TMXUnit)) continue;
            TMXUnit tux = (TMXUnit)tu;
            int[] tags = tux.getTags();
            if (tags != null && tags.length == this.tagsNumber) {
                pm = tux.getPerfectMatch();
                if (pm == null) continue;
                e = XMLHelper.reinsertTags(tags, this.sourceSegment, pm);
                if (!result.sourceDifferent) {
                    perfectMatch = true;
                }
                this.contextProc = result.getContextPercent();
                break;
            }
            while (tux.hasLink()) {
                tags = (tux = (TMXUnit)tux.getLink()).getTags();
                if (tags == null || tags.length != this.tagsNumber || (pm = tux.getPerfectMatch()) == null) continue;
                e = XMLHelper.reinsertTags(tags, this.sourceSegment, pm);
                if (result.sourceDifferent) continue block0;
                perfectMatch = true;
                continue block0;
            }
        }
        if (e == null && this.perfectTUs.size() > 0) {
            String ee = null;
            int eeProc = 0;
            for (int j = 0; j < this.perfectTUs.size(); ++j) {
                TMXResult result = (TMXResult)this.perfectTUs.get(j);
                TranslationUnit tu = result.getPerfectTranslationUnit();
                pm = tu.getPerfectMatch();
                int cp = result.getContextPercent();
                if (cp > this.contextProc || e == null) {
                    e = pm;
                    this.contextProc = cp;
                }
                if (this.tagsNumber != 0 || result.sourceDifferent) continue;
                perfectMatch = true;
                if (cp <= eeProc && ee != null) continue;
                ee = pm;
                eeProc = cp;
            }
            if (ee != null) {
                e = ee;
                this.contextProc = eeProc;
            }
        }
        if (e != null) {
            this.totalproc = perfectMatch ? 101.0f : 100.0f;
        }
        return e;
    }

    private void makeSourceElements(String query, String queryTagged) {
        String comp;
        int i;
        String nstring;
        String string;
        String[] str;
        this.sourceSegment = query;
        this.sourceSegmentTagged = queryTagged;
        query = XMLHelper.normalizeSpace(query);
        String[] wordsArray = null;
        String fullSent = matchType != 2 ? query : null;
        this.tagsNumber = queryTagged != null ? XMLHelper.countTagGroups(queryTagged) : XMLHelper.countTagGroups(query);
        query = query.trim();
        this.exactSegmentNoPrefix = query = query.replaceAll("\\s+", " ");
        String sent2 = null;
        if (prefixMatch) {
            String string2;
            sent2 = query;
            str = matchPattern.split(query);
            if (matchType == 2) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i2 = 0; i2 < str.length; ++i2) {
                    string2 = str[i2];
                    if (string2.length() <= 0) continue;
                    list.add(string2);
                }
                str = new String[list.size()];
                int n = 0;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    str[n] = string = it.next().toString();
                    ++n;
                }
            }
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < str.length; ++j) {
                string2 = str[j];
                nstring = string2.replaceAll(AppPreferences.punctuation, "");
                if (nstring.length() > 0) {
                    str[j] = nstring;
                    sb.append(nstring);
                    sb.append(wordSeparatorSource);
                    continue;
                }
                sb.append(string2);
                sb.append(wordSeparatorSource);
            }
            int l = str.length;
            this.fullkeysArray = new String[l][l];
            for (i = 0; i < str.length; ++i) {
                this.fullkeysArray[i][0] = comp = str[i];
                for (int j = i + 1; j < str.length; ++j) {
                    this.fullkeysArray[i][j] = comp = comp + wordSeparatorSource + str[j];
                }
            }
            query = AssembleParser.makePrefixes(sb.toString().trim());
            this.exactSegment = query.replaceAll(AppPreferences.punctuation, "");
        } else {
            this.exactSegment = query.replaceAll(AppPreferences.punctuation, "");
        }
        str = matchPattern.split(query);
        String[] str2 = !prefixMatch ? str : matchPattern.split(sent2);
        if (fullSent != null) {
            wordsArray = new String[str2.length];
            int start = 0;
            for (int j = 0; j < str2.length; ++j) {
                String fullword;
                int tail;
                int end;
                string = str2[j];
                int y = start;
                int len = fullSent.length();
                if (y < len && fullSent.charAt(y) == ' ') {
                    ++y;
                }
                int x = start;
                if (len > y + 1 && fullSent.charAt(y) == '<' && fullSent.charAt(y + 1) == 'x' && (y = fullSent.indexOf(62, y)) != -1 && y + 1 < len) {
                    x = y + 1;
                }
                if ((end = fullSent.indexOf(string, x)) != -1) {
                    tail = end + string.length();
                    if (tail > len) {
                        tail = len;
                    }
                    fullword = fullSent.substring(start, tail);
                } else {
                    fullword = string;
                    tail = start + string.length();
                }
                if (j == str2.length - 1 && fullSent.indexOf(tail) < len) {
                    fullword = fullword + fullSent.substring(tail);
                }
                wordsArray[j] = fullword;
                start = tail;
            }
        }
        if (matchType == 2) {
            ArrayList<String> list = new ArrayList<String>();
            for (i = 0; i < str.length; ++i) {
                string = str[i];
                if (string.length() <= 0) continue;
                list.add(string);
            }
            str = new String[list.size()];
            int n = 0;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String string3;
                str[n] = string3 = it.next().toString();
                ++n;
            }
        }
        if (!prefixMatch) {
            for (int j = 0; j < str.length; ++j) {
                String string4 = str[j];
                nstring = string4.replaceAll(AppPreferences.punctuation, "");
                str[j] = nstring.length() > 0 ? nstring : string4;
            }
        }
        int l = str.length;
        this.keysArray = new String[l][l];
        if (matchType != 2) {
            this.extraChars = new Object[l][l];
        }
        for (int i3 = 0; i3 < str.length; ++i3) {
            String fullcomp;
            this.keysArray[i3][0] = comp = str[i3];
            if (matchType != 2) {
                fullcomp = wordsArray[i3];
                String prefcomp = null;
                if (prefixMatch) {
                    prefcomp = comp;
                    comp = this.fullkeysArray[i3][0];
                }
                if (fullcomp.length() > comp.length()) {
                    String[] echars = new String[3];
                    int h = fullcomp.lastIndexOf(comp);
                    if (h != -1) {
                        if (h > 0) {
                            String ech;
                            echars[0] = ech = fullcomp.substring(0, h);
                        }
                        if (!fullcomp.endsWith(comp)) {
                            String ech;
                            echars[1] = ech = fullcomp.substring(h + comp.length());
                        }
                    } else {
                        char ce;
                        char cs;
                        int k = 0;
                        char space = fullcomp.charAt(k);
                        if (space == ' ') {
                            ++k;
                        }
                        if (fullcomp.length() > k && AppPreferences.punctuationString.indexOf(cs = fullcomp.charAt(k)) != -1 && cs != '<') {
                            echars[0] = Character.toString(cs);
                        }
                        if (fullcomp.length() > ++k && AppPreferences.punctuationString.indexOf(ce = fullcomp.charAt(fullcomp.length() - 1)) != -1 && ce != '>') {
                            char ce2;
                            echars[1] = fullcomp.length() > ++k ? (AppPreferences.punctuationString.indexOf(ce2 = fullcomp.charAt(fullcomp.length() - 2)) != -1 && ce2 != '>' ? Character.toString(ce2) + Character.toString(ce) : Character.toString(ce)) : Character.toString(ce);
                        }
                        echars[2] = fullcomp;
                    }
                    this.extraChars[i3][0] = echars;
                }
                if (prefcomp != null) {
                    comp = prefcomp;
                }
            } else {
                fullcomp = null;
            }
            for (int j = i3 + 1; j < str.length; ++j) {
                this.keysArray[i3][j] = comp = comp + wordSeparatorSource + str[j];
                String prefcomp = null;
                if (prefixMatch) {
                    prefcomp = comp;
                    comp = this.fullkeysArray[i3][j];
                }
                if (fullcomp != null && (fullcomp = fullcomp + wordsArray[j]).length() > comp.length()) {
                    String[] echars = new String[3];
                    int h = fullcomp.lastIndexOf(comp);
                    if (h != -1) {
                        if (h > 0) {
                            String ech;
                            echars[0] = ech = fullcomp.substring(0, h);
                        }
                        if (!fullcomp.endsWith(comp)) {
                            String ech;
                            echars[1] = ech = fullcomp.substring(h + comp.length());
                        }
                    } else {
                        char ce;
                        char cs;
                        int k = 0;
                        char space = fullcomp.charAt(k);
                        if (space == ' ') {
                            ++k;
                        }
                        if (fullcomp.length() > k && AppPreferences.punctuationString.indexOf(cs = fullcomp.charAt(k)) != -1 && cs != '<') {
                            echars[0] = Character.toString(cs);
                        }
                        if (fullcomp.length() > ++k && AppPreferences.punctuationString.indexOf(ce = fullcomp.charAt(fullcomp.length() - 1)) != -1 && ce != '>') {
                            char ce2;
                            echars[1] = fullcomp.length() > ++k ? (AppPreferences.punctuationString.indexOf(ce2 = fullcomp.charAt(fullcomp.length() - 2)) != -1 && ce2 != '>' ? Character.toString(ce2) + Character.toString(ce) : Character.toString(ce)) : Character.toString(ce);
                        }
                        echars[2] = fullcomp;
                    }
                    this.extraChars[i3][j] = echars;
                }
                if (prefcomp == null) continue;
                comp = prefcomp;
            }
        }
    }

    public int getAccuracy() {
        return (int)this.totalproc;
    }

    public int getContextPercent() {
        return this.contextProc;
    }

    public synchronized String[] translate(String query, String queryTagged) {
        char endChar;
        MTRefinement.resetMasking();
        MTRefinement.setParser(this);
        this.makeSourceElements(query, queryTagged);
        if (AppPreferences.fuzzyCorrector) {
            this.correctFuzzyMatches();
        }
        this.targetSegment = new StringBuffer("");
        this.targetFormat = new StringBuffer("");
        this.running = true;
        this.totalproc = 0.0f;
        this.length = this.keysArray.length;
        if (!this.exactMemory()) {
            float npass = -1.0f;
            if (matchType == 0) {
                this.i = 0;
                while (this.i < this.keysArray.length && this.running) {
                    this.fragmentPriority = -1;
                    this.translatedEntry.setLength(0);
                    this.translatedEntryFormat.setLength(0);
                    this.findEntry(this.i, 0);
                    npass += 1.0f;
                    ++this.i;
                }
            } else {
                this.i = 0;
                while (this.i < this.keysArray.length && this.running) {
                    this.fragmentPriority = -1;
                    this.translatedEntry.setLength(0);
                    this.translatedEntryFormat.setLength(0);
                    this.findExactEntry(this.i, 0);
                    npass += 1.0f;
                    ++this.i;
                }
            }
            if (this.totalproc > 0.0f) {
                this.totalproc = this.totalproc * ((this.length - npass) / this.length) * 100.0f;
            }
        }
        String[] r = new String[2];
        String tF = this.targetFormat.toString();
        if (this.targetSegment.length() > 0 && Character.toString(endChar = this.targetSegment.charAt(this.targetSegment.length() - 1)).equals(wordSeparatorSource) && !this.sourceSegment.endsWith(wordSeparatorSource)) {
            this.targetSegment.deleteCharAt(this.targetSegment.length() - 1);
        }
        String tS = this.targetSegment.toString();
        if (AppPreferences.replacePunctAtTransfer) {
            int wl;
            tS = WorkflowView.replacePunctCharacters(wordSeparatorSource + tS + wordSeparatorSource);
            if (tS.startsWith(wordSeparatorSource)) {
                wl = wordSeparatorSource.length();
                tS = tS.substring(wl);
            }
            if (tS.endsWith(wordSeparatorSource)) {
                wl = wordSeparatorSource.length();
                tS = tS.substring(0, tS.length() - wl);
            }
        }
        r[0] = tF;
        r[1] = tS;
        return r;
    }

    public void stop() {
        this.running = false;
    }

    private void findEntry(int sindex, int nindex) {
        this.step = 1.0f;
        if (this.shortTermMemory(sindex, nindex)) {
            this.found = true;
            this.proc = this.step / this.length;
        } else {
            this.found = false;
        }
        this.findNextEntry(sindex);
        if (!this.found) {
            String[] echar = null;
            if (this.extraChars != null) {
                echar = (String[])this.extraChars[sindex][0];
            }
            if (!prefixMatch) {
                this.showNotFoundEntries(this.keysArray[sindex][0], echar);
            } else {
                this.showNotFoundEntries(this.fullkeysArray[sindex][0], echar);
            }
        } else {
            this.totalproc += this.proc;
            this.showFoundEntries();
        }
    }

    private void findNextEntry(int sindex) {
        for (int nindex = sindex + 1; nindex < this.keysArray.length; ++nindex) {
            this.step += 1.0f;
            if (!this.shortTermMemory(sindex, nindex)) continue;
            this.i = nindex;
            this.found = true;
            this.proc = this.step / this.length;
        }
    }

    private void findExactEntry(int sindex, int nindex) {
        this.step = 1.0f;
        if (this.shortTermMemory(sindex, nindex)) {
            this.found = true;
            this.proc = this.step / this.length;
        } else {
            this.found = false;
        }
        this.findNextExactEntry(sindex);
        if (!this.found) {
            String[] echar = null;
            if (this.extraChars != null) {
                echar = (String[])this.extraChars[sindex][0];
            }
            if (!prefixMatch) {
                this.showNotFoundEntries(this.keysArray[sindex][0], echar);
            } else {
                this.showNotFoundEntries(this.fullkeysArray[sindex][0], echar);
            }
        } else {
            this.totalproc += this.proc;
            this.showFoundEntries();
        }
    }

    private void findNextExactEntry(int sindex) {
        for (int nindex = sindex + 1; nindex < this.keysArray.length; ++nindex) {
            this.step += 1.0f;
            if (!this.shortTermMemory(sindex, nindex)) continue;
            this.i = nindex;
            this.found = true;
            this.proc = this.step / this.length;
        }
    }

    private void showNotFoundEntries(String nf, String[] echar) {
        int ind;
        StringBuilder sb = new StringBuilder();
        if (echar != null) {
            String one = echar[0];
            String two = echar[1];
            String three = echar[2];
            if (three != null) {
                sb.append(three);
            } else {
                if (one != null) {
                    sb.append(one);
                }
                sb.append(nf);
                if (two != null) {
                    sb.append(two);
                }
            }
        } else {
            sb.append(nf);
        }
        String notFound = sb.toString();
        if (!AppPreferences.trimInsertion) {
            this.targetSegment.append(notFound);
        }
        if ((ind = notFound.indexOf("<")) != -1) {
            notFound = notFound.replaceAll(tags, "");
        }
        String nff = XMLHelper.resolveXMLEntities2(notFound);
        if (this.matchFound && wordSeparatorSource.length() > 0 && nff.startsWith(wordSeparatorSource)) {
            this.targetFormat.append(wordSeparatorSource);
            String nfff = nff.substring(wordSeparatorSource.length());
            this.targetFormat.append(HTMLFormat.noMatchColorHTML).append(nfff).append("</span>");
        } else if (wordSeparatorSource.length() > 0) {
            this.targetFormat.append(HTMLFormat.noMatchColorHTML).append(nff).append("</span>");
        } else {
            this.targetFormat.append(nff);
        }
        this.matchFound = false;
    }

    private void showFoundEntries() {
        if (this.translatedEntry.length() > 0) {
            this.targetSegment.append(this.translatedEntry);
        }
        if (this.translatedEntryFormat.length() > 0) {
            this.targetFormat.append(this.translatedEntryFormat);
        }
    }

    public boolean tagsInserted() {
        return this.tagsInserted;
    }

    private boolean shortTermMemory(int sindex, int nindex) {
        String key = this.keysArray[sindex][nindex];
        String fullKey = !prefixMatch ? key : this.fullkeysArray[sindex][nindex];
        CaseInsensitiveString cisKey = new CaseInsensitiveString(key, false);
        String e = (String)superglossaryMap.get(cisKey);
        if (e == null) {
            FragmentMatch fr = (FragmentMatch)this.memoryMap.get(cisKey);
            if (fr != null) {
                e = fr.getTarget();
                this.fragmentPriority = fr.getPriority();
            } else {
                String fkey = fullKey.trim();
                String p = this.getSegmentPattern(fkey, true);
                if (p != null && p.length() > 0) {
                    CaseInsensitiveString cisKey2 = new CaseInsensitiveString(key, false);
                    matchedPatternsMap.put(cisKey2, p);
                    key = fkey;
                    e = p;
                    this.fragmentPriority = 2;
                    FragmentMatch fm = new FragmentMatch(key, key, e, "CT", false, 8, 2, 0, 2, 0);
                    this.event.addAssembledFragmentMatch(fm);
                }
            }
        } else {
            String s = fullKey.trim();
            this.fragmentPriority = 2;
            FragmentMatch fm = new FragmentMatch(s, s, e, "CT", false, 9, 2, 0, 2, 0);
            this.event.addAssembledFragmentMatch(fm);
        }
        if (e != null) {
            char firstChar;
            char lastChar;
            if (nindex > 0) {
                this.translatedEntry.setLength(0);
                this.translatedEntryFormat.setLength(0);
            }
            if (e.length() > 0 && Character.isLetterOrDigit(lastChar = key.charAt(key.length() - 1)) && !Character.isLetterOrDigit(lastChar = e.charAt(e.length() - 1)) && Character.getType(lastChar) != 26 && lastChar != '>') {
                e = e.substring(0, e.length() - 1);
            }
            if (e.length() > 0 && Character.isLetterOrDigit(firstChar = key.charAt(0)) && !Character.isLetterOrDigit(firstChar = e.charAt(0)) && Character.getType(firstChar) != 26 && firstChar != '<') {
                e = e.substring(1);
            }
            if (e.length() > 0) {
                String[] echar;
                if (AppPreferences.caseAdaptation) {
                    if (AppPreferences.caseAdaptationSentence) {
                        String f;
                        if (sindex == 0 && !(f = XMLHelper.adaptCase(key, e)).equals(e)) {
                            if (this.autocomplete != null) {
                                this.autocomplete.getAssembledPhrases(f, true);
                            }
                            e = f;
                        }
                    } else {
                        String f = XMLHelper.adaptCase(key, e);
                        if (!f.equals(e)) {
                            if (this.autocomplete != null) {
                                this.autocomplete.getAssembledPhrases(f, true);
                            }
                            e = f;
                        }
                    }
                }
                if (!(!AppPreferences.correctAA || AppPreferences.fragmentAdjustmentMT || AppPreferences.correctAAPriority && this.fragmentPriority != 2)) {
                    MTRefinement.maskFragment(fullKey, e);
                }
                if (this.extraChars != null && (echar = (String[])this.extraChars[sindex][nindex]) != null) {
                    String one = echar[0];
                    String two = echar[1];
                    String three = echar[2];
                    if (one != null) {
                        if (wordSeparatorTarget.length() == 0) {
                            one = one.trim();
                        }
                        if (!e.trim().startsWith(one)) {
                            one = this.isStartPairPuncutationPresent(e, one);
                            e = one + e;
                        }
                    }
                    if (two != null) {
                        if (wordSeparatorTarget.length() == 0) {
                            two = two.trim();
                        }
                        if (!e.trim().endsWith(two)) {
                            two = this.isEndPairPuncutationPresent(e, two);
                            e = e + two;
                        }
                    }
                    if (three != null) {
                        if (wordSeparatorTarget.length() == 0) {
                            three = three.trim();
                        }
                        e = XMLHelper.transferTags(three, e);
                        if (wordSeparatorTarget.length() > 0 && three.startsWith(wordSeparatorTarget)) {
                            this.translatedEntry.append(wordSeparatorTarget);
                            this.translatedEntryFormat.append(wordSeparatorTarget);
                        }
                    }
                }
                if (wordSeparatorSource.length() == 0 && wordSeparatorTarget.length() > 0) {
                    if (this.translatedEntry.length() > 0 && !this.translatedEntry.toString().endsWith(wordSeparatorTarget)) {
                        e = wordSeparatorTarget + e;
                    }
                    e = e + wordSeparatorTarget;
                }
                this.translatedEntry.append(e);
                int ind = e.indexOf("<");
                if (ind != -1) {
                    e = e.replaceAll(tags, "");
                }
                String ee = XMLHelper.resolveXMLEntities2(e);
                if (wordSeparatorTarget.length() > 0 && ee.startsWith(wordSeparatorTarget)) {
                    this.translatedEntryFormat.append(wordSeparatorTarget);
                    String eee = ee.substring(wordSeparatorTarget.length());
                    this.translatedEntryFormat.append(eee);
                } else {
                    this.translatedEntryFormat.append(ee);
                }
            } else {
                this.translatedEntry.append(e);
                this.translatedEntryFormat.append(e);
            }
            this.matchFound = true;
            return true;
        }
        return false;
    }

    private boolean exactMemory() {
        String e = null;
        boolean perfectMatch = false;
        block0: for (int j = 0; j < this.perfectTUs.size(); ++j) {
            String pm;
            TMXResult result = (TMXResult)this.perfectTUs.get(j);
            TranslationUnit tu = result.getPerfectTranslationUnit();
            if (!(tu instanceof TMXUnit)) continue;
            TMXUnit tux = (TMXUnit)tu;
            int[] tags = tux.getTags();
            if (tags != null && tags.length == this.tagsNumber && this.sourceSegmentTagged != null) {
                pm = tux.getPerfectMatch();
                if (pm == null) continue;
                e = XMLHelper.reinsertTags(tags, this.sourceSegmentTagged, pm);
                this.tagsInserted = true;
                if (!result.sourceDifferent) {
                    perfectMatch = true;
                }
                this.contextProc = result.getContextPercent();
                break;
            }
            while (tux.hasLink()) {
                tags = (tux = (TMXUnit)tux.getLink()).getTags();
                if (tags == null || tags.length != this.tagsNumber || this.sourceSegmentTagged == null || (pm = tux.getPerfectMatch()) == null) continue;
                e = XMLHelper.reinsertTags(tags, this.sourceSegmentTagged, pm);
                this.tagsInserted = true;
                if (result.sourceDifferent) continue block0;
                perfectMatch = true;
                continue block0;
            }
        }
        if (e == null && this.perfectTUs.size() > 0) {
            TMXResult result = (TMXResult)this.perfectTUs.get(0);
            TranslationUnit tu = result.getPerfectTranslationUnit();
            e = tu.getPerfectMatch();
            this.contextProc = result.getContextPercent();
            if (this.tagsNumber == 0) {
                this.tagsInserted = true;
                if (!result.sourceDifferent) {
                    perfectMatch = true;
                }
            }
        }
        if (e != null) {
            this.translatedEntry.append(e);
            int ind = e.indexOf("<");
            if (ind != -1) {
                e = e.replaceAll(tags, "");
            }
            String ee = XMLHelper.resolveXMLEntities2(e);
            this.translatedEntryFormat.append(ee);
            this.totalproc = perfectMatch ? 101.0f : 100.0f;
            this.showFoundEntries();
            return true;
        }
        CaseInsensitiveString cisKey = new CaseInsensitiveString(this.exactSegment, false);
        e = (String)superglossaryMap.get(cisKey);
        if (e == null) {
            FragmentMatch fr = (FragmentMatch)this.memoryMap.get(cisKey);
            if (fr != null) {
                e = fr.getTarget();
            }
            if (e == null) {
                e = this.getSegmentPattern(this.sourceSegment, false);
            }
        }
        if (e != null) {
            String f;
            if (AppPreferences.caseAdaptation && !(f = XMLHelper.adaptCase(this.exactSegment, e)).equals(e)) {
                if (this.autocomplete != null) {
                    this.autocomplete.getAssembledPhrases(f, false);
                }
                e = f;
            }
            if (this.extraChars != null) {
                String two;
                String one;
                String[] echar = (String[])this.extraChars[0][0];
                if (echar != null && (one = echar[0]) != null) {
                    if (wordSeparatorTarget.length() == 0) {
                        one = one.trim();
                    }
                    if (!e.trim().startsWith(one)) {
                        one = this.isStartPairPuncutationPresent(e, one);
                        e = one + e;
                    }
                }
                if ((echar = (String[])this.extraChars[this.extraChars.length - 1][0]) != null && (two = echar[1]) != null) {
                    if (wordSeparatorTarget.length() == 0) {
                        two = two.trim();
                    }
                    if (!e.trim().endsWith(two)) {
                        two = this.isEndPairPuncutationPresent(e, two);
                        e = e + two;
                    }
                }
            }
            this.translatedEntry.append(e);
            int ind = e.indexOf("<");
            if (ind != -1) {
                e = e.replaceAll(tags, "");
            }
            String ee = XMLHelper.resolveXMLEntities2(e);
            this.translatedEntryFormat.append(ee);
            this.totalproc = 100.0f;
            this.showFoundEntries();
            return true;
        }
        return false;
    }

    private String getSegmentPattern(String source, boolean term) {
        SegmentPatternString spsKey = new SegmentPatternString(source, null, false, false);
        SegmentPatternString spsOriginal = !term ? (SegmentPatternString)segmentPatternsMap.get(spsKey) : (SegmentPatternString)termPatternsMap.get(spsKey);
        if (spsOriginal != null) {
            String sd = spsOriginal.getDefaultSource();
            if (sd != null && sd.equals(source)) {
                String e = spsOriginal.getDefaultTarget();
                return e;
            }
            Map smap = spsOriginal.getSourceFragmentsMap();
            String target = spsOriginal.getTarget();
            Matcher m = patternSegment.matcher(target);
            StringBuffer sb = new StringBuffer();
            boolean found = false;
            while (m.find()) {
                found = true;
                String defaultTargetTerm = null;
                String g = m.group();
                int ie = g.indexOf(61);
                if (ie == -1) {
                    ie = g.length() - 1;
                } else {
                    defaultTargetTerm = g.substring(ie + 1, g.length() - 1);
                }
                String d = g.substring(1, ie);
                if (smap != null) {
                    String sourceTerm = (String)smap.get(d);
                    if (sourceTerm != null) {
                        CaseInsensitiveString cisSourceTerm;
                        String targetTerm;
                        if (prefixMatch) {
                            sourceTerm = AssembleParser.makePrefixes(sourceTerm);
                        }
                        if ((targetTerm = (String)superglossaryMap.get(cisSourceTerm = new CaseInsensitiveString(sourceTerm, false))) == null) {
                            FragmentMatch fr2 = (FragmentMatch)this.memoryMap.get(cisSourceTerm);
                            if (fr2 != null) {
                                targetTerm = fr2.getTarget();
                            } else {
                                targetTerm = this.getGlossaryMatchForPattern(sourceTerm);
                                if (targetTerm == null) {
                                    Workflow flow = MainClass.getMainView().getWorkflowView().getWorkflowManager().getWorkflow();
                                    targetTerm = flow.hasPlaceableInSegment(sourceTerm) ? sourceTerm : (String)matchedPatternsMap.get(cisSourceTerm);
                                }
                            }
                        }
                        if (targetTerm != null) {
                            m.appendReplacement(sb, targetTerm);
                            continue;
                        }
                        if (defaultTargetTerm != null) {
                            m.appendReplacement(sb, defaultTargetTerm);
                            continue;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
            if (!found) {
                return null;
            }
            m.appendTail(sb);
            String e = sb.toString();
            return e;
        }
        return null;
    }

    private static String makePrefixes(String key) {
        int min = AppPreferences.memPrefixLength;
        int proc = AppPreferences.memPrefixAccuracy;
        StringBuilder sb = new StringBuilder();
        String[] arr = key.split(" ");
        for (int i = 0; i < arr.length; ++i) {
            boolean hasPrefix = false;
            String string = arr[i];
            for (Memory mem : localMemories) {
                int[] parr = mem.getTMX().getTUMap().getPrefixLength(string);
                if (parr == null) continue;
                int pipe = parr[0];
                int pipe2 = parr[1];
                string = pipe2 != -1 ? string.substring(pipe, pipe2) : string.substring(0, pipe);
                hasPrefix = true;
                break;
            }
            if (!hasPrefix) {
                int ai = string.indexOf(39);
                if (ai != -1) {
                    String s = string.substring(ai + 1);
                    int len = s.length();
                    if (len >= min) {
                        if (proc == 0) {
                            string = s.substring(0, min);
                        } else {
                            int newlen = len * proc / 100;
                            if (newlen < min) {
                                newlen = min;
                            }
                            string = s.substring(0, newlen);
                        }
                    }
                } else {
                    int len = string.length();
                    if (len >= min) {
                        if (proc == 0) {
                            string = string.substring(0, min);
                        } else {
                            int newlen = len * proc / 100;
                            if (newlen < min) {
                                newlen = min;
                            }
                            string = string.substring(0, newlen);
                        }
                    }
                }
            }
            sb.append(string);
            if (i >= arr.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getSegmentForMTCorrection() {
        return this.exactSegmentNoPrefix;
    }

    private String getMemoryMatchForFuzzyTarget(String s) {
        String e = null;
        for (Memory mem : localMemories) {
            TranslationUnitMap map = mem.getTMX().getTUMap();
            e = map.getMatch(s);
            if (e != null && e.length() > 0) {
                return e;
            }
            e = map.getVirtualMatch(s);
            if (e == null || e.length() <= 0) continue;
            return e;
        }
        return null;
    }

    private String getGlossaryMatchForFuzzyTarget(String s, String fuzzyTarget) {
        if (glossaries == null) {
            return null;
        }
        for (GlossaryResource gloss : glossaries) {
            List targets = gloss.getMatch(s, false);
            for (int j = 0; j < targets.size(); ++j) {
                String tar = (String)targets.get(j);
                if (tar.length() <= 0 || fuzzyTarget.indexOf(tar) == -1) continue;
                return tar;
            }
        }
        return null;
    }

    private String getGlossaryMatchForPattern(String s) {
        if (glossaries == null) {
            return null;
        }
        for (GlossaryResource gloss : glossaries) {
            List targets = gloss.getMatch(s, true);
            for (int j = 0; j < targets.size(); ++j) {
                String tar = (String)targets.get(j);
                if (tar.length() <= 0) continue;
                return tar;
            }
        }
        return null;
    }

    public synchronized String correctMT(String target) {
        if (!this.memoryMap.isEmpty()) {
            Collection col = this.memoryMap.values();
            for (FragmentMatch fm : col) {
                CaseInsensitiveString cisKey;
                String e;
                String s = fm.getSource();
                String t = fm.getTarget();
                int is = this.exactSegmentNoPrefix.indexOf(s);
                int it = target.indexOf(t);
                if (is == -1 || it == -1 || (e = (String)superglossaryMap.get(cisKey = new CaseInsensitiveString(s, false))) == null || e.equals(t)) continue;
                target = target.replace(t, e);
            }
        }
        return target;
    }

    private void correctFuzzyMatches() {
        if (this.bestFuzzies != null && this.bestFuzzies.length > 0) {
            Workflow flow = MainClass.getMainView().getWorkflowView().getWorkflowManager().getWorkflow();
            HashSet<String> keyWords = new HashSet<String>();
            for (int i = 0; i < this.bestFuzzies.length; ++i) {
                FragmentMatch fr;
                String keyword;
                FragmentMatch fr2;
                String targetWord;
                Object object = this.bestFuzzies[i];
                if (object == null) continue;
                Object[] arr = (Object[])object;
                String fuzzyKey = (String)arr[1];
                String fuzzyEntry = (String)arr[2];
                boolean fuzzyPrefix = (Boolean)arr[4];
                String segment = fuzzyPrefix ? this.exactSegment : this.exactSegmentNoPrefix;
                if (fuzzyKey == null || fuzzyEntry.length() <= 0) continue;
                int[][] matrix = (int[][])arr[3];
                int sint = 0;
                for (int j = 0; j < matrix.length; ++j) {
                    if (matrix[j] == null) continue;
                    int len = matrix[j].length;
                    String s = fuzzyKey.substring(j, j + len);
                    int si = segment.indexOf(s);
                    if (si != -1) {
                        String nf;
                        String keyword2 = segment.substring(0, si).trim();
                        if (keyword2.length() > 0 && (nf = fuzzyKey.substring(sint, j).trim()).length() > 0) {
                            if (flow.hasPlaceableInSegment(keyword2) && flow.hasPlaceableInAll(nf)) {
                                fuzzyEntry = fuzzyEntry.replace(nf, keyword2);
                                arr[2] = fuzzyEntry;
                                arr[13] = true;
                                keyWords.add(keyword2);
                            } else {
                                CaseInsensitiveString cis = new CaseInsensitiveString(keyword2, false);
                                targetWord = (String)superglossaryMap.get(cis);
                                if (targetWord == null && (fr2 = (FragmentMatch)this.memoryMap.get(cis)) != null) {
                                    targetWord = fr2.getTarget();
                                }
                                if (targetWord != null) {
                                    String e = this.getGlossaryMatchForFuzzyTarget(nf, fuzzyEntry);
                                    if (e != null) {
                                        fuzzyEntry = fuzzyEntry.replace(e, targetWord);
                                        arr[2] = fuzzyEntry;
                                        arr[13] = true;
                                        keyWords.add(keyword2);
                                    } else {
                                        e = this.getMemoryMatchForFuzzyTarget(nf);
                                        if (e != null) {
                                            e = prefixMatch ? this.prepareTargetPrefix(e) : Pattern.quote(e);
                                            fuzzyEntry = fuzzyEntry.replaceFirst(e, targetWord);
                                            arr[2] = fuzzyEntry;
                                            arr[13] = true;
                                            keyWords.add(keyword2);
                                        }
                                    }
                                }
                            }
                        }
                        segment = segment.substring(si + s.length());
                    }
                    sint = j + len;
                    if (len <= 0) continue;
                    j += len - 1;
                }
                if (segment.length() > 0 && (keyword = segment.trim()).length() > 0 && sint < fuzzyKey.length()) {
                    String nf = fuzzyKey.substring(sint).trim();
                    if (flow.hasPlaceableInSegment(keyword) && flow.hasPlaceableInAll(nf)) {
                        fuzzyEntry = fuzzyEntry.replace(nf, keyword);
                        arr[2] = fuzzyEntry;
                        arr[13] = true;
                        keyWords.add(keyword);
                    } else {
                        FragmentMatch fr3;
                        CaseInsensitiveString cis = new CaseInsensitiveString(keyword, false);
                        String targetWord2 = (String)superglossaryMap.get(cis);
                        if (targetWord2 == null && (fr3 = (FragmentMatch)this.memoryMap.get(cis)) != null) {
                            targetWord2 = fr3.getTarget();
                        }
                        if (targetWord2 != null) {
                            String e = this.getGlossaryMatchForFuzzyTarget(nf, fuzzyEntry);
                            if (e != null) {
                                fuzzyEntry = fuzzyEntry.replace(e, targetWord2);
                                arr[2] = fuzzyEntry;
                                arr[13] = true;
                                keyWords.add(keyword);
                            } else {
                                e = this.getMemoryMatchForFuzzyTarget(nf);
                                if (e != null) {
                                    e = prefixMatch ? this.prepareTargetPrefix(e) : Pattern.quote(e);
                                    fuzzyEntry = fuzzyEntry.replaceFirst(e, targetWord2);
                                    arr[2] = fuzzyEntry;
                                    arr[13] = true;
                                    keyWords.add(keyword);
                                }
                            }
                        }
                    }
                }
                String currentSegment = (String)arr[6];
                int[][] matrix2 = (int[][])arr[7];
                sint = 0;
                StringBuilder sb = new StringBuilder();
                boolean startIndex = true;
                for (int j = 0; j < matrix2.length; ++j) {
                    if (matrix2[j] == null) continue;
                    int[] pos = matrix2[j];
                    int len = pos.length;
                    if (startIndex) {
                        String m;
                        String nf = currentSegment.substring(sint, j);
                        if (nf.length() > 0) {
                            if (nf.trim().length() == 0) {
                                sb.append(nf);
                            } else {
                                if (nf.charAt(0) == ' ') {
                                    sb.append(' ');
                                    nf = nf.substring(1);
                                }
                                if (nf.charAt(nf.length() - 1) == ' ') {
                                    nf = nf.substring(0, nf.length() - 1);
                                    sb.append(nf);
                                    sb.append(' ');
                                } else {
                                    sb.append(nf);
                                }
                            }
                        }
                        if ((m = currentSegment.substring(j, j + len)).trim().length() > 0) {
                            startIndex = false;
                        } else {
                            sb.append(m);
                        }
                    }
                    sint = j + len;
                    if (len <= 0) continue;
                    j += len - 1;
                }
                String ws = "";
                String firstPhrase = sb.toString();
                if (firstPhrase.endsWith(" ")) {
                    ws = " ";
                }
                if ((firstPhrase = firstPhrase.trim()).length() > 0 && !keyWords.contains(firstPhrase)) {
                    if (flow.hasPlaceableInSegment(firstPhrase) && !fuzzyEntry.startsWith(firstPhrase)) {
                        fuzzyEntry = firstPhrase + ws + fuzzyEntry;
                        arr[2] = fuzzyEntry;
                        arr[13] = true;
                    } else {
                        CaseInsensitiveString cis = new CaseInsensitiveString(firstPhrase, false);
                        targetWord = (String)superglossaryMap.get(cis);
                        if (targetWord == null && (fr2 = (FragmentMatch)this.memoryMap.get(cis)) != null) {
                            targetWord = fr2.getTarget();
                        }
                        if (targetWord != null && !fuzzyEntry.startsWith(targetWord)) {
                            fuzzyEntry = targetWord + ws + fuzzyEntry;
                            arr[2] = fuzzyEntry;
                            arr[13] = true;
                        }
                    }
                }
                if (sint >= currentSegment.length()) continue;
                ws = "";
                String lastPhrase = currentSegment.substring(sint);
                if (lastPhrase.startsWith(" ")) {
                    ws = " ";
                }
                if ((lastPhrase = lastPhrase.trim()).length() <= 0 || keyWords.contains(lastPhrase)) continue;
                if (flow.hasPlaceableInSegment(lastPhrase)) {
                    if (fuzzyEntry.length() <= 0 || fuzzyEntry.contains(lastPhrase)) continue;
                    char c = fuzzyEntry.charAt(fuzzyEntry.length() - 1);
                    if (c == '.' || c == '?' || c == '!') {
                        String f = fuzzyEntry.substring(0, fuzzyEntry.length() - 1);
                        if (f.length() <= 0 || f.endsWith(lastPhrase)) continue;
                        char ch = f.charAt(f.length() - 1);
                        char ch2 = lastPhrase.charAt(lastPhrase.length() - 1);
                        if (Character.isDigit(ch) && Character.isDigit(ch2)) continue;
                        fuzzyEntry = f + ws + lastPhrase + c;
                        arr[2] = fuzzyEntry;
                        arr[13] = true;
                        continue;
                    }
                    char ch = fuzzyEntry.charAt(fuzzyEntry.length() - 1);
                    char ch2 = lastPhrase.charAt(lastPhrase.length() - 1);
                    if (Character.isDigit(ch) && Character.isDigit(ch2)) continue;
                    fuzzyEntry = fuzzyEntry + ws + lastPhrase;
                    arr[2] = fuzzyEntry;
                    arr[13] = true;
                    continue;
                }
                CaseInsensitiveString cis = new CaseInsensitiveString(lastPhrase, false);
                String targetWord3 = (String)superglossaryMap.get(cis);
                if (targetWord3 == null && (fr = (FragmentMatch)this.memoryMap.get(cis)) != null) {
                    targetWord3 = fr.getTarget();
                }
                if (targetWord3 == null || fuzzyEntry.contains(targetWord3)) continue;
                char c = fuzzyEntry.charAt(fuzzyEntry.length() - 1);
                if (c == '.' || c == '?' || c == '!') {
                    String f = fuzzyEntry.substring(0, fuzzyEntry.length() - 1);
                    if (f.endsWith(targetWord3)) continue;
                    fuzzyEntry = f + ws + targetWord3 + c;
                    arr[2] = fuzzyEntry;
                    arr[13] = true;
                    continue;
                }
                fuzzyEntry = fuzzyEntry + ws + targetWord3;
                arr[2] = fuzzyEntry;
                arr[13] = true;
            }
        }
    }

    private String prepareTargetPrefix(String term) {
        int min = AppPreferences.memPrefixLength;
        int proc = AppPreferences.memPrefixAccuracy;
        StringBuilder sb = new StringBuilder();
        Pattern pattern = Pattern.compile("\\s+");
        term = term.trim();
        term = term.replaceAll("\\s+", " ");
        String[] str = pattern.split(term);
        for (int i = 0; i < str.length; ++i) {
            String string = str[i];
            boolean pause = false;
            int newlen = 0;
            int newlen2 = -1;
            int p = string.indexOf(124);
            if (p != -1) {
                newlen = p;
                int p2 = string.indexOf(124, p + 1);
                if (p2 != -1) {
                    newlen2 = p2 - 1;
                }
                string = string.replace("|", "");
            } else if (string.indexOf(42) == -1) {
                int len = string.length();
                if (len >= min) {
                    if (proc == 0) {
                        newlen = min;
                    } else {
                        newlen = len * proc / 100;
                        if (newlen < min) {
                            newlen = min;
                        }
                    }
                }
            } else {
                newlen = string.length();
                pause = true;
            }
            if (newlen == 0) {
                newlen = 1;
            }
            if (string.length() == 0) continue;
            string = newlen2 != -1 ? string.substring(newlen, newlen2) : string.substring(0, newlen);
            if (string.startsWith("*")) {
                sb.append("\\b[^\\s]*");
                string = string.substring(1);
            } else {
                sb.append("\\b");
            }
            string = Pattern.quote(string);
            if (string.indexOf("*") != -1) {
                string = string.replace("*", "\\E[^\\s]*\\Q");
            }
            sb.append(string);
            if (!pause) {
                sb.append("[^\\s]*");
            } else {
                sb.append("\\b");
            }
            if (i >= str.length - 1) continue;
            sb.append("(\\s+)");
        }
        return sb.toString();
    }

    private String isEndPairPuncutationPresent(String match, String extraChars) {
        StringBuilder sb = new StringBuilder();
        char[] arr = extraChars.toCharArray();
        for (int j = 0; j < arr.length; ++j) {
            int k;
            char c = arr[j];
            if ((c == ')' || c == ']' || c == '}') && (k = match.lastIndexOf(c)) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private String isStartPairPuncutationPresent(String match, String extraChars) {
        StringBuilder sb = new StringBuilder();
        char[] arr = extraChars.toCharArray();
        for (int j = 0; j < arr.length; ++j) {
            int k;
            char c = arr[j];
            if ((c == '(' || c == '[' || c == '{') && (k = match.indexOf(c)) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String clearSegmentPattern(String segment) {
        Matcher m = patternSegment.matcher(segment);
        StringBuffer clearedString = new StringBuffer();
        while (m.find()) {
            String g = m.group();
            int e = g.indexOf(61);
            String s = e == -1 ? "" : g.substring(e + 1, g.length() - 1);
            m.appendReplacement(clearedString, s);
        }
        m.appendTail(clearedString);
        if (clearedString.length() > 0 && clearedString.charAt(0) == '?') {
            clearedString.deleteCharAt(0);
        }
        return clearedString.toString();
    }

    public static boolean isSegmentPattern(String segment) {
        Matcher m = patternSegment.matcher(segment);
        return m.find();
    }

    public static void clearMaps() {
        superglossaryMap.clear();
        segmentPatternsMap.clear();
        termPatternsMap.clear();
        matchedPatternsMap.clear();
    }

    static {
        matchedPatternsMap = new ConcurrentHashMap();
        superglossaryMap = new ConcurrentHashMap();
        segmentPatternsMap = new ConcurrentHashMap();
        termPatternsMap = new ConcurrentHashMap();
        prefixMatch = true;
        tags = "(<[/]*x.*?\\d+[^>]*>)+?";
        patternSegment = Pattern.compile("\\{\\d+(=.+?)?\\}");
        patternWildcard = Pattern.compile(".*?\\*");
    }
}

