/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.DefaultResource;
import translator.GlossaryEntryEditor;
import translator.GlossaryResource;
import translator.LanguageCodes;
import translator.MainView;
import translator.MySwingWorker;
import translator.Placeables;
import translator.Project;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.ScrollPaneWatermark;
import translator.TabView;
import translator.TargetView;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLElementEditor;
import translator.XMLHelper;
import translator.database.DBConnection;
import translator.database.Term;
import translator.database.TermBase;
import translator.html.CTHTMLEditorKit;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.ui.Colors;
import translator.ui.HTMLFormat;
import translator.ui.UITools;

public class DictionaryResource
extends DefaultResource {
    public MainView topui;
    public TabView tview;
    private ProgressMonitor pm;
    protected JTextPane textPane;
    protected DefaultStyledDocument doc;
    public ResourceView rview;
    protected String KeyEntrySeparator;
    protected String EntrySeparator;
    protected String TargetDelimiter;
    private String encoding;
    private String uid;
    private String name;
    private String path;
    private String infoPath;
    protected boolean QATermsCheck = AppPreferences.consistencyCheckGlossary;
    protected boolean automaticMatchingStopped;
    protected boolean autoAssemblingStopped;
    protected boolean readOnly = false;
    protected boolean regExOnly = false;
    protected boolean nontranslatablesOnly = false;
    protected boolean caseMatch = false;
    protected boolean hideFields;
    private boolean running;
    protected boolean state = false;
    private Style style;
    private StringBuilder content;
    private StringBuilder newContent = new StringBuilder();
    private StringBuilder newContentBuffer = new StringBuilder();
    protected String[] fields = null;
    protected String[] newFields = null;
    protected HashSet fieldsToHide = null;
    private MySwingWorker worker;
    private File file;
    private int index = -1;
    private boolean toTable = false;
    public int newEntryIndex = 0;
    private int page = 100;
    protected String backupName;
    private boolean setBOM = false;
    private ArrayList header;
    protected Pattern alterntivesPattern;
    protected Pattern fieldsPattern;
    protected int sourceColumnIndex = -1;
    protected int targetColumnIndex = -1;
    protected int searchColumnIndex = -1;
    protected boolean verticalDisplay = AppPreferences.verticalGlossaryDisplay;
    protected Pattern splitPattern;
    private Pattern newLinePattern;
    public static boolean multilingualTermAddition = false;
    int mouseX;
    int mouseY;
    protected ResourceInfo info;
    private boolean termReplaced;

    DictionaryResource(ResourceInfo ri) {
        this.info = ri;
        this.uid = Integer.toString(ResourceView.uniqueResourceID++);
        this.infoPath = ri.getInfoPath();
        this.path = ri.getResourcePath();
        String type = ri.getType();
        this.name = ri.getName();
        this.readOnly = ri.isReadOnly();
        this.caseMatch = ri.isMatchCase();
        this.regExOnly = ri.isRegExOnly();
        this.nontranslatablesOnly = ri.isNontranslatablesOnly();
        this.QATermsCheck = ri.isTermsCheck();
        this.searchColumnIndex = ri.getSearchColumn();
        String url = ri.getConnectionURL();
        if (!(this.infoPath != null || this.name != null && this.name.equals("ProjectTerms") || url != null)) {
            this.toTable = true;
        }
        if (this.name == null && this.infoPath != null) {
            int i = this.infoPath.lastIndexOf(AppPreferences.fs);
            if (i == -1) {
                i = this.infoPath.lastIndexOf(47);
            }
            this.name = i != -1 ? this.infoPath.substring(i + 1, this.infoPath.length() - 4) : "Glossary";
        }
        if (this.path == null) {
            if (type.equals("glossary")) {
                this.path = AppPreferences.packagePath + "resources/glossaries/";
            } else if (type.equals("dictionary")) {
                this.path = AppPreferences.packagePath + "resources/dictionaries/";
            }
        }
        this.EntrySeparator = ri.getEntrySeparator();
        if (this.EntrySeparator.equals("Windows")) {
            this.EntrySeparator = "\r\n";
        } else if (this.EntrySeparator.equals("OS X/Unix") || this.EntrySeparator.equals("Unix") || this.EntrySeparator.equals("Linux")) {
            this.EntrySeparator = "\n";
        } else if (this.EntrySeparator.equals("Mac OS")) {
            this.EntrySeparator = "\r";
        } else if (this.EntrySeparator.indexOf("\\n") != -1) {
            this.EntrySeparator = this.EntrySeparator.replaceAll("\\\\n", "\n");
        } else if (this.EntrySeparator.indexOf("\\r") != -1) {
            this.EntrySeparator = this.EntrySeparator.replaceAll("\\\\r", "\r");
        }
        this.KeyEntrySeparator = "\t";
        this.splitPattern = Pattern.compile("[^\t]*(\t|\\z)");
        this.TargetDelimiter = AppPreferences.alternativesSeparator;
        this.alterntivesPattern = Pattern.compile(this.TargetDelimiter, 16);
        if (this.KeyEntrySeparator.length() > 0) {
            this.fieldsPattern = Pattern.compile(this.KeyEntrySeparator);
        }
        this.newLinePattern = Pattern.compile("\n");
        this.encoding = ri.getEncoding();
        this.fieldsToHide = new HashSet(4);
        if (AppPreferences.fieldsToHideGlossary.length() > 0) {
            Pattern pt = Pattern.compile("\\d+");
            Matcher m = pt.matcher(AppPreferences.fieldsToHideGlossary);
            while (m.find()) {
                String gr = m.group();
                if (gr.length() <= 0) continue;
                int i = Integer.parseInt(gr);
                this.fieldsToHide.add(i);
            }
        }
        if (this.fieldsToHide.size() > 0) {
            this.hideFields = true;
        }
        if (this.path != null) {
            this.readStream(this.path, true);
        }
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        if (!this.toTable) {
            this.tview = topui.getTabView();
            this.rview = topui.getResourceView();
            this.createDictionaryTab();
        }
    }

    public JTextPane getGlossaryPane() {
        return this.textPane;
    }

    private void createDictionaryTab() {
        File file;
        this.textPane = new JTextPane();
        this.textPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.textPane.putClientProperty("type", "memory");
        Graphics g = this.textPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        this.textPane.setEditable(false);
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.textPane.setCaretColor(foreground);
            this.textPane.setBackground(background);
            this.textPane.setForeground(foreground);
            this.textPane.setSelectionColor(selection);
            this.textPane.setSelectedTextColor(foreground);
        }
        this.textPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        this.textPane.addHyperlinkListener(new GlossaryHyperactive(this));
        this.textPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DictionaryResource.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                String sel;
                boolean ctrl = UITools.isShortcutDown(evt);
                if (!ctrl && (sel = DictionaryResource.this.textPane.getSelectedText()) != null && sel.length() < 300) {
                    int cc = evt.getClickCount();
                    if (cc < 2 && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                        try {
                            int spos = Utilities.getWordStart(DictionaryResource.this.textPane, DictionaryResource.this.textPane.getSelectionStart());
                            int epos = Utilities.getWordEnd(DictionaryResource.this.textPane, DictionaryResource.this.textPane.getSelectionEnd() - 1);
                            DictionaryResource.this.textPane.setSelectionStart(spos);
                            DictionaryResource.this.textPane.setSelectionEnd(epos);
                            sel = DictionaryResource.this.textPane.getSelectedText();
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    TargetView pview = DictionaryResource.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
            }
        });
        this.textPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DictionaryResource.this.mouseX = evt.getX();
                DictionaryResource.this.mouseY = evt.getY();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.textPane.setOpaque(false);
            this.textPane.setBackground(new Color(0, 0, 0, 0));
        }
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.textPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.textPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        jScrollPane.setName(this.uid);
        this.tview.addTab(this, this.name, jScrollPane);
    }

    private DefaultStyledDocument createNewStyledDoc() {
        StyleContext styles = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(styles);
        this.style = styles.addStyle("dicPane", null);
        Style underlineStyle = styles.addStyle("underline", null);
        StyleConstants.setUnderline(underlineStyle, true);
        Color selection = new Color(AppPreferences.selection);
        StyleConstants.setBackground(this.style, selection);
        StyleConstants.setForeground(this.style, new Color(AppPreferences.foreground));
        return doc;
    }

    public void joinResource(String path) {
        if (path != null) {
            this.readStream(path, false);
            if (this.content.length() > 0) {
                this.saveDictionary(this.content, true, false);
                this.reload();
            }
        }
    }

    protected void clearNewContent() {
        this.newContent.setLength(0);
        this.newContentBuffer.setLength(0);
        this.newFields = null;
    }

    protected void reload() {
        if (this.path != null) {
            this.readStream(this.path, true);
            this.index = -1;
        }
    }

    protected void readStream(String fpath, boolean main) {
        try {
            this.content = new StringBuilder();
            if (fpath.startsWith("http") || fpath.startsWith("ftp:")) {
                String eline;
                URI uri = new URI(fpath);
                URL url = uri.toURL();
                InputStream is = url.openStream();
                BufferedReader r = new BufferedReader(new InputStreamReader(is, this.encoding));
                int len = 0;
                while ((eline = r.readLine()) != null) {
                    this.content.append(eline);
                    this.content.append("\n");
                    len += eline.length();
                }
                if (this.content.length() > 0) {
                    is.close();
                }
            } else {
                File[] files;
                File file;
                boolean urip = false;
                if (!fpath.startsWith("file:")) {
                    file = new File(fpath);
                } else {
                    URI uri = new URI(fpath);
                    file = new File(uri);
                    urip = true;
                }
                if (!file.isDirectory() && !file.exists()) {
                    file.createNewFile();
                }
                boolean isDir = false;
                if (file.isDirectory()) {
                    files = file.listFiles();
                    isDir = true;
                    if (main) {
                        this.readOnly = true;
                    }
                } else {
                    files = new File[]{file};
                }
                for (int i = 0; i < files.length; ++i) {
                    char bom;
                    File file1 = files[i];
                    String n = file1.getName().toLowerCase();
                    if (file1.isHidden() || file1.isDirectory() || isDir && !n.endsWith(".txt") && !n.endsWith(".csv")) continue;
                    FileInputStream fis = new FileInputStream(file1);
                    FileChannel fc = fis.getChannel();
                    int sz = (int)fc.size();
                    ByteBuffer bb = ByteBuffer.allocateDirect(sz);
                    fc.read(bb);
                    ByteBuffer buffer = bb;
                    ((Buffer)buffer).flip();
                    Charset charset = Charset.isSupported(this.encoding) ? Charset.forName(this.encoding) : Charset.forName("UTF-8");
                    CharsetDecoder decoder = charset.newDecoder();
                    decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
                    decoder.onMalformedInput(CodingErrorAction.REPLACE);
                    CharBuffer cb = decoder.decode(bb);
                    int BOM = this.content.length();
                    this.content.append(cb);
                    fc.close();
                    fis.close();
                    if (!isDir || this.content.length() <= BOM || (bom = this.content.charAt(BOM)) != '\ufeff') continue;
                    this.content.deleteCharAt(BOM);
                }
            }
            if (this.content.length() > 0) {
                char bom = this.content.charAt(0);
                if (bom == '\ufeff') {
                    this.content.deleteCharAt(0);
                }
            } else if (this.encoding.equals("UTF-8")) {
                this.setBOM = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + fpath);
        }
    }

    protected void fillFields() {
        String line;
        this.fields = this.makeFields(this.content, this.EntrySeparator);
        this.content = null;
        if (this.fields != null && this.fields.length > 0 && (line = this.fields[0]).startsWith("#")) {
            int pair = 0;
            this.header = new ArrayList(4);
            Pattern pat = Pattern.compile("[^#]+");
            Matcher m = pat.matcher(line);
            int hindex = 0;
            while (m.find()) {
                String g = m.group().trim();
                if (g.length() <= 0) continue;
                if (g.equalsIgnoreCase(AppPreferences.fileSLang)) {
                    this.sourceColumnIndex = hindex;
                    if (this.searchColumnIndex == -1) {
                        this.searchColumnIndex = hindex;
                    }
                    ++pair;
                } else if (g.equalsIgnoreCase(AppPreferences.fileTLang)) {
                    this.targetColumnIndex = hindex;
                    ++pair;
                }
                this.header.add(g);
                ++hindex;
            }
            if (pair != 2) {
                this.header.clear();
                int si = AppPreferences.fileSLang.indexOf(45);
                int ti = AppPreferences.fileTLang.indexOf(45);
                if (si != -1 && ti != -1) {
                    String slan = AppPreferences.fileSLang.substring(0, si);
                    String tlan = AppPreferences.fileTLang.substring(0, ti);
                    m.reset();
                    hindex = 0;
                    while (m.find()) {
                        String g = m.group().trim();
                        if (g.length() <= 0) continue;
                        String g2 = g;
                        int k = g2.indexOf(45);
                        if (k != -1) {
                            g2 = g2.substring(0, k);
                        }
                        if (g2.equalsIgnoreCase(slan)) {
                            this.sourceColumnIndex = hindex;
                            if (this.searchColumnIndex == -1) {
                                this.searchColumnIndex = hindex;
                            }
                            g = AppPreferences.fileSLang;
                        } else if (g2.equalsIgnoreCase(tlan)) {
                            this.targetColumnIndex = hindex;
                            g = AppPreferences.fileTLang;
                        }
                        this.header.add(g);
                        ++hindex;
                    }
                }
            }
        }
    }

    protected String[] makeFields(CharSequence contents, String entrySeparator) {
        String[] field;
        if (contents != null && contents.length() > 0) {
            char sep = entrySeparator.charAt(0);
            if (sep == '\n' || sep == '\r') {
                entrySeparator = "\r?\n";
            }
            Pattern p = Pattern.compile(entrySeparator);
            field = p.split(contents);
        } else {
            field = null;
        }
        return field;
    }

    @Override
    public void search(final String key, final String rep) {
        JFrame jf = this.topui.getExtendedFrame();
        if (jf != null && jf.getExtendedState() == 1 && this.topui.getTabView().tabExists(this.name)) {
            jf.setExtendedState(0);
        }
        this.worker = new MySwingWorker(this){
            boolean found;
            final /* synthetic */ DictionaryResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.found = this.this$0.find(key, rep);
                return null;
            }

            @Override
            public void finished() {
                if (this.found) {
                    this.this$0.topui.getTabView().selectGlossaryTab(this.this$0);
                }
            }
        };
        this.worker.start();
    }

    private boolean find(String match, String replace) {
        boolean termFound = false;
        this.termReplaced = false;
        this.index = -10;
        this.running = true;
        this.textPane.setText("");
        String trimmedMatch = match.endsWith("=") ? match.substring(0, match.lastIndexOf("=")) : (match.startsWith("=") ? match.substring(match.indexOf("=") + 1) : match);
        try {
            boolean b;
            trimmedMatch = this.topui.getResourceView().prepareSearchString(trimmedMatch);
            Pattern p = AppPreferences.searchCase ? Pattern.compile(trimmedMatch) : Pattern.compile(trimmedMatch, 2);
            if (this.fields == null) {
                this.fillFields();
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(HTMLFormat.startHTML);
            buffer.append(HTMLFormat.glossaryStyles);
            buffer.append(HTMLFormat.startBody);
            buffer.append(HTMLFormat.startTableGlossary);
            if (this.header != null && !this.header.isEmpty() && !this.verticalDisplay) {
                this.makeHorizontalHeaderRow(buffer);
            }
            if (this.fields != null && (b = this.searchFields(this.fields, buffer, false, p, replace))) {
                termFound = b;
            }
            if (this.newFields != null && (b = this.searchFields(this.newFields, buffer, true, p, replace))) {
                termFound = b;
            }
            buffer.append(HTMLFormat.endTable);
            buffer.append(HTMLFormat.endHTML);
            this.showContent(buffer.toString());
            if (this.termReplaced && this instanceof GlossaryResource) {
                GlossaryResource g = (GlossaryResource)this;
                g.reloadMaps();
                this.saveAllContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return termFound;
    }

    private String highlightMatch(String html, Pattern p) {
        StringBuffer sbHTML = new StringBuffer();
        Matcher ma = p.matcher(html);
        while (ma.find()) {
            String m = ma.group();
            String h = HTMLFormat.matchColorHTML + m + "</span>";
            ma.appendReplacement(sbHTML, h);
        }
        ma.appendTail(sbHTML);
        return sbHTML.toString();
    }

    private boolean searchFields(String[] fields, StringBuilder buffer, boolean newFields, Pattern pattern, String replace) throws BadLocationException {
        boolean success = false;
        AbstractMap rowMap = AppPreferences.sortMatches ? new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toLowerCase().compareTo(o2.toLowerCase());
            }
        }) : new LinkedHashMap();
        boolean colorRow = false;
        block0: for (int j = 0; j < fields.length && this.running; ++j) {
            String line = fields[j];
            if (line == null || line.startsWith("#")) continue;
            if (line.indexOf(124) != -1) {
                line = line.replace("|", "");
            }
            Matcher m = this.splitPattern.matcher(line);
            int ind = 0;
            while (m.find()) {
                String s;
                if ((ind == this.searchColumnIndex || this.searchColumnIndex < 0) && (s = m.group().trim()).length() > 0) {
                    Matcher m2 = pattern.matcher(s);
                    if (m2.find()) {
                        int k;
                        int start;
                        String s2;
                        int si;
                        success = true;
                        if (replace != null && (si = line.indexOf(s2 = m2.group(), start = m.start())) != -1) {
                            String begin = line.substring(0, si);
                            String end = line.substring(si + s2.length());
                            fields[j] = line = begin + replace + end;
                            this.termReplaced = true;
                        }
                        if ((line = XMLHelper.resolveHTMLSwingEntities(line)).indexOf(this.TargetDelimiter) != -1) {
                            line = line.replace(this.TargetDelimiter, "<br>");
                        }
                        this.index = j + 1 - 10;
                        StringBuilder row = new StringBuilder();
                        int keyindex = line.indexOf(this.KeyEntrySeparator);
                        if (this.KeyEntrySeparator.length() > 0 && keyindex != -1) {
                            if (newFields) {
                                k = j + 1;
                                k = -k;
                                if (this.verticalDisplay) {
                                    this.makeVerticalRow(null, k, line, null, row, colorRow);
                                } else {
                                    this.makeHorizontalRow(null, k, line, null, row, colorRow);
                                }
                            } else if (this.verticalDisplay) {
                                this.makeVerticalRow(null, j, line, null, row, colorRow);
                            } else {
                                this.makeHorizontalRow(null, j, line, null, row, colorRow);
                            }
                        } else {
                            if (newFields) {
                                k = j + 1;
                                k = -k;
                            } else {
                                k = j;
                            }
                            row.append(HTMLFormat.sRow);
                            if (colorRow) {
                                row.append(HTMLFormat.currentDictionaryLeftCol2);
                            } else {
                                row.append(HTMLFormat.currentDictionaryLeftCol);
                            }
                            row.append("<p>");
                            line = this.highlightMatch(line, pattern);
                            row.append("<a href=#").append(k).append(">").append(line).append("</a>");
                            row.append("</p>");
                            row.append(HTMLFormat.eCol);
                            row.append(HTMLFormat.eRow);
                        }
                        rowMap.put(line, row);
                        colorRow = !colorRow;
                        continue block0;
                    }
                    if (this.searchColumnIndex >= 0) continue block0;
                }
                ++ind;
            }
        }
        if (!rowMap.isEmpty()) {
            for (Map.Entry entry : rowMap.entrySet()) {
                buffer.append(((StringBuilder)entry.getValue()).toString());
            }
        }
        return success;
    }

    public void fromMemory(final Memory memory) {
        MySwingWorker worker = new MySwingWorker(this){
            int count = 0;
            TranslationUnitMap tmap;
            final /* synthetic */ DictionaryResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                TMX tmx = memory.getTMX();
                this.tmap = tmx.getTUMap();
                Collection col = tmx.getTranslationUnits();
                this.tmap.initProgress(0, col.size(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SENDING MEMORY SEGMENTS TO GLOSSARY"));
                ProgressMonitor pbar = this.tmap.getProgresBar();
                String slang = memory.getSourceLangCode();
                String tlang = memory.getTargetLangCode();
                String source = null;
                String target = null;
                for (TranslationUnit tu : col) {
                    source = tu.getSegment(slang);
                    target = tu.getSegment(tlang);
                    if (source.indexOf(9) != -1) {
                        source = source.replace('\t', ' ');
                    }
                    if (target.indexOf(9) != -1) {
                        target = target.replace('\t', ' ');
                    }
                    this.this$0.updateDictionary(source, target, null);
                    ++this.count;
                    if (this.count % 100 == 0) {
                        this.tmap.updateProgress(this.count);
                    }
                    if (!pbar.isCanceled()) continue;
                    break;
                }
                return null;
            }

            @Override
            public void finished() {
                this.tmap.cancelProgress();
                String mpath = this.this$0.path;
                if (!this.this$0.path.endsWith(".txt")) {
                    this.this$0.path = this.this$0.path + ".txt";
                }
                this.this$0.saveDictionary(this.this$0.newContent, true, false);
                this.this$0.path = mpath;
                JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
            }
        };
        worker.start();
    }

    public void toMemory(final Memory memory) {
        this.pm = new ProgressMonitor(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION IN PROGESS..."), "", 0, 100);
        MySwingWorker worker = new MySwingWorker(this){
            final /* synthetic */ DictionaryResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                int ind;
                StringBuilder columns;
                String note;
                int i;
                String line;
                int j;
                int fsize = 0;
                int nfsize = 0;
                if (this.this$0.fields != null) {
                    fsize = this.this$0.fields.length;
                }
                if (this.this$0.newFields != null) {
                    nfsize = this.this$0.newFields.length;
                }
                this.this$0.pm.setMinimum(0);
                this.this$0.pm.setMaximum(fsize + nfsize);
                TMX tmx = memory.getTMX();
                TranslationUnitMap tmap = tmx.getTUMap();
                int count = 0;
                String id = memory.getUserID();
                String source = null;
                String target = null;
                LinkedHashMap attrs = null;
                Project pro = this.this$0.topui.getProjectView().getProject();
                if (pro != null) {
                    attrs = pro.getSegmentAttributes();
                }
                if (fsize > 0) {
                    for (j = 0; j < this.this$0.fields.length; ++j) {
                        line = this.this$0.fields[j];
                        if (line == null || line.startsWith("#")) continue;
                        i = line.indexOf(this.this$0.KeyEntrySeparator);
                        if (this.this$0.KeyEntrySeparator.length() <= 0 || i == -1) continue;
                        note = null;
                        if (this.this$0.sourceColumnIndex != -1 && this.this$0.targetColumnIndex != -1) {
                            columns = new StringBuilder();
                            ind = 0;
                            Matcher m = this.this$0.splitPattern.matcher(line);
                            while (m.find()) {
                                String s = m.group().trim();
                                if (s.length() > 0) {
                                    if (ind == this.this$0.sourceColumnIndex) {
                                        source = s;
                                    } else if (ind == this.this$0.targetColumnIndex) {
                                        target = s;
                                    } else {
                                        if (columns.length() > 0) {
                                            columns.append('\t');
                                        }
                                        columns.append(s);
                                    }
                                }
                                ++ind;
                            }
                            if (columns.length() > 0) {
                                note = columns.toString();
                            }
                        } else {
                            source = line.substring(0, i);
                            target = line.substring(i + this.this$0.KeyEntrySeparator.length());
                            int n = target.indexOf(this.this$0.KeyEntrySeparator);
                            if (n != -1) {
                                String s = target;
                                target = target.substring(0, n);
                                note = s.substring(n + this.this$0.KeyEntrySeparator.length());
                                note = note.replaceAll(this.this$0.KeyEntrySeparator, "\n");
                                if ((note = note.trim()).length() == 0) {
                                    note = null;
                                }
                            }
                        }
                        if (source != null && source.length() > 0 && target != null) {
                            int pipe = source.indexOf(this.this$0.TargetDelimiter);
                            String[] sources = pipe != -1 ? Pattern.compile(this.this$0.TargetDelimiter, 16).split(source) : new String[]{source};
                            pipe = target.indexOf(this.this$0.TargetDelimiter);
                            String[] targets = pipe != -1 ? Pattern.compile(this.this$0.TargetDelimiter, 16).split(target) : new String[]{target};
                            for (int k = 0; k < sources.length; ++k) {
                                char p;
                                String src = sources[k];
                                if (src.length() <= 0 || (p = src.charAt(0)) == '|' || p == '#') continue;
                                for (int m = 0; m < targets.length; ++m) {
                                    String trg = targets[m];
                                    tmap.createTU(id);
                                    tmx.update(src, trg, note, attrs, null, memory.getDuplicatesMode());
                                }
                            }
                        }
                        if (++count % 100 == 0) {
                            this.this$0.updateProgress(count);
                        }
                        if (!this.this$0.pm.isCanceled()) continue;
                        nfsize = 0;
                        break;
                    }
                }
                if (nfsize > 0) {
                    for (j = 0; j < this.this$0.newFields.length; ++j) {
                        line = this.this$0.newFields[j];
                        if (line == null) continue;
                        i = line.indexOf(this.this$0.KeyEntrySeparator);
                        if (this.this$0.KeyEntrySeparator.length() <= 0 || i == -1) continue;
                        note = null;
                        if (this.this$0.sourceColumnIndex != -1 && this.this$0.targetColumnIndex != -1) {
                            columns = new StringBuilder();
                            ind = 0;
                            Matcher m = this.this$0.splitPattern.matcher(line);
                            while (m.find()) {
                                String s = m.group().trim();
                                if (s.length() > 0) {
                                    if (ind == this.this$0.sourceColumnIndex) {
                                        source = s;
                                    } else if (ind == this.this$0.targetColumnIndex) {
                                        target = s;
                                    } else {
                                        if (columns.length() > 0) {
                                            columns.append('\t');
                                        }
                                        columns.append(s);
                                    }
                                }
                                ++ind;
                            }
                            if (columns.length() > 0) {
                                note = columns.toString();
                            }
                        } else {
                            source = line.substring(0, i);
                            target = line.substring(i + this.this$0.KeyEntrySeparator.length());
                            int n = target.indexOf(this.this$0.KeyEntrySeparator);
                            if (n != -1) {
                                String s = target;
                                target = target.substring(0, n);
                                note = s.substring(n + this.this$0.KeyEntrySeparator.length());
                                note = note.replaceAll(this.this$0.KeyEntrySeparator, "\n");
                                if ((note = note.trim()).length() == 0) {
                                    note = null;
                                }
                            }
                        }
                        if (source != null && source.length() > 0 && target != null) {
                            int pipe = target.indexOf(this.this$0.TargetDelimiter);
                            String[] targets = pipe != -1 ? Pattern.compile(this.this$0.TargetDelimiter, 16).split(target) : new String[]{target};
                            for (int k = 0; k < targets.length; ++k) {
                                target = targets[k];
                                tmap.createTU(id);
                                tmx.update(source, target, note, attrs, null, memory.getDuplicatesMode());
                            }
                        }
                        if (++count % 100 == 0) {
                            this.this$0.updateProgress(count);
                        }
                        if (this.this$0.pm.isCanceled()) break;
                    }
                }
                return null;
            }

            @Override
            public void finished() {
                this.this$0.pm.setProgress(this.this$0.pm.getMaximum());
                memory.nextTUS();
                JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
                memory.checkTrialVersionLimit();
            }
        };
        worker.start();
    }

    public void toDatabase(final TermBase base) {
        this.pm = new ProgressMonitor(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION IN PROGESS..."), "", 0, 100);
        MySwingWorker worker = new MySwingWorker(this){
            DBConnection connectionDB;
            final /* synthetic */ DictionaryResource this$0;
            {
                this.this$0 = this$0;
                this.connectionDB = base.getConnection();
            }

            @Override
            public Object construct() {
                try {
                    String ccol;
                    String ncol;
                    String fcol;
                    String idcol;
                    String tcol;
                    String nq = this.connectionDB.getNextRowsQuery();
                    if (nq == null) {
                        this.connectionDB.selectAllRows();
                    } else {
                        this.connectionDB.selectRows(nq);
                    }
                    ResultSet rs = this.connectionDB.getResultSet();
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnCount = meta.getColumnCount();
                    Connection connection = this.connectionDB.getConnection();
                    String[] columnNames = this.connectionDB.getColumnNamesArray();
                    String tableName = this.connectionDB.getTableName();
                    String driver = this.connectionDB.getDriverClassName();
                    int scrollType = rs.getType();
                    Statement stmt = null;
                    if (scrollType == 1003) {
                        stmt = connection.createStatement();
                    } else if (driver != null && driver.equals("org.mariadb.jdbc.Driver")) {
                        stmt = connection.createStatement();
                    }
                    String scol = this.connectionDB.getSourceLang();
                    if (scol.indexOf("-") != -1) {
                        scol = scol.replaceAll("-", "_");
                    }
                    if ((tcol = this.connectionDB.getTargetLang()).indexOf("-") != -1) {
                        tcol = tcol.replaceAll("-", "_");
                    }
                    if ((idcol = this.connectionDB.getClientIDName()).indexOf("-") != -1) {
                        idcol = idcol.replaceAll("-", "_");
                    }
                    if ((fcol = this.connectionDB.getFieldName()).indexOf("-") != -1) {
                        fcol = fcol.replaceAll("-", "_");
                    }
                    if ((ncol = this.connectionDB.getNotesName()).indexOf("-") != -1) {
                        ncol = ncol.replaceAll("-", "_");
                    }
                    if ((ccol = this.connectionDB.getContextName()).indexOf("-") != -1) {
                        ccol = ccol.replaceAll("-", "_");
                    }
                    boolean autoincrement = this.connectionDB.autoIncrementNull;
                    int srcCol = -1;
                    int trgCol = -1;
                    boolean id = false;
                    boolean note = false;
                    boolean field = false;
                    boolean context = false;
                    for (int i = 1; i <= columnCount; ++i) {
                        String name = meta.getColumnName(i);
                        int type = meta.getColumnType(i);
                        if (type != -9 && type != 12) continue;
                        if (name.equalsIgnoreCase(idcol)) {
                            id = true;
                            continue;
                        }
                        if (name.equalsIgnoreCase(fcol)) {
                            field = true;
                            continue;
                        }
                        if (name.equalsIgnoreCase(ccol)) {
                            context = true;
                            continue;
                        }
                        if (name.equalsIgnoreCase(ncol)) {
                            note = true;
                            continue;
                        }
                        if (name.equalsIgnoreCase(scol)) {
                            srcCol = i;
                            continue;
                        }
                        if (!name.equalsIgnoreCase(tcol)) continue;
                        trgCol = i;
                    }
                    if (this.this$0.fields == null) {
                        this.this$0.fillFields();
                    }
                    int fsize = 0;
                    if (this.this$0.fields != null) {
                        fsize = this.this$0.fields.length;
                    }
                    this.this$0.pm.setMinimum(0);
                    this.this$0.pm.setMaximum(fsize);
                    this.this$0.pm.setNote(this.this$0.name);
                    int count = 0;
                    String source = null;
                    String target = null;
                    if (fsize > 0) {
                        for (int j = 0; j < this.this$0.fields.length; ++j) {
                            String line = this.this$0.fields[j];
                            if (line == null || line.startsWith("#")) continue;
                            line = line.replace("'", "''");
                            int i = line.indexOf(this.this$0.KeyEntrySeparator);
                            if (this.this$0.KeyEntrySeparator.length() <= 0 || i == -1) continue;
                            String noteString = null;
                            if (this.this$0.sourceColumnIndex != -1 && this.this$0.targetColumnIndex != -1) {
                                StringBuilder columns = new StringBuilder();
                                int ind = 0;
                                Matcher m = this.this$0.splitPattern.matcher(line);
                                while (m.find()) {
                                    String s = m.group().trim();
                                    if (s.length() > 0) {
                                        if (ind == this.this$0.sourceColumnIndex) {
                                            source = s;
                                        } else if (ind == this.this$0.targetColumnIndex) {
                                            target = s;
                                        } else {
                                            if (columns.length() > 0) {
                                                columns.append('\t');
                                            }
                                            columns.append(s);
                                        }
                                    }
                                    ++ind;
                                }
                                if (columns.length() > 0) {
                                    noteString = columns.toString();
                                }
                            } else {
                                source = line.substring(0, i);
                                target = line.substring(i + this.this$0.KeyEntrySeparator.length());
                                int n = target.indexOf(this.this$0.KeyEntrySeparator);
                                if (n != -1) {
                                    String s = target;
                                    target = target.substring(0, n);
                                    noteString = s.substring(n + this.this$0.KeyEntrySeparator.length());
                                    noteString = noteString.replaceAll(this.this$0.KeyEntrySeparator, "\n");
                                }
                            }
                            if (source != null && source.length() > 0 && target != null) {
                                if (source == null || target == null || source.length() > AppPreferences.columnSize || target.length() > AppPreferences.columnSize) continue;
                                int pipe = target.indexOf(this.this$0.TargetDelimiter);
                                String[] targets = pipe != -1 ? Pattern.compile(this.this$0.TargetDelimiter, 16).split(target) : new String[]{target};
                                for (int k = 0; k < targets.length; ++k) {
                                    target = targets[k];
                                    Term term = this.connectionDB.newTerm();
                                    term.setSource(source);
                                    term.setTarget(target);
                                    if (note && noteString != null) {
                                        term.setNote(noteString);
                                    }
                                    List values = term.getValues();
                                    int[] types = term.getTypes();
                                    int ti = 0;
                                    if (stmt == null) {
                                        rs.moveToInsertRow();
                                        for (Object object : values) {
                                            Date t;
                                            int type = types[ti];
                                            if (type == -9 || type == 12) {
                                                String s = (String)object;
                                                rs.updateString(ti + 1, s);
                                            } else if (type == 4) {
                                                if (!meta.isAutoIncrement(ti + 1)) {
                                                    int ii = (Integer)object;
                                                    rs.updateInt(ti + 1, ii);
                                                } else if (autoincrement) {
                                                    rs.updateObject(ti + 1, null);
                                                }
                                            } else if (type == 91) {
                                                java.sql.Date d = (java.sql.Date)object;
                                                rs.updateDate(ti + 1, d);
                                            } else if (type == 92) {
                                                t = (Time)object;
                                                rs.updateTime(ti + 1, (Time)t);
                                            } else if (type == 93) {
                                                t = (Timestamp)object;
                                                rs.updateTimestamp(ti + 1, (Timestamp)t);
                                            }
                                            ++ti;
                                        }
                                        rs.insertRow();
                                        continue;
                                    }
                                    StringBuilder sqlColumns = new StringBuilder("(");
                                    StringBuilder sqlValues = new StringBuilder("(");
                                    for (Object object : values) {
                                        int type = types[ti];
                                        String columnName = columnNames[ti];
                                        if (type == -9 || type == 12) {
                                            String s = (String)object;
                                            sqlColumns.append(columnName);
                                            sqlColumns.append(",");
                                            sqlValues.append("'");
                                            sqlValues.append(s);
                                            sqlValues.append("', ");
                                        } else if (type != 4) {
                                            Date t;
                                            String s;
                                            if (type == 91) {
                                                java.sql.Date d = (java.sql.Date)object;
                                                s = d.toString();
                                                if (s.length() > 0) {
                                                    sqlColumns.append(columnName);
                                                    sqlColumns.append(",");
                                                    sqlValues.append('\'');
                                                    sqlValues.append(s);
                                                    sqlValues.append('\'');
                                                    sqlValues.append(", ");
                                                }
                                            } else if (type == 92) {
                                                t = (Time)object;
                                                s = ((Time)t).toString();
                                                if (s.length() > 0) {
                                                    sqlColumns.append(columnName);
                                                    sqlColumns.append(",");
                                                    sqlValues.append(s);
                                                    sqlValues.append(", ");
                                                }
                                            } else if (type == 93 && (s = ((Timestamp)(t = (Timestamp)object)).toString()).length() > 0) {
                                                sqlColumns.append(columnName);
                                                sqlColumns.append(",");
                                                sqlValues.append(s);
                                                sqlValues.append(", ");
                                            }
                                        }
                                        ++ti;
                                    }
                                    if (sqlColumns.length() > 1) {
                                        sqlColumns.setLength(sqlColumns.length() - 1);
                                        sqlColumns.append(")");
                                    }
                                    if (sqlValues.length() > 2) {
                                        sqlValues.setLength(sqlValues.length() - 2);
                                        sqlValues.append(")");
                                    }
                                    String sql = "INSERT INTO " + tableName + " " + sqlColumns.toString() + " VALUES " + sqlValues.toString() + ";";
                                    stmt.executeUpdate(sql);
                                }
                            }
                            if (++count % 100 == 0) {
                                this.this$0.updateProgress(count);
                            }
                            if (this.this$0.pm.isCanceled()) break;
                        }
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(DictionaryResource.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            public void finished() {
                if (base.isLoaded()) {
                    try {
                        this.connectionDB.refresh();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(DictionaryResource.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    base.closeResource();
                }
                this.this$0.pm.setProgress(this.this$0.pm.getMaximum());
                JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
            }
        };
        worker.start();
    }

    private void updateProgress(final int count) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ DictionaryResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.pm.setNote(Integer.toString(count));
                this.this$0.pm.setProgress(count);
            }
        });
    }

    @Override
    public void stopSearch() {
        this.running = false;
    }

    protected synchronized boolean saveDictionary(StringBuilder con, boolean append, boolean backup) {
        try {
            if (con == null || con.length() == 0 || this.readOnly) {
                return true;
            }
            if (this.path == null) {
                throw new IOException();
            }
            if (!this.path.startsWith("http:") && !this.path.startsWith("file:")) {
                this.file = new File(this.path);
                if (this.file.isDirectory() && this.name != null) {
                    if (!this.path.endsWith(AppPreferences.fs)) {
                        this.path = this.path + AppPreferences.fs;
                    }
                    String n = this.name;
                    if (this.name.indexOf(46) == -1) {
                        n = this.name + ".txt";
                    }
                    this.path = this.path + n;
                    this.file = new File(this.path);
                }
                if (!append && backup) {
                    File file2 = new File(this.path);
                    String backupPath = this.path + "_" + this.getDateTime();
                    File back = new File(backupPath);
                    boolean success = file2.renameTo(back);
                    this.backupName = success ? back.getName() : null;
                }
            } else {
                URI uri = new URI(this.path);
                this.file = new File(uri);
            }
            if (!append) {
                char bom;
                if (this.encoding.equals("UTF-8") && (bom = con.charAt(0)) != '\ufeff') {
                    con.insert(0, '\ufeff');
                    this.setBOM = false;
                }
            } else if (this.setBOM) {
                con.insert(0, '\ufeff');
                this.setBOM = false;
            }
            Charset charset = Charset.isSupported(this.encoding) ? Charset.forName(this.encoding) : Charset.forName("UTF-8");
            CharsetEncoder encoder = charset.newEncoder();
            FileOutputStream foss = new FileOutputStream(this.file, append);
            FileChannel fc = foss.getChannel();
            CharBuffer cb = CharBuffer.wrap(con);
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            foss.close();
            fc.close();
            this.state = false;
            this.newEntryIndex = 0;
            con.setLength(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING FILE") + " " + this.path);
            return false;
        }
        return true;
    }

    public void showNewEntries() {
        if (this.newFields != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(HTMLFormat.startHTML);
            buffer.append(HTMLFormat.glossaryStyles);
            buffer.append(HTMLFormat.startBody);
            buffer.append(HTMLFormat.startTableGlossary);
            if (this.header != null && !this.header.isEmpty() && !this.verticalDisplay) {
                this.makeHorizontalHeaderRow(buffer);
            }
            boolean colorRow = false;
            for (int j = this.newFields.length - 1; j >= 0; --j) {
                String line = this.newFields[j];
                if (line == null || line.startsWith("#")) continue;
                if ((line = XMLHelper.resolveHTMLSwingEntities(line)).indexOf(this.TargetDelimiter) != -1) {
                    line = line.replace(this.TargetDelimiter, "<br>");
                }
                int keyindex = line.indexOf(this.KeyEntrySeparator);
                if (this.KeyEntrySeparator.length() > 0 && keyindex != -1) {
                    int k = j + 1;
                    k = -k;
                    if (this.verticalDisplay) {
                        this.makeVerticalRow(null, k, line, null, buffer, colorRow);
                    } else {
                        this.makeHorizontalRow(null, k, line, null, buffer, colorRow);
                    }
                } else {
                    buffer.append(HTMLFormat.sRow);
                    if (colorRow) {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol2);
                    } else {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol);
                    }
                    buffer.append("<p>");
                    line = XMLHelper.resolveHTMLSwingEntities(line);
                    buffer.append(line);
                    buffer.append("</p>");
                    buffer.append(HTMLFormat.eCol);
                    buffer.append(HTMLFormat.eRow);
                }
                colorRow = !colorRow;
            }
            buffer.append(HTMLFormat.endTable);
            buffer.append(HTMLFormat.endHTML);
            this.showContent(buffer.toString());
        }
    }

    public void showFromIndex(int ind) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(HTMLFormat.startHTML);
        buffer.append(HTMLFormat.glossaryStyles);
        buffer.append(HTMLFormat.startBody);
        buffer.append(HTMLFormat.startTableGlossary);
        if (this.header != null && !this.header.isEmpty() && !this.verticalDisplay) {
            this.makeHorizontalHeaderRow(buffer);
        }
        int count = 0;
        if (this.fields != null) {
            this.index = ind;
            if (this.index == -1) {
                this.index = 0;
            }
            if (this.index < 0 || this.index >= this.fields.length) {
                this.index = 0;
            }
            boolean colorRow = false;
            for (int j = this.index; j < this.fields.length && count < this.page; ++j) {
                String line = this.fields[j];
                if (line == null || line.startsWith("#")) continue;
                if ((line = XMLHelper.resolveHTMLSwingEntities(line)).indexOf(this.TargetDelimiter) != -1) {
                    line = line.replace(this.TargetDelimiter, "<br>");
                }
                int keyindex = line.indexOf(this.KeyEntrySeparator);
                if (this.KeyEntrySeparator.length() > 0 && keyindex != -1) {
                    if (this.verticalDisplay) {
                        this.makeVerticalRow(null, j, line, null, buffer, colorRow);
                    } else {
                        this.makeHorizontalRow(null, j, line, null, buffer, colorRow);
                    }
                } else {
                    buffer.append(HTMLFormat.sRow);
                    if (colorRow) {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol2);
                    } else {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol);
                    }
                    buffer.append("<p>");
                    line = XMLHelper.resolveHTMLSwingEntities(line);
                    buffer.append(line);
                    buffer.append("</p>");
                    buffer.append(HTMLFormat.eCol);
                    buffer.append(HTMLFormat.eRow);
                }
                colorRow = !colorRow;
                ++count;
            }
            buffer.append(HTMLFormat.endTable);
            buffer.append(HTMLFormat.endHTML);
            this.showContent(buffer.toString());
        }
    }

    public void updateDictionary(String source, String target, Map map) {
        String[] entries;
        String[] keys;
        if (this.nontranslatablesOnly && source.indexOf(10) != -1) {
            keys = this.newLinePattern.split(source.trim());
            entries = null;
        } else if (this.nontranslatablesOnly && target.indexOf(10) != -1) {
            keys = this.newLinePattern.split(target.trim());
            entries = null;
        } else if (source.indexOf(10) != -1 && target.indexOf(10) != -1 && !multilingualTermAddition) {
            keys = this.newLinePattern.split(source.trim());
            entries = this.newLinePattern.split(target.trim());
        } else {
            keys = new String[]{source};
            entries = new String[]{target};
            multilingualTermAddition = false;
        }
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String entry = entries != null && i < entries.length ? entries[i] : "";
            if (key.length() > 0 && key.charAt(0) == '!') {
                Placeables.addPlaceable(key.substring(1));
            } else if (entry.length() > 0 && entry.charAt(0) == '!') {
                key = entry;
                entry = "";
                Placeables.addPlaceable(key.substring(1));
            } else if (this.nontranslatablesOnly) {
                if (key.length() > 0) {
                    Placeables.addPlaceable(key);
                } else if (entry.length() > 0) {
                    key = entry;
                    entry = "";
                    Placeables.addPlaceable(key);
                }
            }
            if (key.length() > 0 && entry.length() > 0 && AssembleParser.isSegmentPattern(key)) {
                if (key.length() > 0 && key.charAt(0) != '?' && key.charAt(0) != '|') {
                    key = "?" + key;
                }
                if (entry.length() > 0 && entry.charAt(0) != '?' && entry.charAt(0) != '|') {
                    entry = "?" + entry;
                }
            }
            if (this.header != null && !this.nontranslatablesOnly) {
                int count = 0;
                for (String next : this.header) {
                    String s;
                    Object o;
                    if (count > 0) {
                        this.newContent.append(this.KeyEntrySeparator);
                        this.newContentBuffer.append(this.KeyEntrySeparator);
                    }
                    if (next.equalsIgnoreCase(AppPreferences.fileSLang)) {
                        this.newContent.append(key);
                        this.newContentBuffer.append(key);
                    } else if (next.equalsIgnoreCase(AppPreferences.fileTLang)) {
                        this.newContent.append(entry);
                        this.newContentBuffer.append(entry);
                    } else if (map != null && !map.isEmpty() && (o = map.get(next)) != null && (s = (String)o).length() > 0) {
                        this.newContent.append(s);
                        this.newContentBuffer.append(s);
                    }
                    ++count;
                }
                this.newContent.append(this.EntrySeparator);
                this.newContentBuffer.append(this.EntrySeparator);
                this.newFields = this.makeFields(this.newContentBuffer, this.EntrySeparator);
                this.state = true;
                ++this.newEntryIndex;
                continue;
            }
            if (key.length() <= 0 && entry.length() <= 0) continue;
            String dicEntry = key.length() == 0 ? entry : (entry.length() == 0 ? key : key + this.KeyEntrySeparator + entry);
            this.newContent.append(dicEntry);
            this.newContentBuffer.append(dicEntry);
            this.newContent.append(this.EntrySeparator);
            this.newContentBuffer.append(this.EntrySeparator);
            this.newFields = this.makeFields(this.newContentBuffer, this.EntrySeparator);
            this.state = true;
            ++this.newEntryIndex;
        }
    }

    public void cloneTerm(String line) {
        this.newContent.append(line);
        this.newContentBuffer.append(line);
        this.newContent.append(this.EntrySeparator);
        this.newContentBuffer.append(this.EntrySeparator);
        this.newFields = this.makeFields(this.newContentBuffer, this.EntrySeparator);
        this.state = true;
        ++this.newEntryIndex;
    }

    @Override
    public void nextResource() {
        int keyindex;
        String line;
        int j;
        boolean colorRow;
        if (this.fields == null) {
            this.fillFields();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(HTMLFormat.startHTML);
        buffer.append(HTMLFormat.glossaryStyles);
        buffer.append(HTMLFormat.startBody);
        buffer.append(HTMLFormat.startTableGlossary);
        if (this.header != null && !this.header.isEmpty() && !this.verticalDisplay) {
            this.makeHorizontalHeaderRow(buffer);
        }
        int count = 0;
        if (this.fields != null) {
            this.index = this.index == -1 ? 0 : (this.index += this.page);
            if (this.index < 0 || this.index >= this.fields.length) {
                this.index = 0;
            }
            colorRow = false;
            for (j = this.index; j < this.fields.length && count < this.page; ++j) {
                line = this.fields[j];
                if (line == null || line.startsWith("#")) continue;
                if ((line = XMLHelper.resolveHTMLSwingEntities(line)).indexOf(this.TargetDelimiter) != -1) {
                    line = line.replace(this.TargetDelimiter, "<br>");
                }
                keyindex = line.indexOf(this.KeyEntrySeparator);
                if (this.KeyEntrySeparator.length() > 0 && keyindex != -1) {
                    if (this.verticalDisplay) {
                        this.makeVerticalRow(null, j, line, null, buffer, colorRow);
                    } else {
                        this.makeHorizontalRow(null, j, line, null, buffer, colorRow);
                    }
                } else {
                    buffer.append(HTMLFormat.sRow);
                    if (colorRow) {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol2);
                    } else {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol);
                    }
                    buffer.append("<p>");
                    line = XMLHelper.resolveHTMLSwingEntities(line);
                    buffer.append("<a href=#").append(j).append(">").append(line).append("</a>");
                    buffer.append("</p>");
                    buffer.append(HTMLFormat.eCol);
                    buffer.append(HTMLFormat.eRow);
                }
                colorRow = !colorRow;
                ++count;
            }
        }
        if (this.newFields != null && this.index < 1) {
            colorRow = false;
            for (j = 0; j < this.newFields.length; ++j) {
                line = this.newFields[j];
                if (line == null || line.startsWith("#")) continue;
                if ((line = XMLHelper.resolveHTMLSwingEntities(line)).indexOf(this.TargetDelimiter) != -1) {
                    line = line.replace(this.TargetDelimiter, "<br>");
                }
                keyindex = line.indexOf(this.KeyEntrySeparator);
                int k = j + 1;
                k = -k;
                if (this.KeyEntrySeparator.length() > 0 && keyindex != -1) {
                    if (this.verticalDisplay) {
                        this.makeVerticalRow(null, k, line, null, buffer, colorRow);
                    } else {
                        this.makeHorizontalRow(null, k, line, null, buffer, colorRow);
                    }
                } else {
                    buffer.append(HTMLFormat.sRow);
                    if (colorRow) {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol2);
                    } else {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol);
                    }
                    buffer.append("<p>");
                    line = XMLHelper.resolveHTMLSwingEntities(line);
                    buffer.append("<a href=#").append(k).append(">").append(line).append("</a>");
                    buffer.append("</p>");
                    buffer.append(HTMLFormat.eCol);
                    buffer.append(HTMLFormat.eRow);
                }
                colorRow = !colorRow;
            }
        }
        buffer.append(HTMLFormat.endTable);
        buffer.append(HTMLFormat.endHTML);
        this.showContent(buffer.toString());
    }

    @Override
    public void previousResource() {
        int keyindex;
        String line;
        int j;
        boolean colorRow;
        if (this.fields == null) {
            this.fillFields();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(HTMLFormat.startHTML);
        buffer.append(HTMLFormat.glossaryStyles);
        buffer.append(HTMLFormat.startBody);
        buffer.append(HTMLFormat.startTableGlossary);
        if (this.header != null && !this.header.isEmpty() && !this.verticalDisplay) {
            this.makeHorizontalHeaderRow(buffer);
        }
        int count = 0;
        if (this.fields != null) {
            this.index -= this.page;
            if (this.index > this.fields.length) {
                this.index = this.fields.length < this.page ? 0 : this.fields.length - this.page;
            } else if (this.index < 0) {
                this.index = 0;
            }
            colorRow = false;
            for (j = this.index; j > -1 && j < this.fields.length && count < this.page; ++j) {
                line = this.fields[j];
                if (line == null || line.startsWith("#")) continue;
                if ((line = XMLHelper.resolveHTMLSwingEntities(line)).indexOf(this.TargetDelimiter) != -1) {
                    line = line.replace(this.TargetDelimiter, "<br>");
                }
                keyindex = line.indexOf(this.KeyEntrySeparator);
                if (this.KeyEntrySeparator.length() > 0 && keyindex != -1) {
                    if (this.verticalDisplay) {
                        this.makeVerticalRow(null, j, line, null, buffer, colorRow);
                    } else {
                        this.makeHorizontalRow(null, j, line, null, buffer, colorRow);
                    }
                } else {
                    buffer.append(HTMLFormat.sRow);
                    if (colorRow) {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol2);
                    } else {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol);
                    }
                    buffer.append("<p>");
                    line = XMLHelper.resolveHTMLSwingEntities(line);
                    buffer.append("<a href=#").append(j).append(">").append(line).append("</a>");
                    buffer.append("</p>");
                    buffer.append(HTMLFormat.eCol);
                    buffer.append(HTMLFormat.eRow);
                }
                colorRow = !colorRow;
                ++count;
            }
        }
        if (this.newFields != null && this.index < 1) {
            colorRow = false;
            for (j = 0; j < this.newFields.length; ++j) {
                line = this.newFields[j];
                if (line == null || line.startsWith("#")) continue;
                if ((line = XMLHelper.resolveHTMLSwingEntities(line)).indexOf(this.TargetDelimiter) != -1) {
                    line = line.replace(this.TargetDelimiter, "<br>");
                }
                keyindex = line.indexOf(this.KeyEntrySeparator);
                int k = j + 1;
                k = -k;
                if (this.KeyEntrySeparator.length() > 0 && keyindex != -1) {
                    if (this.verticalDisplay) {
                        this.makeVerticalRow(null, k, line, null, buffer, colorRow);
                    } else {
                        this.makeHorizontalRow(null, k, line, null, buffer, colorRow);
                    }
                } else {
                    buffer.append(HTMLFormat.sRow);
                    if (colorRow) {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol2);
                    } else {
                        buffer.append(HTMLFormat.currentDictionaryLeftCol);
                    }
                    buffer.append("<p>");
                    line = XMLHelper.resolveHTMLSwingEntities(line);
                    buffer.append("<a href=#").append(k).append(">").append(line).append("</a>");
                    buffer.append("</p>");
                    buffer.append(HTMLFormat.eCol);
                    buffer.append(HTMLFormat.eRow);
                }
                colorRow = !colorRow;
            }
        }
        buffer.append(HTMLFormat.endTable);
        buffer.append(HTMLFormat.endHTML);
        this.showContent(buffer.toString());
    }

    @Override
    public void minusResource() {
        Font font = this.textPane.getFont();
        float size = font.getSize() - 1;
        font = font.deriveFont(size);
        this.textPane.setFont(font);
    }

    @Override
    public void plusResource() {
        Font font = this.textPane.getFont();
        float size = font.getSize() + 1;
        font = font.deriveFont(size);
        this.textPane.setFont(font);
    }

    public void saveAllContent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String line;
                int j;
                StringBuilder sb = new StringBuilder(10000);
                if (DictionaryResource.this.fields != null) {
                    for (j = 0; j < DictionaryResource.this.fields.length; ++j) {
                        line = DictionaryResource.this.fields[j];
                        if (line == null) continue;
                        sb.append(line);
                        sb.append(DictionaryResource.this.EntrySeparator);
                    }
                }
                if (DictionaryResource.this.newFields != null) {
                    if (DictionaryResource.this.newContent != null) {
                        DictionaryResource.this.newContent.setLength(0);
                    }
                    DictionaryResource.this.newContentBuffer.setLength(0);
                    for (j = 0; j < DictionaryResource.this.newFields.length; ++j) {
                        line = DictionaryResource.this.newFields[j];
                        if (line == null) continue;
                        sb.append(line);
                        sb.append(DictionaryResource.this.EntrySeparator);
                        DictionaryResource.this.newContentBuffer.append(line);
                        DictionaryResource.this.newContentBuffer.append(DictionaryResource.this.EntrySeparator);
                    }
                }
                DictionaryResource.this.saveDictionary(sb, false, false);
            }
        });
    }

    @Override
    public void saveResource() {
        if (this.state && !this.isReadOnly()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DictionaryResource.this.saveDictionary(DictionaryResource.this.newContent, true, false);
                }
            });
        }
    }

    public void saveResourceOneThread() {
        if (this.state && !this.isReadOnly()) {
            this.saveDictionary(this.newContent, true, false);
        }
    }

    @Override
    public void saveAsResource() {
        final String dir = AppPreferences.glossaryDir != null && AppPreferences.glossaryDir.length() > 0 ? AppPreferences.glossaryDir : System.getProperty("user.home");
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ DictionaryResource this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        File f;
                        String n = "";
                        if (this.this$0.name != null) {
                            n = this.this$0.name;
                        }
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE GLOSSARY") + " " + n);
                        if (dir != null && (f = new File(dir)).isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if (n != null && n.length() > 0) {
                            fileChooser.setInitialFileName(n);
                        }
                        if ((file = fileChooser.showSaveDialog(null)) != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 12 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    AppPreferences.glossaryDir = file.getParent();
                                    this.this$1.this$0.path = file.getPath();
                                    if (!this.this$1.this$0.path.endsWith(".txt") && !this.this$1.this$0.path.endsWith(".csv")) {
                                        this.this$1.this$0.path = this.this$1.this$0.path + ".txt";
                                    }
                                    TabView tabview = this.this$1.this$0.topui.getTabView();
                                    if (this.this$1.this$0.name != null && tabview.tabExists(this.this$1.this$0.name)) {
                                        tabview.selectTab(this.this$1.this$0.name);
                                        this.this$1.this$0.name = file.getName();
                                        tabview.setCurrentName(this.this$1.this$0.getName());
                                    } else {
                                        this.this$1.this$0.name = file.getName();
                                    }
                                    this.this$1.this$0.infoPath = null;
                                    this.this$1.this$0.saveAllContent();
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 12 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            File f = new File(dir);
            String n = "";
            if (this.name != null) {
                n = this.name;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(n));
            jFileChooser.setCurrentDirectory(f);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE GLOSSARY") + " " + n);
            jFileChooser.repaint();
            if (0 == jFileChooser.showSaveDialog(this.topui)) {
                File newFile = jFileChooser.getSelectedFile();
                AppPreferences.glossaryDir = newFile.getParent();
                this.path = newFile.getPath();
                if (!this.path.endsWith(".txt") && !this.path.endsWith(".csv")) {
                    this.path = this.path + ".txt";
                }
                TabView tabview = this.topui.getTabView();
                if (this.name != null && tabview.tabExists(this.name)) {
                    tabview.selectTab(this.name);
                    this.name = newFile.getName();
                    tabview.setCurrentName(this.getName());
                } else {
                    this.name = newFile.getName();
                }
                this.infoPath = null;
                this.saveAllContent();
            }
        }
    }

    public void updateResourceInfo(String key, String value) {
        if (this.info != null) {
            this.info.setEntry(key, value);
            this.info.saveInfo();
        }
    }

    public boolean isQATermsCheck() {
        return this.QATermsCheck;
    }

    public void setQATermsCheck(boolean check) {
        this.QATermsCheck = check;
        if (check) {
            this.updateResourceInfo("Terms check", "yes");
        } else {
            this.updateResourceInfo("Terms check", "no");
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
        if (ro) {
            this.updateResourceInfo("Read only", "yes");
        } else {
            this.updateResourceInfo("Read only", "no");
        }
    }

    public void setMatchCase(boolean ma) {
        this.caseMatch = ma;
        if (ma) {
            this.updateResourceInfo("Match case", "yes");
        } else {
            this.updateResourceInfo("Match case", "no");
        }
    }

    public boolean isAutomaticMatchingStopped() {
        return this.automaticMatchingStopped;
    }

    private boolean okToAbandon() {
        if (!this.state) {
            return true;
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE CHANGES IN THE GLOSSARY?"), this.name, 1);
        switch (value) {
            case 0: {
                return this.saveDictionary(this.newContent, true, false);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void closeResource() {
        if (this.okToAbandon()) {
            this.running = false;
            if (this.infoPath != null) {
                List loader = this.topui.getResourceLoader().getResourceLoaderList();
                loader.remove(this.infoPath);
                this.topui.getResourceLoader().removeLastSessionResource(this.infoPath);
            }
            if (this instanceof GlossaryResource) {
                GlossaryResource gr = (GlossaryResource)this;
                this.topui.getResourceView().removeGlossary(gr);
                if (this.infoPath != null) {
                    this.topui.getProjectView().removeGlossary(this.infoPath);
                    this.topui.getProjectView().removeReference(this.infoPath);
                }
            } else if (this.infoPath != null) {
                this.topui.getProjectView().removeReference(this.infoPath);
            }
            this.tview.removeTab(this.uid, this.name);
        }
    }

    @Override
    public String getLocation() {
        return this.path;
    }

    @Override
    public String getInfoPath() {
        return this.infoPath;
    }

    public String getResourcePath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    private String getDateTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddhhmmss");
        return df.format(new java.sql.Date(System.currentTimeMillis()));
    }

    public String getKeyEntrySeparator() {
        return this.KeyEntrySeparator;
    }

    protected void setHeader() {
        if (AppPreferences.dbOneCol.length() == 0) {
            AppPreferences.dbOneCol = AppPreferences.fileSLang;
        }
        if (AppPreferences.dbTwoCol.length() == 0) {
            AppPreferences.dbTwoCol = AppPreferences.fileTLang;
        }
        ArrayList<String> langList = new ArrayList<String>(8);
        langList.add(AppPreferences.dbOneCol);
        langList.add(AppPreferences.dbTwoCol);
        langList.add(AppPreferences.dbThreeCol);
        langList.add(AppPreferences.dbFourCol);
        langList.add(AppPreferences.dbFiveCol);
        langList.add(AppPreferences.dbSixCol);
        langList.add(AppPreferences.dbSevenCol);
        langList.add(AppPreferences.dbEightCol);
        if (!langList.contains(AppPreferences.fileTLang)) {
            langList.add(0, AppPreferences.fileTLang);
        }
        if (!langList.contains(AppPreferences.fileSLang)) {
            langList.add(0, AppPreferences.fileSLang);
        }
        this.header = new ArrayList(4);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String next : langList) {
            if (next.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(this.KeyEntrySeparator);
            }
            sb.append("#").append(next);
            this.header.add(next);
            if (next.equalsIgnoreCase(AppPreferences.fileSLang)) {
                this.sourceColumnIndex = i;
                this.searchColumnIndex = i;
            } else if (next.equalsIgnoreCase(AppPreferences.fileTLang)) {
                this.targetColumnIndex = i;
            }
            ++i;
        }
        if (AppPreferences.dbContextCol.length() > 0) {
            this.header.add(AppPreferences.dbContextCol);
            sb.append(this.KeyEntrySeparator);
            sb.append("#");
            sb.append(AppPreferences.dbContextCol);
        }
        if (AppPreferences.dbFieldCol.length() > 0) {
            this.header.add(AppPreferences.dbFieldCol);
            sb.append(this.KeyEntrySeparator);
            sb.append("#");
            sb.append(AppPreferences.dbFieldCol);
        }
        if (AppPreferences.dbClientCol.length() > 0) {
            this.header.add(AppPreferences.dbClientCol);
            sb.append(this.KeyEntrySeparator);
            sb.append("#");
            sb.append(AppPreferences.dbClientCol);
        }
        if (AppPreferences.dbNotesCol.length() > 0) {
            this.header.add(AppPreferences.dbNotesCol);
            sb.append(this.KeyEntrySeparator);
            sb.append("#");
            sb.append(AppPreferences.dbNotesCol);
        }
        if (AppPreferences.dbURLCol.length() > 0) {
            this.header.add(AppPreferences.dbURLCol);
            sb.append(this.KeyEntrySeparator);
            sb.append("#");
            sb.append(AppPreferences.dbURLCol);
        }
        if (AppPreferences.dbUser1Col.length() > 0) {
            this.header.add(AppPreferences.dbUser1Col);
            sb.append(this.KeyEntrySeparator);
            sb.append("#");
            sb.append(AppPreferences.dbUser1Col);
        }
        if (AppPreferences.dbUser2Col.length() > 0) {
            this.header.add(AppPreferences.dbUser2Col);
            sb.append(this.KeyEntrySeparator);
            sb.append("#");
            sb.append(AppPreferences.dbUser2Col);
        }
        if (AppPreferences.dbUser3Col.length() > 0) {
            this.header.add(AppPreferences.dbUser3Col);
            sb.append(this.KeyEntrySeparator);
            sb.append("#");
            sb.append(AppPreferences.dbUser3Col);
        }
        sb.append(this.EntrySeparator);
        this.newContent.append(sb.toString());
        this.newContentBuffer.append(sb.toString());
        this.newFields = this.makeFields(this.newContentBuffer, this.EntrySeparator);
        this.state = true;
        ++this.newEntryIndex;
    }

    public ArrayList getHeader() {
        return this.header;
    }

    public void showContent(String s) {
        try {
            String type = this.textPane.getContentType();
            if (!type.equals("text/html")) {
                this.textPane.setContentType("text/html");
            }
            this.textPane.setCaretPosition(0);
            HTMLDocument htmldoc = (HTMLDocument)this.textPane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), s);
            JViewport vp = (JViewport)this.textPane.getParent();
            final JScrollPane scroll = (JScrollPane)vp.getParent();
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ DictionaryResource this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    scroll.getVerticalScrollBar().setValue(0);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getFields(boolean newF) {
        if (newF) {
            return this.newFields;
        }
        return this.fields;
    }

    void makeVerticalRow(String term, int j, String line, String[] fields, StringBuilder sb, boolean evenRow) {
        StringBuilder sc = new StringBuilder();
        if (AppPreferences.sortMatches) {
            sc.append(HTMLFormat.defaultRowLeftAlign2);
        } else if (!evenRow) {
            sc.append(HTMLFormat.glossaryRowLeftAlign);
        } else {
            sc.append(HTMLFormat.glossaryRowLeftAlign2);
        }
        StringBuilder tc = new StringBuilder();
        if (AppPreferences.sortMatches) {
            tc.append(HTMLFormat.defaultRowLeftAlign2);
        } else if (!evenRow) {
            tc.append(HTMLFormat.glossaryRowLeftAlign);
        } else {
            tc.append(HTMLFormat.glossaryRowLeftAlign2);
        }
        int firstTarget = tc.length();
        int columnsNo = 0;
        if (this.header != null) {
            columnsNo = this.header.size();
        }
        int sIndex = 0;
        int tIndex = 1;
        if (this.sourceColumnIndex != -1) {
            sIndex = this.sourceColumnIndex;
        }
        if (this.targetColumnIndex != -1) {
            tIndex = this.targetColumnIndex;
        }
        Matcher matcher = this.splitPattern.matcher(line);
        int i = 0;
        int k = 0;
        boolean found = false;
        while (matcher.find()) {
            String s = matcher.group();
            if (s.length() <= 0) continue;
            if (this.hideFields && this.fieldsToHide.contains(i + 1)) {
                ++i;
                continue;
            }
            StringBuilder col = new StringBuilder();
            if ((s = s.trim()).length() > 0) {
                found = true;
                col.append("<p>");
                if (i == sIndex) {
                    String t = term != null ? term : s;
                    col.append("<a href=#").append(j).append(">").append(t).append("</a>");
                } else if (s.startsWith("www") || s.startsWith("http") || s.startsWith("file:") || s.startsWith("/") || s.indexOf(":\\") != -1) {
                    col.append("<a href=\"").append(s).append("\">").append(s).append("</a>");
                } else if (i == tIndex) {
                    col.append("<b>" + s + "</b>");
                } else {
                    col.append(s);
                }
                col.append("</p>");
                if (i == sIndex) {
                    sc.append((CharSequence)col);
                } else if (i == tIndex) {
                    tc.insert(firstTarget, col);
                } else {
                    tc.append((CharSequence)col);
                    if (fields != null && k < 8) {
                        fields[k] = s;
                        ++k;
                    }
                }
            }
            ++i;
        }
        if (found) {
            sb.append("<tr>");
            sb.append((CharSequence)sc).append("</td>");
            sb.append((CharSequence)tc).append("</td>");
            sb.append("</tr>");
        }
    }

    void makeHorizontalRow(String term, int j, String line, String[] fields, StringBuilder sb, boolean evenRow) {
        StringBuilder sc = new StringBuilder();
        StringBuilder tc = new StringBuilder();
        StringBuilder fc = new StringBuilder();
        int sIndex = 0;
        int tIndex = 1;
        if (this.sourceColumnIndex != -1) {
            sIndex = this.sourceColumnIndex;
        }
        if (this.targetColumnIndex != -1) {
            tIndex = this.targetColumnIndex;
        }
        Matcher matcher = this.splitPattern.matcher(line);
        int i = 0;
        int k = 0;
        boolean found = false;
        while (matcher.find()) {
            String s = matcher.group();
            if (s.length() <= 0) continue;
            if (this.hideFields && this.fieldsToHide.contains(i + 1)) {
                ++i;
                continue;
            }
            found = true;
            StringBuilder col = new StringBuilder();
            s = s.trim();
            if (AppPreferences.sortMatches) {
                col.append(HTMLFormat.defaultRowLeftAlign2);
            } else if (!evenRow) {
                col.append(HTMLFormat.glossaryRowLeftAlign);
            } else {
                col.append(HTMLFormat.glossaryRowLeftAlign2);
            }
            col.append("<p>");
            if (i == sIndex) {
                String t = term != null ? term : s;
                col.append("<a href=#").append(j).append(">").append(t).append("</a>");
            } else if (s.startsWith("www") || s.startsWith("http") || s.startsWith("file:") || s.startsWith("/") || s.indexOf(":\\") != -1) {
                col.append("<a href=\"").append(s).append("\">").append(s).append("</a>");
            } else {
                col.append(s);
            }
            col.append("</p>");
            col.append("</td>");
            if (i == sIndex) {
                sc.append((CharSequence)col);
            } else if (i == tIndex) {
                tc.append((CharSequence)col);
            } else {
                fc.append((CharSequence)col);
                if (fields != null && k < 8) {
                    fields[k] = s;
                    ++k;
                }
            }
            ++i;
        }
        if (found) {
            sb.append("<tr>");
            sb.append((CharSequence)sc);
            sb.append((CharSequence)tc);
            sb.append((CharSequence)fc);
            if (this.header != null) {
                while (i < this.header.size()) {
                    if (this.hideFields && this.fieldsToHide.contains(i + 1)) {
                        ++i;
                        continue;
                    }
                    if (!evenRow) {
                        sb.append(HTMLFormat.glossaryRowLeftAlign);
                    } else {
                        sb.append(HTMLFormat.glossaryRowLeftAlign2);
                    }
                    sb.append("</td>");
                    ++i;
                }
            }
            sb.append("</tr>");
        }
    }

    void makeHorizontalHeaderRow(StringBuilder sb) {
        int sIndex = 0;
        int tIndex = 1;
        if (this.sourceColumnIndex != -1) {
            sIndex = this.sourceColumnIndex;
        }
        if (this.targetColumnIndex != -1) {
            tIndex = this.targetColumnIndex;
        }
        int count = 0;
        sb.append("<tr>");
        int k = sb.length();
        StringBuilder sc = new StringBuilder();
        StringBuilder tc = new StringBuilder();
        Iterator iterator = this.header.iterator();
        while (iterator.hasNext()) {
            if (this.hideFields && this.fieldsToHide.contains(count + 1)) {
                iterator.next();
                ++count;
                continue;
            }
            Object next = iterator.next();
            if (sIndex == count) {
                sc.append("<TD COLOR=white BGCOLOR=").append(Colors.colorGlossaryHTML).append(" style='border-width: 0px; border-style: solid; border-color: ").append("#DDDDDD").append("' NOWRAP VALIGN=CENTER ALIGN=center>");
            } else if (tIndex == count) {
                tc.append("<TD COLOR=white BGCOLOR=").append(Colors.colorGlossaryHTML).append(" style='border-width: 0px; border-style: solid; border-color: ").append("#DDDDDD").append("' NOWRAP VALIGN=CENTER ALIGN=center>");
            } else {
                sb.append("<TD COLOR=white BGCOLOR=").append("#2E2E2E").append(" style='border-width: 0px; border-style: solid; border-color: ").append("#DDDDDD").append("' NOWRAP VALIGN=CENTER ALIGN=center>");
            }
            String s = next.toString();
            String n = LanguageCodes.getName(s);
            if (n == null) {
                n = s;
            } else {
                int i = n.indexOf(40);
                if (i != -1) {
                    n = n.substring(0, i);
                }
            }
            if (sIndex == count) {
                sc.append(n);
                sc.append("</td>");
            } else if (tIndex == count) {
                tc.append(n);
                tc.append("</td>");
            } else {
                sb.append(n);
                sb.append("</td>");
            }
            ++count;
        }
        if (tc.length() > 0) {
            sc.append((CharSequence)tc);
        }
        if (sc.length() > 0) {
            sb.insert(k, sc);
        }
        sb.append("</tr>");
    }

    public String breakSynonyms(String s) {
        if (this.TargetDelimiter.length() == 1) {
            char del = this.TargetDelimiter.charAt(0);
            char[] ch = s.toCharArray();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < ch.length; ++i) {
                char c = ch[i];
                if (c == del) {
                    int len = sb.length();
                    if (len > 4 && sb.charAt(len - 4) == '&') {
                        sb.append(c);
                        continue;
                    }
                    sb.append("<br>");
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return s;
    }

    public void editEntry(DictionaryResource dictionary, String s) {
        String fs;
        boolean isNewTerm;
        String[] entries;
        int index;
        int i;
        String ss = s.substring(1);
        if (ss.startsWith("-")) {
            ss = ss.substring(1);
            i = Integer.parseInt(ss);
            index = i - 1;
            entries = this.newFields;
            isNewTerm = true;
        } else {
            index = i = Integer.parseInt(ss);
            entries = this.fields;
            isNewTerm = false;
        }
        if (entries != null && entries.length > index && (fs = entries[index]) != null) {
            GlossaryEntryEditor dlg = new GlossaryEntryEditor(this.topui, dictionary, entries, fs, index, isNewTerm);
            dlg.setResizable(true);
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.topui.getSize();
            Point loc = this.topui.getLocationOnScreen();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            if (AppPreferences.glossaryDialogWidth > 100) {
                dlg.setPreferredSize(new Dimension(AppPreferences.glossaryDialogWidth, dlg.getHeight()));
            }
            dlg.pack();
            dlg.setVisible(true);
        }
    }

    class GlossaryHyperactive
    implements HyperlinkListener {
        private DictionaryResource dictionary;
        private Thread th;
        private boolean act = true;

        GlossaryHyperactive(DictionaryResource dictionary) {
            this.dictionary = dictionary;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                if (this.th != null) {
                    this.act = false;
                    if (this.th.isAlive()) {
                        this.th.interrupt();
                    }
                    this.th = null;
                }
                DictionaryResource.this.topui.getResourceView().getGlossaryTip().hideInfo();
            } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                if (this.th == null && DictionaryResource.this.fieldsToHide.size() > 0 && DictionaryResource.this.hideFields) {
                    this.act = true;
                    final String s = e.getDescription();
                    final Component comp = (Component)e.getSource();
                    this.th = new Thread(this){
                        final /* synthetic */ GlossaryHyperactive this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            try {
                                Thread.currentThread();
                                Thread.sleep(750L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                @Override
                                public void run() {
                                    if (this.this$2.this$1.act && s != null && s.startsWith("#")) {
                                        this.this$2.this$1.DictionaryResource.this.topui.getResourceView().getGlossaryTip().showInfo(this.this$2.this$1.dictionary, s, comp, this.this$2.this$1.DictionaryResource.this.mouseX + 20, this.this$2.this$1.DictionaryResource.this.mouseY + 20);
                                    }
                                }
                            });
                        }
                    };
                    this.th.setPriority(1);
                    this.th.start();
                }
            } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.act = false;
                DictionaryResource.this.topui.getResourceView().getGlossaryTip().hideInfo();
                String s = e.getDescription();
                if (s != null && s.startsWith("#") && !DictionaryResource.this.isReadOnly()) {
                    DictionaryResource.this.editEntry(this.dictionary, s);
                } else if (s.startsWith("file")) {
                    try {
                        File file = new File(new URI(s));
                        if (file.exists()) {
                            DictionaryResource.this.topui.getResourceView().viewFile(file);
                        }
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (s.startsWith("http")) {
                    try {
                        URI uri = new URI(s);
                        DictionaryResource.this.topui.getResourceView();
                        ResourceView.browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (s.startsWith("www")) {
                    s = "http://" + s;
                    try {
                        URI uri = new URI(s);
                        DictionaryResource.this.topui.getResourceView();
                        ResourceView.browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (s.startsWith("/") || s.indexOf(":\\") != -1) {
                    File file = new File(s);
                    if (file.exists()) {
                        DictionaryResource.this.topui.getResourceView().viewFile(file);
                    }
                } else if (s.equals("next")) {
                    DictionaryResource.this.nextResource();
                } else {
                    DictionaryResource.this.topui.getMemoryView().insertMatch(s);
                    DictionaryResource.this.topui.getTargetPane().requestFocusInWindow();
                }
            }
        }
    }
}

