/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import translator.AppPreferences;
import translator.FileFilters;
import translator.FormatChooser;
import translator.MainView;
import translator.Resource;
import translator.translatables.AutoCadDocument;
import translator.translatables.FramemakerMIFDocument;
import translator.translatables.GZipDocument;
import translator.translatables.ITTSubtitles;
import translator.translatables.IndesignIDMLDocument;
import translator.translatables.IndesignINXDocument;
import translator.translatables.MSExcelDocument;
import translator.translatables.MSOfficeDocument;
import translator.translatables.MSOfficePPDocument;
import translator.translatables.MSOfficeXMLDocument;
import translator.translatables.OpenOfficeDocument;
import translator.translatables.ResXFile;
import translator.translatables.SRTSubtitles;
import translator.translatables.SVGDocument;
import translator.translatables.TaggedTextDocument;
import translator.translatables.TextDocument;
import translator.translatables.TransitXMLFile;
import translator.translatables.ZipDocument;

public class DocumentChooser {
    private String[] zipExtentions = new String[]{".kwd", ".pages", ".key", ".numbers"};
    private String[] ooExtentions = new String[]{".odt", ".ods", ".odp", ".odg", ".sxw"};
    private String[] msExtentions = new String[]{".docx", ".xlsx", ".pptx", ".docm", ".xlsm"};
    private MainView topui;
    private File file;

    public DocumentChooser(MainView topui) {
        this.topui = topui;
    }

    public void fileOpen() {
        FileFilters filters = new FileFilters();
        String filterName = AppPreferences.format;
        JFileChooser jFileChooser = new JFileChooser();
        filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN DOCUMENT"));
        jFileChooser.setSelectedFile(new File(""));
        jFileChooser.setCurrentDirectory(new File(AppPreferences.fileDirectory));
        jFileChooser.repaint();
        if (0 == jFileChooser.showOpenDialog(this.topui)) {
            File file;
            FileFilter filter = jFileChooser.getFileFilter();
            String formatName = filter.getDescription();
            if (formatName.equals("All Files")) {
                formatName = "Text (*.txt)";
            }
            this.file = file = jFileChooser.getSelectedFile();
            AppPreferences.fileDirectory = file.getParent();
            this.fileOpen(file, formatName, AppPreferences.en, null, null);
        }
    }

    public Resource fileOpen(File file, String formatName, String encoding, String zName, Map filters) {
        this.file = file;
        String name = file.getName();
        String extention = null;
        int i = name.lastIndexOf(".");
        extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
        AppPreferences.format = formatName;
        List<String> ziplist = Arrays.asList(this.zipExtentions);
        List<String> oolist = Arrays.asList(this.ooExtentions);
        List<String> mslist = Arrays.asList(this.msExtentions);
        if (extention.equalsIgnoreCase(".gz")) {
            GZipDocument res = new GZipDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding);
            return res;
        }
        if (mslist.contains(extention)) {
            if (formatName.equals("Ms PowerPoint (*.pptx)")) {
                MSOfficePPDocument res = new MSOfficePPDocument();
                res.setMainView(this.topui);
                res.openFile(file, formatName, encoding, zName, filters);
                return res;
            }
            if (formatName.equals("Ms Excel (*.xlsx)") || formatName.equals("Tagged Ms Excel (*.xlsx)")) {
                MSExcelDocument res = new MSExcelDocument();
                res.setMainView(this.topui);
                res.openFile(file, formatName, encoding, zName, filters);
                return res;
            }
            MSOfficeDocument res = new MSOfficeDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding, zName, filters);
            return res;
        }
        if (oolist.contains(extention)) {
            OpenOfficeDocument res = new OpenOfficeDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding, zName, filters);
            return res;
        }
        if (ziplist.contains(extention)) {
            ZipDocument res = new ZipDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding, zName);
            return res;
        }
        if (formatName.equals("Ms Word (*.docx/xml)")) {
            MSOfficeXMLDocument res = new MSOfficeXMLDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".dxf") && formatName.equals("AutoCAD (*.dxf)")) {
            AutoCadDocument res = new AutoCadDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding, filters);
            return res;
        }
        if (extention.equalsIgnoreCase(".inx") && formatName.equals("Indesign (*.inx)")) {
            IndesignINXDocument res = new IndesignINXDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, "UTF-8");
            return res;
        }
        if (extention.equalsIgnoreCase(".idml") && formatName.equals("Indesign (*.idml)")) {
            IndesignIDMLDocument res = new IndesignIDMLDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding, zName);
            return res;
        }
        if (extention.equalsIgnoreCase(".mif") && formatName.equals("Framemaker (*.mif)")) {
            FramemakerMIFDocument res = new FramemakerMIFDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".srt") && formatName.equals("Subtitles (*.srt)")) {
            SRTSubtitles res = new SRTSubtitles();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".itt") && formatName.equals("Subtitles (*.itt)")) {
            ITTSubtitles res = new ITTSubtitles();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".resx") && formatName.equals("Windows .NET Resources (*.resx)")) {
            ResXFile res = new ResXFile();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".svg") && formatName.equals("Vector Image (*.svg)")) {
            SVGDocument res = new SVGDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding);
            return res;
        }
        if (formatName.equals("DTP Tagged Text")) {
            TaggedTextDocument res = new TaggedTextDocument();
            res.setMainView(this.topui);
            res.openFile(file, formatName, encoding);
            return res;
        }
        if (formatName.equals("Transit XML File")) {
            TransitXMLFile res = new TransitXMLFile();
            res.setMainView(this.topui);
            res.openFile(file, formatName, "UTF-16LE");
            return res;
        }
        TextDocument res = new TextDocument();
        if (formatName != null && formatName.equals("Text (*.txt)")) {
            res.setParagraphView(false);
        }
        res.setMainView(this.topui);
        res.openFile(file, formatName, encoding);
        return res;
    }

    public Resource fileLoad(File file, String formatName, String encoding, String zName, Map filters) {
        this.file = file;
        String name = file.getName();
        String extention = null;
        int i = name.lastIndexOf(".");
        extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
        AppPreferences.format = formatName;
        List<String> ziplist = Arrays.asList(this.zipExtentions);
        List<String> oolist = Arrays.asList(this.ooExtentions);
        List<String> mslist = Arrays.asList(this.msExtentions);
        if (extention.equalsIgnoreCase(".gz")) {
            GZipDocument res = new GZipDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding);
            return res;
        }
        if (mslist.contains(extention)) {
            if (formatName.equals("Ms PowerPoint (*.pptx)")) {
                MSOfficePPDocument res = new MSOfficePPDocument();
                res.setMainView(this.topui);
                res.loadFile(file, formatName, encoding, zName, filters);
                return res;
            }
            if (formatName.equals("Ms Excel (*.xlsx)") || formatName.equals("Tagged Ms Excel (*.xlsx)")) {
                MSExcelDocument res = new MSExcelDocument();
                res.setMainView(this.topui);
                res.loadFile(file, formatName, encoding, zName, filters);
                return res;
            }
            MSOfficeDocument res = new MSOfficeDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding, zName, filters);
            return res;
        }
        if (oolist.contains(extention)) {
            OpenOfficeDocument res = new OpenOfficeDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding, zName, filters);
            return res;
        }
        if (ziplist.contains(extention)) {
            ZipDocument res = new ZipDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding, zName);
            return res;
        }
        if (formatName.equals("Ms Word (*.docx/xml)")) {
            MSOfficeXMLDocument res = new MSOfficeXMLDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".dxf") && formatName.equals("AutoCAD (*.dxf)")) {
            AutoCadDocument res = new AutoCadDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding, filters);
            return res;
        }
        if (extention.equalsIgnoreCase(".inx") && formatName.equals("Indesign (*.inx)")) {
            IndesignINXDocument res = new IndesignINXDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, "UTF-8");
            return res;
        }
        if (extention.equalsIgnoreCase(".idml") && formatName.equals("Indesign (*.idml)")) {
            IndesignIDMLDocument res = new IndesignIDMLDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding, zName);
            return res;
        }
        if (extention.equalsIgnoreCase(".mif") && formatName.equals("Framemaker (*.mif)")) {
            FramemakerMIFDocument res = new FramemakerMIFDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".srt") && formatName.equals("Subtitles (*.srt)")) {
            SRTSubtitles res = new SRTSubtitles();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".itt") && formatName.equals("Subtitles (*.itt)")) {
            ITTSubtitles res = new ITTSubtitles();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".resx") && formatName.equals("Windows .NET Resources (*.resx)")) {
            ResXFile res = new ResXFile();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding);
            return res;
        }
        if (extention.equalsIgnoreCase(".svg") && formatName.equals("Vector Image (*.svg)")) {
            SVGDocument res = new SVGDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding);
            return res;
        }
        if (formatName.equals("DTP Tagged Text")) {
            TaggedTextDocument res = new TaggedTextDocument();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, encoding);
            return res;
        }
        if (formatName.equals("Transit XML File")) {
            TransitXMLFile res = new TransitXMLFile();
            res.setMainView(this.topui);
            res.loadFile(file, formatName, "UTF-16LE");
            return res;
        }
        TextDocument res = new TextDocument();
        res.setMainView(this.topui);
        res.loadFile(file, formatName, encoding);
        return res;
    }

    public File getSelectedFile() {
        return this.file;
    }
}

