/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;

public class EULAView
extends JDialog {
    JButton accept;
    JButton reject;

    public EULAView(File file, String title) {
        this.setModal(true);
        this.setTitle(title);
        try {
            Charset charset = Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            FileInputStream fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            CharBuffer cb = decoder.decode(bb);
            fc.close();
            fis.close();
            char[] buff = new char[sz];
            cb.get(buff, 0, sz);
            String text = new String(buff, 0, sz);
            this.initApplicationEULA(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EULAView(String text) {
        this.setModal(true);
        this.setTitle("End User License Agreement");
        this.initInformationEULA(text);
    }

    private void initApplicationEULA(String text) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        this.accept = new JButton("Accept");
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CHECK, (int)(this.accept.getFont().getSize() + 4), (Color)this.accept.getForeground());
        this.accept.setIcon((Icon)ficon);
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EULAView.this.dispose();
                AppPreferences.EULAShow = false;
            }
        });
        this.reject = new JButton("Decline");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)(this.reject.getFont().getSize() + 4), (Color)this.reject.getForeground());
        this.reject.setIcon((Icon)ficon);
        this.reject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JPanel bpanel = new JPanel();
        bpanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        bpanel.add(this.accept);
        bpanel.add(this.reject);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        panel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        JTextArea ta = new JTextArea();
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        Dimension screen = this.getToolkit().getScreenSize();
        int fsize = screen.width > 3000 ? 22 : (screen.width > 2400 ? 18 : 14);
        ta.setFont(new Font(AppPreferences.fontname, 0, fsize));
        ta.setMargin(new Insets(24, 24, 24, 24));
        ta.setEditable(false);
        jScrollPane.getViewport().add((Component)ta, null);
        ta.setText(text);
        ta.setCaretPosition(0);
        panel.add((Component)jScrollPane, "Center");
        panel.add((Component)bpanel, "South");
        this.setContentPane(panel);
        Dimension frameSize = new Dimension(800, 600);
        this.setSize(frameSize);
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    private void initInformationEULA(String text) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EULAView.this.dispose();
            }
        });
        this.accept = new JButton("OK");
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CHECK, (int)(this.accept.getFont().getSize() + 4), (Color)this.accept.getForeground());
        this.accept.setIcon((Icon)ficon);
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EULAView.this.dispose();
            }
        });
        JPanel bpanel = new JPanel();
        bpanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        bpanel.add(this.accept);
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        panel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        JTextArea ta = new JTextArea();
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setFont(new Font(AppPreferences.fontname, 0, 14));
        ta.setMargin(new Insets(24, 24, 24, 24));
        ta.setEditable(false);
        jScrollPane.getViewport().add((Component)ta, null);
        ta.setText(text);
        ta.setCaretPosition(0);
        panel.add((Component)jScrollPane, "Center");
        panel.add((Component)bpanel, "South");
        this.setContentPane(panel);
        Dimension screen = this.getToolkit().getScreenSize();
        Dimension frameSize = new Dimension(800, 600);
        this.setSize(frameSize);
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.setVisible(true);
    }
}

