/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import translator.AppPreferences;
import translator.MainView;
import translator.Placeables;
import translator.Workflow;
import translator.XMLHelper;

public class ExternalEditor {
    private File bindFile;
    private Timer timerIn;
    private MainView topui;
    private long lastModified;
    private Path path;
    private boolean clipboardTansfer;
    private boolean autoRefresh;
    int editor;
    private boolean defaultCharset = false;

    public ExternalEditor(MainView topui) {
        this.topui = topui;
        if (AppPreferences.editorBinding.equals("Clipboard binding")) {
            this.clipboardTansfer = true;
        }
        if (!this.clipboardTansfer) {
            String dir = System.getProperty("user.home") + AppPreferences.fs + "Documents";
            File d = new File(dir);
            if (!d.exists()) {
                d.mkdir();
            }
            String filePath = dir + AppPreferences.fs + "CafeTranBond.txt";
            this.bindFile = new File(filePath);
            this.lastModified = this.bindFile.lastModified();
            if (AppPreferences.editorBinding.equals("WordPad") && AppPreferences.operatingSystem == 0) {
                this.editor = 1;
                this.autoRefresh = false;
                this.defaultCharset = true;
            } else if (AppPreferences.editorBinding.equals("TextEdit") && AppPreferences.operatingSystem == 1) {
                this.editor = 2;
                this.autoRefresh = false;
            } else if (AppPreferences.editorBinding.equals("Jarte") && AppPreferences.operatingSystem == 0) {
                this.defaultCharset = true;
            } else {
                this.autoRefresh = true;
            }
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void startTimer() {
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long lm = ExternalEditor.this.bindFile.lastModified();
                if (lm != ExternalEditor.this.lastModified) {
                    ExternalEditor.this.lastModified = lm;
                    ExternalEditor.this.setExternalTargetSegment();
                } else if (ExternalEditor.this.topui.getTargetView().isReadyToBind() && ExternalEditor.this.autoRefresh) {
                    ExternalEditor.this.setCafeTranTargetSegment();
                }
            }
        };
        int delaySeconds = 2;
        this.timerIn = new Timer(2000, taskPerformer);
        this.timerIn.start();
        try {
            boolean bl = this.bindFile.createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(ExternalEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isClipboardTransfer() {
        return this.clipboardTansfer;
    }

    public void stopTimer() {
        if (this.timerIn != null) {
            this.timerIn.stop();
        }
    }

    public void setClipboardTargetSegment(String segment) {
        boolean autoNext = this.topui.getTargetView().isAutoNextOn();
        segment = Placeables.unmaskTarget(segment);
        if (autoNext) {
            this.topui.getTargetView().setExternalEditorTranslation(segment);
            this.topui.getWorkflowView().add(0, false);
        } else {
            this.topui.toFront();
            this.topui.requestFocusInWindow();
            this.topui.getTargetView().setExternalEditorTranslation(segment);
            this.topui.getTargetPane().requestFocus();
        }
    }

    private void setExternalTargetSegment() {
        try {
            byte[] bytes;
            if (this.path == null) {
                this.path = Paths.get(this.bindFile.toURI());
            }
            String s = (bytes = Files.readAllBytes(this.path)) != null && bytes.length > 0 ? (this.defaultCharset ? new String(bytes, Charset.defaultCharset()) : new String(bytes, "UTF-8")) : "";
            this.topui.getTargetView().setExternalEditorTranslation(s);
            this.topui.getTargetView().setReadyToBind(false);
            boolean autoNext = this.topui.getTargetView().isAutoNextOn();
            if (autoNext) {
                this.topui.getWorkflowView().add(0, false);
            } else {
                this.topui.toFront();
                this.topui.requestFocusInWindow();
                this.topui.getTargetPane().requestFocus();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ExternalEditor.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this.topui, ex.getMessage());
        }
    }

    public void setCafeTranTargetSegment() {
        block13: {
            String segment;
            this.topui.getTargetView().setReadyToBind(false);
            Workflow w = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
            if (w != null && (segment = w.getTarget()) != null) {
                if (segment.length() > 0) {
                    segment = XMLHelper.replaceTagsWithPipes(segment);
                }
                try {
                    if (this.editor == 1) {
                        Runtime.getRuntime().exec("taskkill /IM wordpad.exe /f");
                    } else if (this.editor == 2) {
                        Runtime.getRuntime().exec("killall TextEdit");
                    }
                    byte[] bytes = this.defaultCharset ? segment.getBytes(Charset.defaultCharset()) : segment.getBytes("utf-8");
                    if (this.path == null) {
                        this.path = Paths.get(this.bindFile.toURI());
                    }
                    Files.write(this.path, bytes, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                    this.lastModified = this.bindFile.lastModified();
                    if (this.editor == 1) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(ExternalEditor.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        Runtime.getRuntime().exec("write " + this.bindFile.toString());
                        break block13;
                    }
                    if (this.editor != 2) break block13;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ExternalEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Runtime.getRuntime().exec("open -a  TextEdit " + this.bindFile.toString());
                }
                catch (IOException ex) {
                    Logger.getLogger(ExternalEditor.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(this.topui, ex.getMessage());
                }
            }
        }
    }
}

