/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.Serializable;
import translator.tmx.TMXResult;

public class FragmentMatch
implements Serializable {
    private String fragment;
    private String source;
    private String target;
    private String resourceName;
    private int matchType;
    private int resourceType;
    private int accuracy;
    private int priority;
    private int contextLevel;
    private int weight = 0;
    private int alternative = 0;
    private TMXResult result;
    private int resultID;
    private int hitsNumber;
    private String[] fields;
    private boolean segmentMatch;
    private static final long serialVersionUID = 1L;

    public FragmentMatch(String fragment, String source, String target, String resourceName, boolean segmentMatch, int matchType, int resourceType, int contexLevel, int priority, int alternative) {
        this.segmentMatch = segmentMatch;
        this.fragment = fragment;
        this.source = source;
        this.target = target;
        this.resourceName = resourceName;
        this.matchType = matchType;
        this.resourceType = resourceType;
        this.priority = priority;
        this.contextLevel = contexLevel;
        this.alternative = alternative;
    }

    public boolean isSegmentMatch() {
        return this.segmentMatch;
    }

    public void setFields(String[] f) {
        this.fields = f;
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setTMResult(TMXResult result) {
        this.result = result;
    }

    public TMXResult getTMResult() {
        return this.result;
    }

    public void setResultID(int id) {
        this.resultID = id;
    }

    public int getResultID() {
        return this.resultID;
    }

    public void setHitsNumer(int no) {
        this.hitsNumber = no;
    }

    public int getHitsNumber() {
        return this.hitsNumber;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getShortResourceName() {
        if (this.resourceName.length() > 2) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.resourceName.charAt(0));
            sb.append(this.resourceName.charAt(this.resourceName.length() - 1));
            return sb.toString();
        }
        return this.resourceName;
    }

    public int getMatchTypeInt() {
        return this.matchType;
    }

    public String getMatchType() {
        if (this.matchType == 1) {
            if (this.segmentMatch) {
                if (this.contextLevel == 1) {
                    return "CTX";
                }
                return "Exact";
            }
            if (this.resourceType == 2) {
                return "Term";
            }
            return "Fragm";
        }
        if (this.matchType == 2) {
            return "Virtual";
        }
        if (this.matchType == 3) {
            return "Hit";
        }
        if (this.matchType == 4) {
            return "Prefix";
        }
        if (this.matchType == 5) {
            return "Stem";
        }
        if (this.matchType == 6) {
            return "Regex";
        }
        if (this.matchType == 7) {
            return "Nontrans";
        }
        if (this.matchType == 8) {
            return "Pattern";
        }
        if (this.matchType == 9) {
            return "Auto";
        }
        return "Term";
    }

    public String getShortMatchType() {
        if (this.matchType == 1) {
            if (this.segmentMatch) {
                if (this.contextLevel == 1) {
                    return "CM";
                }
                return "EM";
            }
            if (this.resourceType == 2) {
                return "TR";
            }
            return "FR";
        }
        if (this.matchType == 2) {
            return "VM";
        }
        if (this.matchType == 3) {
            return "HT";
        }
        if (this.matchType == 4) {
            return "PX";
        }
        if (this.matchType == 5) {
            return "SM";
        }
        if (this.matchType == 6) {
            return "RM";
        }
        if (this.matchType == 7) {
            return "NT";
        }
        if (this.matchType == 8) {
            return "PA";
        }
        if (this.matchType == 9) {
            return "AA";
        }
        return "TR";
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int a) {
        this.accuracy = a;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getAltenative() {
        return this.alternative;
    }

    public int getContexLevel() {
        return this.contextLevel;
    }

    public int getWeight() {
        if (this.weight != 0) {
            return this.weight;
        }
        this.weight = this.matchType == 1 || this.matchType == 8 || this.matchType == 9 ? 4 : (this.matchType == 2 ? 3 : (this.matchType == 3 ? 2 : (this.matchType == 0 ? 0 : 1)));
        return this.weight;
    }

    public int hashCode() {
        return this.source.hashCode() + this.target.hashCode();
    }

    public boolean equals(Object obj) {
        FragmentMatch fm = (FragmentMatch)obj;
        return fm.source.equals(this.source) && fm.target.equals(this.target);
    }
}

