/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.FileFilters;
import translator.MainView;
import translator.MySwingWorker;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.TabView;

public class ImageResource
extends DefaultResource {
    private MainView topui;
    private TabView tview;
    private ResourceView rview;
    private Vector pictures;
    private JLabel imagePanel;
    private int current = -1;
    private int procScale = 0;
    private ArrayList topEntries;
    private String imagedir = null;
    private String info;
    private String path;
    private String infoPath;
    private String resourceName;
    private MySwingWorker worker;
    private boolean invert = false;
    private String uid;

    ImageResource(String path) {
        try {
            Object[] files;
            File file;
            this.uid = Integer.toString(ResourceView.uniqueResourceID++);
            this.info = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMAGE VIEWER");
            this.procScale = 0;
            this.path = path;
            this.resourceName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMAGE");
            if (path == null) {
                return;
            }
            if (!path.startsWith("http:") && !path.startsWith("file:")) {
                file = new File(path);
            } else {
                URI uri = new URI(path);
                file = new File(uri);
            }
            path = file.getPath();
            this.resourceName = file.getName();
            if (file.isDirectory()) {
                files = file.list();
                Arrays.sort(files);
            } else {
                files = new String[1];
                String s = file.getName();
                files[0] = s;
                path = path.substring(0, path.lastIndexOf(s));
            }
            this.pictures = this.parseParameters(path, (String[])files);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ImageResource(ResourceInfo ri) {
        try {
            Object[] files;
            File file;
            this.uid = Integer.toString(ResourceView.uniqueResourceID++);
            this.infoPath = ri.getInfoPath();
            this.path = ri.getResourcePath();
            if (this.path == null) {
                this.path = AppPreferences.packagePath + "resources/images/";
            }
            this.procScale = ri.getZoom();
            int i = this.infoPath.lastIndexOf(AppPreferences.fs);
            if (i == -1) {
                i = this.infoPath.lastIndexOf(47);
            }
            this.resourceName = i != -1 ? this.infoPath.substring(i + 1, this.infoPath.length() - 4) : "Image";
            if (!this.path.startsWith("http:") && !this.path.startsWith("file:")) {
                file = new File(this.path);
            } else {
                URI uri = new URI(this.path);
                file = new File(uri);
            }
            this.path = file.getPath();
            if (file.isDirectory()) {
                files = file.list();
                Arrays.sort(files);
            } else {
                files = new String[1];
                String s = file.getName();
                files[0] = s;
                this.path = this.path.substring(0, this.path.lastIndexOf(s));
            }
            this.pictures = this.parseParameters(this.path, (String[])files);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.rview = topui.getResourceView();
        if (this.pictures != null && this.pictures.size() > 0) {
            this.createImageTab();
            if (this.pictures.size() == 1) {
                this.imagePanel.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING IMAGE..."));
                this.setPhoto(0);
            } else {
                this.imagePanel.setText(this.info);
            }
        }
    }

    private void createImageTab() {
        this.imagePanel = new JLabel();
        this.imagePanel.setOpaque(true);
        if (AppPreferences.background != 0) {
            Color background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            this.imagePanel.setBackground(background);
            this.imagePanel.setForeground(foreground);
        }
        this.imagePanel.setHorizontalAlignment(0);
        this.imagePanel.setVerticalAlignment(0);
        this.imagePanel.setVerticalTextPosition(0);
        this.imagePanel.setHorizontalTextPosition(0);
        this.imagePanel.setAutoscrolls(true);
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem nextMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEXT DOCUMENT"));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT, (int)nextMenu.getFont().getSize(), (Color)nextMenu.getForeground());
        nextMenu.setIcon((Icon)ficon);
        nextMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageResource.this.nextResource();
            }
        });
        menu.add(nextMenu);
        JMenuItem previousMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIOUS DOCUMENT"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_LEFT, (int)previousMenu.getFont().getSize(), (Color)previousMenu.getForeground());
        previousMenu.setIcon((Icon)ficon);
        previousMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageResource.this.previousResource();
            }
        });
        menu.add(previousMenu);
        JMenuItem zoomPlusMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ZOOM +10%"));
        zoomPlusMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageResource.this.plusResource();
            }
        });
        menu.add(zoomPlusMenu);
        JMenuItem zoomMinusMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ZOOM -10%"));
        zoomMinusMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageResource.this.minusResource();
            }
        });
        menu.add(zoomMinusMenu);
        JMenuItem invertMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVERT COLORS"));
        invertMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Photo pic = (Photo)ImageResource.this.pictures.elementAt(ImageResource.this.current);
                pic.invertColors();
                ImageResource.this.imagePanel.repaint();
                ImageResource.this.invert = !ImageResource.this.invert;
            }
        });
        menu.add(invertMenu);
        this.imagePanel.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ImageResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().add((Component)this.imagePanel, null);
        jScrollPane.setName(this.uid);
        this.tview.addTab(this, this.resourceName, jScrollPane);
    }

    private void next() {
        if (this.pictures == null || this.current == this.pictures.size() - 1) {
            return;
        }
        this.imagePanel.setIcon(null);
        this.imagePanel.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING IMAGE..."));
        ++this.current;
        this.setPhoto(this.current);
    }

    private void previous() {
        if (this.current <= 0) {
            return;
        }
        this.imagePanel.setIcon(null);
        this.imagePanel.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING IMAGE..."));
        --this.current;
        this.setPhoto(this.current);
    }

    private void zoomPlus() {
        if (this.current == -1) {
            return;
        }
        this.imagePanel.setIcon(null);
        this.imagePanel.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING IMAGE..."));
        Photo pic = (Photo)this.pictures.elementAt(this.current);
        pic.setSize(10);
        this.updatePhotograph(this.current, pic);
    }

    private void zoomMinus() {
        if (this.current == -1) {
            return;
        }
        this.imagePanel.setIcon(null);
        this.imagePanel.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING IMAGE..."));
        Photo pic = (Photo)this.pictures.elementAt(this.current);
        pic.setSize(-10);
        this.updatePhotograph(this.current, pic);
    }

    private int getPageIndex(String name) {
        int findex = -1;
        int subindex = 0;
        for (int nlength = 1; nlength <= name.length(); ++nlength) {
            String subName = name.substring(0, nlength);
            while (subindex < this.topEntries.size()) {
                String page = (String)this.topEntries.get(subindex);
                if (page.startsWith(subName)) {
                    findex = subindex;
                    break;
                }
                ++subindex;
            }
            if (subindex >= this.topEntries.size()) break;
        }
        return findex;
    }

    @Override
    public void search(String okey, String rep) {
        final String key = okey;
        if (this.pictures.size() == 1) {
            return;
        }
        JFrame jf = this.topui.getExtendedFrame();
        if (jf != null && jf.getExtendedState() == 1 && this.topui.getTabView().tabExists(this.resourceName)) {
            jf.setExtendedState(0);
        }
        this.worker = new MySwingWorker(this){
            final /* synthetic */ ImageResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.this$0.tview = this.this$0.topui.getTabView();
                if (this.this$0.tview.tabExists(this.this$0.resourceName)) {
                    this.this$0.tview.selectTab(this.this$0.resourceName);
                }
                this.this$0.find(key);
                return null;
            }

            @Override
            public void finished() {
            }
        };
        this.worker.start();
    }

    private void find(String key) {
        this.imagePanel.setIcon(null);
        this.imagePanel.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING IMAGE..."));
        int j = this.getPageIndex(key);
        if (j != -1) {
            this.setPhoto(j);
        } else {
            this.imagePanel.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO IMAGES"));
        }
    }

    @Override
    public void stopSearch() {
        this.worker.interrupt();
    }

    private void setPhoto(int cur) {
        this.current = cur;
        Photo pic = (Photo)this.pictures.elementAt(this.current);
        ImageIcon icon = pic.getIcon();
        if (icon == null) {
            this.loadImage(pic.filename, this.current);
        } else {
            this.updatePhotograph(this.current, pic);
        }
    }

    private void updatePhotograph(int index, Photo pic) {
        ImageIcon icon = pic.getIcon();
        this.procScale = pic.scale;
        this.imagePanel.setToolTipText(pic.filename + ": " + icon.getIconWidth() + " X " + icon.getIconHeight());
        this.imagePanel.setIcon(icon);
        this.imagePanel.setText("");
    }

    private void loadImage(final String imagePath, final int index) {
        MySwingWorker worker = new MySwingWorker(this){
            ImageIcon icon = null;
            final /* synthetic */ ImageResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                try {
                    BufferedImage bgimage = ImageIO.read(this.this$0.getImageURL(imagePath));
                    if (bgimage != null) {
                        this.icon = new ImageIcon();
                        this.icon.setImage(bgimage);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(ImageResource.class.getName()).log(Level.SEVERE, null, ex);
                }
                return this.icon;
            }

            @Override
            public void finished() {
                Photo pic = (Photo)this.this$0.pictures.elementAt(index);
                pic.setIcon(this.icon, this.this$0.procScale);
                if (index == this.this$0.current) {
                    this.this$0.updatePhotograph(index, pic);
                }
            }
        };
        worker.start();
    }

    public String getHref() {
        Photo pic = (Photo)this.pictures.elementAt(this.current);
        URL url = this.getImageURL(pic.filename);
        return url.toString();
    }

    private URL getImageURL(String filename) {
        URL url = null;
        try {
            File file = new File(this.imagedir + filename);
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
        return url;
    }

    private Vector parseParameters(String dir, String[] files) {
        Vector<Photo> pix = new Vector<Photo>(files.length);
        this.topEntries = new ArrayList(files.length);
        for (int i = 0; i < files.length; ++i) {
            String ext;
            String file = files[i];
            int ind = file.indexOf(46);
            if (ind == -1 || !(ext = file.substring(ind)).equalsIgnoreCase(".jpg") && !ext.equalsIgnoreCase(".jpeg") && !ext.equalsIgnoreCase(".png") && !ext.equalsIgnoreCase(".bmp") && !ext.equalsIgnoreCase(".gif") && !ext.equalsIgnoreCase(".tif") && !ext.equalsIgnoreCase(".tiff")) continue;
            Photo pic = new Photo(file);
            pix.addElement(pic);
            this.topEntries.add(file.substring(0, ind));
        }
        this.imagedir = dir;
        if (this.imagedir != null) {
            this.imagedir = this.imagedir + "/";
        }
        return pix;
    }

    private void openImage() {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        String[] pro = new String[]{"Images"};
        FileFilters filters = new FileFilters();
        filters.setFileFilters(pro, "Images", jFileChooser);
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN IMAGE"));
        jFileChooser.setCurrentDirectory(new File(AppPreferences.fileDirectory));
        jFileChooser.setFileSelectionMode(2);
        if (0 == jFileChooser.showOpenDialog(this.topui)) {
            Object[] files;
            if (this.imagePanel == null) {
                this.createImageTab();
            }
            file = jFileChooser.getSelectedFile();
            AppPreferences.fileDirectory = file.getParent();
            this.path = file.getPath();
            this.resourceName = file.getName();
            this.tview.setCurrentName(this.resourceName);
            this.procScale = 0;
            if (file.isDirectory()) {
                files = file.list();
                Arrays.sort(files);
            } else {
                files = new String[1];
                String s = file.getName();
                files[0] = s;
                this.path = this.path.substring(0, this.path.lastIndexOf(s));
            }
            this.pictures = this.parseParameters(this.path, (String[])files);
            if (this.pictures.size() == 1) {
                this.imagePanel.setIcon(null);
                this.imagePanel.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING IMAGE..."));
                this.setPhoto(0);
            } else {
                this.imagePanel.setText(this.info);
            }
            this.topui.repaint();
        }
    }

    @Override
    public void newResource() {
        String s = null;
        this.topui.getResourceLoader().prepareImageResource(s);
    }

    @Override
    public void openResource() {
        this.openImage();
    }

    @Override
    public void closeResource() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
        if (this.infoPath != null) {
            List loader = this.topui.getResourceLoader().getResourceLoaderList();
            loader.remove(this.infoPath);
            this.topui.getProjectView().removeReference(this.infoPath);
            this.topui.getResourceLoader().removeLastSessionResource(this.infoPath);
        }
        if (this.path != null) {
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            docs.remove(this.path);
        }
        this.tview.removeTab(this.uid, this.resourceName);
    }

    @Override
    public void nextResource() {
        this.next();
    }

    @Override
    public void previousResource() {
        this.previous();
    }

    @Override
    public void plusResource() {
        this.zoomPlus();
    }

    @Override
    public void minusResource() {
        this.zoomMinus();
    }

    @Override
    public String getInfoPath() {
        return this.infoPath;
    }

    class Photo {
        public String filename;
        public int width;
        public int height;
        public int scale;
        public ImageIcon icon;
        public BufferedImage image;

        public Photo(String filename) {
            this.filename = filename;
            this.width = 0;
            this.height = 0;
            this.scale = 0;
            this.icon = null;
        }

        public void setSize(int i) {
            this.scale += i;
            Image im = this.image.getScaledInstance(this.width + this.width * this.scale / 100, this.height + this.height * this.scale / 100, 2);
            this.icon.setImage(im);
        }

        public void setIcon(ImageIcon i, int scale) {
            this.icon = i;
            this.width = this.icon.getIconWidth();
            this.height = this.icon.getIconHeight();
            this.image = (BufferedImage)this.icon.getImage();
            if (ImageResource.this.invert) {
                this.invertColors();
            }
            if (scale != 0) {
                this.icon.setImage(this.image.getScaledInstance(this.width + this.width * scale / 100, this.height + this.height * scale / 100, 2));
            }
            this.scale = scale;
        }

        public void invertColors() {
            Graphics g2 = this.image.getGraphics();
            g2.setXORMode(Color.WHITE);
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, this.width, this.height);
            this.icon.setImage(this.image);
        }

        public ImageIcon getIcon() {
            return this.icon;
        }

        public void removeIcon() {
            this.icon = null;
            this.image = null;
        }
    }
}

