/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.MainView;

public final class KeyPreferences
extends JDialog
implements ActionListener {
    private JTextField field;
    private JComboBox modbox;
    private JComboBox modbox2;
    private JButton jb1;
    private JButton jb2;
    private JButton jb3;
    private String key;
    private KeyStroke keystroke;
    private static Map keyStrokesMap = new HashMap();
    private JComponent component;
    private static Preferences kprefs;
    private static int menuShortcutMask;
    private MainView parent;

    KeyPreferences(MainView parent, String title, String key, JComponent component) {
        super(parent, title, true);
        this.enableEvents(64L);
        this.parent = parent;
        this.key = key;
        this.component = component;
        try {
            this.init();
            this.pack();
            this.field.requestFocusInWindow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.field = new JTextField();
        Font font = this.field.getFont();
        font = font.deriveFont(1);
        this.field.setFont(font);
        this.field.setPreferredSize(new Dimension(160, this.field.getPreferredSize().height));
        this.field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 16 || keyCode == 17 || keyCode == 18 || keyCode == 157) {
                    return;
                }
                String keyString = KeyEvent.getKeyText(keyCode);
                KeyPreferences.this.field.setText(keyString);
                KeyPreferences.this.field.putClientProperty("keycode", keyCode);
                int mod = e.getModifiers();
                String mods = KeyEvent.getKeyModifiersText(mod);
                if (mods == null || mods.length() == 0) {
                    KeyPreferences.this.modbox.setSelectedIndex(0);
                    KeyPreferences.this.modbox2.setSelectedIndex(0);
                } else if (mods != null) {
                    int plus = mods.indexOf("+");
                    if (plus == -1) {
                        KeyPreferences.this.modbox.setSelectedItem(mods);
                        KeyPreferences.this.modbox2.setSelectedIndex(0);
                    } else {
                        String m1 = mods.substring(0, plus);
                        String m2 = mods.substring(plus + 1);
                        KeyPreferences.this.modbox.setSelectedItem(m1);
                        KeyPreferences.this.modbox2.setSelectedItem(m2);
                    }
                }
            }
        });
        String[] keys = new String[]{"", KeyEvent.getKeyModifiersText(1), KeyEvent.getKeyModifiersText(2), KeyEvent.getKeyModifiersText(4), KeyEvent.getKeyModifiersText(8)};
        this.modbox = new JComboBox<String>(keys);
        this.modbox2 = new JComboBox<String>(keys);
        font = this.modbox.getFont();
        font = font.deriveFont(1);
        this.modbox.setFont(font);
        this.modbox2.setFont(font);
        this.keystroke = (KeyStroke)keyStrokesMap.get(this.key);
        if (this.keystroke != null) {
            int k = this.keystroke.getKeyCode();
            int m = this.keystroke.getModifiers();
            if (k != 27 && m != 0) {
                this.field.setText(KeyEvent.getKeyText(k));
                this.field.putClientProperty("keycode", k);
                String mods = KeyEvent.getKeyModifiersText(m);
                if (mods == null || mods.length() == 0) {
                    this.modbox.setSelectedIndex(0);
                    this.modbox2.setSelectedIndex(0);
                } else if (mods != null) {
                    int plus = mods.indexOf("+");
                    if (plus == -1) {
                        this.modbox.setSelectedItem(mods);
                        this.modbox2.setSelectedIndex(0);
                    } else {
                        String m1 = mods.substring(0, plus);
                        String m2 = mods.substring(plus + 1);
                        this.modbox.setSelectedItem(m1);
                        this.modbox2.setSelectedItem(m2);
                    }
                }
            }
        }
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb3 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DISABLE"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        this.jb3.addActionListener(this);
        JPanel content = (JPanel)this.getContentPane();
        content.setBorder(new EmptyBorder(new Insets(10, 10, 5, 10)));
        JPanel panel1 = new JPanel();
        this.setResizable(false);
        panel1.add(this.modbox);
        panel1.add(new JLabel("+"));
        panel1.add(this.modbox2);
        panel1.add(new JLabel("+"));
        panel1.add(this.field);
        JPanel panel2 = new JPanel();
        panel2.setBorder(new EmptyBorder(new Insets(10, 0, 0, 0)));
        panel2.setLayout(new FlowLayout());
        panel2.setLayout(new FlowLayout(2));
        panel2.add(this.jb1);
        panel2.add(this.jb3);
        panel2.add(this.jb2);
        content.add((Component)panel1, "Center");
        content.add((Component)panel2, "South");
    }

    static void setKeyPreferences() {
        kprefs = AppPreferences.getPreferences();
        String k = kprefs.get("k1", KeyPreferences.keyString(40, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k1", k);
        k = kprefs.get("k2", KeyPreferences.keyString(39, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k2", k);
        k = kprefs.get("k3", KeyPreferences.keyString(37, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k3", k);
        k = kprefs.get("k4", KeyPreferences.keyString(38, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k4", k);
        k = kprefs.get("k5", KeyPreferences.keyString(83, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k5", k);
        k = kprefs.get("k6", KeyPreferences.keyString(68, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k6", k);
        k = kprefs.get("k7", KeyPreferences.keyString(49, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k7", k);
        k = kprefs.get("k8", KeyPreferences.keyString(50, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k8", k);
        k = kprefs.get("k9", KeyPreferences.keyString(51, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k9", k);
        k = kprefs.get("k10", KeyPreferences.keyString(52, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k10", k);
        k = kprefs.get("k11", KeyPreferences.keyString(113, 0));
        KeyPreferences.makeKeyStroke("k11", k);
        k = kprefs.get("k12", KeyPreferences.keyString(112, 0));
        KeyPreferences.makeKeyStroke("k12", k);
        k = kprefs.get("k13", KeyPreferences.keyString(73, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k13", k);
        k = kprefs.get("k14", KeyPreferences.keyString(75, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k14", k);
        k = kprefs.get("k15", KeyPreferences.keyString(74, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k15", k);
        k = kprefs.get("k16", KeyPreferences.keyString(72, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k16", k);
        k = kprefs.get("k17", KeyPreferences.keyString(114, 0));
        KeyPreferences.makeKeyStroke("k17", k);
        k = kprefs.get("k18", KeyPreferences.keyString(57, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k18", k);
        k = kprefs.get("k19", KeyPreferences.keyString(82, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k19", k);
        k = kprefs.get("k20", KeyPreferences.keyString(115, 0));
        KeyPreferences.makeKeyStroke("k20", k);
        k = kprefs.get("k21", KeyPreferences.keyString(80, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k21", k);
        k = kprefs.get("k25", KeyPreferences.keyString(10, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k25", k);
        k = kprefs.get("k26", KeyPreferences.keyString(77, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k26", k);
        k = kprefs.get("k27", KeyPreferences.keyString(71, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k27", k);
        k = kprefs.get("k28", KeyPreferences.keyString(84, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k28", k);
        k = kprefs.get("k29", KeyPreferences.keyString(78, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k29", k);
        k = kprefs.get("k30", KeyPreferences.keyString(66, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k30", k);
        k = kprefs.get("k32", KeyPreferences.keyString(79, 576));
        KeyPreferences.makeKeyStroke("k32", k);
        k = kprefs.get("k33", KeyPreferences.keyString(83, 576));
        KeyPreferences.makeKeyStroke("k33", k);
        k = kprefs.get("k34", KeyPreferences.keyString(70, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k34", k);
        k = kprefs.get("k35", KeyPreferences.keyString(116, 0));
        KeyPreferences.makeKeyStroke("k35", k);
        k = kprefs.get("k36", KeyPreferences.keyString(65, 192));
        KeyPreferences.makeKeyStroke("k36", k);
        k = kprefs.get("k37", KeyPreferences.keyString(67, 192));
        KeyPreferences.makeKeyStroke("k37", k);
        k = kprefs.get("k38", KeyPreferences.keyString(61, 192));
        KeyPreferences.makeKeyStroke("k38", k);
        k = kprefs.get("k39", KeyPreferences.keyString(61, 128));
        KeyPreferences.makeKeyStroke("k39", k);
        k = kprefs.get("k40", KeyPreferences.keyString(46, 192));
        KeyPreferences.makeKeyStroke("k40", k);
        k = kprefs.get("k41", KeyPreferences.keyString(44, 192));
        KeyPreferences.makeKeyStroke("k41", k);
        k = kprefs.get("k42", KeyPreferences.keyString(47, 192));
        KeyPreferences.makeKeyStroke("k42", k);
        k = kprefs.get("k44", KeyPreferences.keyString(84, 128));
        KeyPreferences.makeKeyStroke("k44", k);
        k = kprefs.get("k45", KeyPreferences.keyString(84, 192));
        KeyPreferences.makeKeyStroke("k45", k);
        k = kprefs.get("k46", KeyPreferences.keyString(78, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k46", k);
        k = kprefs.get("k47", KeyPreferences.keyString(79, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k47", k);
        k = kprefs.get("k48", KeyPreferences.keyString(68, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k48", k);
        k = kprefs.get("k49", KeyPreferences.keyString(35, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k49", k);
        k = kprefs.get("k50", KeyPreferences.keyString(83, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k50", k);
        k = kprefs.get("k51", KeyPreferences.keyString(81, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k51", k);
        k = kprefs.get("k52", KeyPreferences.keyString(10, 128));
        KeyPreferences.makeKeyStroke("k52", k);
        k = kprefs.get("k53", KeyPreferences.keyString(78, 192));
        KeyPreferences.makeKeyStroke("k53", k);
        k = kprefs.get("k55", KeyPreferences.keyString(73, 192));
        KeyPreferences.makeKeyStroke("k55", k);
        k = kprefs.get("k56", KeyPreferences.keyString(80, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k56", k);
        k = kprefs.get("k57", KeyPreferences.keyString(87, 128));
        KeyPreferences.makeKeyStroke("k57", k);
        k = kprefs.get("k58", KeyPreferences.keyString(87, 192));
        KeyPreferences.makeKeyStroke("k58", k);
        k = kprefs.get("k59", KeyPreferences.keyString(46, 128));
        KeyPreferences.makeKeyStroke("k59", k);
        k = kprefs.get("k60", KeyPreferences.keyString(44, 128));
        KeyPreferences.makeKeyStroke("k60", k);
        k = kprefs.get("k67", KeyPreferences.keyString(83, 192));
        KeyPreferences.makeKeyStroke("k67", k);
        k = kprefs.get("k62", KeyPreferences.keyString(32, 128));
        KeyPreferences.makeKeyStroke("k62", k);
        k = kprefs.get("k63", KeyPreferences.keyString(27, 0));
        KeyPreferences.makeKeyStroke("k63", k);
        k = kprefs.get("k64", KeyPreferences.keyString(122, 0));
        KeyPreferences.makeKeyStroke("k64", k);
        k = kprefs.get("k65", KeyPreferences.keyString(82, 192));
        KeyPreferences.makeKeyStroke("k65", k);
        k = kprefs.get("k66", KeyPreferences.keyString(114, 128));
        KeyPreferences.makeKeyStroke("k66", k);
        k = kprefs.get("k61", KeyPreferences.keyString(32, 192));
        KeyPreferences.makeKeyStroke("k61", k);
        k = kprefs.get("k68", KeyPreferences.keyString(45, 192));
        KeyPreferences.makeKeyStroke("k68", k);
        k = kprefs.get("k69", KeyPreferences.keyString(222, 192));
        KeyPreferences.makeKeyStroke("k69", k);
        k = kprefs.get("k70", KeyPreferences.keyString(40, 128));
        KeyPreferences.makeKeyStroke("k70", k);
        k = kprefs.get("k71", KeyPreferences.keyString(93, 128));
        KeyPreferences.makeKeyStroke("k71", k);
        k = kprefs.get("k72", KeyPreferences.keyString(112, 192));
        KeyPreferences.makeKeyStroke("k72", k);
        k = kprefs.get("k73", KeyPreferences.keyString(113, 192));
        KeyPreferences.makeKeyStroke("k73", k);
        k = kprefs.get("k74", KeyPreferences.keyString(114, 192));
        KeyPreferences.makeKeyStroke("k74", k);
        k = kprefs.get("k75", KeyPreferences.keyString(115, 192));
        KeyPreferences.makeKeyStroke("k75", k);
        k = kprefs.get("k76", KeyPreferences.keyString(116, 192));
        KeyPreferences.makeKeyStroke("k76", k);
        k = kprefs.get("k77", KeyPreferences.keyString(117, 192));
        KeyPreferences.makeKeyStroke("k77", k);
        k = kprefs.get("k78", KeyPreferences.keyString(118, 192));
        KeyPreferences.makeKeyStroke("k78", k);
        k = kprefs.get("k79", KeyPreferences.keyString(93, 192));
        KeyPreferences.makeKeyStroke("k79", k);
        k = kprefs.get("k80", KeyPreferences.keyString(123, 0));
        KeyPreferences.makeKeyStroke("k80", k);
        k = kprefs.get("k81", KeyPreferences.keyString(10, 192));
        KeyPreferences.makeKeyStroke("k81", k);
        k = kprefs.get("k82", KeyPreferences.keyString(92, 192));
        KeyPreferences.makeKeyStroke("k82", k);
        k = kprefs.get("k83", KeyPreferences.keyString(119, 192));
        KeyPreferences.makeKeyStroke("k83", k);
        k = kprefs.get("k84", KeyPreferences.keyString(47, 128));
        KeyPreferences.makeKeyStroke("k84", k);
        k = kprefs.get("k85", KeyPreferences.keyString(120, 192));
        KeyPreferences.makeKeyStroke("k85", k);
        k = kprefs.get("k86", KeyPreferences.keyString(85, 192));
        KeyPreferences.makeKeyStroke("k86", k);
        k = kprefs.get("k87", KeyPreferences.keyString(89, 192));
        KeyPreferences.makeKeyStroke("k87", k);
        k = kprefs.get("k88", KeyPreferences.keyString(10, 64));
        KeyPreferences.makeKeyStroke("k88", k);
        k = kprefs.get("k89", KeyPreferences.keyString(123, 192));
        KeyPreferences.makeKeyStroke("k89", k);
        k = kprefs.get("k90", KeyPreferences.keyString(76, 192));
        KeyPreferences.makeKeyStroke("k90", k);
        k = kprefs.get("k92", KeyPreferences.keyString(76, 128));
        KeyPreferences.makeKeyStroke("k92", k);
        k = kprefs.get("k93", KeyPreferences.keyString(69, 128));
        KeyPreferences.makeKeyStroke("k93", k);
        k = kprefs.get("k94", KeyPreferences.keyString(121, 192));
        KeyPreferences.makeKeyStroke("k94", k);
        k = kprefs.get("k95", KeyPreferences.keyString(70, menuShortcutMask | 0x40));
        KeyPreferences.makeKeyStroke("k95", k);
        k = kprefs.get("k96", KeyPreferences.keyString(91, 192));
        KeyPreferences.makeKeyStroke("k96", k);
        k = kprefs.get("k97", KeyPreferences.keyString(84, 640));
        KeyPreferences.makeKeyStroke("k97", k);
        k = kprefs.get("k98", KeyPreferences.keyString(89, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k98", k);
        k = kprefs.get("k99", KeyPreferences.keyString(66, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k99", k);
        k = kprefs.get("k100", KeyPreferences.keyString(73, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k100", k);
        String kk = kprefs.get("k101", KeyPreferences.keyString(85, menuShortcutMask));
        KeyPreferences.makeKeyStroke("k101", kk);
        k = kprefs.get("k43", KeyPreferences.keyString(68, 192));
        if (k != null && k.equals(kk)) {
            k = KeyPreferences.keyString(68, 192);
        }
        KeyPreferences.makeKeyStroke("k43", k);
        kk = kprefs.get("k102", KeyPreferences.keyString(66, 192));
        KeyPreferences.makeKeyStroke("k102", kk);
        k = kprefs.get("k91", KeyPreferences.keyString(77, 192));
        if (k != null && k.equals(kk)) {
            k = KeyPreferences.keyString(77, 192);
        }
        KeyPreferences.makeKeyStroke("k91", k);
        k = kprefs.get("k103", KeyPreferences.keyString(80, 192));
        KeyPreferences.makeKeyStroke("k103", k);
        k = kprefs.get("k104", "");
        KeyPreferences.makeKeyStroke("k104", k);
        k = kprefs.get("k105", "");
        KeyPreferences.makeKeyStroke("k105", k);
        k = kprefs.get("k106", KeyPreferences.keyString(71, 192));
        KeyPreferences.makeKeyStroke("k106", k);
        k = kprefs.get("k107", KeyPreferences.keyString(8, 192));
        KeyPreferences.makeKeyStroke("k107", k);
        k = kprefs.get("k108", KeyPreferences.keyString(70, menuShortcutMask | 0x200));
        KeyPreferences.makeKeyStroke("k108", k);
        k = kprefs.get("k109", KeyPreferences.keyString(75, 192));
        KeyPreferences.makeKeyStroke("k109", k);
        k = kprefs.get("k110", KeyPreferences.keyString(86, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k110", k);
        k = kprefs.get("k111", KeyPreferences.keyString(69, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k111", k);
        k = kprefs.get("k112", KeyPreferences.keyString(72, 192));
        KeyPreferences.makeKeyStroke("k112", k);
        k = kprefs.get("k113", KeyPreferences.keyString(91, 128));
        KeyPreferences.makeKeyStroke("k113", k);
        k = kprefs.get("k114", "");
        KeyPreferences.makeKeyStroke("k114", k);
        k = kprefs.get("k115", "");
        KeyPreferences.makeKeyStroke("k115", k);
        k = kprefs.get("k116", KeyPreferences.keyString(86, 192));
        KeyPreferences.makeKeyStroke("k116", k);
        k = kprefs.get("k117", "");
        KeyPreferences.makeKeyStroke("k117", k);
        k = kprefs.get("k118", KeyPreferences.keyString(65, menuShortcutMask | 0x200));
        KeyPreferences.makeKeyStroke("k118", k);
        k = kprefs.get("k119", KeyPreferences.keyString(82, menuShortcutMask | 0x200));
        KeyPreferences.makeKeyStroke("k119", k);
        k = kprefs.get("k120", KeyPreferences.keyString(76, AppPreferences.modifier));
        KeyPreferences.makeKeyStroke("k120", k);
        k = kprefs.get("k121", "");
        KeyPreferences.makeKeyStroke("k121", k);
        k = kprefs.get("k122", KeyPreferences.keyString(75, 640));
        KeyPreferences.makeKeyStroke("k122", k);
    }

    static void saveKeyPreferences() {
        if (kprefs != null) {
            Set set = keyStrokesMap.keySet();
            for (String s : set) {
                KeyStroke ks = (KeyStroke)keyStrokesMap.get(s);
                int kcode = ks.getKeyCode();
                int mcode = ks.getModifiers();
                kprefs.put(s, Integer.toString(kcode) + " " + Integer.toString(mcode));
            }
        }
    }

    private static void makeKeyStroke(String key, String value) {
        String[] arr = value.split(" ");
        if (arr.length == 2) {
            int k = Integer.parseInt(arr[0]);
            int m = Integer.parseInt(arr[1]);
            KeyStroke ks = KeyStroke.getKeyStroke(k, m);
            keyStrokesMap.put(key, ks);
        }
    }

    private static String keyString(int key, int mod) {
        String s = Integer.toString(key) + " " + Integer.toString(mod);
        return s;
    }

    public static KeyStroke getKeyStroke(String k) {
        KeyStroke s = (KeyStroke)keyStrokesMap.get(k);
        if (s == null || s.getKeyCode() == 27 && s.getModifiers() == 0) {
            return null;
        }
        return s;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb3) {
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            keyStrokesMap.put(this.key, ks);
            if (this.component instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)this.component;
                item.setAccelerator(null);
            }
            this.cancel();
        } else if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            int mod1 = this.modbox.getSelectedIndex();
            int mod2 = this.modbox2.getSelectedIndex();
            Integer keycode = (Integer)this.field.getClientProperty("keycode");
            if (keycode != null) {
                int k = keycode;
                int modcode = 0;
                if (mod1 == 1) {
                    modcode = mod2 == 2 ? 192 : (mod2 == 3 ? 320 : (mod2 == 4 ? 576 : 64));
                } else if (mod1 == 2) {
                    modcode = mod2 == 1 ? 192 : (mod2 == 3 ? 384 : (mod2 == 4 ? 640 : 128));
                } else if (mod1 == 3) {
                    modcode = mod2 == 1 ? 320 : (mod2 == 2 ? 384 : (mod2 == 4 ? 768 : 256));
                } else if (mod1 == 4) {
                    modcode = mod2 == 1 ? 576 : (mod2 == 2 ? 640 : (mod2 == 3 ? 768 : 512));
                }
                KeyStroke ks = KeyStroke.getKeyStroke(keycode, modcode);
                keyStrokesMap.remove(this.key);
                if (!keyStrokesMap.containsValue(ks)) {
                    keyStrokesMap.put(this.key, ks);
                    if (this.component != null && this.component instanceof JMenuItem) {
                        JMenuItem item = (JMenuItem)this.component;
                        item.setAccelerator(ks);
                    }
                } else {
                    if (this.keystroke != null) {
                        keyStrokesMap.put(this.key, this.keystroke);
                    }
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("KEYBOARD SHORTCUT IN USE"));
                    return;
                }
            }
            this.cancel();
        }
    }

    static {
        menuShortcutMask = AppPreferences.getMenuShortcutKeyMask();
    }
}

