/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.FragmentMatch;
import translator.GlossaryResource;
import translator.MainView;
import translator.NumbersHelper;
import translator.ScrollPaneWatermark;
import translator.TabView;
import translator.TargetView;
import translator.TranslateEvent;
import translator.TranslationResult;
import translator.Workflow;
import translator.XMLHelper;
import translator.html.CTHTMLEditorKit;
import translator.tmx.Memory;
import translator.tmx.TMXResult;
import translator.ui.Colors;
import translator.ui.GridPanel;
import translator.ui.HTMLFormat;
import translator.ui.UITools;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffWorkflow;

public class MatchBoard
extends GridPanel {
    private MainView topui;
    private JPopupMenu pop;
    private TabView tabview;
    private JTextPane htmlPane;
    private HashMap matchMap;
    private int matchCount = 0;
    private Map indexButtons;
    private List sortedMatches;
    private List sortedMatches2;
    private TranslateEvent transEvent;
    private List MTResults;
    int mouseX;
    int mouseY;
    private Timer indexBarTimer;

    public MatchBoard(MainView topui) {
        this.topui = topui;
        this.tabview = topui.getTabView();
        this.matchMap = new HashMap();
        this.indexButtons = new HashMap();
        this.sortedMatches = new ArrayList();
        this.MTResults = new ArrayList(5);
        this.topui = topui;
        if (AppPreferences.alpha != -1) {
            this.setOpaque(false);
            this.setGrid(true);
            this.setTransparent(true);
            Color c = new Color(AppPreferences.background);
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), 0);
            this.setBackground(color);
        } else {
            this.setOpaque(true);
            this.setGrid(AppPreferences.backGrid);
            if (AppPreferences.background != 0) {
                this.setBackground(new Color(AppPreferences.background));
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)topui.getIndexBar(), "North");
        this.createHTMLPane();
        this.setMenuSelectionListener();
    }

    private void setMenuSelectionListener() {
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MenuSelectionManager msm = (MenuSelectionManager)evt.getSource();
                MenuElement[] path = msm.getSelectedPath();
                if (path.length > 0) {
                    MatchBoard.this.topui.getResourceView().getGlossaryTip().hideInfo();
                    for (int i = 0; i < path.length; ++i) {
                        int rt;
                        JMenuItem mi;
                        FragmentMatch fm;
                        Component c = path[i].getComponent();
                        if (!(c instanceof JMenuItem) || (fm = (FragmentMatch)(mi = (JMenuItem)c).getClientProperty("match")) == null || (rt = fm.getResourceType()) != 2) continue;
                        int h = fm.getHitsNumber();
                        String n = fm.getResourceName();
                        GlossaryResource g = MatchBoard.this.topui.getResourceView().getGlossary(n);
                        if (g == null) continue;
                        Dimension frmSize = MatchBoard.this.topui.getSize();
                        Point loc = MatchBoard.this.topui.getLocation();
                        int w = frmSize.width / 2;
                        int x = w - w / 2 + loc.x;
                        String ss = "#" + h;
                        MatchBoard.this.topui.getResourceView().getGlossaryTip().showInfo(g, ss, null, x, 0);
                    }
                }
            }
        });
    }

    public void clearMatchBoard() {
        this.pop = null;
        if (!this.MTResults.isEmpty()) {
            this.MTResults.clear();
        }
        if (this.sortedMatches2 != null) {
            this.sortedMatches2.clear();
        }
        this.sortedMatches.clear();
        this.matchMap.clear();
        JToolBar indexBar = this.topui.getIndexBar();
        indexBar.removeAll();
        indexBar.revalidate();
        indexBar.repaint();
        HTMLDocument htmldoc = (HTMLDocument)this.htmlPane.getDocument();
        int n = htmldoc.getDefaultRootElement().getElementCount();
        for (int i = 0; i < n; ++i) {
            int ecount;
            Element elem = htmldoc.getDefaultRootElement().getElement(i);
            if (elem == null || (ecount = elem.getElementCount()) <= 0) continue;
            try {
                htmldoc.setInnerHTML(elem, "<div></div>");
                continue;
            }
            catch (BadLocationException ex) {
                Logger.getLogger(MatchBoard.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(MatchBoard.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void createMatchesTables() {
        StringBuilder sb = new StringBuilder();
        HTMLDocument htmldoc = (HTMLDocument)this.htmlPane.getDocument();
        sb.append(HTMLFormat.startHTML);
        sb.append(HTMLFormat.matchboardStyles);
        sb.append(HTMLFormat.startBody);
        sb.append("</body></html>");
        try {
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), sb.toString());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(MatchBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MatchBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        sb.setLength(0);
        if (AppPreferences.aiServices != -1) {
            sb.append("<table id=ChatGPT width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
            sb.append("<table id=Claude width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
            sb.append("<table id=Gemini width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
            sb.append("<table id=Mistral width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
            sb.append("<table id=DeepSeek width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
            sb.append("<table id=Grok width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (AppPreferences.mt6 != -1) {
            sb.append("<table id=DeepL width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (AppPreferences.mt != -1) {
            sb.append("<table id=Google width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (AppPreferences.mt2 != -1) {
            sb.append("<table id=Bing width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (AppPreferences.mt3 != -1) {
            sb.append("<table id=MyMemory width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (AppPreferences.mt5 != -1) {
            sb.append("<table id=Yandex width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (AppPreferences.mt7 != -1) {
            sb.append("<table id=Watson width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (AppPreferences.mt8 != -1) {
            sb.append("<table id=Amazon width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (AppPreferences.mt4 != -1) {
            sb.append("<table id=SlateDesktop width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        }
        if (sb.length() == 0) {
            sb.append("<table id=Matches width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        } else if (!AppPreferences.matchBoardShowMTLast) {
            sb.append("<table id=Matches width=100% CELLPADDING=6 CELLSPACING=0>");
            sb.append("</table>");
        } else {
            StringBuffer sb2 = new StringBuffer();
            sb2.append("<table id=Matches width=100% CELLPADDING=6 CELLSPACING=0>");
            sb2.append("</table>");
            sb.insert(0, sb2);
        }
        try {
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), sb.toString());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(MatchBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MatchBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setMatchboardFont(Font font) {
        this.clearMatchBoard();
        this.htmlPane.setFont(font);
        this.createMatchesTables();
    }

    private void createHTMLPane() {
        File file;
        this.htmlPane = new JTextPane();
        this.htmlPane.setName("Matchboard");
        this.htmlPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.htmlPane.setContentType("text/html");
        this.htmlPane.putClientProperty("type", "project");
        Graphics g = this.htmlPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        Color pbackground = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            pbackground = new Color(AppPreferences.background);
            Color pforeground = new Color(AppPreferences.foreground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.pBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.htmlPane.setCaretColor(pforeground);
            this.htmlPane.setBackground(pbackground);
            this.htmlPane.setForeground(pforeground);
            this.htmlPane.setSelectedTextColor(pforeground);
            this.htmlPane.setSelectionColor(selection);
        }
        this.htmlPane.setFont(new Font(AppPreferences.mbfontname, AppPreferences.mbfontstyle, AppPreferences.mbfontsize));
        this.htmlPane.addHyperlinkListener(new MatchesHyperactive());
        this.htmlPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MatchBoard.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.htmlPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    MatchBoard.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    MatchBoard.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    JTextPane pane;
                    String sel;
                    boolean ctrl = UITools.isShortcutDown(evt);
                    if (!ctrl && (sel = (pane = (JTextPane)evt.getSource()).getSelectedText()) != null && sel.length() < 300) {
                        int cc = evt.getClickCount();
                        if (cc < 2 && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                            try {
                                int spos = Utilities.getWordStart(MatchBoard.this.htmlPane, MatchBoard.this.htmlPane.getSelectionStart());
                                int epos = Utilities.getWordEnd(MatchBoard.this.htmlPane, MatchBoard.this.htmlPane.getSelectionEnd() - 1);
                                MatchBoard.this.htmlPane.setSelectionStart(spos);
                                MatchBoard.this.htmlPane.setSelectionEnd(epos);
                                sel = MatchBoard.this.htmlPane.getSelectedText();
                            }
                            catch (BadLocationException ex) {
                                ex.printStackTrace();
                            }
                        }
                        TargetView tview = MatchBoard.this.topui.getTargetView();
                        tview.grabSelection(sel);
                    }
                }
            }
        });
        this.htmlPane.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                MatchBoard.this.mouseX = evt.getX();
                MatchBoard.this.mouseY = evt.getY();
            }
        });
        this.htmlPane.setEditable(false);
        JScrollPane sourceScroll = new JScrollPane(this.htmlPane);
        if (pbackground != null) {
            sourceScroll.setBackground(pbackground);
        }
        sourceScroll.setOpaque(false);
        sourceScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        sourceScroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            sourceScroll.getViewport().setOpaque(false);
            this.htmlPane.setBackground(new Color(0, 0, 0, 0));
            this.htmlPane.setOpaque(false);
        }
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.htmlPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.htmlPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.add((Component)sourceScroll, "Center");
        this.tabview.addTab(this, "Matchboard", null);
    }

    public synchronized void setMTMatch(String target, String id, String type) {
        if (AppPreferences.matchBoardShowMT) {
            String[] unit = new String[4];
            unit[1] = target;
            unit[2] = null;
            unit[3] = type;
            this.matchMap.put(this.matchCount, unit);
            StringBuilder htmlMB = new StringBuilder();
            htmlMB.append("<tr>");
            if (AppPreferences.matchBoardShortMatchInfo) {
                if (type.equals("MT")) {
                    htmlMB.append("<td align=right valign=top style='color:#FFFFFF; background-color:").append(Colors.colorMTHTML).append("'>").append(id).append("</td>");
                } else {
                    htmlMB.append("<td align=right valign=top style='color:#FFFFFF; background-color:").append(Colors.colorAIHTML).append("'>").append(id).append("</td>");
                }
            } else if (type.equals("MT")) {
                htmlMB.append("<td align=right valign=top style='min-width:200px; color:#FFFFFF; background-color:").append(Colors.colorMTHTML).append("'>").append(id).append("</td>");
            } else {
                htmlMB.append("<td align=right valign=top style='min-width:200px; color:#FFFFFF; background-color:").append(Colors.colorAIHTML).append("'>").append(id).append("</td>");
            }
            htmlMB.append("</tr>");
            htmlMB.append("<tr>");
            if (AppPreferences.matchBoardShortMatchInfo) {
                htmlMB.append("<TD BORDER=0 VALIGN=CENTER ALIGN=LEFT style='border-width: 1px; border-style: solid; border-color:" + HTMLFormat.barBackgroundColor + "'>");
            } else {
                htmlMB.append("<TD BORDER=0 VALIGN=CENTER ALIGN=LEFT style='border-width: 1px; border-style: solid; border-color:" + HTMLFormat.barBackgroundColor + "'>");
            }
            htmlMB.append("<p><a class=\"altHref\" href=\"#").append(this.matchCount).append("\">").append(target).append("</a></p>");
            htmlMB.append("</td>");
            htmlMB.append("</tr>");
            ++this.matchCount;
            this.setMatch(htmlMB.toString(), id);
            String[] mts = new String[]{target, id, type};
            this.MTResults.add(mts);
        }
    }

    public List getMTResultsList() {
        return this.MTResults;
    }

    public void resetMTMatches(List mtr) {
        if (AppPreferences.matchBoardShowMT && !mtr.isEmpty()) {
            for (String[] next : mtr) {
                String target = next[0];
                String id = next[1];
                String type = next[2];
                String[] unit = new String[4];
                unit[1] = target;
                unit[2] = null;
                unit[3] = type;
                this.matchMap.put(this.matchCount, unit);
                StringBuilder htmlMB = new StringBuilder();
                htmlMB.append("<tr>");
                if (AppPreferences.matchBoardShortMatchInfo) {
                    htmlMB.append("<td align=right valign=top style='color:#FFFFFF; background-color:").append(Colors.colorMTHTML).append("'>").append(id).append("</td>");
                } else {
                    htmlMB.append("<td align=right valign=top style='color:#FFFFFF; background-color:").append(Colors.colorMTHTML).append("'>").append(id).append("</td>");
                }
                htmlMB.append("</tr>");
                htmlMB.append("<tr>");
                if (AppPreferences.matchBoardShortMatchInfo) {
                    htmlMB.append("<TD BORDER=0 VALIGN=CENTER ALIGN=LEFT style='border-width: 1px; border-style: solid; border-color:" + HTMLFormat.barBackgroundColor + "'>");
                } else {
                    htmlMB.append("<TD BORDER=0 VALIGN=CENTER ALIGN=LEFT style='border-width: 1px; border-style: solid; border-color:" + HTMLFormat.barBackgroundColor + "'>");
                }
                htmlMB.append("<a class=\"altHref\" href=\"#").append(this.matchCount).append("\">").append(target).append("</a>");
                htmlMB.append("</td>");
                htmlMB.append("</tr>");
                ++this.matchCount;
                this.setMatch(htmlMB.toString(), id);
            }
        }
    }

    public synchronized void setMatch(String htmlMatch, String id) {
        HTMLDocument htmldoc = (HTMLDocument)this.htmlPane.getDocument();
        try {
            Element elem = htmldoc.getElement(id);
            if (elem != null) {
                htmldoc.setInnerHTML(elem, htmlMatch);
                this.htmlPane.setCaretPosition(0);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(MatchBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MatchBoard.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List getSortedMatches() {
        return this.sortedMatches;
    }

    private void setSortedMatches(TranslateEvent event) {
        TranslationResult tr = event.getTranslationResult();
        Map matchesMap = tr.getMatchesMap();
        if (matchesMap != null && !matchesMap.isEmpty()) {
            Set set = matchesMap.keySet();
            this.sortedMatches = new ArrayList(set);
            if (!AppPreferences.noWordSeparatorSourceLanguage && AppPreferences.matchBoardSort != 3) {
                final Collator usCollator = Collator.getInstance(this.topui.getProjectView().getProjectLocale());
                usCollator.setStrength(0);
                Collections.sort(this.sortedMatches, new Comparator(){
                    final /* synthetic */ MatchBoard this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public int compare(Object o1, Object o2) {
                        String s1 = o1.toString();
                        String s2 = o2.toString();
                        return usCollator.compare(s1, s2);
                    }
                });
            } else {
                final String s = event.getMemoryLookupTextCleaned();
                if (s != null && s.length() > 0) {
                    Collections.sort(this.sortedMatches, new Comparator(){
                        final /* synthetic */ MatchBoard this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public int compare(Object o1, Object o2) {
                            String s1 = o1.toString();
                            String s2 = o2.toString();
                            if (AppPreferences.noWordSeparatorSourceLanguage) {
                                Integer i1 = s.indexOf(s1.charAt(0));
                                Integer i2 = s.indexOf(s2.charAt(0));
                                return i1.compareTo(i2);
                            }
                            Integer i1 = s.indexOf(s1);
                            Integer i2 = s.indexOf(s2);
                            return i1.compareTo(i2);
                        }
                    });
                }
            }
            if (AppPreferences.matchBoardSort == 1 || AppPreferences.matchBoardSort == 2) {
                this.sortedMatches2 = new ArrayList(set);
                if (AppPreferences.matchBoardSort == 2) {
                    Collections.sort(this.sortedMatches2, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            Integer i1 = o1.toString().length();
                            Integer i2 = o2.toString().length();
                            return i2.compareTo(i1);
                        }
                    });
                }
            }
        }
    }

    public void showMatches(TranslateEvent event) {
        this.transEvent = event;
        this.setSortedMatches(event);
        String matches = this.createCTMatchesHTML(event);
        if (!AppPreferences.hideMatchIndexBar) {
            this.updateIndexBar();
        }
        this.setMatch(matches, "Matches");
        this.topui.getMemoryView().insertBestAutoMatch(event);
        this.topui.getTargetView().setCafeTranTargetTextExternal();
    }

    private String createCTMatchesHTML(TranslateEvent event) {
        String res;
        TranslationResult tr = event.getTranslationResult();
        String[] aaResult = tr.getAAResult();
        Object[] fuzzyResult = tr.getFuzzyResult();
        Map matchesMap = tr.getMatchesMap();
        int autoaccuracy = tr.getAAAccuracy();
        if (autoaccuracy == 101) {
            autoaccuracy = 100;
        }
        int contextaccuracy = tr.getContextAccuracy();
        int aaResultLength = 0;
        StringBuilder sb = new StringBuilder();
        if (aaResult != null && (res = aaResult[1]) != null && res.trim().length() > 0) {
            String acc;
            String p;
            String name;
            String percent;
            String type;
            if (contextaccuracy > 100) {
                type = "EM";
                percent = Integer.toString(contextaccuracy);
                if (AppPreferences.matchBoardShortMatchInfo) {
                    name = "CM";
                    p = percent;
                } else {
                    p = percent + "%";
                    name = "Context";
                }
                acc = "<td colspan=\"4\" align=right valign=top style='color:#FFFFFF; background-color:" + Colors.colorMemoryContextMatchHTML + "'>" + name + " " + p + "</td>";
            } else if (contextaccuracy == 100) {
                type = "EM";
                percent = Integer.toString(contextaccuracy);
                if (AppPreferences.matchBoardShortMatchInfo) {
                    name = "EM";
                    p = percent;
                } else {
                    name = "Exact";
                    p = percent + "%";
                }
                acc = "<td colspan=\"4\" align=right valign=top style='color:#FFFFFF; background-color:" + Colors.colorMemoryExactMatchHTML + "'>" + name + " " + p + "</td>";
            } else {
                type = "CT";
                percent = Integer.toString(autoaccuracy);
                if (AppPreferences.matchBoardShortMatchInfo) {
                    name = "CT";
                    p = percent;
                } else {
                    name = "Assembled";
                    p = percent + "%";
                }
                acc = "<td colspan=\"4\" align=right valign=top style='color:#FFFFFF; background-color:" + Colors.colorTRHTML + "'>" + name + " " + p + "</td>";
            }
            if (contextaccuracy > 99 || AppPreferences.matchBoardShowAA) {
                String m = aaResult[0];
                String m2 = aaResult[1];
                aaResultLength = m2.length();
                String[] unit = new String[4];
                unit[1] = m2;
                unit[2] = percent;
                unit[3] = type;
                this.matchMap.put(this.matchCount, unit);
                sb.append("<tr>").append(acc).append("</tr>");
                sb.append("<tr><td width=100% colspan=\"4\" style='border-width: 1px; border-style: solid; border-color:" + HTMLFormat.barBackgroundColor + "'><p><a class=\"altHref\" href=\"#").append(this.matchCount).append("\">").append(m).append("</a>").append("</p></td>").append("</tr>");
                ++this.matchCount;
            }
        }
        if (AppPreferences.matchBoardShowFuzzySegments) {
            for (int i = 0; i < fuzzyResult.length; ++i) {
                String tmDisplayName;
                Object object = fuzzyResult[i];
                if (object == null) continue;
                Object[] arr = (Object[])object;
                Integer oi = (Integer)arr[0];
                boolean ac = (Boolean)arr[13];
                int pro = oi;
                String proc = Integer.toString(pro);
                String p = !AppPreferences.matchBoardShortMatchInfo ? proc + "%" : proc;
                if (ac) {
                    p = "!" + p;
                }
                String fuzzyEntry = (String)arr[2];
                boolean pref = (Boolean)arr[4];
                String tmName = (String)arr[8];
                int index = (Integer)arr[9];
                String fuzzyKeyHTML = (String)arr[10];
                String[] unit = new String[4];
                unit[1] = fuzzyEntry;
                unit[2] = proc;
                unit[3] = "FM";
                this.matchMap.put(this.matchCount, unit);
                if (AppPreferences.matchBoardShortMatchInfo && tmName.length() > 2) {
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append(tmName.charAt(0));
                    sb2.append(tmName.charAt(tmName.length() - 1));
                    tmDisplayName = sb2.toString();
                } else {
                    tmDisplayName = tmName;
                    if (tmDisplayName.length() > 10) {
                        tmDisplayName = tmDisplayName.substring(0, 7) + "...";
                    }
                }
                sb.append("<tr>");
                sb.append("<td colspan=\"4\" align=right valign=top style='color:#FFFFFF; background-color:#D35400'>").append(tmDisplayName).append(" <a style=\"color:yellow\" href=\"$").append(tmName).append(':').append(i).append("=").append(index).append("\">").append(p).append("</a>").append("</td>");
                sb.append("</tr>");
                if (AppPreferences.matchBoardShowFuzzySourceSegments) {
                    sb.append("<tr>");
                    sb.append("<td width=100% colspan=\"4\" style='border-width: 1px; border-style: solid; border-color:" + HTMLFormat.barBackgroundColor + "'>");
                    if (!pref) {
                        sb.append("<p>");
                        sb.append(fuzzyKeyHTML);
                        sb.append("</p>");
                    }
                    sb.append("</td>");
                    sb.append("</tr>");
                }
                sb.append("<tr>");
                sb.append("<td width=100% colspan=\"4\" style='border-width: 1px; border-style: solid; border-color:" + HTMLFormat.barBackgroundColor + "'>");
                sb.append("<p><a class=\"altHref\" href=\"#").append(this.matchCount).append("\">").append(fuzzyEntry).append("</a></p>");
                sb.append("</td>");
                sb.append("</tr>");
                ++this.matchCount;
            }
        }
        List matches = this.sortedMatches2 != null ? this.sortedMatches2 : this.sortedMatches;
        int maxLen = 100;
        if ((AppPreferences.matchBoardShowTerms || AppPreferences.matchBoardShowFragments) && !matches.isEmpty() && matchesMap != null) {
            Iterator it = matches.iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                int sourceLen = key.length();
                Set targets = (Set)matchesMap.get(key);
                if (targets == null) continue;
                for (FragmentMatch fmatch : targets) {
                    int id;
                    TMXResult result;
                    String[] extaFields;
                    String h;
                    int rt;
                    String resourceName;
                    String value = fmatch.getTarget();
                    if (AppPreferences.matchBoardShortMatchInfo) {
                        resourceName = fmatch.getShortResourceName();
                        if (resourceName == null) {
                            resourceName = "New";
                        }
                    } else {
                        resourceName = fmatch.getResourceName();
                        if (resourceName == null) {
                            resourceName = "New";
                        } else if (resourceName.length() > 15) {
                            resourceName = resourceName.substring(0, 12) + "...";
                        }
                    }
                    if ((rt = fmatch.getResourceType()) == 2 && !AppPreferences.matchBoardShowTerms || rt == 1 && !AppPreferences.matchBoardShowFragments && !fmatch.isSegmentMatch()) continue;
                    String matchType = AppPreferences.matchBoardShortMatchInfo ? fmatch.getShortMatchType() : fmatch.getMatchType();
                    int w = fmatch.getWeight();
                    if (w < 3 && rt == 1 && !AppPreferences.matchBoardShowFuzzyFragments || w < 3 && rt > 1 && !AppPreferences.matchBoardShowFuzzyTerms) continue;
                    String border = w > 2 ? (sourceLen < maxLen ? HTMLFormat.defaultRowLeftAlign2 : HTMLFormat.FMLeftCol2) : (sourceLen < maxLen ? HTMLFormat.defaultRowLeftAlign2 : HTMLFormat.FMLeftCol2);
                    if (rt == 1) {
                        if (fmatch.isSegmentMatch()) {
                            if (aaResultLength == value.length()) continue;
                            if (fmatch.getContexLevel() == 1) {
                                if (contextaccuracy > 100) continue;
                                h = Colors.colorMemoryContextMatchHTML;
                            } else {
                                h = Colors.colorMemoryExactMatchHTML;
                            }
                        } else {
                            h = Colors.colorMemoryHTML;
                        }
                    } else {
                        h = rt == 2 ? Colors.colorGlossaryHTML : Colors.colorResourcesHTML;
                    }
                    String[] unit = new String[]{key, value, null, "FR"};
                    this.matchMap.put(this.matchCount, unit);
                    StringBuilder htmlValue = new StringBuilder();
                    htmlValue.append("<p><a class=\"altHref\" href=\"#").append(this.matchCount).append("\">").append(value).append("</a></p>");
                    if (AppPreferences.matchBoardShowGlossaryFields && rt == 2 && (extaFields = fmatch.getFields()) != null) {
                        String extraField;
                        for (int i = 0; i < extaFields.length && (extraField = extaFields[i]) != null; ++i) {
                            if (extraField.length() <= 0) continue;
                            htmlValue.append("<p><i>").append(extraField).append("</i></p>");
                        }
                    }
                    sb.append("<tr>").append(border);
                    if (rt == 1) {
                        result = fmatch.getTMResult();
                        int mt = fmatch.getMatchTypeInt();
                        if (result != null && (mt == 1 || mt == 4)) {
                            String rn = fmatch.getResourceName();
                            int i = fmatch.getResultID();
                            int[][] tuids = result.getTUIds();
                            id = tuids[i][0];
                            int priority = fmatch.getPriority();
                            StringBuilder link = new StringBuilder();
                            link.append("<a style=\"color:yellow\" href=\"$").append(rn).append(':').append(i).append("=").append(id).append("\">").append(matchType).append("</a>");
                            if (priority == 0 || priority == 2) {
                                if (priority == 0) {
                                    link.append(HTMLFormat.subStartPriortyLow);
                                    link.append("Low");
                                } else if (priority == 2) {
                                    link.append(HTMLFormat.subStartPriortyHigh);
                                    link.append("High");
                                }
                                link.append(HTMLFormat.subEnd);
                            }
                            matchType = link.toString();
                        }
                    } else if (rt == 2) {
                        String rn = fmatch.getResourceName();
                        int hit = fmatch.getHitsNumber();
                        int priority = fmatch.getPriority();
                        StringBuilder link = new StringBuilder();
                        link.append("<a style=\"color:yellow\" href=\"%").append(rn).append(':').append(hit).append("\">").append(matchType).append("</a>");
                        if (priority == 0 || priority == 2) {
                            if (priority == 0) {
                                link.append(HTMLFormat.subStartPriortyLow);
                                link.append("Low");
                            } else if (priority == 2) {
                                link.append(HTMLFormat.subStartPriortyHigh);
                                link.append("High");
                            }
                            link.append(HTMLFormat.subEnd);
                        }
                        matchType = link.toString();
                    }
                    sb.append("<p>");
                    sb.append(key);
                    sb.append("</p>");
                    sb.append("</td>");
                    if (sourceLen < maxLen) {
                        sb.append(border).append((CharSequence)htmlValue).append("</td><td nowrap valign=top style=\"color:#FFFFFF; background-color:" + h + "\" align=left>").append(matchType).append("</td><td nowrap valign=top style=\"color:#FFFFFF; background-color:" + h + "\" align=left>").append(resourceName).append("</td>");
                    } else {
                        sb.append("<td nowrap valign=top style=\"color:#FFFFFF; background-color:" + h + "\" align=left>").append("</td><td nowrap valign=top style=\"color:#FFFFFF; background-color:" + h + "\" align=left>").append("</td></tr><tr>").append(border).append((CharSequence)htmlValue).append("</td><td nowrap valign=top style=\"color:#FFFFFF; background-color:" + h + "\" align=left>").append(matchType).append("</td><td nowrap valign=top style=\"color:#FFFFFF; background-color:" + h + "\" align=left>").append(resourceName).append("</td>");
                    }
                    sb.append("</tr>");
                    if (AppPreferences.matchBoardShowHitNumbers && rt == 1 && fmatch.getMatchTypeInt() == 3 && (result = fmatch.getTMResult()) != null) {
                        sb.append("<tr><td COLSPAN=4 style=\"color:#FFFFFF; background-color:" + h + "\" align=left>");
                        String rn = fmatch.getResourceName();
                        int i = fmatch.getResultID();
                        int[][] tuids = result.getTUIds();
                        for (int j = 0; j < 10 && tuids[i][j] != 0; ++j) {
                            id = tuids[i][j];
                            int k = j + 1;
                            if (j > 0) {
                                sb.append("&nbsp;");
                                sb.append("&nbsp;");
                                sb.append("|");
                                sb.append("&nbsp;");
                                sb.append("&nbsp;");
                            }
                            sb.append("<a style=\"color:yellow\" href=\"$").append(rn).append(':').append(i).append("=").append(id).append("\">").append(k).append("</a>");
                        }
                        sb.append("</td>");
                        sb.append("</tr>");
                    }
                    ++this.matchCount;
                }
            }
        }
        String s = sb.toString();
        return s;
    }

    public void updateIndexBar() {
        JToolBar ibar = this.topui.getIndexBar();
        if (!this.sortedMatches.isEmpty()) {
            String prev = null;
            Iterator it = this.sortedMatches.iterator();
            while (it.hasNext()) {
                JButton button;
                String key = it.next().toString().trim();
                if (key.length() <= 0) continue;
                String A = key.substring(0, 1).toUpperCase();
                if (prev != null && A.equals(prev)) continue;
                prev = A;
                Object o = this.indexButtons.get(A);
                if (o != null) {
                    button = (JButton)o;
                } else {
                    button = new JButton(A);
                    button.setFont(button.getFont().deriveFont(1, AppPreferences.toolBarButtonsFontSize));
                    button.setPreferredSize(new Dimension(50, button.getPreferredSize().height));
                    button.setMinimumSize(new Dimension(50, button.getPreferredSize().height));
                    button.setMaximumSize(new Dimension(50, button.getPreferredSize().height));
                    button.setOpaque(false);
                    button.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, Color.WHITE));
                    button.setForeground(new Color(AppPreferences.toolBarsForeground));
                    button.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (MatchBoard.this.indexBarTimer != null) {
                                MatchBoard.this.indexBarTimer.stop();
                            }
                            JButton but = (JButton)e.getSource();
                            int x = e.getX() - 40;
                            int y = e.getY() + 40;
                            MatchBoard.this.topui.getTargetView().showMatchesPopUp(but, x, y, but.getText().substring(0, 1));
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            int delay = 250;
                            final int x = e.getX() - 40;
                            final int y = e.getY() + 40;
                            final JButton but = (JButton)e.getSource();
                            ActionListener taskPerformer = new ActionListener(){
                                final /* synthetic */ 8 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void actionPerformed(ActionEvent evt) {
                                    this.this$1.MatchBoard.this.topui.getTargetView().showMatchesPopUp(but, x, y, but.getText().substring(0, 1));
                                }
                            };
                            MatchBoard.this.indexBarTimer = new Timer(delay, taskPerformer);
                            MatchBoard.this.indexBarTimer.setRepeats(false);
                            MatchBoard.this.indexBarTimer.start();
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            if (MatchBoard.this.indexBarTimer != null) {
                                MatchBoard.this.indexBarTimer.stop();
                            }
                        }
                    });
                    this.indexButtons.put(A, button);
                }
                ibar.add(button);
            }
        }
        ibar.revalidate();
        ibar.repaint();
    }

    public String transferSegmentTags(String sourceSegment, String targetSegment, TranslateEvent event) {
        List plist;
        Workflow wf;
        List matches = this.sortedMatches2 != null ? this.sortedMatches2 : this.sortedMatches;
        HashSet tags = new HashSet();
        HashMap tagMap = new HashMap(8);
        String sourceSegment2 = XMLHelper.shrinkTags(sourceSegment, tagMap);
        String sourceSegmentLowerCase = sourceSegment.toLowerCase();
        if (tagMap.isEmpty()) {
            return targetSegment;
        }
        boolean tagTransfer = false;
        TranslationResult tr = event.getTranslationResult();
        if (tr != null) {
            Map matchesMap = tr.getMatchesMap();
            if (!matches.isEmpty() && matchesMap != null) {
                Iterator it = matches.iterator();
                block0: while (it.hasNext()) {
                    String key = it.next().toString();
                    if (sourceSegmentLowerCase.indexOf(key.toLowerCase()) == -1) continue;
                    Set targets = (Set)matchesMap.get(key);
                    for (FragmentMatch fmatch : targets) {
                        String value2;
                        String value = fmatch.getTarget();
                        int valueIndex = targetSegment.toLowerCase().indexOf(value.toLowerCase());
                        if (valueIndex == -1 || tagMap.isEmpty() || (value2 = this.transferTags(0, sourceSegment2, key, value, tagMap, tags, true)).length() <= value.length()) continue;
                        targetSegment = targetSegment.substring(0, valueIndex) + value2 + targetSegment.substring(valueIndex + value.length());
                        tagTransfer = true;
                        continue block0;
                    }
                }
            }
        }
        if ((wf = this.topui.getWorkflowView().getWorkflowManager().getWorkflow()) != null && (plist = wf.getPlaceables()) != null && plist.size() > 0) {
            int offset = 0;
            int offsetSource = 0;
            int offsetSource2 = 0;
            int offsetTarget = 0;
            Iterator it = plist.iterator();
            while (it.hasNext()) {
                String value2;
                char c;
                Object[] o = (Object[])it.next();
                String key = o[1].toString();
                int len = key.length();
                int off = (Integer)o[0];
                if (off + len <= offset) {
                    it.remove();
                    continue;
                }
                offset = off + len;
                int i = sourceSegment.indexOf(key, offsetSource);
                int j = sourceSegment2.indexOf(key, offsetSource2);
                if (i == -1 || j == -1) continue;
                int valueIndex = targetSegment.indexOf(key, offsetTarget);
                while (valueIndex > 1 && (c = targetSegment.charAt(valueIndex - 1)) == 'x') {
                    valueIndex = targetSegment.indexOf(key, valueIndex + key.length());
                }
                if (valueIndex == -1 || (value2 = this.transferTags(offsetSource2, sourceSegment2, key, key, tagMap, tags, true)).length() <= key.length()) continue;
                targetSegment = targetSegment.substring(0, valueIndex) + value2 + targetSegment.substring(valueIndex + key.length());
                tagTransfer = true;
                offsetSource = i + key.length();
                offsetSource2 = j + key.length();
                offsetTarget = valueIndex + value2.length();
            }
        }
        if (tagTransfer) {
            targetSegment = XMLHelper.trimSpace(targetSegment);
        }
        return targetSegment;
    }

    public String matchHiddenNontranslatables(String targetSegment) {
        XLIFF xliff = this.topui.getProjectView().getProject().getXLIFF();
        if (xliff != null) {
            int k = 0;
            XliffWorkflow xw = xliff.getWorkflow();
            ArrayList hntags = xw.getHiddenNontranslatableTags();
            for (String[] next : hntags) {
                String s;
                int i;
                String nt = next[0];
                if (k >= targetSegment.length() || (i = targetSegment.indexOf(nt, k)) == -1) continue;
                String tag = AppPreferences.autotags ? next[1] : "";
                targetSegment = s = targetSegment.substring(0, i) + tag + targetSegment.substring(i + nt.length());
                k = i + tag.length();
            }
        }
        return targetSegment;
    }

    public String matchHiddenNontranslatablesOld(String targetSegment) {
        XLIFF xliff = this.topui.getProjectView().getProject().getXLIFF();
        if (xliff != null) {
            XliffWorkflow xw = xliff.getWorkflow();
            ArrayList hntags = xw.getHiddenNontranslatableTags();
            block0: for (String[] next : hntags) {
                String nt = next[0];
                int i = targetSegment.indexOf(nt);
                if (i == -1) continue;
                String tag = next[1];
                List plist = this.topui.getWorkflowView().getWorkflowManager().getWorkflow().getTags();
                if (plist == null) continue;
                for (Object[] o : plist) {
                    String s;
                    String key = o[1].toString();
                    if (key.indexOf(tag) == -1) continue;
                    targetSegment = s = targetSegment.substring(0, i) + key + targetSegment.substring(i + nt.length());
                    continue block0;
                }
            }
        }
        return targetSegment;
    }

    public String transferTags(int offset, String sourceSegment, String sourceFr, String targetFr, HashMap tagMap, Set tags, boolean addTags) {
        sourceSegment = sourceSegment.toLowerCase();
        sourceFr = sourceFr.toLowerCase();
        int i = sourceSegment.indexOf(sourceFr, offset);
        while (i != -1) {
            char c;
            int k;
            int m;
            char c2;
            boolean hasTag = false;
            if (i > 4 && (c2 = sourceSegment.charAt(i - 1)) == '>') {
                int j = 4;
                char c22 = sourceSegment.charAt(i - j);
                if (c22 != '<' && i > 5) {
                    c22 = sourceSegment.charAt(i - ++j);
                }
                if (c22 == '<') {
                    String stag = sourceSegment.substring(i - j, i);
                    if (tags == null || !tags.contains(stag)) {
                        String ltag;
                        if (addTags && tags != null) {
                            tags.add(stag);
                        }
                        if ((ltag = (String)tagMap.get(stag)) != null) {
                            targetFr = ltag + targetFr;
                            hasTag = true;
                        }
                    }
                }
            }
            if ((m = (k = i + sourceFr.length()) + 3) < sourceSegment.length() && (c = sourceSegment.charAt(k)) == '<') {
                char c23 = sourceSegment.charAt(m);
                if (c23 != '>' && m + 1 < sourceSegment.length()) {
                    c23 = sourceSegment.charAt(++m);
                }
                if (c23 == '>') {
                    String stag = sourceSegment.substring(k, m + 1);
                    if (tags == null || !tags.contains(stag)) {
                        String ltag;
                        if (addTags && tags != null) {
                            tags.add(stag);
                        }
                        if ((ltag = (String)tagMap.get(stag)) != null) {
                            targetFr = targetFr + ltag;
                            hasTag = true;
                        }
                    }
                }
            }
            if (hasTag) break;
            i = sourceSegment.indexOf(sourceFr, i + sourceFr.length());
        }
        return targetFr;
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        String text = !AppPreferences.noWordSeparatorSourceLanguage ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SORT MATCHES ALPHABETICALLY") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SORT MATCHES BY ORDER IN SEGMENT");
        JRadioButtonMenuItem radio1 = new JRadioButtonMenuItem(text);
        if (AppPreferences.matchBoardSort == 0) {
            radio1.setSelected(true);
        } else if (AppPreferences.matchBoardSort == 3 && AppPreferences.noWordSeparatorSourceLanguage) {
            radio1.setSelected(true);
        }
        radio1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.matchBoardSort = 0;
                    MatchBoard.this.sortedMatches2 = null;
                }
            }
        });
        this.pop.add(radio1);
        JRadioButtonMenuItem radio2 = new JRadioButtonMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SORT MATCHES BY QUALITY"));
        if (AppPreferences.matchBoardSort == 1) {
            radio2.setSelected(true);
        }
        radio2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.matchBoardSort = 1;
                    MatchBoard.this.sortedMatches2 = new ArrayList();
                }
            }
        });
        this.pop.add(radio2);
        JRadioButtonMenuItem radio3 = new JRadioButtonMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SORT MATCHES BY LENGTH"));
        if (AppPreferences.matchBoardSort == 2) {
            radio3.setSelected(true);
        }
        radio3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.matchBoardSort = 2;
                    MatchBoard.this.sortedMatches2 = new ArrayList();
                }
            }
        });
        this.pop.add(radio3);
        JRadioButtonMenuItem radio4 = null;
        if (!AppPreferences.noWordSeparatorSourceLanguage) {
            radio4 = new JRadioButtonMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SORT MATCHES BY ORDER IN SEGMENT"));
            if (AppPreferences.matchBoardSort == 3) {
                radio4.setSelected(true);
            }
            radio4.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AppPreferences.matchBoardSort = 3;
                        MatchBoard.this.sortedMatches2 = null;
                    }
                }
            });
            this.pop.add(radio4);
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(radio1);
        bg.add(radio2);
        bg.add(radio3);
        if (radio4 != null) {
            bg.add(radio4);
        }
        this.pop.addSeparator();
        JCheckBoxMenuItem item5 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW MACHINE TRANSLATION"));
        item5.setSelected(AppPreferences.matchBoardShowMT);
        item5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowMT = e.getStateChange() == 1;
            }
        });
        this.pop.add(item5);
        JCheckBoxMenuItem item55 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MACHINE TRANSLATION SHOWN LAST"));
        item55.setSelected(AppPreferences.matchBoardShowMTLast);
        item55.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowMTLast = e.getStateChange() == 1;
                MatchBoard.this.createMatchesTables();
            }
        });
        this.pop.add(item55);
        JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW AUTO-ASSEMBLING RESULT"));
        item2.setSelected(AppPreferences.matchBoardShowAA);
        item2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowAA = e.getStateChange() == 1;
            }
        });
        this.pop.add(item2);
        JCheckBoxMenuItem itemFuzzySegments = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW FUZZY MEMORY SEGMENTS"));
        itemFuzzySegments.setSelected(AppPreferences.matchBoardShowFuzzySegments);
        itemFuzzySegments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowFuzzySegments = e.getStateChange() == 1;
            }
        });
        this.pop.add(itemFuzzySegments);
        this.pop.addSeparator();
        JCheckBoxMenuItem item8 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW GLOSSARY TERMS"));
        item8.setSelected(AppPreferences.matchBoardShowTerms);
        item8.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowTerms = e.getStateChange() == 1;
            }
        });
        this.pop.add(item8);
        JCheckBoxMenuItem item9 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW MEMORY FRAGMENTS"));
        item9.setSelected(AppPreferences.matchBoardShowFragments);
        item9.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowFragments = e.getStateChange() == 1;
            }
        });
        this.pop.add(item9);
        JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW FUZZY MEMORY FRAGMENTS"));
        item3.setSelected(AppPreferences.matchBoardShowFuzzyFragments);
        item3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowFuzzyFragments = e.getStateChange() == 1;
            }
        });
        this.pop.add(item3);
        JCheckBoxMenuItem itemHits = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW MEMORY HITS"));
        itemHits.setSelected(AppPreferences.matchBoardShowHitNumbers);
        itemHits.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowHitNumbers = e.getStateChange() == 1;
            }
        });
        this.pop.add(itemHits);
        this.pop.addSeparator();
        JCheckBoxMenuItem item4 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW FUZZY GLOSSARY TERMS"));
        item4.setSelected(AppPreferences.matchBoardShowFuzzyTerms);
        item4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowFuzzyTerms = e.getStateChange() == 1;
            }
        });
        this.pop.add(item4);
        JCheckBoxMenuItem item7 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW FUZZY SOURCE SEGMENTS"));
        item7.setSelected(AppPreferences.matchBoardShowFuzzySourceSegments);
        item7.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowFuzzySourceSegments = e.getStateChange() == 1;
            }
        });
        this.pop.add(item7);
        JCheckBoxMenuItem itemFields = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW GLOSSARY FIELDS"));
        itemFields.setSelected(AppPreferences.matchBoardShowGlossaryFields);
        itemFields.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShowGlossaryFields = e.getStateChange() == 1;
            }
        });
        this.pop.add(itemFields);
        JCheckBoxMenuItem item6 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHORTEN MATCH INFORMATION"));
        item6.setSelected(AppPreferences.matchBoardShortMatchInfo);
        item6.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.matchBoardShortMatchInfo = e.getStateChange() == 1;
            }
        });
        this.pop.addSeparator();
        this.pop.add(item6);
    }

    private void showPopUp(Component comp, int x, int y) {
        if (this.pop == null) {
            this.setPopup();
        }
        this.pop.show(comp, x, y);
    }

    class MatchesHyperactive
    implements HyperlinkListener {
        private Thread th;
        private boolean act = true;

        MatchesHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(final HyperlinkEvent e) {
            block37: {
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    if (this.th != null) {
                        this.act = false;
                        if (this.th.isAlive()) {
                            this.th.interrupt();
                        }
                        this.th = null;
                    }
                    MatchBoard.this.topui.getMemoryView().getMemoryTip().hideInfo();
                    MatchBoard.this.topui.getResourceView().getGlossaryTip().hideInfo();
                } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    if (this.th == null) {
                        this.act = true;
                        final String s = e.getDescription();
                        if (s.startsWith("$") || s.startsWith("%")) {
                            this.th = new Thread(this){
                                final /* synthetic */ MatchesHyperactive this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    try {
                                        Thread.currentThread();
                                        Thread.sleep(750L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    final Component comp = (Component)e.getSource();
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            if (this.this$2.this$1.act) {
                                                char ch = s.charAt(0);
                                                if (ch == '$') {
                                                    int j = s.indexOf(58);
                                                    int k = s.indexOf(61);
                                                    if (j != -1 && k != -1) {
                                                        String n = s.substring(1, j);
                                                        Memory m = this.this$2.this$1.MatchBoard.this.topui.getMemoryView().getMemory(n);
                                                        if (m != null) {
                                                            String ss = "#" + s.substring(j + 1);
                                                            this.this$2.this$1.MatchBoard.this.topui.getMemoryView().getMemoryTip().showInfo(m.getTMX(), ss, comp, this.this$2.this$1.MatchBoard.this.mouseX + 20, this.this$2.this$1.MatchBoard.this.mouseY + 20);
                                                        }
                                                    }
                                                } else {
                                                    int j = s.indexOf(58);
                                                    if (j != -1) {
                                                        String n = s.substring(1, j);
                                                        GlossaryResource g = this.this$2.this$1.MatchBoard.this.topui.getResourceView().getGlossary(n);
                                                        if (g != null) {
                                                            String ss = "#" + s.substring(j + 1);
                                                            this.this$2.this$1.MatchBoard.this.topui.getResourceView().getGlossaryTip().showInfo(g, ss, comp, this.this$2.this$1.MatchBoard.this.mouseX + 20, this.this$2.this$1.MatchBoard.this.mouseY + 20);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    });
                                }
                            };
                            this.th.setPriority(1);
                            this.th.start();
                        }
                    }
                } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    int j;
                    this.act = false;
                    MatchBoard.this.topui.getMemoryView().getMemoryTip().hideInfo();
                    MatchBoard.this.topui.getResourceView().getGlossaryTip().hideInfo();
                    String s = e.getDescription();
                    if (s.startsWith("#")) {
                        String id = s.substring(1);
                        int i = Integer.parseInt(id);
                        String[] arr = (String[])MatchBoard.this.matchMap.get(i);
                        if (arr != null) {
                            String source = arr[0];
                            String target = arr[1];
                            String proc = arr[2];
                            String type = arr[3];
                            if (source != null && target != null) {
                                String key;
                                String f;
                                String value = target;
                                int cpos = MatchBoard.this.topui.getTargetPane().getCaretPosition();
                                if (!(!AppPreferences.caseAdaptation || AppPreferences.caseAdaptationSentence && cpos != 0 || (f = XMLHelper.adaptCase(key = source, value)).equals(value))) {
                                    value = f;
                                }
                                try {
                                    JTextPane targetTextPane;
                                    String sel;
                                    if (AppPreferences.matchesToClipboard) {
                                        MatchBoard.this.topui.getResourceView().addStringToClipboard(value);
                                        break block37;
                                    }
                                    if (AppPreferences.autotags) {
                                        String sourceSegment = MatchBoard.this.topui.getSourcePane().getText();
                                        String targetSegment = MatchBoard.this.topui.getTargetPane().getText();
                                        HashMap ttagMap = new HashMap(8);
                                        targetSegment = XMLHelper.shrinkTags(targetSegment, ttagMap);
                                        HashMap stagMap = new HashMap(8);
                                        sourceSegment = XMLHelper.shrinkTags(sourceSegment, stagMap);
                                        if (!stagMap.isEmpty()) {
                                            value = MatchBoard.this.transferTags(0, sourceSegment, source, value, stagMap, ttagMap.keySet(), false);
                                        }
                                    }
                                    if ((sel = (targetTextPane = MatchBoard.this.topui.getTargetPane()).getSelectedText()) != null) {
                                        int ss = targetTextPane.getSelectionStart();
                                        int se = targetTextPane.getSelectionEnd();
                                        targetTextPane.getDocument().remove(ss, se - ss);
                                        cpos = targetTextPane.getCaretPosition();
                                    }
                                    targetTextPane.getDocument().insertString(cpos, value, null);
                                    if (AppPreferences.adjustWordSpacing) {
                                        MatchBoard.this.topui.getTargetView().autoAdjustSpacing();
                                    }
                                    if (!targetTextPane.isFocusOwner()) {
                                        targetTextPane.requestFocusInWindow();
                                    }
                                    this.setMatchStatus(type, proc);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            } else if (target != null) {
                                String segmentSource = MatchBoard.this.topui.getSourcePane().getText();
                                if (AppPreferences.matchesToClipboard) {
                                    if (!(!AppPreferences.autonumbers || type.equals("EM") && MatchBoard.this.transEvent.hasTagsTransferred())) {
                                        target = NumbersHelper.autoTransfer(segmentSource, target);
                                    }
                                    MatchBoard.this.topui.getResourceView().addStringToClipboard(target);
                                } else {
                                    if (!type.equals("EM") || !MatchBoard.this.transEvent.hasTagsTransferred()) {
                                        if (AppPreferences.autotags && MatchBoard.this.transEvent != null) {
                                            target = MatchBoard.this.transferSegmentTags(segmentSource, target, MatchBoard.this.transEvent);
                                        }
                                        if (AppPreferences.autonumbers) {
                                            target = NumbersHelper.autoTransfer(segmentSource, target);
                                        }
                                    }
                                    target = MatchBoard.this.matchHiddenNontranslatables(target);
                                    JTextPane targetTextPane = MatchBoard.this.topui.getTargetPane();
                                    MatchBoard.this.topui.getTargetView().setTargetPaneText(target);
                                    targetTextPane.setCaretPosition(0);
                                    if (!targetTextPane.isFocusOwner()) {
                                        targetTextPane.requestFocusInWindow();
                                    }
                                    this.setMatchStatus(type, proc);
                                }
                            }
                        }
                    } else if (s.startsWith("$")) {
                        int j2 = s.indexOf(58);
                        int k = s.indexOf(61);
                        if (k != -1) {
                            String n = s.substring(1, j2);
                            Memory m = MatchBoard.this.topui.getMemoryView().getMemory(n);
                            if (m != null) {
                                String ss = "#" + s.substring(j2 + 1);
                                m.edit(ss);
                            }
                        }
                    } else if (s.startsWith("%") && (j = s.indexOf(58)) != -1) {
                        String n = s.substring(1, j);
                        GlossaryResource g = MatchBoard.this.topui.getResourceView().getGlossary(n);
                        if (g != null && !g.isReadOnly()) {
                            String ss = "#" + s.substring(j + 1);
                            g.editEntry(g, ss);
                        }
                    }
                }
            }
        }

        private void setMatchStatus(String type, String procent) {
            XLIFFUnit tu;
            XLIFF xliff = MatchBoard.this.topui.getProjectView().getProject().getXLIFF();
            if (xliff != null && (tu = xliff.getWorkflow().getCheckTransUnit()) != null) {
                int p;
                int t;
                if (type.equals("EM")) {
                    t = 1;
                    p = Integer.parseInt(procent);
                } else if (type.equals("FM")) {
                    t = 2;
                    p = Integer.parseInt(procent);
                } else if (type.equals("CT")) {
                    t = 3;
                    p = -1;
                } else if (type.equals("MT")) {
                    t = 4;
                    p = -1;
                } else if (type.equals("AI")) {
                    t = 0;
                    p = -1;
                } else {
                    return;
                }
                MatchBoard.this.topui.getTargetView().setEdited(false);
                tu.removeMatch(false);
                boolean storeMatch = false;
                if (xliff.isCafeTranXLIFF) {
                    storeMatch = true;
                }
                tu.setMatch(p, t, storeMatch);
            }
        }
    }
}

