/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.DictionaryResource;
import translator.MainView;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.tmx.DatabaseSaveChooser;
import translator.ui.GridPanel;

public class NewResource
extends JDialog
implements ActionListener {
    private Map hm;
    private Map importhm;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JComboBox combo1;
    private JComboBox combo2;
    private JComboBox combo3;
    private JComboBox combo4;
    private JComboBox combo5;
    private JCheckBox chooseFolderBox;
    private JTextField classPathField;
    private String[] ews = new String[]{"=", ",", ";", ":", "TAB", ""};
    private String[] es = new String[]{"Windows", "OS X/Unix"};
    private String[] td = new String[]{"\""};
    private String[] services = new String[]{"Reference and research", "Translation", "Use system browser"};
    private MainView parent;
    public boolean approve = false;
    boolean newres = false;
    private String defaultPath;
    private String dir;
    public String infoPath;
    private String importPath;
    private String resourcePath;
    private boolean isEditor = false;
    private boolean toTable = false;
    private int type;
    private int imported = -1;

    public NewResource(MainView owner, String title, String path, int type) {
        super(owner, title, true);
        this.setResizable(false);
        this.defaultPath = path;
        this.parent = owner;
        this.hm = new LinkedHashMap();
        this.type = type;
        if (type == 6) {
            this.dir = "databases";
            this.infoPath = AppPreferences.packagePath + "infos/" + this.dir;
            this.newres = true;
        } else if (type == 8) {
            this.dir = "Glossaries";
            this.infoPath = AppPreferences.packagePath + "infos/resources/" + this.dir;
            this.newres = true;
            this.toTable = true;
        } else if (type == 9) {
            this.dir = "Glossaries";
            this.infoPath = AppPreferences.packagePath + "infos/resources/" + this.dir;
            this.newres = true;
        } else if (type == 0 || type == 10) {
            this.dir = "Internet";
            this.infoPath = AppPreferences.packagePath + "infos/resources/" + this.dir;
            this.newres = true;
            if (type == 10) {
                if (path.endsWith(".ini")) {
                    this.imported = 1;
                    this.importPath = path;
                    this.initImportMap();
                    this.defaultPath = AppPreferences.packagePath + "forms/InternetAddResource";
                } else {
                    this.imported = 0;
                }
            }
        } else if (type == 1) {
            this.dir = "Images";
            this.infoPath = AppPreferences.packagePath + "infos/resources/" + this.dir;
            this.newres = true;
        } else if (type == 3) {
            this.dir = "";
            this.infoPath = AppPreferences.packagePath + "infos/resources";
            this.newres = true;
        } else {
            if (type == 7) {
                this.isEditor = true;
            }
            this.dir = "";
            this.infoPath = path;
        }
        if (type != 9) {
            this.initForm();
        }
        if (this.isEditor) {
            this.setLibreOfficeEditor();
        }
    }

    private void setLibreOfficeEditor() {
        if (this.classPathField != null) {
            int i;
            String val = this.classPathField.getText();
            boolean findOOBeanJar = false;
            if (AppPreferences.operatingSystem == 0 && val != null && val.length() > 0 && (i = val.indexOf("officebean.jar")) == -1) {
                findOOBeanJar = true;
            }
            if (val == null || val.length() == 0 || findOOBeanJar) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String p;
                        File file = null;
                        if (AppPreferences.operatingSystem == 1) {
                            file = new File("/Applications");
                        } else if (AppPreferences.operatingSystem == 0) {
                            file = new File("C:\\Program Files");
                        } else if (AppPreferences.operatingSystem == 2) {
                            file = new File("/opt");
                        }
                        if (file != null && file.exists() && file.isDirectory() && (p = NewResource.this.getLibreOfficePath(file)).length() > 0) {
                            NewResource.this.classPathField.setText(p);
                            NewResource.this.setTitle("LibreOffice is ready to connect.");
                        }
                    }
                });
            }
        }
    }

    public void chooseGlossary(String path) {
        this.resourcePath = path;
        this.initForm();
    }

    private void saveResourceInfo(String path) {
        try {
            File file = new File(path);
            FileOutputStream out = new FileOutputStream(file);
            BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            for (String key : this.hm.keySet()) {
                JComponent jcb;
                Object o = this.hm.get(key);
                String val = null;
                if (o instanceof String) {
                    val = o.toString();
                } else if (o instanceof JTextField) {
                    JTextField jtf = (JTextField)this.hm.get(key);
                    val = jtf.getText();
                } else if (o instanceof JComboBox) {
                    jcb = (JComboBox)this.hm.get(key);
                    if (key.equals("Priority")) {
                        int ind = ((JComboBox)jcb).getSelectedIndex();
                        val = Integer.toString(ind);
                    } else {
                        val = (String)((JComboBox)jcb).getSelectedItem();
                    }
                } else if (o instanceof JCheckBox) {
                    jcb = (JCheckBox)this.hm.get(key);
                    val = ((AbstractButton)jcb).isSelected() ? "yes" : "no";
                }
                awriter.write(key + "=" + val);
                awriter.newLine();
            }
            awriter.close();
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadGlossaryToDatabase() {
        ResourceInfo info = this.getResourceInfo();
        DictionaryResource dr = new DictionaryResource(info);
        dr.setMainView(this.parent);
        DatabaseSaveChooser dlg = new DatabaseSaveChooser(this.parent, dr.getName() + " -> Total Recall", dr);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    private ResourceInfo getResourceInfo() {
        HashMap<String, String> hmap = new HashMap<String, String>(8);
        for (String key : this.hm.keySet()) {
            JComponent jcb;
            Object o = this.hm.get(key);
            String val = null;
            if (o instanceof JTextField) {
                JTextField jtf = (JTextField)this.hm.get(key);
                val = jtf.getText();
            } else if (o instanceof JComboBox) {
                jcb = (JComboBox)this.hm.get(key);
                val = (String)((JComboBox)jcb).getSelectedItem();
            } else if (o instanceof JCheckBox) {
                jcb = (JCheckBox)this.hm.get(key);
                val = ((AbstractButton)jcb).isSelected() ? "yes" : "no";
            }
            hmap.put(key, val);
        }
        ResourceInfo info = new ResourceInfo(hmap);
        return info;
    }

    private LinkedHashMap getOOClassPath(File file, LinkedHashMap jars) {
        File[] files;
        int size = 5;
        if (AppPreferences.operatingSystem == 0) {
            ++size;
        }
        if ((files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file1 = files[i];
                String jpath = file1.getPath();
                if (jpath.endsWith("soffice.bin") || jpath.endsWith("soffice")) {
                    jars.put("soffice.bin", file1.getParent());
                } else if (jpath.endsWith("ridl.jar")) {
                    jars.put("ridl.jar", jpath);
                } else if (jpath.endsWith("jurt.jar")) {
                    jars.put("jurt.jar", jpath);
                } else if (jpath.endsWith("juh.jar")) {
                    jars.put("juh.jar", jpath);
                } else if (jpath.endsWith("unoil.jar")) {
                    jars.put("unoil.jar", jpath);
                } else if (AppPreferences.operatingSystem == 0 && jpath.endsWith("officebean.jar")) {
                    jars.put("officebean.jar", jpath);
                } else if (jars.size() < size && file1.isDirectory()) {
                    this.getOOClassPath(file1, jars);
                }
                if (jars.size() == size) break;
            }
        }
        return jars;
    }

    private String getLibreOfficePath(File file) {
        String path;
        block10: {
            Collection col;
            LinkedHashMap jars;
            File f;
            String dname;
            String sep;
            block9: {
                path = "";
                sep = System.getProperty("path.separator");
                dname = file.getName().toLowerCase();
                f = null;
                if (dname.equals("applications") || dname.equals("program files")) {
                    File[] files = file.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        File file1 = files[i];
                        String n = file1.getName().toLowerCase();
                        if (!n.startsWith("libreoffice")) continue;
                        f = file1;
                        dname = n;
                        break;
                    }
                }
                if (f == null) {
                    f = file;
                }
                if (!dname.startsWith("libreoffice")) break block9;
                jars = new LinkedHashMap();
                LinkedHashMap jjars = this.getLOClassPath(f, jars);
                int size = 2;
                if (AppPreferences.operatingSystem == 0) {
                    ++size;
                }
                if (jjars.size() != size) break block10;
                col = jjars.values();
                for (String jar : col) {
                    path = path + jar + sep;
                }
                break block10;
            }
            if (dname.startsWith("openoffice") || dname.startsWith("neooffice")) {
                jars = new LinkedHashMap();
                LinkedHashMap jjars = this.getOOClassPath(f, jars);
                int size = 5;
                if (AppPreferences.operatingSystem == 0) {
                    ++size;
                }
                if (jjars.size() == size) {
                    col = jjars.values();
                    for (String jar : col) {
                        path = path + jar + sep;
                    }
                }
            }
        }
        return path;
    }

    private LinkedHashMap getLOClassPath(File file, LinkedHashMap jars) {
        File[] files;
        int size = 2;
        if (AppPreferences.operatingSystem == 0) {
            ++size;
        }
        if ((files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file1 = files[i];
                String jpath = file1.getPath();
                if (jpath.endsWith("soffice.bin") || jpath.endsWith("soffice")) {
                    jars.put("soffice.bin", file1.getParent());
                } else if (jpath.endsWith("libreoffice.jar")) {
                    jars.put("libreoffice.jar", jpath);
                } else if (AppPreferences.operatingSystem == 0 && jpath.endsWith("officebean.jar")) {
                    jars.put("officebean.jar", jpath);
                } else if (jars.size() < size && file1.isDirectory()) {
                    this.getLOClassPath(file1, jars);
                }
                if (jars.size() == size) break;
            }
        }
        return jars;
    }

    private void initImportMap() {
        this.importhm = new LinkedHashMap();
        try {
            String line;
            File file = new File(this.importPath);
            FileInputStream fis = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            while ((line = in.readLine()) != null) {
                int i;
                if (line.length() <= 0 || (i = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, i);
                String value = line.substring(i + 1);
                if (value == null || key == null) continue;
                this.importhm.put(key, value);
            }
            fis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initForm() {
        LinkedHashMap<String, String> entrieshm = new LinkedHashMap<String, String>();
        try {
            String line;
            File file = new File(this.defaultPath);
            FileInputStream fis = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            while ((line = in.readLine()) != null) {
                int i;
                if (line.length() <= 0 || (i = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, i);
                String value = line.substring(i + 1);
                if (value == null || key == null) continue;
                entrieshm.put(key, value);
            }
            in.close();
            fis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridLayout(0, 2, 10, 5));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.setOpaque(false);
        jPanel3.setBorder(new EmptyBorder(new Insets(10, 0, 5, 0)));
        for (Map.Entry entry : entrieshm.entrySet()) {
            JCheckBox box1;
            JTextField jtf;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.equals("Type")) {
                this.hm.put(key, value);
                continue;
            }
            if ((this.isEditor || this.type == 9) && key.equals("Name")) {
                this.hm.put(key, value);
                continue;
            }
            if (this.isEditor && key.equals("Path")) {
                String s = AppPreferences.packagePath + "lib" + AppPreferences.fs + "editors-1.0.zip";
                File f = new File(s);
                if (f.exists()) {
                    String ss = AppPreferences.packagePath + "lib" + AppPreferences.fs + "editors-1.0.jar";
                    File ff = new File(ss);
                    f.renameTo(ff);
                }
                if ((f = new File(s = AppPreferences.packagePath + "lib" + AppPreferences.fs + "editors.jar")).exists()) {
                    f.delete();
                }
                if (value.equals("lib/editors.jar")) {
                    value = "lib/editors-1.0.jar";
                }
                this.hm.put(key, value);
                continue;
            }
            if (this.imported == 1) {
                String imval;
                if (key.equals("Address start")) {
                    imval = (String)this.importhm.get("Start");
                    if (imval != null) {
                        value = imval;
                    }
                } else if (key.equals("Address end")) {
                    imval = (String)this.importhm.get("Finish");
                    if (imval != null) {
                        value = imval;
                    }
                } else if (key.equals("Encoding") && (imval = (String)this.importhm.get("Encoding")) != null) {
                    value = imval;
                }
            }
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(4);
            jLabel.setText(key + ":");
            if (key.equals("Entry word separator")) {
                jLabel.setText("Source/Target separator:");
                this.combo1 = new JComboBox<String>(this.ews);
                this.combo1.setEditable(true);
                if (this.newres && value.length() == 0) {
                    this.combo1.setSelectedItem("TAB");
                } else {
                    this.combo1.setSelectedItem(value);
                }
                this.combo1.setPreferredSize(new Dimension(400, this.combo1.getPreferredSize().height));
                jPanel2.add(jLabel);
                jPanel2.add(this.combo1);
                this.hm.put(key, this.combo1);
                continue;
            }
            if (key.equals("Entries separator")) {
                this.combo2 = new JComboBox<String>(this.es);
                this.combo2.setEditable(true);
                if (value.length() == 0) {
                    if (AppPreferences.operatingSystem == 0) {
                        this.combo2.setSelectedItem("Windows");
                    } else {
                        this.combo2.setSelectedItem("OS X/Unix");
                    }
                } else if (value.equals("Linux")) {
                    this.combo2.setSelectedItem("OS X/Unix");
                } else {
                    this.combo2.setSelectedItem(value);
                }
                this.combo2.setPreferredSize(new Dimension(400, this.combo2.getPreferredSize().height));
                jPanel2.add(jLabel);
                jPanel2.add(this.combo2);
                this.hm.put(key, this.combo2);
                continue;
            }
            if (key.equals("Text delimiter")) {
                if (this.type == 9) {
                    this.hm.put(key, "");
                    continue;
                }
                this.combo3 = new JComboBox<String>(this.td);
                this.combo3.setEditable(true);
                this.combo3.setSelectedItem(value);
                this.combo3.setPreferredSize(new Dimension(400, this.combo3.getPreferredSize().height));
                jPanel2.add(jLabel);
                jPanel2.add(this.combo3);
                this.hm.put(key, this.combo3);
                continue;
            }
            if (key.equals("Priority")) {
                String[] priorities = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOW PRIORITY"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEDIUM PRIORITY"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIGH PRIORITY"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("KEEP OUT OF AUTO-ASSEMBLING")};
                this.combo5 = new JComboBox<String>(priorities);
                if (value.length() == 0) {
                    this.combo5.setSelectedIndex(1);
                } else {
                    int ind = Integer.parseInt(value);
                    this.combo5.setSelectedIndex(ind);
                }
                this.combo5.setPreferredSize(new Dimension(400, this.combo5.getPreferredSize().height));
                jPanel2.add(jLabel);
                jPanel2.add(this.combo5);
                this.hm.put(key, this.combo5);
                continue;
            }
            if (key.equals("Path") || key.equals("Driver file")) {
                jtf = new JTextField();
                jtf.setPreferredSize(new Dimension(400, jtf.getPreferredSize().height));
                jtf.setMargin(new Insets(0, 2, 0, 0));
                jtf.setFont(jtf.getFont().deriveFont(1));
                if (this.resourcePath != null) {
                    jtf.setText(this.resourcePath);
                } else {
                    jtf.setText(value);
                }
                jtf.setCaretPosition(0);
                JButton jb = new JButton(key + "...");
                jb.setName(key);
                jb.putClientProperty("value", value);
                jb.addActionListener(new ActionListener(){
                    final /* synthetic */ NewResource this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JButton button = (JButton)e.getSource();
                        String k = button.getName();
                        String v = (String)button.getClientProperty("value");
                        final String loc = k.equals("Driver file") ? System.getProperty("user.home") : (v.length() == 0 ? (this.this$0.type == 9 && AppPreferences.glossaryDir.length() > 0 ? AppPreferences.glossaryDir : AppPreferences.packagePath + "resources/" + this.this$0.dir.toLowerCase()) : (v.startsWith("resources") ? AppPreferences.packagePath + v : v));
                        if (AppPreferences.isJavaFXReady()) {
                            Platform.runLater((Runnable)new Runnable(){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    try {
                                        File file;
                                        if (this.this$1.this$0.chooseFolderBox == null || !this.this$1.this$0.chooseFolderBox.isSelected()) {
                                            FileChooser fileChooser = new FileChooser();
                                            if (this.this$1.this$0.type == 9) {
                                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                                            }
                                            if (loc != null && loc.length() > 0) {
                                                File f = new File(loc);
                                                if (f.isDirectory()) {
                                                    fileChooser.setInitialDirectory(f);
                                                } else {
                                                    fileChooser.setInitialDirectory(f.getParentFile());
                                                    fileChooser.setInitialFileName(f.getName());
                                                }
                                            }
                                            file = fileChooser.showOpenDialog(null);
                                        } else {
                                            DirectoryChooser fileChooser = new DirectoryChooser();
                                            if (this.this$1.this$0.type == 9) {
                                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                                            }
                                            if (loc != null && loc.length() > 0) {
                                                File f = new File(loc);
                                                if (f.isDirectory()) {
                                                    fileChooser.setInitialDirectory(f);
                                                } else {
                                                    fileChooser.setInitialDirectory(f.getParentFile());
                                                }
                                            }
                                            file = fileChooser.showDialog(null);
                                        }
                                        if (file != null) {
                                            SwingUtilities.invokeLater(new Runnable(){
                                                final /* synthetic */ 1 this$2;
                                                {
                                                    this.this$2 = this$2;
                                                }

                                                @Override
                                                public void run() {
                                                    try {
                                                        this.this$2.this$1.this$0.defaultPath = file.toURI().toURL().getPath();
                                                    }
                                                    catch (MalformedURLException ex) {
                                                        ex.printStackTrace();
                                                    }
                                                    if (this.this$2.this$1.this$0.defaultPath.startsWith(AppPreferences.packagePath + "resources") || this.this$2.this$1.this$0.defaultPath.startsWith(AppPreferences.packagePath + "lib")) {
                                                        this.this$2.this$1.this$0.defaultPath = this.this$2.this$1.this$0.defaultPath.substring(AppPreferences.packagePath.length());
                                                        this.this$2.this$1.this$0.defaultPath = this.this$2.this$1.this$0.defaultPath.replaceAll("%20", " ");
                                                        jtf.setText(this.this$2.this$1.this$0.defaultPath);
                                                    } else {
                                                        this.this$2.this$1.this$0.defaultPath = file.getPath();
                                                        if (file.isDirectory()) {
                                                            this.this$2.this$1.this$0.defaultPath = this.this$2.this$1.this$0.defaultPath + AppPreferences.fs;
                                                        } else if (this.this$2.this$1.this$0.type == 9 && !file.exists() && this.this$2.this$1.this$0.defaultPath.indexOf(46) == -1) {
                                                            this.this$2.this$1.this$0.defaultPath = this.this$2.this$1.this$0.defaultPath + ".txt";
                                                        }
                                                        jtf.setText(this.this$2.this$1.this$0.defaultPath);
                                                    }
                                                }
                                            });
                                        }
                                    }
                                    catch (Exception ex) {
                                        final String s = ex.getMessage();
                                        SwingUtilities.invokeLater(new Runnable(){
                                            final /* synthetic */ 1 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            @Override
                                            public void run() {
                                                JOptionPane.showMessageDialog(this.this$2.this$1.this$0.parent, s);
                                            }
                                        });
                                    }
                                }
                            });
                        } else {
                            JFileChooser jch = new JFileChooser(loc);
                            if (this.this$0.type == 9) {
                                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE GLOSSARY"));
                            } else {
                                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                            }
                            jch.setFileSelectionMode(2);
                            if (0 == jch.showOpenDialog(this.this$0.parent)) {
                                File file = jch.getSelectedFile();
                                try {
                                    this.this$0.defaultPath = file.toURI().toURL().getPath();
                                }
                                catch (MalformedURLException ex) {
                                    ex.printStackTrace();
                                }
                                if (this.this$0.defaultPath.startsWith(AppPreferences.packagePath + "resources") || this.this$0.defaultPath.startsWith(AppPreferences.packagePath + "lib")) {
                                    this.this$0.defaultPath = this.this$0.defaultPath.substring(AppPreferences.packagePath.length());
                                    this.this$0.defaultPath = this.this$0.defaultPath.replaceAll("%20", " ");
                                    jtf.setText(this.this$0.defaultPath);
                                } else {
                                    this.this$0.defaultPath = file.getPath();
                                    if (file.isDirectory()) {
                                        this.this$0.defaultPath = this.this$0.defaultPath + AppPreferences.fs;
                                    } else if (this.this$0.type == 9 && !file.exists() && this.this$0.defaultPath.indexOf(46) == -1) {
                                        this.this$0.defaultPath = this.this$0.defaultPath + ".txt";
                                    }
                                    jtf.setText(this.this$0.defaultPath);
                                }
                            }
                        }
                    }
                });
                jPanel2.add(jb);
                jPanel2.add(jtf);
                this.hm.put(key, jtf);
                this.chooseFolderBox = new JCheckBox("Choose a folder");
                this.chooseFolderBox.setOpaque(false);
                if (this.type == 9 && this.resourcePath != null && this.resourcePath.length() > 0 && new File(this.resourcePath).isDirectory()) {
                    this.chooseFolderBox.setSelected(true);
                }
                jPanel2.add(new JLabel());
                jPanel2.add(this.chooseFolderBox);
                continue;
            }
            if (key.equals("Style") || key.equals("Service")) {
                key = "Service";
                jLabel.setText(key + ":");
                this.combo4 = new JComboBox<String>(this.services);
                this.combo4.setSelectedItem(value);
                this.combo4.setPreferredSize(new Dimension(400, this.combo4.getPreferredSize().height));
                jPanel2.add(jLabel);
                jPanel2.add(this.combo4);
                this.hm.put(key, this.combo4);
                continue;
            }
            if (key.equals("Class path")) {
                jtf = new JTextField();
                jtf.setPreferredSize(new Dimension(400, jtf.getPreferredSize().height));
                jtf.setMargin(new Insets(0, 2, 0, 0));
                jtf.setFont(jtf.getFont().deriveFont(1));
                jtf.setText(value);
                jtf.setCaretPosition(0);
                JButton jb = new JButton(key + "...");
                if (this.isEditor) {
                    jb.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE LIBREOFFICE INSTALLATION DIRECTORY"));
                } else {
                    jb.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE RESOURCE CLASS PATH"));
                }
                jb.addActionListener(new ActionListener(){
                    final /* synthetic */ NewResource this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final JButton but = (JButton)e.getSource();
                        if (AppPreferences.isJavaFXReady()) {
                            Platform.runLater((Runnable)new Runnable(){
                                final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    try {
                                        File file;
                                        FileChooser fileChooser;
                                        if (!this.this$1.this$0.isEditor) {
                                            fileChooser = new FileChooser();
                                            fileChooser.setTitle(but.getToolTipText());
                                            file = fileChooser.showOpenDialog(null);
                                        } else {
                                            fileChooser = new DirectoryChooser();
                                            fileChooser.setTitle(but.getToolTipText());
                                            file = fileChooser.showDialog(null);
                                        }
                                        if (file == null) {
                                            return;
                                        }
                                        if (this.this$1.this$0.isEditor && file.isDirectory()) {
                                            SwingUtilities.invokeLater(new Runnable(){
                                                final /* synthetic */ 1 this$2;
                                                {
                                                    this.this$2 = this$2;
                                                }

                                                @Override
                                                public void run() {
                                                    String p = this.this$2.this$1.this$0.getLibreOfficePath(file);
                                                    if (p.length() > 0) {
                                                        this.this$2.this$1.this$0.classPathField.setText(p);
                                                    }
                                                }
                                            });
                                        } else {
                                            String path = file.getPath();
                                            jtf.setText(path);
                                        }
                                    }
                                    catch (Exception ex) {
                                        final String s = ex.getMessage();
                                        SwingUtilities.invokeLater(new Runnable(){
                                            final /* synthetic */ 1 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            @Override
                                            public void run() {
                                                JOptionPane.showMessageDialog(this.this$2.this$1.this$0.parent, s);
                                            }
                                        });
                                    }
                                }
                            });
                        } else {
                            JFileChooser jch = new JFileChooser();
                            jch.setDialogTitle(but.getToolTipText());
                            jch.setFileSelectionMode(2);
                            jch.setMultiSelectionEnabled(true);
                            if (0 == jch.showOpenDialog(this.this$0.parent)) {
                                File[] files = jch.getSelectedFiles();
                                String path = "";
                                String sep = System.getProperty("path.separator");
                                for (int j = 0; j < files.length; ++j) {
                                    File file = files[j];
                                    if (!file.isDirectory()) {
                                        path = path + file.getPath() + sep;
                                        continue;
                                    }
                                    String dname = file.getName().toLowerCase();
                                    if (dname.startsWith("openoffice") || dname.startsWith("neooffice") || dname.startsWith("libreoffice")) {
                                        LinkedHashMap jars = new LinkedHashMap();
                                        LinkedHashMap jjars = this.this$0.getOOClassPath(file, jars);
                                        if (jjars.size() != 5) continue;
                                        Collection col = jjars.values();
                                        for (String jar : col) {
                                            path = path + jar + sep;
                                        }
                                        jtf.setText("");
                                        JOptionPane.showMessageDialog(this.this$0.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LIBREOFFICE CLASSPATH SET SUCCESSFULLY!"));
                                        continue;
                                    }
                                    path = path + file.getPath();
                                }
                                String field = jtf.getText();
                                jtf.setText(field + path);
                            }
                        }
                    }
                });
                jPanel2.add(jb);
                jPanel2.add(jtf);
                this.hm.put(key, jtf);
                this.classPathField = jtf;
                continue;
            }
            if (key.equals("Read only")) {
                box1 = new JCheckBox(key);
                box1.setOpaque(false);
                if (value.equalsIgnoreCase("yes")) {
                    box1.setSelected(true);
                } else {
                    box1.setSelected(false);
                }
                jPanel2.add(new JLabel());
                jPanel2.add(box1);
                this.hm.put(key, box1);
                continue;
            }
            if (key.equals("Match case")) {
                box1 = new JCheckBox(key);
                box1.setOpaque(false);
                if (value.equalsIgnoreCase("yes")) {
                    box1.setSelected(true);
                } else {
                    box1.setSelected(false);
                }
                jPanel2.add(new JLabel());
                jPanel2.add(box1);
                this.hm.put(key, box1);
                continue;
            }
            if (key.equals("Regular expressions only")) {
                box1 = new JCheckBox(key);
                box1.setOpaque(false);
                if (value.equalsIgnoreCase("yes")) {
                    box1.setSelected(true);
                } else {
                    box1.setSelected(false);
                }
                jPanel2.add(new JLabel());
                jPanel2.add(box1);
                this.hm.put(key, box1);
                continue;
            }
            if (key.equals("Non-translatable fragments only")) {
                box1 = new JCheckBox(key);
                box1.setOpaque(false);
                if (value.equalsIgnoreCase("yes")) {
                    box1.setSelected(true);
                } else {
                    box1.setSelected(false);
                }
                jPanel2.add(new JLabel());
                jPanel2.add(box1);
                this.hm.put(key, box1);
                continue;
            }
            if (key.equals("POST method")) {
                box1 = new JCheckBox(key);
                box1.setHorizontalAlignment(4);
                box1.setOpaque(false);
                if (value.equalsIgnoreCase("yes")) {
                    box1.setSelected(true);
                } else {
                    box1.setSelected(false);
                }
                jPanel2.add(new JLabel());
                jPanel2.add(box1);
                this.hm.put(key, box1);
                continue;
            }
            if (key.equals("Block JavaScript") || key.equals("Page start") || key.equals("Page end")) continue;
            JTextField jTextField = new JTextField();
            jTextField.setMargin(new Insets(0, 2, 0, 0));
            jTextField.setFont(jTextField.getFont().deriveFont(1));
            jTextField.setPreferredSize(new Dimension(400, jTextField.getPreferredSize().height));
            jTextField.setText(value);
            jTextField.setCaretPosition(0);
            jPanel2.add(jLabel);
            jPanel2.add(jTextField);
            this.hm.put(key, jTextField);
        }
        if (this.type == 9) {
            JButton optionsButton = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DEFINITIONS"));
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SETTINGS, (int)optionsButton.getFont().getSize(), (Color)optionsButton.getForeground());
            optionsButton.setIcon((Icon)ficon);
            optionsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewResource.this.parent.showOptions(null, 1);
                }
            });
            jPanel3.add(optionsButton);
        }
        if (this.isEditor && AppPreferences.operatingSystem == 0) {
            JCheckBox optionBox = new JCheckBox("Open in tab");
            optionBox.setSelected(AppPreferences.editorEmbeded);
            optionBox.addItemListener(new ItemListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void itemStateChanged(ItemEvent e) {
                    int k = e.getStateChange();
                    if (k == 1) {
                        AppPreferences.editorEmbeded = true;
                        String p = NewResource.this.classPathField.getText();
                        if (p.length() > 0) {
                            String sep = System.getProperty("path.separator");
                            String[] arr = p.split(sep);
                            for (int i = 0; i < arr.length; ++i) {
                                String string = arr[i];
                                if (string.length() <= 0 || string.endsWith(".jar")) continue;
                                string = "\"" + string + "\"";
                                String cmdCommand = "setx UNO_PATH " + string;
                                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                                processBuilder.command("cmd.exe", "/c", cmdCommand);
                                try {
                                    try {
                                        processBuilder.start();
                                    }
                                    catch (IOException ex) {
                                        Logger.getLogger(NewResource.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                                catch (Throwable throwable) {}
                                break;
                            }
                        }
                    } else {
                        AppPreferences.editorEmbeded = false;
                    }
                }
            });
            jPanel3.add(optionBox);
        }
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton2 = new JButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE"));
        this.jButton3.addActionListener(this);
        jPanel3.add(this.jButton1);
        if (!(this.newres || this.isEditor || this.toTable)) {
            jPanel3.add(this.jButton3);
        }
        jPanel3.add(this.jButton2);
        GridPanel con = new GridPanel();
        con.setLayout(new BorderLayout());
        this.setContentPane(con);
        con.setBorder(new EmptyBorder(new Insets(10, 10, 5, 10)));
        con.add((Component)jPanel2, "Center");
        con.add((Component)jPanel3, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewResource.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewResource.this.jButton2.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewResource.this.closeDialog();
            }
        });
        this.pack();
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton2) {
            this.closeDialog();
        } else if (e.getSource() == this.jButton1) {
            if (this.toTable) {
                this.closeDialog();
                this.loadGlossaryToDatabase();
                return;
            }
            File f = null;
            final File file = new File(this.infoPath);
            if (!file.isDirectory()) {
                f = file;
            } else {
                JTextField field;
                Object o = this.hm.get("Name");
                if (o != null && o instanceof JTextField) {
                    field = (JTextField)o;
                    String n = field.getText();
                    if (n.length() > 0) {
                        f = new File(this.infoPath + "/" + n);
                    }
                } else if (this.imported == 0) {
                    int en;
                    int sn = this.defaultPath.lastIndexOf(AppPreferences.fs);
                    if (sn != -1 && (en = this.defaultPath.lastIndexOf(".res")) != -1) {
                        String n = this.defaultPath.substring(sn, en);
                        f = new File(this.infoPath + "/" + n);
                    }
                } else if (this.imported == 1) {
                    int en;
                    int sn = this.importPath.lastIndexOf(AppPreferences.fs);
                    if (sn != -1 && (en = this.importPath.lastIndexOf(".ini")) != -1) {
                        String n = this.importPath.substring(sn, en);
                        f = new File(this.infoPath + "/" + n);
                    }
                } else {
                    String p;
                    o = this.hm.get("Path");
                    if (o != null && o instanceof JTextField && (p = (field = (JTextField)o).getText()).length() > 0 && (f = new File(p)).exists()) {
                        String n = f.getName();
                        int i = n.lastIndexOf(".");
                        if (i != -1) {
                            n = n.substring(0, i) + ".res";
                        }
                        f = new File(this.infoPath + "/" + n);
                    }
                }
            }
            if (f != null) {
                this.approve = true;
                String fpath = f.getPath();
                if (fpath.endsWith(".res")) {
                    this.saveResourceInfo(fpath);
                    this.infoPath = fpath;
                } else {
                    fpath = fpath + ".res";
                    this.saveResourceInfo(fpath);
                    this.infoPath = fpath;
                }
                if (this.type == 9) {
                    ResourceView rv = this.parent.getResourceView();
                    rv.refreshResourceMenu();
                }
                this.closeDialog();
            } else if (AppPreferences.isJavaFXReady()) {
                final String fileName = f != null ? f.getName() : null;
                Platform.runLater((Runnable)new Runnable(){
                    final /* synthetic */ NewResource this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            File fileChosen;
                            FileChooser fileChooser = new FileChooser();
                            fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE RESOURCE INFORMATION"));
                            if (file.isDirectory()) {
                                fileChooser.setInitialDirectory(file);
                            } else {
                                fileChooser.setInitialDirectory(file.getParentFile());
                            }
                            if (fileName != null && fileName.length() > 0) {
                                fileChooser.setInitialFileName(fileName);
                            }
                            if ((fileChosen = fileChooser.showSaveDialog(null)) != null) {
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 9 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        this.this$1.this$0.approve = true;
                                        String path = fileChosen.getPath();
                                        if (path.endsWith(".res")) {
                                            this.this$1.this$0.saveResourceInfo(path);
                                            this.this$1.this$0.infoPath = path;
                                        } else {
                                            path = path + ".res";
                                            this.this$1.this$0.saveResourceInfo(path);
                                            this.this$1.this$0.infoPath = path;
                                        }
                                        if (this.this$1.this$0.type == 9) {
                                            ResourceView rv = this.this$1.this$0.parent.getResourceView();
                                            rv.refreshResourceMenu();
                                        }
                                        this.this$1.this$0.closeDialog();
                                    }
                                });
                            }
                        }
                        catch (Exception ex) {
                            final String s = ex.getMessage();
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 9 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(this.this$1.this$0.parent, s);
                                }
                            });
                        }
                    }
                });
            } else {
                JFileChooser jch = new JFileChooser(file);
                jch.setFileSelectionMode(0);
                jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE RESOURCE INFORMATION"));
                if (f != null) {
                    jch.setSelectedFile(f);
                }
                if (0 == jch.showSaveDialog(this.parent)) {
                    this.approve = true;
                    String path = jch.getSelectedFile().getPath();
                    if (path.endsWith(".res")) {
                        this.saveResourceInfo(path);
                        this.infoPath = path;
                    } else {
                        path = path + ".res";
                        this.saveResourceInfo(path);
                        this.infoPath = path;
                    }
                    if (this.type == 9) {
                        ResourceView rv = this.parent.getResourceView();
                        rv.refreshResourceMenu();
                    }
                    this.closeDialog();
                }
            }
        } else if (e.getSource() == this.jButton3 && this.jButton3.isEnabled()) {
            File file = new File(this.infoPath);
            if (file.exists()) {
                file.delete();
                this.approve = true;
            }
            this.closeDialog();
        }
    }
}

