/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.Placeables;
import translator.WorkflowView;

public class NumbersHelper {
    private static final String extraCharsWithSpace = "[\\(\\[\\{\\-%$\u20ac]*([0-9]+['.,/:;=+\u00f7*\\-%$\u20ac\u00a0 ]*[\\)\\]\\}]*)++";
    private static final String extraChars = "[\\(\\[\\{\\-%$\u20ac]*([0-9]+['.,/:;=+\u00f7*\\-%$\u20ac\u00a0]*[\\)\\]\\}]*)++";
    private static final String numberSegmentFormat = "\\A[\\(\\[\\{\\-%$\u20ac]*([0-9]+['.,/:;=+\u00f7*\\-%$\u20ac\u00a0 ]*[\\)\\]\\}]*)++\\z";
    private static final String numberTransferFormat = AppPreferences.tags + "|" + "[\\(\\[\\{\\-%$\u20ac]*([0-9]+['.,/:;=+\u00f7*\\-%$\u20ac\u00a0]*[\\)\\]\\}]*)++";
    private static Pattern numberSegmentPattern = Pattern.compile("\\A[\\(\\[\\{\\-%$\u20ac]*([0-9]+['.,/:;=+\u00f7*\\-%$\u20ac\u00a0 ]*[\\)\\]\\}]*)++\\z");
    private static Pattern numberTransferPattern = Pattern.compile(numberTransferFormat);
    private static HashMap<Locale, DecimalFormat> formatMap = new HashMap(2);
    private static Pattern numberPattern = Pattern.compile("([0-9]+([.,][0-9])?)++");
    private static Pattern numberSpacePattern = Pattern.compile("([0-9]+([.,\u00a0 ][0-9])?)++");
    private static Locale sourceLocale;
    private static Locale targetLocale;
    private static char decimalSeparator;
    private static char groupingSeparator;

    public static void setSourceLocale(Locale locale) {
        sourceLocale = locale;
        if (sourceLocale != null) {
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(sourceLocale);
            decimalSeparator = dfs.getDecimalSeparator();
            groupingSeparator = dfs.getGroupingSeparator();
        }
    }

    public static void setTargetLocale(Locale locale) {
        targetLocale = locale;
    }

    public static String isNumber(String sn) {
        DecimalFormat nf;
        char aChar;
        int i;
        if (sourceLocale == null) {
            return null;
        }
        String start = null;
        String end = null;
        int j = 0;
        int k = sn.length();
        char[] charsArr = sn.toCharArray();
        for (i = 0; i < charsArr.length && Character.isSpaceChar(aChar = charsArr[i]); ++i) {
            ++j;
        }
        for (i = k - 1; i > j && (Character.isSpaceChar(aChar = charsArr[i]) || aChar == '.'); --i) {
            --k;
        }
        if (j > 0 || k < sn.length()) {
            if (j > 0) {
                start = sn.substring(0, j);
            }
            if (k < sn.length()) {
                end = sn.substring(k);
            }
            sn = sn.substring(j, k);
        }
        if (AppPreferences.formatnumbers && sn.length() > 3) {
            char a = sn.charAt(0);
            char b = sn.charAt(sn.length() - 1);
            if (Character.isDigit(a) && Character.isDigit(b)) {
                sn = sn.replace(String.valueOf('\u00a0'), "");
                sn = sn.replace(String.valueOf('\u202f'), "");
            } else {
                return null;
            }
        }
        if ((nf = formatMap.get(sourceLocale)) == null) {
            nf = (DecimalFormat)DecimalFormat.getInstance(sourceLocale);
            formatMap.put(sourceLocale, nf);
        }
        nf.setRoundingMode(RoundingMode.DOWN);
        ParsePosition parsePosition = new ParsePosition(0);
        Number num = nf.parse(sn, parsePosition);
        if (parsePosition.getIndex() != sn.length()) {
            return null;
        }
        if (AppPreferences.formatnumbers) {
            char[] chars = sn.toCharArray();
            boolean allDigits = true;
            boolean endNoDigit = false;
            boolean startZero = false;
            boolean noDecimalSeparator = true;
            for (int i2 = 0; i2 < chars.length; ++i2) {
                char aChar2 = chars[i2];
                if (!Character.isDigit(aChar2)) {
                    allDigits = false;
                    if (i2 == chars.length - 1) {
                        endNoDigit = true;
                    }
                    if (i2 == 1 && startZero) {
                        startZero = false;
                    }
                    if (aChar2 != decimalSeparator) continue;
                    noDecimalSeparator = false;
                    continue;
                }
                if (i2 != 0 || aChar2 != '0') continue;
                startZero = true;
            }
            if (noDecimalSeparator || allDigits || endNoDigit || startZero || targetLocale == null) {
                if (start != null) {
                    sn = start + sn;
                }
                if (end != null) {
                    sn = sn + end;
                }
                return sn;
            }
            double dv = num.doubleValue();
            nf = formatMap.get(targetLocale);
            if (nf == null) {
                nf = (DecimalFormat)DecimalFormat.getInstance(targetLocale);
                formatMap.put(targetLocale, nf);
            }
            nf.setRoundingMode(RoundingMode.DOWN);
            String tn = nf.format(dv);
            if (sn.length() > tn.length()) {
                String z;
                String s = sn.substring(tn.length());
                if (s.equals(z = Character.toString(decimalSeparator) + "0")) {
                    nf.setMinimumFractionDigits(1);
                    sn = nf.format(dv);
                } else {
                    sn = tn + s;
                }
            } else {
                sn = tn;
            }
        }
        if (start != null) {
            sn = start + sn;
        }
        if (end != null) {
            sn = sn + end;
        }
        return sn;
    }

    public static boolean isExtendedNumber(String sn) {
        Matcher m = numberSegmentPattern.matcher(sn.trim());
        return m.matches();
    }

    public static String autoTransfer(String source, String target) {
        ArrayList<String> sgroups = new ArrayList<String>();
        Matcher matcher = numberTransferPattern.matcher(source);
        while (matcher.find()) {
            String s = matcher.group();
            if (s.startsWith("<")) continue;
            sgroups.add(s);
        }
        matcher = numberTransferPattern.matcher(target);
        StringBuffer sb = new StringBuffer();
        while (!sgroups.isEmpty() && matcher.find()) {
            String s = matcher.group();
            if (!s.startsWith("<")) {
                s = (String)sgroups.remove(0);
                boolean formatted = false;
                if (AppPreferences.formatnumbers) {
                    String ext = Placeables.getConvertedPlaceable(s);
                    if (ext == null) {
                        Matcher matcher2 = numberSpacePattern.matcher(s);
                        StringBuffer sb2 = new StringBuffer();
                        while (matcher2.find()) {
                            String group = matcher2.group();
                            String s3 = Placeables.getConvertedPlaceable(group);
                            if (s3 == null) {
                                String s2 = NumbersHelper.formatLocaleNumber(group);
                                if (!s2.equals(group)) {
                                    formatted = true;
                                }
                                matcher2.appendReplacement(sb2, s2);
                                continue;
                            }
                            matcher2.appendReplacement(sb2, s3);
                            formatted = true;
                        }
                        matcher2.appendTail(sb2);
                        s = sb2.toString();
                    } else {
                        s = ext;
                        formatted = true;
                    }
                }
                if (AppPreferences.replaceAtTransfer && !formatted) {
                    s = WorkflowView.replaceCharacters(s);
                }
            }
            matcher.appendReplacement(sb, s);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String formatLocaleNumber(String sn) {
        String sourceNumber;
        String sg = sn;
        boolean brackets = false;
        if (sn.length() > 3) {
            char c = sn.charAt(0);
            char cc = sn.charAt(sn.length() - 1);
            if (!Character.isLetterOrDigit(c) && !Character.isLetterOrDigit(cc)) {
                brackets = true;
                sg = sn.substring(1, sn.length() - 2);
            }
        }
        char[] chars = sg.toCharArray();
        boolean allDigits = true;
        boolean endNoDigit = false;
        boolean startZero = false;
        boolean noDecimalSeparator = true;
        boolean noGroupingSeparator = true;
        int digitCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (!Character.isDigit(aChar)) {
                allDigits = false;
                if (i == chars.length - 1) {
                    endNoDigit = true;
                }
                if (i == 1 && startZero) {
                    startZero = false;
                }
                if (aChar == decimalSeparator) {
                    noDecimalSeparator = false;
                }
                if (aChar != groupingSeparator && aChar != '\u00a0') continue;
                noGroupingSeparator = false;
                continue;
            }
            ++digitCount;
            if (i != 0 || aChar != '0') continue;
            startZero = true;
        }
        if (noDecimalSeparator && noGroupingSeparator || allDigits || endNoDigit || startZero) {
            return sn;
        }
        if (sourceLocale == null) {
            return sn;
        }
        DecimalFormat dfSource = formatMap.get(sourceLocale);
        if (dfSource == null) {
            dfSource = (DecimalFormat)DecimalFormat.getInstance(sourceLocale);
            if (dfSource == null) {
                return sn;
            }
            formatMap.put(sourceLocale, dfSource);
        }
        dfSource.setRoundingMode(RoundingMode.DOWN);
        if (!noGroupingSeparator && digitCount > 3) {
            sourceNumber = sg.replace(String.valueOf('\u00a0'), "");
            sourceNumber = sg.replace(String.valueOf('\u202f'), "");
        } else {
            sourceNumber = sg;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number num = dfSource.parse(sourceNumber, parsePosition);
        int parseIndex = parsePosition.getIndex();
        if (parseIndex != sourceNumber.length()) {
            return sn;
        }
        if (targetLocale == null) {
            return sn;
        }
        double dv = num.doubleValue();
        DecimalFormat dfTarget = formatMap.get(targetLocale);
        if (dfTarget == null) {
            dfTarget = (DecimalFormat)DecimalFormat.getInstance(targetLocale);
            if (dfTarget == null) {
                return sn;
            }
            formatMap.put(targetLocale, dfTarget);
        }
        dfTarget.setRoundingMode(RoundingMode.DOWN);
        try {
            String targetNumber = dfTarget.format(dv);
            if (sourceNumber.length() > targetNumber.length()) {
                String z;
                String s = sourceNumber.substring(targetNumber.length());
                if (s.equals(z = Character.toString(decimalSeparator) + "0")) {
                    dfTarget.setMinimumFractionDigits(1);
                    targetNumber = dfTarget.format(dv);
                } else {
                    targetNumber = targetNumber + s;
                }
            }
            if (!brackets) {
                return targetNumber;
            }
            char c = sn.charAt(0);
            char cc = sn.charAt(sn.length() - 1);
            String tn = Character.toString(c) + targetNumber + Character.toString(cc);
            return tn;
        }
        catch (ArithmeticException ex) {
            return sn;
        }
    }

    public static Pattern getNumberPattern() {
        return numberPattern;
    }

    public static boolean isNumeric(String str) {
        char[] arr = str.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            char c = arr[i];
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String s = "345\u202f987.246";
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.FRENCH);
        DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
        char thousandSep = symbols.getGroupingSeparator();
        s = s.replace(String.valueOf(thousandSep), "");
        double d = Double.parseDouble(s);
        System.out.println(d);
        DecimalFormat dff = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        ParsePosition parsePosition = new ParsePosition(0);
        Number num = df.parse(s, parsePosition);
        double dv = num.doubleValue();
        String sn = dff.format(d);
        System.out.println(sn);
    }
}

