/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

final class PrinterWork
implements Printable {
    private boolean EOF = false;
    private int remPageIndex = -1;
    private String text;
    private static AttributedString mstyledText;
    private AttributedCharacterIterator charIterator;
    private LineBreakMeasurer measurer;
    private float wrappingWidth;
    private Font fnt;
    private BufferedReader br;

    PrinterWork(String text, Font fnt) {
        this.fnt = fnt;
        this.text = text;
        try {
            this.br = new BufferedReader(new StringReader(text));
        }
        catch (Exception e) {
            this.EOF = true;
        }
    }

    @Override
    public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
        try {
            if (pageIndex != this.remPageIndex) {
                this.remPageIndex = pageIndex;
                if (this.EOF) {
                    return 1;
                }
                this.br.mark(this.text.length() + 1);
            } else {
                this.br.reset();
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(format.getImageableX(), format.getImageableY());
            Point2D.Float pen = new Point2D.Float();
            g2d.setPaint(Color.black);
            this.wrappingWidth = (float)format.getImageableWidth();
            while ((double)(pen.y + this.fnt.getSize2D()) < format.getImageableHeight()) {
                String line = this.br.readLine();
                if (line == null) {
                    this.EOF = true;
                    break;
                }
                if (line.length() == 0) {
                    line = " ";
                }
                mstyledText = new AttributedString(line);
                mstyledText.addAttribute(TextAttribute.FONT, this.fnt);
                this.charIterator = mstyledText.getIterator();
                this.measurer = new LineBreakMeasurer(this.charIterator, g2d.getFontRenderContext());
                while (this.measurer.getPosition() < this.charIterator.getEndIndex()) {
                    TextLayout layout = this.measurer.nextLayout(this.wrappingWidth);
                    pen.y += layout.getAscent();
                    float dx = layout.isLeftToRight() ? 0.0f : this.wrappingWidth - layout.getAdvance();
                    layout.draw(g2d, pen.x + dx, pen.y);
                    pen.y += layout.getDescent() + layout.getLeading();
                }
            }
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }
}

