/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.BreakIterator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import translator.AppPreferences;
import translator.Converter;
import translator.DefaultXMLElement;
import translator.DocumentChooser;
import translator.FileFilters;
import translator.GlossaryResource;
import translator.MainView;
import translator.MySwingWorker;
import translator.NaturalOrderComparator;
import translator.NumbersHelper;
import translator.ProjectView;
import translator.Resource;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.StatisticsView;
import translator.Tag;
import translator.TextResource;
import translator.Translatable;
import translator.TranslationHandler;
import translator.TranslationUnitMap;
import translator.Workflow;
import translator.WorkflowManager;
import translator.WorkflowView;
import translator.XMLElement;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.tmx.TMXUnitMap;
import translator.tmx.TMXView;
import translator.tmx.TMXWorkflow;
import translator.ttx.Raw;
import translator.ttx.TTX;
import translator.ttx.TTXHandler;
import translator.ttx.TTXView;
import translator.ttx.TTXWorkflow;
import translator.xliff.BinaryUnit;
import translator.xliff.FileBody;
import translator.xliff.FileHeader;
import translator.xliff.Reference;
import translator.xliff.Skeleton;
import translator.xliff.TXMLHandler;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;
import translator.xliff.XliffHandler;
import translator.xliff.XliffView;
import translator.xliff.XliffWorkflow;

public class Project {
    private MainView topui;
    private WorkflowView wview;
    private String sdlProjFileName;
    private String projectPath;
    private String filepath;
    private String packagePath;
    private String zipPackageName;
    private String zipPackagePath;
    private String zipPackageDir;
    private String projectName;
    private ArrayList projects;
    XLIFF xliff;
    TTX ttx;
    TMX tmx;
    Memory memory;
    public int mode = 0;
    public boolean align;
    public boolean autoalign;
    public boolean filter = false;
    public boolean glue = false;
    public boolean superglue = false;
    public boolean sdlxliffType = false;
    public boolean sdlxliffFile = false;
    public boolean xliffFile = false;
    public boolean poFile = false;
    private int libreOfficeMode = 0;
    public boolean translatedStatusSet = false;
    public static boolean hasSDLTargetSegments = false;
    public static boolean hasSDLSourceSegments = false;
    private int idCounter = 0;
    private int currentTUIndexNoFilter = -1;
    private static List subjects;
    private static List clients;
    public static String userProjectName;
    private String previewReferencePath;
    private List filesFilter;
    private static HashMap projectMemory;
    private static LinkedHashMap<String, Tag> tags;
    private LinkedHashMap<String, String> documentFilterMap;
    private boolean closed = false;
    private int exportStartTU = -1;
    private Memory replacementMemory;
    int tagsQA = 0;
    private BreakIterator sourceBreakIterator;
    private BreakIterator targetBreakIterator;

    public Project(MainView topui, String path) {
        this.topui = topui;
        this.wview = topui.getWorkflowView();
        if (path != null) {
            this.projectPath = path;
        } else {
            this.projectName = "MyProject";
        }
        projectMemory = new HashMap(500);
        tags = new LinkedHashMap();
    }

    public void setExportStartTU(int no) {
        this.exportStartTU = no;
    }

    public void setClosed(boolean c) {
        this.closed = c;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static void addTag(String id, Tag tag) {
        tags.put(id, tag);
    }

    public static Tag getTag(String id) {
        return tags.get(id);
    }

    public LinkedHashMap getTags() {
        return tags;
    }

    public static HashMap getProjectMemory() {
        return projectMemory;
    }

    public void createFilesFilter(String s) {
        this.filesFilter = new ArrayList();
        if (s.indexOf(124) != -1) {
            String[] arr = s.split("\\|");
            for (int i = 0; i < arr.length; ++i) {
                String arr1 = arr[i];
                if (arr1.length() <= 0) continue;
                this.filesFilter.add(arr1);
            }
        } else {
            this.filesFilter.add(s);
        }
    }

    public List getFilesFilter() {
        return this.filesFilter;
    }

    public static List getSubjectList() {
        return subjects;
    }

    public static List getClientList() {
        return clients;
    }

    public static void loadFieldLists() {
        MySwingWorker worker = new MySwingWorker(){

            @Override
            public Object construct() {
                if (AppPreferences.subjectListPath != null && AppPreferences.subjectListPath.length() > 0) {
                    Project.setSubjectList(AppPreferences.subjectListPath);
                }
                if (AppPreferences.clientListPath != null && AppPreferences.clientListPath.length() > 0) {
                    Project.setClientList(AppPreferences.clientListPath);
                }
                return null;
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSubjectList(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            FileInputStream fis = null;
            subjects = new ArrayList(20);
            try {
                String eline;
                fis = new FileInputStream(file);
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                while ((eline = r.readLine()) != null) {
                    int hash = eline.indexOf(35);
                    if (hash != -1) {
                        if (eline.charAt(0) == '#') continue;
                        eline = eline.substring(0, hash);
                    }
                    subjects.add(eline);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + file.getPath());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClientList(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            FileInputStream fis = null;
            clients = new ArrayList(20);
            try {
                String eline;
                fis = new FileInputStream(file);
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                while ((eline = r.readLine()) != null) {
                    int hash = eline.indexOf(35);
                    if (hash != -1) {
                        if (eline.charAt(0) == '#') continue;
                        eline = eline.substring(0, hash);
                    }
                    clients.add(eline);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + file.getPath());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void createProjectGlossary() {
        File pf;
        String xlfdir;
        boolean ct = false;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF) {
            ct = true;
        }
        String p = null;
        if (!ct && this.packagePath != null && this.packagePath.length() > 0) {
            p = this.packagePath;
        } else if (this.projectPath != null && this.projectPath.length() > 0) {
            p = this.projectPath;
        }
        if (p != null && (xlfdir = (pf = new File(p)).getParent()) != null) {
            String gpath = xlfdir + AppPreferences.fs + "ProjectTerms.txt";
            ResourceInfo ri = new ResourceInfo();
            ri.setEntry("Path", gpath);
            ri.setEntry("Name", "ProjectTerms");
            ri.setEntry("Encoding", "UTF-8");
            ri.setEntry("Entry word separator", "\t");
            ri.setEntry("Priority", "2");
            GlossaryResource g = new GlossaryResource(ri);
            g.setMainView(this.topui);
            this.topui.getResourceView().addGlossary(g);
            g.checkTrialVersionLimit(false);
        }
    }

    public void createProjectTM() {
        boolean ct = false;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF) {
            ct = true;
        }
        String p = null;
        if (!ct && this.packagePath != null && this.packagePath.length() > 0) {
            p = this.packagePath;
        } else if (this.projectPath != null && this.projectPath.length() > 0) {
            p = this.projectPath;
        }
        if (p != null) {
            Memory m = this.topui.getMemoryView().newProjectMemory();
            this.topui.getMemoryView().setProjectMemory(m);
            File pf = new File(p);
            String xlfdir = pf.getParent();
            if (xlfdir != null) {
                String mpath = xlfdir + AppPreferences.fs + "ProjectTM.tmx";
                m.saveMemory(mpath);
            }
        }
    }

    public String getProjectDirectory() {
        boolean ct = false;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF) {
            ct = true;
        }
        String p = null;
        if (!ct && this.packagePath != null && this.packagePath.length() > 0) {
            p = this.packagePath;
        } else if (this.projectPath != null && this.projectPath.length() > 0) {
            p = this.projectPath;
        }
        if (p == null) {
            return null;
        }
        File pf = new File(p);
        String dir = pf.getParent();
        return dir;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getPackagePath() {
        return this.zipPackagePath;
    }

    public String getProjectFolderName() {
        File file;
        String s = null;
        if (this.projectPath != null && (file = new File(this.projectPath)).exists() && (file = file.getParentFile()).exists()) {
            s = file.getName();
        }
        return s;
    }

    public String getProjectTMPath() {
        boolean ct = false;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF) {
            ct = true;
        }
        String p = null;
        if (!ct && this.packagePath != null && this.packagePath.length() > 0) {
            p = this.packagePath;
        } else if (this.projectPath != null && this.projectPath.length() > 0) {
            p = this.projectPath;
        }
        if (p == null) {
            return null;
        }
        File pf = new File(p);
        String xlfdir = pf.getParent();
        String mpath = xlfdir + AppPreferences.fs + "ProjectTM.tmx";
        File mfile = new File(mpath);
        if (!mfile.exists()) {
            return null;
        }
        boolean loaded = false;
        MemoryView mv = this.topui.getMemoryView();
        List mems = mv.getLocalMemories();
        for (Memory m : mems) {
            String mname = m.getName();
            if (mname == null || !mname.equals("ProjectTM")) continue;
            loaded = true;
            break;
        }
        if (!loaded) {
            return mpath;
        }
        return null;
    }

    public String getProjectTermsPath() {
        boolean ct = false;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF) {
            ct = true;
        }
        String p = null;
        if (!ct && this.packagePath != null && this.packagePath.length() > 0) {
            p = this.packagePath;
        } else if (this.projectPath != null && this.projectPath.length() > 0) {
            p = this.projectPath;
        }
        if (p == null) {
            return null;
        }
        File pf = new File(p);
        String xlfdir = pf.getParent();
        String gpath = xlfdir + AppPreferences.fs + "ProjectTerms.txt";
        File mfile = new File(gpath);
        if (!mfile.exists()) {
            return null;
        }
        boolean loaded = false;
        ResourceView rv = this.topui.getResourceView();
        List gl = rv.getGlossaries();
        if (gl != null) {
            for (GlossaryResource g : gl) {
                String mname = g.getName();
                if (mname == null || !mname.equals("ProjectTerms")) continue;
                loaded = true;
                break;
            }
        }
        if (!loaded) {
            return gpath;
        }
        return null;
    }

    public LinkedHashMap getSegmentAttributes() {
        if (this.xliff != null) {
            return this.xliff.getSegmentAttributes();
        }
        return null;
    }

    public void setSegmentAttribute(String name, String value) {
        String s;
        if (this.xliff != null && name != null && name.length() > 0 && value.trim().length() > 0 && (s = this.xliff.getAttribute("xmlns:property")) != null) {
            this.xliff.setAttribute(name, value);
        }
    }

    public void addDocumentFilter(String name, String value) {
        if (this.documentFilterMap == null) {
            this.documentFilterMap = new LinkedHashMap();
        }
        this.documentFilterMap.put(name, value);
    }

    public LinkedHashMap<String, String> getDocumentFilters() {
        return this.documentFilterMap;
    }

    public void setXLIFF(XLIFF xliff) {
        this.xliff = xliff;
        if (xliff.getView() == null) {
            XliffView xview = new XliffView(this.topui, xliff);
            xliff.setView(xview);
        }
        if (this.projects != null && !this.projects.contains(xliff)) {
            this.projects.add(xliff);
            xliff.setID(this.idCounter);
            xliff.setPath(this.filepath);
            ++this.idCounter;
        }
        AppPreferences.projectType = !xliff.isExternalToolXLIFF ? 0 : 3;
    }

    public void setXLIFF(int id) {
        Object o;
        if (this.projects != null && (o = this.projects.get(id)) != null && o instanceof XLIFF) {
            XLIFF t;
            this.xliff = t = (XLIFF)o;
            this.xliff.saved = false;
        }
    }

    public XLIFF getXLIFF() {
        return this.xliff;
    }

    public void setTTX(TTX ttx) {
        this.ttx = ttx;
        if (ttx.getView() == null) {
            TTXView view = new TTXView(this.topui, ttx);
            ttx.setView(view);
        }
        if (this.projects != null && !this.projects.contains(ttx)) {
            this.projects.add(ttx);
            ttx.setID(this.idCounter);
            ttx.setPath(this.filepath);
            ++this.idCounter;
        }
        AppPreferences.projectType = 1;
    }

    public void setTTX(int id) {
        Object o;
        if (this.projects != null && (o = this.projects.get(id)) != null && o instanceof TTX) {
            TTX t;
            this.ttx = t = (TTX)o;
            this.ttx.saved = false;
        }
    }

    public TTX getTTX(int id) {
        Object o;
        TTX t = null;
        if (this.projects != null && (o = this.projects.get(id)) != null && o instanceof TTX) {
            t = (TTX)o;
        }
        return t;
    }

    public TTX getTTX() {
        return this.ttx;
    }

    public void setTMX(TMX tmx) {
        this.tmx = tmx;
        if (this.projects != null) {
            if (!this.projects.contains(tmx)) {
                this.projects.add(tmx);
                tmx.setID(this.idCounter);
                tmx.setPath(this.filepath);
                ++this.idCounter;
            } else {
                TranslationUnitMap map;
                int projectID = tmx.getID();
                if (projectID != -1 && (map = tmx.getTUMap()) != null && map instanceof TMXUnitMap) {
                    TMXUnitMap xmap = (TMXUnitMap)map;
                    xmap.setProjectID(projectID);
                }
            }
        }
        AppPreferences.projectType = 2;
    }

    public TMX getTMX() {
        return this.tmx;
    }

    public void setTMX(int id) {
        Object o;
        if (this.projects != null && (o = this.projects.get(id)) != null && o instanceof TMX) {
            TranslationUnitMap map;
            TMX t;
            this.tmx = t = (TMX)o;
            this.tmx.saved = false;
            int projectID = this.tmx.getID();
            if (projectID != -1 && (map = this.tmx.getTUMap()) != null && map instanceof TMXUnitMap) {
                TMXUnitMap xmap = (TMXUnitMap)map;
                xmap.setProjectID(projectID);
            }
        }
    }

    public TMX getTMX(int id) {
        Object o;
        TMX t = null;
        if (this.projects != null && (o = this.projects.get(id)) != null && o instanceof TMX) {
            t = (TMX)o;
        }
        return t;
    }

    public List getProjects() {
        return this.projects;
    }

    public Memory getTMXMemory() {
        return this.memory;
    }

    public void createFile(boolean add) {
        this.topui.getWorkflowView().getWorkflowManager().endTranslation();
        if (this.xliff != null) {
            if (add && this.glue) {
                this.setGluedWorkflow(false);
            }
            this.xliff.getView().createFile(add);
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null) {
                this.setTitleForFile(file.getShortName());
            }
        }
    }

    public void replaceFile() {
        if (this.xliff != null) {
            if (!this.xliff.isCafeTranXLIFF) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOT A CAFETRAN PROJECT FILE!"));
                return;
            }
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null) {
                int value;
                this.topui.getWorkflowView().getWorkflowManager().endTranslation();
                String name = file.getShortName();
                if (name == null) {
                    name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE DOCUMENT");
                }
                if ((value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CURRENT DOCUMENT WILL BE REMOVED NOW."), name, 2, 1)) == 0) {
                    if (this.glue) {
                        this.setGluedWorkflow(false);
                    } else {
                        this.xliff.setWorkflow(null);
                    }
                    this.createReplacementMemory();
                    this.xliff.getView().replaceFile(file);
                    this.setTitleForFile(file.getShortName());
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOT A CAFETRAN PROJECT FILE!"));
        }
    }

    public void createReplacementMemory() {
        XliffFile file;
        if (this.xliff != null && (file = this.xliff.getCurrentFile()) != null) {
            this.replacementMemory = new Memory("");
            this.replacementMemory.setName("Memory");
            this.replacementMemory.setMainView(this.topui);
            this.replacementMemory.setSourceLangCode(AppPreferences.fileSLang);
            this.replacementMemory.setTargetLangCode(AppPreferences.fileTLang);
            this.replacementMemory.setDuplicatesMode(-1);
            this.replacementMemory.newTM(1000);
            Converter conv = new Converter(this, this.replacementMemory);
            conv.setMainView(this.topui);
            conv.toReplacementMemory();
        }
    }

    public void setExactMachesFromReplacementMemory() {
        TranslationHandler handler = new TranslationHandler(this.topui);
        if (this.replacementMemory != null) {
            handler.autotranslateWithReplacementMemory(this, this.replacementMemory);
        }
    }

    public void resetFileIDs() {
        if (this.xliff != null) {
            ArrayList<XLIFF> xliffs;
            if (this.projects != null) {
                xliffs = this.projects;
            } else {
                xliffs = new ArrayList<XLIFF>(1);
                xliffs.add(this.xliff);
            }
            this.idCounter = 0;
            XLIFF.fileCounter = 0;
            XLIFF.unitCounter = 0;
            for (XLIFF next : xliffs) {
                next.setID(this.idCounter);
                ++this.idCounter;
                Map map = next.getFilesMap();
                map.clear();
                List files = next.getFiles();
                for (XliffFile next1 : files) {
                    next1.setFileID(XLIFF.fileCounter);
                    map.put(XLIFF.fileCounter, next1);
                    ++XLIFF.fileCounter;
                    FileBody body = next1.getBody();
                    body.unitNumber = 0;
                    List units = body.getTransUnits();
                    for (XLIFFUnit next2 : units) {
                        next2.setProjectID(next.getID());
                        next2.setFileID(next1.getFileID());
                        next2.setUnitID(++XLIFF.unitCounter);
                        ++body.unitNumber;
                        next2.setUnitNumber(body.unitNumber);
                    }
                }
            }
        }
    }

    public void resetUnitsIDs() {
        if (this.xliff != null) {
            ArrayList<XLIFF> xliffs;
            if (this.projects != null) {
                xliffs = this.projects;
            } else {
                xliffs = new ArrayList<XLIFF>(1);
                xliffs.add(this.xliff);
            }
            XLIFF.unitCounter = 0;
            for (XLIFF next : xliffs) {
                List files = next.getFiles();
                for (XliffFile next1 : files) {
                    FileBody body = next1.getBody();
                    body.unitNumber = 0;
                    List units = body.getTransUnits();
                    for (XLIFFUnit next2 : units) {
                        next2.setUnitID(++XLIFF.unitCounter);
                        ++body.unitNumber;
                        next2.setUnitNumber(body.unitNumber);
                    }
                }
            }
        }
    }

    public void removeFile(XliffFile file) {
        if (this.xliff != null) {
            Translatable tr;
            this.xliff.removeFile(file);
            String opath = file.getTranslatablePath();
            if (opath != null && (tr = this.topui.getResourceView().getTranslatable(opath)) != null) {
                this.topui.getResourceView().removeTranslatable(tr);
                File doc = new File(opath);
                if (doc.exists()) {
                    doc.delete();
                }
            }
            this.resetFileIDs();
        }
    }

    public void removeAllFiles() {
        if (this.xliff != null) {
            List files = this.xliff.getFiles();
            for (XliffFile file : files) {
                Translatable tr;
                this.xliff.removeChild(file);
                String opath = file.getTranslatablePath();
                if (opath == null || (tr = this.topui.getResourceView().getTranslatable(opath)) == null) continue;
                this.topui.getResourceView().removeTranslatable(tr);
            }
            this.resetFileIDs();
        }
    }

    public void editFile() {
        if (this.xliff != null) {
            this.xliff.getView().editFile();
        } else if (this.ttx != null) {
            this.ttx.getView().editFile();
        } else if (this.tmx != null) {
            this.tmx.getView().editFile();
        }
    }

    public void showFiles() {
        if (this.xliff != null) {
            if (this.projects != null && this.projects.size() > 1) {
                this.xliff.getView().getMenu().showProjectsDialog(this.projects);
            } else {
                this.xliff.getView().getMenu().showFilesDialog();
            }
        } else if (this.ttx != null) {
            if (this.projects != null && this.projects.size() > 1) {
                this.ttx.getView().getMenu().showProjectsDialog(this.projects);
            } else {
                this.ttx.getView().getMenu().showFilesDialog();
            }
        } else if (this.tmx != null && this.projects != null && this.projects.size() > 1) {
            this.tmx.getView().getMenu().showProjectsDialog(this.projects);
        }
    }

    public void showRemoveFiles() {
        if (this.xliff != null) {
            if (this.projects != null && this.projects.size() > 1) {
                this.xliff.getView().getMenu().showRemoveProjectsDialog(this.projects);
            } else {
                this.xliff.getView().getMenu().showRemoveFilesDialog();
            }
        } else if (this.tmx != null && this.projects != null && this.projects.size() > 1) {
            this.tmx.getView().getMenu().showRemoveProjectsDialog(this.projects);
        }
    }

    public void showPopUp(Component comp, int x, int y, Object o) {
        if (this.xliff != null) {
            this.xliff.getView().showPopUp(comp, x, y, o);
        } else if (this.tmx != null) {
            this.tmx.getView().showPopUp(comp, x, y, o);
        } else if (this.ttx != null) {
            this.ttx.getView().showPopUp(comp, x, y, o);
        }
    }

    public void checkSourceFilesReferences() {
        List files;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF && (files = this.xliff.getFiles()).size() > 1) {
            for (XliffFile file : files) {
                this.updateSkeletonReference(file);
            }
        }
    }

    public List getProjectFiles() {
        if (this.xliff != null) {
            return this.xliff.getFiles();
        }
        if (this.ttx != null) {
            return this.ttx.getFiles();
        }
        return null;
    }

    public void chooseFile() {
        List list;
        if (this.xliff != null && AppPreferences.original != null && AppPreferences.original.length() > 0 && (list = this.getProjectFiles()) != null && list.size() > 1) {
            for (XliffFile file : list) {
                String org = file.getAttribute("original");
                if (org == null || !org.equals(AppPreferences.original)) continue;
                this.xliff.setCurrentFile(file);
                this.xliff.setWorkflow(null);
                break;
            }
        }
    }

    public String updateSkeletonReference(XliffFile xfile) {
        XMLElement exf;
        Skeleton sk;
        String href = null;
        FileHeader h = xfile.getHeader();
        if (h != null && (sk = h.getSkeleton()) != null && (exf = sk.getExternalFile()) != null) {
            href = exf.getAttribute("href");
        }
        if (href == null || href.length() == 0) {
            href = xfile.getAttribute("original");
        }
        if (href != null) {
            int fsep;
            File file = new File(href);
            if (file.exists()) {
                return href;
            }
            if (this.projectPath != null && (fsep = this.projectPath.lastIndexOf(AppPreferences.fs)) != -1) {
                String pname;
                int i;
                String fdir = this.projectPath.substring(0, fsep + 1);
                String fn = file.getName();
                String sref = fdir + fn;
                file = new File(sref);
                if (file.exists()) {
                    h.setSkeletonReference(sref);
                    return sref;
                }
                int j = this.projectName.indexOf(".xlf");
                if (j != -1 && (i = href.lastIndexOf(pname = this.projectName.substring(0, j))) != -1) {
                    sref = fdir + href.substring(i);
                    try {
                        Pattern p = Pattern.compile(" ", 16);
                        sref = p.matcher(sref).replaceAll("%20");
                        p = Pattern.compile("\\", 16);
                        sref = p.matcher(sref).replaceAll("/");
                        URL url = new URL("file:///" + sref);
                        file = new File(url.toURI());
                        if (file.exists()) {
                            sref = file.getPath();
                            h.setSkeletonReference(sref);
                            return sref;
                        }
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return null;
    }

    public void openSkeleton(XliffFile currentFile) {
        String href;
        String phase;
        String fmt;
        if (this.xliff == null || !this.xliff.isCafeTranXLIFF) {
            return;
        }
        String tool = currentFile.getAttribute("tool-id");
        if (tool != null && tool.equalsIgnoreCase("CafeTran-LibreOffice")) {
            this.libreOfficeMode = 1;
            ResourceView rv = this.topui.getResourceView();
            boolean isOO = rv.openOOResource();
            if (isOO) {
                return;
            }
            this.libreOfficeMode = 0;
            AppPreferences.tool = tool = "CafeTran";
        }
        if ((fmt = currentFile.getAttribute("datatype")) != null) {
            if (fmt.equals("x-image")) {
                this.mode = 2;
            } else if (fmt.equals("x-clipboard")) {
                this.mode = 3;
            }
        }
        boolean editor = true;
        if (this.mode == 1) {
            editor = false;
        }
        if ((phase = currentFile.getCurrentPhase()) != null) {
            if (phase.equals("Alignment")) {
                this.align = true;
            } else if (phase.equals("Autoalignment")) {
                this.align = true;
                this.autoalign = true;
                editor = false;
            } else if (phase.equals("Review") || phase.equals("End")) {
                editor = false;
            }
        }
        if ((href = this.updateSkeletonReference(currentFile)) == null) {
            if (this.mode < 2) {
                JOptionPane.showMessageDialog(this.topui, "Source document reference not found!");
            }
            return;
        }
        List list = this.topui.getResourceLoader().getDocumentLoaderList();
        if (list.contains(href)) {
            return;
        }
        File f = new File(href);
        if (!f.exists()) {
            if (this.mode < 2) {
                JOptionPane.showMessageDialog(this.topui, "Source file reference not found!");
            }
            return;
        }
        if (this.poFile) {
            return;
        }
        if (tool != null && tool.equalsIgnoreCase("CafeTran") && f.exists()) {
            ResourceView rv = this.topui.getResourceView();
            String format = this.xliff.getFormat();
            String ext = href.toLowerCase();
            if (format.startsWith("Image") || ext.endsWith(".jpg") || ext.endsWith(".gif") || ext.endsWith(".bmp") || ext.endsWith(".png")) {
                this.topui.getResourceLoader().prepareImageResource(href);
                List docs = this.topui.getResourceLoader().getDocumentLoaderList();
                if (!docs.contains(href)) {
                    docs.add(href);
                }
            } else {
                rv.openDocument(f, editor, currentFile.getAttributes());
                if (this.align) {
                    File refFile;
                    String sref;
                    File file2 = null;
                    DocumentChooser ch = new DocumentChooser(this.topui);
                    FileHeader h = currentFile.getHeader();
                    Reference ref = h.getReference("Aligned document");
                    if (ref != null && (sref = ref.getExternalFile().getAttribute("href")) != null && (refFile = new File(sref)).exists()) {
                        Resource r = editor ? ch.fileOpen(refFile, AppPreferences.format, AppPreferences.en, null, currentFile.getAttributes()) : ch.fileLoad(refFile, AppPreferences.format, AppPreferences.en, null, currentFile.getAttributes());
                        file2 = ch.getSelectedFile();
                        if (file2 != null && r instanceof Translatable) {
                            Translatable translatable = (Translatable)((Object)r);
                            this.topui.getResourceView().addTranslatable(translatable);
                        }
                    }
                    if (file2 == null) {
                        ch.fileOpen();
                    }
                    file2 = ch.getSelectedFile();
                    String fname1 = f.getName();
                    if (fname1 != null && file2 != null) {
                        String fname2 = file2.getName();
                        this.topui.synchronizeViews(fname1, fname2);
                        ProjectView pro = this.topui.getProjectView();
                        String aref = file2.getPath();
                        pro.setReference(aref, "Aligned document");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSDLLanguagePair(ZipFile zfile, ZipEntry entry, String encoding) {
        String[] pair = new String[2];
        Pattern pattern = Pattern.compile("<LanguageDirection .+?>");
        InputStream is = null;
        try {
            int i;
            int size = (int)entry.getSize();
            is = zfile.getInputStream(entry);
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] buf = new byte[size];
            bis.read(buf, 0, size);
            bis.close();
            String outString = new String(buf, 0, buf.length, encoding);
            Matcher m = pattern.matcher(outString);
            String group = null;
            if (m.find() && (i = (group = m.group()).indexOf("SourceLanguageCode=\"")) != -1) {
                String sl;
                int j = group.indexOf("\"", i += 20);
                pair[0] = sl = group.substring(i, j);
                i = group.indexOf("TargetLanguageCode=\"");
                if (i != -1) {
                    String tl;
                    j = group.indexOf("\"", i += 20);
                    pair[1] = tl = group.substring(i, j);
                }
            }
            String[] stringArray = pair;
            return stringArray;
        }
        catch (IOException ex) {
            Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSDLTMs(ZipFile zfile, ZipEntry entry, String encoding) {
        ArrayList<String> tmList = new ArrayList<String>(2);
        Pattern pattern = Pattern.compile("<CascadeEntryItem.+?</CascadeEntryItem>", 32);
        InputStream is = null;
        try {
            int size = (int)entry.getSize();
            is = zfile.getInputStream(entry);
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] buf = new byte[size];
            bis.read(buf, 0, size);
            bis.close();
            String outString = new String(buf, 0, buf.length, encoding);
            Matcher m = pattern.matcher(outString);
            String group = null;
            while (m.find()) {
                group = m.group();
                int i = group.indexOf("sdltm.file:///Tm/");
                while (i != -1) {
                    int j = group.indexOf(".sdltm", i += 17);
                    if (j != -1) {
                        String fa = group.substring(i, j + 6);
                        tmList.add(fa);
                        i = j;
                    }
                    i = group.indexOf("sdltm.file:///Tm/", i);
                }
            }
            ArrayList<String> arrayList = tmList;
            return arrayList;
        }
        catch (IOException ex) {
            Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public boolean makeZippedCTProject(File file) {
        boolean success = false;
        String dirPath = null;
        boolean extract = true;
        try {
            String path = file.getPath();
            int i = path.indexOf(".ctp");
            if (i == -1 && (i = path.indexOf(".mqxlz")) == -1) {
                return false;
            }
            dirPath = path.substring(0, i);
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdir();
            } else {
                extract = false;
            }
            this.packagePath = dirPath;
            this.zipPackageName = file.getName();
            this.zipPackagePath = file.getPath();
            this.zipPackageDir = file.getParent();
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                int fs = entryName.indexOf(AppPreferences.fs);
                if (fs == -1 && AppPreferences.fs.equals("/")) {
                    entryName = entryName.replace('\\', '/');
                }
                if (extract) {
                    File destFile = new File(dir, entryName);
                    File destinationParent = destFile.getParentFile();
                    destinationParent.mkdirs();
                }
                if (entry.isDirectory() || !extract) continue;
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(dirPath + AppPreferences.fs + entryName);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            System.err.println("Unhandled exception:");
            ioe.printStackTrace();
            return false;
        }
        String p = dirPath;
        File f = new File(p);
        if (f.exists()) {
            this.projectPath = p;
            boolean succ = this.loadGlueProject(f);
            if (succ) {
                success = true;
            }
        }
        return success;
    }

    public boolean makeZippedSDLProject(File file) {
        boolean success = false;
        String sourceLang = null;
        String targetLang = null;
        String dirPath = null;
        List tms = null;
        boolean extract = true;
        try {
            String path = file.getPath();
            int i = path.toLowerCase().indexOf(".sdlppx");
            if (i == -1) {
                return false;
            }
            dirPath = path.substring(0, i);
            File dir = new File(dirPath);
            if (!dir.exists()) {
                dir.mkdir();
            } else {
                extract = false;
            }
            this.packagePath = dirPath;
            this.zipPackageName = file.getName();
            this.zipPackagePath = file.getPath();
            this.zipPackageDir = file.getParent();
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                int fs = entryName.indexOf(AppPreferences.fs);
                if (fs == -1 && AppPreferences.fs.equals("/")) {
                    entryName = entryName.replace('\\', '/');
                }
                if (extract) {
                    File destFile = new File(dir, entryName);
                    File destinationParent = destFile.getParentFile();
                    destinationParent.mkdirs();
                }
                if (entry.isDirectory()) continue;
                if (entryName.endsWith(".sdlproj")) {
                    this.sdlProjFileName = entryName;
                    String[] languagePair = Project.getSDLLanguagePair(zipFile, entry, "UTF-8");
                    sourceLang = languagePair[0];
                    targetLang = languagePair[1];
                    tms = Project.getSDLTMs(zipFile, entry, "UTF-8");
                }
                if (!extract) continue;
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(dirPath + AppPreferences.fs + entryName);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) >= 0) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            System.err.println("Unhandled exception:");
            ioe.printStackTrace();
            return false;
        }
        if (sourceLang != null && targetLang != null) {
            String pp;
            File ff;
            String p = dirPath + AppPreferences.fs + targetLang;
            File f = new File(p);
            if (f.exists()) {
                this.projectPath = p;
                AppPreferences.fileSDLTargetLang = targetLang;
                boolean succ = this.loadGlueProject(f);
                if (succ) {
                    String tp;
                    File tdir;
                    success = true;
                    String mp = dirPath + AppPreferences.fs + "Tm" + AppPreferences.fs + targetLang;
                    File mdir = new File(mp);
                    if (mdir.isDirectory()) {
                        File[] mfiles = mdir.listFiles();
                        if (mfiles != null) {
                            for (int i = 0; i < mfiles.length; ++i) {
                                File ff2 = mfiles[i];
                                String tm = ff2.getPath();
                                if (!tm.endsWith(".sdltm") && !tm.endsWith(".SDLTM")) continue;
                                this.topui.getResourceLoader().prepareSDLMemory(mdir.getPath());
                                break;
                            }
                        }
                    } else if (tms != null && !tms.isEmpty()) {
                        for (String next : tms) {
                            mp = dirPath + AppPreferences.fs + "Tm" + AppPreferences.fs + next;
                            File mfile2 = new File(mp);
                            if (!mfile2.exists()) continue;
                            this.topui.getResourceLoader().prepareSDLMemory(mfile2.getParent());
                            break;
                        }
                    }
                    if ((tdir = new File(tp = dirPath + AppPreferences.fs + "Termbases")).isDirectory()) {
                        this.topui.getResourceLoader().prepareSDLMemory(tp);
                    }
                }
            } else {
                f.mkdir();
            }
            if (!success && (ff = new File(pp = dirPath + AppPreferences.fs + sourceLang)).exists()) {
                this.projectPath = p;
                AppPreferences.fileSDLTargetLang = targetLang;
                boolean succ = this.loadGlueProject(ff);
                if (succ) {
                    String mp;
                    File mfile;
                    success = true;
                    if (this.projects != null) {
                        for (XLIFF x : this.projects) {
                            String xp = x.getPath();
                            int i = xp.indexOf(sourceLang);
                            if (i == -1) continue;
                            xp = xp.replaceFirst(sourceLang, targetLang);
                            x.setPath(xp);
                        }
                    } else {
                        XLIFF x = this.getXLIFF();
                        String xp = x.getPath();
                        int i = xp.indexOf(sourceLang);
                        if (i != -1) {
                            xp = xp.replaceFirst(sourceLang, targetLang);
                            x.setPath(xp);
                            this.projectPath = xp;
                        }
                    }
                    if ((mfile = new File(mp = dirPath + AppPreferences.fs + "Tm" + AppPreferences.fs + targetLang)).isDirectory()) {
                        this.topui.getResourceLoader().prepareSDLMemory(mp);
                    } else if (tms != null && !tms.isEmpty()) {
                        for (String next : tms) {
                            mp = dirPath + AppPreferences.fs + "Tm" + AppPreferences.fs + next;
                            File mfile2 = new File(mp);
                            if (!mfile2.exists()) continue;
                            this.topui.getResourceLoader().prepareSDLMemory(mfile2.getParent());
                            break;
                        }
                    }
                    String tp = dirPath + AppPreferences.fs + "Termbases";
                    File tdir = new File(tp);
                    if (tdir.isDirectory()) {
                        this.topui.getResourceLoader().prepareSDLMemory(tp);
                    }
                }
            }
        }
        return success;
    }

    private void findTranslationFiles(List tfiles, File dir) {
        File[] files = dir.listFiles();
        if (files.length > 1) {
            List<File> list = Arrays.asList(files);
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    File entry1 = (File)o1;
                    File entry2 = (File)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return super.compare(s1, s2);
                }
            });
        }
        boolean x = false;
        boolean t = false;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.findTranslationFiles(tfiles, file);
                continue;
            }
            String fpath = file.getPath().toLowerCase();
            if (fpath.endsWith(".xlf") || fpath.endsWith(".sdlxliff") || fpath.endsWith(".ttx") || fpath.endsWith(".xliff") || fpath.endsWith(".mqxliff") || fpath.endsWith(".mxliff") || fpath.endsWith(".txml") || fpath.endsWith(".txlf")) {
                tfiles.add(file);
                x = true;
                if (!t) continue;
                Iterator iterator = tfiles.iterator();
                while (iterator.hasNext()) {
                    File f = (File)iterator.next();
                    String s = f.getPath().toLowerCase();
                    if (!s.endsWith(".tmx")) continue;
                    iterator.remove();
                }
                continue;
            }
            if (!fpath.endsWith(".tmx") || x) continue;
            tfiles.add(file);
            t = true;
        }
    }

    public boolean loadGlueProject(File file) {
        this.projectName = file.getName();
        boolean success = false;
        ArrayList translationfiles = new ArrayList();
        this.findTranslationFiles(translationfiles, file);
        if (translationfiles.isEmpty()) {
            return false;
        }
        this.projects = new ArrayList(translationfiles.size());
        String fname = null;
        for (int i = 0; i < translationfiles.size(); ++i) {
            File file1 = (File)translationfiles.get(i);
            boolean suc = this.loadProject(file1);
            if (!suc) continue;
            fname = file1.getName();
            success = true;
        }
        if (this.projects.isEmpty()) {
            return false;
        }
        Object o = this.projects.get(0);
        if (o != null) {
            DefaultXMLElement t;
            if (o instanceof TTX) {
                t = (TTX)o;
                this.setTTX((TTX)t);
                ((TTX)t).saved = false;
                if (this.projects.size() == 1) {
                    this.projectPath = ((TTX)t).getPath();
                    this.projectName = fname;
                    this.projects = null;
                }
                this.topui.getResourceLoader().addProject(this.projectPath);
            } else if (o instanceof XLIFF) {
                t = (XLIFF)o;
                this.setXLIFF((XLIFF)t);
                ((XLIFF)t).saved = false;
                if (this.projects.size() == 1) {
                    this.projectPath = ((XLIFF)t).getPath();
                    this.projectName = fname;
                    this.projects = null;
                }
                if (this.zipPackagePath != null) {
                    this.topui.getResourceLoader().addProject(this.zipPackagePath);
                } else {
                    this.topui.getResourceLoader().addProject(this.projectPath);
                }
            } else if (o instanceof TMX) {
                t = (TMX)o;
                this.setTMX((TMX)t);
                ((TMX)t).saved = false;
                if (this.projects.size() == 1) {
                    this.projectPath = ((TMX)t).getPath();
                    this.projectName = fname;
                    this.projects = null;
                }
                this.topui.getResourceLoader().addProject(this.projectPath);
            }
        }
        return success;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadProject(File file) {
        try {
            void var3_10;
            if (this.projects == null) {
                this.projectName = file.getName();
                if (this.zipPackagePath != null) {
                    this.topui.getResourceLoader().addProject(this.zipPackagePath);
                } else {
                    this.topui.getResourceLoader().addProject(this.projectPath);
                }
            }
            this.filepath = file.getPath();
            String fpath = this.filepath.toLowerCase();
            if (fpath.endsWith(".tmx")) {
                if (this.memory == null) {
                    this.memory = new Memory(this.filepath);
                    this.memory.setNewlyAdded(true);
                    this.memory.setProject(this);
                    this.memory.setMainView(this.topui);
                    this.memory.showStartDialog(this.getName());
                    if (this.memory.canLoad()) {
                        int n = this.memory.loadTMXProject();
                        if (n != 0) return true;
                        String n2 = this.memory.getName();
                        n2 = n2 != null ? " - " + n2 : " - TM";
                        this.memory.showStartDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE SOURCE AND TARGET LANGUAGES!") + n2);
                        if (!this.memory.canLoad()) return true;
                        this.memory.switchProjectTM();
                        return true;
                    } else {
                        this.memory = null;
                    }
                    return true;
                } else {
                    this.memory.setProject(this);
                    this.memory.setPath(this.filepath);
                    this.memory.loadTMXProject();
                }
                return true;
            }
            if (fpath.endsWith(".sdlxliff")) {
                this.sdlxliffType = true;
                this.sdlxliffFile = true;
            } else if (fpath.endsWith(".mqxliff")) {
                this.sdlxliffType = true;
            } else if (fpath.endsWith(".txlf")) {
                this.sdlxliffType = true;
            } else if (fpath.endsWith(".mxliff")) {
                this.sdlxliffType = true;
            } else if (fpath.endsWith(".xliff") || fpath.endsWith(".xlf")) {
                this.xliffFile = true;
            }
            if (fpath.endsWith(".ttx")) {
                if (this.xliff != null) return false;
                TTXHandler tTXHandler = new TTXHandler(this.topui, this);
            } else {
                if (!(fpath.endsWith(".xlf") || fpath.endsWith(".xliff") || fpath.endsWith(".sdlxliff") || fpath.endsWith(".mxliff") || fpath.endsWith(".mqxliff") || fpath.endsWith(".txml"))) {
                    if (!fpath.endsWith(".txlf")) return false;
                }
                if (this.ttx != null) return false;
                if (!fpath.endsWith(".txml")) {
                    XliffHandler xliffHandler = new XliffHandler(this.topui, this, false);
                } else {
                    TXMLHandler tXMLHandler = new TXMLHandler(this.topui, this);
                }
            }
            FileInputStream fis = new FileInputStream(file);
            InputSource is = new InputSource(fis);
            is.setSystemId("file:" + AppPreferences.packagePath);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", var3_10);
            saxParser.parse(is, (DefaultHandler)var3_10);
            return true;
        }
        catch (SAXException e) {
            e.printStackTrace();
            final String string = e.getMessage();
            int i = string.indexOf("0x");
            int j = string.indexOf(41, i);
            if (i != -1 && j != -1) {
                String m = string.substring(i + 2, j);
                String s = m.length() > 1 ? "[\\u00" + string.substring(i + 2, j) + "]+" : "[\\u000" + string.substring(i + 2, j) + "]+";
                Project.searchAndReplaceInFile(file, "UTF-8", s, "");
                if (this.projects == null) return this.loadProject(file);
                if (this.xliff == null) return this.loadProject(file);
                if (!this.projects.contains(this.xliff)) return this.loadProject(file);
                this.projects.remove(this.xliff);
                --this.idCounter;
                return this.loadProject(file);
            }
            if (string.indexOf("&#") != -1) {
                Project.searchAndReplaceInFile(file, "UTF-8", "&#.*?;", "");
                if (this.projects == null) return this.loadProject(file);
                if (this.xliff == null) return this.loadProject(file);
                if (!this.projects.contains(this.xliff)) return this.loadProject(file);
                this.projects.remove(this.xliff);
                --this.idCounter;
                return this.loadProject(file);
            }
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ Project this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(this.this$0.topui, string);
                }
            });
            this.projectPath = null;
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Project.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE") + " " + Project.this.projectPath);
                    if (Project.this.projectPath != null && Project.this.projectPath.toLowerCase().endsWith(".doc")) {
                        JOptionPane.showMessageDialog(Project.this.topui, "Please save this MS Word .doc file in the new MS Word .docx format and create a Project again.");
                    }
                    Project.this.projectPath = null;
                }
            });
            return false;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Project.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WRONG PARSER"));
                }
            });
            this.projectPath = null;
            return false;
        }
    }

    public static void searchAndReplaceInFile(File file, String enc, String search, String replace) {
        String content = TextResource.loadAsText(file, enc);
        if (content != null) {
            String result = content.replaceAll(search, replace);
            TextResource.storeAsText(file, result, enc);
        }
    }

    public void saveProjectAsTMX(final String path) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Project this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Memory ntr = new Memory("");
                ntr.setName("Memory");
                ntr.setMainView(this.this$0.topui);
                ntr.setSourceLangCode(AppPreferences.fileSLang);
                ntr.setTargetLangCode(AppPreferences.fileTLang);
                ntr.setDuplicatesMode(-1);
                ntr.newTM(1000);
                Converter conv = new Converter(this.this$0, ntr);
                conv.setMainView(this.this$0.topui);
                conv.toMemory();
                ntr.checkTrialVersionLimit();
                ntr.saveMemory(path);
            }
        });
    }

    private void saveProjects() {
        JProgressBar bar = this.topui.getProjectActionProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVING PROJECT") + " " + this.projectName + " ...");
        for (Object object : this.projects) {
            DefaultXMLElement t;
            if (object instanceof XLIFF) {
                t = (XLIFF)object;
                try {
                    if (this.xliff != null && this.xliff.equals(t)) {
                        ((XLIFF)t).writeXMLFormat();
                        continue;
                    }
                    if (((XLIFF)t).saved) continue;
                    ((XLIFF)t).writeXMLFormat();
                }
                catch (IOException ex) {
                    Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING PROJECT!"));
                }
                continue;
            }
            if (object instanceof TMX) {
                t = (TMX)object;
                try {
                    if (this.tmx != null && this.tmx.equals(t)) {
                        ((TMX)t).writeXMLFormat();
                        continue;
                    }
                    if (((TMX)t).saved) continue;
                    ((TMX)t).writeXMLFormat();
                }
                catch (IOException ex) {
                    Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING PROJECT!"));
                }
                continue;
            }
            if (!(object instanceof TTX)) continue;
            t = (TTX)object;
            try {
                if (this.ttx != null && this.ttx.equals(t)) {
                    ((TTX)t).writeXMLFormat();
                    continue;
                }
                if (((TTX)t).saved) continue;
                ((TTX)t).writeXMLFormat();
            }
            catch (IOException ex) {
                Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING PROJECT!"));
            }
        }
        this.topui.removeProjectActionProgressBar(bar);
    }

    public void saveProject(String path) {
        this.projectPath = path;
        this.saveProject(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void saveProject(boolean as) {
        File projectFile;
        String currTU;
        if (this.closed) {
            return;
        }
        if (this.projectPath == null) {
            return;
        }
        if (this.ttx != null) {
            currTU = this.ttx.getLastID();
            if (currTU != null && this.projectName != null) {
                AppPreferences.currentTUNumber = '{' + currTU + '}' + this.projectName;
            }
        } else if (this.xliff != null && !this.xliff.isCafeTranXLIFF && (currTU = this.xliff.getLastID()) != null && this.projectName != null) {
            AppPreferences.currentTUNumber = '{' + currTU + '}' + this.projectName;
        }
        if (!as) {
            this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(0);
        }
        if (this.projects != null && !as) {
            this.saveProjects();
            return;
        }
        File packageFile = null;
        boolean toHTML = false;
        boolean toText = false;
        boolean toPackage = false;
        if (as) {
            String dir;
            String folderName = null;
            if (this.xliff != null && this.xliff.isCafeTranXLIFF) {
                folderName = this.getProjectFolderName();
            }
            JFileChooser jFileChooser = new JFileChooser();
            String[] pro = new String[]{"TMX Memory", "HTML", "Text", "Package"};
            FileFilters filters = new FileFilters();
            if (this.zipPackageName != null) {
                filters.setFileFilters(pro, "Package", jFileChooser);
            } else {
                filters.setFileFilters(pro, "TMX Memory", jFileChooser);
            }
            if (AppPreferences.exportDirectory != null && AppPreferences.exportDirectory.length() > 0) {
                dir = AppPreferences.exportDirectory;
                File f = new File(dir);
                if (f.exists()) {
                    jFileChooser.setCurrentDirectory(f);
                }
            } else {
                dir = System.getProperty("user.home");
                jFileChooser.setCurrentDirectory(new File(dir));
            }
            if (this.zipPackageName != null) {
                jFileChooser.setSelectedFile(new File(this.zipPackageName));
            } else if (folderName != null) {
                jFileChooser.setSelectedFile(new File(folderName));
            } else if (this.projectName != null) {
                int dot = this.projectName.lastIndexOf(46);
                String n = dot != -1 ? this.projectName.substring(0, dot) : this.projectName;
                jFileChooser.setSelectedFile(new File(n));
            } else {
                jFileChooser.setSelectedFile(new File(""));
            }
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE PROJECT"));
            jFileChooser.setName("SaveProject");
            jFileChooser.repaint();
            if (0 != jFileChooser.showSaveDialog(this.topui)) return;
            projectFile = jFileChooser.getSelectedFile();
            AppPreferences.exportDirectory = projectFile.getParent();
            FileFilter filter = jFileChooser.getFileFilter();
            String desc = filter.getDescription();
            String name = projectFile.getName();
            if (desc.equals("TMX Memory") || name.endsWith(".tmx")) {
                if (!name.endsWith(".tmx") || !name.endsWith(".TMX")) {
                    int dot = name.lastIndexOf(".");
                    if (dot != -1) {
                        name = name.substring(0, dot);
                    }
                    name = name + ".tmx";
                }
                String mPath = projectFile.getParent() + AppPreferences.fs + name;
                this.saveProjectAsTMX(mPath);
                return;
            }
            if (desc.equals("HTML") || name.endsWith(".html")) {
                if (!name.endsWith(".html") || !name.endsWith(".HTML")) {
                    name = name + ".html";
                }
                String mPath = projectFile.getParent() + AppPreferences.fs + name;
                projectFile = new File(mPath);
                toHTML = true;
            } else if (desc.equals("Text") || name.endsWith(".txt")) {
                if (!name.endsWith(".txt") || !name.endsWith(".TXT")) {
                    name = name + ".txt";
                }
                String mPath = projectFile.getParent() + AppPreferences.fs + name;
                projectFile = new File(mPath);
                toText = true;
            } else if (desc.equals("Package")) {
                String pp = projectFile.getPath();
                packageFile = pp.endsWith(".ctp") || pp.endsWith(".sdlppx") ? projectFile : (this.zipPackageName != null && this.zipPackageName.endsWith(".sdlppx") ? new File(pp + ".sdlppx") : new File(pp + ".ctp"));
                toPackage = true;
                projectFile = new File(this.projectPath);
                this.projectName = projectFile.getName();
            }
        } else {
            projectFile = new File(this.projectPath);
            this.projectName = projectFile.getName();
        }
        JProgressBar bar = this.topui.getProjectActionProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVING PROJECT") + " " + this.projectName + " ...");
        try {
            File tempFile = null;
            FileOutputStream fout = null;
            if (toText) {
                tempFile = File.createTempFile("old", null, projectFile.getParentFile());
                fout = new FileOutputStream(tempFile);
                this.storeToText(fout);
            } else if (toHTML) {
                tempFile = File.createTempFile("old", null, projectFile.getParentFile());
                fout = new FileOutputStream(tempFile);
                this.storeToHTML(fout);
            } else if (this.projects != null) {
                this.saveProjects();
            } else {
                tempFile = File.createTempFile("old", null, projectFile.getParentFile());
                fout = new FileOutputStream(tempFile);
                this.store(fout);
            }
            if (tempFile != null) {
                fout.close();
                if (projectFile.exists()) {
                    projectFile.delete();
                }
                if (!tempFile.renameTo(projectFile)) {
                    throw new IOException();
                }
            }
            if (toPackage) {
                String p = packageFile.getPath();
                this.zipPackageName = packageFile.getName();
                if (this.packagePath == null) {
                    String pp = projectFile.getPath();
                    this.packagePath = pp != null && pp.toLowerCase().endsWith(".tmx") ? pp : projectFile.getParent();
                }
                this.storeToPackage(p);
            }
            this.topui.removeProjectActionProgressBar(bar);
            if (!toText && !toHTML && !toPackage) return;
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING PROJECT!"));
            this.topui.removeProjectActionProgressBar(bar);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void exportProject(int as) {
        String selectedFile;
        this.topui.requestFocus();
        if (as == 5) {
            this.sendToClipboard();
            return;
        }
        if (this.projectPath == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO PROJECT!"));
            return;
        }
        String folderName = null;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF) {
            folderName = this.getProjectFolderName();
        }
        final String currentDir = this.zipPackageDir != null ? this.zipPackageDir : (AppPreferences.exportDirectory != null && AppPreferences.exportDirectory.length() > 0 ? AppPreferences.exportDirectory : System.getProperty("user.home"));
        if (this.zipPackageName != null) {
            StringBuffer sb = new StringBuffer(this.zipPackageName);
            if (as == 4 && this.zipPackageName.toLowerCase().endsWith(".sdlppx")) {
                Object[] options = new Object[]{"Project package (*.sdlppx)", "Return package (*.sdlrpx)", "Cancel"};
                int n = JOptionPane.showOptionDialog(this.topui, "Choose one of the following package types:", "Package Type", 1, 3, null, options, options[0]);
                if (n != 1 && n != 0) return;
                if (n == 1) {
                    sb.replace(sb.length() - 6, sb.length(), "sdlrpx");
                    as = 5;
                }
                this.topui.requestFocus();
                String dir = !currentDir.endsWith(AppPreferences.fs) ? currentDir + AppPreferences.fs : currentDir;
                File efile = new File(dir + sb.toString());
                if (efile.exists()) {
                    if (as == 4) {
                        String s = JOptionPane.showInputDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THE FILE ALREADY EXISTS. CHANGE THE NAME?"), sb.toString());
                        if (s == null || s.length() <= 0) return;
                        sb = new StringBuffer(s);
                    } else {
                        int i = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OVERWRITE THE EXISITNG FILE?"), sb.toString(), 0);
                        if (i == 1) {
                            return;
                        }
                    }
                }
                final File file = new File(dir + sb.toString());
                final int asFile = as;
                if (!file.exists() || as == 5) {
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ Project this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            this.this$0.saveProjectAs(file, asFile);
                        }
                    });
                    return;
                } else {
                    JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THE FILE ALREADY EXISTS."));
                }
                return;
            }
            selectedFile = sb.toString();
        } else if (folderName != null) {
            selectedFile = folderName;
        } else if (this.projectName != null) {
            int dot = this.projectName.lastIndexOf(46);
            String n = dot != -1 ? this.projectName.substring(0, dot) : this.projectName;
            selectedFile = n;
        } else {
            selectedFile = "";
        }
        if (AppPreferences.isJavaFXReady()) {
            final int asFile = as;
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ Project this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        File f;
                        FileChooser fileChooser = new FileChooser();
                        String title = asFile == 1 ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TO TMX MEMORY") : (asFile == 2 ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TO HTML FILE") : (asFile == 3 ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TO TEXT FILE") : (asFile == 4 ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TO PACKAGE") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT"))));
                        fileChooser.setTitle(title);
                        if (currentDir != null && (f = new File(currentDir)).exists() && f.isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if (selectedFile != null) {
                            fileChooser.setInitialFileName(new File(selectedFile).getName());
                        }
                        if ((file = fileChooser.showSaveDialog(null)) != null) {
                            String parent;
                            AppPreferences.exportDirectory = parent = file.getParent();
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 8 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this$0.saveProjectAs(file, asFile);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 8 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
            return;
        } else {
            String parent;
            File file;
            File f;
            JFileChooser jFileChooser = new JFileChooser();
            if (currentDir != null && (f = new File(currentDir)).exists()) {
                jFileChooser.setCurrentDirectory(f);
            }
            if (selectedFile != null) {
                jFileChooser.setSelectedFile(new File(selectedFile));
            }
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE PROJECT"));
            jFileChooser.repaint();
            if (0 != jFileChooser.showSaveDialog(this.topui) || (file = jFileChooser.getSelectedFile()) == null) return;
            AppPreferences.exportDirectory = parent = file.getParent();
            this.saveProjectAs(file, as);
        }
    }

    private void saveProjectAs(File projectFile, int as) {
        String mPath;
        File packageFile = null;
        boolean toHTML = false;
        boolean toText = false;
        boolean toPackage = false;
        boolean SDLPackage = false;
        String name = projectFile.getName();
        if (as == 1) {
            if (!name.toLowerCase().endsWith(".tmx")) {
                name = name + ".tmx";
            }
            String mPath2 = projectFile.getParent() + AppPreferences.fs + name;
            this.saveProjectAsTMX(mPath2);
            return;
        }
        if (as == 2) {
            if (!name.toLowerCase().endsWith(".html")) {
                name = name + ".html";
            }
            mPath = projectFile.getParent() + AppPreferences.fs + name;
            projectFile = new File(mPath);
            toHTML = true;
        } else if (as == 3) {
            if (!name.toLowerCase().endsWith(".txt")) {
                name = name + ".txt";
            }
            mPath = projectFile.getParent() + AppPreferences.fs + name;
            projectFile = new File(mPath);
            toText = true;
        } else if (as == 4 || as == 5) {
            String pp = projectFile.getPath();
            if (pp.endsWith(".ctp") || pp.endsWith(".mqxlz") || pp.endsWith(".sdlppx") || pp.endsWith(".sdlrpx")) {
                packageFile = projectFile;
                if (pp.endsWith(".sdlppx") || pp.endsWith(".sdlrpx")) {
                    SDLPackage = true;
                }
            } else if (this.zipPackageName != null && this.zipPackageName.endsWith(".sdlppx")) {
                packageFile = as == 4 ? new File(pp + ".sdlppx") : new File(pp + ".sdlrpx");
                SDLPackage = true;
            } else {
                packageFile = this.xliff != null && this.xliff.isCafeTranXLIFF ? new File(pp + ".ctp") : new File(pp + ".zip");
            }
            toPackage = true;
            projectFile = new File(this.projectPath);
            this.projectName = projectFile.getName();
        }
        JProgressBar bar = this.topui.getProjectActionProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVING PROJECT") + " " + this.projectName + " ...");
        try {
            File tempFile = null;
            FileOutputStream fout = null;
            if (toText) {
                tempFile = File.createTempFile("old", null, projectFile.getParentFile());
                fout = new FileOutputStream(tempFile);
                this.storeToText(fout);
            } else if (toHTML) {
                tempFile = File.createTempFile("old", null, projectFile.getParentFile());
                fout = new FileOutputStream(tempFile);
                this.storeToHTML(fout);
            }
            if (tempFile != null && fout != null) {
                fout.close();
                if (projectFile.exists()) {
                    projectFile.delete();
                }
                if (!tempFile.renameTo(projectFile)) {
                    throw new IOException();
                }
            }
            if (toPackage) {
                int i;
                String p = packageFile.getPath();
                if (this.packagePath == null) {
                    String pp = projectFile.getPath();
                    this.packagePath = pp != null && pp.toLowerCase().endsWith(".tmx") ? pp : projectFile.getParent();
                }
                if (SDLPackage && !this.translatedStatusSet && (i = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET TRANSLATED STATUS FOR SEGMENTS"), "Select an Option", 0)) == 0) {
                    this.topui.getTaskView().setTranslatedStatus();
                }
                if (as == 4) {
                    this.zipPackageName = packageFile.getName();
                    this.storeToPackage(p);
                } else {
                    this.storeToSDLReturnPackage(p);
                }
            }
            this.topui.removeProjectActionProgressBar(bar);
            if (toText || toHTML || toPackage) {
                if (!Desktop.isDesktopSupported()) {
                    JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                } else {
                    File pf = packageFile != null ? packageFile.getParentFile() : projectFile.getParentFile();
                    this.topui.getWorkflowView().showProjectExportCompleteDialog(pf);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING PROJECT!"));
            this.topui.removeProjectActionProgressBar(bar);
        }
    }

    public StringBuffer toAutoCompletion() {
        if (this.xliff != null) {
            if (this.projects != null) {
                StringBuffer sb = new StringBuffer();
                for (Object object : this.projects) {
                    if (!(object instanceof XLIFF)) continue;
                    XLIFF t = (XLIFF)object;
                    sb.append(t.toAutoCompletion());
                }
                return sb;
            }
            return this.xliff.toAutoCompletion();
        }
        if (this.ttx != null) {
            if (this.projects != null) {
                StringBuffer sb = new StringBuffer();
                for (Object object : this.projects) {
                    if (!(object instanceof TTX)) continue;
                    TTX t = (TTX)object;
                    sb.append(t.toAutoCompletion());
                }
                return sb;
            }
            return this.ttx.toAutoCompletion();
        }
        return null;
    }

    public static void zipSDLReturnPackage(String fileToZip, String zipFile, boolean excludeContainingFolder) throws IOException {
        if (!zipFile.toLowerCase().endsWith(".sdlrpx")) {
            zipFile = zipFile + ".sdlrpx";
        }
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
        File srcFile = new File(fileToZip);
        if (excludeContainingFolder && srcFile.isDirectory()) {
            for (String fileName : srcFile.list()) {
                if (fileName.equals("Reports") || fileName.equals("Tm") || fileName.equals("Termbases")) continue;
                Project.addToZip("", fileToZip + "/" + fileName, zipOut);
            }
        } else {
            Project.addToZip("", fileToZip, zipOut);
        }
        zipOut.flush();
        zipOut.close();
        System.out.println("Successfully created " + zipFile);
    }

    public static void zipFile(String fileToZip, String zipFile, boolean excludeContainingFolder) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
        File srcFile = new File(fileToZip);
        if (excludeContainingFolder && srcFile.isDirectory()) {
            for (String fileName : srcFile.list()) {
                Project.addToZip("", fileToZip + "/" + fileName, zipOut);
            }
        } else {
            Project.addToZip("", fileToZip, zipOut);
        }
        zipOut.flush();
        zipOut.close();
        System.out.println("Successfully created " + zipFile);
    }

    private static void addToZip(String path, String srcFile, ZipOutputStream zipOut) throws IOException {
        String filePath;
        File file = new File(srcFile);
        String string = filePath = "".equals(path) ? file.getName() : path + "/" + file.getName();
        if (file.isDirectory()) {
            for (String fileName : file.list()) {
                Project.addToZip(filePath, srcFile + "/" + fileName, zipOut);
            }
        } else {
            int len;
            zipOut.putNextEntry(new ZipEntry(filePath));
            FileInputStream in = new FileInputStream(srcFile);
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                zipOut.write(buffer, 0, len);
            }
            in.close();
        }
    }

    private void updateSDLCounts() {
        File file = new File(this.packagePath + AppPreferences.fs + this.sdlProjFileName);
        if (file.exists()) {
            String s = TextResource.loadAsText(file, "UTF-8");
            Pattern pattern = Pattern.compile("<LanguageFile.+?</LanguageFile>", 32);
            Pattern pattern2 = Pattern.compile("<AnalysisStatistics.+?</AnalysisStatistics>\\s+<ConfirmationStatistics.+?</ConfirmationStatistics>", 32);
            Pattern totalP = Pattern.compile("<Total .+?/>");
            Pattern unspecP = Pattern.compile("<Unspecified .+?/>");
            Pattern translatedP = Pattern.compile("<Translated .+?/>");
            Matcher matcher = pattern.matcher(s);
            String unSpec = "<Unspecified Words=\"0\" Characters=\"0\" Segments=\"0\" Placeables=\"0\" Tags=\"0\" />";
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String group = matcher.group();
                Matcher matcher2 = pattern2.matcher(group);
                if (matcher2.find()) {
                    String group2 = matcher2.group();
                    Matcher mTotal = totalP.matcher(group);
                    Matcher mUnspec = unspecP.matcher(group);
                    Matcher mTrans = translatedP.matcher(group);
                    if (mTotal.find() && mUnspec.find() && mTrans.find()) {
                        String s1 = mTotal.group();
                        String s2 = mUnspec.group();
                        String s3 = mTrans.group();
                        group = group.replace(s2, unSpec);
                        s1 = s1.replace("Total", "Translated");
                        group = group.replace(s3, s1);
                    }
                }
                matcher.appendReplacement(sb, group);
            }
            matcher.appendTail(sb);
            TextResource.storeAsText(file, sb.toString(), "UTF-8");
        }
    }

    private void updateSDLProjectFile() {
        File file = new File(this.packagePath + AppPreferences.fs + this.sdlProjFileName);
        if (file.exists()) {
            String s = TextResource.loadAsText(file, "UTF-8");
            Pattern pattern = Pattern.compile("<PackageProject.+?>", 32);
            Pattern pattern2 = Pattern.compile("PackageGuid=.+?\"");
            Pattern pattern3 = Pattern.compile("PackageType=.+?\"");
            Pattern pattern4 = Pattern.compile("<AutomaticTask .+?</AutomaticTask>\\s*", 40);
            Pattern pattern5 = Pattern.compile("<ManualTask .+?</ManualTask>", 32);
            Pattern pattern6 = Pattern.compile("<Termbases>.+?</Termbases>\\s*", 40);
            Matcher matcher = pattern.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                Matcher matcher3;
                String group = matcher.group();
                Matcher matcher2 = pattern2.matcher(group);
                if (matcher2.find()) {
                    String group2 = matcher2.group();
                    StringBuffer buff = new StringBuffer(group2);
                    char c = buff.charAt(buff.length() - 2);
                    if (c != '1') {
                        buff.setCharAt(buff.length() - 2, '1');
                    } else {
                        buff.setCharAt(buff.length() - 2, '2');
                    }
                    group = group.replace(group2, buff.toString());
                }
                if ((matcher3 = pattern3.matcher(group)).find()) {
                    String group3 = matcher3.group();
                    group = group.replace(group3, "PackageType=\"ReturnPackage\"");
                }
                matcher.appendReplacement(sb, group);
            }
            matcher.appendTail(sb);
            Matcher matcher4 = pattern4.matcher(sb.toString());
            sb.setLength(0);
            while (matcher4.find()) {
                matcher4.appendReplacement(sb, "");
            }
            matcher4.appendTail(sb);
            Matcher matcher5 = pattern5.matcher(sb.toString());
            sb.setLength(0);
            while (matcher5.find()) {
                int j;
                String pc;
                String group = matcher5.group();
                int i = group.indexOf("Status=\"Assigned\"");
                if (i == -1) continue;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                String dateString = format.format(new Date());
                i = (group = group.replace("Status=\"Assigned\"", "Status=\"Completed\" CompletedAt=\"" + dateString + "\"")).indexOf(pc = "PercentComplete=\"");
                if (i != -1 && (j = group.indexOf("\"", i + pc.length())) != -1) {
                    pc = group.substring(i, j + 1);
                    group = group.replace(pc, "PercentComplete=\"100\"");
                }
                group = group.replace("Completed=\"false\"", "Completed=\"true\"");
                matcher5.appendReplacement(sb, group);
            }
            matcher5.appendTail(sb);
            Matcher matcher6 = pattern6.matcher(sb.toString());
            sb.setLength(0);
            if (matcher6.find()) {
                matcher6.appendReplacement(sb, "");
            }
            matcher6.appendTail(sb);
            TextResource.storeAsText(file, sb.toString(), "UTF-8");
        }
    }

    private void storeToSDLReturnPackage(String p) throws IOException {
        this.updateSDLProjectFile();
        Project.zipSDLReturnPackage(this.packagePath, p, true);
    }

    private void storeToPackage(String p) throws IOException {
        Project.zipFile(this.packagePath, p, true);
    }

    private void store(FileOutputStream fout) throws IOException {
        String enc = AppPreferences.en;
        if (this.ttx != null) {
            enc = "UTF-16";
        } else if (!enc.startsWith("UTF")) {
            enc = "UTF-8";
        }
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, enc));
        String p = this.projectPath.toLowerCase();
        if (p.endsWith(".sdlxliff") || p.endsWith(".txml")) {
            if (this.xliff != null && this.xliff.isTXML) {
                awriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            } else {
                awriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            }
        } else {
            Workflow w = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
            if (w != null) {
                long d = w.getTotalDuration();
                this.setDuration(Long.toString(d));
            }
            awriter.write("<?xml version=\"1.0\"?>");
        }
        this.writeXMLFormat(awriter);
        awriter.close();
    }

    private void sendToClipboard() {
        if (this.xliff != null) {
            XliffView view = this.xliff.getView();
            String text = view.fetchTextSegments();
            if (!AppPreferences.clipboardHTMLExport) {
                this.topui.getResourceView().addTargetToClipboard(text);
            } else {
                this.topui.getResourceView().addHTMLTargetToClipboard(text);
            }
            this.topui.getHelpBar().setText("Target contents sent out to the external application.");
        }
    }

    public void sendCurrentBlockToClipboard() {
        if (this.xliff != null && this.exportStartTU != -1) {
            XliffView view = this.xliff.getView();
            String text = view.fetchTextSegments(this.exportStartTU);
            if (!AppPreferences.clipboardHTMLExport) {
                this.topui.getResourceView().addTargetToClipboard(text);
            } else {
                this.topui.getResourceView().addHTMLTargetToClipboard(text);
            }
            this.topui.setPauseButtonColor(Color.red);
            this.topui.getHelpBar().setText("Target contents sent out to the external application.");
            this.exportStartTU = -1;
        }
    }

    private void storeToText(FileOutputStream out) throws IOException {
        Object view;
        String text = null;
        if (this.xliff != null) {
            view = this.xliff.getView();
            text = ((XliffView)view).fetchTextSegments();
        } else if (this.tmx != null) {
            view = this.tmx.getView();
            text = ((TMXView)view).fetchTextTargetSegments();
        }
        if (text != null) {
            BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            awriter.write(text);
            awriter.close();
        }
    }

    private void storeToHTML(FileOutputStream out) throws IOException {
        Object view;
        String html = null;
        if (this.xliff != null) {
            view = this.xliff.getView();
            html = ((XliffView)view).fetchHTMLContent();
        } else if (this.tmx != null) {
            view = this.tmx.getView();
            html = ((TMXView)view).fetchHTMLContent();
        } else if (this.ttx != null) {
            view = this.ttx.getView();
            html = ((TTXView)view).fetchHTMLContent();
        }
        if (html != null) {
            BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            awriter.write(html);
            awriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToWordProcessorHTML(File file) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this.storeToHTML(fout);
            fout.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fout.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setSkeletonReference(String href) {
        FileHeader header;
        XliffFile file;
        if (this.xliff != null && (file = this.xliff.getCurrentFile()) != null && (header = file.getHeader()) != null) {
            header.setSkeletonReference(href);
        }
    }

    public String getSkeletonReference() {
        FileHeader header;
        XliffFile file;
        String ref = null;
        if (this.xliff != null && (file = this.xliff.getCurrentFile()) != null && (header = file.getHeader()) != null) {
            ref = header.getSkeletonReference();
        }
        return ref;
    }

    public String getAlignedSkeletonReference() {
        Reference ref;
        FileHeader header;
        XliffFile file;
        String sref = null;
        if (this.xliff != null && (file = this.xliff.getCurrentFile()) != null && (header = file.getHeader()) != null && (ref = header.getReference("Aligned document")) != null) {
            sref = ref.getExternalFile().getAttribute("href");
        }
        return sref;
    }

    public String getPreviewReference(String id) {
        String href = this.topui.getProjectView().getReference(id);
        if (href != null && href.length() > 0) {
            return href;
        }
        return this.previewReferencePath;
    }

    public void setPreviewReference(String path, String id) {
        ProjectView pro = this.topui.getProjectView();
        pro.removeLibreOfficeReference();
        pro.setReference(path, id);
        this.previewReferencePath = path;
    }

    public Translatable getTranslatable() {
        Object object;
        HashMap map;
        Translatable t = null;
        String s = this.getSkeletonReference();
        if (s != null && (map = this.topui.getResourceView().getTranslatables()) != null && (object = map.get(s)) != null) {
            t = (Translatable)object;
        }
        return t;
    }

    public Translatable getAlignedTranslatable() {
        Object object;
        HashMap map;
        Translatable t = null;
        String s = this.getAlignedSkeletonReference();
        if (s != null && (map = this.topui.getResourceView().getTranslatables()) != null && (object = map.get(s)) != null) {
            t = (Translatable)object;
        }
        return t;
    }

    public Translatable getTranslatable(XliffFile file) {
        Object object;
        HashMap map;
        String s;
        Translatable t = null;
        FileHeader header = file.getHeader();
        if (header != null && (s = header.getSkeletonReference()) != null && (map = this.topui.getResourceView().getTranslatables()) != null && (object = map.get(s)) != null) {
            t = (Translatable)object;
        }
        return t;
    }

    public void resetLastTU() {
        XliffFile file;
        if (this.xliff != null && (file = this.xliff.getCurrentFile()) != null) {
            file.getBody().resetLastTU();
        }
    }

    public void prepareTransUnit() {
        if (this.xliff != null) {
            this.xliff.prepareTransUnit();
        }
    }

    public boolean checkTagsQA() {
        boolean ok = true;
        if (this.tagsQA == 0) {
            try {
                int j;
                StyledDocument sdoc = this.topui.getSourcePane().getStyledDocument();
                int slen = sdoc.getLength();
                String key = sdoc.getText(0, slen);
                StyledDocument tdoc = this.topui.getTargetPane().getStyledDocument();
                int tlen = tdoc.getLength();
                if (tlen == 0) {
                    return ok;
                }
                String value = tdoc.getText(0, tlen);
                int i = XMLHelper.countTags(key);
                if (i != (j = XMLHelper.countTags(value))) {
                    int n;
                    Object[] options = new Object[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DON'T WARN NOW")};
                    this.tagsQA = n = JOptionPane.showOptionDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER TAGS! - F3"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TAGS QA"), 0, 2, null, options, options[0]);
                    ok = false;
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Project.class.getName()).log(Level.SEVERE, null, ex);
                return ok;
            }
        }
        return ok;
    }

    public void createTransUnit(String source, String target, String segBreak, int pos, int length, int state, String note) {
        if (this.xliff != null) {
            this.xliff.createTransUnit(source, target, segBreak, pos, length, state, note);
        }
    }

    public void setAlignmentPosition(int pos, int length, String segBreak) {
        if (this.xliff != null) {
            this.xliff.setTargetPosition(pos, length, segBreak);
        }
    }

    public void setPhase(String s) {
        XliffFile file;
        XLIFF xliff = this.getXLIFF();
        if (xliff != null && (file = xliff.getCurrentFile()) != null) {
            file.setCurrentPhase(s);
        }
    }

    public String getPhase() {
        XliffFile file;
        String s = null;
        XLIFF xliff = this.getXLIFF();
        if (xliff != null && (file = xliff.getCurrentFile()) != null) {
            s = file.getCurrentPhase();
        }
        return s;
    }

    public void setQA(boolean check) {
        this.tagsQA = check ? 0 : 1;
    }

    public void toggleBookmark() {
        if (this.xliff != null) {
            this.xliff.toggleBookmark();
        } else if (this.ttx != null) {
            this.ttx.toggleBookmark();
        }
    }

    public void createNote() {
        if (this.xliff != null) {
            this.xliff.createTUNote();
        } else if (this.tmx != null) {
            this.tmx.createTUNote();
        }
    }

    public void createAltTrans() {
        if (this.xliff != null) {
            this.xliff.createAltTrans();
        }
    }

    public String getTagsFormat(String tags) {
        if (this.xliff != null) {
            XliffWorkflow flow = this.xliff.getWorkflow();
            if (flow != null) {
                return flow.getTagsFormat(tags);
            }
            return null;
        }
        return null;
    }

    public String getTagsXML(String id, boolean source) {
        if (this.xliff != null) {
            XliffWorkflow flow = this.xliff.getWorkflow();
            if (flow != null) {
                return flow.getTagsXML(id, source);
            }
            return null;
        }
        if (this.tmx != null) {
            TMXWorkflow flow = this.tmx.getWorkflow();
            if (flow != null) {
                return flow.getTagsXML(id, source);
            }
            return null;
        }
        if (this.ttx != null) {
            TTXWorkflow flow = this.ttx.getWorkflow();
            if (flow != null) {
                return flow.getTagsXML(id, source);
            }
            return null;
        }
        return null;
    }

    public void splitSegment(int scaret, int tcaret) {
        XliffWorkflow flow;
        if (this.xliff != null && (flow = this.xliff.getWorkflow()) != null) {
            flow.splitTU(scaret, tcaret);
        }
    }

    public void splitSegment() {
        TMXWorkflow flow;
        if (this.xliff != null) {
            XliffWorkflow flow2 = this.xliff.getWorkflow();
            if (flow2 != null) {
                XLIFFUnit tu = flow2.getCheckTransUnit();
                if (tu != null) {
                    flow2.splitTU();
                } else {
                    this.topui.getWorkflowView().splitTU();
                }
            }
        } else if (this.tmx != null && (flow = this.tmx.getWorkflow()) != null) {
            flow.splitTU();
        }
    }

    public String getFromMemory(String source, String[] tags) {
        String s = null;
        if (AppPreferences.autonumbers && (s = NumbersHelper.isNumber(source)) != null) {
            if (AppPreferences.replaceAtTransfer) {
                s = WorkflowView.replaceCharacters(s);
            }
            return s;
        }
        if (this.xliff != null) {
            s = this.xliff.getFromMemory(source, tags);
        } else if (this.ttx != null) {
            s = this.ttx.getFromMemory(source, tags);
        } else if (this.tmx != null) {
            s = this.tmx.getFromMemory(source);
        }
        return s;
    }

    public void makeBinaryUnit(String url) {
        if (this.xliff != null) {
            this.xliff.makeBinaryUnit(url);
        }
    }

    public void cancelBinaryMode() {
        XliffFile file;
        if (this.xliff != null && (file = this.xliff.getCurrentFile()) != null) {
            FileBody body = file.getBody();
            body.setCurrentBU(null);
        }
    }

    public void sort() {
        if (this.xliff != null) {
            this.xliff.sort();
        } else if (this.ttx != null) {
            this.ttx.sort();
        } else if (this.tmx != null) {
            this.tmx.sort();
        }
    }

    public void sortByLength(boolean longToShort) {
        if (this.xliff != null) {
            this.xliff.sortByLength(longToShort);
        } else if (this.ttx != null) {
            this.ttx.sortByLength(longToShort);
        } else if (this.tmx != null) {
            this.tmx.sortByLength(longToShort);
        }
    }

    public void searchProjectFile(String s, String r, int mode) {
        if (this.xliff != null) {
            this.xliff.searchFile(s, r, mode);
        } else if (this.ttx != null) {
            this.ttx.searchFile(s, r, mode);
        } else if (this.tmx != null) {
            this.tmx.searchFile(s, r, mode);
        }
    }

    public void viewRange(int from, int to) {
        if (this.xliff != null) {
            this.xliff.viewRange(from, to);
        } else if (this.ttx != null) {
            this.ttx.viewRange(from, to);
        } else if (this.tmx != null) {
            this.tmx.viewRange(from, to);
        }
    }

    public void updateViewMode(int mode) {
        if (this.xliff != null) {
            this.xliff.getView().setViewMode(mode);
            if (this.xliff.getFiles().size() > 1 || this.projects != null && this.projects.size() > 1) {
                this.topui.getProjectView().setDocumentsButton();
            }
            if (XLIFF.unitCounter > AppPreferences.pagesize || this.align) {
                this.topui.getProjectView().setNavigationButtons();
            }
        } else if (this.ttx != null) {
            this.ttx.getView().setViewMode(mode);
            if (this.ttx.getView().currentTUSize > AppPreferences.pagesize) {
                this.topui.getProjectView().setNavigationButtons();
            }
        } else if (this.tmx != null) {
            this.tmx.getView().setViewMode(mode);
            if (this.tmx.getView().currentTUSize > AppPreferences.pagesize) {
                this.topui.getProjectView().setNavigationButtons();
            }
        }
    }

    public void refreshView() {
        if (this.xliff != null) {
            this.xliff.getView().refreshView();
        } else if (this.ttx != null) {
            this.ttx.getView().refreshView();
        } else if (this.tmx != null) {
            this.tmx.getView().refreshView();
        }
    }

    void updateSegmentView() {
        if (this.xliff != null) {
            this.xliff.getView().updateSegmentView();
        }
    }

    public void edit(String s, int i) {
        Object xflow;
        this.topui.resetTextAreas();
        WorkflowView wview = this.topui.getWorkflowView();
        WorkflowManager wm = wview.getWorkflowManager();
        Workflow process = wm.getWorkflow();
        if (process == null) {
            process = new Workflow(this.topui);
            wm.setWorkflow(process);
        }
        wm.setReview(true);
        if (this.xliff != null) {
            xflow = this.xliff.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.xliff.getView().browseToUnit(i);
            this.xliff.edit(s);
        } else if (this.tmx != null) {
            xflow = this.tmx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.tmx.getView().browseToUnit(i);
            this.tmx.edit(s);
        } else if (this.ttx != null) {
            xflow = this.ttx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.ttx.getView().browseToUnit(i);
            this.ttx.edit(s);
        }
        this.topui.getTargetPane().requestFocusInWindow();
        if (AppPreferences.updateProjectStatistics && !AppPreferences.pauseProjectStatistics) {
            StatisticsView sv = this.topui.getStatisticsView();
            sv.updateProjectStatistics();
        }
    }

    public void editFirst() {
        Object xflow;
        this.topui.resetTextAreas();
        WorkflowView wview = this.topui.getWorkflowView();
        WorkflowManager wm = wview.getWorkflowManager();
        Workflow process = wm.getWorkflow();
        if (process == null) {
            process = new Workflow(this.topui);
            wm.setWorkflow(process);
        }
        wm.setReview(true);
        if (this.xliff != null) {
            xflow = this.xliff.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.xliff.getView().browseToUnit(0);
            this.xliff.edit("#0");
        } else if (this.tmx != null) {
            xflow = this.tmx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.tmx.getView().browseToUnit(0);
            this.tmx.edit("#0");
        } else if (this.ttx != null) {
            xflow = this.ttx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.ttx.getView().browseToUnit(0);
            this.ttx.edit("#0");
        }
        this.topui.getTargetPane().requestFocusInWindow();
        if (AppPreferences.updateProjectStatistics && !AppPreferences.pauseProjectStatistics) {
            StatisticsView sv = this.topui.getStatisticsView();
            sv.updateProjectStatistics();
        }
    }

    public void editCurrent() {
        Object xflow;
        this.topui.resetTextAreas();
        WorkflowView wview = this.topui.getWorkflowView();
        WorkflowManager wm = wview.getWorkflowManager();
        Workflow process = wm.getWorkflow();
        if (process == null) {
            process = new Workflow(this.topui);
            wm.setWorkflow(process);
        }
        wm.setReview(true);
        if (this.xliff != null) {
            String c;
            XliffFile file;
            xflow = this.xliff.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            int i = 0;
            String id = "#0";
            if (this.xliff.isExternalToolXLIFF) {
                int closing;
                if (AppPreferences.currentTUNumber.startsWith("{") && (closing = AppPreferences.currentTUNumber.indexOf("}")) != -1) {
                    String ttxName = AppPreferences.currentTUNumber.substring(closing + 1);
                    if (this.projectName != null && this.projectName.equals(ttxName)) {
                        String c2 = AppPreferences.currentTUNumber.substring(1, closing);
                        id = "#" + c2;
                        i = Integer.parseInt(c2);
                    }
                }
            } else if (!this.glue && (file = this.xliff.getCurrentFile()) != null && (c = file.getLastID()) != null) {
                id = "#" + c;
                i = Integer.parseInt(c);
            }
            this.xliff.edit(id);
        } else if (this.ttx != null) {
            int closing;
            xflow = this.ttx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            int i = 0;
            String id = "#0";
            if (AppPreferences.currentTUNumber.startsWith("{") && (closing = AppPreferences.currentTUNumber.indexOf("}")) != -1) {
                String ttxName = AppPreferences.currentTUNumber.substring(closing + 1);
                if (this.projectName != null && this.projectName.equals(ttxName)) {
                    String c = AppPreferences.currentTUNumber.substring(1, closing);
                    id = "#" + c;
                    i = Integer.parseInt(c);
                }
            }
            this.ttx.edit(id);
        }
        this.topui.getTargetPane().requestFocusInWindow();
        if (AppPreferences.updateProjectStatistics && !AppPreferences.pauseProjectStatistics) {
            StatisticsView sv = this.topui.getStatisticsView();
            sv.updateProjectStatistics();
        }
    }

    public void editLast() {
        Object xflow;
        this.topui.resetTextAreas();
        WorkflowView wview = this.topui.getWorkflowView();
        WorkflowManager wm = wview.getWorkflowManager();
        Workflow process = wm.getWorkflow();
        if (process == null) {
            process = new Workflow(this.topui);
            wm.setWorkflow(process);
        }
        wm.setReview(true);
        if (this.xliff != null) {
            xflow = this.xliff.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.xliff.getView().browseToLastUnit();
            this.xliff.edit("END");
        } else if (this.tmx != null) {
            xflow = this.tmx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.tmx.getView().browseToLastUnit();
            this.tmx.edit("END");
        } else if (this.ttx != null) {
            xflow = this.ttx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.ttx.getView().browseToLastUnit();
            this.ttx.edit("END");
        }
        this.topui.getTargetPane().requestFocusInWindow();
        if (AppPreferences.updateProjectStatistics && !AppPreferences.pauseProjectStatistics) {
            StatisticsView sv = this.topui.getStatisticsView();
            sv.updateProjectStatistics();
        }
    }

    public void edit(String s) {
        Object xflow;
        Workflow process;
        this.topui.resetTextAreas();
        WorkflowManager wm = this.wview.getWorkflowManager();
        if (!WorkflowManager.workflowStarted) {
            WorkflowManager.workflowStarted = true;
        }
        if ((process = wm.getWorkflow()) == null) {
            process = new Workflow(this.topui);
            wm.setWorkflow(process);
        }
        wm.setReview(true);
        if (this.xliff != null) {
            xflow = this.xliff.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.xliff.edit(s);
        } else if (this.ttx != null) {
            xflow = this.ttx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.ttx.edit(s);
        } else if (this.tmx != null) {
            xflow = this.tmx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
            }
            this.tmx.edit(s);
        }
        if (!AppPreferences.bindExternalEditor) {
            this.topui.getTargetPane().requestFocusInWindow();
        }
        if (AppPreferences.updateProjectStatistics && !AppPreferences.pauseProjectStatistics) {
            StatisticsView sv = this.topui.getStatisticsView();
            sv.updateProjectStatistics();
        }
    }

    public void pretranslateFromCurrentSegment(Memory m) {
        WorkflowManager wm = this.wview.getWorkflowManager();
        Workflow process = wm.getWorkflow();
        if (process == null) {
            process = new Workflow(this.topui);
            wm.setWorkflow(process);
        }
        if (this.xliff != null) {
            XliffWorkflow xflow = this.xliff.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
                xflow = this.xliff.getWorkflow();
            }
            xflow.pretranslate(m);
        } else if (this.ttx != null) {
            TTXWorkflow xflow = this.ttx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
                xflow = this.ttx.getWorkflow();
            }
            xflow.pretranslate(m);
        } else if (this.tmx != null) {
            TMXWorkflow xflow = this.tmx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
                xflow = this.tmx.getWorkflow();
            }
            xflow.pretranslate(m);
        }
    }

    public void analyse(Memory m) {
        WorkflowManager wm = this.wview.getWorkflowManager();
        Workflow process = wm.getWorkflow();
        if (process == null) {
            process = new Workflow(this.topui);
            wm.setWorkflow(process);
        }
        if (this.xliff != null) {
            XliffWorkflow xflow = this.xliff.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
                xflow = this.xliff.getWorkflow();
            }
            xflow.analyse(m);
        } else if (this.ttx != null) {
            TTXWorkflow xflow = this.ttx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
                xflow = this.ttx.getWorkflow();
            }
            xflow.analyse(m);
        } else if (this.tmx != null) {
            TMXWorkflow xflow = this.tmx.getWorkflow();
            if (xflow == null) {
                this.initWorkflow(process);
                xflow = this.tmx.getWorkflow();
            }
            xflow.analyse(m);
        }
    }

    public void highlightCurrentSegment() {
        XliffWorkflow xflow;
        if (this.xliff != null && (xflow = this.xliff.getWorkflow()) != null) {
            xflow.highlightSegment(false);
        }
    }

    public void initWorkflow(Workflow process) {
        if (this.xliff != null) {
            XliffWorkflow xflow = new XliffWorkflow(this.topui, process, this.xliff);
            this.xliff.setWorkflow(xflow);
        } else if (this.ttx != null) {
            TTXWorkflow xflow = new TTXWorkflow(this.topui, process, this.ttx);
            this.ttx.setWorkflow(xflow);
        } else if (this.tmx != null) {
            TMXWorkflow xflow = new TMXWorkflow(this.topui, process, this.tmx);
            this.tmx.setWorkflow(xflow);
        }
    }

    public void setQAFilteredWorkflow(List tunits) {
        if (this.xliff != null) {
            XliffView.setQAFilteredUnits(tunits);
        } else if (this.ttx != null) {
            TTXView.setQAFilteredUnits(tunits);
        } else if (this.tmx != null) {
            TMXView.setQAFilteredUnits(tunits);
        }
    }

    public boolean isQAFilterWorkflow() {
        if (this.xliff != null) {
            return XliffView.hasQAFilter();
        }
        if (this.ttx != null) {
            return TTXView.hasQAFilter();
        }
        if (this.tmx != null) {
            return TMXView.hasQAFilter();
        }
        return false;
    }

    public boolean isTrackingChangesSupported() {
        return this.xliff != null && (this.xliff.isCafeTranXLIFF || this.xliff.isStudioXLIFF);
    }

    public boolean isCurrentSegmentEmpty() {
        XliffWorkflow xflow;
        if (this.xliff != null && (xflow = this.xliff.getWorkflow()) != null) {
            return xflow.isTargetSegmentEmpty();
        }
        return false;
    }

    public void setFilteredWorkflow(boolean flag) {
        this.filter = flag;
        if (this.xliff != null) {
            XliffView.setFilteredWorkflow(flag);
            XliffWorkflow xflow = this.xliff.getWorkflow();
            if (xflow != null) {
                String s;
                if (xflow.isTargetSegmentEmpty() && (s = this.topui.getWorkflowView().getWorkflowManager().getWorkflow().getTarget()) != null && s.length() > 0) {
                    XLIFFUnit tu = xflow.getCheckTransUnit();
                    tu.setSegmentUnconfirmed(s);
                }
                if (flag) {
                    this.currentTUIndexNoFilter = xflow.getCheckTUIndex();
                } else {
                    this.currentTUIndexNoFilter = -1;
                    XliffFile xfile = this.xliff.getCurrentFile();
                    if (xfile != null) {
                        this.setTitleForFile(xfile.getShortName());
                    }
                }
                xflow.cancelCheck();
            }
            this.xliff.setWorkflow(null);
        } else if (this.ttx != null) {
            TTXWorkflow xflow = this.ttx.getWorkflow();
            TTXView.setFilteredWorkflow(flag);
            if (xflow != null) {
                this.currentTUIndexNoFilter = flag ? xflow.getCheckTUIndex() : -1;
                xflow.cancelCheck();
            }
            this.ttx.setWorkflow(null);
        } else if (this.tmx != null) {
            TMXWorkflow xflow = this.tmx.getWorkflow();
            TMXView.setFilteredWorkflow(flag);
            if (xflow != null) {
                this.currentTUIndexNoFilter = flag ? xflow.getCheckTUIndex() : -1;
                xflow.cancelCheck();
            }
            this.tmx.setWorkflow(null);
        }
    }

    public void setSuperGluedWorkflow(boolean flag) {
        this.superglue = flag;
        this.glue = true;
        if (this.xliff != null) {
            this.xliff.getView().setSuperGluedWorkflow(flag);
            XliffWorkflow xflow = this.xliff.getWorkflow();
            if (xflow != null) {
                xflow.cancelCheck();
            }
            this.xliff.setWorkflow(null);
        }
    }

    public void setGluedWorkflow(boolean flag) {
        this.glue = flag;
        if (this.xliff != null) {
            this.xliff.getView().setGluedWorkflow(flag);
            XliffWorkflow xflow = this.xliff.getWorkflow();
            if (xflow != null) {
                xflow.cancelCheck();
            }
            this.xliff.setWorkflow(null);
            if (this.xliff.isCafeTranXLIFF) {
                this.xliff.setGlueMode(Boolean.toString(flag));
            }
        } else if (this.ttx != null) {
            this.ttx.getView().setGluedWorkflow(flag);
            TTXWorkflow xflow = this.ttx.getWorkflow();
            if (xflow != null) {
                xflow.cancelCheck();
            }
            this.ttx.setWorkflow(null);
        } else if (this.tmx != null) {
            this.tmx.getView().setGluedWorkflow(flag);
            TMXWorkflow xflow = this.tmx.getWorkflow();
            if (xflow != null) {
                xflow.cancelCheck();
            }
            this.tmx.setWorkflow(null);
        }
    }

    public void removeWorkflow() {
        if (this.xliff != null) {
            this.xliff.setWorkflow(null);
        }
        if (this.ttx != null) {
            this.ttx.setWorkflow(null);
        }
        if (this.tmx != null) {
            this.tmx.setWorkflow(null);
        }
    }

    public void cancelGluedWorkflows() {
        if (this.xliff != null) {
            XliffView view = this.xliff.getView();
            view.cancelGluedWorkflows();
        } else if (this.tmx != null) {
            TMXView view = this.tmx.getView();
            view.cancelGluedWorkflows();
        } else if (this.ttx != null) {
            TTXView view = this.ttx.getView();
            view.cancelGluedWorkflows();
        }
    }

    public void cancelReviewMode() {
        Object xflow;
        if (this.xliff != null) {
            xflow = this.xliff.getWorkflow();
            if (xflow != null) {
                ((XliffWorkflow)xflow).cancelCheck();
                XliffFile file = this.xliff.getCurrentFile();
                if (file != null) {
                    this.setTitleForFile(file.getShortName());
                }
            }
        } else if (this.ttx != null) {
            xflow = this.ttx.getWorkflow();
            if (xflow != null) {
                ((TTXWorkflow)xflow).cancelCheck();
            }
        } else if (this.tmx != null && (xflow = this.tmx.getWorkflow()) != null) {
            ((TMXWorkflow)xflow).cancelCheck();
        }
        WorkflowView wview = this.topui.getWorkflowView();
        WorkflowManager wm = wview.getWorkflowManager();
        wm.setReview(false);
    }

    public void nextTUS() {
        if (this.xliff != null) {
            XliffView view = this.xliff.getView();
            view.nextTUS();
        } else if (this.ttx != null) {
            TTXView view = this.ttx.getView();
            view.nextTUS();
        } else if (this.tmx != null) {
            TMXView view = this.tmx.getView();
            view.nextTUS();
        }
    }

    public void previousTUS() {
        if (this.xliff != null) {
            XliffView view = this.xliff.getView();
            view.previousTUS();
        } else if (this.ttx != null) {
            TTXView view = this.ttx.getView();
            view.previousTUS();
        } else if (this.tmx != null) {
            TMXView view = this.tmx.getView();
            view.previousTUS();
        }
    }

    public void setCurrentTUIndexNoFilter(int i) {
        this.currentTUIndexNoFilter = i;
    }

    public int getCurrentTUIndexNoFilter() {
        return this.currentTUIndexNoFilter;
    }

    public int getCurrenTUIndex() {
        int i = -1;
        if (this.xliff != null) {
            i = this.xliff.getView().getCurrentTUIndex();
        } else if (this.ttx != null) {
            i = this.ttx.getView().getCurrentTUIndex();
        } else if (this.tmx != null) {
            i = this.tmx.getView().getCurrentTUIndex();
        }
        return i;
    }

    public int getCurrentUnitsNumber() {
        int i = -1;
        if (this.xliff != null) {
            i = this.xliff.getView().getCurrentUnitsSize();
        } else if (this.ttx != null) {
            i = this.ttx.getView().getCurrentUnitsSize();
        } else if (this.tmx != null) {
            i = this.tmx.getView().getCurrentUnitsSize();
        }
        return i;
    }

    public int getLastPosition() {
        if (this.xliff != null) {
            return this.xliff.getLastSourcePosition();
        }
        return -1;
    }

    public int getAlignmentPosition() {
        if (this.xliff != null) {
            return this.xliff.getLastTargetPosition();
        }
        return -1;
    }

    public XMLElement getCurrentTransUnit() {
        TMXWorkflow xflow;
        DefaultXMLElement tu = null;
        if (this.xliff != null) {
            XliffFile file = this.xliff.getCurrentFile();
            if (file != null) {
                XliffWorkflow xflow2 = this.xliff.getWorkflow();
                if (xflow2 != null) {
                    tu = xflow2.getCheckTransUnit();
                }
                if (tu == null) {
                    tu = file.getBody().getCurrentTU();
                }
            }
        } else if (this.ttx != null) {
            TTXWorkflow xflow3;
            Raw file = this.ttx.getCurrentFile();
            if (file != null && (xflow3 = this.ttx.getWorkflow()) != null) {
                tu = xflow3.getCheckTransUnit();
            }
        } else if (this.tmx != null && (xflow = this.tmx.getWorkflow()) != null) {
            tu = xflow.getCheckTransUnit();
        }
        return tu;
    }

    public BinaryUnit getCurrentBinUnit() {
        if (this.xliff != null) {
            return this.xliff.getCurrentFile().getBody().getCurrentBU();
        }
        return null;
    }

    public String translate(Document sdoc) {
        if (this.xliff != null) {
            String s = this.xliff.translate(sdoc);
            return s;
        }
        return null;
    }

    public String translateUnclean(Document sdoc) {
        if (this.xliff != null) {
            String s = this.xliff.translateUnclean(sdoc);
            return s;
        }
        return null;
    }

    public String preview(Document sdoc) {
        if (this.xliff != null) {
            String s = this.xliff.preview(sdoc);
            return s;
        }
        return null;
    }

    public String preview2(Document sdoc) {
        if (this.xliff != null) {
            String s = this.xliff.preview2(sdoc);
            return s;
        }
        return null;
    }

    public String previewUnclean(Document sdoc) {
        if (this.xliff != null) {
            String s = this.xliff.previewUnclean(sdoc);
            return s;
        }
        return null;
    }

    private void writeXMLFormat(BufferedWriter awriter) throws IOException {
        if (this.xliff != null) {
            this.xliff.writeXMLFormat(awriter);
        } else if (this.ttx != null) {
            this.ttx.writeXMLFormat(awriter);
        } else if (this.tmx != null) {
            this.tmx.writeXMLFormat(awriter);
        }
    }

    public String getName() {
        return this.projectName;
    }

    public void setName(String n) {
        this.projectName = n;
    }

    public Date getDate() {
        XliffFile xf;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF && (xf = this.xliff.getCurrentFile()) != null) {
            return xf.getDate();
        }
        return null;
    }

    public String getDuration() {
        String s;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF && (s = this.xliff.getDuration()) != null) {
            return s;
        }
        return null;
    }

    public void setDuration(String s) {
        if (this.xliff != null && this.xliff.isCafeTranXLIFF) {
            this.xliff.setDuration(s);
        }
    }

    public Locale getLocale() {
        if (this.xliff != null) {
            return this.xliff.getLocale();
        }
        if (this.ttx != null) {
            return this.ttx.getLocale();
        }
        if (this.tmx != null) {
            return this.tmx.getLocale();
        }
        return Locale.getDefault();
    }

    public Locale getSrcLocale() {
        if (this.xliff != null) {
            return this.xliff.getSrcLocale();
        }
        if (this.ttx != null) {
            return this.ttx.getSrcLocale();
        }
        if (this.tmx != null) {
            return this.tmx.getSrcLocale();
        }
        return Locale.getDefault();
    }

    public BreakIterator getSourceBreakIterator() {
        if (this.sourceBreakIterator != null) {
            return this.sourceBreakIterator;
        }
        this.sourceBreakIterator = BreakIterator.getWordInstance(this.getSrcLocale());
        return this.sourceBreakIterator;
    }

    public BreakIterator getTargetBreakIterator() {
        if (this.targetBreakIterator != null) {
            return this.targetBreakIterator;
        }
        Locale loc = this.getLocale();
        if (loc == null) {
            loc = Locale.getDefault();
        }
        this.targetBreakIterator = BreakIterator.getWordInstance(loc);
        return this.targetBreakIterator;
    }

    void updateContentView() {
        if (this.xliff != null) {
            this.xliff.getView().updateContentView();
        } else if (this.ttx != null) {
            this.ttx.getView().updateContentView();
        } else if (this.tmx != null) {
            this.tmx.getView().updateContentView();
        }
    }

    public void setTitleForFile(String title) {
        if (title != null) {
            this.topui.setTitle(title + " - " + AppPreferences.CTTitle);
        }
    }

    public int getLibreOfficeMode() {
        return this.libreOfficeMode;
    }

    public void setLibreOfficeMode(int i) {
        this.libreOfficeMode = i;
    }
}

