/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.Abbreviations;
import translator.AppPreferences;
import translator.ClipboardHandler;
import translator.DashboardView;
import translator.FileFilters;
import translator.GlossaryResource;
import translator.KeyPreferences;
import translator.MainClass;
import translator.MainView;
import translator.MatchBoard;
import translator.MySwingWorker;
import translator.Options;
import translator.Placeables;
import translator.Project;
import translator.ResourceLoader;
import translator.ResourceView;
import translator.ScrollPaneWatermark;
import translator.Segmentation;
import translator.SourceView;
import translator.StatisticsView;
import translator.TargetView;
import translator.TextShortcuts;
import translator.Translatable;
import translator.TranslationUnitMap;
import translator.WorkflowManager;
import translator.WorkflowView;
import translator.XMLElementEditor;
import translator.browser.Browser;
import translator.html.CTHTMLEditorKit;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;
import translator.ttx.Raw;
import translator.ttx.TTX;
import translator.ui.Colors;
import translator.ui.GridPanel;
import translator.ui.UITools;
import translator.ui.kodo.KodoProgressBarUI;
import translator.xliff.FileBody;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class ProjectView
extends GridPanel {
    private Project project;
    private MainView topui;
    private JTextPane projectTextPane;
    private JTextPane projectTextPane2;
    private GridPanel secondGrid;
    private JMenu projectMenu;
    Object stag;
    Object ttag;
    private JToolBar bar;
    private JProgressBar progressBar;
    JMenuItem newProjectItem;
    JMenuItem openProjectItem;
    JMenuItem openProjectFolderItem;
    JMenuItem documentsItem;
    JMenuItem exportCurrentDocumentItem;
    JMenuItem saveProjectItem;
    JMenuItem menuItemExit;
    JMenuItem previewItem;
    private JToggleButton filterButton;
    JButton buttonFirst;
    JButton buttonLast;
    JButton buttonNext;
    JButton buttonPrevious;
    JButton buttonExport;
    JButton buttonDocs;
    private AdjustmentListener gridOneAjustmentListener;
    private boolean adjustmentType = true;

    public ProjectView(MainView parent) {
        this.topui = parent;
        if (AppPreferences.alpha != -1) {
            this.setOpaque(false);
            this.setGrid(true);
            this.setTransparent(true);
            Color c = new Color(AppPreferences.tbackground);
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), AppPreferences.alpha);
            this.setBackground(color);
        } else {
            this.setOpaque(true);
            if (AppPreferences.pbackground != 0) {
                this.setBackground(new Color(AppPreferences.pbackground));
            }
        }
        this.setLayout(new BorderLayout());
        this.createProjectBar();
        this.createProjectTextPane();
        this.createProjectMenu();
    }

    public void setSplitGrid(boolean set) {
        if (set) {
            if (this.projectTextPane2 == null) {
                this.createProjectTextPane2();
                this.topui.validate();
            }
        } else {
            this.topui.getTabView().removeTab("Grid");
            this.projectTextPane2 = null;
        }
        this.adjustVerticalScrollBar(set);
        this.topui.getTargetView().setSegmentStatusBar(set);
    }

    public void setAdjustmentType(boolean multiple) {
        this.adjustmentType = multiple;
    }

    private void adjustVerticalScrollBar(boolean adjust) {
        JScrollPane sourceScroll = (JScrollPane)this.projectTextPane.getParent().getParent();
        if (adjust) {
            if (this.gridOneAjustmentListener == null) {
                this.gridOneAjustmentListener = new AdjustmentListener(){

                    @Override
                    public void adjustmentValueChanged(AdjustmentEvent e) {
                        if (!ProjectView.this.adjustmentType) {
                            e.getAdjustable().setValue(e.getAdjustable().getMaximum());
                        }
                    }
                };
            }
            sourceScroll.getVerticalScrollBar().addAdjustmentListener(this.gridOneAjustmentListener);
        } else if (this.gridOneAjustmentListener != null) {
            sourceScroll.getVerticalScrollBar().removeAdjustmentListener(this.gridOneAjustmentListener);
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void startProject() {
        this.createProject();
        if (AppPreferences.prompter) {
            TextShortcuts ts;
            this.topui.getSourceView().updatePrompter();
            if (AppPreferences.textShortcutsFile != null && AppPreferences.textShortcutsFile.length() > 0 && (ts = this.topui.getResourceView().getTextShortcuts()) != null) {
                ts.loadShortcuts();
            }
        }
    }

    public void closeProject() {
        if (this.project != null) {
            Segmentation segmentation;
            TMX tmx;
            TTX ttx;
            this.project.setClosed(true);
            this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(0);
            this.topui.setTitle(AppPreferences.CTTitle);
            this.project.removeWorkflow();
            this.project.cancelGluedWorkflows();
            XLIFF xliff = this.project.getXLIFF();
            if (xliff != null) {
                List projects = this.project.getProjects();
                if (projects != null) {
                    for (Object object : projects) {
                        if (!(object instanceof XLIFF)) continue;
                        XLIFF x = (XLIFF)object;
                        List files = x.getFiles();
                        for (XliffFile file : files) {
                            Translatable tr;
                            FileBody body = file.getBody();
                            if (body != null) {
                                body.getTransUnits().clear();
                            }
                            x.removeChild(file);
                            String opath = file.getTranslatablePath();
                            if (opath == null || (tr = this.topui.getResourceView().getTranslatable(opath)) == null) continue;
                            this.topui.getResourceView().removeTranslatable(tr);
                        }
                    }
                    projects.clear();
                } else {
                    List files = xliff.getFiles();
                    for (XliffFile file : files) {
                        Translatable tr;
                        FileBody body = file.getBody();
                        if (body != null) {
                            body.getTransUnits().clear();
                        }
                        xliff.removeChild(file);
                        String opath = file.getTranslatablePath();
                        if (opath == null || (tr = this.topui.getResourceView().getTranslatable(opath)) == null) continue;
                        this.topui.getResourceView().removeTranslatable(tr);
                    }
                }
            }
            if ((ttx = this.project.getTTX()) != null) {
                List projects = this.project.getProjects();
                if (projects != null) {
                    for (Object object : projects) {
                        if (!(object instanceof TTX)) continue;
                        TTX x = (TTX)object;
                        List files = x.getFiles();
                        for (Raw file : files) {
                            if (file == null) continue;
                            file.getTransUnits().clear();
                            x.removeChild(file);
                        }
                    }
                    projects.clear();
                } else {
                    List files = ttx.getFiles();
                    for (Raw file : files) {
                        if (file == null) continue;
                        file.getTransUnits().clear();
                        file.removeChild(file);
                    }
                }
            }
            this.topui.getResourceLoader().getResourceLoaderList().clear();
            this.topui.getResourceLoader().getDocumentLoaderList().clear();
            this.topui.getMemoryView().close();
            this.topui.getResourceView().closeOOResource();
            this.topui.getResourceView().clearMTCache();
            Project.userProjectName = null;
            Project.hasSDLSourceSegments = false;
            Project.hasSDLTargetSegments = false;
            Project.getProjectMemory().clear();
            this.project.getTags().clear();
            XLIFF xl = this.project.getXLIFF();
            if (xl != null && xl.isExternalToolXLIFF) {
                XLIFFUnit.lockedTUs.clear();
            }
            if ((tmx = this.project.getTMX()) != null) {
                tmx.getTranslationUnits().clear();
                tmx.getTUMap().clearMap();
                this.topui.getTargetView().useDeleteButton(false);
            }
            Abbreviations.resetAbbrievations();
            this.resetProjectTextPane();
            this.project.updateViewMode(AppPreferences.projectView);
            WorkflowManager.workflowStarted = false;
            SourceView sv = this.topui.getSourceView();
            if (!sv.isShowing()) {
                this.topui.cancelImageTranslationInterface();
            }
            this.topui.getTabView().closeAlignmentUI();
            MatchBoard mb = this.topui.getMatchBoard();
            if (mb != null) {
                mb.clearMatchBoard();
            }
            if ((segmentation = this.topui.getSegmentation()) != null) {
                segmentation.setFilterSegmenation(null);
            }
            Browser.stopBindScript();
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setString(null);
            }
            this.topui.togglePauseButton(false);
            this.buttonExport.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT"));
            this.buttonExport.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT CURRENT DOCUMENT") + " (" + Options.getShortcutComboString("k49") + ")");
            this.topui.getMainStatusBar().setText("");
            this.topui.getLanguagePairLabel().setText("Dashboard");
            this.project = null;
            XLIFF.unitCounter = 0;
            XLIFF.fileCounter = 0;
            Memory.totalTUsLoaded = 0;
            Memory.trialMessageDisplayed = false;
            GlossaryResource.totalEntriesLoaded = 0;
            GlossaryResource.trialMessageDisplayed = false;
        }
    }

    public void newProject() {
        if (AppPreferences.detached) {
            this.topui.attachView(true);
        }
        this.topui.getResourceLoader().createLastSessionResourcesList();
        this.createProject();
        if (AppPreferences.prompter) {
            this.topui.getSourceView().updatePrompter();
        }
    }

    public void openProject(final int i, final boolean folder) {
        final String dir = i == 2 && AppPreferences.memoryDirectory != null && AppPreferences.memoryDirectory.length() > 0 ? AppPreferences.memoryDirectory : (AppPreferences.projectLocationDir != null && AppPreferences.projectLocationDir.length() > 0 ? AppPreferences.projectLocationDir : System.getProperty("user.home"));
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ ProjectView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        if (!folder) {
                            File f;
                            FileChooser fileChooser = new FileChooser();
                            if (dir.length() > 0 && (f = new File(dir)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showOpenDialog(null);
                        } else {
                            File f;
                            DirectoryChooser fileChooser = new DirectoryChooser();
                            if (dir.length() > 0 && (f = new File(dir)).isDirectory() && f.canRead()) {
                                fileChooser.setInitialDirectory(f);
                            }
                            file = fileChooser.showDialog(null);
                        }
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    String name = file.getName().toLowerCase();
                                    if (file.isDirectory() || name.endsWith(".xlf") || name.endsWith(".ttx") || name.endsWith(".tmx") || name.endsWith(".xliff") || name.endsWith(".sdlxliff") || name.endsWith(".ctp") || name.endsWith(".sdlppx") || name.endsWith(".mqxlz") || name.endsWith(".mxliff") || name.endsWith(".mqxliff") || name.endsWith(".txml") || name.endsWith(".txlf")) {
                                        String path = file.getPath();
                                        if (i == 2) {
                                            AppPreferences.memoryDirectory = file.getParent();
                                        } else {
                                            AppPreferences.projectDirectory = !file.isDirectory() ? file.getParent() : file.getPath();
                                        }
                                        DashboardView dash = this.this$1.this$0.topui.getDashboardView();
                                        if (dash != null) {
                                            dash.closeDashboard();
                                            this.this$1.this$0.prepareProject(path);
                                        } else {
                                            ResourceLoader rl = this.this$1.this$0.topui.getResourceLoader();
                                            rl.addProject(path);
                                            boolean success = rl.loadProjectTemplate(path);
                                            if (!success) {
                                                rl.closeProjectTemplate();
                                            }
                                            AppPreferences.currentProject = path;
                                            this.this$1.this$0.newProject();
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            String[] pro = new String[]{"XLIFF Projects (*.xlf)", "TTX Projects (*.ttx)", "TMX Projects (*.tmx)", "SDLPPX Projects (*.sdlppx)", "TXML Projects (*.txml)"};
            FileFilters filters = new FileFilters();
            if (i == 0) {
                filters.setFileFilters(pro, "XLIFF Projects (*.xlf)", jFileChooser);
            } else if (i == 1) {
                filters.setFileFilters(pro, "SDLPPX Projects (*.sdlppx)", jFileChooser);
            } else if (i == 2) {
                filters.setFileFilters(pro, "TMX Projects (*.tmx)", jFileChooser);
            }
            File file = new File(dir);
            jFileChooser.setSelectedFile(new File(""));
            jFileChooser.setCurrentDirectory(file);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN PROJECT"));
            jFileChooser.repaint();
            if (0 == jFileChooser.showOpenDialog(this.topui)) {
                file = jFileChooser.getSelectedFile();
                String name = file.getName().toLowerCase();
                if (file.isDirectory() || name.endsWith(".xlf") || name.endsWith(".ttx") || name.endsWith(".tmx") || name.endsWith(".xliff") || name.endsWith(".sdlxliff") || name.endsWith(".ctp") || name.endsWith(".sdlppx") || name.endsWith(".mxliff") || name.endsWith(".mqxliff") || name.endsWith(".txml") || name.endsWith(".txlf")) {
                    String path = file.getPath();
                    if (i == 2) {
                        AppPreferences.memoryDirectory = file.getParent();
                    } else {
                        AppPreferences.projectDirectory = !file.isDirectory() ? file.getParent() : file.getPath();
                    }
                    DashboardView dash = this.topui.getDashboardView();
                    if (dash != null) {
                        dash.closeDashboard();
                    }
                    this.prepareProject(path);
                }
            }
        }
    }

    private boolean okToAbandon() {
        int i;
        if (this.project == null) {
            return true;
        }
        String title = this.project.getName();
        if (title == null || title.length() == 0) {
            title = "CafeTran Espresso";
        }
        if ((i = this.topui.getWorkflowView().getWorkflowManager().getAutosaveStatus()) > 0) {
            return true;
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE CHANGES IN THE PROJECT?"), title, 1);
        switch (value) {
            case 0: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProjectView.this.project.saveProject(false);
                    }
                });
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private void createProject() {
        this.project = new Project(this.topui, null);
        String type = "version";
        String value = "1.2";
        XLIFF xliff = new XLIFF();
        xliff.isCafeTranXLIFF = true;
        xliff.setName("xliff");
        xliff.setAttribute(type, value);
        xliff.setAttribute("xmlns", "urn:oasis:names:tc:xliff:document:1.2");
        xliff.setAttribute("xmlns:ct", "urn:cafetran:ct");
        xliff.setAttribute("xmlns:text", "urn:cafetran:text");
        xliff.setAttribute("xmlns:bill", "urn:cafetran:bill");
        xliff.setAttribute("xmlns:property", "urn:cafetran:property");
        xliff.setAttribute("xmlns:filter", "urn:cafetran:filter");
        this.project.setXLIFF(xliff);
        this.project.createFile(false);
    }

    public Project getProject() {
        return this.project;
    }

    public JMenu getMenu() {
        return this.projectMenu;
    }

    private void createProjectMenu() {
        this.projectMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT"));
        this.projectMenu.setName("MenuProject");
        this.newProjectItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW PROJECT..."));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_BOOK_PLUS, (int)this.newProjectItem.getFont().getSize(), (Color)this.newProjectItem.getForeground());
        this.newProjectItem.setIcon((Icon)ficon);
        this.newProjectItem.setName("MenuProjectNewProject");
        KeyStroke ks = KeyPreferences.getKeyStroke("k46");
        if (ks != null) {
            this.newProjectItem.setAccelerator(ks);
        }
        this.newProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int PromptResult = JOptionPane.showConfirmDialog(ProjectView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE THIS PROJECT?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE PROJECT"), 0);
                if (PromptResult == 0) {
                    ProjectView.this.topui.getWorkflowView().getWorkflowManager().endTranslation();
                    ProjectView.this.resetProgressBar();
                    ProjectView.this.topui.getResourceView().closeAll();
                    ProjectView.this.closeProject();
                    ProjectView.this.newProject();
                }
            }
        });
        this.projectMenu.add(this.newProjectItem);
        this.projectMenu.addSeparator();
        this.openProjectItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN PROJECT") + "...");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_BOOK_OPEN_PAGE_VARIANT, (int)this.openProjectItem.getFont().getSize(), (Color)this.openProjectItem.getForeground());
        this.openProjectItem.setIcon((Icon)ficon);
        this.openProjectItem.setName("MenuProjectOpenProject");
        this.openProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int PromptResult = JOptionPane.showConfirmDialog(ProjectView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE THIS PROJECT?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE PROJECT"), 0);
                if (PromptResult == 0) {
                    ProjectView.this.topui.getWorkflowView().getWorkflowManager().endTranslation();
                    ProjectView.this.resetProgressBar();
                    ProjectView.this.topui.getResourceView().closeAll();
                    ProjectView.this.closeProject();
                    ProjectView.this.openProject(0, false);
                }
            }
        });
        this.projectMenu.add(this.openProjectItem);
        this.openProjectFolderItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN PROJECT FOLDER..."));
        this.openProjectFolderItem.setName("MenuProjectOpenProject");
        ks = KeyPreferences.getKeyStroke("k47");
        if (ks != null) {
            this.openProjectFolderItem.setAccelerator(ks);
        }
        this.openProjectFolderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int PromptResult = JOptionPane.showConfirmDialog(ProjectView.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE THIS PROJECT?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE PROJECT"), 0);
                if (PromptResult == 0) {
                    ProjectView.this.topui.getWorkflowView().getWorkflowManager().endTranslation();
                    ProjectView.this.resetProgressBar();
                    ProjectView.this.topui.getResourceView().closeAll();
                    ProjectView.this.closeProject();
                    ProjectView.this.openProject(0, true);
                }
            }
        });
        this.projectMenu.add(this.openProjectFolderItem);
        JMenu recentProjectsMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RECENT PROJECTS"));
        recentProjectsMenu.setName("MenuProjectRecentProjects");
        this.projectMenu.add(recentProjectsMenu);
        List list = this.topui.getResourceLoader().getLastProjects();
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            String nn;
            File file;
            final String p = list.get(i).toString();
            if (p == null || p.length() <= 0 || !(file = new File(p)).exists()) continue;
            if (!file.isDirectory() && (nn = file.getName().toLowerCase()).endsWith(".xlf")) {
                file = file.getParentFile();
            }
            String n = file.getName();
            JMenuItem item = new JMenuItem(n);
            item.setToolTipText(file.getPath());
            item.setHorizontalAlignment(2);
            item.addActionListener(new ActionListener(){
                final /* synthetic */ ProjectView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.this$0.topui.getWorkflowView().getWorkflowManager().endTranslation();
                    this.this$0.resetProgressBar();
                    this.this$0.topui.getResourceView().closeAll();
                    this.this$0.closeProject();
                    File file = new File(p);
                    AppPreferences.projectDirectory = !file.isDirectory() ? file.getParent() : file.getPath();
                    ResourceLoader rl = this.this$0.topui.getResourceLoader();
                    rl.addProject(p);
                    boolean success = rl.loadProjectTemplate(p);
                    if (!success) {
                        rl.closeProjectTemplate();
                    }
                    AppPreferences.currentProject = p;
                    this.this$0.newProject();
                }
            });
            if (count > 0 && count % 6 == 0) {
                recentProjectsMenu.addSeparator();
            }
            recentProjectsMenu.add(item);
            if (++count == 16) break;
        }
        JMenuItem closeProjectItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE PROJECT"));
        closeProjectItem.setName("MenuProjectCloseProject");
        closeProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().getWorkflowManager().endTranslation();
                ProjectView.this.resetProgressBar();
                ProjectView.this.topui.getResourceView().closeAll();
                ProjectView.this.closeProject();
                ProjectView.this.newProject();
            }
        });
        this.projectMenu.add(closeProjectItem);
        JMenuItem menuFileEdit = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT CONFIGURATION") + "..."){

            @Override
            public void actionPerformed(ActionEvent a) {
                if (ProjectView.this.project != null) {
                    ProjectView.this.project.editFile();
                }
            }
        });
        menuFileEdit.setName("MenuProjectConfiguration");
        this.projectMenu.addSeparator();
        this.projectMenu.add(menuFileEdit);
        this.projectMenu.addSeparator();
        JMenuItem newFile = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD DOCUMENT") + "..."){

            @Override
            public void actionPerformed(ActionEvent a) {
                if (ProjectView.this.project != null) {
                    XLIFF xliff = ProjectView.this.project.getXLIFF();
                    if (xliff != null && xliff.isCafeTranXLIFF) {
                        ProjectView.this.project.createFile(true);
                    } else {
                        JOptionPane.showMessageDialog(ProjectView.this.topui, "You cannot add documents to projects created in other tools.");
                    }
                }
            }
        });
        newFile.setName("MenuProjectAddDocument");
        this.projectMenu.add(newFile);
        JMenuItem removeFile = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE DOCUMENT") + "..."){

            @Override
            public void actionPerformed(ActionEvent a) {
                if (ProjectView.this.project != null) {
                    if (((ProjectView)ProjectView.this).project.mode != 3) {
                        ProjectView.this.topui.getWorkflowView().getWorkflowManager().endTranslation();
                        ProjectView.this.project.showRemoveFiles();
                    } else {
                        ProjectView.this.topui.getWorkflowView().getWorkflowManager().getWorkflow().setSource("", false);
                        ProjectView.this.topui.getWorkflowView().getWorkflowManager().getWorkflow().setTarget("");
                        ProjectView.this.project.getXLIFF().getCurrentFile().getBody().clearFile();
                        ProjectView.this.project.getXLIFF().getView().refreshView();
                    }
                }
            }
        });
        removeFile.setName("MenuProjectRemoveDocument");
        this.projectMenu.add(removeFile);
        JMenuItem replaceFile = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE DOCUMENT") + "..."){

            @Override
            public void actionPerformed(ActionEvent a) {
                if (ProjectView.this.project != null) {
                    ProjectView.this.project.replaceFile();
                }
            }
        });
        replaceFile.setName("MenuProjectReplaceDocument");
        this.projectMenu.add(replaceFile);
        this.documentsItem = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENTS") + "..."){

            @Override
            public void actionPerformed(ActionEvent a) {
                if (ProjectView.this.project != null) {
                    ProjectView.this.project.showFiles();
                }
            }
        });
        this.documentsItem.setName("MenuProjectDocuments");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FILE_MULTIPLE, (int)this.documentsItem.getFont().getSize(), (Color)this.documentsItem.getForeground());
        this.documentsItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k48");
        if (ks != null) {
            this.documentsItem.setAccelerator(ks);
        }
        this.projectMenu.add(this.documentsItem);
        this.previewItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW CURRENT DOCUMENT"));
        this.previewItem.setName("MenuTransActionPreviewDocument");
        ks = KeyPreferences.getKeyStroke("k6");
        if (ks != null) {
            this.previewItem.setAccelerator(ks);
        }
        this.previewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().preview();
            }
        });
        this.projectMenu.add(this.previewItem);
        this.projectMenu.addSeparator();
        JMenu menuStats = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STATISTICS"));
        menuStats.setName("MenuProjectStatistics");
        StatisticsView sv = this.topui.getStatisticsView();
        sv.showStatsMenu(menuStats);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CHART_BAR, (int)menuStats.getFont().getSize(), (Color)menuStats.getForeground());
        menuStats.setIcon((Icon)ficon);
        this.projectMenu.add(menuStats);
        this.projectMenu.addSeparator();
        JMenu exportMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT AND EXCHANGE"));
        exportMenu.setName("MenuExport");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FLAG_CHECKERED, (int)exportMenu.getFont().getSize(), (Color)exportMenu.getForeground());
        exportMenu.setIcon((Icon)ficon);
        this.projectMenu.add(exportMenu);
        this.exportCurrentDocumentItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT CURRENT DOCUMENT"));
        this.exportCurrentDocumentItem.setName("MenuProjectExportCurrentDocument");
        ks = KeyPreferences.getKeyStroke("k49");
        if (ks != null) {
            this.exportCurrentDocumentItem.setAccelerator(ks);
        }
        this.exportCurrentDocumentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project p = ProjectView.this.getProject();
                if (p != null && p.mode == 3) {
                    ProjectView.this.exportProjectAs(5);
                    return;
                }
                ProjectView.this.topui.getWorkflowView().export();
            }
        });
        exportMenu.add(this.exportCurrentDocumentItem);
        JMenuItem endAll = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT ALL DOCUMENTS"));
        endAll.setName("MenuProjectExportAllDocuments");
        endAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().exportAll(false);
            }
        });
        exportMenu.add(endAll);
        exportMenu.addSeparator();
        JMenuItem exportWithNotes = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT CURRENT DOCUMENT WITH NOTES"));
        exportWithNotes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().exportWithNotes();
            }
        });
        exportWithNotes.setName("MenuProjectExportCurrentWithNotes");
        exportMenu.add(exportWithNotes);
        JMenuItem endAllWithNotes = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT ALL DOCUMENTS WITH NOTES"));
        endAllWithNotes.setName("MenuProjectExportAllDocumentsWithNotes");
        endAllWithNotes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().exportAll(true);
            }
        });
        exportMenu.add(endAllWithNotes);
        JCheckBoxMenuItem notesWithSourcesItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCLUDE SOURCE SEGMENTS IN NOTES"));
        notesWithSourcesItem.setName("MenuProjectIncludeSourceSegsInNotes");
        notesWithSourcesItem.setSelected(AppPreferences.includeSourceinNotes);
        notesWithSourcesItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                AppPreferences.includeSourceinNotes = state == 1;
            }
        });
        exportMenu.add(notesWithSourcesItem);
        exportMenu.addSeparator();
        JMenuItem exportToExternalView = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT AS BILINGUAL DOCUMENT"));
        exportToExternalView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().exportToExternalView(false);
            }
        });
        exportToExternalView.setName("MenuProjectExportAsBilingual");
        exportMenu.add(exportToExternalView);
        JMenuItem exportToExternalViewWithNotes = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT AS BILINGUAL DOCUMENT WITH NOTES"));
        exportToExternalViewWithNotes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().exportToExternalView(true);
            }
        });
        exportToExternalViewWithNotes.setName("MenuProjectExportAsBilingualWithNotes");
        exportMenu.add(exportToExternalViewWithNotes);
        JMenuItem importFromExternalView = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT BILINGUAL DOCUMENT"));
        importFromExternalView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().importFromExternalView();
            }
        });
        importFromExternalView.setName("MenuProjectImportBilingualDocument");
        exportMenu.add(importFromExternalView);
        exportMenu.addSeparator();
        JMenuItem toTMXMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TO TMX MEMORY") + "...");
        toTMXMenu.setName("MenuProjectConvertToTMX");
        toTMXMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.exportProjectAs(1);
            }
        });
        exportMenu.add(toTMXMenu);
        JMenuItem toPackageMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TO PACKAGE") + "...");
        toPackageMenu.setName("MenuProjectConvertToPackage");
        toPackageMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.exportProjectAs(4);
            }
        });
        exportMenu.add(toPackageMenu);
        JMenuItem toHTMLMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TO HTML FILE") + "...");
        toHTMLMenu.setName("MenuProjectConvertToHTML");
        toHTMLMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.exportProjectAs(2);
            }
        });
        exportMenu.add(toHTMLMenu);
        JMenuItem toTextMenu = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TO TEXT FILE") + "...");
        toTextMenu.setName("MenuProjectConvertToText");
        toTextMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.exportProjectAs(3);
            }
        });
        exportMenu.add(toTextMenu);
        this.projectMenu.addSeparator();
        this.saveProjectItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE PROJECT"));
        this.saveProjectItem.setName("MenuProjectSaveProject");
        ks = KeyPreferences.getKeyStroke("k50");
        if (ks != null) {
            this.saveProjectItem.setAccelerator(ks);
        }
        this.saveProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceView rview = ProjectView.this.topui.getResourceView();
                rview.save();
            }
        });
        this.projectMenu.add(this.saveProjectItem);
        if (AppPreferences.operatingSystem != 1) {
            this.projectMenu.addSeparator();
            this.menuItemExit = new JMenuItem();
            this.menuItemExit.setName("MenuProjectExit");
            ks = KeyPreferences.getKeyStroke("k51");
            if (ks != null) {
                this.menuItemExit.setAccelerator(ks);
            }
            this.menuItemExit.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXIT"));
            this.menuItemExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object[] ObjButtons = new String[]{"Exit", "Cancel"};
                    int PromptResult = JOptionPane.showOptionDialog(ProjectView.this.topui, "Are you sure you want to exit CafeTran Espresso?", "Confirm exit", -1, 2, null, ObjButtons, ObjButtons[0]);
                    if (PromptResult == 0) {
                        ProjectView.this.topui.dispatchEvent(new WindowEvent(ProjectView.this.topui, 201));
                    }
                }
            });
            this.projectMenu.add(this.menuItemExit);
        }
    }

    public void prepareProject(final String path) {
        this.project = new Project(this.topui, path);
        this.resetProjectTextPane();
        this.topui.resetSegmentsFilter();
        final String lcpath = path.toLowerCase();
        MySwingWorker worker = new MySwingWorker(this){
            boolean success = false;
            JProgressBar pbar = ProjectView.access$100(this.this$0).getProjectActionProgressBar();
            final /* synthetic */ ProjectView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                File file;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pbar.setIndeterminate(true);
                        pbar.setStringPainted(true);
                        pbar.setString(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING PROJECT UNITS") + " ...");
                    }
                });
                Placeables.loadPlaceables();
                if (!lcpath.startsWith("http:") && !lcpath.startsWith("file:")) {
                    file = new File(path);
                } else {
                    URI uri;
                    try {
                        uri = new URI(path);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(ProjectView.class.getName()).log(Level.SEVERE, null, ex);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this$0.topui, "Bad URI syntax");
                            }
                        });
                        return null;
                    }
                    file = new File(uri);
                }
                this.success = file.isDirectory() ? this.this$0.project.loadGlueProject(file) : (lcpath.endsWith(".sdlppx") ? this.this$0.project.makeZippedSDLProject(file) : (lcpath.endsWith(".ctp") || lcpath.endsWith(".mqxlz") ? this.this$0.project.makeZippedCTProject(file) : this.this$0.project.loadProject(file)));
                return null;
            }

            @Override
            public void finished() {
                Memory proTM = this.this$0.project.getTMXMemory();
                if (proTM != null) {
                    proTM.getProgressMonitor().close();
                }
                this.this$0.topui.removeProjectActionProgressBar(this.pbar);
                if (this.success) {
                    Project p;
                    if (AppPreferences.trackingChanges && this.this$0.topui.getTrackingChanges() == null && (p = this.this$0.topui.getProjectView().getProject()).isTrackingChangesSupported()) {
                        this.this$0.topui.setTrackingChanges();
                    }
                    this.this$0.topui.getResourceLoader().setStartupLoading(true);
                    this.this$0.project.chooseFile();
                    this.this$0.project.updateViewMode(AppPreferences.projectView);
                    XLIFF xliff = this.this$0.project.getXLIFF();
                    if (xliff != null) {
                        if (this.this$0.project.getProjects() != null) {
                            String p2 = xliff.getPath();
                            if (p2 == null) {
                                p2 = this.this$0.project.getProjectPath();
                            }
                            this.this$0.project.setTitleForFile(p2);
                            this.this$0.project.showFiles();
                        } else {
                            String gmode;
                            XliffFile xfile = xliff.getCurrentFile();
                            if (xfile != null) {
                                this.this$0.project.setTitleForFile(xfile.getShortName());
                                this.this$0.project.checkSourceFilesReferences();
                                this.this$0.project.openSkeleton(xfile);
                            }
                            if ((gmode = xliff.getGlueMode()) != null && gmode.equals("true")) {
                                this.this$0.project.setGluedWorkflow(true);
                                String id = xliff.getLastID();
                                if (xliff.getView().getGluedUnits().isEmpty()) {
                                    JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FOUND NO SEGMENTS"));
                                    xliff.getView().getMenu().showFilesDialog();
                                } else if (id != null) {
                                    this.this$0.project.edit("#" + id);
                                } else {
                                    this.this$0.project.updateViewMode(AppPreferences.projectView);
                                }
                            } else if (gmode != null && gmode.equals("false") && xfile != null) {
                                String id = xfile.getLastID();
                                if (id != null) {
                                    this.this$0.project.edit("#" + id);
                                } else {
                                    this.this$0.topui.getWorkflowView().next(0);
                                }
                            } else {
                                String lastID = xliff.getLastID();
                                if (lastID != null) {
                                    xliff.getView().getMenu().showFilesDialog();
                                } else {
                                    List files = xliff.getContentsFiles();
                                    if (files != null && files.size() > 1) {
                                        xliff.getView().getMenu().showFilesDialog();
                                    } else if (!xliff.isCafeTranXLIFF && xfile != null && !xfile.hasTranslationUnits()) {
                                        xliff.getView().getMenu().showFilesDialog();
                                    } else if (((ProjectView)this.this$0).project.mode == 2) {
                                        this.this$0.topui.getWorkflowView().getWorkflowManager().start();
                                    } else if (((ProjectView)this.this$0).project.mode == 3) {
                                        this.this$0.topui.getWorkflowView().getWorkflowManager().start();
                                        String id = xfile.getLastID();
                                        if (id != null) {
                                            this.this$0.project.edit("#" + id);
                                        }
                                    } else {
                                        this.this$0.topui.getWorkflowView().next(0);
                                    }
                                }
                            }
                        }
                        if (xliff.isExternalToolXLIFF) {
                            if (!(!((ProjectView)this.this$0).project.sdlxliffFile || Project.hasSDLTargetSegments && Project.hasSDLSourceSegments)) {
                                JOptionPane.showMessageDialog(null, "The unsegmented SDLXLIFF file is not ready for translation in CafeTran yet.\nPlease pre-translate it against a TM or copy source segments to target segments in its native tool.");
                                MainClass.getMainView().getProjectView().closeProject();
                                MainClass.getMainView().getProjectView().newProject();
                                return;
                            }
                            this.this$0.buttonExport.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FINALIZE"));
                            this.this$0.buttonExport.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET TRANSLATED STATUS FOR SEGMENTS") + " (" + Options.getShortcutComboString("k49") + ")");
                        }
                    } else {
                        TMX tmx = this.this$0.project.getTMX();
                        if (tmx != null) {
                            this.this$0.topui.getTargetView().useDeleteButton(true);
                            String p3 = tmx.getPath();
                            if (p3 == null) {
                                p3 = this.this$0.project.getProjectPath();
                            }
                            this.this$0.project.setTitleForFile(p3);
                            if (this.this$0.project.getProjects() != null) {
                                this.this$0.project.showFiles();
                            } else {
                                this.this$0.topui.getWorkflowView().getWorkflowManager().start();
                            }
                        } else {
                            TTX ttx = this.this$0.project.getTTX();
                            if (ttx != null) {
                                String p4 = ttx.getPath();
                                if (p4 == null) {
                                    p4 = this.this$0.project.getProjectPath();
                                }
                                this.this$0.project.setTitleForFile(p4);
                                String lan = ttx.getTargetLang();
                                if (lan == null || lan.length() == 0) {
                                    List list;
                                    ttx.getView().editFile();
                                    lan = ttx.getTargetLang();
                                    if (lan != null && lan.length() > 0 && (list = this.this$0.project.getProjects()) != null) {
                                        for (Object object : list) {
                                            if (!(object instanceof TTX)) continue;
                                            TTX tt = (TTX)object;
                                            tt.setTargetLang(lan);
                                        }
                                    }
                                }
                                if (this.this$0.project.getProjects() != null) {
                                    this.this$0.project.showFiles();
                                }
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this$0.topui.getResourceView().openDocumentNote(false);
                            this$0.topui.getResourceLoader().loadTranslationResources(this$0.project, false);
                        }
                    });
                    if (AppPreferences.prompter) {
                        this.this$0.topui.getSourceView().updatePrompter();
                    }
                } else {
                    JLabel statusBar = this.this$0.topui.getMainStatusBar();
                    statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT FAILED TO LOAD!"));
                }
            }
        };
        worker.start();
    }

    public JTextPane getProjectPane() {
        return this.projectTextPane;
    }

    public JTextPane getProjectPane2() {
        return this.projectTextPane2;
    }

    public GridPanel getSecondGrid() {
        return this.secondGrid;
    }

    public JToolBar getToolBar() {
        return this.bar;
    }

    void setGlossary(String rhref, String ruid) {
        String val;
        XliffFile pfile;
        XLIFF xliff;
        if (this.project != null && (xliff = this.project.getXLIFF()) != null && !xliff.isExternalToolXLIFF && (pfile = xliff.getFile(0)) != null && (val = pfile.getAttribute("tool-id")) != null && val.startsWith("CafeTran")) {
            pfile.addGlossary(rhref, ruid);
            xliff.saved = false;
            this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(1);
        }
    }

    public void removeGlossary(String rhref) {
        String val;
        XliffFile pfile;
        XLIFF xliff;
        if (this.project != null && (xliff = this.project.getXLIFF()) != null && !xliff.isExternalToolXLIFF && (pfile = xliff.getFile(0)) != null && (val = pfile.getAttribute("tool-id")) != null && val.startsWith("CafeTran")) {
            pfile.removeGlossary(rhref);
            xliff.saved = false;
            this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(1);
        }
    }

    public void setReference(String rhref, String ruid) {
        String val;
        XliffFile pfile;
        XLIFF xliff;
        if (this.project != null && (xliff = this.project.getXLIFF()) != null && !xliff.isExternalToolXLIFF && (pfile = xliff.getFile(0)) != null && (val = pfile.getAttribute("tool-id")) != null && val.startsWith("CafeTran")) {
            pfile.addReference(rhref, ruid);
            xliff.saved = false;
            this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(1);
        }
    }

    public String getReference(String ruid) {
        String val;
        XliffFile pfile;
        XLIFF xliff;
        String ref = null;
        if (this.project != null && (xliff = this.project.getXLIFF()) != null && !xliff.isExternalToolXLIFF && (pfile = xliff.getFile(0)) != null && (val = pfile.getAttribute("tool-id")) != null && val.startsWith("CafeTran")) {
            ref = pfile.getReference(ruid);
        }
        return ref;
    }

    public void removeReference(String rhref) {
        String val;
        XliffFile pfile;
        XLIFF xliff;
        if (this.project != null && (xliff = this.project.getXLIFF()) != null && !xliff.isExternalToolXLIFF && (pfile = xliff.getFile(0)) != null && (val = pfile.getAttribute("tool-id")) != null && val.startsWith("CafeTran")) {
            pfile.removeReference(rhref);
            xliff.saved = false;
            this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(1);
        }
    }

    public void removeLibreOfficeReference() {
        String val;
        XliffFile pfile;
        XLIFF xliff;
        if (this.project != null && (xliff = this.project.getXLIFF()) != null && !xliff.isExternalToolXLIFF && (pfile = xliff.getFile(0)) != null && (val = pfile.getAttribute("tool-id")) != null && val.startsWith("CafeTran")) {
            pfile.removeLibreOfficeReference();
            xliff.saved = false;
            this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(1);
        }
    }

    public void resetProjectTextPane() {
        if (this.projectTextPane != null) {
            this.projectTextPane.setContentType("plain/text");
        }
        if (this.projectTextPane2 != null) {
            this.projectTextPane2.setContentType("plain/text");
        }
    }

    public void setNavigationButtons() {
        if (!this.buttonFirst.isShowing()) {
            this.bar.add(this.buttonFirst);
            this.bar.add(this.buttonPrevious);
            this.bar.add(this.buttonNext);
            this.bar.add(this.buttonLast);
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    public void setDocumentsButton() {
        if (!this.buttonDocs.isShowing()) {
            this.bar.add(this.buttonDocs);
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    private void createProjectBar() {
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        if (AppPreferences.alpha != -1) {
            this.bar.setOpaque(false);
        } else {
            this.bar.setOpaque(true);
        }
        this.bar.setBackground(this.topui.getMainPanelBackgroundColor());
        this.buttonExport = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT"));
        this.buttonExport.setOpaque(false);
        this.buttonExport.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.buttonExport.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.buttonExport.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        this.buttonExport.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT CURRENT DOCUMENT") + " (" + Options.getShortcutComboString("k49") + ")");
        this.buttonExport.setName("ExportCurrentDoc");
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FLAG_CHECKERED, (int)(this.buttonExport.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonExport.setIcon((Icon)ficon);
        this.buttonExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project p = ProjectView.this.getProject();
                if (p != null && p.mode == 3) {
                    ProjectView.this.exportProjectAs(5);
                    return;
                }
                WorkflowView flow = ProjectView.this.topui.getWorkflowView();
                flow.end();
            }
        });
        this.bar.add(this.buttonExport);
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        this.progressBar.setUI(new KodoProgressBarUI());
        this.progressBar.setBackground(this.topui.getMainPanelBackgroundColor());
        Color c = new Color(AppPreferences.iconsColor).darker();
        this.progressBar.setForeground(c);
        this.progressBar.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CURRENT POSITION"));
        this.progressBar.setStringPainted(true);
        Dimension d = this.progressBar.getPreferredSize();
        this.progressBar.setPreferredSize(new Dimension(100, d.height));
        this.bar.add(Box.createHorizontalStrut(4));
        this.bar.add(this.progressBar);
        this.bar.add(Box.createHorizontalStrut(4));
        this.buttonFirst = new JButton();
        this.buttonFirst.setOpaque(false);
        this.buttonFirst.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonFirst.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIRST SEGMENTS"));
        this.buttonFirst.setName("FirstPage");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PAGE_FIRST, (int)(this.buttonFirst.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonFirst.setIcon((Icon)ficon);
        this.buttonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().getWorkflowManager().reviewFirst();
            }
        });
        this.buttonPrevious = new JButton();
        this.buttonPrevious.setOpaque(false);
        this.buttonPrevious.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonPrevious.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIOUS SEGMENTS"));
        this.buttonPrevious.setName("PreviousPage");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CHEVRON_DOUBLE_LEFT, (int)(this.buttonPrevious.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonPrevious.setIcon((Icon)ficon);
        this.buttonPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.previous();
            }
        });
        this.buttonNext = new JButton();
        this.buttonNext.setOpaque(false);
        this.buttonNext.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonNext.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEXT SEGMENTS"));
        this.buttonNext.setName("NextPage");
        this.buttonNext.setHorizontalTextPosition(2);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CHEVRON_DOUBLE_RIGHT, (int)(this.buttonNext.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonNext.setIcon((Icon)ficon);
        this.buttonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.next();
            }
        });
        this.buttonLast = new JButton();
        this.buttonLast.setOpaque(false);
        this.buttonLast.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonLast.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LAST SEGMENTS"));
        this.buttonLast.setName("LastPage");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PAGE_LAST, (int)(this.buttonLast.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonLast.setIcon((Icon)ficon);
        this.buttonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectView.this.topui.getWorkflowView().getWorkflowManager().reviewLast();
            }
        });
        this.buttonDocs = new JButton();
        this.buttonDocs.setOpaque(false);
        this.buttonDocs.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonDocs.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENTS"));
        this.buttonDocs.setName("MenuProjectDocuments");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FILE_MULTIPLE, (int)(this.buttonDocs.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonDocs.setIcon((Icon)ficon);
        this.buttonDocs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ProjectView.this.project != null) {
                    ProjectView.this.project.showFiles();
                }
            }
        });
        this.filterButton = new JToggleButton();
        if (AppPreferences.tbackground2 != 0) {
            this.filterButton.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.filterButton.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.filterButton.setFont(this.filterButton.getFont().deriveFont(1, AppPreferences.toolBarButtonsFontSize));
        this.filterButton.setOpaque(false);
        this.filterButton.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.filterButton.setSelected(false);
        this.filterButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTS FILTER"));
        this.filterButton.setName("SegmentsFilter");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FILTER, (int)(this.filterButton.getFont().getSize() + 4), (Color)Color.RED);
        this.filterButton.setIcon((Icon)ficon);
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XLIFF xliff;
                ProjectView.this.bar.remove(ProjectView.this.filterButton);
                ProjectView.this.bar.revalidate();
                ProjectView.this.bar.repaint();
                int mod = e.getModifiers();
                if ((mod & 2) == 2 && (xliff = ProjectView.this.project.getXLIFF()) != null) {
                    XLIFFUnit tu = xliff.getWorkflow().getCheckTransUnit();
                    int k = tu.getUnitID();
                    ProjectView.this.project.setCurrentTUIndexNoFilter(k);
                }
                ProjectView.this.topui.resetSegmentsFilter();
            }
        });
        this.add((Component)this.bar, "North");
    }

    private void createProjectTextPane() {
        File file;
        this.projectTextPane = new JTextPane();
        this.projectTextPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.projectTextPane.putClientProperty("type", "project");
        Graphics g = this.projectTextPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        Color pbackground = null;
        if (AppPreferences.pbackground != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            pbackground = new Color(AppPreferences.pbackground);
            Color pforeground = new Color(AppPreferences.pforeground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.pBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.projectTextPane.setCaretColor(pforeground);
            this.projectTextPane.setBackground(pbackground);
            this.projectTextPane.setForeground(pforeground);
            this.projectTextPane.setSelectedTextColor(pforeground);
            this.projectTextPane.setSelectionColor(selection);
        }
        this.projectTextPane.setFont(new Font(AppPreferences.pfontname, AppPreferences.pfontstyle, AppPreferences.pfontsize));
        this.projectTextPane.addHyperlinkListener(new ProjectHyperactive());
        this.projectTextPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ProjectView.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.projectTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    // empty if block
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JTextPane pane;
                String sel;
                boolean ctrl;
                if (!(evt.isPopupTrigger() || (ctrl = UITools.isShortcutDown(evt)) || (sel = (pane = (JTextPane)evt.getSource()).getSelectedText()) == null || sel.endsWith("\u200b"))) {
                    int i = sel.indexOf(10);
                    if (i != -1) {
                        sel = sel.substring(0, i);
                    }
                    TargetView pview = ProjectView.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                final int mod = evt.getModifiersEx();
                int c = evt.getClickCount();
                if (c == 1) {
                    JTextPane pane = (JTextPane)evt.getSource();
                    int pos = pane.getCaretPosition();
                    StyledDocument doc = pane.getStyledDocument();
                    Element e = doc.getCharacterElement(pos);
                    Element p = e.getParentElement();
                    String pn = p.getName();
                    if (pn.equals("p")) {
                        AttributeSet attrs = p.getAttributes();
                        Enumeration<?> en = attrs.getAttributeNames();
                        while (en.hasMoreElements()) {
                            Object v;
                            Object o = en.nextElement();
                            String id = o.toString();
                            if (!id.equals("id") || (v = attrs.getAttribute(o)) == null) continue;
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 38 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    if (this.this$1.ProjectView.this.project != null) {
                                        if (mod == 128) {
                                            ResourceView rv = this.this$1.ProjectView.this.topui.getResourceView();
                                            XLIFF xliff = this.this$1.ProjectView.this.project.getXLIFF();
                                            if (xliff != null) {
                                                XLIFFUnit tu = xliff.getView().getUnitInView(v.toString());
                                                if (tu != null) {
                                                    String s = tu.getSourceText();
                                                    rv.searchForDuplicateUnits(s);
                                                }
                                            } else {
                                                TMXUnit tu;
                                                TMX tmx = this.this$1.ProjectView.this.project.getTMX();
                                                if (tmx != null && (tu = tmx.getView().getUnitInView(v.toString())) != null) {
                                                    TranslationUnitMap map = tmx.getTUMap();
                                                    String lang = map.getSourceLang();
                                                    rv.searchForDuplicateUnits(tu.getSegment(lang));
                                                }
                                            }
                                        } else {
                                            this.this$1.ProjectView.this.project.edit("#" + v);
                                        }
                                    }
                                }
                            });
                            break;
                        }
                    }
                }
            }
        });
        this.projectTextPane.setEditable(false);
        JScrollPane sourceScroll = new JScrollPane(this.projectTextPane);
        sourceScroll.setVerticalScrollBarPolicy(22);
        sourceScroll.setHorizontalScrollBarPolicy(31);
        if (pbackground != null) {
            sourceScroll.setBackground(pbackground);
        }
        sourceScroll.setOpaque(false);
        sourceScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        sourceScroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            sourceScroll.getViewport().setOpaque(false);
            this.projectTextPane.setBackground(new Color(0, 0, 0, 0));
            this.projectTextPane.setOpaque(false);
        }
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.projectTextPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.projectTextPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.add((Component)sourceScroll, "Center");
    }

    private void createProjectTextPane2() {
        File file;
        this.projectTextPane2 = new JTextPane();
        this.projectTextPane2.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.projectTextPane2.putClientProperty("type", "project");
        Graphics g = this.projectTextPane2.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        Color pbackground = null;
        if (AppPreferences.pbackground != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            pbackground = new Color(AppPreferences.pbackground);
            Color pforeground = new Color(AppPreferences.pforeground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.pBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.projectTextPane2.setCaretColor(pforeground);
            this.projectTextPane2.setBackground(pbackground);
            this.projectTextPane2.setForeground(pforeground);
            this.projectTextPane2.setSelectedTextColor(pforeground);
            this.projectTextPane2.setSelectionColor(selection);
        }
        this.projectTextPane2.setFont(new Font(AppPreferences.pfontname, AppPreferences.pfontstyle, AppPreferences.pfontsize));
        this.projectTextPane2.addHyperlinkListener(new ProjectHyperactive());
        this.projectTextPane2.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ProjectView.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.projectTextPane2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    // empty if block
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JTextPane pane;
                String sel;
                boolean ctrl;
                if (!(evt.isPopupTrigger() || (ctrl = UITools.isShortcutDown(evt)) || (sel = (pane = (JTextPane)evt.getSource()).getSelectedText()) == null || sel.endsWith("\u200b"))) {
                    int i = sel.indexOf(10);
                    if (i != -1) {
                        sel = sel.substring(0, i);
                    }
                    TargetView pview = ProjectView.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                final int mod = evt.getModifiersEx();
                int c = evt.getClickCount();
                if (c == 1) {
                    JTextPane pane = (JTextPane)evt.getSource();
                    int pos = pane.getCaretPosition();
                    StyledDocument doc = pane.getStyledDocument();
                    Element e = doc.getCharacterElement(pos);
                    Element p = e.getParentElement();
                    String pn = p.getName();
                    if (pn.equals("p")) {
                        AttributeSet attrs = p.getAttributes();
                        Enumeration<?> en = attrs.getAttributeNames();
                        while (en.hasMoreElements()) {
                            Object v;
                            Object o = en.nextElement();
                            String id = o.toString();
                            if (!id.equals("id") || (v = attrs.getAttribute(o)) == null) continue;
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 40 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    if (this.this$1.ProjectView.this.project != null) {
                                        if (mod == 128) {
                                            ResourceView rv = this.this$1.ProjectView.this.topui.getResourceView();
                                            XLIFF xliff = this.this$1.ProjectView.this.project.getXLIFF();
                                            if (xliff != null) {
                                                XLIFFUnit tu = xliff.getView().getUnitInView(v.toString());
                                                if (tu != null) {
                                                    String s = tu.getSourceText();
                                                    rv.searchForDuplicateUnits(s);
                                                }
                                            } else {
                                                TMXUnit tu;
                                                TMX tmx = this.this$1.ProjectView.this.project.getTMX();
                                                if (tmx != null && (tu = tmx.getView().getUnitInView(v.toString())) != null) {
                                                    TranslationUnitMap map = tmx.getTUMap();
                                                    String lang = map.getSourceLang();
                                                    rv.searchForDuplicateUnits(tu.getSegment(lang));
                                                }
                                            }
                                        } else {
                                            this.this$1.ProjectView.this.project.edit("#" + v);
                                        }
                                    }
                                }
                            });
                            break;
                        }
                    }
                }
            }
        });
        this.projectTextPane2.setEditable(false);
        JScrollPane sourceScroll = new JScrollPane(this.projectTextPane2);
        sourceScroll.setVerticalScrollBarPolicy(22);
        sourceScroll.setHorizontalScrollBarPolicy(31);
        if (pbackground != null) {
            sourceScroll.setBackground(pbackground);
        }
        sourceScroll.setOpaque(false);
        sourceScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        sourceScroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            sourceScroll.getViewport().setOpaque(false);
            this.projectTextPane2.setBackground(new Color(0, 0, 0, 0));
            this.projectTextPane2.setOpaque(false);
        }
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.projectTextPane2.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.projectTextPane2);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        if (AppPreferences.alpha != -1) {
            this.topui.getTabView().addTab(this, "Grid", sourceScroll);
        } else {
            this.secondGrid = new GridPanel();
            this.secondGrid.setOpaque(true);
            if (AppPreferences.pbackground != 0) {
                this.secondGrid.setBackground(new Color(AppPreferences.pbackground));
            }
            this.secondGrid.setLayout(new BorderLayout());
            this.secondGrid.add((Component)sourceScroll, "Center");
            this.topui.getTabView().addTab(this, "Grid", this.secondGrid);
        }
    }

    public Locale getProjectTargetLocale() {
        Locale loc;
        if (this.project != null) {
            loc = this.project.getLocale();
            if (loc == null) {
                loc = Locale.getDefault();
            }
        } else {
            loc = Locale.getDefault();
        }
        return loc;
    }

    public Locale getProjectLocale() {
        Locale loc = this.project != null ? this.project.getSrcLocale() : Locale.getDefault();
        return loc;
    }

    public void saveProject() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProjectView.this.project != null) {
                    ProjectView.this.project.saveProject(false);
                }
            }
        });
    }

    public void exportProjectAs(final int as) {
        if (this.project == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO PROJECT!"));
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ProjectView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.project != null) {
                    this.this$0.project.exportProject(as);
                }
            }
        });
    }

    public void next() {
        this.project.nextTUS();
    }

    public void previous() {
        this.project.previousTUS();
    }

    public void searchCurrentDuplicates() {
        ResourceView rv = this.topui.getResourceView();
        XLIFF xliff = this.project.getXLIFF();
        if (xliff != null) {
            XLIFFUnit tu = xliff.getWorkflow().getCheckTransUnit();
            if (tu != null) {
                String s = tu.getSourceText();
                rv.searchForDuplicateUnits(s);
            }
        } else {
            TMXUnit tu;
            TMX tmx = this.project.getTMX();
            if (tmx != null && (tu = tmx.getWorkflow().getCheckTransUnit()) != null) {
                TranslationUnitMap map = tmx.getTUMap();
                String lang = map.getSourceLang();
                rv.searchForDuplicateUnits(tu.getSegment(lang));
            }
        }
    }

    public void searchEntry(String s, String r, int mode) {
        if (this.project != null) {
            this.project.searchProjectFile(s, r, mode);
        }
    }

    boolean goToTU(String s) {
        int no = -1;
        try {
            no = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        if (no > 0) {
            String s2 = "#" + Integer.toString(--no);
            if (this.project != null) {
                int number = this.project.getCurrentUnitsNumber();
                if (no < number) {
                    this.project.edit(s2, no);
                    return true;
                }
                JOptionPane.showMessageDialog(this, "Segment number " + s + " not found");
            }
        }
        return false;
    }

    boolean viewRange(String s) {
        int i = s.indexOf(45);
        if (i == -1) {
            return false;
        }
        String s1 = s.substring(0, i);
        String s2 = s.substring(i + 1);
        int no1 = -1;
        try {
            no1 = Integer.parseInt(s1);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        int no2 = -1;
        try {
            no2 = Integer.parseInt(s2);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        if (this.project != null) {
            this.topui.setSegmentsFilter();
            this.project.viewRange(no1, no2);
            return true;
        }
        return false;
    }

    public void showProjectMessage(String mes) {
        HTMLDocument doc = (HTMLDocument)this.projectTextPane.getDocument();
        try {
            doc.setInnerHTML(doc.getDefaultRootElement(), mes);
            this.projectTextPane.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        XLIFF xlf = this.project.getXLIFF();
        if (xlf != null) {
            xlf.getView().viewTypeChanged();
        }
    }

    private void resetProgressBar() {
        int val = this.progressBar.getValue();
        if (val > 0) {
            this.progressBar.setValue(0);
        }
    }

    public void setFilterButtonState(boolean state) {
        this.filterButton.setSelected(state);
        if (state) {
            if (!this.filterButton.isShowing()) {
                this.bar.add(this.filterButton);
                this.bar.revalidate();
                this.bar.repaint();
            }
        } else if (this.filterButton.isShowing()) {
            this.bar.remove(this.filterButton);
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    public void pauseSession() {
        ClipboardHandler ch = this.topui.getResourceView().getClipboardHandler();
        if (!ch.isPaused()) {
            ch.pause(true);
            this.topui.getMainStatusBar().setText("Paused listening");
        } else {
            ch.pause(false);
            this.topui.getMainStatusBar().setText("Listening for the source text...");
        }
    }

    public void scrollToSegment(final int dot) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ProjectView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    Rectangle2D r0 = this.this$0.projectTextPane.modelToView2D(dot);
                    Rectangle r = this.this$0.projectTextPane.getVisibleRect();
                    int w = (int)r.getWidth();
                    int h = (int)r.getHeight();
                    int x = (int)r.getX();
                    int y0 = (int)r0.getY();
                    r = new Rectangle(x, y0 - h / 3, w, h);
                    this.this$0.projectTextPane.scrollRectToVisible(r);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(ProjectView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    public void scrollToBottom() {
        JViewport vp = (JViewport)this.projectTextPane.getParent();
        final JScrollPane scroll = (JScrollPane)vp.getParent();
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ProjectView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                JScrollBar bar = scroll.getVerticalScrollBar();
                bar.setValue(bar.getMaximum());
            }
        });
    }

    class ProjectHyperactive
    implements HyperlinkListener {
        ProjectHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                final String s = e.getDescription();
                if (s.startsWith("filter_mode")) {
                    ProjectView.this.topui.setSegmentsFilter();
                    String mode = s.substring(s.lastIndexOf(95) + 1);
                    int i = Integer.valueOf(mode);
                    String string = ProjectView.this.topui.getResourceView().getLookUpText();
                    if (string.length() > 0) {
                        int m = ProjectView.this.topui.getResourceView().getFindMode();
                        ProjectView.this.topui.getResourceView().setFindMode(i);
                        ProjectView.this.topui.getResourceView().lookUpResource(string, null, null);
                        ProjectView.this.topui.getResourceView().setFindMode(m);
                    }
                } else if (s.startsWith("#")) {
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ ProjectHyperactive this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (this.this$1.ProjectView.this.project != null) {
                                this.this$1.ProjectView.this.project.edit(s);
                            }
                        }
                    });
                } else if (s.startsWith("$")) {
                    String ss = s.substring(1);
                    int k = Integer.parseInt(ss);
                    ProjectView.this.project.setCurrentTUIndexNoFilter(k);
                    ProjectView.this.topui.resetSegmentsFilter();
                } else if (s.startsWith("file")) {
                    try {
                        File file = new File(new URI(s));
                        if (file.exists()) {
                            ProjectView.this.topui.getResourceView().viewFile(file);
                        }
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (s.startsWith("http")) {
                    try {
                        URI uri = new URI(s);
                        ProjectView.this.topui.getResourceView();
                        ResourceView.browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (s.startsWith("www")) {
                    String s2 = "http://" + s;
                    try {
                        URI uri = new URI(s2);
                        ProjectView.this.topui.getResourceView();
                        ResourceView.browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

