/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import translator.AppPreferences;
import translator.KeyPreferences;
import translator.MainView;
import translator.MySwingWorker;
import translator.Options;
import translator.Project;
import translator.ProjectView;
import translator.ResourceView;
import translator.TargetView;
import translator.TextShortcuts;

public class Prompter {
    private MainView topui;
    private Map shortcuts;
    private Map shortcuts2;
    private ConcurrentHashMap typedWords;
    private ConcurrentHashMap phrases;
    private ConcurrentHashMap phrases2;
    private JTextComponent jtextArea;
    private Document doc;
    private TexTranKeyListener tkl;
    private Window popup;
    private JTable table;
    private DefaultTableModel model;
    private KeyStroke removeKeyStroke;
    private int screenWidth;
    public static boolean imputMethodsOverlapping = false;
    private int width;
    private int heigth;
    private Set currentWordArrays;
    private Pattern splitTypedWordsPattern;
    private Pattern wordPattern;
    private int ctrlDown = 0;
    private int xloc = -1;
    private int yloc = -1;
    MouseAdapter ma = new MouseAdapter(){
        Point mouseDownCompCoords = null;

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseDownCompCoords = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseDownCompCoords = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point currCoords = e.getLocationOnScreen();
            Prompter.this.xloc = currCoords.x - this.mouseDownCompCoords.x;
            Prompter.this.yloc = currCoords.y - this.mouseDownCompCoords.y;
            Prompter.this.popup.setLocation(Prompter.this.xloc, Prompter.this.yloc);
        }
    };
    boolean explicit = false;

    public Prompter(MainView topui) {
        this.topui = topui;
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        if (screenSize.width > 3000) {
            this.width = 800;
            this.heigth = 800;
        } else if (screenSize.width > 2400) {
            this.width = 600;
            this.heigth = 800;
        } else if (screenSize.width > 1900) {
            this.width = 400;
            this.heigth = 600;
        } else {
            this.width = 400;
            this.heigth = 600;
        }
        this.splitTypedWordsPattern = Pattern.compile(" ");
        this.wordPattern = Pattern.compile("[.,]*(\\s+|\\z)");
    }

    public void setTableFont(Font font) {
        if (this.table != null) {
            float fsize = font.getSize2D();
            if (fsize > 20.0f) {
                fsize -= 2.0f;
            }
            int rowSize = (int)fsize + 6;
            this.table.setRowHeight(rowSize);
            font = !AppPreferences.prompterEditorFont ? this.table.getFont().deriveFont(fsize) : font.deriveFont(fsize);
            this.table.setFont(font);
        }
    }

    private void setPopUp() {
        Object[] columnNames = new String[]{"Entry", "Key"};
        Object[][] data = new Object[][]{};
        this.model = new DefaultTableModel(data, columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        this.table.setTableHeader(null);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(1).setMaxWidth(25);
        this.table.setShowVerticalLines(false);
        if (AppPreferences.operatingSystem == 1) {
            this.table.setGridColor(Color.LIGHT_GRAY);
        }
        Font font = this.jtextArea.getFont();
        this.setTableFont(font);
        this.table.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable target;
                int i;
                if (e.getClickCount() == 2 && (i = (target = (JTable)e.getSource()).getSelectedRow()) != -1) {
                    Prompter.this.insertAutoEntry(i);
                }
            }
        });
        this.model = (DefaultTableModel)this.table.getModel();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        scrollPane.setPreferredSize(new Dimension(this.width, this.heigth));
        this.table.setFillsViewportHeight(true);
        this.table.setToolTipText("Press ENTER to accept or " + Options.getShortcutComboString("k65") + " to remove.");
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenWidth = dim.width;
        if (AppPreferences.operatingSystem == 2) {
            JDialog dpopup = new JDialog(this.topui);
            dpopup.setAlwaysOnTop(true);
            dpopup.setLayout(new BorderLayout());
            dpopup.setUndecorated(true);
            dpopup.setAutoRequestFocus(false);
            dpopup.setContentPane(scrollPane);
            this.popup = dpopup;
        } else {
            JWindow jwpopup = new JWindow(this.topui.getOwner());
            jwpopup.setAlwaysOnTop(true);
            jwpopup.setContentPane(scrollPane);
            jwpopup.pack();
            this.popup = jwpopup;
        }
        this.table.addMouseListener(this.ma);
        this.table.addMouseMotionListener(this.ma);
    }

    boolean isPopUpVisible() {
        return this.popup.isVisible();
    }

    public void setKeyListener() {
        ResourceView rv = this.topui.getResourceView();
        if (rv != null) {
            TextShortcuts ts = rv.getTextShortcuts();
            this.shortcuts = ts.getShortcutsMap();
            this.shortcuts2 = ts.getShortcutsMap2();
        }
        this.jtextArea = this.topui.getTargetPane();
        if (!(this.jtextArea instanceof JTextComponent)) {
            TargetView pview = this.topui.getTargetView();
            this.jtextArea = pview.getTargetPane();
        }
        this.doc = this.jtextArea.getDocument();
        this.tkl = new TexTranKeyListener();
        this.typedWords = new ConcurrentHashMap();
        this.phrases = new ConcurrentHashMap();
        this.phrases2 = new ConcurrentHashMap();
        this.currentWordArrays = new HashSet();
        this.jtextArea.addKeyListener(this.tkl);
        this.jtextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Prompter.this.closePopUp();
            }
        });
        this.jtextArea.getActionMap().put("DOWN", new AbstractAction("DOWN"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = Prompter.this.table.getSelectedRow();
                if (i == -1) {
                    Prompter.this.table.changeSelection(0, 0, false, false);
                } else {
                    int c = Prompter.this.table.getRowCount();
                    if (++i < c) {
                        Prompter.this.table.changeSelection(i, 0, false, false);
                    } else {
                        Prompter.this.table.changeSelection(0, 0, false, false);
                    }
                }
            }
        });
        this.jtextArea.getActionMap().put("UP", new AbstractAction("UP"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = Prompter.this.table.getSelectedRow();
                if (i == 0) {
                    int c = Prompter.this.table.getRowCount();
                    i = c - 1;
                    Prompter.this.table.changeSelection(i, 0, false, false);
                } else {
                    int c = Prompter.this.table.getRowCount();
                    Prompter.this.table.changeSelection(--i, 0, false, false);
                }
            }
        });
        this.jtextArea.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = Prompter.this.table.getSelectedRow();
                Prompter.this.insertAutoEntry(i);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 1", new AbstractAction("INSERT 1"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(0);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 2", new AbstractAction("INSERT 2"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(1);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 3", new AbstractAction("INSERT 3"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(2);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 4", new AbstractAction("INSERT 4"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(3);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 5", new AbstractAction("INSERT 5"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(4);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 6", new AbstractAction("INSERT 6"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(5);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 7", new AbstractAction("INSERT 7"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(6);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 8", new AbstractAction("INSERT 8"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(7);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 9", new AbstractAction("INSERT 9"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(8);
            }
        });
        this.jtextArea.getActionMap().put("INSERT 10", new AbstractAction("INSERT 10"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.insertAutoEntry(9);
            }
        });
        this.jtextArea.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Prompter.this.explicit = false;
                Prompter.this.closePopUp();
            }
        });
        this.jtextArea.getActionMap().put("DELETE", new AbstractAction("DELETE"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = Prompter.this.table.getSelectedRow();
                String entry = (String)Prompter.this.table.getValueAt(i, 0);
                if (entry != null && Prompter.this.typedWords != null) {
                    Collection c = Prompter.this.typedWords.values();
                    for (Object o : c) {
                        if (o == null) continue;
                        String[] arr = (String[])o;
                        for (int j = 0; j < arr.length; ++j) {
                            String string = arr[j];
                            if (string == null || !string.equals(entry)) continue;
                            arr[j] = "";
                            Prompter.this.table.setValueAt("", i, 0);
                            Prompter.this.table.setValueAt("", i, 1);
                        }
                    }
                }
            }
        });
        this.setPopUp();
    }

    private void insertAutoEntry(int i) {
        int c = this.table.getRowCount();
        if (i < c) {
            String entry = (String)this.table.getValueAt(i, 0);
            String key = (String)this.table.getClientProperty("key");
            if (key != null && entry.length() > 0) {
                int ind;
                if (AppPreferences.prompterCaseAdjustment && key.length() > 1 && Character.isUpperCase(key.charAt(0)) && Character.isUpperCase(key.charAt(1))) {
                    boolean toUpperCase = true;
                    if (entry.indexOf(45) != -1) {
                        toUpperCase = false;
                    } else if (key.length() > 2 && !Character.isUpperCase(key.charAt(2))) {
                        toUpperCase = false;
                    }
                    if (toUpperCase) {
                        entry = entry.toUpperCase();
                    }
                }
                String addString = (ind = entry.indexOf(key)) != -1 ? entry.substring(ind + key.length()) : entry.substring(key.length());
                try {
                    if (addString.length() > 0) {
                        int len;
                        int p = this.jtextArea.getCaretPosition();
                        if (p < (len = this.doc.getLength())) {
                            String s;
                            if (addString.charAt(0) == ' ' && ((s = this.doc.getText(0, p)).length() == 0 || s.charAt(s.length() - 1) == ' ')) {
                                addString = addString.substring(1);
                            }
                            if (AppPreferences.prompterReplaceWords) {
                                this.replaceWordAtCursor(addString, p);
                            }
                        }
                        this.doc.insertString(p, addString, null);
                        this.runPopup(true);
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(Prompter.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.closePopUp();
            }
        }
    }

    private void replaceWordAtCursor(String string, int p) throws BadLocationException {
        String text = this.doc.getText(p, this.doc.getLength() - p);
        if (text.length() > 0) {
            int ind = text.indexOf(32);
            if (ind == -1) {
                ind = text.indexOf(60);
            } else {
                int ind2 = text.indexOf(60);
                if (ind2 != -1 && ind2 < ind) {
                    ind = ind2;
                }
            }
            if (ind == -1) {
                ind = text.length();
            } else {
                int i = string.indexOf(32);
                if (i != -1) {
                    String sub = text.substring(ind);
                    String sub2 = string.substring(i);
                    char[] arr1 = sub.toCharArray();
                    char[] arr2 = sub2.toCharArray();
                    char last = '\u0000';
                    int k = 0;
                    for (int j = 0; j < arr1.length && j < arr2.length; ++j) {
                        char c = arr1[j];
                        char c2 = arr2[j];
                        if (c == c2) {
                            ++ind;
                            last = c;
                            ++k;
                            if (Character.isLetterOrDigit(c)) continue;
                            k = 0;
                            continue;
                        }
                        if (last == ' ') {
                            --ind;
                            break;
                        }
                        if (!AppPreferences.noWordSeparatorTargetLanguage && k > 0 && Character.isLetterOrDigit(c)) {
                            ind = -k;
                            break;
                        }
                        --ind;
                        break;
                    }
                }
            }
            if (ind > 1 && ind - 1 < text.length() && string.length() > 1) {
                char c1 = text.charAt(ind - 1);
                char c2 = string.charAt(string.length() - 1);
                if (Prompter.isPunctuation(c1) && !Prompter.isPunctuation(c2)) {
                    --ind;
                }
            }
            this.doc.remove(p, ind);
        }
    }

    public void removeKeyListener() {
        if (this.tkl != null) {
            this.jtextArea.removeKeyListener(this.tkl);
        }
        this.tkl = null;
        this.typedWords = null;
        this.phrases = null;
        this.phrases2 = null;
    }

    private void addPhrasesEntry(String entry, boolean fragment) {
        if (entry.length() == 0) {
            return;
        }
        if (fragment && entry.indexOf(60) != -1) {
            entry = entry.replaceAll("<[^>]+>", "");
        }
        if (entry.length() >= AppPreferences.prompterMinimalWordLength) {
            for (int j = AppPreferences.pompterStart; j < entry.length(); ++j) {
                LinkedHashSet<String> set;
                String key = entry.substring(0, j);
                Object o = this.phrases.get(key);
                if (o == null) {
                    set = new LinkedHashSet<String>(8);
                    set.add(entry);
                    this.phrases.put(key, set);
                    continue;
                }
                set = (LinkedHashSet<String>)o;
                set.add(entry);
            }
            int jj = entry.indexOf(" ");
            if (jj != -1) {
                String key = entry.substring(0, jj);
                Object o = this.phrases.get(key);
                if (o == null) {
                    LinkedHashSet<String> set = new LinkedHashSet<String>(8);
                    set.add(entry);
                    this.phrases.put(key, set);
                } else {
                    Set set = (Set)o;
                    set.add(entry);
                }
            }
        }
    }

    public void addPhrasesMTEntry(String entry, boolean fragment) {
        if (entry.length() >= AppPreferences.prompterMinimalWordLength) {
            for (int j = AppPreferences.pompterStart; j < entry.length(); ++j) {
                LinkedHashSet<String> set;
                String key = entry.substring(0, j);
                Object o = this.phrases2.get(key);
                if (o == null) {
                    set = new LinkedHashSet<String>(8);
                    set.add(entry);
                    this.phrases2.put(key, set);
                    continue;
                }
                set = (LinkedHashSet<String>)o;
                set.add(entry);
            }
        }
    }

    public synchronized void getAssembledPhrases(String entry, boolean fragment) {
        String tentry;
        this.addPhrasesEntry(entry, fragment);
        String[] atargets = this.wordPattern.split(entry);
        String firstWord = null;
        for (int i = 0; i < atargets.length && (tentry = atargets[i]) != null && tentry.length() > 0; ++i) {
            this.addPhrasesEntry(tentry, fragment);
            if (firstWord != null) {
                this.addPhrasesEntry(firstWord + " " + tentry, fragment);
            }
            firstWord = tentry;
        }
    }

    public synchronized void getMTPhrases(String entry) {
        String tentry;
        this.addPhrasesMTEntry(entry, false);
        String[] atargets = this.wordPattern.split(entry);
        String firstWord = null;
        for (int i = 0; i < atargets.length && (tentry = atargets[i]) != null && tentry.length() > 0; ++i) {
            this.addPhrasesMTEntry(tentry, true);
            if (firstWord != null) {
                this.addPhrasesMTEntry(firstWord + " " + tentry, true);
            }
            firstWord = tentry;
        }
    }

    public void removeMispelledWord(String word) {
        if (!this.currentWordArrays.isEmpty()) {
            for (String[] next : this.currentWordArrays) {
                String string;
                block1: for (int i = 0; i < next.length && (string = next[i]) != null; ++i) {
                    String[] arr = this.splitTypedWordsPattern.split(string);
                    for (int j = 0; j < arr.length; ++j) {
                        String string1 = arr[j];
                        if (!word.equals(string1)) continue;
                        next[i] = "";
                        continue block1;
                    }
                }
            }
        }
    }

    public void clearPhrases() {
        this.phrases.clear();
        this.phrases2.clear();
        this.currentWordArrays.clear();
    }

    public void makeCueWords() {
        MySwingWorker worker = new MySwingWorker(){
            ProjectView pview;
            Project project;
            {
                this.pview = Prompter.this.topui.getProjectView();
                this.project = this.pview.getProject();
            }

            @Override
            public Object construct() {
                String text;
                StringBuffer autoProject;
                StringBuilder sb = new StringBuilder();
                String dtext = null;
                Prompter.this.typedWords.clear();
                try {
                    dtext = Prompter.this.doc.getText(0, Prompter.this.doc.getLength());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                sb.append(dtext);
                sb.append(" ");
                if (this.project != null && (autoProject = this.project.toAutoCompletion()) != null) {
                    sb.append(autoProject);
                }
                if ((text = sb.toString().trim()).length() > 0) {
                    int to = 0;
                    String word2 = null;
                    Matcher m = Prompter.this.wordPattern.matcher(text);
                    while (m.find()) {
                        String string;
                        int j;
                        String[] arr;
                        Object o;
                        int from = m.start();
                        int n = from - to;
                        String word = text.substring(to, from);
                        int tag = word.indexOf(62);
                        if (tag != -1) {
                            word = word.substring(tag + 1);
                        }
                        if ((tag = word.indexOf(60)) != -1) {
                            word = word.substring(0, tag);
                        }
                        int wl = word.length();
                        int wl2 = 0;
                        if (word2 != null) {
                            wl2 = word2.length();
                        }
                        if (AppPreferences.prompterMultipleWords && word2 != null && wl2 + wl > AppPreferences.prompterMinimalWordLength && word2.endsWith(" ")) {
                            StringBuilder sb2 = new StringBuilder();
                            sb2.append(word2);
                            sb2.append(word);
                            if (sb2.length() > AppPreferences.pompterStart && wl2 > 0) {
                                String string2;
                                boolean replace;
                                String key3;
                                String key2 = sb2.substring(0, wl2 - 1);
                                o = Prompter.this.typedWords.get(key2);
                                if (o == null) {
                                    arr = new String[16];
                                    arr[0] = sb2.toString();
                                    Prompter.this.typedWords.put(key2, arr);
                                } else {
                                    arr = (String[])o;
                                    boolean replace2 = true;
                                    for (j = 0; j < arr.length; ++j) {
                                        string = arr[j];
                                        if (string == null) {
                                            arr[j] = sb2.toString();
                                            replace2 = false;
                                            break;
                                        }
                                        if (!string.equals(sb2.toString())) continue;
                                        replace2 = false;
                                        break;
                                    }
                                    if (replace2) {
                                        arr[0] = sb2.toString();
                                    }
                                }
                                if (wl2 > 1 && sb2.length() > wl2 + 1) {
                                    key3 = sb2.substring(0, wl2 + 1);
                                    o = Prompter.this.typedWords.get(key3);
                                    if (o == null) {
                                        String[] arr2 = new String[16];
                                        arr2[0] = word;
                                        Prompter.this.typedWords.put(key3, arr2);
                                    } else {
                                        String[] arr3 = (String[])o;
                                        replace = true;
                                        for (int j2 = 0; j2 < arr3.length; ++j2) {
                                            string2 = arr3[j2];
                                            if (string2 == null) {
                                                arr3[j2] = word;
                                                replace = false;
                                                break;
                                            }
                                            if (!string2.equals(word)) continue;
                                            replace = false;
                                            break;
                                        }
                                        if (replace) {
                                            arr3[0] = word;
                                        }
                                    }
                                }
                                if (wl2 > 2 && sb2.length() > wl2 + 2) {
                                    key3 = sb2.substring(0, wl2 + 2);
                                    o = Prompter.this.typedWords.get(key3);
                                    if (o == null) {
                                        String[] arr4 = new String[16];
                                        arr4[0] = word;
                                        Prompter.this.typedWords.put(key3, arr4);
                                    } else {
                                        String[] arr5 = (String[])o;
                                        replace = true;
                                        for (int j3 = 0; j3 < arr5.length; ++j3) {
                                            string2 = arr5[j3];
                                            if (string2 == null) {
                                                arr5[j3] = word;
                                                replace = false;
                                                break;
                                            }
                                            if (!string2.equals(word)) continue;
                                            replace = false;
                                            break;
                                        }
                                        if (replace) {
                                            arr5[0] = word;
                                        }
                                    }
                                }
                            }
                        }
                        if (n >= AppPreferences.prompterMinimalWordLength) {
                            for (int i = AppPreferences.pompterStart; i < word.length(); ++i) {
                                String key = word.substring(0, i);
                                o = Prompter.this.typedWords.get(key);
                                if (o == null) {
                                    arr = new String[16];
                                    arr[0] = word;
                                    Prompter.this.typedWords.put(key, arr);
                                    continue;
                                }
                                arr = (String[])o;
                                boolean replace = true;
                                for (j = 0; j < arr.length; ++j) {
                                    string = arr[j];
                                    if (string == null) {
                                        arr[j] = word;
                                        replace = false;
                                        break;
                                    }
                                    if (!string.equals(word)) continue;
                                    replace = false;
                                    break;
                                }
                                if (!replace) continue;
                                arr[0] = word;
                            }
                        }
                        to = m.end();
                        word2 = word + m.group();
                    }
                }
                return null;
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
    }

    private static String wordAtIndex(String text, int length, int j) {
        char ch;
        int i;
        StringBuilder word = new StringBuilder();
        for (i = j; i > 0 && !Character.isSpaceChar(ch = text.charAt(i - 1)) && ch != '>'; --i) {
            word.insert(0, ch);
        }
        for (i = j; i < length && !Character.isSpaceChar(ch = text.charAt(i)) && ch != '>'; ++i) {
            word.append(ch);
        }
        return word.toString();
    }

    private static String[] wordsAtIndex(String text, int j, boolean trailingSpace) {
        StringBuilder word = new StringBuilder();
        StringBuilder word2 = new StringBuilder();
        String[] words = new String[2];
        int i = j;
        char ch = text.charAt(i);
        if (!Character.isSpaceChar(ch)) {
            word.insert(0, ch);
        } else if (!trailingSpace) {
            return null;
        }
        while (i > 0) {
            ch = text.charAt(i - 1);
            if (ch == '>') {
                words[0] = word.toString();
                words[1] = "";
                return words;
            }
            if (Character.isSpaceChar(ch)) {
                word2.insert(0, ch);
                break;
            }
            word.insert(0, ch);
            --i;
        }
        --i;
        while (i > 0 && !Character.isSpaceChar(ch = text.charAt(i - 1)) && ch != '>') {
            word2.insert(0, ch);
            --i;
        }
        words[0] = word.toString();
        words[1] = word2.toString();
        return words;
    }

    private static boolean isPunctuation(char c) {
        return c >= '!' && c <= '/' || c >= ':' && c <= '?';
    }

    public void closePopUp() {
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke(40, 0));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke(38, 0));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke(10, 0));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke(27, 0));
            if (this.removeKeyStroke != null) {
                this.jtextArea.getInputMap(0).remove(this.removeKeyStroke);
            }
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('1'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('2'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('3'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('4'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('5'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('6'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('7'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('8'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('9'));
            this.jtextArea.getInputMap(0).remove(KeyStroke.getKeyStroke('0'));
        }
    }

    private void shareActionKeys() {
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), "DOWN");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), "UP");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.removeKeyStroke = KeyPreferences.getKeyStroke("k65");
        if (this.removeKeyStroke != null) {
            this.jtextArea.getInputMap(0).put(this.removeKeyStroke, "DELETE");
        }
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('1'), "INSERT 1");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('2'), "INSERT 2");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('3'), "INSERT 3");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('4'), "INSERT 4");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('5'), "INSERT 5");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('6'), "INSERT 6");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('7'), "INSERT 7");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('8'), "INSERT 8");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('9'), "INSERT 9");
        this.jtextArea.getInputMap(0).put(KeyStroke.getKeyStroke('0'), "INSERT 10");
    }

    public void autoSuggestExplicit() {
        if (!this.popup.isVisible()) {
            this.explicit = true;
            this.runPopup(true);
        } else {
            this.explicit = false;
            this.closePopUp();
        }
    }

    private void runPopup(final boolean pop) {
        if (!this.jtextArea.isEditable()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Prompter this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                21 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        int length = this.this$0.doc.getLength();
                        int cpos = this.this$0.jtextArea.getCaretPosition();
                        if (cpos == 0) {
                            this.this$0.closePopUp();
                            return;
                        }
                        String text = this.this$0.doc.getText(0, length);
                        boolean show = false;
                        show = pop ? true : (cpos >= text.length() ? true : true);
                        if (show) {
                            int wl2;
                            int autostart = this.this$0.explicit ? 0 : AppPreferences.pompterStart;
                            String[] ww = Prompter.wordsAtIndex(text, cpos - 1, false);
                            if (ww == null) {
                                this.this$0.closePopUp();
                                return;
                            }
                            String word = ww[0];
                            String word2 = ww[1];
                            int wl = word.length();
                            if (wl + (wl2 = word2.length()) >= autostart) {
                                int i;
                                Set<String> set;
                                String lword = null;
                                String lowCaseWord = null;
                                if (wl >= autostart) {
                                    Set set2;
                                    if (wl > 1 && Character.isUpperCase(word.charAt(0)) && Character.isUpperCase(word.charAt(1))) {
                                        lowCaseWord = word.toLowerCase();
                                    }
                                    if ((set = (HashSet)this.this$0.phrases.get(word)) == null) {
                                        if (lowCaseWord != null) {
                                            set = (Set)this.this$0.phrases.get(lowCaseWord);
                                            if (set == null) {
                                                lword = this.this$0.changeFirstLatterCase(lowCaseWord);
                                                set = (Set)this.this$0.phrases.get(lword);
                                            }
                                        } else {
                                            lword = this.this$0.changeFirstLatterCase(word);
                                            set = (Set)this.this$0.phrases.get(lword);
                                        }
                                    }
                                    if ((set2 = (Set)this.this$0.phrases2.get(word)) != null) {
                                        if (set != null) {
                                            set.addAll(set2);
                                        } else {
                                            set = set2;
                                        }
                                    } else {
                                        if (lowCaseWord != null) {
                                            set2 = (Set)this.this$0.phrases2.get(lowCaseWord);
                                        }
                                        if (set2 == null) {
                                            if (lword == null) {
                                                lword = lowCaseWord != null ? this.this$0.changeFirstLatterCase(lowCaseWord) : this.this$0.changeFirstLatterCase(word);
                                            }
                                            set2 = (Set)this.this$0.phrases2.get(lword);
                                        }
                                        if (set2 != null) {
                                            if (set != null) {
                                                set.addAll(set2);
                                            } else {
                                                set = set2;
                                            }
                                        }
                                    }
                                } else {
                                    set = null;
                                }
                                String[] entryTyped = null;
                                if (wl2 > 1 && wl < 3 && (entryTyped = (String[])this.this$0.typedWords.get(word2 + word)) == null) {
                                    word2 = this.this$0.changeFirstLatterCase(word2);
                                    entryTyped = (String[])this.this$0.typedWords.get(word2 + word);
                                }
                                if (entryTyped == null && wl >= autostart) {
                                    entryTyped = (String[])this.this$0.typedWords.get(word);
                                    if (entryTyped == null && lowCaseWord != null) {
                                        entryTyped = (String[])this.this$0.typedWords.get(lowCaseWord);
                                    }
                                    if (entryTyped == null) {
                                        if (lword == null) {
                                            lword = lowCaseWord != null ? this.this$0.changeFirstLatterCase(lowCaseWord) : this.this$0.changeFirstLatterCase(word);
                                        }
                                        entryTyped = (String[])this.this$0.typedWords.get(lword);
                                    }
                                }
                                if (entryTyped != null) {
                                    String string;
                                    if (set == null) {
                                        set = new HashSet();
                                    }
                                    for (i = 0; i < entryTyped.length && (string = entryTyped[i]) != null; ++i) {
                                        if (set.contains(string) || string.length() <= 0) continue;
                                        set.add(string);
                                    }
                                }
                                if (set != null) {
                                    this.this$0.table.putClientProperty("key", word);
                                    this.this$0.model.setRowCount(0);
                                    i = 1;
                                    Iterator it = set.iterator();
                                    while (it.hasNext()) {
                                        Object[] data;
                                        String e = it.next().toString();
                                        if (i == 0 || i > 10) {
                                            data = new Object[]{e, ""};
                                            this.this$0.model.addRow(data);
                                        } else if (i < 10) {
                                            data = new Object[]{e, Integer.toString(i)};
                                            this.this$0.model.addRow(data);
                                        } else if (i == 10) {
                                            data = new Object[]{e, "0"};
                                            this.this$0.model.addRow(data);
                                        }
                                        ++i;
                                    }
                                    int h = this.this$0.table.getRowHeight() * this.this$0.model.getRowCount();
                                    if (h > this.this$0.heigth) {
                                        h = this.this$0.heigth;
                                    }
                                    if (this.this$0.xloc == -1 || this.this$0.yloc == -1) {
                                        Rectangle2D r2 = this.this$0.jtextArea.modelToView2D(cpos - word.length());
                                        int x = (int)r2.getX();
                                        int y = (int)r2.getY();
                                        Point p = new Point(x, y);
                                        SwingUtilities.convertPointToScreen(p, this.this$0.jtextArea);
                                        if (p.x + 600 > this.this$0.screenWidth) {
                                            p.x = this.this$0.screenWidth - 600 - 1;
                                        }
                                        if (!imputMethodsOverlapping) {
                                            int fs = this.this$0.jtextArea.getFont().getSize();
                                            this.this$0.popup.setBounds(p.x, p.y + fs + 10, this.this$0.width, h);
                                        } else {
                                            this.this$0.popup.setBounds(p.x, 50, this.this$0.width, h);
                                        }
                                    } else {
                                        this.this$0.popup.setBounds(this.this$0.xloc, this.this$0.yloc, this.this$0.width, h);
                                    }
                                    this.this$0.popup.setVisible(true);
                                    this.this$0.table.changeSelection(0, 0, false, false);
                                    this.this$0.shareActionKeys();
                                } else {
                                    this.this$0.closePopUp();
                                }
                            } else {
                                this.this$0.closePopUp();
                            }
                        } else {
                            this.this$0.closePopUp();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    private void setPopupLocation(Component c) {
        Dimension invokerSize = c.getSize();
        Point invokerScreenLocation = c.getLocationOnScreen();
        Rectangle windowBounds = this.popup.getBounds();
        int dx = invokerScreenLocation.x + (invokerSize.width - windowBounds.width >> 1);
        int dy = invokerScreenLocation.y + (invokerSize.height - windowBounds.height >> 1);
        this.popup.setLocation(dx, dy);
    }

    private String changeFirstLatterCase(String word) {
        char wc = word.charAt(0);
        wc = Character.isUpperCase(wc) ? Character.toLowerCase(wc) : Character.toUpperCase(wc);
        char[] myChars = word.toCharArray();
        myChars[0] = wc;
        word = String.valueOf(myChars);
        return word;
    }

    class TexTranKeyListener
    extends KeyAdapter {
        TexTranKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (Prompter.this.topui.isRecordingChanges() || Prompter.this.ctrlDown >= 2) {
                Prompter.this.ctrlDown = 0;
                return;
            }
            final char c = e.getKeyChar();
            int mod = e.getModifiersEx();
            if ((mod & AppPreferences.modifier) == AppPreferences.modifier) {
                return;
            }
            if (Character.isLetter(c)) {
                Prompter.this.explicit = false;
                Prompter.this.runPopup(false);
            } else if (c == ' ' || Prompter.isPunctuation(c)) {
                Prompter.this.closePopUp();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TexTranKeyListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        try {
                            int length = this.this$1.Prompter.this.doc.getLength();
                            int cpos = this.this$1.Prompter.this.jtextArea.getCaretPosition();
                            if (cpos > 0) {
                                int wl2;
                                String phrase;
                                String word2;
                                String word;
                                String text = this.this$1.Prompter.this.doc.getText(0, length);
                                if (!AppPreferences.prompterMultipleWords) {
                                    word = Prompter.wordAtIndex(text, length, cpos - 1);
                                    word2 = null;
                                } else {
                                    String[] ww = Prompter.wordsAtIndex(text, cpos - 1, true);
                                    word = ww[0];
                                    word2 = ww[1];
                                }
                                int wl = word.length();
                                if (wl > 0 && !this.this$1.Prompter.this.shortcuts.isEmpty() && (phrase = (String)this.this$1.Prompter.this.shortcuts.get(word)) != null) {
                                    int pos = cpos - wl;
                                    this.this$1.Prompter.this.doc.remove(pos - 1, wl + 1);
                                    if (c != ' ') {
                                        phrase = phrase + c;
                                    }
                                    this.this$1.Prompter.this.doc.insertString(pos - 1, phrase, null);
                                    return;
                                }
                                if (!this.this$1.Prompter.this.shortcuts2.isEmpty() && c != ' ') {
                                    String cs = Character.toString(c);
                                    String phrase2 = (String)this.this$1.Prompter.this.shortcuts2.get(cs);
                                    if (phrase2 != null) {
                                        char c3;
                                        int pos = cpos - 1;
                                        int len = 1;
                                        if (pos > 0) {
                                            char c2 = phrase2.charAt(0);
                                            char c22 = text.charAt(pos - 1);
                                            if (c2 == '\u00ab') {
                                                String nb = Character.toString('\u00a0');
                                                phrase2 = c22 == ' ' ? Character.toString(c2) + nb : nb + Character.toString('\u00bb');
                                                c2 = phrase2.charAt(0);
                                            } else if (phrase2.length() > 1 && phrase2.endsWith(Character.toString(c22))) {
                                                phrase2 = phrase2.substring(1);
                                            }
                                            if (c2 == c22) {
                                                --pos;
                                                ++len;
                                            }
                                        } else if (pos == 0 && (c3 = phrase2.charAt(0)) == '\u00ab') {
                                            String nb = Character.toString('\u00a0');
                                            phrase2 = Character.toString(c3) + nb;
                                        }
                                        this.this$1.Prompter.this.doc.remove(pos, len);
                                        this.this$1.Prompter.this.doc.insertString(pos, phrase2, null);
                                        return;
                                    }
                                }
                                if ((wl2 = word2 != null ? word2.length() : 0) + wl > AppPreferences.prompterMinimalWordLength && wl > AppPreferences.pompterStart && wl2 - 1 > AppPreferences.pompterStart) {
                                    StringBuilder sb = new StringBuilder();
                                    if (wl2 > 0) {
                                        sb.append(word2);
                                    }
                                    sb.append(word);
                                    int i = AppPreferences.pompterStart;
                                    if (i < sb.length() && wl2 > 0) {
                                        String string;
                                        boolean replace;
                                        String key3;
                                        String[] arr;
                                        String key2 = sb.substring(0, wl2 - 1);
                                        Object o = this.this$1.Prompter.this.typedWords.get(key2);
                                        if (o == null) {
                                            arr = new String[16];
                                            arr[0] = sb.toString();
                                            this.this$1.Prompter.this.typedWords.put(key2, arr);
                                            this.this$1.Prompter.this.currentWordArrays.add(arr);
                                        } else {
                                            arr = (String[])o;
                                            boolean replace2 = true;
                                            for (int j = 0; j < arr.length; ++j) {
                                                String string2 = arr[j];
                                                if (string2 == null) {
                                                    arr[j] = sb.toString();
                                                    replace2 = false;
                                                    break;
                                                }
                                                if (!string2.equals(sb.toString())) continue;
                                                replace2 = false;
                                                break;
                                            }
                                            if (replace2) {
                                                arr[0] = sb.toString();
                                            }
                                            this.this$1.Prompter.this.currentWordArrays.add(arr);
                                        }
                                        if (wl2 > 1) {
                                            key3 = sb.substring(0, wl2 + 1);
                                            o = this.this$1.Prompter.this.typedWords.get(key3);
                                            if (o == null) {
                                                String[] arr2 = new String[16];
                                                arr2[0] = word;
                                                this.this$1.Prompter.this.typedWords.put(key3, arr2);
                                                this.this$1.Prompter.this.currentWordArrays.add(arr2);
                                            } else {
                                                String[] arr3 = (String[])o;
                                                replace = true;
                                                for (int j = 0; j < arr3.length; ++j) {
                                                    string = arr3[j];
                                                    if (string == null) {
                                                        arr3[j] = word;
                                                        replace = false;
                                                        break;
                                                    }
                                                    if (!string.equals(word)) continue;
                                                    replace = false;
                                                    break;
                                                }
                                                if (replace) {
                                                    arr3[0] = word;
                                                }
                                                this.this$1.Prompter.this.currentWordArrays.add(arr3);
                                            }
                                        }
                                        if (wl2 > 2) {
                                            key3 = sb.substring(0, wl2 + 2);
                                            o = this.this$1.Prompter.this.typedWords.get(key3);
                                            if (o == null) {
                                                String[] arr4 = new String[16];
                                                arr4[0] = word;
                                                this.this$1.Prompter.this.typedWords.put(key3, arr4);
                                                this.this$1.Prompter.this.currentWordArrays.add(arr4);
                                            } else {
                                                String[] arr5 = (String[])o;
                                                replace = true;
                                                for (int j = 0; j < arr5.length; ++j) {
                                                    string = arr5[j];
                                                    if (string == null) {
                                                        arr5[j] = word;
                                                        replace = false;
                                                        break;
                                                    }
                                                    if (!string.equals(word)) continue;
                                                    replace = false;
                                                    break;
                                                }
                                                if (replace) {
                                                    arr5[0] = word;
                                                }
                                                this.this$1.Prompter.this.currentWordArrays.add(arr5);
                                            }
                                        }
                                    }
                                }
                                if (wl >= AppPreferences.prompterMinimalWordLength) {
                                    for (int i = AppPreferences.pompterStart; i < wl; ++i) {
                                        String[] arr;
                                        String key = word.substring(0, i);
                                        Object o = this.this$1.Prompter.this.typedWords.get(key);
                                        if (o == null) {
                                            arr = new String[16];
                                            arr[0] = word;
                                            this.this$1.Prompter.this.typedWords.put(key, arr);
                                            this.this$1.Prompter.this.currentWordArrays.add(arr);
                                            continue;
                                        }
                                        arr = (String[])o;
                                        boolean replace = true;
                                        for (int j = 0; j < arr.length; ++j) {
                                            String string = arr[j];
                                            if (string == null) {
                                                arr[j] = word;
                                                replace = false;
                                                break;
                                            }
                                            if (!string.equals(word)) continue;
                                            replace = false;
                                            break;
                                        }
                                        if (replace) {
                                            arr[0] = word;
                                        }
                                        this.this$1.Prompter.this.currentWordArrays.add(arr);
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int keycode = e.getKeyCode();
            if (keycode == 17) {
                Prompter.this.ctrlDown++;
            }
            if (Prompter.this.topui.isRecordingChanges() || Prompter.this.ctrlDown >= 2) {
                return;
            }
            if ((Prompter.this.popup.isVisible() || Prompter.this.explicit) && (keycode == 37 || keycode == 39 || keycode == 8)) {
                Prompter.this.runPopup(true);
            } else if (keycode == 8) {
                Prompter.this.runPopup(false);
            }
        }
    }
}

