/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.DefaultResource;
import translator.DefaultXMLElement;
import translator.DictionaryResource;
import translator.GlossaryResource;
import translator.ImageResource;
import translator.MainView;
import translator.MySwingWorker;
import translator.Placeables;
import translator.Project;
import translator.ProjectTemplate;
import translator.ProjectView;
import translator.Resource;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.Spellcheckable;
import translator.TabView;
import translator.WebResource;
import translator.Workflow;
import translator.XMLElement;
import translator.browser.WebResourceFX;
import translator.database.DatabaseView;
import translator.database.TermBase;
import translator.hunspell.HunSpellChecker;
import translator.player.VideoResourceFX;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.xliff.FileHeader;
import translator.xliff.Glossary;
import translator.xliff.Reference;
import translator.xliff.XLIFF;
import translator.xliff.XliffFile;

public final class ResourceLoader {
    private MainView topui;
    private List loader;
    private List dloader;
    private List lastprojects;
    private List lastProjectTemplates;
    private List lastSegmentMemories;
    private List lastResources;
    private List lastGlossaries;
    private Set lastSessionResources;
    private HashSet resourcesToLoad;
    private HashSet memoriesToLoad;
    private HashSet SDLMemoriesToLoad;
    private HashSet uniqueInfoNames;
    private CountDownLatch startLatch;
    private boolean startUpLoading = true;
    private boolean lookup = false;
    private ProjectTemplate currentProjectTemplate;
    private String HTMLPreviewPath;
    private String LibreOfficePreviewPath;
    String mpath2;
    String gpath2;

    public ResourceLoader(MainView topui) {
        File f;
        this.topui = topui;
        this.loader = new ArrayList();
        this.dloader = new ArrayList();
        this.lastprojects = new ArrayList(13);
        this.lastProjectTemplates = new ArrayList(12);
        this.uniqueInfoNames = new HashSet();
        String[] s = AppPreferences.projects.split("\\|");
        for (int i = 0; i < s.length; ++i) {
            String string = s[i];
            if (string == null || string.length() <= 0) continue;
            this.lastprojects.add(string);
        }
        String[] t = AppPreferences.projectTemplates.split("\\|");
        for (int i = 0; i < t.length; ++i) {
            String string = t[i];
            if (string == null || string.length() <= 0) continue;
            this.lastProjectTemplates.add(string);
        }
        this.lastSegmentMemories = new ArrayList(13);
        this.lastResources = new ArrayList(7);
        this.lastGlossaries = new ArrayList(7);
        this.lastSessionResources = new HashSet(10);
        if (AppPreferences.currentProject != null && AppPreferences.currentProject.length() > 0 && (f = new File(AppPreferences.currentProject)).exists()) {
            this.loadProjectTemplate(AppPreferences.currentProject);
        }
        this.createMemoriesList();
        this.createResourcesList();
        this.createGlossariesList();
        this.createLastSessionResourcesList();
        Project.loadFieldLists();
    }

    public void createMemoriesList() {
        this.lastSegmentMemories.clear();
        String[] s = AppPreferences.segmentMemories.split("\\|");
        for (int i = 0; i < s.length; ++i) {
            String string = s[i];
            if (string == null || string.length() <= 0) continue;
            this.lastSegmentMemories.add(string);
        }
        if (AppPreferences.segmentMemories2 != null && AppPreferences.segmentMemories2.length() > 0) {
            String[] ss = AppPreferences.segmentMemories2.split("\\|");
            for (int i = 0; i < ss.length; ++i) {
                String string = ss[i];
                if (string == null || string.length() <= 0) continue;
                this.lastSegmentMemories.add(string);
            }
        }
    }

    public void createResourcesList() {
        this.lastResources.clear();
        String[] s = AppPreferences.resources.split("\\|");
        for (int i = 0; i < s.length; ++i) {
            String string = s[i];
            if (string == null || string.length() <= 0) continue;
            this.lastResources.add(string);
        }
    }

    public void createGlossariesList() {
        this.lastGlossaries.clear();
        String[] s = AppPreferences.glossaries.split("\\|");
        for (int i = 0; i < s.length; ++i) {
            String string = s[i];
            if (string == null || string.length() <= 0) continue;
            this.lastGlossaries.add(string);
        }
        if (AppPreferences.glossaries2 != null && AppPreferences.glossaries2.length() > 0) {
            String[] ss = AppPreferences.glossaries2.split("\\|");
            for (int i = 0; i < ss.length; ++i) {
                String string = ss[i];
                if (string == null || string.length() <= 0) continue;
                this.lastGlossaries.add(string);
            }
        }
    }

    public void prepareLoaderResources(HashSet infos) {
        this.resourcesToLoad = infos;
    }

    public void prepareLoaderMemories(HashSet memories) {
        this.memoriesToLoad = memories;
    }

    public void prepareSDLMemory(String m) {
        if (this.SDLMemoriesToLoad == null) {
            this.SDLMemoriesToLoad = new HashSet(2);
        }
        this.SDLMemoriesToLoad.add(m);
    }

    private boolean isMemoryToLoad(String h) {
        if (this.mpath2 != null && this.mpath2.equals(h)) {
            return true;
        }
        if (this.memoriesToLoad != null) {
            for (Memory m : this.memoriesToLoad) {
                String p = m.getPath();
                if (!p.equals(h)) continue;
                return true;
            }
        }
        return false;
    }

    private void loadMemories() {
        if (this.memoriesToLoad != null) {
            List loader = this.getResourceLoaderList();
            for (Memory m : this.memoriesToLoad) {
                String p = m.getPath();
                loader.remove(p);
                this.addSegmentMemory(p);
                this.addLastSessionResource(p);
                this.loadMemory(m);
            }
            this.memoriesToLoad.clear();
            this.memoriesToLoad = null;
        }
    }

    private void loadSDLMemories() {
        if (this.SDLMemoriesToLoad != null) {
            for (String m : this.SDLMemoriesToLoad) {
                this.startMemory(m, true);
            }
            this.SDLMemoriesToLoad.clear();
            this.SDLMemoriesToLoad = null;
        }
    }

    private void openTotalRecallTables() {
        SwingWorker worker = new SwingWorker(){

            public String doInBackground() {
                ArrayList tables;
                Memory totalRecallMemory = ResourceLoader.this.topui.getMemoryView().getTotalRecallMemory();
                if (totalRecallMemory != null && (tables = totalRecallMemory.getDatabaseTableNames()) != null) {
                    for (String next : tables) {
                        ResourceLoader.this.topui.getDatabaseView().openTable(next);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                ResourceLoader.this.countDownLatch();
            }
        };
        worker.execute();
    }

    public void recallMemories() {
        final Memory TotalRecallMemory = this.topui.getMemoryView().getTotalRecallMemory();
        if (TotalRecallMemory != null) {
            String slang = TotalRecallMemory.getSourceLangCode();
            String tlang = TotalRecallMemory.getTargetLangCode();
            if (slang == null || tlang == null) {
                TotalRecallMemory.setSourceLangCode(AppPreferences.fileSLang);
                TotalRecallMemory.setTargetLangCode(AppPreferences.fileTLang);
            }
            TotalRecallMemory.setMatchType(AppPreferences.matchType);
            DatabaseView dv = this.topui.getDatabaseView();
            final TermBase base = dv.connectToTermBase("Total Recall", TotalRecallMemory.getSourceLangCode(), TotalRecallMemory.getTargetLangCode());
            if (base != null) {
                base.setMainView(this.topui);
                TotalRecallMemory.setTable(base);
                String name = base.getName();
                name = name + "_TM";
                TotalRecallMemory.setName(name);
                MemoryView view = this.topui.getMemoryView();
                view.createTranslationTab(name, TotalRecallMemory);
                view.addLocalMemory(TotalRecallMemory);
                TotalRecallMemory.newTM(AppPreferences.initialCapacity);
                final JProgressBar bar = this.topui.getPretranslateProgressBar();
                bar.setIndeterminate(true);
                bar.setStringPainted(true);
                bar.setString("Recalling segments...");
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ ResourceLoader this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        TotalRecallMemory.loadDatabaseTM(base);
                        return null;
                    }

                    @Override
                    protected void done() {
                        this.this$0.topui.removePretranslateProgressBar(bar);
                        this.this$0.countDownLatch();
                    }
                };
                worker.execute();
            } else {
                this.countDownLatch();
            }
        }
    }

    public void loadPreviewPath() {
        String href = this.topui.getProjectView().getReference("LibreOffice");
        if (href != null && href.length() > 0) {
            this.LibreOfficePreviewPath = href;
        }
        if ((href = this.topui.getProjectView().getReference("Source Preview")) != null && href.length() > 0) {
            this.HTMLPreviewPath = href;
        }
    }

    public void loadReferencePaths(Project project) {
        XliffFile pfile;
        XLIFF xliff = project.getXLIFF();
        if (xliff != null && (pfile = xliff.getFile(0)) != null) {
            List loader = this.getResourceLoaderList();
            FileHeader header = pfile.getHeader();
            if (header != null) {
                String href;
                XMLElement ext;
                List refs = header.getGlossaries();
                if (refs != null) {
                    for (DefaultXMLElement r : refs) {
                        String fname;
                        File rfile;
                        ext = ((Glossary)r).getExternalFile();
                        if (ext == null || (href = ext.getAttribute("href")) == null || !href.endsWith(".res") || loader.contains(href) || !(rfile = new File(href)).exists() || this.uniqueInfoNames.contains(fname = rfile.getName())) continue;
                        loader.add(href);
                        this.uniqueInfoNames.add(fname);
                    }
                }
                if ((refs = header.getReferences()) != null) {
                    for (DefaultXMLElement r : refs) {
                        ext = ((Reference)r).getExternalFile();
                        if (ext == null) continue;
                        href = ext.getAttribute("href");
                        String uid = ext.getAttribute("uid");
                        if (href == null || loader.contains(href)) continue;
                        if (uid != null && uid.equals("LibreOffice") && href.length() > 0) {
                            this.LibreOfficePreviewPath = href;
                            continue;
                        }
                        if (uid == null || !uid.equals("Source Preview") || href.length() <= 0) continue;
                        this.HTMLPreviewPath = href;
                    }
                }
            }
        }
    }

    public void loadPreview(Project project) {
        ResourceView rv;
        if (this.LibreOfficePreviewPath != null && AppPreferences.previewWithLibreOffice && project != null && project.getLibreOfficeMode() == 0 && (rv = this.topui.getResourceView()) != null) {
            this.topui.getResourceView().openOOForPreview(this.LibreOfficePreviewPath);
        }
        if (this.HTMLPreviewPath != null) {
            this.prepareWebResource(this.HTMLPreviewPath, "Source Preview", false, false, 0);
        }
    }

    public void loadResources() {
        List loader = this.getResourceLoaderList();
        for (String info : loader) {
            if (info.endsWith(".res")) {
                this.prepareResources(info);
                continue;
            }
            if (!info.endsWith(".tmx")) continue;
            this.loadMemory(info);
        }
    }

    public void loadResourcesPaths() {
        if (this.resourcesToLoad != null) {
            List loader = this.getResourceLoaderList();
            Iterator it = this.resourcesToLoad.iterator();
            while (it.hasNext()) {
                String fname;
                File rfile;
                String info = it.next().toString();
                if (info == null || loader.contains(info) || !info.endsWith(".res") || !(rfile = new File(info)).exists() || this.uniqueInfoNames.contains(fname = rfile.getName())) continue;
                loader.add(info);
                this.uniqueInfoNames.add(fname);
            }
            this.resourcesToLoad = null;
        }
    }

    public List getResourceLoaderList() {
        return this.loader;
    }

    public List getDocumentLoaderList() {
        return this.dloader;
    }

    public void addLastSessionResource(String p) {
        this.lastSessionResources.add(p);
    }

    public void addResource(String p) {
        int i = this.lastResources.indexOf(p);
        if (i == -1) {
            this.lastResources.add(0, p);
            if (this.lastResources.size() > 64) {
                this.lastResources.remove(64);
            }
        } else {
            this.lastResources.remove(i);
            this.lastResources.add(0, p);
        }
    }

    public void addGlossary(String p) {
        int i = this.lastGlossaries.indexOf(p);
        if (i == -1) {
            this.lastGlossaries.add(0, p);
            if (this.lastGlossaries.size() > 64) {
                this.lastGlossaries.remove(64);
            }
        } else {
            this.lastGlossaries.remove(i);
            this.lastGlossaries.add(0, p);
        }
    }

    public List getLastResources() {
        return this.lastResources;
    }

    public void setLastResourcesString() {
        String infos = "";
        Iterator it = this.lastResources.iterator();
        while (it.hasNext()) {
            String info = it.next().toString();
            if (!info.endsWith(".res") || infos.length() + info.length() >= 8192) continue;
            infos = infos + info + "|";
        }
        AppPreferences.resources = infos;
    }

    public List getLastGlossaries() {
        return this.lastGlossaries;
    }

    public void setLastGlossariesString() {
        String infos = "";
        String infos2 = "";
        Iterator it = this.lastGlossaries.iterator();
        while (it.hasNext()) {
            String info = it.next().toString();
            if (info.endsWith(".res") && infos.length() + info.length() < 8192) {
                infos = infos + info + "|";
                continue;
            }
            if (info == null || info.length() <= 0 || infos2.length() + info.length() >= 8192) continue;
            infos2 = infos2 + info + "|";
        }
        AppPreferences.glossaries = infos;
        if (infos2.length() > 0) {
            AppPreferences.glossaries2 = infos2;
        }
    }

    public List getLastProjects() {
        return this.lastprojects;
    }

    public void setLastProjectsString() {
        String infos = "";
        Iterator it = this.lastprojects.iterator();
        while (it.hasNext()) {
            String info = it.next().toString();
            if (info == null || info.length() <= 0 || infos.length() + info.length() >= 8192) continue;
            infos = infos + info + "|";
        }
        AppPreferences.projects = infos;
    }

    public List getlastProjectTemplates() {
        return this.lastProjectTemplates;
    }

    public void setLastProjectTemplatesString() {
        String infos = "";
        Iterator it = this.lastProjectTemplates.iterator();
        while (it.hasNext()) {
            String info = it.next().toString();
            if (info == null || info.length() <= 0 || infos.length() + info.length() >= 8192) continue;
            infos = infos + info + "|";
        }
        AppPreferences.projectTemplates = infos;
    }

    public void createLastSessionResourcesList() {
        String string;
        int i;
        this.lastSessionResources.clear();
        String[] s = AppPreferences.resourcesLastSession.split("\\|");
        for (i = 0; i < s.length; ++i) {
            string = s[i];
            if (string == null || string.length() <= 0) continue;
            this.addLastSessionResource(string);
        }
        s = AppPreferences.resourcesLastSession2.split("\\|");
        for (i = 0; i < s.length; ++i) {
            string = s[i];
            if (string == null || string.length() <= 0) continue;
            this.addLastSessionResource(string);
        }
    }

    public void clearLastSessionResources() {
        this.lastSessionResources.clear();
    }

    public boolean isLastSessionResource(String r) {
        return this.lastSessionResources.contains(r);
    }

    public void removeLastSessionResource(String r) {
        if (!this.topui.exit) {
            this.lastSessionResources.remove(r);
        }
    }

    public Set getLastSessionResources() {
        return this.lastSessionResources;
    }

    public void setLastSessionResourcesString() {
        String infos = "";
        String infos2 = "";
        Iterator it = this.lastSessionResources.iterator();
        while (it.hasNext()) {
            String info = it.next().toString();
            if (info != null && info.length() > 0 && infos.length() + info.length() < 8192) {
                infos = infos + info + "|";
                continue;
            }
            if (info == null || info.length() <= 0 || infos2.length() + info.length() >= 8192) continue;
            infos2 = infos2 + info + "|";
        }
        AppPreferences.resourcesLastSession = infos;
        if (infos2.length() > 0) {
            AppPreferences.resourcesLastSession2 = infos2;
        }
    }

    public void addProject(String p) {
        int i = this.lastprojects.indexOf(p);
        if (i == -1) {
            this.lastprojects.add(0, p);
            if (this.lastprojects.size() > 32) {
                this.lastprojects.remove(32);
            }
        } else {
            this.lastprojects.remove(i);
            this.lastprojects.add(0, p);
        }
    }

    public void removeProject(String p) {
        this.lastprojects.remove(p);
    }

    public ProjectTemplate getCurrentProjectTemplate() {
        return this.currentProjectTemplate;
    }

    public boolean removeCurrentProjectTemplate() {
        String p;
        if (this.currentProjectTemplate == null) {
            return false;
        }
        File file = this.currentProjectTemplate.getTemplateFile();
        if (file != null && (p = file.getPath()) != null && p.length() > 0) {
            this.lastProjectTemplates.remove(p);
        }
        this.currentProjectTemplate.removeProjectTemplate();
        this.currentProjectTemplate = null;
        return true;
    }

    public void addProjectTemplate(ProjectTemplate pt) {
        String p;
        File file = pt.getTemplateFile();
        if (file != null && (p = file.getPath()) != null && p.length() > 0) {
            this.currentProjectTemplate = pt;
            int i = this.lastProjectTemplates.indexOf(p);
            if (i == -1) {
                this.lastProjectTemplates.add(0, p);
                if (this.lastProjectTemplates.size() > 12) {
                    this.lastProjectTemplates.remove(12);
                }
            } else {
                this.lastProjectTemplates.remove(i);
                this.lastProjectTemplates.add(0, p);
            }
        }
    }

    public boolean isCurrentTemplate(String pp) {
        ProjectTemplate currPT = this.getCurrentProjectTemplate();
        if (currPT != null) {
            String pp2 = currPT.getCurrentProject();
            if (pp2 != null && pp2.equals(pp)) {
                return true;
            }
            ProjectTemplate projectTemplate = new ProjectTemplate();
            projectTemplate.setProjectTemplate(pp);
            File templateFile = projectTemplate.getTemplateFile();
            File templateFile2 = currPT.getTemplateFile();
            if (templateFile != null && templateFile2 != null && templateFile.equals(templateFile2)) {
                return true;
            }
        }
        return false;
    }

    public boolean loadProjectTemplate(String pp) {
        if (pp == null) {
            return false;
        }
        ProjectTemplate projectTemplate = new ProjectTemplate();
        projectTemplate.setProjectTemplate(pp);
        boolean success = projectTemplate.loadTemplate();
        if (success) {
            this.addProjectTemplate(projectTemplate);
            TabView.createJoinResourcesMap();
            TabView.createFloatingFramesMap();
            return true;
        }
        return false;
    }

    public void saveProjectTemplate(String pp, boolean exit) {
        ProjectTemplate pt = this.getCurrentProjectTemplate();
        if (pt != null) {
            pt.setProjectResources(this.topui);
            pt.setCTPreferences();
            if (pp != null && pp.length() > 0) {
                pt.mapProjectToTemplate(pp);
            }
            pt.saveTemplate();
            if (exit) {
                pt.removeTemplateNode();
            } else {
                this.createLastSessionResourcesList();
            }
        }
    }

    public void clearTemplateMap() {
        if (this.currentProjectTemplate != null) {
            this.currentProjectTemplate.clearTemplateMap();
        } else {
            ProjectTemplate pt = new ProjectTemplate();
            pt.clearTemplateMap();
        }
    }

    public void closeProjectTemplate() {
        this.currentProjectTemplate = null;
    }

    public List getLastSegmentMemories() {
        return this.lastSegmentMemories;
    }

    public void setLastMemoriesString() {
        String infos = "";
        String infos2 = "";
        Iterator it = this.lastSegmentMemories.iterator();
        while (it.hasNext()) {
            String info = it.next().toString();
            if (info != null && info.length() > 0 && infos.length() + info.length() < 8192) {
                infos = infos + info + "|";
                continue;
            }
            if (info == null || info.length() <= 0 || infos2.length() + info.length() >= 8192) continue;
            infos2 = infos2 + info + "|";
        }
        AppPreferences.segmentMemories = infos;
        if (infos2.length() > 0) {
            AppPreferences.segmentMemories2 = infos2;
        }
    }

    public void addSegmentMemory(String p) {
        int i = this.lastSegmentMemories.indexOf(p);
        if (i == -1) {
            this.lastSegmentMemories.add(0, p);
            if (this.lastSegmentMemories.size() > 100) {
                this.lastSegmentMemories.remove(100);
            }
        } else {
            this.lastSegmentMemories.remove(i);
            this.lastSegmentMemories.add(0, p);
        }
    }

    public void loadMemory(final Memory m) {
        String name;
        MemoryView view = this.topui.getMemoryView();
        if (view.memoryExists(name = m.getName())) {
            return;
        }
        m.setSourceLangCode(AppPreferences.fileSLang);
        m.setTargetLangCode(AppPreferences.fileTLang);
        m.setMatchType(AppPreferences.matchType);
        String path = m.getPath();
        this.setMemoryReference(path, name);
        if (path.toLowerCase().endsWith(".txt")) {
            m.tabbedTM = true;
        }
        view.createTranslationTab(name, m);
        view.addLocalMemory(m);
        if (m.isPretranslateOnly()) {
            m.newTM(AppPreferences.initialCapacity);
            this.countDownLatch();
        } else {
            SwingWorker worker = new SwingWorker(this){
                final /* synthetic */ ResourceLoader this$0;
                {
                    this.this$0 = this$0;
                }

                public String doInBackground() {
                    m.loadTM();
                    return null;
                }

                @Override
                protected void done() {
                    m.finishLoadTM();
                    this.this$0.countDownLatch();
                }
            };
            worker.execute();
        }
    }

    public void loadMemory(String tmx) {
        MemoryView mview = this.topui.getMemoryView();
        final Memory m = mview.createSegmentsMemory(false);
        m.setPath(tmx);
        String name = m.getName();
        if (mview.memoryExists(name)) {
            return;
        }
        m.setMainView(this.topui);
        File file = new File(tmx);
        if (file.isDirectory()) {
            m.setReadOnly(true);
        }
        m.setSourceLangCode(AppPreferences.fileSLang);
        m.setTargetLangCode(AppPreferences.fileTLang);
        String path = m.getPath();
        this.setMemoryReference(path, name);
        if (path.toLowerCase().endsWith(".txt")) {
            m.tabbedTM = true;
        }
        MemoryView view = this.topui.getMemoryView();
        view.createTranslationTab(name, m);
        view.addLocalMemory(m);
        if (m.isPretranslateOnly()) {
            m.newTM(AppPreferences.initialCapacity);
            this.countDownLatch();
        } else {
            SwingWorker worker = new SwingWorker(this){
                final /* synthetic */ ResourceLoader this$0;
                {
                    this.this$0 = this$0;
                }

                public String doInBackground() {
                    m.loadTM();
                    return null;
                }

                @Override
                protected void done() {
                    m.finishLoadTM();
                    this.this$0.countDownLatch();
                }
            };
            worker.execute();
        }
    }

    public void startMemory(String mpath, boolean readonly) {
        final Memory ntr = new Memory(mpath);
        ntr.setReadOnly(readonly);
        MemoryView mview = this.topui.getMemoryView();
        if (mview.memoryExists(ntr.getName())) {
            return;
        }
        ntr.setNewlyAdded(true);
        ntr.setMainView(this.topui);
        int i = mpath.lastIndexOf(AppPreferences.fs);
        String title = null;
        if (i != -1) {
            title = mpath.substring(i + 1);
        }
        if (mpath.toLowerCase().endsWith(".txt")) {
            ntr.tabbedTM = true;
        }
        ntr.showStartDialog(title);
        if (ntr.canLoad()) {
            String name = ntr.getName();
            this.setMemoryReference(mpath, name);
            String ext = mpath.toLowerCase();
            if (!ntr.isReadOnly() && (ext.endsWith(".tmx") || ext.endsWith(".txt"))) {
                this.addSegmentMemory(mpath);
                this.addLastSessionResource(mpath);
            }
            MemoryView view = this.topui.getMemoryView();
            view.createTranslationTab(name, ntr);
            view.addLocalMemory(ntr);
            if (ntr.isPretranslateOnly()) {
                ntr.newTM(AppPreferences.initialCapacity);
                this.countDownLatch();
            } else {
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ ResourceLoader this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        ntr.loadTM();
                        return null;
                    }

                    @Override
                    protected void done() {
                        ntr.finishLoadTM();
                        this.this$0.countDownLatch();
                    }
                };
                worker.execute();
            }
        } else {
            this.removeMemoryReference(mpath);
            this.countDownLatch();
        }
    }

    public void startExternalMemory(String mpath, int mode) {
        final Memory ntr = new Memory(mpath);
        MemoryView mview = this.topui.getMemoryView();
        if (mview.memoryExists(ntr.getName())) {
            return;
        }
        if (mode == 3) {
            ntr.sdlTM = true;
        } else if (mode == 4) {
            ntr.wfTM = true;
            ntr.encoding = "UTF-16";
        } else if (mode == 6) {
            ntr.multitermTM = true;
        }
        ntr.setMainView(this.topui);
        int i = mpath.lastIndexOf(AppPreferences.fs);
        String title = null;
        if (i != -1) {
            title = mpath.substring(i + 1);
        }
        ntr.showStartDialog(title);
        if (ntr.canLoad()) {
            String name = ntr.getName();
            this.setMemoryReference(mpath, name);
            String ext = mpath.toLowerCase();
            if (!ntr.isReadOnly() && (ext.endsWith(".tmx") || ext.endsWith(".txt"))) {
                this.addSegmentMemory(mpath);
                this.addLastSessionResource(mpath);
            }
            MemoryView view = this.topui.getMemoryView();
            view.createTranslationTab(name, ntr);
            view.addLocalMemory(ntr);
            if (ntr.isPretranslateOnly()) {
                ntr.newTM(AppPreferences.initialCapacity);
                this.countDownLatch();
            } else {
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ ResourceLoader this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        ntr.loadTM();
                        return null;
                    }

                    @Override
                    protected void done() {
                        ntr.finishLoadTM();
                        this.this$0.countDownLatch();
                    }
                };
                worker.execute();
            }
        } else {
            this.removeMemoryReference(mpath);
        }
    }

    public void startPretranslationMemory(final Memory ntr) {
        MemoryView mview = this.topui.getMemoryView();
        if (mview.memoryExists(ntr.getName())) {
            return;
        }
        String mpath = ntr.getPath();
        ntr.setMainView(this.topui);
        ntr.setNewlyAdded(true);
        int i = mpath.lastIndexOf(AppPreferences.fs);
        String title = null;
        if (i != -1) {
            title = mpath.substring(i + 1);
        }
        ntr.showStartDialog(title);
        if (ntr.canLoad()) {
            String name = ntr.getName();
            this.setMemoryReference(mpath, name);
            String ext = mpath.toLowerCase();
            if (!ntr.isReadOnly() && ext.endsWith(".tmx")) {
                this.addSegmentMemory(mpath);
                this.addLastSessionResource(mpath);
            }
            MemoryView view = this.topui.getMemoryView();
            view.createTranslationTab(name, ntr);
            view.addLocalMemory(ntr);
            if (ntr.isPretranslateOnly()) {
                ntr.newTM(AppPreferences.initialCapacity);
                this.countDownLatch();
            } else {
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ ResourceLoader this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        ntr.loadTM();
                        return null;
                    }

                    @Override
                    protected void done() {
                        ntr.finishLoadTM();
                        this.this$0.countDownLatch();
                    }
                };
                worker.execute();
            }
        } else {
            this.removeMemoryReference(mpath);
        }
    }

    public void importMemory(String mpath, int type) {
        final Memory ntr = new Memory(mpath);
        MemoryView mview = this.topui.getMemoryView();
        if (mview.memoryExists(ntr.getName())) {
            return;
        }
        ntr.setMainView(this.topui);
        ntr.setImported(type);
        int i = mpath.lastIndexOf(AppPreferences.fs);
        String title = null;
        if (i != -1) {
            title = mpath.substring(i + 1);
        }
        ntr.showStartDialog(title);
        if (ntr.canLoad()) {
            String name = ntr.getName();
            this.setMemoryReference(mpath, name);
            MemoryView view = this.topui.getMemoryView();
            view.createTranslationTab(name, ntr);
            view.addLocalMemory(ntr);
            SwingWorker worker = new SwingWorker(this){
                final /* synthetic */ ResourceLoader this$0;
                {
                    this.this$0 = this$0;
                }

                public String doInBackground() {
                    ntr.loadTM();
                    return null;
                }

                @Override
                protected void done() {
                    ntr.finishLoadTM();
                    this.this$0.countDownLatch();
                }
            };
            worker.execute();
        }
    }

    public void startMemoryFromInfo(ResourceInfo ri) {
        final Memory ntr = new Memory(ri);
        MemoryView mview = this.topui.getMemoryView();
        if (mview.memoryExists(ntr.getName())) {
            return;
        }
        ntr.setNewlyAdded(true);
        ntr.setMainView(this.topui);
        String title = ntr.getName();
        ntr.showStartDialog(title);
        if (ntr.canLoad()) {
            String name = ntr.getName();
            if (this.currentProjectTemplate == null) {
                String href;
                ProjectView prview = this.topui.getProjectView();
                String uid = ri.getName();
                if (uid == null) {
                    uid = "";
                }
                if ((href = ri.getInfoPath()) != null) {
                    prview.setReference(href, uid);
                }
            }
            MemoryView view = this.topui.getMemoryView();
            view.createTranslationTab(name, ntr);
            view.addLocalMemory(ntr);
            SwingWorker worker = new SwingWorker(this){
                final /* synthetic */ ResourceLoader this$0;
                {
                    this.this$0 = this$0;
                }

                public String doInBackground() {
                    ntr.loadTM();
                    return null;
                }

                @Override
                protected void done() {
                    ntr.finishLoadTM();
                    this.this$0.countDownLatch();
                }
            };
            worker.execute();
        }
    }

    public void setMemoryReference(String href, String uid) {
        if (!uid.equalsIgnoreCase("ProjectTM") && this.currentProjectTemplate == null) {
            ProjectView prview = this.topui.getProjectView();
            prview.setReference(href, uid);
        }
    }

    public void removeMemoryReference(String href) {
        List loader = this.getResourceLoaderList();
        if (loader.contains(href)) {
            loader.remove(href);
        }
        ProjectView prview = this.topui.getProjectView();
        prview.removeReference(href);
        this.removeLastSessionResource(href);
    }

    public void loadTranslationResources(Project project, boolean newProject) {
        String mpath = null;
        String gpath = null;
        if (newProject) {
            mpath = AppPreferences.projectDirectory + AppPreferences.fs + "ProjectTM.tmx";
            gpath = AppPreferences.projectDirectory + AppPreferences.fs + "ProjectTerms.txt";
        }
        int threads = 0;
        this.mpath2 = null;
        this.gpath2 = null;
        this.startUpLoading = true;
        AssembleParser.setMatchingType(AppPreferences.matchType);
        if (newProject) {
            this.assertProjectTM(mpath);
            if (AppPreferences.projectGlossary) {
                this.assertProjectGlossary(gpath);
            }
        } else if (project != null) {
            HunSpellChecker hp;
            String s;
            File f;
            this.mpath2 = project.getProjectTMPath();
            if (this.mpath2 != null) {
                ++threads;
            } else if (AppPreferences.projectTMX) {
                project.createProjectTM();
            }
            this.gpath2 = project.getProjectTermsPath();
            if (this.gpath2 != null) {
                ++threads;
            } else if (AppPreferences.projectGlossary) {
                project.createProjectGlossary();
            }
            String dir = project.getProjectDirectory();
            if (dir != null && (f = new File(s = dir + AppPreferences.fs + "resources" + AppPreferences.fs + "spellchecker" + AppPreferences.fs + "user.dic")).exists() && (hp = this.topui.getSpellChecker()) != null) {
                hp.loadIgnoredWords(f);
            }
        }
        if (!newProject && project != null) {
            if (this.currentProjectTemplate == null) {
                this.loadReferencePaths(project);
            } else {
                this.loadPreviewPath();
            }
        }
        this.loadResourcesPaths();
        this.uniqueInfoNames.clear();
        List loader = this.getResourceLoaderList();
        threads += loader.size();
        if (this.memoriesToLoad != null) {
            threads += this.memoriesToLoad.size();
        }
        if (this.SDLMemoriesToLoad != null) {
            threads += this.SDLMemoriesToLoad.size();
        }
        if (this.topui.getMemoryView().getTotalRecallMemory() != null) {
            ++threads;
        }
        this.loadPreview(project);
        if (threads == 0) {
            this.finishLoadingResources();
            return;
        }
        this.startLatch = new CountDownLatch(threads);
        if (this.mpath2 != null) {
            this.loadProjectTM(this.mpath2);
        }
        if (this.gpath2 != null) {
            this.loadProjectTerms(this.gpath2);
        }
        this.loadMemories();
        if (project != null && project.mode == 2) {
            this.openTotalRecallTables();
        } else {
            this.recallMemories();
        }
        this.loadResources();
        this.loadSDLMemories();
    }

    public void assertProjectGlossary(String gpath) {
        boolean loaded = false;
        ResourceView mv = this.topui.getResourceView();
        List gloss = mv.getGlossaries();
        if (gloss != null) {
            for (GlossaryResource m : gloss) {
                String mname = m.getName();
                if (mname == null || !mname.equals("ProjectTerms")) continue;
                loaded = true;
                break;
            }
        }
        if (!loaded) {
            ResourceInfo ri = new ResourceInfo();
            ri.setEntry("Path", gpath);
            ri.setEntry("Name", "ProjectTerms");
            ri.setEntry("Encoding", "UTF-8");
            ri.setEntry("Entry word separator", "\t");
            ri.setEntry("Priority", "2");
            GlossaryResource g = new GlossaryResource(ri);
            g.setMainView(this.topui);
            this.topui.getResourceView().addGlossary(g);
            g.checkTrialVersionLimit(false);
        }
    }

    public void assertProjectTM(String mPath) {
        File mfile = new File(mPath);
        boolean loaded = false;
        MemoryView mv = this.topui.getMemoryView();
        List mems = mv.getLocalMemories();
        for (Memory m : mems) {
            String name = m.getName();
            if (name == null || !name.equals("ProjectTM")) continue;
            loaded = true;
            if (!mfile.exists()) {
                m.setMatchType(AppPreferences.matchType);
                m.saveMemory(mPath);
                break;
            }
            String p = m.getPath();
            if (p != null && p.length() != 0) break;
            m.setMatchType(AppPreferences.matchType);
            m.setSavedStatus(true);
            m.setPath(mPath);
            m.loadTM();
            m.finishLoadTM();
            break;
        }
        if (mfile.exists() && !loaded) {
            this.loadProjectTM(mPath);
        }
    }

    private void loadProjectTM(String mPath) {
        final Memory ntr = new Memory(mPath);
        MemoryView mview = this.topui.getMemoryView();
        if (mview.memoryExists(ntr.getName())) {
            return;
        }
        ntr.setMainView(this.topui);
        ntr.setEncoding("UTF-8");
        ntr.setSourceLangCode(AppPreferences.fileSLang);
        ntr.setTargetLangCode(AppPreferences.fileTLang);
        String id = AppPreferences.userid;
        if (id.length() > 0) {
            ntr.setUserID(id);
        }
        if (AppPreferences.prefixMatchMemoryPR) {
            ntr.setPrefixMatch(true);
            ntr.setPrefixAccuracy(AppPreferences.memPrefixAccuracy);
        }
        ntr.setMatchType(AppPreferences.matchType);
        ntr.setPriority(AppPreferences.priorityMemoryPR);
        ntr.setWorkflowMode(0);
        ntr.setReadOnly(false);
        ntr.setSegmentsMode(AppPreferences.forSegmentsMemoryPR);
        ntr.setTermsMode(AppPreferences.forTermsMemoryPR);
        ntr.setTermsCheck(AppPreferences.termsCheckMemoryPR);
        ntr.setWithTagPositions(true);
        ntr.setDuplicatesMode(AppPreferences.duplicatesMemoryPR);
        ntr.setCaseMatch(AppPreferences.matchCaseMemoryPR);
        ntr.setGreedyMatching(AppPreferences.exactGreedyMatchMemoryPR);
        String name = ntr.getName();
        MemoryView view = this.topui.getMemoryView();
        view.createTranslationTab(name, ntr);
        view.addLocalMemory(ntr);
        if (ntr.isPretranslateOnly()) {
            ntr.newTM(AppPreferences.initialCapacity);
            this.countDownLatch();
        } else {
            SwingWorker worker = new SwingWorker(this){
                final /* synthetic */ ResourceLoader this$0;
                {
                    this.this$0 = this$0;
                }

                public String doInBackground() {
                    ntr.loadTM();
                    return null;
                }

                @Override
                protected void done() {
                    ntr.finishLoadTM();
                    this.this$0.countDownLatch();
                }
            };
            worker.execute();
        }
    }

    private void loadProjectTerms(String gPath) {
        ResourceInfo ri = new ResourceInfo();
        ri.setEntry("Path", gPath);
        ri.setEntry("Name", "ProjectTerms");
        ri.setEntry("Encoding", "UTF-8");
        ri.setEntry("Entry word separator", "\t");
        ri.setEntry("Priority", "2");
        GlossaryResource g = new GlossaryResource(ri);
        g.setMainView(this.topui);
        this.topui.getResourceView().addGlossary(g);
        g.checkTrialVersionLimit(false);
        this.countDownLatch();
    }

    public void openProjectTerms(String projectPath) {
        File pf = new File(projectPath);
        String xlfdir = pf.getParent();
        String mpath = xlfdir + AppPreferences.fs + "ProjectTerms.txt";
        File mfile = new File(mpath);
        if (!mfile.exists()) {
            return;
        }
        boolean loaded = false;
        ResourceView rv = this.topui.getResourceView();
        List gl = rv.getGlossaries();
        if (gl != null) {
            for (GlossaryResource g : gl) {
                String mname = g.getName();
                if (mname == null || !mname.equals("ProjectTerms")) continue;
                loaded = true;
                break;
            }
        }
        if (!loaded) {
            GlossaryResource g;
            ResourceInfo ri = new ResourceInfo();
            ri.setEntry("Path", mpath);
            ri.setEntry("Name", "ProjectTerms");
            ri.setEntry("Encoding", "UTF-8");
            ri.setEntry("Entry word separator", "\t");
            ri.setEntry("Priority", "2");
            g = new GlossaryResource(ri);
            g.setMainView(this.topui);
            this.topui.getResourceView().addGlossary(g);
            g.checkTrialVersionLimit(false);
        }
    }

    public void prepareResources(String iPath) {
        ResourceInfo ri = new ResourceInfo(iPath);
        String type = ri.getType();
        if (type.equals("glossary")) {
            this.addGlossary(iPath);
            this.addLastSessionResource(iPath);
        } else if (!type.equals("java") && !type.equals("database")) {
            this.addResource(iPath);
            this.addLastSessionResource(iPath);
        }
        if (type.equals("database")) {
            DatabaseView dview = this.topui.getDatabaseView();
            dview.prepareDatabase(ri);
        } else if (type.equals("memory")) {
            this.startMemoryFromInfo(ri);
        } else if (type.equals("dictionary")) {
            this.prepareDictionaryResource(ri);
        } else if (type.equals("glossary")) {
            this.prepareGlossaryResource(ri);
        } else if (type.equals("internet") || type.equals("web")) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ResourceLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (AppPreferences.operatingSystem == 1) {
                this.prepareWebResourceMacOS(ri);
            } else {
                this.prepareWebResource(ri);
            }
        } else if (type.equals("image")) {
            this.prepareImageResource(ri);
        } else if (type.equals("java")) {
            this.prepareJavaResource(ri);
        }
    }

    private void prepareDictionaryResource(final ResourceInfo ri) {
        MySwingWorker worker = new MySwingWorker(this){
            DictionaryResource dr;
            final /* synthetic */ ResourceLoader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.dr = new DictionaryResource(ri);
                return null;
            }

            @Override
            public void finished() {
                this.dr.setMainView(this.this$0.topui);
                if (this.this$0.currentProjectTemplate == null) {
                    int sep;
                    ProjectView pro = this.this$0.topui.getProjectView();
                    String ref = ri.getInfoPath();
                    if (ref.endsWith(".res") && (sep = ref.lastIndexOf(AppPreferences.fs)) != -1) {
                        String uid = ref.substring(sep + 1, ref.length() - 4);
                        pro.setReference(ref, uid);
                    }
                }
                this.this$0.topui.getResourceView().setDefaultResource(this.dr);
                this.this$0.countDownLatch();
            }
        };
        worker.start();
    }

    private void prepareGlossaryResource(final ResourceInfo ri) {
        MySwingWorker worker = new MySwingWorker(this){
            GlossaryResource g;
            final /* synthetic */ ResourceLoader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.g = new GlossaryResource(ri);
                return null;
            }

            @Override
            public void finished() {
                this.g.setMainView(this.this$0.topui);
                if (this.this$0.currentProjectTemplate == null) {
                    int sep;
                    ProjectView pro = this.this$0.topui.getProjectView();
                    String ref = ri.getInfoPath();
                    if (ref.endsWith(".res") && (sep = ref.lastIndexOf(AppPreferences.fs)) != -1) {
                        String uid = ref.substring(sep + 1, ref.length() - 4);
                        pro.setGlossary(ref, uid);
                    }
                }
                this.this$0.topui.getResourceView().addGlossary(this.g);
                if (!this.g.isReadOnly()) {
                    this.this$0.topui.getResourceView().setDefaultResource(this.g);
                }
                this.g.checkTrialVersionLimit(false);
                this.this$0.countDownLatch();
            }
        };
        worker.start();
    }

    private void prepareImageResource(final ResourceInfo ri) {
        MySwingWorker worker = new MySwingWorker(this){
            ImageResource ir;
            final /* synthetic */ ResourceLoader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.ir = new ImageResource(ri);
                return null;
            }

            @Override
            public void finished() {
                this.ir.setMainView(this.this$0.topui);
                this.this$0.topui.getResourceView().setDefaultResource(this.ir);
                this.this$0.countDownLatch();
            }
        };
        worker.start();
    }

    public void prepareImageResource(String s) {
        ImageResource resource = new ImageResource(s);
        resource.setMainView(this.topui);
        this.topui.getResourceView().setDefaultResource(resource);
    }

    public void prepareVideoResource(File file) {
        VideoResourceFX resource = new VideoResourceFX(file, null);
        resource.setMainView(this.topui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void prepareWebResource(ResourceInfo ri) {
        DefaultResource wr = null;
        try {
            if (AppPreferences.isJavaFXReady()) {
                wr = new WebResourceFX(ri);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (wr == null) {
                wr = new WebResource(ri);
            }
        }
        if (AppPreferences.sws && this.isExterenalBrowserTabOpened()) {
            WebResource wrr;
            if (wr instanceof WebResourceFX) {
                DefaultResource wrr2 = wr;
                if (((WebResourceFX)wrr2).hasExternalBrowser()) {
                    ((WebResourceFX)wrr2).setTransparentTab(false);
                }
            } else if (wr instanceof WebResource && (wrr = (WebResource)wr).hasExternalBrowser()) {
                wrr.setTabbedView(false);
            }
        }
        ((Resource)wr).setMainView(this.topui);
        this.topui.getResourceView().addWebResource(wr);
        this.topui.getResourceView().setDefaultResource(wr);
        this.countDownLatch();
    }

    private synchronized void prepareWebResourceMacOS(ResourceInfo ri) {
        WebResourceFX wr = new WebResourceFX(ri);
        if (AppPreferences.sws && this.isExterenalBrowserTabOpened()) {
            WebResource wrr;
            if (wr instanceof WebResourceFX) {
                WebResourceFX wrr2 = wr;
                if (wrr2.hasExternalBrowser()) {
                    wrr2.setTransparentTab(false);
                }
            } else if (wr instanceof WebResource && (wrr = (WebResource)((Object)wr)).hasExternalBrowser()) {
                wrr.setTabbedView(false);
            }
        }
        this.topui.getResourceView().addWebResource(wr);
        this.topui.getResourceView().setDefaultResource(wr);
        this.countDownLatch();
        ((Resource)wr).setMainView(this.topui);
    }

    private void prepareWebResourceMacOSPrev(final ResourceInfo ri) {
        SwingWorker worker = new SwingWorker(this){
            Resource wr = null;
            final /* synthetic */ ResourceLoader this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                try {
                    if (AppPreferences.isJavaFXReady()) {
                        this.wr = new WebResourceFX(ri);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (this.wr == null) {
                        this.wr = new WebResource(ri);
                    }
                }
                if (AppPreferences.sws && this.this$0.isExterenalBrowserTabOpened()) {
                    WebResource wrr;
                    if (this.wr instanceof WebResourceFX) {
                        WebResourceFX wrr2 = (WebResourceFX)this.wr;
                        if (wrr2.hasExternalBrowser()) {
                            wrr2.setTransparentTab(false);
                        }
                    } else if (this.wr instanceof WebResource && (wrr = (WebResource)this.wr).hasExternalBrowser()) {
                        wrr.setTabbedView(false);
                    }
                }
                this.wr.setMainView(this.this$0.topui);
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.getResourceView().addWebResource(this.wr);
                this.this$0.topui.getResourceView().setDefaultResource(this.wr);
                this.this$0.countDownLatch();
            }
        };
        worker.execute();
    }

    public synchronized void prepareWebResource(final String url, final String name, final boolean externalBrowser, final boolean inFrame, final int realTimePreview) {
        boolean b;
        if (name != null && (b = this.topui.getTabView().tabExists(name))) {
            this.topui.getTabView().selectTab(name);
            return;
        }
        SwingWorker worker = new SwingWorker(this){
            Resource wr = null;
            final /* synthetic */ ResourceLoader this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                try {
                    if (AppPreferences.isJavaFXReady()) {
                        this.wr = new WebResourceFX(url, name, externalBrowser, inFrame, realTimePreview);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (this.wr == null) {
                        this.wr = new WebResource(url);
                    }
                }
                if (AppPreferences.sws && this.this$0.isExterenalBrowserTabOpened()) {
                    WebResource wrr;
                    if (this.wr instanceof WebResourceFX) {
                        WebResourceFX wrr2 = (WebResourceFX)this.wr;
                        if (wrr2.hasExternalBrowser()) {
                            wrr2.setTransparentTab(false);
                        }
                    } else if (this.wr instanceof WebResource && (wrr = (WebResource)this.wr).hasExternalBrowser()) {
                        wrr.setTabbedView(false);
                    }
                }
                this.wr.setMainView(this.this$0.topui);
                return null;
            }

            @Override
            protected void done() {
                if (realTimePreview == 0 && url != null && url.length() > 0) {
                    ProjectView pro = this.this$0.topui.getProjectView();
                    pro.setReference(url, "Source Preview");
                    this.this$0.countDownLatch();
                }
                this.this$0.topui.getResourceView().addWebResource(this.wr);
                this.this$0.topui.getResourceView().setDefaultResource(this.wr);
            }
        };
        worker.execute();
    }

    private boolean isExterenalBrowserTabOpened() {
        boolean b = false;
        List webresources = this.topui.getResourceView().getWebResources();
        if (webresources != null) {
            for (int i = 0; i < webresources.size(); ++i) {
                DefaultResource wr;
                Object object = webresources.get(i);
                if (object instanceof WebResourceFX) {
                    wr = (WebResourceFX)object;
                    if (!((WebResourceFX)wr).hasExternalBrowser() || !((WebResourceFX)wr).hasTransparentTab()) continue;
                    b = true;
                    break;
                }
                if (!(object instanceof WebResource) || !((WebResource)(wr = (WebResource)object)).hasExternalBrowser() || !((WebResource)wr).hasTabbedView()) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    private void prepareJavaResource(final ResourceInfo ri) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ ResourceLoader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    File file;
                    String jclassPath = ri.getClassPath();
                    URL[] urls = null;
                    if (jclassPath != null) {
                        File file2;
                        int i;
                        File dir = new File(jclassPath);
                        if (dir.isDirectory()) {
                            File[] files = dir.listFiles();
                            urls = new URL[files.length + 1];
                            for (i = 0; i < files.length; ++i) {
                                file2 = files[i];
                                urls[i] = file2.toURI().toURL();
                            }
                        } else {
                            String[] cp = jclassPath.split(System.getProperty("path.separator"));
                            if (cp != null) {
                                urls = new URL[cp.length + 1];
                                for (i = 0; i < cp.length; ++i) {
                                    file2 = new File(cp[i]);
                                    urls[i] = file2.toURI().toURL();
                                }
                            }
                        }
                    }
                    String classPath = ri.getResourcePath();
                    if (urls == null) {
                        urls = new URL[1];
                    }
                    urls[urls.length - 1] = (file = new File(classPath)).exists() ? file.toURI().toURL() : new URL(classPath);
                    URLClassLoader loader = new URLClassLoader(urls);
                    String className = ri.getName();
                    Class<?> c = loader.loadClass(className);
                    Object o = c.newInstance();
                    if (o instanceof Resource) {
                        Resource res = (Resource)o;
                        res.setMainView(this.this$0.topui);
                        if (o instanceof Spellcheckable) {
                            Spellcheckable spellcheckable = (Spellcheckable)o;
                            this.this$0.topui.getResourceView().setSpellcheckable(spellcheckable);
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.this$0.topui, "The library is not a CafeTran resource!");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.this$0.topui, e.toString());
                }
            }
        });
    }

    public boolean isStartupLoading() {
        return this.startUpLoading;
    }

    public void setStartupLoading(boolean b) {
        this.startUpLoading = b;
        if (!this.startUpLoading) {
            this.lookup = true;
        }
    }

    public void countDownLatch() {
        if (this.startLatch != null) {
            this.startLatch.countDown();
            long c = this.startLatch.getCount();
            if (c == 0L) {
                this.startLatch = null;
                this.finishLoadingResources();
            }
        }
    }

    public void finishLoadingResources() {
        this.startUpLoading = false;
        this.topui.setUIState();
        if (this.lookup) {
            int i;
            Project p;
            boolean preStarted;
            XLIFF xliff;
            this.lookup = false;
            Project project = this.topui.getProjectView().getProject();
            if (project != null && (xliff = project.getXLIFF()) != null && !(preStarted = xliff.getWorkflow().pretransationStarted())) {
                xliff.getWorkflow().pretranslateInMemories();
            }
            boolean resetTU = false;
            if (Placeables.getPlaceablesSetHidden().size() > 0 && (p = this.topui.getProjectView().getProject()) != null && (i = p.getCurrenTUIndex()) != -1) {
                p.edit("#" + Integer.toString(i));
                resetTU = true;
            }
            Workflow wf = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
            if (!resetTU && wf != null) {
                wf.lookUpSegment();
            }
        }
        this.topui.savePrefs(false);
    }
}

