/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import translator.AppPreferences;
import translator.KeyPreferences;
import translator.MainView;
import translator.Project;
import translator.Resource;
import translator.XMLHelper;
import translator.text.SegmentEditorKit;
import translator.tmx.TMXView;
import translator.ui.GridPanel;
import translator.ui.UITools;

final class SearchOptions
extends JDialog
implements ActionListener {
    private JButton jb1;
    private JButton findButton;
    private JRadioButton regexBox;
    private JCheckBox regexBoxExtract;
    private JRadioButton wildcardsBox;
    private JCheckBox caseBox;
    private JCheckBox wholeWordsBox;
    private JRadioButton prefixBox;
    private JComboBox comboMatchAccuracy;
    private JCheckBox numbersBox;
    private JCheckBox multiFilterBox;
    private JCheckBox includeProjectSegmentsSearch;
    private JCheckBox preserveCaseBox;
    private JCheckBox filterBox;
    private JTextPane sourceArea;
    private JTextPane targetArea;
    private MainView parent;
    private ButtonGroup searchGroup = new ButtonGroup();
    private JComboBox historyCombo;
    private boolean fireSelection = true;

    SearchOptions(MainView frame, String title, boolean modal) {
        super(frame, title, modal);
        this.parent = frame;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
            this.sourceArea.requestFocusInWindow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.historyCombo = new JComboBox();
        this.historyCombo.setPreferredSize(new Dimension(400, this.historyCombo.getPreferredSize().height));
        this.historyCombo.setMaximumSize(new Dimension(400, this.historyCombo.getPreferredSize().height));
        JComboBox box = this.parent.getResourceView().getLookUpBox();
        int count = box.getItemCount();
        for (int i = 0; i < count; ++i) {
            String item = box.getItemAt(i).toString();
            this.historyCombo.addItem(item);
        }
        ButtonGroup bgroup = new ButtonGroup();
        this.regexBox = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REGULAR EXPRESSION"));
        this.regexBox.setOpaque(false);
        this.regexBoxExtract = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXTRACT REG. EXP. RESULTS"));
        this.regexBoxExtract.setOpaque(false);
        this.wildcardsBox = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEARCH OPERATORS") + " (|+)");
        this.wildcardsBox.setOpaque(false);
        this.caseBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MATCH CASE"));
        this.caseBox.setOpaque(false);
        this.preserveCaseBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRESERVE CASE WITH REPLACEMENT"));
        this.preserveCaseBox.setOpaque(false);
        this.wholeWordsBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WHOLE WORDS"));
        this.wholeWordsBox.setOpaque(false);
        this.numbersBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENT NUMBERS"));
        this.numbersBox.setOpaque(false);
        this.multiFilterBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MULTIPLE FILTER"));
        this.multiFilterBox.setOpaque(false);
        this.prefixBox = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREFIX MATCH") + " (%):");
        this.prefixBox.setOpaque(false);
        Object[] matchAccuracy = new Object[]{10, 20, 30, 40, 50, 60, 70, 80, 90};
        this.comboMatchAccuracy = new JComboBox<Object>(matchAccuracy);
        this.comboMatchAccuracy.setPreferredSize(new Dimension(100, this.comboMatchAccuracy.getPreferredSize().height));
        this.comboMatchAccuracy.setMaximumSize(new Dimension(100, this.comboMatchAccuracy.getPreferredSize().height));
        this.comboMatchAccuracy.setOpaque(false);
        this.filterBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTS FILTER"));
        this.filterBox.setOpaque(false);
        this.filterBox.setSelected(this.parent.isSegmentsFilterSet());
        this.wildcardsBox.setSelected(true);
        if (AppPreferences.searchCase) {
            this.caseBox.setSelected(true);
        }
        this.preserveCaseBox.setSelected(AppPreferences.preserveCaseWithReplacement);
        if (AppPreferences.searchWholewords) {
            this.wholeWordsBox.setSelected(true);
        }
        if (AppPreferences.searchSegmentNumbers) {
            this.numbersBox.setSelected(true);
        }
        if (AppPreferences.searchMultiFilter) {
            this.multiFilterBox.setSelected(true);
        }
        this.comboMatchAccuracy.setSelectedItem(AppPreferences.searchTermAccuracy);
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb1.addActionListener(this);
        this.findButton = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND"));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o;
                SearchOptions.this.setOptions();
                String s = SearchOptions.this.sourceArea.getText();
                if (s.length() == 0 && (o = SearchOptions.this.historyCombo.getSelectedItem()) != null) {
                    s = o.toString();
                }
                if (s.length() > 0) {
                    Resource res = SearchOptions.this.parent.getActiveResource();
                    if (res == null) {
                        res = SearchOptions.this.parent.getTabView().getCurrentResource();
                    }
                    SearchOptions.this.parent.getResourceView().getLookUpBox().removeItem(s);
                    SearchOptions.this.parent.getResourceView().lookUpResource(s, null, res);
                    SearchOptions.this.parent.getResourceView().getLookUpBox().setSelectedIndex(0);
                    SearchOptions.this.fireSelection = false;
                    SearchOptions.this.historyCombo.removeItem(s);
                    SearchOptions.this.setSearchBoxText(s);
                    SearchOptions.this.historyCombo.setSelectedIndex(0);
                    SearchOptions.this.fireSelection = true;
                }
            }
        });
        JButton replaceButton = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE ALL"));
        replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchOptions.this.setOptions();
                String s = SearchOptions.this.sourceArea.getText();
                String r = SearchOptions.this.targetArea.getText();
                if (s.length() > 0) {
                    Resource res = SearchOptions.this.parent.getActiveResource();
                    if (res == null) {
                        res = SearchOptions.this.parent.getTabView().getCurrentResource();
                    }
                    SearchOptions.this.parent.getResourceView().lookUpResource(s, r, res);
                    SearchOptions.this.parent.getResourceView().getLookUpBox().setSelectedIndex(0);
                    SearchOptions.this.setSearchBoxText(s);
                    SearchOptions.this.fireSelection = false;
                    SearchOptions.this.historyCombo.setSelectedIndex(0);
                    SearchOptions.this.fireSelection = true;
                }
            }
        });
        JButton replaceEditButton = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE AND EDIT"));
        replaceEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchOptions.this.setOptions();
                if (AppPreferences.findMode != 4 && AppPreferences.findMode != 5) {
                    SearchOptions.this.parent.getResourceView().setFindMode(5);
                    AppPreferences.findMode = 5;
                }
                AppPreferences.replaceAndEdit = true;
                SearchOptions.this.parent.setSegmentsFilter();
                String s = SearchOptions.this.sourceArea.getText();
                String r = SearchOptions.this.targetArea.getText();
                if (s.length() > 0) {
                    Resource res = SearchOptions.this.parent.getActiveResource();
                    if (res == null) {
                        res = SearchOptions.this.parent.getTabView().getCurrentResource();
                    }
                    SearchOptions.this.parent.getResourceView().lookUpResource(s, r, res);
                    SearchOptions.this.parent.getResourceView().getLookUpBox().setSelectedIndex(0);
                    SearchOptions.this.setSearchBoxText(s);
                    SearchOptions.this.fireSelection = false;
                    SearchOptions.this.historyCombo.setSelectedIndex(0);
                    SearchOptions.this.fireSelection = true;
                    SearchOptions.this.cancel();
                }
            }
        });
        JButton buttonMove = new JButton("Transfer");
        buttonMove.setMnemonic(155);
        buttonMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = SearchOptions.this.sourceArea.getSelectedText();
                if (s == null) {
                    s = SearchOptions.this.sourceArea.getText();
                }
                SearchOptions.this.targetArea.setText(s);
                SearchOptions.this.targetArea.requestFocusInWindow();
            }
        });
        GridPanel content = new GridPanel();
        content.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        content.setLayout(new BorderLayout());
        this.setContentPane(content);
        JPanel panel1 = new JPanel();
        panel1.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPTIONS")));
        panel1.setOpaque(false);
        panel1.setLayout(new SpringLayout());
        bgroup.add(this.wildcardsBox);
        bgroup.add(this.regexBox);
        bgroup.add(this.prefixBox);
        panel1.add(this.filterBox);
        panel1.add(this.wholeWordsBox);
        panel1.add(this.caseBox);
        panel1.add(this.preserveCaseBox);
        panel1.add(this.regexBoxExtract);
        panel1.add(this.numbersBox);
        panel1.add(this.multiFilterBox);
        panel1.add(this.wildcardsBox);
        panel1.add(this.regexBox);
        panel1.add(this.prefixBox);
        panel1.add(this.comboMatchAccuracy);
        this.setResizable(false);
        this.sourceArea = new JTextPane();
        this.sourceArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchOptions.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.sourceArea.setEditorKit(new SegmentEditorKit());
        this.sourceArea.setFont(new Font(AppPreferences.fontname, 0, AppPreferences.fontsize));
        if (AppPreferences.linuxGTK) {
            this.sourceArea.setCaretColor(this.sourceArea.getForeground());
        } else if (AppPreferences.background != 0) {
            Color background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            this.sourceArea.setCaretColor(foreground);
            this.sourceArea.setBackground(background);
            this.sourceArea.setForeground(foreground);
        }
        this.sourceArea.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane jScrollPane1 = new JScrollPane(this.sourceArea);
        jScrollPane1.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FIND")));
        jScrollPane1.setPreferredSize(new Dimension(500, 125));
        this.setTextForSearch();
        this.targetArea = new JTextPane();
        this.targetArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchOptions.this.parent.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.targetArea.setEditorKit(new SegmentEditorKit());
        this.targetArea.setFont(new Font(AppPreferences.fontname, 0, AppPreferences.fontsize));
        if (AppPreferences.linuxGTK) {
            this.targetArea.setCaretColor(this.targetArea.getForeground());
        } else if (AppPreferences.background != 0) {
            Color background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            this.targetArea.setCaretColor(foreground);
            this.targetArea.setBackground(background);
            this.targetArea.setForeground(foreground);
        }
        this.targetArea.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane jScrollPane2 = new JScrollPane(this.targetArea);
        jScrollPane2.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPLACE")));
        jScrollPane2.setPreferredSize(new Dimension(500, 125));
        JPanel panel3 = new JPanel();
        panel3.setBorder(new EmptyBorder(new Insets(0, 10, 0, 10)));
        panel3.setOpaque(false);
        panel3.setLayout(new GridLayout(2, 1, 5, 5));
        panel3.add(jScrollPane1);
        panel3.add(jScrollPane2);
        StyledDocument sdoc = this.sourceArea.getStyledDocument();
        StyledDocument tdoc = this.targetArea.getStyledDocument();
        if (AppPreferences.invisibles) {
            sdoc.putProperty("invisibles", true);
            tdoc.putProperty("invisibles", true);
        } else {
            sdoc.putProperty("invisibles", null);
            tdoc.putProperty("invisibles", null);
        }
        this.historyCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1 && SearchOptions.this.fireSelection) {
                    String s = (String)ie.getItem();
                    SearchOptions.this.sourceArea.setText(s);
                }
            }
        });
        JPanel panel4 = new JPanel();
        panel4.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DEFAULT SCOPE")));
        panel4.setLayout(new SpringLayout());
        panel4.setOpaque(false);
        int mode = this.parent.getResourceView().getFindMode();
        JRadioButton ressearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RESOURCES"));
        ressearch.setOpaque(false);
        if (mode == 0) {
            ressearch.setSelected(true);
        }
        JRadioButton docsearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT"));
        docsearch.setOpaque(false);
        if (mode == 1) {
            docsearch.setSelected(true);
        }
        JRadioButton proSourceSearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT SOURCE"));
        proSourceSearch.setOpaque(false);
        if (mode == 4) {
            proSourceSearch.setSelected(true);
        }
        JRadioButton proTargetSearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROJECT TARGET"));
        proTargetSearch.setOpaque(false);
        if (mode == 5) {
            proTargetSearch.setSelected(true);
        }
        JRadioButton memSourceSearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY SOURCE"));
        memSourceSearch.setOpaque(false);
        if (mode == 2) {
            memSourceSearch.setSelected(true);
        }
        JRadioButton memTargetSearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY TARGET"));
        memTargetSearch.setOpaque(false);
        if (mode == 3) {
            memTargetSearch.setSelected(true);
        }
        JRadioButton glossarySearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARIES"));
        glossarySearch.setOpaque(false);
        if (mode == -4) {
            glossarySearch.setSelected(true);
        }
        JRadioButton dbSourceSearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TOTAL RECALL SOURCE"));
        dbSourceSearch.setOpaque(false);
        if (mode == 6) {
            dbSourceSearch.setSelected(true);
        }
        JRadioButton dbTargetSearch = new JRadioButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TOTAL RECALL TARGET"));
        dbTargetSearch.setOpaque(false);
        if (mode == 7) {
            dbTargetSearch.setSelected(true);
        }
        this.includeProjectSegmentsSearch = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCLUDE PROJECT SEGMENTS"));
        this.includeProjectSegmentsSearch.setOpaque(false);
        this.includeProjectSegmentsSearch.setSelected(AppPreferences.includeProjectSegmentsSearch);
        this.searchGroup.add(ressearch);
        this.searchGroup.add(docsearch);
        this.searchGroup.add(proSourceSearch);
        this.searchGroup.add(proTargetSearch);
        this.searchGroup.add(memSourceSearch);
        this.searchGroup.add(memTargetSearch);
        this.searchGroup.add(glossarySearch);
        this.searchGroup.add(dbSourceSearch);
        this.searchGroup.add(dbTargetSearch);
        panel4.add(ressearch);
        panel4.add(proSourceSearch);
        panel4.add(proTargetSearch);
        panel4.add(memSourceSearch);
        panel4.add(memTargetSearch);
        panel4.add(glossarySearch);
        panel4.add(dbSourceSearch);
        panel4.add(dbTargetSearch);
        panel4.add(docsearch);
        panel4.add(this.includeProjectSegmentsSearch);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout(1));
        panel5.setOpaque(false);
        panel5.setBorder(new EmptyBorder(new Insets(0, 0, 5, 0)));
        panel5.add(replaceEditButton);
        panel5.add(replaceButton);
        panel5.add(this.historyCombo);
        panel5.add(this.findButton);
        panel5.add(buttonMove);
        panel5.add(this.jb1);
        UITools.makeCompactGrid(panel1, 11, 1, 6, 6, 6, 6);
        UITools.makeCompactGrid(panel4, 10, 1, 6, 6, 6, 6);
        content.add((Component)panel1, "West");
        content.add((Component)panel3, "Center");
        content.add((Component)panel4, "East");
        content.add((Component)panel5, "North");
        content.getActionMap().put("TITLECASE", new AbstractAction("TITLECASE"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent tc = SearchOptions.this.parent.getFocusedTextComponent();
                SearchOptions.this.parent.getResourceView().cycleCase(tc, 2);
            }
        });
        content.getActionMap().put("CYCLECASE", new AbstractAction("CYCLECASE"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent tc = SearchOptions.this.parent.getFocusedTextComponent();
                SearchOptions.this.parent.getResourceView().cycleCase(tc, 1);
            }
        });
        content.getActionMap().put("CYCLEFOCUS", new AbstractAction("CYCLEFOCUS"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!SearchOptions.this.targetArea.isFocusOwner()) {
                    SearchOptions.this.targetArea.requestFocusInWindow();
                } else {
                    SearchOptions.this.sourceArea.requestFocusInWindow();
                }
            }
        });
        content.getActionMap().put("REQUESTFOCUS", new AbstractAction("REQUESTFOCUS"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchOptions.this.targetArea.requestFocusInWindow();
            }
        });
        content.getActionMap().put("TRANSPOSE LEFT", new AbstractAction("TRANSPOSE LEFT"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent tc = SearchOptions.this.parent.getFocusedTextComponent();
                SearchOptions.this.parent.getTargetView().transposeWords(false, tc);
            }
        });
        content.getActionMap().put("TRANSPOSE RIGHT", new AbstractAction("TRANSPOSE RIGHT"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextComponent tc = SearchOptions.this.parent.getFocusedTextComponent();
                SearchOptions.this.parent.getTargetView().transposeWords(true, tc);
            }
        });
        content.getActionMap().put("FIND", new AbstractAction("FIND"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchOptions.this.findButton.doClick();
            }
        });
        content.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchOptions.this.cancel();
            }
        });
        KeyStroke ks = KeyPreferences.getKeyStroke("k38");
        content.getInputMap(1).put(ks, "TITLECASE");
        ks = KeyPreferences.getKeyStroke("k39");
        content.getInputMap(1).put(ks, "CYCLECASE");
        ks = KeyPreferences.getKeyStroke("k80");
        content.getInputMap(1).put(ks, "CYCLEFOCUS");
        ks = KeyPreferences.getKeyStroke("k89");
        content.getInputMap(1).put(ks, "REQUESTFOCUS");
        ks = KeyPreferences.getKeyStroke("k45");
        content.getInputMap(1).put(ks, "TRANSPOSE LEFT");
        ks = KeyPreferences.getKeyStroke("k44");
        content.getInputMap(1).put(ks, "TRANSPOSE RIGHT");
        ks = KeyPreferences.getKeyStroke("k106");
        content.getInputMap(1).put(ks, "FIND");
        content.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        if (AppPreferences.cycleFocusTabKey) {
            this.parent.setTabAsFocusTraversalKey(this.sourceArea, this.targetArea, AppPreferences.cycleFocusTabKey);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        AppPreferences.posXFind = this.getLocation().x;
        AppPreferences.posYFind = this.getLocation().y;
        Project project = this.parent.getProjectView().getProject();
        if (project != null && project.getTMX() == null && TMXView.getFilteredUnits() != null) {
            TMXView.setFilteredWorkflow(false);
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb1) {
            this.setOptions();
            this.cancel();
        }
    }

    private void setOptions() {
        if (this.prefixBox.isSelected()) {
            AppPreferences.searchType = 2;
        } else if (this.wildcardsBox.isSelected()) {
            AppPreferences.searchType = 1;
        } else if (this.regexBox.isSelected()) {
            AppPreferences.searchType = 0;
        }
        AppPreferences.searchExtractRegExp = this.regexBoxExtract.isSelected();
        AppPreferences.searchMultiFilter = this.multiFilterBox.isSelected();
        AppPreferences.searchCase = this.caseBox.isSelected();
        AppPreferences.preserveCaseWithReplacement = this.preserveCaseBox.isSelected();
        AppPreferences.searchWholewords = this.wholeWordsBox.isSelected();
        AppPreferences.searchSegmentNumbers = this.numbersBox.isSelected();
        AppPreferences.searchTermAccuracy = (Integer)this.comboMatchAccuracy.getSelectedItem();
        AppPreferences.includeProjectSegmentsSearch = this.includeProjectSegmentsSearch.isSelected();
        this.setFindMode();
        this.setFilter();
    }

    private void setFilter() {
        if (this.filterBox.isSelected()) {
            if (AppPreferences.findMode == 2 || AppPreferences.findMode == 3) {
                TMXView.setFilteredWorkflow(true);
            } else {
                this.parent.setSegmentsFilter();
            }
        } else if (AppPreferences.findMode == 2 || AppPreferences.findMode == 3) {
            TMXView.setFilteredWorkflow(false);
        } else {
            this.parent.resetSegmentsFilter();
        }
    }

    private void setFindMode() {
        Enumeration<AbstractButton> e = this.searchGroup.getElements();
        int i = 0;
        while (e.hasMoreElements()) {
            JRadioButton box = (JRadioButton)e.nextElement();
            if (box.isSelected()) {
                if (i == 0) {
                    this.parent.getResourceView().setFindMode(0);
                    AppPreferences.findMode = 0;
                    break;
                }
                if (i == 1) {
                    this.parent.getResourceView().setFindMode(1);
                    AppPreferences.findMode = 1;
                    break;
                }
                if (i == 2) {
                    this.parent.getResourceView().setFindMode(4);
                    AppPreferences.findMode = 4;
                    break;
                }
                if (i == 3) {
                    this.parent.getResourceView().setFindMode(5);
                    AppPreferences.findMode = 5;
                    break;
                }
                if (i == 4) {
                    this.parent.getResourceView().setFindMode(2);
                    AppPreferences.findMode = 2;
                    break;
                }
                if (i == 5) {
                    this.parent.getResourceView().setFindMode(3);
                    AppPreferences.findMode = 3;
                    break;
                }
                if (i == 6) {
                    this.parent.getResourceView().setFindMode(-4);
                    AppPreferences.findMode = -4;
                    break;
                }
                if (i == 7) {
                    this.parent.getResourceView().setFindMode(6);
                    AppPreferences.findMode = 6;
                    break;
                }
                if (i != 8) break;
                this.parent.getResourceView().setFindMode(7);
                AppPreferences.findMode = 7;
                break;
            }
            ++i;
        }
    }

    private void setSearchBoxText(String s) {
        boolean add = true;
        int c = this.historyCombo.getItemCount();
        for (int i = 0; i < c; ++i) {
            Object object = this.historyCombo.getItemAt(i);
            if (object == null || !object.toString().equals(s)) continue;
            add = false;
            break;
        }
        if (add) {
            this.historyCombo.insertItemAt(s, 0);
            if (c > 9) {
                this.historyCombo.removeItemAt(c);
            }
        }
    }

    void setTextForSearch() {
        this.sourceArea.requestFocusInWindow();
        String s = this.parent.getTargetPane().getSelectedText();
        if (s != null) {
            s = XMLHelper.parseTags(s);
            this.sourceArea.setText(s);
            this.sourceArea.setSelectionStart(0);
            this.sourceArea.setSelectionEnd(s.length());
            this.setSearchBoxText(s);
            this.historyCombo.setSelectedIndex(0);
        } else {
            s = this.parent.getSourcePane().getSelectedText();
            if (s != null) {
                s = XMLHelper.parseTags(s);
                this.sourceArea.setText(s);
                this.sourceArea.setSelectionStart(0);
                this.sourceArea.setSelectionEnd(s.length());
                this.setSearchBoxText(s);
                this.historyCombo.setSelectedIndex(0);
            } else {
                s = this.sourceArea.getText();
                if (s != null && s.length() > 0) {
                    this.sourceArea.setText(s);
                    this.sourceArea.setSelectionStart(0);
                    this.sourceArea.setSelectionEnd(s.length());
                }
            }
        }
    }
}

