/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.SRXHandler;
import translator.XMLElement;

public class Segmentation
extends DefaultXMLElement {
    public static String sentenceSeg = "\\.\\s+|\\!\\s+|\\?\\s+|\\s{2,}|\\p{Punct}\\z|\\z|\u3002";
    public static String paragraphSeg = "\r\n{1,}|\r{1,}|\n{1,}|\\z";
    public static String wordSeg = "\\b\\s+|\\b\\p{Punct}\\s+|\\z";
    public static String docSeg = "\\z";
    public static String tagSeg = "(>\\s+<[/]*)|(</)|[<>]";
    private String filterSegmentation;
    private String name;
    static String path = AppPreferences.packagePath + "rules" + AppPreferences.fs + "segmentation";
    private String language;
    private String languageCode;
    private long lastModified;
    private List yesRules = new ArrayList();
    private List noRules = new ArrayList();
    private List langs = new ArrayList();

    public Segmentation(MainView topui, String fname) {
        boolean success = this.load(fname);
        if (success) {
            this.setLanguage(AppPreferences.fileSLang);
            this.getRules("Default");
            if (this.language != null && !this.language.equalsIgnoreCase("Default")) {
                this.getRules(this.language);
            }
        }
    }

    public boolean segmenationChanged() {
        if (this.name == null) {
            return false;
        }
        File file = new File(path + AppPreferences.fs + this.name);
        if (!file.exists()) {
            return false;
        }
        long modified = file.lastModified();
        return modified != this.lastModified;
    }

    public void setFilterSegmenation(String seg) {
        this.filterSegmentation = seg;
    }

    public String getFilterSegmentation() {
        return this.filterSegmentation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List getLangs() {
        return this.langs;
    }

    public String getLanguageName() {
        return this.language;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageRules(String lname) {
        this.language = lname;
        this.yesRules.clear();
        this.noRules.clear();
        this.getRules("Default");
        if (this.language != null && !this.language.equalsIgnoreCase("Default")) {
            this.getRules(this.language);
        }
    }

    public void setLanguagePattern(String lang) {
        this.yesRules.clear();
        this.noRules.clear();
        this.setLanguage(lang);
        this.getRules("Default");
        if (this.language != null && !this.language.equalsIgnoreCase("Default")) {
            this.getRules(this.language);
        }
    }

    private void setLanguage(String lang) {
        XMLElement elem2;
        this.langs.clear();
        boolean langSet = false;
        List list = this.getChildren("srx");
        if (list != null && list.size() > 0 && (list = (elem2 = (XMLElement)list.get(0)).getChildren("body")) != null && list.size() > 0 && (list = (elem2 = (XMLElement)list.get(0)).getChildren("maprules")) != null && list.size() > 0 && (list = (elem2 = (XMLElement)list.get(0)).getChildren("languagemap")) != null) {
            for (XMLElement elem2 : list) {
                Pattern pat;
                Matcher mat;
                String la;
                String attr = elem2.getAttribute("languagepattern");
                if (attr == null || (la = elem2.getAttribute("languagerulename")) == null) continue;
                if (!langSet && (mat = (pat = Pattern.compile(attr, 2)).matcher(lang)).matches()) {
                    this.language = la;
                    this.languageCode = lang;
                    langSet = true;
                }
                this.langs.add(la);
            }
        }
    }

    public List getYesRules() {
        return this.yesRules;
    }

    public List getNoRules() {
        return this.noRules;
    }

    private void getRules(String lang) {
        XMLElement elem22;
        List list = this.getChildren("srx");
        if (list != null && list.size() > 0 && (list = (elem22 = (XMLElement)list.get(0)).getChildren("body")) != null && (list = (elem22 = (XMLElement)list.get(0)).getChildren("languagerules")) != null && (list = (elem22 = (XMLElement)list.get(0)).getChildren("languagerule")) != null) {
            for (XMLElement elem22 : list) {
                String attr = elem22.getAttribute("languagerulename");
                if (attr == null || !attr.equalsIgnoreCase(lang) || (list = elem22.getChildren("rule")) == null) continue;
                for (XMLElement elem22 : list) {
                    XMLElement aelem;
                    XMLElement belem;
                    Object o;
                    String r;
                    attr = elem22.getAttribute("break");
                    if (attr == null || attr.equals("yes")) {
                        r = "";
                        list = elem22.getChildren("beforebreak");
                        if (list != null && list.size() > 0 && (o = (belem = (XMLElement)list.get(0)).getContent(0)) != null) {
                            r = r + o.toString();
                        }
                        if ((list = elem22.getChildren("afterbreak")) != null && list.size() > 0 && (o = (aelem = (XMLElement)list.get(0)).getContent(0)) != null) {
                            r = r + o.toString();
                        }
                        if (r.length() <= 0) continue;
                        this.yesRules.add(r);
                        continue;
                    }
                    if (!attr.equals("no")) continue;
                    r = "";
                    list = elem22.getChildren("beforebreak");
                    if (list != null && list.size() > 0 && (o = (belem = (XMLElement)list.get(0)).getContent(0)) != null) {
                        r = r + o.toString();
                    }
                    if ((list = elem22.getChildren("afterbreak")) != null && list.size() > 0 && (o = (aelem = (XMLElement)list.get(0)).getContent(0)) != null) {
                        r = r + o.toString();
                    }
                    if (r.length() <= 0) continue;
                    this.noRules.add(r);
                }
            }
        }
    }

    private boolean loadRules(String name) {
        try {
            File file = new File(path + AppPreferences.fs + name);
            if (!file.exists()) {
                return false;
            }
            this.lastModified = file.lastModified();
            this.name = file.getName();
            SRXHandler handler = new SRXHandler(this);
            FileInputStream fis = new FileInputStream(file);
            InputSource is = new InputSource(fis);
            is.setSystemId("file:" + AppPreferences.packagePath);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
            return true;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void saveRules() {
        try {
            File file = new File(path + AppPreferences.fs + this.name);
            File tempFile = File.createTempFile("old", null, file.getParentFile());
            FileOutputStream fout = new FileOutputStream(tempFile);
            this.store(fout);
            fout.close();
            if (file.exists()) {
                file.delete();
            }
            if (!tempFile.renameTo(file)) {
                throw new IOException();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void store(FileOutputStream out) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        awriter.write("<?xml version=\"1.0\"?>");
        List list = this.getChildren("srx");
        if (list != null) {
            XMLElement elem = (XMLElement)list.get(0);
            String s = elem.getXMLFormat();
            awriter.write(s);
        }
        awriter.close();
    }

    public final boolean load(String fname) {
        boolean success = false;
        success = fname != null && fname.endsWith("srx") ? this.loadRules(fname) : this.loadRules("Default.srx");
        return success;
    }
}

