/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.XMLElement;
import translator.ui.UITools;

public class SegmentationEditor
extends JDialog
implements ActionListener {
    private MainView owner;
    private JPanel elementsPanel;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton jButton0;
    private JButton jButton2;
    private JButton jButton3;
    private JTextPane jtextArea;
    private LinkedHashMap attr;
    private int status = -1;
    private JPanel jPanel5;
    private XMLElement parentXML;
    private StringBuffer stringXML;
    XMLElement defLangRule;
    XMLElement defLangMap;

    public SegmentationEditor(MainView owner, Object xmle) {
        super(owner, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTATION EDITOR"), true);
        XMLElement exml;
        String n;
        this.setResizable(false);
        this.owner = owner;
        this.jPanel3 = new JPanel();
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridLayout(1, 3, 5, 3));
        this.jPanel3.setBorder(new EmptyBorder(new Insets(5, 5, 0, 5)));
        this.jButton0 = new JButton();
        this.jButton0.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE"));
        this.jButton0.addActionListener(this);
        boolean delete = true;
        if (xmle instanceof XMLElement && ((n = (exml = (XMLElement)xmle).getName()).equals("body") || n.equals("maprules") || n.equals("languagerules"))) {
            delete = false;
        }
        JScrollPane scroll = null;
        if (xmle instanceof XMLElement) {
            this.parentXML = (XMLElement)xmle;
            List elements = this.parentXML.getChildren();
            int size = elements.size();
            if (size > 0) {
                if (this.parentXML.getName().equals("body")) {
                    List mrules = this.parentXML.getChildren("maprules");
                    List list = this.parentXML.getChildren("langrules");
                }
                this.elementsPanel = new JPanel();
                this.elementsPanel.setOpaque(false);
                this.elementsPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
                this.elementsPanel.setLayout(new GridLayout(0, 1, 5, 5));
                scroll = new JScrollPane(this.elementsPanel);
                scroll.getVerticalScrollBar().setUnitIncrement(10);
                scroll.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
                if (size > 10) {
                    scroll.setPreferredSize(new Dimension(800, 400));
                }
            }
            int count = 0;
            int rows = 0;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                final int eindex = count++;
                Object o = it.next();
                if (o instanceof XMLElement) {
                    final XMLElement elem = (XMLElement)o;
                    final String ename = elem.getName();
                    String menuName = null;
                    String att = elem.getAttribute("languagerulename");
                    if (att != null) {
                        if (att.equals("Default")) {
                            if (elem.getAttribute("languagepattern") != null) {
                                this.defLangMap = elem;
                            } else {
                                this.defLangRule = elem;
                            }
                        }
                        menuName = att;
                    } else {
                        menuName = elem.getName();
                    }
                    if (menuName.equals("rule")) {
                        String cont;
                        Object oo;
                        String br = elem.getAttribute("break");
                        if (br != null) {
                            if (br.equals("yes")) {
                                menuName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BREAK:") + "     ";
                            } else if (br.equals("no")) {
                                menuName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXCEPTION:") + "     ";
                            }
                        } else {
                            menuName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BREAK:") + "     ";
                        }
                        List list = elem.getChildren("beforebreak");
                        for (XMLElement before : list) {
                            oo = before.getContent(0);
                            if (oo == null) continue;
                            cont = oo.toString();
                            menuName = menuName + cont;
                        }
                        list = elem.getChildren("afterbreak");
                        for (XMLElement after : list) {
                            oo = after.getContent(0);
                            if (oo == null) continue;
                            cont = oo.toString();
                            menuName = menuName + cont;
                        }
                    } else if (menuName.equals("beforebreak") || menuName.equals("afterbreak")) {
                        if (this.jPanel5 == null) {
                            this.jPanel5 = new JPanel(new SpringLayout());
                            this.jPanel5.setOpaque(false);
                            this.jPanel5.setBorder(new EmptyBorder(new Insets(5, 10, 10, 10)));
                        }
                        JLabel label = new JLabel(menuName + ":");
                        label.setHorizontalAlignment(4);
                        JTextField field = new JTextField();
                        field.setPreferredSize(new Dimension(400, field.getPreferredSize().height));
                        Object oo = elem.getContent(0);
                        if (oo != null) {
                            field.setText(oo.toString());
                            field.putClientProperty("element", elem);
                        }
                        this.jPanel5.add(label);
                        this.jPanel5.add(field);
                        ++rows;
                        menuName = null;
                    }
                    if ((ename.equals("languagerule") || ename.equals("languagemap") || ename.equals("rule")) && count == 1) {
                        JButton newItem = new JButton(new AbstractAction(this, "New " + ename + "..."){
                            final /* synthetic */ SegmentationEditor this$0;
                            {
                                this.this$0 = this$0;
                                super(arg0);
                            }

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                final DefaultXMLElement nelem = new DefaultXMLElement();
                                nelem.setName(ename);
                                if (ename.equals("languagerule")) {
                                    nelem.setAttribute("languagerulename", "");
                                    DefaultXMLElement rule = new DefaultXMLElement();
                                    rule.setName("rule");
                                    rule.setAttribute("break", "no");
                                    DefaultXMLElement before = new DefaultXMLElement();
                                    before.setName("beforebreak");
                                    before.setContent(0, "");
                                    DefaultXMLElement after = new DefaultXMLElement();
                                    after.setName("afterbreak");
                                    after.setContent(0, "");
                                    rule.addChild(before);
                                    rule.addChild(after);
                                    nelem.addChild(rule);
                                } else if (ename.equals("languagemap")) {
                                    nelem.setAttribute("languagepattern", "");
                                    nelem.setAttribute("languagerulename", "");
                                } else if (ename.equals("rule")) {
                                    nelem.setAttribute("break", "no");
                                    DefaultXMLElement before = new DefaultXMLElement();
                                    before.setName("beforebreak");
                                    before.setContent(0, "");
                                    DefaultXMLElement after = new DefaultXMLElement();
                                    after.setName("afterbreak");
                                    after.setContent(0, "");
                                    nelem.addChild(before);
                                    nelem.addChild(after);
                                }
                                int st = this.this$0.showXMLElement(nelem);
                                if (st != 0 && st == 1) {
                                    if (ename.equals("languagemap")) {
                                        this.this$0.parentXML.addChild(nelem);
                                        if (this.this$0.defLangMap != null) {
                                            this.this$0.parentXML.removeChild(this.this$0.defLangMap);
                                            this.this$0.parentXML.addChild(this.this$0.defLangMap);
                                        }
                                    } else if (ename.equals("languagerule")) {
                                        this.this$0.parentXML.addChild(nelem);
                                        if (this.this$0.defLangRule != null) {
                                            this.this$0.parentXML.removeChild(this.this$0.defLangRule);
                                            this.this$0.parentXML.addChild(this.this$0.defLangRule);
                                        }
                                    } else {
                                        this.this$0.parentXML.addChild(nelem);
                                    }
                                    String menuName = null;
                                    String att = nelem.getAttribute("languagerulename");
                                    if (att == null && (att = nelem.getAttribute("break")) != null) {
                                        if (att.equals("yes")) {
                                            att = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BREAK:") + "     ";
                                        } else if (att.equals("no")) {
                                            att = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXCEPTION:") + "     ";
                                        }
                                    }
                                    menuName = att != null ? att : nelem.getName();
                                    JButton button = new JButton(new AbstractAction(this, menuName){
                                        final /* synthetic */ 1 this$1;
                                        {
                                            this.this$1 = this$1;
                                            super(arg0);
                                        }

                                        @Override
                                        public void actionPerformed(ActionEvent a) {
                                            JButton b = (JButton)a.getSource();
                                            int st = this.this$1.this$0.showXMLElement(nelem);
                                            if (st == 0) {
                                                this.this$1.this$0.parentXML.removeChild(nelem);
                                                this.this$1.this$0.elementsPanel.remove(b);
                                                this.this$1.this$0.elementsPanel.validate();
                                                this.this$1.this$0.elementsPanel.repaint();
                                            }
                                        }
                                    });
                                    button.setHorizontalAlignment(2);
                                    this.this$0.elementsPanel.add(button);
                                    this.this$0.elementsPanel.validate();
                                    this.this$0.elementsPanel.repaint();
                                }
                            }
                        });
                        this.elementsPanel.add(newItem);
                    }
                    if (menuName == null) continue;
                    if (menuName.equals("maprules")) {
                        menuName = "Language maps";
                    } else if (menuName.equals("languagerules")) {
                        menuName = "Language rules";
                    }
                    if (menuName.length() > 100) {
                        menuName = menuName.substring(0, 100) + " ...";
                    }
                    JButton button = new JButton(new AbstractAction(this, menuName){
                        final /* synthetic */ SegmentationEditor this$0;
                        {
                            this.this$0 = this$0;
                            super(arg0);
                        }

                        @Override
                        public void actionPerformed(ActionEvent a) {
                            JButton b = (JButton)a.getSource();
                            int st = this.this$0.showXMLElement(elem);
                            if (st == 0) {
                                this.this$0.parentXML.removeChild(elem);
                                this.this$0.elementsPanel.remove(b);
                                this.this$0.elementsPanel.validate();
                                this.this$0.elementsPanel.repaint();
                            } else if (st == 1) {
                                this.this$0.parentXML.setContent(eindex, elem);
                                String buttonName = elem.getName();
                                if (buttonName.equals("rule")) {
                                    String cont;
                                    Object oo;
                                    String buttonText = null;
                                    String br = elem.getAttribute("break");
                                    if (br != null) {
                                        if (br.equals("yes")) {
                                            buttonText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BREAK:") + "     ";
                                        } else if (br.equals("no")) {
                                            buttonText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXCEPTION:") + "     ";
                                        }
                                    } else {
                                        buttonText = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BREAK:") + "     ";
                                    }
                                    List list = elem.getChildren("beforebreak");
                                    for (XMLElement before : list) {
                                        oo = before.getContent(0);
                                        if (oo == null) continue;
                                        cont = oo.toString();
                                        buttonText = buttonText + cont;
                                    }
                                    list = elem.getChildren("afterbreak");
                                    for (XMLElement after : list) {
                                        oo = after.getContent(0);
                                        if (oo == null) continue;
                                        cont = oo.toString();
                                        buttonText = buttonText + cont;
                                    }
                                    if (buttonText != null) {
                                        b.setText(buttonText);
                                    }
                                }
                            }
                        }
                    });
                    button.setHorizontalAlignment(2);
                    this.elementsPanel.add(button);
                    continue;
                }
                if (!(o instanceof String)) continue;
                if (this.jPanel5 == null) {
                    this.jPanel5 = new JPanel(new SpringLayout());
                    this.jPanel5.setOpaque(false);
                    this.jPanel5.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
                }
                JLabel label = new JLabel(this.parentXML.getName() + ":");
                label.setHorizontalAlignment(4);
                JTextField field = new JTextField();
                field.setPreferredSize(new Dimension(200, 26));
                if (o != null) {
                    field.setText(o.toString());
                    field.putClientProperty("element", this.parentXML);
                }
                this.jPanel5.add(label);
                this.jPanel5.add(field);
                ++rows;
            }
            if (this.jPanel5 != null) {
                UITools.makeCompactGrid(this.jPanel5, rows, 2, 6, 6, 6, 6);
            }
            this.attr = this.parentXML.getAttributes();
            int arows = 0;
            if (this.attr != null) {
                this.jPanel1 = new JPanel(new SpringLayout());
                this.jPanel1.setOpaque(false);
                this.jPanel1.setBorder(new EmptyBorder(new Insets(5, 40, 5, 40)));
                Set keys = this.attr.keySet();
                for (String lname : keys) {
                    String value = (String)this.attr.get(lname);
                    JLabel label1 = new JLabel(lname + ":");
                    label1.setName(lname);
                    label1.setHorizontalAlignment(4);
                    this.jPanel1.add(label1);
                    if (lname.equals("break")) {
                        String[] items = new String[]{"yes", "no"};
                        JComboBox<String> box = new JComboBox<String>(items);
                        box.setSelectedItem(value);
                        this.jPanel1.add(box);
                    } else {
                        JTextField field = new JTextField(value);
                        field.setCaretPosition(0);
                        field.setMargin(new Insets(0, 2, 0, 0));
                        field.setFont(field.getFont().deriveFont(1));
                        field.setPreferredSize(new Dimension(200, field.getPreferredSize().height));
                        this.jPanel1.add(field);
                    }
                    ++arows;
                }
            }
            if (this.jPanel1 != null) {
                UITools.makeCompactGrid(this.jPanel1, arows, 2, 6, 6, 6, 6);
            }
        } else if (xmle instanceof StringBuffer) {
            this.stringXML = (StringBuffer)xmle;
            this.jPanel4 = new JPanel();
            this.jPanel4.setOpaque(false);
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            this.jtextArea = new JTextPane();
            this.jtextArea.setPreferredSize(new Dimension(400, 200));
            this.jtextArea.setFont(new Font(AppPreferences.fontname, 1, AppPreferences.fontsize));
            if (AppPreferences.background != 0) {
                Color background = new Color(AppPreferences.background);
                Color foreground = new Color(AppPreferences.foreground);
                this.jtextArea.setCaretColor(foreground);
                this.jtextArea.setBackground(background);
                this.jtextArea.setForeground(foreground);
            }
            this.jtextArea.setMargin(new Insets(5, 5, 5, 5));
            JScrollPane jScrollPane = new JScrollPane(this.jtextArea);
            this.jtextArea.setText(xmle.toString());
            this.jtextArea.setCaretPosition(0);
            this.jPanel4.add(jScrollPane);
        }
        this.jButton2 = new JButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton3.addActionListener(this);
        if (delete) {
            this.jPanel3.add(this.jButton0);
        }
        this.jPanel3.add(this.jButton2);
        this.jPanel3.add(this.jButton3);
        JPanel con = new JPanel();
        this.setContentPane(con);
        EmptyBorder border = new EmptyBorder(5, 10, 5, 10);
        con.setBorder(border);
        con.setLayout(new BorderLayout());
        if (this.jPanel1 != null) {
            con.add((Component)this.jPanel1, "North");
        }
        if (this.jPanel5 != null) {
            con.add((Component)this.jPanel5, "Center");
        } else if (this.jPanel4 != null) {
            con.add((Component)this.jPanel4, "Center");
        } else if (scroll != null) {
            con.add((Component)scroll, "Center");
        }
        con.add((Component)this.jPanel3, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationEditor.this.jButton2.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationEditor.this.jButton3.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SegmentationEditor.this.closeDialog();
            }
        });
        this.pack();
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton0) {
            this.status = 0;
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            if (this.parentXML != null) {
                String value;
                int i;
                Component[] comps;
                if (this.jPanel1 != null) {
                    comps = this.jPanel1.getComponents();
                    for (i = 0; i < comps.length; ++i) {
                        JComponent field;
                        String type = null;
                        value = null;
                        if (comps[i] instanceof JLabel) {
                            JLabel lab = (JLabel)comps[i];
                            type = lab.getName();
                            ++i;
                        }
                        if (comps[i] instanceof JTextField) {
                            field = (JTextField)comps[i];
                            value = ((JTextComponent)field).getText();
                        } else if (comps[i] instanceof JComboBox) {
                            field = (JComboBox)comps[i];
                            value = (String)((JComboBox)field).getSelectedItem();
                        }
                        if (type == null || value == null) continue;
                        this.parentXML.setAttribute(type, value);
                    }
                }
                if (this.jPanel5 != null) {
                    comps = this.jPanel5.getComponents();
                    for (i = 0; i < comps.length; ++i) {
                        if (!(comps[i] instanceof JTextField)) continue;
                        JTextField field = (JTextField)comps[i];
                        value = field.getText();
                        XMLElement elem = (XMLElement)field.getClientProperty("element");
                        if (elem == null) continue;
                        elem.setContent(0, value);
                    }
                }
            } else if (this.stringXML != null) {
                this.stringXML.setLength(0);
                this.stringXML.append(this.jtextArea.getText());
            }
            this.status = 1;
            this.closeDialog();
        } else if (e.getSource() == this.jButton3) {
            this.status = -1;
            this.closeDialog();
        }
    }

    private void setXMLMenu(final XMLElement parent, List elements, JMenu menu) {
        if (elements != null) {
            int index = 0;
            int count = 0;
            for (Object o : elements) {
                Object elem;
                int eindex = index++;
                ++count;
                if (o instanceof XMLElement) {
                    String br;
                    String name;
                    String menuName;
                    elem = (XMLElement)o;
                    String att = elem.getAttribute("languagerulename");
                    if (att != null) {
                        if (att.equals("Default")) {
                            if (elem.getAttribute("languagepattern") != null) {
                                this.defLangMap = elem;
                            } else {
                                this.defLangRule = elem;
                            }
                        }
                        menuName = att;
                    } else {
                        menuName = elem.getName();
                    }
                    if (index == 1 && ((name = elem.getName()).equals("languagerule") || name.equals("languagemap") || name.equals("rule"))) {
                        JMenuItem newItem = new JMenuItem(new AbstractAction(this, "New " + name + "...", (XMLElement)elem){
                            final /* synthetic */ XMLElement val$elem;
                            final /* synthetic */ SegmentationEditor this$0;
                            {
                                this.val$elem = xMLElement2;
                                this.this$0 = this$0;
                                super(arg0);
                            }

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                DefaultXMLElement nelem = new DefaultXMLElement();
                                nelem.setName(name);
                                if (name.equals("languagerule")) {
                                    nelem.setAttribute("languagerulename", "");
                                    DefaultXMLElement rule = new DefaultXMLElement();
                                    rule.setName("rule");
                                    rule.setAttribute("break", "no");
                                    DefaultXMLElement before = new DefaultXMLElement();
                                    before.setName("beforebreak");
                                    before.setContent(0, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET A RULE HERE!"));
                                    DefaultXMLElement after = new DefaultXMLElement();
                                    after.setName("afterbreak");
                                    after.setContent(0, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET A RULE HERE!"));
                                    rule.addChild(before);
                                    rule.addChild(after);
                                    nelem.addChild(rule);
                                } else if (name.equals("languagemap")) {
                                    nelem.setAttribute("languagepattern", "");
                                    nelem.setAttribute("languagerulename", "");
                                } else if (name.equals("rule")) {
                                    nelem.setAttribute("break", "no");
                                    DefaultXMLElement before = new DefaultXMLElement();
                                    before.setName("beforebreak");
                                    before.setContent(0, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET A RULE HERE!"));
                                    DefaultXMLElement after = new DefaultXMLElement();
                                    after.setName("afterbreak");
                                    after.setContent(0, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET A RULE HERE!"));
                                    nelem.addChild(before);
                                    nelem.addChild(after);
                                }
                                int st = this.this$0.showXMLElement(nelem);
                                if (st == 0) {
                                    parent.removeChild(this.val$elem);
                                } else if (st == 1) {
                                    if (name.equals("languagemap")) {
                                        parent.addChild(nelem);
                                        if (this.this$0.defLangMap != null) {
                                            parent.removeChild(this.this$0.defLangMap);
                                            parent.addChild(this.this$0.defLangMap);
                                        }
                                    } else if (name.equals("languagerule")) {
                                        parent.addChild(nelem);
                                        if (this.this$0.defLangRule != null) {
                                            parent.removeChild(this.this$0.defLangRule);
                                            parent.addChild(this.this$0.defLangRule);
                                        }
                                    } else {
                                        parent.addChild(nelem);
                                    }
                                }
                            }
                        });
                        menu.add(newItem);
                    }
                    if (menuName.equals("rule") && (br = elem.getAttribute("break")) != null) {
                        String cont;
                        Object oo;
                        if (br.equals("yes")) {
                            menuName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BREAK:") + "     ";
                        } else if (br.equals("no")) {
                            menuName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXCEPTION:") + "     ";
                        }
                        List list = elem.getChildren("beforebreak");
                        for (XMLElement before : list) {
                            oo = before.getContent(0);
                            if (oo == null) continue;
                            cont = oo.toString();
                            menuName = menuName + cont;
                        }
                        list = elem.getChildren("afterbreak");
                        for (XMLElement after : list) {
                            oo = after.getContent(0);
                            if (oo == null) continue;
                            cont = oo.toString();
                            menuName = menuName + cont;
                        }
                    }
                    if (count > 20) {
                        count = 0;
                        JMenu nextMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEXT ELEMENTS..."));
                        menu.addSeparator();
                        menu.add(nextMenu);
                        menu = nextMenu;
                    }
                    JMenu emenu = new JMenu(menuName);
                    menu.add(emenu);
                    emenu.addItemListener(new ItemListener(){
                        final /* synthetic */ XMLElement val$elem;
                        final /* synthetic */ XMLElement val$parent;
                        final /* synthetic */ int val$eindex;
                        final /* synthetic */ SegmentationEditor this$0;
                        {
                            this.val$elem = xMLElement;
                            this.val$parent = xMLElement2;
                            this.val$eindex = n;
                            this.this$0 = this$0;
                        }

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            JMenu menu = (JMenu)e.getItem();
                            if (e.getStateChange() == 1) {
                                JMenuItem editItem = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT ELEMENT")){
                                    final /* synthetic */ 7 this$1;
                                    {
                                        this.this$1 = this$1;
                                        super(arg0);
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent a) {
                                        int st = this.this$1.this$0.showXMLElement(val$elem);
                                        if (st == 0) {
                                            val$parent.removeChild(val$elem);
                                        } else if (st == 1) {
                                            val$parent.setContent(val$eindex, val$elem);
                                        }
                                    }
                                });
                                menu.add(editItem);
                                List elems = this.val$elem.getChildren();
                                if (elems != null && elems.size() > 0) {
                                    menu.addSeparator();
                                    this.this$0.setXMLMenu(this.val$elem, elems, menu);
                                }
                            } else if (e.getStateChange() == 2) {
                                menu.removeAll();
                            }
                        }
                    });
                    continue;
                }
                if (!(o instanceof String)) continue;
                elem = new StringBuffer(o.toString());
                JMenuItem item = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET A RULE..."), (StringBuffer)elem, parent, eindex){
                    final /* synthetic */ StringBuffer val$elem;
                    final /* synthetic */ XMLElement val$parent;
                    final /* synthetic */ int val$eindex;
                    final /* synthetic */ SegmentationEditor this$0;
                    {
                        this.val$elem = stringBuffer;
                        this.val$parent = xMLElement;
                        this.val$eindex = n;
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        int st = this.this$0.showXMLElement(this.val$elem);
                        if (st == 0) {
                            this.val$parent.removeChild(this.val$elem.toString());
                        } else if (st == 1) {
                            this.val$parent.setContent(this.val$eindex, this.val$elem.toString());
                        }
                    }
                });
                if (((StringBuffer)elem).length() > 0) {
                    item.setText("<html><body width=500>" + ((StringBuffer)elem).toString() + "</body></html>");
                }
                menu.add(item);
            }
        }
    }

    private int showXMLElement(Object elem) {
        SegmentationEditor dlg = new SegmentationEditor(this.owner, elem);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.owner.getSize();
        Point loc = this.owner.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        return dlg.getStatus();
    }

    public int getStatus() {
        return this.status;
    }
}

