/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.ExternalEditor;
import translator.FragmentMatch;
import translator.GlossaryNewEntryEditor;
import translator.KeyPreferences;
import translator.MainView;
import translator.MyUndoListener;
import translator.NumbersHelper;
import translator.Options;
import translator.Placeables;
import translator.Project;
import translator.Prompter;
import translator.ResourceView;
import translator.ScrollPaneWatermark;
import translator.SourceView;
import translator.TranslateEvent;
import translator.TranslationResult;
import translator.Workflow;
import translator.WorkflowManager;
import translator.WorkflowView;
import translator.XMLHelper;
import translator.ai.CTLinguist;
import translator.hunspell.HunSpellChecker;
import translator.text.ProtectedDocument;
import translator.text.SegmentEditorKit;
import translator.text.TargetStyleConstants;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.tmx.TMXNewEntryEditor;
import translator.ui.Colors;
import translator.ui.GridPanel;
import translator.ui.HTMLFormat;
import translator.ui.HighlightCaret;
import translator.ui.SelectWordAction;
import translator.ui.UITools;
import translator.ui.kodo.KodoComboBoxRenderer;
import translator.ui.kodo.KodoComboBoxUI;
import translator.ui.kodo.KodoGlowingBorder;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class TargetView
extends GridPanel {
    private MyUndoListener undoHandler;
    private MainView topui;
    private JScrollPane jscroll;
    private JTextPane targetTextPane;
    private JComboBox stateComboBox;
    private JCheckBox autoNextBox;
    private JButton buttonAppend;
    private JButton buttonProof;
    private JButton buttonNext;
    private JButton buttonAdd;
    JButton buttonAddFragment;
    JButton buttonAddTerm;
    private JButton buttonMove;
    private JToggleButton buttonMouseTags;
    private StyledDocument document;
    private ProtectedDocument protectedDoc;
    private JToolBar bar;
    private JToolBar segmentStatusBar;
    private JPopupMenu pop;
    private JPopupMenu toolPop;
    private String chara = "";
    private int insertLength;
    private int shiftDown;
    private boolean goToCharacter = false;
    private boolean caseAdjusted;
    private boolean readyToBind;
    private boolean edited = false;
    private ExternalEditor externalEditor;
    private JButton currentTULabel;
    private JButton buttonTimer;

    TargetView(MainView parent) {
        this.topui = parent;
        int t = 180;
        if (AppPreferences.theme.equals("System")) {
            t = 0;
        } else if (AppPreferences.alpha != -1) {
            this.setOpaque(false);
            this.setGrid(true);
            this.setTransparent(true);
            Color c = new Color(AppPreferences.tbackground);
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), AppPreferences.alpha);
            this.setBackground(color);
            t = 255 - AppPreferences.alpha;
        } else {
            this.setOpaque(true);
            this.setGrid(AppPreferences.backGrid);
            if (AppPreferences.tbackground != 0) {
                this.setBackground(new Color(AppPreferences.tbackground));
            }
        }
        this.setLayout(new BorderLayout());
        KodoGlowingBorder border = new KodoGlowingBorder();
        Color c = new Color(AppPreferences.iconsColor);
        Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), t);
        border.setColors(new Color(200, 200, 200, t), new Color(200, 200, 200, t), color);
        this.setBorder(border);
        this.createTextPane();
        this.createToolBar();
        this.setPopup();
        this.setToolPopup();
    }

    public void setEdited(boolean e) {
        this.edited = e;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setSegmentStatusBar(boolean set) {
        if (set) {
            if (this.segmentStatusBar == null) {
                this.segmentStatusBar = new JToolBar(1);
                if (AppPreferences.linuxGTK) {
                    this.segmentStatusBar.setUI(new BasicToolBarUI());
                    this.segmentStatusBar.setLayout(new BoxLayout(this.segmentStatusBar, 1));
                }
                this.segmentStatusBar.setFloatable(false);
                this.segmentStatusBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                if (AppPreferences.alpha == -1 && AppPreferences.tBackgroundIm.length() > 0) {
                    this.segmentStatusBar.setOpaque(true);
                    if (!AppPreferences.backGrid) {
                        this.segmentStatusBar.setBackground(this.topui.getMainPanelBackgroundColor());
                    } else {
                        this.segmentStatusBar.setBackground(GridPanel.darker(this.topui.getMainPanelBackgroundColor(), 0.92));
                    }
                } else {
                    this.segmentStatusBar.setOpaque(false);
                }
                this.currentTULabel = new JButton("");
                this.currentTULabel.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
                this.currentTULabel.setOpaque(false);
                float fsize = AppPreferences.pfontsize;
                this.currentTULabel.setFont(this.currentTULabel.getFont().deriveFont(1, fsize));
                Color pbackground = null;
                if (AppPreferences.pbackground != 0 || AppPreferences.pBackgroundIm.length() > 0) {
                    pbackground = new Color(AppPreferences.pbackground);
                    Color pforeground = new Color(AppPreferences.pforeground);
                    this.currentTULabel.setBackground(pbackground);
                    this.currentTULabel.setForeground(pforeground);
                } else {
                    this.currentTULabel.setForeground(new Color(AppPreferences.toolBarsForeground));
                }
                this.currentTULabel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final int mod = e.getModifiers();
                        JButton button = (JButton)e.getSource();
                        final String s = button.getName();
                        if (s != null) {
                            if (s.startsWith("#")) {
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        Project project = this.this$1.TargetView.this.topui.getProjectView().getProject();
                                        if (project != null) {
                                            if ((mod & 2) == 2) {
                                                this.this$1.TargetView.this.topui.getProjectView().searchCurrentDuplicates();
                                            } else {
                                                project.edit(s);
                                            }
                                        }
                                    }
                                });
                            } else if (s.startsWith("$")) {
                                String ss = s.substring(1);
                                int k = Integer.parseInt(ss);
                                Project project = TargetView.this.topui.getProjectView().getProject();
                                if (project != null) {
                                    project.setCurrentTUIndexNoFilter(k);
                                    TargetView.this.topui.resetSegmentsFilter();
                                }
                            }
                        }
                    }
                });
                this.segmentStatusBar.add(Box.createVerticalGlue());
                this.segmentStatusBar.add(this.currentTULabel);
                this.add((Component)this.segmentStatusBar, "East");
                this.validate();
            }
        } else {
            if (this.segmentStatusBar != null) {
                this.remove(this.segmentStatusBar);
                this.validate();
            }
            this.currentTULabel = null;
            this.segmentStatusBar = null;
        }
    }

    public void setCurrentTUStatus(String html, String uid) {
        if (this.currentTULabel != null) {
            this.currentTULabel.setText(html);
            this.currentTULabel.setName(uid);
        }
    }

    public void setReadyToBind(boolean b) {
        this.readyToBind = b;
    }

    public boolean isReadyToBind() {
        return this.readyToBind;
    }

    public void bindExternalEditor(boolean bind) {
        if (bind) {
            this.setAutoNextBox(true);
            this.externalEditor = new ExternalEditor(this.topui);
            if (!this.externalEditor.isClipboardTransfer()) {
                this.externalEditor.startTimer();
            }
        } else {
            this.setAutoNextBox(false);
            if (this.externalEditor != null) {
                this.externalEditor.stopTimer();
                this.externalEditor = null;
            }
        }
    }

    public ExternalEditor getExternalEditor() {
        return this.externalEditor;
    }

    public void setCafeTranTargetTextExternal() {
        ExternalEditor ex = this.getExternalEditor();
        if (ex != null && !ex.isClipboardTransfer() && !ex.isAutoRefresh() && this.isReadyToBind()) {
            ex.setCafeTranTargetSegment();
        }
    }

    public JScrollPane getScrollPane() {
        return this.jscroll;
    }

    public JTextPane getTargetPane() {
        return this.targetTextPane;
    }

    public String getTargetPaneText() {
        return this.targetTextPane.getText();
    }

    public void setTargetPaneText(String s) {
        try {
            int len = this.document.getLength();
            if (len > 0) {
                this.document.remove(0, len);
            }
            this.document.insertString(0, s, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setTextForAddButton(String s) {
        this.buttonAdd.setText(s);
    }

    public JToolBar getToolBar() {
        return this.bar;
    }

    private void createTextPane() {
        File file;
        this.targetTextPane = new JTextPane();
        this.targetTextPane.setEditorKit(new SegmentEditorKit());
        this.targetTextPane.setDragEnabled(AppPreferences.draganddrop);
        this.targetTextPane.putClientProperty("type", "langview");
        Graphics g = this.targetTextPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        if (AppPreferences.tbackground != 0 || AppPreferences.tBackgroundIm.length() > 0) {
            Color tbackground = new Color(AppPreferences.tbackground);
            Color tforeground = new Color(AppPreferences.tforeground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.targetTextPane.setSelectionColor(selection);
            this.targetTextPane.setCaretColor(tforeground);
            this.targetTextPane.setBackground(tbackground);
            this.targetTextPane.setForeground(tforeground);
            this.targetTextPane.setSelectedTextColor(tforeground);
        } else if (AppPreferences.linuxGTK) {
            this.targetTextPane.setCaretColor(this.targetTextPane.getForeground());
        }
        if (AppPreferences.laf != null && AppPreferences.laf.equals("Mac OS")) {
            this.targetTextPane.setCaret(new HighlightCaret());
        }
        this.targetTextPane.setFont(new Font(AppPreferences.tfontname, AppPreferences.tfontstyle, AppPreferences.tfontsize));
        this.targetTextPane.setMargin(new Insets(16, 16, 16, 16));
        Color termcolor = new Color(AppPreferences.matchColor);
        Color termcolorfont = new Color(AppPreferences.matchColorFont);
        if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
            termcolor = this.topui.toAlphaColor(termcolor, 127);
        }
        Style sstyle = this.targetTextPane.addStyle("highlight", null);
        StyleConstants.setBackground(sstyle, termcolor);
        StyleConstants.setForeground(sstyle, termcolorfont);
        DropTarget dt = this.targetTextPane.getDropTarget();
        dt.setActive(true);
        try {
            dt.addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    dtde.acceptDrop(dtde.getSourceActions());
                    dtde.dropComplete(true);
                    TargetView.this.targetTextPane.setCaretPosition(TargetView.this.targetTextPane.getCaretPosition());
                    if (AppPreferences.adjustWordSpacing) {
                        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
                        executor.schedule(new Runnable(){

                            @Override
                            public void run() {
                                TargetView.this.autoAdjustSpacing();
                            }
                        }, 200L, TimeUnit.MILLISECONDS);
                    }
                }
            });
        }
        catch (TooManyListenersException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.targetTextPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TargetView.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (TargetView.this.topui.getSourceView().isPrompterActive()) {
                    TargetView.this.topui.getSourceView().getPrompter().closePopUp();
                }
            }
        });
        this.targetTextPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                WorkflowManager manager;
                if (evt.isPopupTrigger()) {
                    TargetView.this.showToolsPopup(evt.getComponent(), evt.getX(), evt.getY(), true);
                }
                if (AppPreferences.autopilot && (manager = TargetView.this.topui.getWorkflowView().getWorkflowManager()) != null) {
                    manager.stopTimer();
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    TargetView.this.showToolsPopup(evt.getComponent(), evt.getX(), evt.getY(), true);
                }
                if (evt.getButton() == 1) {
                    int cc = evt.getClickCount();
                    int mod = evt.getModifiersEx();
                    String sel = TargetView.this.targetTextPane.getSelectedText();
                    if (cc < 2) {
                        if ((mod & 0x200) != 512 && sel != null && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                            try {
                                int spos = Utilities.getWordStart(TargetView.this.targetTextPane, TargetView.this.targetTextPane.getSelectionStart());
                                int epos = Utilities.getWordEnd(TargetView.this.targetTextPane, TargetView.this.targetTextPane.getSelectionEnd() - 1);
                                TargetView.this.targetTextPane.setSelectionStart(spos);
                                TargetView.this.targetTextPane.setSelectionEnd(epos);
                                sel = TargetView.this.targetTextPane.getSelectedText();
                            }
                            catch (BadLocationException ex) {
                                ex.printStackTrace();
                            }
                        }
                        if (AppPreferences.mouseTags || UITools.isShortcutDown(evt)) {
                            TargetView.this.mouseTagPlacement(sel);
                        }
                    }
                    if (sel != null) {
                        ResourceView rview = TargetView.this.topui.getResourceView();
                        rview.clearAISelection();
                        if (sel.length() <= 150) {
                            sel = XMLHelper.parseTags(sel);
                            rview = TargetView.this.topui.getResourceView();
                            rview.getLookUpBox().setSelectedItem(sel);
                            if (AppPreferences.chatGPTAction == 2) {
                                rview.translateAIService(sel);
                            }
                            if (AppPreferences.ttsSpeak == 2) {
                                rview.speak(sel);
                            }
                        }
                        TargetView.this.topui.getSourcePane().getCaret().setSelectionVisible(true);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TargetView.this.topui.resetTextAreas();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.targetTextPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int len = TargetView.this.document.getLength();
                        if (len == 0) {
                            return;
                        }
                        int cpos = TargetView.this.targetTextPane.getCaretPosition();
                        if (cpos == 0) {
                            cpos = 1;
                        }
                        try {
                            String text;
                            int opening;
                            TargetView.this.chara = TargetView.this.document.getText(cpos - 1, 2);
                            if (TargetView.this.chara.charAt(0) == '<') {
                                String text2;
                                int closing;
                                if ((TargetView.this.chara.charAt(1) == 'x' || TargetView.this.chara.charAt(1) == '/' || TargetView.this.chara.charAt(1) == 'b' || TargetView.this.chara.charAt(1) == 'i' || TargetView.this.chara.charAt(1) == 'u' || TargetView.this.chara.charAt(1) == 's' || TargetView.this.chara.charAt(1) == 'r' || TargetView.this.chara.charAt(1) == 'm') && (closing = TargetView.this.endTagPostion(cpos, text2 = TargetView.this.document.getText(0, len))) != -1) {
                                    cpos = closing + 1;
                                    TargetView.this.targetTextPane.setCaretPosition(cpos);
                                }
                            } else if (TargetView.this.chara.charAt(1) == '>' && (opening = TargetView.this.startTagPostion(text = TargetView.this.document.getText(0, cpos))) != -1) {
                                TargetView.this.targetTextPane.setCaretPosition(opening);
                            }
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                final int dot = e.getDot();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        try {
                            Rectangle r = this.this$1.TargetView.this.targetTextPane.getVisibleRect();
                            Rectangle2D r0 = this.this$1.TargetView.this.targetTextPane.modelToView2D(dot);
                            int w = (int)r.getWidth();
                            int h = (int)r.getHeight();
                            int x = (int)r.getX();
                            int y = (int)r.getY();
                            int y0 = (int)r0.getY();
                            if (y0 - y + 40 >= h) {
                                r = new Rectangle(x, y0, w, h);
                                this.this$1.TargetView.this.targetTextPane.scrollRectToVisible(r);
                            } else if (y0 < 40) {
                                r = new Rectangle(0, 0, w, h);
                                this.this$1.TargetView.this.targetTextPane.scrollRectToVisible(r);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        this.targetTextPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                CTLinguist gpt;
                int keycode = e.getKeyCode();
                if (keycode == 27) {
                    final int cpos = TargetView.this.targetTextPane.getCaretPosition();
                    if (cpos < 1) {
                        return;
                    }
                    final DefaultStyledDocument doc = (DefaultStyledDocument)TargetView.this.targetTextPane.getDocument();
                    try {
                        char c;
                        String all = doc.getText(0, doc.getLength());
                        final String stn = all.substring(0, cpos);
                        final char ch = stn.charAt(stn.length() - 1);
                        if (ch == 'b' || ch == 'i' || ch == 'u' || ch == 's' || ch == 'r' || ch == 'm') {
                            if (TargetView.this.topui.getSourceView().isPrompterActive()) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 6 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    Font font = this.this$1.TargetView.this.targetTextPane.getFont();
                                    Style nstyle = doc.getStyle("Tags");
                                    JLabel label = new JLabel(Character.toString(ch));
                                    label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                                    label.setHorizontalTextPosition(0);
                                    label.setOpaque(false);
                                    Font f = stn.length() > 1 && stn.charAt(stn.length() - 2) == '/' ? font.deriveFont(3, AppPreferences.tagsfontsize) : font.deriveFont(1, AppPreferences.tagsfontsize);
                                    label.setFont(f);
                                    label.setForeground(new Color(AppPreferences.tagColor));
                                    StyleConstants.setComponent(nstyle, label);
                                    try {
                                        doc.putProperty("notags", true);
                                        if (ch == 'b') {
                                            if (stn.endsWith("/b")) {
                                                doc.replace(cpos - 2, 2, "</b>", nstyle);
                                            } else {
                                                doc.replace(cpos - 1, 1, "<b>", nstyle);
                                            }
                                        } else if (ch == 'i') {
                                            if (stn.endsWith("/i")) {
                                                doc.replace(cpos - 2, 2, "</i>", nstyle);
                                            } else {
                                                doc.replace(cpos - 1, 1, "<i>", nstyle);
                                            }
                                        } else if (ch == 'u') {
                                            if (stn.endsWith("/u")) {
                                                doc.replace(cpos - 2, 2, "</u>", nstyle);
                                            } else {
                                                doc.replace(cpos - 1, 1, "<u>", nstyle);
                                            }
                                        } else if (ch == 's') {
                                            if (stn.endsWith("/s")) {
                                                doc.replace(cpos - 2, 2, "</sub>", nstyle);
                                            } else {
                                                doc.replace(cpos - 1, 1, "<sub>", nstyle);
                                            }
                                        } else if (ch == 'r') {
                                            if (stn.endsWith("/r")) {
                                                doc.replace(cpos - 2, 2, "</sup>", nstyle);
                                            } else {
                                                doc.replace(cpos - 1, 1, "<sup>", nstyle);
                                            }
                                        } else if (ch == 'm') {
                                            if (stn.endsWith("/m")) {
                                                doc.replace(cpos - 2, 2, "</mark>", nstyle);
                                            } else {
                                                doc.replace(cpos - 1, 1, "<mark>", nstyle);
                                            }
                                        }
                                        doc.putProperty("notags", null);
                                    }
                                    catch (BadLocationException ex) {
                                        ex.printStackTrace();
                                        doc.putProperty("notags", null);
                                    }
                                }
                            });
                            return;
                        }
                        if (ch == 'x') {
                            doc.replace(cpos - 1, 1, "", null);
                            TargetView.this.transferCurrentTag();
                            return;
                        }
                        char[] chars = stn.toCharArray();
                        final StringBuilder sb = new StringBuilder();
                        for (int i = chars.length - 1; i >= 0 && Character.isDigit(c = chars[i]); --i) {
                            sb.append(c);
                        }
                        if (sb.length() > 0) {
                            if (TargetView.this.topui.getSourceView().isPrompterActive()) {
                                return;
                            }
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 6 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    List tlist;
                                    Workflow flow = this.this$1.TargetView.this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
                                    if (flow != null && (tlist = flow.getTags()) != null && !tlist.isEmpty()) {
                                        sb.reverse();
                                        String tag = sb.toString();
                                        boolean tagInserted = false;
                                        while (tag.length() > 0) {
                                            for (Object[] o : tlist) {
                                                Project project;
                                                String n;
                                                Integer integ = (Integer)o[0];
                                                String tagNo = Integer.toString(integ);
                                                String key = o[1].toString();
                                                if (tagNo == null || !tagNo.equals(tag)) continue;
                                                tagInserted = true;
                                                Font font = this.this$1.TargetView.this.targetTextPane.getFont();
                                                Style nstyle = doc.getStyle("Tags");
                                                String sid = tag;
                                                if (!AppPreferences.hideTagDetails && (n = (project = this.this$1.TargetView.this.topui.getProjectView().getProject()).getTagsXML(key, true)) != null && n.length() > 0) {
                                                    sid = sid + " " + n;
                                                }
                                                JLabel label = new JLabel(sid);
                                                label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                                                label.setHorizontalTextPosition(0);
                                                label.setOpaque(false);
                                                Font f = font.deriveFont(1, AppPreferences.tagsfontsize);
                                                label.setFont(f);
                                                if (key != null && key.indexOf("xntr") != -1) {
                                                    label.setForeground(new Color(AppPreferences.placeablesColor));
                                                } else {
                                                    label.setForeground(new Color(AppPreferences.tagColor));
                                                }
                                                StyleConstants.setComponent(nstyle, label);
                                                try {
                                                    doc.putProperty("notags", true);
                                                    doc.replace(cpos - tag.length(), tag.length(), key, nstyle);
                                                    doc.putProperty("notags", null);
                                                }
                                                catch (BadLocationException ex) {
                                                    ex.printStackTrace();
                                                    doc.putProperty("notags", null);
                                                }
                                                break;
                                            }
                                            if (tagInserted) break;
                                            tag = tag.substring(1);
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                } else if (keycode == 525) {
                    try {
                        int pos = TargetView.this.targetTextPane.getCaretPosition();
                        Rectangle2D r = TargetView.this.targetTextPane.modelToView2D(pos);
                        int x = (int)r.getX();
                        int y = (int)r.getY();
                        Component comp = (Component)e.getSource();
                        TargetView.this.showToolsPopup(comp, x, y, true);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(SourceView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (keycode == 10 && AppPreferences.chatGPTTargetEditorChatMode && !TargetView.this.topui.getSourceView().isPrompterActive() && (gpt = TargetView.this.topui.getResourceView().getCTLinguist()) != null) {
                    e.consume();
                    String s = TargetView.this.targetTextPane.getText();
                    if (s != null && (s = s.trim()).length() > 0) {
                        gpt.promptChat(s, TargetView.this.targetTextPane);
                        TargetView.this.targetTextPane.selectAll();
                        Prompter auto = TargetView.this.topui.getSourceView().getPrompter();
                        if (auto != null) {
                            auto.addPhrasesMTEntry(s, false);
                        }
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                TargetView.this.shiftDown = 0;
                char c = e.getKeyChar();
                if (TargetView.this.goToCharacter) {
                    TargetView.this.goToCharacter = false;
                    e.consume();
                    TargetView.this.goToCharacter(c);
                    return;
                }
                boolean space = Character.isSpaceChar(c);
                if (space) {
                    if (AppPreferences.adjustCase && !TargetView.this.caseAdjusted) {
                        TargetView.this.autoAdjustCase();
                    } else {
                        TargetView.this.undoHandler.compoundEditBreak(true);
                    }
                } else if (!AppPreferences.noWordSeparatorTargetLanguage) {
                    TargetView.this.undoHandler.compoundEditEnd(false);
                } else {
                    TargetView.this.undoHandler.compoundEditEnd(true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int i = e.getKeyCode();
                if (i == 16) {
                    TargetView.this.shiftDown++;
                    if (TargetView.this.shiftDown == 2) {
                        TargetView.this.shiftDown = 0;
                        if (!e.isShiftDown()) {
                            String s = TargetView.this.targetTextPane.getSelectedText();
                            if (s == null) {
                                s = TargetView.this.topui.getResourceView().getWordAtCaretPosition(TargetView.this.targetTextPane, true);
                            }
                            TargetView.this.showMatchesForIndex(s);
                        }
                    }
                } else {
                    TargetView.this.shiftDown = 0;
                }
            }
        });
        this.document = this.targetTextPane.getStyledDocument();
        this.document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TargetView.this.undoHandler.compoundEditEnd(false);
            }

            @Override
            public void insertUpdate(final DocumentEvent e) {
                Object o;
                TargetView.this.edited = true;
                TargetView.this.readyToBind = true;
                TargetView.this.insertLength = e.getLength();
                if (TargetView.this.insertLength > 1 && (o = TargetView.this.document.getProperty("notags")) == null) {
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (this.this$1.TargetView.this.document.getLength() > 1) {
                                if (AppPreferences.adjustCase && !this.this$1.TargetView.this.caseAdjusted) {
                                    this.this$1.TargetView.this.autoAdjustCase();
                                }
                                try {
                                    String t = this.this$1.TargetView.this.document.getText(e.getOffset(), e.getLength());
                                    if (t != null && t.indexOf(60) != -1) {
                                        Font font = this.this$1.TargetView.this.targetTextPane.getFont();
                                        font = font.deriveFont(1, AppPreferences.tagsfontsize);
                                        XMLHelper.markTags(this.this$1.TargetView.this.document, font);
                                    }
                                }
                                catch (BadLocationException ex) {
                                    Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        }
                    });
                }
                TargetView.this.topui.countTagPos(TargetView.this.insertLength, false);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TargetView.this.edited = true;
                TargetView.this.readyToBind = true;
                final int off = e.getOffset();
                int remLen = e.getLength();
                int len = TargetView.this.document.getLength();
                if (off == 0 && len == 0) {
                    if (TargetView.this.topui.getSourceView().isPrompterActive()) {
                        TargetView.this.topui.getSourceView().getPrompter().closePopUp();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Style style = TargetView.this.document.getStyle("");
                            TargetView.this.targetTextPane.setCharacterAttributes(style, true);
                        }
                    });
                }
                if (TargetView.this.chara == null) {
                    return;
                }
                String tchara = TargetView.this.chara;
                TargetView.this.chara = null;
                if (len > 1) {
                    try {
                        String x = TargetView.this.document.getText(off, 1);
                        char chx = x.charAt(0);
                        if (tchara.endsWith("<") && (chx == 'x' || chx == '/' || chx == 'b' || chx == 'i' || chx == 'u' || chx == 's' || chx == 'r' || chx == 'm')) {
                            String text = TargetView.this.document.getText(0, TargetView.this.document.getLength());
                            int i = TargetView.this.endTagPostion(off, text);
                            if (i != -1) {
                                final int j = i + 1;
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 7 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            this.this$1.TargetView.this.document.remove(off, j - off);
                                            this.this$1.TargetView.this.undoHandler.resetUndoManager();
                                        }
                                        catch (BadLocationException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                });
                            }
                        } else if (tchara.startsWith(">") && off > 0) {
                            int cp = TargetView.this.targetTextPane.getCaretPosition();
                            int ss = TargetView.this.targetTextPane.getSelectionStart();
                            String text = TargetView.this.document.getText(0, off);
                            int i = TargetView.this.startTagPostion(text);
                            if (i != -1 && cp != off && cp == ss) {
                                final int opening = i;
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 7 this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        try {
                                            this.this$1.TargetView.this.document.remove(opening, off - opening);
                                            this.this$1.TargetView.this.undoHandler.resetUndoManager();
                                        }
                                        catch (BadLocationException ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                });
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
                TargetView.this.topui.countTagPos(len, true);
            }
        });
        if (AppPreferences.invisibles) {
            this.document.putProperty("invisibles", true);
        }
        Style style = this.document.addStyle("Tags", null);
        this.document.addStyle("", null);
        style = this.document.addStyle("Normal", null);
        StyleConstants.setForeground(style, this.targetTextPane.getForeground());
        style = this.document.addStyle("SpaceNB", null);
        StyleConstants.setBackground(style, Color.LIGHT_GRAY);
        style = this.document.addStyle("Spellcheck", null);
        TargetStyleConstants.setColorUnderline(style, true);
        style = this.document.addStyle("Added", null);
        style.addAttribute("track", "added");
        StyleConstants.setForeground(style, new Color(AppPreferences.trackingAddColor));
        StyleConstants.setUnderline(style, true);
        style = this.document.addStyle("Deleted", null);
        style.addAttribute("track", "deleted");
        StyleConstants.setForeground(style, new Color(AppPreferences.trackingDeleteColor));
        StyleConstants.setStrikeThrough(style, true);
        style = this.document.addStyle("Add", null);
        style.addAttribute("track", "add");
        StyleConstants.setForeground(style, new Color(AppPreferences.trackingAddColor));
        StyleConstants.setUnderline(style, true);
        style = this.document.addStyle("Delete", null);
        style.addAttribute("track", "delete");
        StyleConstants.setForeground(style, new Color(AppPreferences.trackingDeleteColor));
        StyleConstants.setStrikeThrough(style, true);
        this.undoHandler = new MyUndoListener();
        this.undoHandler.setLimit(100);
        this.document.addUndoableEditListener(this.undoHandler);
        this.targetTextPane.getActionMap().put("select-word", new SelectWordAction());
        this.targetTextPane.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetView.this.undoHandler.undoAction();
            }
        });
        this.targetTextPane.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TargetView.this.undoHandler.redoAction();
            }
        });
        if (AppPreferences.operatingSystem == 1) {
            this.targetTextPane.getInputMap().put(KeyStroke.getKeyStroke(90, 256), "Undo");
            this.targetTextPane.getInputMap().put(KeyStroke.getKeyStroke(89, 256), "Redo");
        } else {
            this.targetTextPane.getInputMap().put(KeyStroke.getKeyStroke(90, 128), "Undo");
            this.targetTextPane.getInputMap().put(KeyStroke.getKeyStroke(89, 128), "Redo");
        }
        this.jscroll = new JScrollPane(this.targetTextPane);
        this.jscroll.setOpaque(false);
        this.jscroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.jscroll.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            this.jscroll.getViewport().setOpaque(false);
            this.targetTextPane.setBackground(new Color(0, 0, 0, 0));
            this.targetTextPane.setOpaque(false);
        }
        if (AppPreferences.alpha == -1 && AppPreferences.tBackgroundIm.length() > 0 && (file = new File(AppPreferences.tBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.targetTextPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.targetTextPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.add((Component)this.jscroll, "Center");
    }

    public void useDeleteButton(boolean use) {
        Component comp = this.bar.getComponentAtIndex(7);
        String name = comp.getName();
        if (use) {
            if (name != null && name.equals("MenuTransActionDeleteSegment")) {
                return;
            }
            JButton buttonDelete = new JButton();
            buttonDelete.setName("MenuTransActionDeleteSegment");
            buttonDelete.setOpaque(false);
            buttonDelete.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
            FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DELETE_FOREVER, (int)(buttonDelete.getFont().getSize() + 4), (Color)Colors.getIconsColor());
            buttonDelete.setIcon((Icon)ficon);
            buttonDelete.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE SEGMENT"));
            buttonDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TMX tmx = TargetView.this.topui.getProjectView().getProject().getTMX();
                    if (tmx != null) {
                        tmx.getWorkflow().removeTU();
                    }
                }
            });
            this.bar.add((Component)buttonDelete, 7);
            this.bar.validate();
            this.bar.repaint();
            JMenu amenu = this.topui.getWorkflowView().getActionMenu();
            JMenuItem deleteItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE SEGMENT"));
            deleteItem.setName("MenuTransActionDeleteSegment");
            KeyStroke ks = KeyPreferences.getKeyStroke("k107");
            if (ks != null) {
                deleteItem.setAccelerator(ks);
            }
            deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TMX tmx = TargetView.this.topui.getProjectView().getProject().getTMX();
                    if (tmx != null) {
                        tmx.getWorkflow().removeTU();
                    }
                }
            });
            amenu.add((Component)deleteItem, 4);
            amenu.validate();
            amenu.repaint();
        } else if (name != null && name.equals("MenuTransActionDeleteSegment")) {
            this.bar.remove(7);
            this.bar.validate();
            this.bar.repaint();
            JMenu amenu = this.topui.getWorkflowView().getActionMenu();
            amenu.remove(4);
            amenu.validate();
            amenu.repaint();
        }
    }

    private void createToolBar() {
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        this.bar.setOpaque(true);
        this.bar.setBackground(GridPanel.darker(this.topui.getMainPanelBackgroundColor(), 0.9));
        this.buttonAdd = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEXT"));
        this.buttonAdd.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.tbackground2 != 0) {
            this.buttonAdd.setBackground(this.topui.getMainPanelBackgroundColor());
        }
        this.buttonAdd.setOpaque(false);
        this.buttonAdd.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE_TO_GO, (int)(this.buttonAdd.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonAdd.setIcon((Icon)ficon);
        this.buttonAdd.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SEGMENT TO MEMORY AND GO TO NEXT SEGMENT") + " (" + Options.getShortcutComboString("k1") + ")");
        this.buttonAdd.setName("AddSegmentToTM");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TargetView.this.topui.getWorkflowView();
                flow.add(0, false);
            }
        });
        this.buttonAppend = new JButton();
        this.buttonAppend.setOpaque(false);
        this.buttonAppend.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CALL_MERGE, (int)(this.buttonAppend.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonAppend.setIcon((Icon)ficon);
        this.buttonAppend.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN SEGMENTS") + " (" + Options.getShortcutComboString("k4") + ")");
        this.buttonAppend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TargetView.this.topui.getWorkflowView();
                flow.append(0);
            }
        });
        this.buttonAppend.setName("JoinSegments");
        JButton buttonSplit = new JButton();
        buttonSplit.setOpaque(false);
        buttonSplit.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonSplit.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPLIT SEGMENT") + " (" + Options.getShortcutComboString("k5") + ")");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CALL_SPLIT, (int)(buttonSplit.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonSplit.setIcon((Icon)ficon);
        buttonSplit.setName("SplitSegments");
        buttonSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = TargetView.this.topui.getProjectView().getProject();
                if (project != null) {
                    project.splitSegment();
                }
            }
        });
        this.buttonNext = new JButton();
        this.buttonNext.setOpaque(false);
        this.buttonNext.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT_BOLD_CIRCLE_OUTLINE, (int)(this.buttonNext.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonNext.setIcon((Icon)ficon);
        this.buttonNext.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MOVE TO THE NEXT SEGMENT") + " (" + Options.getShortcutComboString("k2") + ")");
        this.buttonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TargetView.this.topui.getWorkflowView();
                flow.next(0);
            }
        });
        this.buttonNext.setName("NextSegment");
        this.buttonProof = new JButton("");
        this.buttonProof.setOpaque(false);
        this.buttonProof.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_LEFT_BOLD_CIRCLE_OUTLINE, (int)(this.buttonProof.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonProof.setIcon((Icon)ficon);
        this.buttonProof.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MOVE TO THE PREVIOUS SEGMENT") + " (" + Options.getShortcutComboString("k3") + ")");
        this.buttonProof.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TargetView.this.topui.getWorkflowView();
                flow.review();
            }
        });
        this.buttonProof.setName("PreviousSegment");
        this.buttonAddFragment = new JButton();
        this.buttonAddFragment.setOpaque(false);
        this.buttonAddFragment.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonAddFragment.setName("AddTermToMemory");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)(this.buttonAddFragment.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonAddFragment.setIcon((Icon)ficon);
        this.buttonAddFragment.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD FRAGMENT TO MEMORY") + " (" + Options.getShortcutComboString("k26") + ")");
        this.buttonAddFragment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int mod = e.getModifiers();
                boolean modifier = false;
                if ((mod & 2) == 2) {
                    modifier = true;
                }
                if (AppPreferences.skipTermWindowButton && !modifier) {
                    MemoryView mv = TargetView.this.topui.getMemoryView();
                    mv.addPhraseDirectToMemory();
                } else {
                    WorkflowView flow = TargetView.this.topui.getWorkflowView();
                    flow.addPhraseToMemory();
                }
            }
        });
        this.buttonMove = new JButton();
        this.buttonMove.setOpaque(false);
        this.buttonMove.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonMove.setName("TransferToTargetSegmentPane");
        this.buttonMove.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER TO TARGET SEGMENT EDITOR") + " (" + Options.getShortcutComboString("k13") + ")");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_DOWN_BOLD, (int)(this.buttonMove.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonMove.setIcon((Icon)ficon);
        this.buttonMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView flow = TargetView.this.topui.getWorkflowView();
                flow.transferSegment();
            }
        });
        this.buttonMouseTags = new JToggleButton();
        this.buttonMouseTags.setSelected(AppPreferences.mouseTags);
        this.buttonMouseTags.setOpaque(false);
        this.buttonMouseTags.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonMouseTags.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MOUSE TAG PLACEMENT"));
        this.buttonMouseTags.setName("MouseTagPlacement");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CODE_TAGS, (int)(this.buttonMouseTags.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonMouseTags.setIcon((Icon)ficon);
        this.buttonMouseTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppPreferences.mouseTags = !AppPreferences.mouseTags;
                TargetView.this.getToolPopup().setVisible(false);
                TargetView.this.topui.getWorkflowView().setMouseTagsMenu(AppPreferences.mouseTags);
                String sel = TargetView.this.targetTextPane.getSelectedText();
                if (sel != null) {
                    TargetView.this.mouseTagPlacement(sel);
                }
            }
        });
        this.buttonAddTerm = new JButton();
        this.buttonAddTerm.setOpaque(false);
        this.buttonAddTerm.setName("AddTermToGlossary");
        this.buttonAddTerm.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        this.buttonAddTerm.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD TERM TO GLOSSARY") + " (" + Options.getShortcutComboString("k27") + ")");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PENCIL, (int)(this.buttonAddTerm.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        this.buttonAddTerm.setIcon((Icon)ficon);
        this.buttonAddTerm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int mod = e.getModifiers();
                boolean modifier = false;
                if ((mod & 2) == 2) {
                    modifier = true;
                }
                if (AppPreferences.skipTermWindowButton && !modifier) {
                    WorkflowView flow = TargetView.this.topui.getWorkflowView();
                    flow.addDirectEntryToGlossary();
                } else {
                    WorkflowView flow = TargetView.this.topui.getWorkflowView();
                    flow.addEntryToGlossary();
                }
            }
        });
        String[] states = new String[]{"Translate", "Check", "Lock", "Version", "Approve", "Reject"};
        this.stateComboBox = new JComboBox<String>(states);
        this.stateComboBox.setName("SelectSegmentStatus");
        int w = AppPreferences.toolBarButtonsFontSize > 30 ? 192 : (AppPreferences.toolBarButtonsFontSize > 20 ? 174 : 140);
        this.stateComboBox.setPreferredSize(new Dimension(w, this.stateComboBox.getPreferredSize().height));
        this.stateComboBox.setMaximumSize(new Dimension(w, this.stateComboBox.getPreferredSize().height));
        if (!AppPreferences.linuxGTK && !AppPreferences.theme.equals("System")) {
            this.stateComboBox.setRenderer(new KodoComboBoxRenderer());
            KodoComboBoxUI ui = new KodoComboBoxUI();
            this.stateComboBox.setUI(ui);
            if (AppPreferences.tbackground != 0) {
                Color background = new Color(AppPreferences.tbackground);
                Color foreground = new Color(AppPreferences.tforeground);
                this.stateComboBox.setBackground(background);
                this.stateComboBox.setForeground(foreground);
                ui.setButtonColors(foreground, background);
            }
        }
        JButton buttonNote = new JButton();
        buttonNote.setOpaque(false);
        buttonNote.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
        buttonNote.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SEGMENT NOTE") + " (" + Options.getShortcutComboString("k29") + ")");
        buttonNote.setName("AddSegmentNote");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COMMENT, (int)(buttonNote.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        buttonNote.setIcon((Icon)ficon);
        buttonNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = TargetView.this.topui.getProjectView().getProject();
                if (project != null) {
                    project.createNote();
                }
            }
        });
        this.bar.add(this.buttonAdd);
        this.bar.add(this.buttonProof);
        this.bar.add(this.buttonNext);
        this.bar.add(this.buttonAppend);
        this.bar.add(buttonSplit);
        this.bar.add(this.buttonMove);
        this.bar.add(this.buttonMouseTags);
        this.bar.add(this.buttonAddFragment);
        this.bar.add(this.buttonAddTerm);
        this.bar.add(buttonNote);
        this.bar.add(this.stateComboBox);
        if (AppPreferences.autopilot) {
            this.buttonTimer = new JButton("ON");
            this.buttonTimer.setName("TimingNextSegment");
            this.buttonTimer.setForeground(new Color(AppPreferences.toolBarsForeground));
            if (AppPreferences.tbackground2 != 0) {
                this.buttonTimer.setBackground(this.topui.getMainPanelBackgroundColor());
            }
            this.buttonTimer.setOpaque(false);
            this.buttonTimer.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
            this.buttonTimer.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO STOP AUTOPILOT OR PRESS ESC KEY TO SUSPEND"));
            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOCK, (int)(this.buttonTimer.getFont().getSize() + 4), (Color)Colors.getIconsColor());
            this.buttonTimer.setIcon((Icon)ficon);
            this.buttonTimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AppPreferences.autopilot = !AppPreferences.autopilot;
                    WorkflowManager manager = TargetView.this.topui.getWorkflowView().getWorkflowManager();
                    if (manager != null && !AppPreferences.autopilot) {
                        TargetView.this.buttonTimer.setText("OFF");
                        manager.stopTimer();
                    } else {
                        TargetView.this.buttonTimer.setText("ON");
                    }
                }
            });
            this.bar.add(this.buttonTimer);
        }
        if (AppPreferences.targetToolbarPosition) {
            this.add((Component)this.bar, "North");
        } else {
            this.add((Component)this.bar, "South");
        }
        this.bar.setVisible(!AppPreferences.hideToolBars);
    }

    void setAutoNextBox(boolean state) {
        if (state) {
            this.autoNextBox = new JCheckBox("AutoNext", true);
            this.autoNextBox.setForeground(new Color(AppPreferences.toolBarsForeground));
            this.autoNextBox.setOpaque(false);
            this.autoNextBox.setName("CheckBoxAutoNext");
            this.bar.add(this.autoNextBox);
        } else if (this.autoNextBox != null) {
            this.bar.remove(this.autoNextBox);
            this.autoNextBox = null;
        }
        this.bar.revalidate();
        this.bar.repaint();
    }

    public boolean isAutoNextOn() {
        return this.autoNextBox != null && this.autoNextBox.isSelected();
    }

    void showGlossaryAddButton() {
        if (this.bar.getComponentIndex(this.buttonAddTerm) == -1) {
            this.bar.add((Component)this.buttonAddTerm, 8);
            this.bar.revalidate();
            this.bar.repaint();
        }
    }

    public int getTUState() {
        return this.stateComboBox.getSelectedIndex();
    }

    public void setTUState(int state) {
        this.stateComboBox.setSelectedIndex(state);
    }

    public void grabSelection(String selection) {
        if (selection.length() < 3) {
            return;
        }
        GlossaryNewEntryEditor ge = this.topui.getResourceView().getGlossaryNewEntryEditor();
        if (ge != null && ge.isVisible()) {
            ge.grabSelection(selection);
            return;
        }
        TMXNewEntryEditor me = this.topui.getMemoryView().getMemoryNewEntryEditor();
        if (me != null && me.isVisible()) {
            me.grabSelection(selection);
            return;
        }
        String sel = this.targetTextPane.getSelectedText();
        Document doc = this.targetTextPane.getDocument();
        int pos = this.targetTextPane.getCaretPosition();
        try {
            if (sel != null) {
                doc.remove(pos -= sel.length(), sel.length());
            }
            doc.insertString(pos, selection.trim() + AppPreferences.fca, null);
            if (AppPreferences.adjustWordSpacing) {
                this.autoAdjustSpacing();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.targetTextPane.isFocusOwner()) {
            this.targetTextPane.requestFocusInWindow();
        }
    }

    private void setMatchStatus() {
        XLIFFUnit tu;
        XLIFF xliff = this.topui.getProjectView().getProject().getXLIFF();
        if (xliff != null && (tu = xliff.getWorkflow().getCheckTransUnit()) != null) {
            this.topui.getTargetView().setEdited(false);
            tu.removeMatch(false);
            boolean storeMatch = false;
            if (xliff.isCafeTranXLIFF) {
                storeMatch = true;
            }
            tu.setMatch(-1, 4, storeMatch);
        }
    }

    public void setWebMachineTranslation(String translation) {
        translation = translation.trim();
        try {
            String sText;
            StyledDocument sdoc = (StyledDocument)this.topui.getSourcePane().getDocument();
            int slen = sdoc.getLength();
            Document tdoc = this.targetTextPane.getDocument();
            int tlen = tdoc.getLength();
            if (tlen > 0) {
                tdoc.remove(0, tlen);
            }
            if (slen > 0 && (translation = XMLHelper.replacePipesWithTags(sText = sdoc.getText(0, slen), translation)).length() > 0) {
                char p2;
                char p1 = sText.charAt(slen - 1);
                if (p1 == '.' || p1 == '?' || p1 == '!') {
                    char p22 = translation.charAt(translation.length() - 1);
                    if (p1 != p22) {
                        if (!AppPreferences.noWordSeparatorTargetLanguage) {
                            translation = translation + p1;
                        } else if (p22 != '\u3002') {
                            translation = translation + '\u3002';
                        }
                    }
                } else if (p1 == '\u3002' && p1 != (p2 = translation.charAt(translation.length() - 1))) {
                    if (!AppPreferences.noWordSeparatorTargetLanguage) {
                        if (p2 != '.' && p2 != '!' && p2 != '?') {
                            translation = translation + ".";
                        }
                    } else {
                        translation = translation + '\u3002';
                    }
                }
            }
            tdoc.insertString(0, translation.trim(), null);
            if (AppPreferences.adjustWordSpacing) {
                this.autoAdjustSpacing();
            }
            this.targetTextPane.setCaretPosition(0);
            this.setMatchStatus();
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setExternalEditorTranslation(String translation) {
        String s = (translation = translation.trim()).toLowerCase();
        if (s.endsWith("stop")) {
            translation = translation.substring(0, translation.length() - 4).trim();
        }
        if (s.endsWith("computer")) {
            translation = translation.substring(0, translation.length() - 8).trim();
        } else if (s.endsWith("segment")) {
            translation = translation.substring(0, translation.length() - 7).trim();
        }
        try {
            String sText;
            StyledDocument sdoc = (StyledDocument)this.topui.getSourcePane().getDocument();
            int slen = sdoc.getLength();
            Document tdoc = this.targetTextPane.getDocument();
            int tlen = tdoc.getLength();
            if (tlen > 0) {
                tdoc.remove(0, tlen);
            }
            if (slen > 0 && (translation = XMLHelper.replacePipesWithTags(sText = sdoc.getText(0, slen), translation)).length() > 0) {
                char p2;
                char p1 = sText.charAt(slen - 1);
                if (p1 == '.' || p1 == '?' || p1 == '!') {
                    char p22 = translation.charAt(translation.length() - 1);
                    if (p1 != p22) {
                        if (!AppPreferences.noWordSeparatorTargetLanguage) {
                            translation = translation + p1;
                        } else if (p22 != '\u3002') {
                            translation = translation + '\u3002';
                        }
                    }
                } else if (p1 == '\u3002' && p1 != (p2 = translation.charAt(translation.length() - 1))) {
                    if (!AppPreferences.noWordSeparatorTargetLanguage) {
                        if (p2 != '.' && p2 != '!' && p2 != '?') {
                            translation = translation + ".";
                        }
                    } else {
                        translation = translation + '\u3002';
                    }
                }
            }
            tdoc.insertString(0, translation.trim(), null);
            if (AppPreferences.adjustWordSpacing) {
                this.autoAdjustSpacing();
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    MyUndoListener getUndoHandler() {
        return this.undoHandler;
    }

    public void highlightWord(final String word) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ TargetView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    StyledDocument sdoc = this.this$0.targetTextPane.getStyledDocument();
                    String text = sdoc.getText(0, sdoc.getLength());
                    if (text.length() > word.length()) {
                        Pattern p = Pattern.compile(word, 2);
                        Matcher ma = p.matcher(text);
                        while (ma.find()) {
                            int s = ma.start();
                            int e = ma.end();
                            sdoc.setCharacterAttributes(s, e - s, this.this$0.targetTextPane.getStyle("highlight"), false);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public JPopupMenu getToolPopup() {
        return this.toolPop;
    }

    private void setToolPopup() {
        this.toolPop = new JPopupMenu();
        this.toolPop.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.toolPop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TargetView.this.toolPop.removeAll();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                TargetView.this.toolPop.removeAll();
            }
        });
    }

    public void showToolsPopup(Component comp, int xx, int yy, boolean contexBar) {
        int ws;
        String word;
        String sel;
        JTextPane textPane = (JTextPane)comp;
        int pos = textPane.getCaretPosition();
        int x = comp.getX();
        int y = comp.getY();
        if (xx != -1 && yy != -1) {
            x = xx;
            y = yy;
            Point p = new Point(x, y);
            pos = textPane.viewToModel2D(p);
        } else {
            try {
                Rectangle2D rec = textPane.modelToView2D(pos);
                x = (int)rec.getX();
                y = (int)rec.getY();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (contexBar) {
            this.toolPop.add(this.topui.getContextToolBar());
        }
        if ((sel = textPane.getSelectedText()) != null) {
            word = sel;
            ws = textPane.getSelectionStart();
        } else {
            int wss = -1;
            String wword = null;
            StyledDocument doc = textPane.getStyledDocument();
            if (pos == 0 && doc.getLength() > 0) {
                pos = 1;
            }
            try {
                int wee;
                while (pos > 0 && (wword = doc.getText(wss = Utilities.getWordStart(textPane, pos), (wee = Utilities.getWordEnd(textPane, pos)) - wss)).trim().length() <= 0) {
                    --pos;
                }
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            word = wword;
            ws = wss;
        }
        if (word != null && (word = word.trim()).length() > 0) {
            HunSpellChecker checker;
            boolean spellcheck = false;
            if (AppPreferences.spellChecker == 0 && (checker = this.topui.getSpellChecker()) != null && word.indexOf(32) == -1) {
                spellcheck = checker.addPopUpMenu(this.toolPop, word, ws);
            }
            if (!spellcheck) {
                this.topui.getMemoryView().showTargetWordAlternatives(this.toolPop, word, ws);
            }
        }
        this.toolPop.show(comp, x, y + 20);
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        this.pop.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TargetView.this.targetTextPane.setFocusable(false);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TargetView.this.pop.removeAll();
                TargetView.this.topui.getResourceView().getGlossaryTip().hideInfo();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TargetView.this.targetTextPane.setFocusable(true);
                        if (!TargetView.this.targetTextPane.isFocusOwner()) {
                            TargetView.this.targetTextPane.requestFocusInWindow();
                        }
                    }
                });
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                TargetView.this.pop.removeAll();
                TargetView.this.topui.getResourceView().getGlossaryTip().hideInfo();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TargetView.this.targetTextPane.setFocusable(true);
                        if (!TargetView.this.targetTextPane.isFocusOwner()) {
                            TargetView.this.targetTextPane.requestFocusInWindow();
                        }
                    }
                });
            }
        });
    }

    public void showAutoTranslationPopUp(final Component comp, final int xx, final int yy, final TranslateEvent event) {
        Runnable r = new Runnable(){
            final /* synthetic */ TargetView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    String res;
                    int y;
                    int x;
                    int pos = this.this$0.targetTextPane.getCaretPosition();
                    if (xx != -1 && yy != -1) {
                        x = xx;
                        y = yy;
                    } else {
                        Rectangle2D rec = this.this$0.targetTextPane.modelToView2D(pos);
                        x = (int)rec.getX();
                        y = (int)rec.getY();
                    }
                    int ssize = Toolkit.getDefaultToolkit().getScreenSize().width;
                    int max = ssize / 3 + 200;
                    Font f = new Font(AppPreferences.mfontname, AppPreferences.mfontstyle, AppPreferences.mfontsize);
                    TranslationResult translationResult = event.getTranslationResult();
                    Object[] totalBest = translationResult.getFuzzyResult();
                    String[] result = translationResult.getAAResult();
                    int autoaccuracy = translationResult.getAAAccuracy();
                    if (autoaccuracy == 101) {
                        autoaccuracy = 100;
                    }
                    int contextaccuracy = translationResult.getContextAccuracy();
                    int no = 0;
                    FontIcon ficon = null;
                    if (result != null && (res = result[1]) != null && res.trim().length() > 0) {
                        JMenuItem item = new JMenuItem(new AbstractAction(this, result[1]){
                            final /* synthetic */ 26 this$1;
                            {
                                this.this$1 = this$1;
                                super(arg0);
                            }

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                String com = a.getActionCommand();
                                String source = this.this$1.this$0.topui.getSourcePane().getText();
                                if (AppPreferences.autonumbers && !event.hasTagsTransferred()) {
                                    com = NumbersHelper.autoTransfer(source, com);
                                }
                                try {
                                    if (AppPreferences.matchesToClipboard) {
                                        this.this$1.this$0.topui.getResourceView().addStringToClipboard(com);
                                    } else {
                                        if (AppPreferences.autotags && !event.hasTagsTransferred()) {
                                            com = this.this$1.this$0.topui.getMatchBoard().transferSegmentTags(source, com, event);
                                        }
                                        com = this.this$1.this$0.topui.getMatchBoard().matchHiddenNontranslatables(com);
                                        int len = this.this$1.this$0.document.getLength();
                                        if (len > 0) {
                                            this.this$1.this$0.document.remove(0, len);
                                        }
                                        this.this$1.this$0.document.insertString(0, com, null);
                                    }
                                    this.this$1.this$0.pop.setVisible(false);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_DOWN_BOLD, (int)item.getFont().getSize(), (Color)item.getForeground());
                        item.setIcon((Icon)ficon);
                        item.setActionCommand(result[1]);
                        char sh = Character.forDigit(++no, 10);
                        item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                        String acc = contextaccuracy > 100 ? "<td align=center width=10% style='color:white; background-color:" + Colors.colorTRHTML + ";  font-size:" + AppPreferences.UIFontSizeHTML + "'><b>" + contextaccuracy + "%</b><br>Context match</td>" : (contextaccuracy == 100 ? "<td align=center width=10% style='color:white; background-color:" + Colors.colorTRHTML + ";  font-size:" + AppPreferences.UIFontSizeHTML + "'><b>" + contextaccuracy + "%</b><br>Exact match</td>" : "<td align=center width=10% style='color:white; background-color:" + Colors.colorTRHTML + ";  font-size:" + AppPreferences.UIFontSizeHTML + "'><b>" + autoaccuracy + "%</b><br>Assembled</td>");
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html><body color=");
                        sb.append(HTMLFormat.htmlForegroundColor);
                        sb.append(" bgcolor=");
                        sb.append(HTMLFormat.htmlBackgroundColor);
                        sb.append(" width=").append(max).append("><table width=100% CELLPADDING=5 CELLSPACING=5><tr><td style='border-width: 1px; border-style: solid; border-color: #9E9E9E'>").append(result[0]).append("</td>").append(acc).append("</tr></table></body></html>");
                        item.setText(sb.toString());
                        item.setFont(f);
                        this.this$0.pop.add(item);
                    }
                    for (int i = 0; i < totalBest.length; ++i) {
                        Object object = totalBest[i];
                        if (object == null) continue;
                        StringBuffer sb = new StringBuffer();
                        sb.append("<tr>");
                        sb.append("<td valign=top width=45% style='border-width: 1px; border-style: solid; border-color: #9E9E9E'>");
                        Object[] arr = (Object[])object;
                        Integer oi = (Integer)arr[0];
                        int pro = oi;
                        String proc = Integer.toString(pro);
                        String fuzzyEntry = (String)arr[2];
                        boolean pref = (Boolean)arr[4];
                        String tmName = (String)arr[8];
                        String fuzzyKeyHTML = (String)arr[10];
                        if (!pref) {
                            sb.append("<p>");
                            sb.append(fuzzyKeyHTML);
                            sb.append("</p>");
                        }
                        sb.append("</td>");
                        sb.append("<td valign=top width=45% style='border-width: 1px; border-style: solid; border-color: #9E9E9E'>");
                        sb.append(fuzzyEntry);
                        sb.append("</td>");
                        sb.append("<td align=center width=10% style='color:white; background-color:#0074CC;  font-size:").append(AppPreferences.UIFontSizeHTML).append("'><b>").append(proc).append("%</b><br>").append(tmName).append("</td>");
                        sb.append("</tr>");
                        String HTMLDisplay = sb.toString();
                        JMenuItem item = new JMenuItem(new AbstractAction(this, fuzzyEntry){
                            final /* synthetic */ 26 this$1;
                            {
                                this.this$1 = this$1;
                                super(arg0);
                            }

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                String com = a.getActionCommand();
                                String source = this.this$1.this$0.topui.getSourcePane().getText();
                                if (AppPreferences.autonumbers) {
                                    com = NumbersHelper.autoTransfer(source, com);
                                }
                                try {
                                    if (AppPreferences.matchesToClipboard) {
                                        this.this$1.this$0.topui.getResourceView().addStringToClipboard(com);
                                    } else {
                                        if (AppPreferences.autotags) {
                                            com = this.this$1.this$0.topui.getMatchBoard().transferSegmentTags(source, com, event);
                                        }
                                        com = this.this$1.this$0.topui.getMatchBoard().matchHiddenNontranslatables(com);
                                        int len = this.this$1.this$0.document.getLength();
                                        if (len > 0) {
                                            this.this$1.this$0.document.remove(0, len);
                                        }
                                        this.this$1.this$0.document.insertString(0, com, null);
                                        this.this$1.this$0.pop.setVisible(false);
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                        if (ficon == null) {
                            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_DOWN_BOLD, (int)item.getFont().getSize(), (Color)item.getForeground());
                        }
                        item.setIcon((Icon)ficon);
                        item.setActionCommand(fuzzyEntry);
                        char sh = Character.forDigit(++no, 10);
                        item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                        StringBuilder sbb = new StringBuilder();
                        sbb.append("<html><body color=");
                        sbb.append(HTMLFormat.htmlForegroundColor);
                        sbb.append(" bgcolor=");
                        sbb.append(HTMLFormat.htmlBackgroundColor);
                        sbb.append(" width=").append(max).append("><table width=100% CELLPADDING=5 CELLSPACING=5>").append(HTMLDisplay).append("</table></body></html>");
                        item.setText(sbb.toString());
                        item.setFont(f);
                        this.this$0.pop.add(item);
                    }
                    if (this.this$0.pop.getComponentCount() > 0) {
                        this.this$0.pop.show(comp, x, y);
                        this.this$0.pop.dispatchEvent(new KeyEvent(this.this$0.pop, 401, 0L, 0, 40, '\u0000'));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        r.run();
    }

    public void showMatchesPopUp(final Component comp, final int xx, final int yy, final String AAindex) {
        TranslateEvent event;
        if (this.pop.isVisible()) {
            this.pop.setVisible(false);
        }
        if ((event = this.topui.getMemoryView().getTranslateEvent()) == null) {
            return;
        }
        final TranslationResult translationResult = event.getTranslationResult();
        if (translationResult == null) {
            return;
        }
        final int resCount = event.getResultCount();
        Runnable r = new Runnable(){
            final /* synthetic */ TargetView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    int y;
                    int x;
                    if (xx != -1 && yy != -1) {
                        x = xx;
                        y = yy;
                    } else {
                        int pos = this.this$0.targetTextPane.getCaretPosition();
                        Rectangle2D rec = this.this$0.targetTextPane.modelToView2D(pos);
                        x = (int)rec.getX();
                        y = (int)rec.getY();
                    }
                    Map mmap = translationResult.getMatchesMap();
                    int no = 0;
                    boolean colorRow = false;
                    JMenu nextMatches = null;
                    char letter = '\u0000';
                    Font font = new Font(AppPreferences.mfontname, AppPreferences.mfontstyle, AppPreferences.mfontsize);
                    FontIcon ficon = null;
                    if (mmap != null && !mmap.isEmpty()) {
                        int resultCount;
                        String key;
                        Iterator it;
                        ArrayList list = new ArrayList(this.this$0.topui.getMatchBoard().getSortedMatches());
                        if (AAindex != null && AAindex.length() > 0) {
                            it = list.iterator();
                            while (it.hasNext()) {
                                key = it.next().toString().trim();
                                if (key.toUpperCase().startsWith(AAindex.toUpperCase())) continue;
                                it.remove();
                            }
                            resultCount = list.size();
                        } else {
                            resultCount = resCount;
                        }
                        it = list.iterator();
                        while (it.hasNext()) {
                            key = it.next().toString();
                            if (key.length() <= 0) continue;
                            char a = Character.toUpperCase(key.charAt(0));
                            Set targets = (Set)mmap.get(key);
                            for (FragmentMatch fmatch : targets) {
                                String value = fmatch.getTarget();
                                String resourceName = fmatch.getResourceName();
                                if (resourceName == null) {
                                    resourceName = "New";
                                }
                                if (resourceName.length() > 15) {
                                    resourceName = resourceName.substring(0, 12) + "...";
                                }
                                String matchType = fmatch.getMatchType();
                                int rt = fmatch.getResourceType();
                                int w = fmatch.getWeight();
                                if (AAindex == null && w < 3 && (rt == 1 && !AppPreferences.matchBoardShowFuzzyFragments || rt > 1 && !AppPreferences.matchBoardShowFuzzyTerms)) continue;
                                JMenuItem item = new JMenuItem(new AbstractAction(key){

                                    @Override
                                    public void actionPerformed(ActionEvent a) {
                                        String f;
                                        String value = a.getActionCommand();
                                        int cpos = this$0.targetTextPane.getCaretPosition();
                                        JMenuItem item = (JMenuItem)a.getSource();
                                        String key = item.getName();
                                        if (!(!AppPreferences.caseAdaptation || AppPreferences.caseAdaptationSentence && cpos != 0 || (f = XMLHelper.adaptCase(key, value)).equals(value))) {
                                            value = f;
                                        }
                                        if (value.length() == 0) {
                                            value = key;
                                        }
                                        try {
                                            if (AppPreferences.matchesToClipboard) {
                                                this$0.topui.getResourceView().addStringToClipboard(value);
                                            } else {
                                                String sel;
                                                if (AppPreferences.autotags) {
                                                    String sourceSegment = this$0.topui.getSourcePane().getText();
                                                    String targetSegment = this$0.topui.getTargetPane().getText();
                                                    HashMap stagMap = new HashMap(8);
                                                    sourceSegment = XMLHelper.shrinkTags(sourceSegment, stagMap);
                                                    if (!stagMap.isEmpty()) {
                                                        HashMap ttagMap = new HashMap(8);
                                                        XMLHelper.shrinkTags(targetSegment, ttagMap);
                                                        value = this$0.topui.getMatchBoard().transferTags(0, sourceSegment, key, value, stagMap, ttagMap.keySet(), false);
                                                    }
                                                }
                                                if ((sel = this$0.targetTextPane.getSelectedText()) != null) {
                                                    int ss = this$0.targetTextPane.getSelectionStart();
                                                    int se = this$0.targetTextPane.getSelectionEnd();
                                                    this$0.document.remove(ss, se - ss);
                                                    cpos = this$0.targetTextPane.getCaretPosition();
                                                }
                                                this$0.document.insertString(cpos, value, null);
                                                if (AppPreferences.adjustWordSpacing) {
                                                    this$0.autoAdjustSpacing();
                                                }
                                                this$0.setCafeTranTargetTextExternal();
                                            }
                                            this$0.pop.setVisible(false);
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                        }
                                    }
                                });
                                item.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                                int ssize = Toolkit.getDefaultToolkit().getScreenSize().width;
                                int max = ssize / 3 + 200;
                                item.setActionCommand(value);
                                item.setName(key);
                                item.putClientProperty("match", fmatch);
                                boolean nmenu = false;
                                int count = 0;
                                if (resultCount > 20) {
                                    if (a != letter) {
                                        nmenu = true;
                                    }
                                    letter = a;
                                    if (nextMatches != null) {
                                        count = nextMatches.getMenuComponentCount();
                                    }
                                } else {
                                    count = -1;
                                }
                                if (count == 0 || count == 20 || nmenu || no == 20) {
                                    String alphabet = "" + a;
                                    nextMatches = null;
                                    if (AppPreferences.noWordSeparatorSourceLanguage && nmenu) {
                                        int cc = this.this$0.pop.getComponentCount();
                                        for (int i = 0; i < cc; ++i) {
                                            Component comp2 = this.this$0.pop.getComponent(i);
                                            String name = comp2.getName();
                                            if (name == null || !name.equals(alphabet)) continue;
                                            nextMatches = (JMenu)comp2;
                                            break;
                                        }
                                    }
                                    no = 0;
                                    if (nextMatches == null) {
                                        nextMatches = new JMenu();
                                        if (ficon == null) {
                                            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_DOWN_BOLD, (int)nextMatches.getFont().getSize(), (Color)nextMatches.getForeground());
                                        }
                                        nextMatches.setIcon((Icon)ficon);
                                        nextMatches.setForeground(Color.BLUE);
                                        Font f = nextMatches.getFont();
                                        nextMatches.setFont(f.deriveFont(1));
                                        nextMatches.setText(alphabet);
                                        nextMatches.setName(alphabet);
                                        this.this$0.pop.add(nextMatches);
                                    }
                                }
                                if (++no < 10) {
                                    char sh = Character.forDigit(no, 10);
                                    item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                                } else if (no == 10) {
                                    char sh = Character.forDigit(0, 10);
                                    item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                                } else if (no < 20) {
                                    int no2 = no - 10;
                                    char sh = Character.forDigit(no2, 10);
                                    item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 128));
                                } else if (no == 20) {
                                    char sh = Character.forDigit(0, 10);
                                    item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 128));
                                }
                                String h = rt == 1 ? Colors.colorMemoryHTML : (rt == 2 ? Colors.colorGlossaryHTML : Colors.colorResourcesHTML);
                                StringBuilder sb = new StringBuilder();
                                sb.append("<html><body color=");
                                sb.append(HTMLFormat.htmlForegroundColor);
                                sb.append(" bgcolor=");
                                sb.append(HTMLFormat.htmlBackgroundColor);
                                if (!colorRow) {
                                    sb.append(" width=").append(max).append("><table width=100% CELLPADDING=4 CELLSPACING=0><tr>").append("<TD WIDTH=35% BORDER=0 VALIGN=CENTER ALIGN=LEFT>").append(key).append("</td>").append("<TD WIDTH=35% BORDER=0 VALIGN=CENTER ALIGN=LEFT>").append(value).append("</td><td nowrap valign=top width=15% style=\"color:white; background-color:" + h + "\" align=left>").append(matchType).append("</td><td nowrap valign=top width=15% style=\"color:white; background-color:" + h + "\" align=left>").append(resourceName).append("</td></tr></table></body></html>");
                                } else {
                                    sb.append(" width=").append(max).append("><table width=100% CELLPADDING=4 CELLSPACING=0><tr>").append("<TD WIDTH=35% BORDER=0 VALIGN=CENTER ALIGN=LEFT>").append(key).append("</td>").append("<TD WIDTH=35% BORDER=0 VALIGN=CENTER ALIGN=LEFT>").append(value).append("</td><td nowrap valign=top width=15% style=\"color:white; background-color:" + h + "\" align=left> ").append(matchType).append("</td><td nowrap valign=top width=15% style=\"color:white; background-color:" + h + "\" align=left> ").append(resourceName).append("</td></tr></table></body></html>");
                                }
                                colorRow = !colorRow;
                                item.setText(sb.toString());
                                item.setFont(font);
                                if (nextMatches != null) {
                                    nextMatches.add(item);
                                    continue;
                                }
                                this.this$0.pop.add(item);
                            }
                        }
                    }
                    if (this.this$0.pop.getComponentCount() > 0) {
                        this.this$0.pop.show(comp, x, y);
                        if (AAindex == null) {
                            this.this$0.pop.dispatchEvent(new KeyEvent(this.this$0.pop, 401, 0L, 0, 40, '\u0000'));
                        } else {
                            JComponent comp3 = (JComponent)this.this$0.pop.getComponent(0);
                            MouseEvent event = new MouseEvent(comp3, 504, 0L, 0, 0, 0, 0, false);
                            comp3.dispatchEvent(event);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        r.run();
    }

    public void showPlaceablesPopUp(final Component comp, final int xx, final int yy) {
        Runnable r = new Runnable(){
            final /* synthetic */ TargetView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Workflow flow = this.this$0.topui.getWorkflowView().getWorkflowManager().getWorkflow();
                if (flow != null) {
                    try {
                        int y;
                        int x;
                        final List plist = flow.getPlaceables();
                        if (plist == null || plist.isEmpty()) {
                            return;
                        }
                        int pos = this.this$0.targetTextPane.getCaretPosition();
                        if (xx != -1 && yy != -1) {
                            x = xx;
                            y = yy;
                        } else {
                            Rectangle2D rec = this.this$0.targetTextPane.modelToView2D(pos);
                            x = (int)rec.getX();
                            y = (int)rec.getY();
                        }
                        int no = 1;
                        int accel = 1;
                        FontIcon ficon = null;
                        int offset = 0;
                        HashSet<String> set = new HashSet<String>();
                        Iterator it = plist.iterator();
                        while (it.hasNext()) {
                            char sh;
                            Object[] o = (Object[])it.next();
                            String key = o[1].toString();
                            int len = key.length();
                            int off = (Integer)o[0];
                            if (set.contains(key)) {
                                ++no;
                                continue;
                            }
                            if (off + len <= offset) {
                                it.remove();
                                continue;
                            }
                            set.add(key);
                            offset = off + len;
                            String ckey = Placeables.getConvertedPlaceable(key);
                            if (ckey == null) {
                                String t;
                                String rep;
                                if (AppPreferences.replaceAtTransfer && !(rep = WorkflowView.replaceCharacters(key)).equals(key)) {
                                    ckey = rep;
                                }
                                if (AppPreferences.formatnumbers && ckey == null && (t = NumbersHelper.formatLocaleNumber(key)) != null) {
                                    ckey = t;
                                }
                            }
                            if (ckey != null) {
                                key = ckey;
                            }
                            JMenuItem item = new JMenuItem(new AbstractAction(this, key){
                                final /* synthetic */ 28 this$1;
                                {
                                    this.this$1 = this$1;
                                    super(arg0);
                                }

                                @Override
                                public void actionPerformed(ActionEvent a) {
                                    int mod = a.getModifiers();
                                    String com = a.getActionCommand();
                                    int ind = Integer.parseInt(com);
                                    Object[] o = (Object[])plist.get(ind);
                                    try {
                                        if (plist.size() > 0) {
                                            plist.remove(o);
                                        }
                                        String key = o[1].toString();
                                        if ((mod & 2) != 2) {
                                            String ckey = Placeables.getConvertedPlaceable(key);
                                            if (ckey == null) {
                                                String t;
                                                String rep;
                                                if (AppPreferences.replaceAtTransfer && !(rep = WorkflowView.replaceCharacters(key)).equals(key)) {
                                                    ckey = rep;
                                                }
                                                if (AppPreferences.formatnumbers && ckey == null && (t = NumbersHelper.formatLocaleNumber(key)) != null) {
                                                    ckey = t;
                                                }
                                            }
                                            if (ckey != null) {
                                                key = ckey;
                                            }
                                        }
                                        int cpos = this.this$1.this$0.targetTextPane.getCaretPosition();
                                        String sel = this.this$1.this$0.targetTextPane.getSelectedText();
                                        if (sel != null) {
                                            int ss = this.this$1.this$0.targetTextPane.getSelectionStart();
                                            int se = this.this$1.this$0.targetTextPane.getSelectionEnd();
                                            this.this$1.this$0.document.remove(ss, se - ss);
                                            cpos = this.this$1.this$0.targetTextPane.getCaretPosition();
                                        }
                                        if (AppPreferences.autotags) {
                                            String sourceSegment = this.this$1.this$0.topui.getSourcePane().getText();
                                            String targetSegment = this.this$1.this$0.topui.getTargetPane().getText();
                                            HashMap stagMap = new HashMap(8);
                                            sourceSegment = XMLHelper.shrinkTags(sourceSegment, stagMap);
                                            if (!stagMap.isEmpty()) {
                                                HashMap tagMap = new HashMap(8);
                                                XMLHelper.shrinkTags(targetSegment, tagMap);
                                                key = this.this$1.this$0.topui.getMatchBoard().transferTags(0, sourceSegment, key, key, stagMap, tagMap.keySet(), false);
                                            }
                                        }
                                        this.this$1.this$0.document.insertString(cpos, key, null);
                                        this.this$1.this$0.pop.setVisible(false);
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            });
                            Font f = this.this$0.targetTextPane.getFont();
                            float fs = AppPreferences.toolBarButtonsFontSize;
                            item.setFont(f.deriveFont(fs));
                            int max = 150;
                            item.setActionCommand(Integer.toString(no - 1));
                            if (ficon == null) {
                                ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_DOWN_BOLD, (int)item.getFont().getSize(), (Color)item.getForeground());
                            }
                            item.setIcon((Icon)ficon);
                            if (accel < 10) {
                                sh = Character.forDigit(accel, 10);
                                item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                            } else if (no == 10) {
                                sh = Character.forDigit(0, 10);
                                item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                            }
                            ++no;
                            ++accel;
                            int splen = key.trim().length();
                            if (splen == 0) {
                                splen = key.length();
                                String ch = " whitespace";
                                key = splen + ch;
                            }
                            if (key.length() > max) {
                                key = key.substring(0, max) + "...";
                            }
                            item.setText(key);
                            if (accel > 2) {
                                this.this$0.pop.addSeparator();
                            }
                            this.this$0.pop.add(item);
                            if (accel != 31) continue;
                            break;
                        }
                        if (this.this$0.pop.getComponentCount() > 0) {
                            this.this$0.pop.show(comp, x, y);
                            this.this$0.pop.dispatchEvent(new KeyEvent(this.this$0.pop, 401, 0L, 0, 40, '\u0000'));
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        };
        r.run();
    }

    public void showTagsPopUp(Component comp, int xx, int yy) {
        Workflow flow = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
        if (flow != null) {
            try {
                int y;
                int x;
                int pos = this.targetTextPane.getCaretPosition();
                if (xx != -1 && yy != -1) {
                    x = xx;
                    y = yy;
                } else {
                    Rectangle2D rec = this.targetTextPane.modelToView2D(pos);
                    x = (int)rec.getX();
                    y = (int)rec.getY();
                }
                final List plist = flow.getTags();
                int no = 1;
                int accel = 1;
                if (plist != null && !plist.isEmpty()) {
                    FontIcon ficon = null;
                    for (Object[] o : plist) {
                        XLIFF xliff;
                        Integer integ = (Integer)o[0];
                        String tagNo = Integer.toString(integ);
                        String key = o[1].toString();
                        JMenuItem item = new JMenuItem(new AbstractAction(this, key){
                            final /* synthetic */ TargetView this$0;
                            {
                                this.this$0 = this$0;
                                super(arg0);
                            }

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                JMenuItem item = (JMenuItem)a.getSource();
                                Object[] o = (Object[])item.getClientProperty("tagObject");
                                try {
                                    if (plist.size() > 1) {
                                        plist.remove(o);
                                        plist.add(o);
                                    }
                                    String key = o[1].toString();
                                    int cpos = this.this$0.targetTextPane.getCaretPosition();
                                    this.this$0.document.putProperty("notags", true);
                                    Style style = this.this$0.document.getStyle("Tags");
                                    Integer integ = (Integer)o[0];
                                    String tagNo = Integer.toString(integ);
                                    if (tagNo != null) {
                                        Project project;
                                        String n;
                                        if (!AppPreferences.hideTagDetails && (n = (project = this.this$0.topui.getProjectView().getProject()).getTagsXML(key, true)) != null && n.length() > 0) {
                                            tagNo = tagNo + " " + n;
                                        }
                                        JLabel label = new JLabel(tagNo);
                                        label.setHorizontalTextPosition(0);
                                        label.setOpaque(false);
                                        Font font = this.this$0.topui.getTargetPane().getFont();
                                        font = font.deriveFont(1, AppPreferences.tagsfontsize);
                                        label.setFont(font);
                                        if (key.indexOf("xntr") != -1) {
                                            label.setForeground(new Color(AppPreferences.placeablesColor));
                                        } else {
                                            label.setForeground(new Color(AppPreferences.tagColor));
                                        }
                                        StyleConstants.setComponent(style, label);
                                    }
                                    this.this$0.document.insertString(cpos, key, style);
                                    this.this$0.document.putProperty("notags", null);
                                    this.this$0.pop.setVisible(false);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                        Font f = this.targetTextPane.getFont();
                        float fs = AppPreferences.toolBarButtonsFontSize;
                        item.setFont(f.deriveFont(fs));
                        item.putClientProperty("tagObject", o);
                        int max = 150;
                        if (ficon == null) {
                            ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_DOWN_BOLD, (int)item.getFont().getSize(), (Color)item.getForeground());
                        }
                        item.setIcon((Icon)ficon);
                        if (accel < 10) {
                            char sh = Character.forDigit(accel, 10);
                            item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                        } else if (no == 10) {
                            char sh = Character.forDigit(0, 10);
                            item.setAccelerator(KeyStroke.getKeyStroke((int)sh, 0));
                        }
                        ++no;
                        ++accel;
                        Project project = this.topui.getProjectView().getProject();
                        String stag = project.getTagsXML(key, true);
                        if (stag == null || stag.length() == 0) {
                            stag = "tag";
                        }
                        if ((xliff = project.getXLIFF()) != null && xliff.isCafeTranXLIFF) {
                            if (stag.length() > 150) {
                                item.setText(tagNo + " tag");
                                item.setToolTipText(stag);
                            } else {
                                item.setText(tagNo + " " + stag);
                            }
                        } else if (stag.length() > 150) {
                            item.setText(tagNo + " tag");
                            item.setToolTipText(stag);
                        } else {
                            item.setText(tagNo + " " + stag);
                        }
                        if (accel > 2) {
                            this.pop.addSeparator();
                        }
                        this.pop.add(item);
                        if (accel != 31) continue;
                        break;
                    }
                }
                if (this.pop.getComponentCount() > 0) {
                    this.pop.show(comp, x, y);
                    this.pop.dispatchEvent(new KeyEvent(this.pop, 401, 0L, 0, 40, '\u0000'));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int startTagPostion(String text) {
        int k;
        int i = text.lastIndexOf("<");
        if (i == -1 || i >= text.length() - 1) return -1;
        char j = text.charAt(i + 1);
        if (j != 'x' && j != '/' && j != 'b' && j != 'i' && j != 'u' && j != 's' && j != 'r' && j != 'm') return -1;
        if (i <= 0) return i;
        String s = text.substring(i);
        if (s.indexOf(62) != -1) {
            return -1;
        }
        char c = text.charAt(i - 1);
        while (c == '>' && (k = (text = text.substring(0, i - 1)).lastIndexOf("<")) != -1 && k < text.length() - 1 && ((j = text.charAt(k + 1)) == 'x' || j == '/') && (s = text.substring(k)).indexOf(62) == -1 && (i = k) > 0) {
            c = text.charAt(i - 1);
        }
        return i;
    }

    private int endTagPostion(int off, String text) {
        int i = text.indexOf(">", off);
        if (i != -1 && i < text.length() - 1) {
            char c = text.charAt(i + 1);
            while (c == '<') {
                int k = i + 1;
                if ((k = text.indexOf(">", k)) == -1 || (i = k) >= text.length() - 1) break;
                c = text.charAt(i + 1);
            }
        }
        return i;
    }

    public void removeDefinedCharacters() {
        try {
            String fulltext;
            String text;
            Document doc = this.targetTextPane.getDocument();
            int len = doc.getLength();
            if (len > 0 && (text = XMLHelper.removeChars(fulltext = doc.getText(0, len))).length() > 0) {
                doc.remove(0, len);
                doc.insertString(0, text, null);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void removeDefinedCharactersToLeft() {
        try {
            Document doc = this.targetTextPane.getDocument();
            int pos = this.targetTextPane.getCaretPosition();
            int len = doc.getLength();
            if (len > 0 && pos > 0) {
                String s = doc.getText(0, len);
                String s1 = s.substring(0, pos);
                String s2 = s.substring(pos);
                String text = XMLHelper.removeLastOnlyChars(s1);
                if (text != null && text.length() > 0) {
                    doc.remove(0, len);
                    doc.insertString(0, text + s2, null);
                    int pos2 = pos - (s1.length() - text.length());
                    this.targetTextPane.setCaretPosition(pos2);
                }
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setTargetProtection(boolean protect) {
        if (protect) {
            if (this.protectedDoc == null) {
                this.protectedDoc = new ProtectedDocument(this.targetTextPane);
            }
        } else {
            if (this.protectedDoc != null) {
                this.protectedDoc.removeProtection();
            }
            this.protectedDoc = null;
        }
    }

    public void trackChanges(boolean tc) {
        if (this.protectedDoc != null) {
            this.protectedDoc.trackChanges(tc);
        }
    }

    public void protectTags(int from, int to) {
        if (this.protectedDoc != null) {
            this.protectedDoc.protect(from, to);
        }
    }

    public void resetTagProtection() {
        if (this.protectedDoc != null) {
            this.protectedDoc.reset();
        }
    }

    public void removeTags() {
        try {
            Document doc = this.targetTextPane.getDocument();
            int len = doc.getLength();
            if (len > 0) {
                String text = doc.getText(0, len);
                if ((text = XMLHelper.parseTags(text)).length() > 0) {
                    doc.remove(0, len);
                    doc.insertString(0, text, null);
                    this.targetTextPane.setCaretPosition(0);
                }
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void deleteToSegmentEnd() {
        int pos = this.targetTextPane.getCaretPosition();
        if (pos != -1) {
            try {
                String text;
                int delLen;
                Document doc = this.targetTextPane.getDocument();
                int len = doc.getLength();
                if (len > 0 && (delLen = (text = doc.getText(pos, len - pos)).length()) > 0) {
                    char c = text.charAt(delLen - 1);
                    if (this.isPunctuation(c)) {
                        --len;
                    }
                    doc.remove(pos, len - pos);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void formatSelectedText(char ch) {
        if (ch == 'b' || ch == 'i' || ch == 'u' || ch == 's' || ch == 'r' || ch == 'm') {
            StyledDocument doc = this.targetTextPane.getStyledDocument();
            Font font = this.targetTextPane.getFont();
            Font f = font.deriveFont(1, AppPreferences.tagsfontsize);
            Style nstyle = doc.getStyle("Tags");
            JLabel label = new JLabel(Character.toString(ch));
            label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
            label.setHorizontalTextPosition(0);
            label.setOpaque(false);
            label.setFont(f);
            label.setForeground(new Color(AppPreferences.tagColor));
            StyleConstants.setComponent(nstyle, label);
            String sel = this.targetTextPane.getSelectedText();
            int end = 0;
            try {
                doc.putProperty("notags", true);
                if (ch == 'b') {
                    int start = this.targetTextPane.getSelectionStart();
                    doc.insertString(start, "<b>", nstyle);
                    end = this.targetTextPane.getSelectionEnd();
                    JLabel label2 = new JLabel(Character.toString(ch));
                    label2.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                    label2.setHorizontalTextPosition(0);
                    label2.setOpaque(false);
                    f = font.deriveFont(3, AppPreferences.tagsfontsize);
                    label2.setFont(f);
                    label2.setForeground(new Color(AppPreferences.tagColor));
                    StyleConstants.setComponent(nstyle, label2);
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    doc.insertString(end, "</b>", nstyle);
                } else if (ch == 'i') {
                    int start = this.targetTextPane.getSelectionStart();
                    doc.insertString(start, "<i>", nstyle);
                    end = this.targetTextPane.getSelectionEnd();
                    JLabel label2 = new JLabel(Character.toString(ch));
                    label2.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                    label2.setHorizontalTextPosition(0);
                    label2.setOpaque(false);
                    f = font.deriveFont(3, AppPreferences.tagsfontsize);
                    label2.setFont(f);
                    label2.setForeground(new Color(AppPreferences.tagColor));
                    StyleConstants.setComponent(nstyle, label2);
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    doc.insertString(end, "</i>", nstyle);
                } else if (ch == 'u') {
                    int start = this.targetTextPane.getSelectionStart();
                    doc.insertString(start, "<u>", nstyle);
                    end = this.targetTextPane.getSelectionEnd();
                    JLabel label2 = new JLabel(Character.toString(ch));
                    label2.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                    label2.setHorizontalTextPosition(0);
                    label2.setOpaque(false);
                    f = font.deriveFont(3, AppPreferences.tagsfontsize);
                    label2.setFont(f);
                    label2.setForeground(new Color(AppPreferences.tagColor));
                    StyleConstants.setComponent(nstyle, label2);
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    doc.insertString(end, "</u>", nstyle);
                } else if (ch == 's') {
                    int start = this.targetTextPane.getSelectionStart();
                    doc.insertString(start, "<sub>", nstyle);
                    end = this.targetTextPane.getSelectionEnd();
                    JLabel label2 = new JLabel(Character.toString(ch));
                    label2.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                    label2.setHorizontalTextPosition(0);
                    label2.setOpaque(false);
                    f = font.deriveFont(3, AppPreferences.tagsfontsize);
                    label2.setFont(f);
                    label2.setForeground(new Color(AppPreferences.tagColor));
                    StyleConstants.setComponent(nstyle, label2);
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    doc.insertString(end, "</sub>", nstyle);
                } else if (ch == 'r') {
                    int start = this.targetTextPane.getSelectionStart();
                    doc.insertString(start, "<sup>", nstyle);
                    end = this.targetTextPane.getSelectionEnd();
                    JLabel label2 = new JLabel(Character.toString(ch));
                    label2.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                    label2.setHorizontalTextPosition(0);
                    label2.setOpaque(false);
                    f = font.deriveFont(3, AppPreferences.tagsfontsize);
                    label2.setFont(f);
                    label2.setForeground(new Color(AppPreferences.tagColor));
                    StyleConstants.setComponent(nstyle, label2);
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    doc.insertString(end, "</sup>", nstyle);
                } else if (ch == 'm') {
                    int start = this.targetTextPane.getSelectionStart();
                    doc.insertString(start, "<mark>", nstyle);
                    end = this.targetTextPane.getSelectionEnd();
                    JLabel label2 = new JLabel(Character.toString(ch));
                    label2.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                    label2.setHorizontalTextPosition(0);
                    label2.setOpaque(false);
                    f = font.deriveFont(3, AppPreferences.tagsfontsize);
                    label2.setFont(f);
                    label2.setForeground(new Color(AppPreferences.tagColor));
                    StyleConstants.setComponent(nstyle, label2);
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    doc.insertString(end, "</mark>", nstyle);
                }
                if (sel == null) {
                    this.targetTextPane.setCaretPosition(end);
                } else {
                    this.targetTextPane.setCaretPosition(this.targetTextPane.getCaretPosition());
                }
                doc.putProperty("notags", null);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
                doc.putProperty("notags", null);
            }
            return;
        }
    }

    public void transferCurrentTag() {
        List plist;
        String sel;
        if (this.topui.getSourceView().isPrompterActive()) {
            this.topui.getSourceView().getPrompter().closePopUp();
        }
        if ((sel = this.targetTextPane.getSelectedText()) != null && sel.length() > 0) {
            this.mouseTagPlacement(sel);
            return;
        }
        Workflow flow = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
        if (flow != null && (plist = flow.getTags()) != null && plist.size() > 0) {
            StyledDocument doc = this.targetTextPane.getStyledDocument();
            int cpos = this.targetTextPane.getCaretPosition();
            int count = 0;
            try {
                String t = doc.getText(0, cpos);
                count = AppPreferences.mergeNeighboringTags ? XMLHelper.countTagGroups(t) : XMLHelper.countTags(t);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
            }
            Object[] o = null;
            for (int i = 0; i < plist.size(); ++i) {
                Object[] object = (Object[])plist.get(i);
                Integer integ = (Integer)object[0];
                if (count + 1 != integ) continue;
                o = object;
                break;
            }
            if (o == null) {
                return;
            }
            try {
                if (plist.size() > 1) {
                    plist.remove(o);
                    plist.add(o);
                }
                Integer integ = (Integer)o[0];
                String tagNo = Integer.toString(integ);
                String key = o[1].toString();
                doc.putProperty("notags", true);
                Style style = doc.getStyle("Tags");
                if (tagNo != null) {
                    Project project;
                    String n;
                    if (!AppPreferences.hideTagDetails && (n = (project = this.topui.getProjectView().getProject()).getTagsXML(key, true)) != null && n.length() > 0) {
                        tagNo = tagNo + " " + n;
                    }
                    JLabel label = new JLabel(tagNo);
                    label.setHorizontalTextPosition(0);
                    label.setOpaque(false);
                    Font font = this.targetTextPane.getFont();
                    font = font.deriveFont(1, AppPreferences.tagsfontsize);
                    label.setFont(font);
                    if (key.indexOf("xntr") != -1) {
                        label.setForeground(new Color(AppPreferences.placeablesColor));
                    } else {
                        label.setForeground(new Color(AppPreferences.tagColor));
                    }
                    StyleConstants.setComponent(style, label);
                }
                doc.insertString(cpos, key, style);
                doc.putProperty("notags", null);
                if (!this.targetTextPane.isFocusOwner()) {
                    this.targetTextPane.requestFocusInWindow();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void mouseTagPlacement(String sel) {
        List tlist;
        Workflow flow = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
        if (flow != null && (tlist = flow.getTags()) != null && !tlist.isEmpty()) {
            JLabel label;
            Project project;
            String n;
            int cpos;
            int cpos2 = -1;
            if (sel != null) {
                cpos = this.targetTextPane.getSelectionStart();
                cpos2 = this.targetTextPane.getSelectionEnd();
            } else {
                cpos = this.targetTextPane.getCaretPosition();
            }
            Document doc = this.targetTextPane.getDocument();
            int count = 0;
            try {
                String t = doc.getText(0, cpos);
                count = AppPreferences.mergeNeighboringTags ? XMLHelper.countTagGroups(t) : XMLHelper.countTags(t);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
            }
            Object[] o = null;
            for (int i = 0; i < tlist.size(); ++i) {
                Object[] object = (Object[])tlist.get(i);
                Integer integ = (Integer)object[0];
                if (count + 1 != integ) continue;
                o = object;
                break;
            }
            if (o == null) {
                return;
            }
            if (tlist.size() > 1) {
                tlist.remove(o);
                tlist.add(o);
            }
            Integer integ = (Integer)o[0];
            String tagNo = Integer.toString(integ);
            String key = o[1].toString();
            this.document.putProperty("notags", true);
            Style style = this.document.getStyle("Tags");
            Font font = this.topui.getTargetPane().getFont();
            font = font.deriveFont(1, AppPreferences.tagsfontsize);
            Color color = key != null && key.indexOf("xntr") != -1 ? new Color(AppPreferences.placeablesColor) : new Color(AppPreferences.tagColor);
            if (tagNo != null) {
                String sid = tagNo;
                if (!AppPreferences.hideTagDetails && (n = (project = this.topui.getProjectView().getProject()).getTagsXML(key, true)) != null && n.length() > 0) {
                    sid = sid + " " + n;
                }
                label = new JLabel(sid);
                label.setHorizontalTextPosition(0);
                label.setOpaque(false);
                label.setFont(font);
                label.setForeground(color);
                StyleConstants.setComponent(style, label);
            }
            try {
                this.document.insertString(cpos, key, style);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (cpos2 > 0 && tlist.size() > 1) {
                o = null;
                for (int i = 0; i < tlist.size(); ++i) {
                    Object[] object = (Object[])tlist.get(i);
                    Integer integer = (Integer)object[0];
                    if (count + 2 != integer) continue;
                    o = object;
                    break;
                }
                if (o != null) {
                    tlist.remove(o);
                    tlist.add(o);
                    integ = (Integer)o[0];
                    tagNo = Integer.toString(integ);
                    key = o[1].toString();
                    if (tagNo != null) {
                        String sid = tagNo;
                        if (!AppPreferences.hideTagDetails && (n = (project = this.topui.getProjectView().getProject()).getTagsXML(key, true)) != null && n.length() > 0) {
                            sid = sid + " " + n;
                        }
                        label = new JLabel(sid);
                        label.setHorizontalTextPosition(0);
                        label.setOpaque(false);
                        label.setFont(font);
                        label.setForeground(color);
                        StyleConstants.setComponent(style, label);
                    }
                    cpos2 = this.targetTextPane.getSelectionEnd();
                    this.targetTextPane.setCaretPosition(cpos2);
                    try {
                        this.document.insertString(cpos2, key, style);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            this.document.putProperty("notags", null);
            if (!this.targetTextPane.isFocusOwner()) {
                this.targetTextPane.requestFocusInWindow();
            }
        }
    }

    public synchronized void transposeWords(boolean right, JTextComponent textcomp) {
        try {
            int orgcaret;
            char c;
            char cc;
            int caret;
            Document doc = textcomp.getDocument();
            String segment = doc.getText(0, doc.getLength());
            int spos1 = -1;
            int epos1 = -1;
            int spos2 = -1;
            boolean selection = false;
            int selectionLength = -1;
            String word1 = textcomp.getSelectedText();
            if (word1 != null) {
                selection = true;
            }
            if (!right && selection) {
                spos1 = textcomp.getSelectionStart();
                epos1 = textcomp.getSelectionEnd();
                caret = spos1;
            } else if (selection) {
                caret = textcomp.getSelectionEnd();
                spos2 = textcomp.getSelectionStart();
                word1 = null;
                selectionLength = caret - spos2 + 1;
            } else {
                caret = textcomp.getCaretPosition();
            }
            if (caret < segment.length() && (cc = segment.charAt(caret)) == '<') {
                if (right && selection) {
                    int ccc = segment.indexOf(62, caret);
                    if (ccc != -1) {
                        return;
                    }
                } else {
                    --caret;
                }
            }
            if (right) {
                try {
                    caret = Utilities.getNextWord(textcomp, caret);
                    cc = segment.charAt(caret);
                    if (this.isPunctuation(cc)) {
                        caret = Utilities.getNextWord(textcomp, caret);
                    }
                }
                catch (BadLocationException ex) {
                    caret = segment.length();
                }
            }
            if (caret == segment.length()) {
                if (right) {
                    return;
                }
                --caret;
            }
            if (caret < 0) {
                return;
            }
            int sseg = Utilities.getWordStart(textcomp, caret);
            if (sseg == 0) {
                caret = Utilities.getNextWord(textcomp, caret);
            } else {
                c = segment.charAt(--sseg);
                while (c == '>') {
                    for (orgcaret = sseg - 2; orgcaret >= 0 && segment.charAt(orgcaret) != '<'; --orgcaret) {
                    }
                    if (orgcaret > 0) {
                        sseg = orgcaret - 1;
                        c = segment.charAt(sseg);
                        continue;
                    }
                    sseg = 0;
                    break;
                }
                if (sseg == 0) {
                    return;
                }
            }
            if (caret < 0) {
                return;
            }
            c = '\u0000';
            while (caret != -1 && (Character.isSpaceChar(c = segment.charAt(caret)) || this.isPunctuation(c) || c == '<')) {
                --caret;
            }
            if (c == '>') {
                return;
            }
            if (caret < 0) {
                return;
            }
            if (caret > 0 && (c = segment.charAt(caret - 1)) == '>') {
                return;
            }
            if (spos1 == -1 || epos1 == -1) {
                spos1 = Utilities.getWordStart(textcomp, caret);
                epos1 = Utilities.getWordEnd(textcomp, caret);
            }
            if ((caret = spos1 - 1) < 0) {
                return;
            }
            while (caret != -1 && (Character.isSpaceChar(c = segment.charAt(caret)) || this.isPunctuation(c) || c == '<')) {
                --caret;
            }
            if (caret < 0) {
                return;
            }
            c = segment.charAt(caret);
            while (c == '>') {
                for (orgcaret = caret - 2; orgcaret >= 0 && segment.charAt(orgcaret) != '<'; --orgcaret) {
                }
                if (orgcaret > 0) {
                    caret = orgcaret - 1;
                    c = segment.charAt(caret);
                    continue;
                }
                caret = 0;
                break;
            }
            if (caret < 0) {
                return;
            }
            while (caret != -1 && (Character.isSpaceChar(c = segment.charAt(caret)) || this.isPunctuation(c) || c == '<')) {
                --caret;
            }
            if (caret < 0) {
                return;
            }
            if (spos2 == -1) {
                spos2 = Utilities.getWordStart(textcomp, caret);
            }
            if (word1 == null) {
                word1 = doc.getText(spos1, epos1 - spos1);
            }
            if (spos1 > 0) {
                c = segment.charAt(spos1 - 1);
                if (Character.isSpaceChar(c)) {
                    doc.remove(spos1 - 1, epos1 - spos1 + 1);
                } else {
                    doc.remove(spos1, epos1 - spos1);
                }
            } else {
                doc.remove(spos1, epos1 - spos1);
            }
            if (spos2 == 0) {
                c = segment.charAt(0);
                char c2 = word1.charAt(0);
                if (Character.isUpperCase(c)) {
                    word1 = word1.substring(0, 1).toUpperCase() + word1.substring(1);
                    if (Character.isLowerCase(c2)) {
                        c = Character.toLowerCase(c);
                        doc.remove(spos2, 1);
                        doc.insertString(spos2, Character.toString(c), null);
                    }
                }
            }
            doc.insertString(spos2, word1 + " ", null);
            if (selection) {
                if (!right) {
                    textcomp.setSelectionStart(spos2);
                    textcomp.setSelectionEnd(spos2 + word1.length());
                } else {
                    textcomp.setSelectionStart(spos2 + word1.length() + 1);
                    textcomp.setSelectionEnd(spos2 + word1.length() + selectionLength);
                }
            } else if (!right) {
                textcomp.setCaretPosition(spos2 + word1.length());
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void insertUnicodeCharacters(String s) {
        int cp;
        StyledDocument sdoc;
        if (this.topui.getSourcePane().isFocusOwner()) {
            sdoc = this.topui.getSourcePane().getStyledDocument();
            cp = this.topui.getSourcePane().getCaretPosition();
        } else {
            sdoc = this.targetTextPane.getStyledDocument();
            cp = this.targetTextPane.getCaretPosition();
        }
        try {
            sdoc.insertString(cp, s, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void surroundWithCharacters(String surroundChars) {
        int i;
        String prefix = null;
        String suffix = null;
        if (surroundChars.length() > 0 && (i = surroundChars.indexOf(83)) != -1) {
            prefix = surroundChars.substring(0, i);
            suffix = surroundChars.substring(i + 1);
        }
        try {
            int spos = -1;
            int epos = -1;
            String s = this.targetTextPane.getSelectedText();
            if (s != null) {
                spos = this.targetTextPane.getSelectionStart();
                epos = this.targetTextPane.getSelectionEnd();
            } else {
                int cp = this.targetTextPane.getCaretPosition();
                if (cp != -1) {
                    spos = Utilities.getWordStart(this.targetTextPane, cp);
                    epos = Utilities.getWordEnd(this.targetTextPane, cp);
                }
            }
            StyledDocument doc = this.targetTextPane.getStyledDocument();
            if (spos != -1 && prefix != null) {
                doc.insertString(spos, prefix, null);
                epos += prefix.length();
            }
            if (epos != -1 && suffix != null) {
                doc.insertString(epos, suffix, null);
                final int caretPosition = epos + suffix.length();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TargetView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.targetTextPane.setCaretPosition(caretPosition);
                    }
                });
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setCaseAdjusted(boolean b) {
        this.caseAdjusted = b;
    }

    private void autoAdjustCase() {
        this.caseAdjusted = true;
        try {
            Document sdoc = this.topui.getSourcePane().getDocument();
            int len1 = this.document.getLength();
            int len2 = sdoc.getLength();
            if (len1 > 0 && len2 > 0) {
                boolean tUpper;
                boolean sUpper;
                int n;
                int n2;
                String sourceText = sdoc.getText(0, len2);
                String targetText = this.document.getText(0, len1);
                char s = sourceText.charAt(0);
                int k = 0;
                while (s == '<' && (n2 = sourceText.indexOf(62, k)) != -1 && sourceText.length() > n2 + 1) {
                    k = ++n2;
                    s = sourceText.charAt(k);
                }
                k = 0;
                char t = targetText.charAt(0);
                while (t == '<' && (n = targetText.indexOf(62, k)) != -1 && targetText.length() > n + 1) {
                    k = ++n;
                    t = targetText.charAt(k);
                }
                if (Character.isLetter(s) && Character.isLetter(t) && (sUpper = Character.isUpperCase(s)) != (tUpper = Character.isUpperCase(t))) {
                    this.undoHandler.compoundEditEnd(false);
                    this.document.remove(k, 1);
                    this.undoHandler.compoundEditEnd(false);
                    if (sUpper) {
                        this.document.insertString(k, "" + Character.toUpperCase(t), null);
                    } else {
                        this.document.insertString(k, "" + Character.toLowerCase(t), null);
                    }
                }
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void autoAdjustSpacing() {
        try {
            char c;
            int endOff;
            char c2;
            int cpos = this.targetTextPane.getCaretPosition();
            int insOff = cpos - this.insertLength;
            boolean adjust = false;
            int docLen = this.document.getLength();
            StringBuilder text = new StringBuilder(this.document.getText(0, docLen));
            if (insOff > 0 && Character.isLetterOrDigit(c2 = text.charAt(insOff - 1))) {
                text.insert(insOff, ' ');
                ++insOff;
                adjust = true;
                ++cpos;
            }
            if (docLen > (endOff = insOff + this.insertLength) && Character.isLetterOrDigit(c = text.charAt(endOff))) {
                text.insert(endOff, ' ');
                adjust = true;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c3 = text.charAt(i);
                if (c3 == ' ') {
                    char cc;
                    String firstSourceChar;
                    if (i == 0 && (firstSourceChar = this.topui.getSourcePane().getDocument().getText(0, 1)).charAt(0) != ' ') {
                        if (i < cpos) {
                            --cpos;
                        }
                        adjust = true;
                        continue;
                    }
                    int j = i + 1;
                    if (j < text.length() && ((cc = text.charAt(j)) == ' ' || this.isPunctuation(cc) || cc == ')' || cc == ']' || cc == '}') && cc != '\"') {
                        adjust = true;
                        if (i >= cpos) continue;
                        --cpos;
                        continue;
                    }
                }
                sb.append(c3);
            }
            if (adjust) {
                if (sb.charAt(sb.length() - 1) == ' ') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                final int caretPosition = cpos;
                this.undoHandler.compoundEditEnd(false);
                this.document.remove(0, docLen);
                this.undoHandler.compoundEditEnd(false);
                this.document.insertString(0, sb.toString(), null);
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TargetView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        int len = this.this$0.document.getLength();
                        if (caretPosition < len) {
                            this.this$0.targetTextPane.setCaretPosition(caretPosition);
                        } else {
                            this.this$0.targetTextPane.setCaretPosition(len);
                        }
                    }
                });
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void adjustStartPunctuation() {
        try {
            Pattern p = Pattern.compile("\\A\\W+", 256);
            Document sdoc = this.topui.getSourcePane().getDocument();
            StyledDocument tdoc = this.targetTextPane.getStyledDocument();
            String source = sdoc.getText(0, sdoc.getLength());
            String target = tdoc.getText(0, tdoc.getLength());
            Matcher m = p.matcher(source);
            if (m.find()) {
                String f = m.group();
                String ff = "";
                m = p.matcher(target);
                if (m.find()) {
                    ff = m.group();
                }
                if (!f.equals(ff)) {
                    if (ff.length() > 0) {
                        tdoc.remove(0, ff.length());
                    }
                    tdoc.insertString(0, f, null);
                }
            } else {
                m = p.matcher(target);
                if (m.find()) {
                    String f = m.group();
                    tdoc.remove(0, f.length());
                }
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void adjustEndPunctuation() {
        Document sdoc = this.topui.getSourcePane().getDocument();
        StyledDocument tdoc = this.targetTextPane.getStyledDocument();
        try {
            String source = sdoc.getText(0, sdoc.getLength());
            String target = tdoc.getText(0, tdoc.getLength());
            Pattern p = Pattern.compile("\\W+\\z", 256);
            Matcher m = p.matcher(source);
            if (m.find()) {
                String f = m.group();
                char[] ch = f.toCharArray();
                for (int i = ch.length - 1; i >= 0; --i) {
                    char c = ch[i];
                    if (c != '>' && c != '\"' && c != ')' && c != ']' && c != '}') continue;
                    f = f.substring(i + 1);
                    break;
                }
                String ff = "";
                m = p.matcher(target);
                if (m.find()) {
                    ff = m.group();
                    ch = ff.toCharArray();
                    for (int i = ch.length - 1; i >= 0; --i) {
                        char c = ch[i];
                        if (c != '>' && c != '\"' && c != ')' && c != ']' && c != '}') continue;
                        ff = ff.substring(i + 1);
                        break;
                    }
                }
                if (!f.equals(ff)) {
                    if (ff.length() > 0) {
                        tdoc.remove(tdoc.getLength() - ff.length(), ff.length());
                    }
                    tdoc.insertString(tdoc.getLength(), f, null);
                }
            } else {
                m = p.matcher(target);
                if (m.find()) {
                    String f = m.group();
                    char[] ch = f.toCharArray();
                    for (int i = ch.length - 1; i >= 0; --i) {
                        char c = ch[i];
                        if (c != '>' && c != '\"' && c != ')' && c != ']' && c != '}') continue;
                        f = f.substring(i + 1);
                        break;
                    }
                    if (f.length() > 0) {
                        tdoc.remove(tdoc.getLength() - f.length(), f.length());
                    }
                }
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean isPunctuation(char c) {
        return c == ',' || c == '.' || c == '!' || c == '?' || c == ':' || c == ';' || c == '\"' || c == '\u3002';
    }

    public void plusFont() {
        if (this.targetTextPane != null) {
            Font font = this.targetTextPane.getFont();
            float size = font.getSize() + 1;
            font = font.deriveFont(size);
            this.targetTextPane.setFont(font);
            AppPreferences.tfontsize = (int)size;
            MutableAttributeSet attr = this.targetTextPane.getInputAttributes();
            StyleConstants.setFontFamily(attr, font.getFamily());
            StyleConstants.setFontSize(attr, font.getSize());
            StyledDocument doc = this.targetTextPane.getStyledDocument();
            doc.setCharacterAttributes(0, doc.getLength(), attr, false);
            Prompter ac = this.topui.getSourceView().getPrompter();
            if (ac != null) {
                ac.setTableFont(font);
            }
        }
    }

    public void minusFont() {
        if (this.targetTextPane != null) {
            Font font = this.targetTextPane.getFont();
            float size = font.getSize() - 1;
            font = font.deriveFont(size);
            this.targetTextPane.setFont(font);
            AppPreferences.tfontsize = (int)size;
            MutableAttributeSet attr = this.targetTextPane.getInputAttributes();
            StyleConstants.setFontFamily(attr, font.getFamily());
            StyleConstants.setFontSize(attr, font.getSize());
            StyledDocument doc = this.targetTextPane.getStyledDocument();
            doc.setCharacterAttributes(0, doc.getLength(), attr, false);
            Prompter ac = this.topui.getSourceView().getPrompter();
            if (ac != null) {
                ac.setTableFont(font);
            }
        }
    }

    public void setTextComponentOrientation(Locale loc) {
        ComponentOrientation o = ComponentOrientation.getOrientation(loc);
        ComponentOrientation co = this.targetTextPane.getComponentOrientation();
        if (o.isLeftToRight() != co.isLeftToRight()) {
            AppPreferences.RTLTarget = !o.isLeftToRight();
            this.targetTextPane.getParent().getParent().applyComponentOrientation(o);
            this.revalidate();
            this.repaint();
        }
    }

    public void showMatchesForIndex(String s) {
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        int w = frmSize.width / 2;
        int x = w - w / 2 + loc.x;
        int y = frmSize.height / 2 + loc.y;
        this.showMatchesPopUp(this.topui, x, y, s);
    }

    public void toggleTagsButton(boolean flag) {
        this.buttonMouseTags.setSelected(flag);
    }

    public void replaceText(Pattern p, String r) {
        int len = this.document.getLength();
        if (len > 0) {
            try {
                String t = this.document.getText(0, len);
                Matcher ma = p.matcher(t);
                StringBuffer sb = new StringBuffer();
                boolean found = false;
                while (ma.find()) {
                    if (AppPreferences.preserveCaseWithReplacement) {
                        String key = ma.group();
                        String f = XMLHelper.adaptCase(key, r);
                        if (!f.equals(r)) {
                            ma.appendReplacement(sb, f);
                        } else {
                            ma.appendReplacement(sb, r);
                        }
                    } else {
                        ma.appendReplacement(sb, r);
                    }
                    found = true;
                }
                if (found) {
                    ma.appendTail(sb);
                    String s = sb.toString();
                    this.document.remove(0, len);
                    this.document.insertString(0, s, null);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setGoToCharacterReady() {
        this.goToCharacter = !this.goToCharacter;
    }

    public void goToCharacter(char c) {
        int len = this.document.getLength();
        if (len > 0) {
            try {
                String t = this.document.getText(0, len);
                int pos = this.targetTextPane.getCaretPosition();
                if (pos == len) {
                    pos = 0;
                } else {
                    char ch = t.charAt(pos);
                    if (c == ch) {
                        ++pos;
                    }
                }
                int i = t.indexOf(c, pos);
                if (i == -1 && pos > 0) {
                    pos = 0;
                    i = t.indexOf(c, pos);
                }
                if (i != -1) {
                    this.targetTextPane.setCaretPosition(i);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TargetView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setTimerUI(boolean state) {
        if (state) {
            if (this.buttonTimer == null) {
                this.buttonTimer = new JButton("ON");
                this.buttonTimer.setName("TimingNextSegment");
                this.buttonTimer.setForeground(new Color(AppPreferences.toolBarsForeground));
                if (AppPreferences.tbackground2 != 0) {
                    this.buttonTimer.setBackground(this.topui.getMainPanelBackgroundColor());
                }
                this.buttonTimer.setOpaque(false);
                this.buttonTimer.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize * 2, AppPreferences.borderSize, AppPreferences.borderSize * 2));
                this.buttonTimer.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO STOP AUTOPILOT OR PRESS ESC KEY TO SUSPEND"));
                FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOCK, (int)(this.buttonTimer.getFont().getSize() + 4), (Color)Colors.getIconsColor());
                this.buttonTimer.setIcon((Icon)ficon);
                this.buttonTimer.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AppPreferences.autopilot = !AppPreferences.autopilot;
                        WorkflowManager manager = TargetView.this.topui.getWorkflowView().getWorkflowManager();
                        if (manager != null && !AppPreferences.autopilot) {
                            TargetView.this.buttonTimer.setText("OFF");
                            manager.stopTimer();
                        } else {
                            TargetView.this.buttonTimer.setText("ON");
                        }
                    }
                });
            } else {
                this.buttonTimer.setText("ON");
            }
            this.bar.add(this.buttonTimer);
        } else {
            this.bar.remove(this.buttonTimer);
        }
        this.bar.validate();
        this.bar.repaint();
    }
}

