/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import translator.AppPreferences;
import translator.MainView;
import translator.TargetView;
import translator.TextResource;
import translator.ui.UITools;

public class Terminal
extends TextResource {
    private StyledDocument document;
    private MainView topui;

    public Terminal(MainView topui) {
        this.topui = topui;
        this.setMainView(topui);
        this.setParagraphView(false);
        this.newDocument("DST");
        this.setTerminalProperties();
    }

    private void setTerminalProperties() {
        this.getTextPane().setEditable(false);
        this.getTextPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                JTextPane pane;
                String sel;
                boolean ctrl;
                if (!evt.isPopupTrigger() && !(ctrl = UITools.isShortcutDown(evt)) && (sel = (pane = (JTextPane)evt.getSource()).getSelectedText()) != null) {
                    TargetView pview = Terminal.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
            }
        });
        this.document = (StyledDocument)this.getDocument();
        Color termcolor = new Color(AppPreferences.matchColor);
        Color termcolorfont = new Color(AppPreferences.matchColorFont);
        if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
            termcolor = this.topui.toAlphaColor(termcolor, 127);
        }
        Style style = this.document.addStyle("Terms", null);
        StyleConstants.setBackground(style, termcolor);
        StyleConstants.setForeground(style, termcolorfont);
    }

    public void runCommand(String[] command, String query) {
        ExecuteCommand ec = new ExecuteCommand(command, query);
        ec.execute();
    }

    void markQuery(String string) {
        try {
            Style style = this.document.getStyle("Terms");
            String s = this.document.getText(0, this.document.getLength());
            Pattern p = Pattern.compile(string, 18);
            Matcher ma = p.matcher(s);
            while (ma.find()) {
                int st = ma.start();
                int en = ma.end();
                this.document.setCharacterAttributes(st, en - st, style, true);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Terminal.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void closeResource() {
        this.topui.getResourceView().closeTerminal();
        this.topui.getTabView().removeTab("DST");
    }

    private class ExecuteCommand
    extends SwingWorker<String, String> {
        private String[] command;
        private String query;

        public ExecuteCommand(String[] command, String query) {
            this.command = command;
            this.query = query;
            int len = Terminal.this.document.getLength();
            if (len > 0) {
                try {
                    Terminal.this.document.remove(0, Terminal.this.document.getLength());
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(Terminal.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        protected String doInBackground() {
            try {
                Process process = Runtime.getRuntime().exec(this.command);
                this.ProcessCommandOutput(process.getInputStream(), false);
                this.ProcessCommandOutput(process.getErrorStream(), true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }

        private void ProcessCommandOutput(InputStream inputStream, boolean error) throws IOException {
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String segStart = "<seg>";
            String segEnd = "</seg>";
            String lineEnd = "\n\n";
            char tab = '\t';
            Style style = Terminal.this.document.getStyle("Terms");
            Pattern p = Pattern.compile(this.query, 18);
            int count = 0;
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    int len;
                    String tline = line.trim();
                    if (tline.startsWith(segStart)) {
                        int e = tline.lastIndexOf(segEnd);
                        if (e != -1) {
                            line = tline.substring(segStart.length(), e);
                        }
                    } else {
                        line = line.replace(tab, '\n');
                    }
                    Matcher ma = p.matcher(line);
                    int en = 0;
                    while (ma.find()) {
                        ++count;
                        len = Terminal.this.document.getLength();
                        String gr = ma.group();
                        int st = ma.start();
                        if (st > en) {
                            String noMatch = line.substring(en, st);
                            Terminal.this.document.insertString(len, noMatch, null);
                        }
                        len = Terminal.this.document.getLength();
                        Terminal.this.document.insertString(len, gr, style);
                        en = ma.end();
                    }
                    len = Terminal.this.document.getLength();
                    if (en < line.length()) {
                        String noMatch = line.substring(en);
                        Terminal.this.document.insertString(len, noMatch + lineEnd, null);
                    } else {
                        Terminal.this.document.insertString(len, lineEnd, null);
                    }
                    if (count < AppPreferences.searchDisplayLimit) continue;
                    break;
                }
                if (!error) {
                    Terminal.this.document.insertString(Terminal.this.document.getLength(), "\n----- SEARCH ENDED -----\n", null);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Terminal.class.getName()).log(Level.SEVERE, null, ex);
            }
            br.close();
        }
    }
}

