/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import translator.AppPreferences;
import translator.DocumentChooser;
import translator.MainView;
import translator.Project;
import translator.Resource;
import translator.Translatable;
import translator.Workflow;
import translator.XMLElement;
import translator.translatables.MSExcelDocument;
import translator.translatables.MSOfficeDocument;
import translator.translatables.OpenOfficeDocument;
import translator.xliff.FileHeader;
import translator.xliff.POHandler;
import translator.xliff.Skeleton;
import translator.xliff.XLIFF;
import translator.xliff.XliffFile;
import translator.xliff.XliffHandler;

public class TranslatableHandler {
    private MainView topui;
    private DocumentChooser chooser;
    private ProgressMonitor pm;

    public TranslatableHandler(MainView topui) {
        this.topui = topui;
        this.chooser = new DocumentChooser(topui);
        this.pm = new ProgressMonitor(topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTO-SEGMENTATION"), "", 0, 10);
        this.pm.setMillisToPopup(0);
    }

    public void autoSegmentationBilingualSingleFile(Project project) {
        MSExcelDocument doc;
        Translatable translatable = project.getTranslatable();
        if (translatable != null && translatable instanceof MSExcelDocument && (doc = (MSExcelDocument)translatable).isBilingual()) {
            this.segmentBilingualDocument(project, doc.getSourceAndTargetContent());
            XLIFF xliff = project.getXLIFF();
            XliffFile file = xliff.getCurrentFile();
            if (file != null) {
                file.setCurrentPhase("Review");
            }
        }
    }

    public void autoSegmentationSingleFile(Project project) {
        if (project.poFile) {
            POHandler poh = new POHandler(project);
            poh.parsePOFormatSingle();
            return;
        }
        Translatable translatable = project.getTranslatable();
        if (translatable != null) {
            Workflow process = new Workflow(this.topui);
            process.setTranslatable(translatable);
            boolean s = process.start();
            if (!s) {
                return;
            }
            XLIFF xliff = project.getXLIFF();
            if (xliff != null) {
                if (process.unclean) {
                    xliff.setSegmentSeparator(AppPreferences.segFormat);
                    process.automateUncleaned();
                    XliffFile file = xliff.getCurrentFile();
                    if (file != null) {
                        file.setCurrentPhase("Review");
                    }
                } else {
                    xliff.setSegmentSeparator(AppPreferences.segmentSeparator);
                    int tmode = process.getMode();
                    if (tmode == 0) {
                        process.automate();
                        XliffFile file = xliff.getCurrentFile();
                        if (file != null) {
                            file.setCurrentPhase("Review");
                        }
                    }
                }
            }
        }
    }

    public void autoSegmentation(Project project) {
        XLIFF xliff = project.getXLIFF();
        if (xliff == null) {
            return;
        }
        if (project.poFile) {
            POHandler poh = new POHandler(project);
            poh.parsePOFormat();
            return;
        }
        List files = project.getProjectFiles();
        if (files != null) {
            this.initProgress(0, files.size(), "");
            for (int k = 0; k < files.size(); ++k) {
                String tool;
                int fsep;
                XMLElement exf;
                FileHeader h;
                XliffFile file;
                String phase;
                Object object = files.get(k);
                if (!(object instanceof XliffFile) || (phase = (file = (XliffFile)object).getCurrentPhase()) != null && (phase.equals("Alignment") || phase.equals("Autoalignment")) || (h = file.getHeader()) == null) continue;
                String href = null;
                Skeleton sk = h.getSkeleton();
                if (sk != null && (exf = sk.getExternalFile()) != null) {
                    href = exf.getAttribute("href");
                }
                String zName = file.getAttribute("original");
                if (href == null || href.length() == 0) {
                    href = zName;
                }
                if (href == null) continue;
                File f = new File(href);
                String path = project.getProjectPath();
                if (!f.exists() && path != null && (fsep = path.lastIndexOf(AppPreferences.fs)) != -1) {
                    String fdir = path.substring(0, fsep + 1);
                    String fn = f.getName();
                    String sref = fdir + fn;
                    f = new File(sref);
                    if (f.exists()) {
                        h.setSkeletonReference(sref);
                    } else {
                        String pname;
                        int i;
                        String name = project.getName();
                        int j = name.indexOf(".xlf");
                        if (j != -1 && (i = href.lastIndexOf(pname = name.substring(0, j))) != -1) {
                            sref = fdir + href.substring(i);
                            try {
                                Pattern p = Pattern.compile(" ", 16);
                                sref = p.matcher(sref).replaceAll("%20");
                                p = Pattern.compile("\\", 16);
                                sref = p.matcher(sref).replaceAll("/");
                                URL url = new URL("file:///" + sref);
                                f = new File(url.toURI());
                                if (f.exists()) {
                                    h.setSkeletonReference(f.getPath());
                                }
                            }
                            catch (MalformedURLException ex) {
                                Logger.getLogger(TranslatableHandler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            catch (URISyntaxException ex) {
                                Logger.getLogger(TranslatableHandler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                boolean bilingual = false;
                if (file.getAttribute("filter:ImportTargetColumn") != null) {
                    bilingual = true;
                }
                if (!(tool = file.getAttribute("tool-id")).equalsIgnoreCase("CafeTran") || !f.exists()) continue;
                xliff.setCurrentFile(file);
                xliff.setWorkflow(null);
                project.setTitleForFile(file.getShortName());
                String format = project.getXLIFF().getFormat();
                Resource r = this.chooser.fileLoad(f, format, AppPreferences.en, null, file.getAttributes());
                if (!(r instanceof Translatable)) continue;
                this.updateProgress(k + 1, f.getName());
                Translatable translatable = (Translatable)((Object)r);
                if (bilingual && translatable instanceof MSExcelDocument) {
                    MSExcelDocument doc = (MSExcelDocument)translatable;
                    if (!doc.isBilingual()) continue;
                    this.segmentBilingualDocument(project, doc.getSourceAndTargetContent());
                    if (file == null) continue;
                    file.setCurrentPhase("Review");
                    continue;
                }
                Workflow process = new Workflow(this.topui);
                process.setTranslatable(translatable);
                boolean s = process.start();
                if (!s) continue;
                if (process.unclean) {
                    xliff.setSegmentSeparator(AppPreferences.segFormat);
                    process.automateUncleaned();
                    file.setCurrentPhase("Review");
                    continue;
                }
                xliff.setSegmentSeparator(AppPreferences.segmentSeparator);
                int tmode = process.getMode();
                if (tmode != 0) continue;
                process.automate();
                file.setCurrentPhase("Review");
            }
            this.updateProgress(files.size(), "");
        }
    }

    public boolean autoExport(String targetDir, Project project, boolean withNotes) {
        boolean success = false;
        List files = project.getProjectFiles();
        if (files != null) {
            XLIFF xliff = project.getXLIFF();
            if (xliff != null) {
                if (xliff.isExternalToolXLIFF) {
                    return success;
                }
            } else {
                return success;
            }
            if (xliff.isPO) {
                POHandler poh = new POHandler(project);
                boolean b = poh.exportAll(targetDir);
                return b;
            }
            this.initProgress(0, files.size(), "");
            for (int k = 0; k < files.size(); ++k) {
                String tool;
                int fsep;
                XMLElement exf;
                FileHeader h;
                XliffFile file;
                String phase;
                Object object = files.get(k);
                if (!(object instanceof XliffFile) || (phase = (file = (XliffFile)object).getCurrentPhase()) != null && (phase.equals("Alignment") || phase.equals("Autoalignment") || phase.equals("End")) || (h = file.getHeader()) == null) continue;
                String href = null;
                Skeleton sk = h.getSkeleton();
                if (sk != null && (exf = sk.getExternalFile()) != null) {
                    href = exf.getAttribute("href");
                }
                String zName = file.getAttribute("original");
                if (href == null || href.length() == 0) {
                    href = zName;
                }
                if (href == null) continue;
                File f = new File(href);
                String path = project.getProjectPath();
                if (!f.exists() && path != null && (fsep = path.lastIndexOf(AppPreferences.fs)) != -1) {
                    String fdir = path.substring(0, fsep + 1);
                    String fn = f.getName();
                    String sref = fdir + fn;
                    f = new File(sref);
                    if (f.exists()) {
                        h.setSkeletonReference(sref);
                    } else {
                        String pname;
                        int i;
                        String name = project.getName();
                        int j = name.indexOf(".xlf");
                        if (j != -1 && (i = href.lastIndexOf(pname = name.substring(0, j))) != -1) {
                            sref = fdir + href.substring(i);
                            try {
                                Pattern p = Pattern.compile(" ", 16);
                                sref = p.matcher(sref).replaceAll("%20");
                                p = Pattern.compile("\\", 16);
                                sref = p.matcher(sref).replaceAll("/");
                                URL url = new URL("file:///" + sref);
                                f = new File(url.toURI());
                                if (f.exists()) {
                                    h.setSkeletonReference(f.getPath());
                                }
                            }
                            catch (MalformedURLException ex) {
                                Logger.getLogger(TranslatableHandler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            catch (URISyntaxException ex) {
                                Logger.getLogger(TranslatableHandler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                if ((tool = file.getAttribute("tool-id")).equalsIgnoreCase("CafeTran") && f.exists()) {
                    String targetLang;
                    xliff = project.getXLIFF();
                    xliff.setCurrentFile(file);
                    xliff.setWorkflow(null);
                    project.setTitleForFile(file.getShortName());
                    Translatable translatable = project.getTranslatable(file);
                    if (translatable == null) {
                        String format = project.getXLIFF().getFormat();
                        Resource r = this.chooser.fileLoad(f, format, AppPreferences.en, null, file.getAttributes());
                        if (!(r instanceof Translatable)) continue;
                        translatable = (Translatable)((Object)r);
                    }
                    this.updateProgress(k + 1, f.getName());
                    if (project.mode == 2) continue;
                    boolean transitFile = false;
                    String dtype = file.getAttribute("datatype");
                    if (dtype != null && dtype.equals("x-transit_xml")) {
                        transitFile = true;
                    }
                    if ((targetLang = file.getAttribute("target-language")) == null) continue;
                    String sourceLang = file.getAttribute("source-language");
                    String sourceName = f.getName();
                    if (sourceLang == null) continue;
                    int si = sourceName.lastIndexOf("_" + sourceLang);
                    if (si != -1) {
                        String targetName = !transitFile ? sourceName.substring(0, si) + sourceName.substring(si + sourceLang.length() + 1) : sourceName.substring(0, si) + sourceName.substring(si + sourceLang.length() + 1);
                        String targetPath = targetDir + AppPreferences.fs + targetName;
                        new File(targetPath).getParentFile().mkdirs();
                        if (!withNotes) {
                            translatable.preview(project, targetPath);
                        } else if (translatable instanceof MSOfficeDocument) {
                            MSOfficeDocument mstrans = (MSOfficeDocument)translatable;
                            mstrans.previewWithNotes(project, targetPath);
                        } else if (translatable instanceof OpenOfficeDocument) {
                            OpenOfficeDocument ootrans = (OpenOfficeDocument)translatable;
                            int appType = ootrans.getOfficeApplicationType();
                            if (appType == 0 || appType == 1) {
                                ootrans.previewWithNotes(project, targetPath);
                            } else {
                                translatable.preview(project, targetPath);
                            }
                        } else {
                            translatable.preview(project, targetPath);
                        }
                    } else {
                        String targetPath = targetDir + AppPreferences.fs + targetLang + "_" + sourceName;
                        if (!withNotes) {
                            translatable.preview(project, targetPath);
                        } else if (translatable instanceof MSOfficeDocument) {
                            MSOfficeDocument mstrans = (MSOfficeDocument)translatable;
                            mstrans.previewWithNotes(project, targetPath);
                        } else if (translatable instanceof OpenOfficeDocument) {
                            OpenOfficeDocument ootrans = (OpenOfficeDocument)translatable;
                            int appType = ootrans.getOfficeApplicationType();
                            if (appType == 0 || appType == 1) {
                                ootrans.previewWithNotes(project, targetPath);
                            } else {
                                translatable.preview(project, targetPath);
                            }
                        } else {
                            translatable.preview(project, targetPath);
                        }
                    }
                    success = true;
                    continue;
                }
                if (tool.equalsIgnoreCase("CafeTran")) {
                    JOptionPane.showMessageDialog(this.topui, "CafeTran cannot find the original source language document: " + f.getName());
                    continue;
                }
                JOptionPane.showMessageDialog(this.topui, "This is not CafeTran project file.");
            }
            this.updateProgress(files.size(), "");
        }
        return success;
    }

    public void segmentBilingualDocument(Project project, String content) {
        try {
            SAXParser parser = MSExcelDocument.getParser();
            XliffHandler handler = new XliffHandler(this.topui, project, true);
            StringReader reader = new StringReader(content);
            InputSource is = new InputSource();
            is.setCharacterStream(reader);
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
        }
    }

    public void initProgress(int min, int max, String note) {
        ProgressInit initProgress = new ProgressInit(min, max, note);
        SwingUtilities.invokeLater(initProgress);
    }

    public void updateProgress(int counter, String note) {
        ProgressUpdater updater = new ProgressUpdater(counter, note);
        SwingUtilities.invokeLater(updater);
    }

    private class ProgressInit
    implements Runnable {
        private int min;
        private int max;
        private String note;

        ProgressInit(int min, int max, String note) {
            this.min = min;
            this.max = max;
            this.note = note;
        }

        @Override
        public void run() {
            TranslatableHandler.this.pm.setMinimum(this.min);
            TranslatableHandler.this.pm.setMaximum(this.max);
            TranslatableHandler.this.pm.setNote(this.note);
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private int _value;
        private String _note;

        ProgressUpdater(int value, String note) {
            this._value = value;
            this._note = note;
        }

        @Override
        public void run() {
            TranslatableHandler.this.pm.setProgress(this._value);
            TranslatableHandler.this.pm.setNote(this._note);
        }
    }
}

