/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.StyleSheet;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.MainView;
import translator.MySwingWorker;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.TabView;
import translator.TargetView;
import translator.TransparentBackground;
import translator.TransparentBackgroundListener;
import translator.ui.UITools;

public class WebResource
extends DefaultResource {
    private MainView topui;
    private TabView tview;
    private ResourceView rview;
    private String prefix;
    private String suffix;
    private String charset;
    private String infopath;
    private String path;
    private String style;
    private String command;
    private String[] extCommand;
    private URL url;
    private JLabel statusBar;
    private JEditorPane jepane;
    private TransparentBackground tbg;
    private boolean start;
    private boolean tabbedView;
    private boolean running;
    private StyleSheet stylesheet;
    private String resourceName;
    private ArrayList docBases;
    private int cache;
    private int current;
    private MySwingWorker worker;
    private String tableStart;
    private String tableEnd;
    private Desktop desktop;
    private boolean postMethod;
    private boolean canSearchOnline;

    public WebResource(String path) {
        this.start = false;
        this.tabbedView = true;
        this.current = -1;
        this.tableStart = "<html><body leftmargin=7 topmargin=7 marginheight=7 marginwidth=7>";
        this.tableEnd = "</body></html>";
        this.postMethod = false;
        this.canSearchOnline = true;
        this.path = path;
        this.infopath = null;
        this.charset = System.getProperty("file.encoding");
        this.prefix = "";
        this.suffix = "";
        this.style = null;
        this.resourceName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WEB BROWSER");
        this.cache = 10;
        this.docBases = new ArrayList(this.cache);
        this.command = AppPreferences.browser;
        this.canSearchOnline = false;
    }

    public WebResource(ResourceInfo ri) {
        block12: {
            block10: {
                block13: {
                    block11: {
                        this.start = false;
                        this.tabbedView = true;
                        this.current = -1;
                        this.tableStart = "<html><body leftmargin=7 topmargin=7 marginheight=7 marginwidth=7>";
                        this.tableEnd = "</body></html>";
                        this.postMethod = false;
                        this.canSearchOnline = true;
                        this.path = ri.getResourceAddress();
                        this.infopath = ri.getInfoPath();
                        this.charset = ri.getEncoding();
                        this.prefix = ri.getPrefix();
                        if (this.prefix.startsWith("@")) {
                            this.postMethod = true;
                            this.prefix = this.prefix.substring(1);
                        } else {
                            this.postMethod = ri.getMethod();
                        }
                        this.suffix = ri.getSuffix();
                        if (this.path != null && this.prefix.length() == 0) {
                            this.canSearchOnline = false;
                        }
                        this.style = ri.getStyleSheetPath();
                        int i = this.infopath.lastIndexOf(AppPreferences.fs);
                        if (i == -1) {
                            i = this.infopath.lastIndexOf(47);
                        }
                        this.resourceName = i != -1 ? this.infopath.substring(i + 1, this.infopath.length() - 4) : this.path;
                        this.cache = 10;
                        this.docBases = new ArrayList(this.cache);
                        if (this.style == null) break block10;
                        if (!this.style.startsWith("System")) break block11;
                        this.command = "System";
                        break block12;
                    }
                    if (this.style.length() <= 0 || this.style.endsWith(".css")) break block13;
                    this.command = "System command";
                    if (this.style.startsWith("cmd") || this.style.startsWith("open")) {
                        String[] split = this.style.split(" ");
                        this.extCommand = new String[split.length + 1];
                        for (int k = 0; k < split.length; ++k) {
                            this.extCommand[k] = split[k];
                        }
                    } else {
                        this.extCommand = new String[2];
                        this.extCommand[0] = this.style;
                    }
                    break block12;
                }
                this.command = AppPreferences.browser;
                if (!this.command.startsWith("cmd") && !this.command.startsWith("open")) break block12;
                this.command = "System command";
                String[] split = AppPreferences.browser.split(" ");
                this.extCommand = new String[split.length + 1];
                for (int k = 0; k < split.length; ++k) {
                    this.extCommand[k] = split[k];
                }
                break block12;
            }
            this.command = AppPreferences.browser;
            if (this.command.startsWith("cmd") || this.command.startsWith("open")) {
                this.command = "System command";
                String[] split = AppPreferences.browser.split(" ");
                this.extCommand = new String[split.length + 1];
                for (int k = 0; k < split.length; ++k) {
                    this.extCommand[k] = split[k];
                }
            }
        }
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.rview = topui.getResourceView();
        this.statusBar = topui.getMainStatusBar();
        if (!(!this.command.equals("System") || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE))) {
            this.command = "CafeTran";
            JOptionPane.showMessageDialog(topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM BROWSER IS NOT SUPPORTED ON YOUR SYSTEM."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM INFORMATION"), 1);
        }
        if (this.command.equalsIgnoreCase("CafeTran")) {
            this.createHTMLTab();
            HTMLDocument doc = (HTMLDocument)this.jepane.getDocument();
            if (this.style != null) {
                try {
                    URL url;
                    if (!this.style.startsWith("http:") && !this.style.startsWith("file:")) {
                        File file = new File(this.style);
                        url = file.toURI().toURL();
                    } else {
                        url = new URL(this.style);
                    }
                    this.stylesheet = new StyleSheet();
                    this.stylesheet.importStyleSheet(url);
                    doc.getStyleSheet().importStyleSheet(url);
                }
                catch (MalformedURLException malformedURLException) {}
            }
        } else if (this.command.startsWith("System") && this.tabbedView) {
            this.createHTMLDesktopTab();
        }
        if (this.path != null) {
            String s;
            if (this.path.startsWith("www")) {
                this.path = "http://" + this.path;
            }
            if ((s = this.path).startsWith("http:") || s.startsWith("file:")) {
                this.rview.setSearchBoxText(s);
                this.search(s, null);
                topui.repaint();
                return;
            }
        }
    }

    public void setTabbedView(boolean hasTabbedView) {
        this.tabbedView = hasTabbedView;
    }

    public boolean hasTabbedView() {
        return this.tabbedView;
    }

    public boolean hasExternalBrowser() {
        return this.command != null && this.command.startsWith("System");
    }

    private void setDefaultStyle(HTMLDocument doc) {
        String hexB = Integer.toHexString(AppPreferences.background).substring(2);
        String hexF = Integer.toHexString(AppPreferences.foreground).substring(2);
        String globalRule = "{ background : #" + hexB + " ! important; color : #" + hexF + " ! important;}";
        String bodyRule = "body { background : #" + hexB + " ! important; color : #" + hexF + " ! important;}";
        String htmlRule = "html { background : #" + hexB + " ! important; color : #" + hexF + " ! important;}";
        String tableRule = "table, tr, td { background : #" + hexB + " ! important; color : #" + hexF + " ! important;}";
        String linkRule = "a[href] { background : #" + hexB + " ! important; color : #" + hexF + " ! important;}";
        this.stylesheet = new StyleSheet();
        this.stylesheet.addRule(globalRule + bodyRule + htmlRule + tableRule + linkRule);
        doc.getStyleSheet().addStyleSheet(this.stylesheet);
    }

    @Override
    public void search(String okey, String rep) {
        if (!this.canSearchOnline) {
            return;
        }
        final String key = okey;
        this.worker = new MySwingWorker(this){
            final /* synthetic */ WebResource this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                if (this.this$0.command.startsWith("System")) {
                    this.this$0.browse(key);
                } else {
                    JFrame jf = this.this$0.topui.getExtendedFrame();
                    if (jf != null && jf.getExtendedState() == 1 && this.this$0.topui.getTabView().tabExists(this.this$0.resourceName)) {
                        jf.setExtendedState(0);
                    }
                    this.this$0.find(key);
                }
                return null;
            }

            @Override
            public void finished() {
            }
        };
        this.worker.start();
    }

    private void browse(String address) {
        String request = address;
        if (request.startsWith("www.")) {
            request = "http://" + request;
        }
        if (!request.startsWith("http:") && !request.startsWith("file:")) {
            int i = request.indexOf(47);
            if (i != -1) {
                String s1 = request.substring(0, i);
                String s2 = request.substring(i + 1);
                try {
                    s1 = URLEncoder.encode(s1, this.charset);
                    s2 = URLEncoder.encode(s2, this.charset);
                    request = s1 + "/" + s2;
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    request = URLEncoder.encode(request, this.charset);
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            }
            request = this.prefix + request + this.suffix;
            if (request.indexOf("|") != -1) {
                request = request.replace("|", "%7C");
            }
        }
        if (this.extCommand != null && this.extCommand.length > 0) {
            String s;
            String os;
            if (request.indexOf("&") != -1 && (os = System.getProperty("os.name")).startsWith("Windows") && (s = this.extCommand[0]).startsWith("cmd")) {
                request = request.replaceAll("&", "^&");
            }
            this.extCommand[this.extCommand.length - 1] = request;
            try {
                Runtime.getRuntime().exec(this.extCommand);
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FAILED TO OPEN EXTERNAL BROWSER."), null, 0);
            }
        } else {
            try {
                if (this.desktop == null) {
                    this.desktop = Desktop.getDesktop();
                }
                this.desktop.browse(new URI(request));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void find(String key) {
        String request = (key = key.trim()).startsWith("www.") ? "http://" + key : key;
        if (!request.startsWith("http:") && !request.startsWith("file:")) {
            int i = request.indexOf(47);
            if (i != -1) {
                String s1 = request.substring(0, i);
                String s2 = request.substring(i + 1);
                try {
                    s1 = URLEncoder.encode(s1, this.charset);
                    s2 = URLEncoder.encode(s2, this.charset);
                    request = s1 + "/" + s2;
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    request = URLEncoder.encode(request, this.charset);
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            }
            request = this.prefix + request + this.suffix;
            if (request.indexOf("|") != -1) {
                request = request.replace("|", "%7C");
            }
            this.start = false;
        } else {
            this.start = true;
        }
        BufferedReader in = null;
        try {
            if (this.start) {
                this.url = new URL(request);
                this.jepane.putClientProperty("charset", this.charset);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WebResource.this.jepane.setPage(WebResource.this.url);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(WebResource.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        Document doc = WebResource.this.jepane.getDocument();
                        if (doc instanceof HTMLDocument) {
                            HTMLDocument hdoc = (HTMLDocument)doc;
                            hdoc.setAsynchronousLoadPriority(1);
                            if (WebResource.this.stylesheet != null) {
                                hdoc.getStyleSheet().addStyleSheet(WebResource.this.stylesheet);
                            }
                        }
                        WebResource.this.statusBar.setText("");
                    }
                });
            } else {
                int index = -1;
                String post = null;
                if (this.postMethod && (index = request.indexOf("?")) != -1) {
                    post = request.substring(index + 1);
                    request = request.substring(0, index);
                }
                this.url = new URL(request);
                this.running = true;
                String htmlText = "";
                StringBuilder line = new StringBuilder();
                String eline = "";
                boolean len = false;
                in = this.getBufferedReader(this.url, post);
                line.append(this.tableStart);
                line.append("\n");
                while ((eline = in.readLine()) != null && this.running) {
                    line.append(eline);
                    line.append("\n");
                }
                line.append(this.tableEnd);
                htmlText = line.toString();
                if (this.style != null) {
                    if (htmlText.indexOf(" bgcolor=\"") != -1) {
                        htmlText = htmlText.replaceAll(" bgcolor=", "xxx=");
                    }
                    if (htmlText.indexOf("<font ") != -1) {
                        htmlText = htmlText.replaceAll("<font [^<]*>(?i)", "<font>");
                    }
                }
                this.jepane.setText(htmlText);
                this.addToCache(this.jepane.getDocument());
            }
        }
        catch (Exception er) {
            er.printStackTrace();
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PAGE UNAVAILABLE"));
        }
        finally {
            this.closeConnection(in);
        }
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNABLE TO CLOSE THE CONNECTION"));
        }
    }

    private void addToCache(Document doc) {
        ++this.current;
        this.docBases.add(this.current, doc);
        int index = this.docBases.size() - 1;
        if (index == this.cache) {
            this.docBases.remove(0);
            --this.current;
        }
    }

    private void next() {
        if (this.current < this.docBases.size() - 1) {
            MySwingWorker worker = new MySwingWorker(){

                @Override
                public Object construct() {
                    return null;
                }

                @Override
                public void finished() {
                    WebResource.this.current++;
                    Document doc = (Document)WebResource.this.docBases.get(WebResource.this.current);
                    if (!(doc instanceof HTMLDocument)) {
                        WebResource.this.jepane.setContentType("text/plain");
                    } else if (WebResource.this.jepane.getContentType().equals("text/plain")) {
                        WebResource.this.jepane.setContentType("text/html");
                    }
                    WebResource.this.jepane.setDocument(doc);
                }
            };
            worker.start();
        }
    }

    private void previous() {
        if (this.current > 0) {
            MySwingWorker worker = new MySwingWorker(){

                @Override
                public Object construct() {
                    return null;
                }

                @Override
                public void finished() {
                    WebResource.this.current--;
                    Document doc = (Document)WebResource.this.docBases.get(WebResource.this.current);
                    if (!(doc instanceof HTMLDocument)) {
                        WebResource.this.jepane.setContentType("text/plain");
                    } else if (WebResource.this.jepane.getContentType().equals("text/plain")) {
                        WebResource.this.jepane.setContentType("text/html");
                    }
                    WebResource.this.jepane.setDocument(doc);
                }
            };
            worker.start();
        }
    }

    @Override
    public void stopSearch() {
        this.running = false;
        this.worker.interrupt();
    }

    private void createHTMLDesktopTab() {
        this.tbg = new TransparentBackground(this.topui);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.tbg.setPreferredSize(dim);
        JScrollPane pane = new JScrollPane();
        pane.getVerticalScrollBar().setUnitIncrement(10);
        pane.getViewport().add(this.tbg);
        this.tview.addTab(this, this.resourceName, pane);
    }

    private void createHTMLTab() {
        this.jepane = new JEditorPane();
        this.jepane.setContentType("text/html");
        this.jepane.addHyperlinkListener(new Hyperactive());
        this.jepane.setEditable(false);
        this.jepane.addPropertyChangeListener("page", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Document doc = WebResource.this.jepane.getDocument();
                if (doc instanceof HTMLDocument) {
                    HTMLDocument hdoc = (HTMLDocument)doc;
                    WebResource.this.addToCache(hdoc);
                }
            }
        });
        this.jepane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                String sel;
                boolean ctrl = UITools.isShortcutDown(e);
                if (!ctrl && (sel = WebResource.this.jepane.getSelectedText()) != null) {
                    TargetView pview = WebResource.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
            }
        });
        Color selection = new Color(AppPreferences.selection);
        this.jepane.setSelectionColor(selection);
        this.jepane.setSelectedTextColor(Color.WHITE);
        this.jepane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                WebResource.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        Graphics g = this.jepane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        JScrollPane scroll = new JScrollPane();
        scroll.getVerticalScrollBar().setUnitIncrement(10);
        scroll.setBorder(null);
        scroll.getViewport().add((Component)this.jepane, null);
        this.tview.addTab(this, this.resourceName, scroll);
    }

    private void pageOpen() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN PAGE"));
        if (0 == jFileChooser.showOpenDialog(this.topui)) {
            try {
                File file = jFileChooser.getSelectedFile();
                AppPreferences.fileDirectory = file.getParent();
                String path = file.toURI().toURL().toExternalForm();
                this.rview.setSearchBoxText(path);
                this.search(path, null);
                this.topui.repaint();
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void saveAsPage() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE PAGE"));
        if (0 == jFileChooser.showSaveDialog(this.topui)) {
            String name;
            File file = null;
            Object path = null;
            file = jFileChooser.getSelectedFile();
            AppPreferences.fileDirectory = file.getParent();
            this.resourceName = name = file.getName();
            String text = this.jepane.getText();
            this.saveFile(file, text);
        }
    }

    private void saveFile(File file, String text) {
        try {
            String enc = null;
            enc = this.charset != null ? this.charset : AppPreferences.en;
            Charset chars = Charset.isSupported(enc) ? Charset.forName(enc) : Charset.forName("ISO-8859-15");
            CharsetEncoder encoder = chars.newEncoder();
            File tempFile = File.createTempFile("old", null, file.getParentFile());
            FileOutputStream fos = new FileOutputStream(tempFile);
            FileChannel fc = fos.getChannel();
            CharBuffer cb = CharBuffer.wrap(text.toCharArray());
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            fos.close();
            if (file.exists()) {
                file.delete();
            }
            if (!tempFile.renameTo(file)) {
                this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANNOT RENAME FILE"));
            }
        }
        catch (Exception e) {
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING PAGE"));
        }
    }

    public void finalize() {
        this.docBases = null;
    }

    @Override
    public void newResource() {
        String s = null;
        this.topui.getResourceLoader().prepareWebResource(s, null, false, false, -1);
    }

    @Override
    public void openResource() {
        this.pageOpen();
    }

    @Override
    public void saveResource() {
        if (this.command == null) {
            this.saveAsPage();
        }
    }

    @Override
    public void saveAsResource() {
        if (this.command == null) {
            this.saveAsPage();
        }
    }

    @Override
    public void closeResource() {
        TransparentBackgroundListener tbgl;
        this.running = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        if (this.infopath != null) {
            List loader = this.topui.getResourceLoader().getResourceLoaderList();
            loader.remove(this.infopath);
            this.topui.getProjectView().removeReference(this.infopath);
            this.topui.getResourceLoader().removeLastSessionResource(this.infopath);
        }
        if (this.tbg != null && (tbgl = this.topui.getTransparentBackgroundListener()) != null) {
            tbgl.removeBackgroundComp(this.tbg);
        }
        this.topui.getResourceView().removeWebResource(this);
        if (this.hasTabbedView()) {
            this.tview.removeTab(this.resourceName);
            if (AppPreferences.sws && this.tbg != null) {
                this.closeExternalWebResources();
            }
        }
    }

    @Override
    public void nextResource() {
        this.next();
    }

    @Override
    public void previousResource() {
        this.previous();
    }

    @Override
    public String getInfoPath() {
        return this.infopath;
    }

    @Override
    public String getLocation() {
        return this.resourceName;
    }

    protected BufferedReader getBufferedReader(URL page, String post) throws IOException {
        EditorKit kit;
        Document doc;
        URLConnection conn = page.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla 5.0");
        conn.setDoOutput(true);
        if (post != null) {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(post);
            out.close();
        }
        if (conn instanceof HttpURLConnection) {
            boolean redirect;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            int response = hconn.getResponseCode();
            boolean bl = redirect = response >= 300 && response <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                page = loc.startsWith("http", 0) ? new URL(loc) : new URL(page, loc);
                return this.getBufferedReader(page, post);
            }
        }
        if ((doc = (kit = this.jepane.getEditorKit()).createDefaultDocument()) instanceof HTMLDocument) {
            HTMLDocument hdoc = (HTMLDocument)doc;
            hdoc.setAsynchronousLoadPriority(1);
            if (this.stylesheet != null) {
                hdoc.getStyleSheet().addStyleSheet(this.stylesheet);
            }
        }
        this.jepane.setDocument(doc);
        doc.putProperty("stream", page);
        String enc = conn.getContentEncoding();
        if (enc == null) {
            enc = this.charset;
        }
        doc.putProperty("content-encoding", enc);
        InputStream in = conn.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, enc));
        return r;
    }

    private void closeExternalWebResources() {
        List list = this.topui.getResourceView().getWebResources();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                WebResource wr;
                Object object = it.next();
                if (!(object instanceof WebResource) || (wr = (WebResource)object).hasTabbedView()) continue;
                it.remove();
            }
        }
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    URL url = e.getURL();
                    String s = url.toExternalForm();
                    WebResource.this.rview.setSearchBoxText(s);
                    WebResource.this.search(s, null);
                }
            }
        }
    }
}

