/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import translator.Abbreviations;
import translator.AppPreferences;
import translator.Frequencer;
import translator.ImageResource;
import translator.MainView;
import translator.MatchBoard;
import translator.MySwingWorker;
import translator.NumbersHelper;
import translator.Placeables;
import translator.Project;
import translator.ProjectView;
import translator.Resource;
import translator.ResourceView;
import translator.SegmentParser;
import translator.Segmentation;
import translator.SourceView;
import translator.StyleHelper;
import translator.TabView;
import translator.TargetView;
import translator.TrackingChanges;
import translator.Translatable;
import translator.WordCount;
import translator.WorkflowManager;
import translator.WorkflowView;
import translator.XMLElement;
import translator.XMLHelper;
import translator.database.TermBase;
import translator.hunspell.HunSpellChecker;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.translatables.ITTSubtitles;
import translator.translatables.MSExcelDocument;
import translator.translatables.MSOfficeDocument;
import translator.translatables.OpenOfficeDocument;
import translator.translatables.SRTSubtitles;
import translator.translatables.TextDocument;
import translator.xliff.POHandler;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class Workflow {
    private MainView topui;
    private MemoryView mview;
    private ProjectView prview;
    private SourceView sourceView;
    private TargetView targetView;
    private ProgressMonitor pm;
    private JProgressBar pb;
    private Translatable translatable;
    private String translatableText;
    private int startPosition;
    private int endPosition;
    private int currentPosition = -1;
    private int indexPosition = -1;
    private String currentSegment;
    private Project project;
    private int mode = 0;
    private Matcher matcher;
    private String bounds;
    private String headBounds;
    private WordCount wordCount;
    private String startTimeSessionString;
    private long pauseSessionStart;
    private long startTimeSession;
    private long pauseTimeSession;
    private long lastTimeSessions;
    private JTextPane sourcePane;
    private JTextPane targetPane;
    private String currentSource;
    private String currentTarget;
    boolean align = false;
    private String firstTag;
    private String segBreak;
    boolean unclean = false;
    boolean noPunctuation = false;
    boolean noLookup = false;
    boolean resetLookup = false;
    public boolean canAppend2 = true;
    public boolean justStarted = false;
    private Workflow alignmentWorkflow = null;
    private Map commentsMap;
    private List plist = new ArrayList();
    private Map pmap = new HashMap();
    private List tlist = new ArrayList();
    public static Map formatMap = new HashMap();
    private String commentRegEx;
    private Pattern noLetterPattern;
    private String segmentTagged;
    private String[] segmentTags;
    private String segmentForMemory;
    private String segmentForGlossary;
    private String segmentForAutoAssembling;
    private String segmentForTTS;
    private boolean targetOut = false;
    private String wordsName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORDS");
    private String charactersName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHARACTERS");
    private String dayName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DAY");
    private String daysName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DAYS");
    private String hourName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HOUR");
    private String hoursName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HOURS");
    private String minuteName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MINUTE");
    private String minutesName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MINUTES");
    private String secondsName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SECONDS");
    Pattern pattern;
    Pattern noPattern;
    private boolean sortPlaceables;
    private boolean[] translatables;
    boolean tagBreak = false;
    boolean autoSegmentation = false;

    public Workflow(MainView topui) {
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.mview = topui.getMemoryView();
        this.sourceView = topui.getSourceView();
        this.targetView = topui.getTargetView();
        this.project = this.prview.getProject();
        this.sourcePane = topui.getSourcePane();
        this.targetPane = topui.getTargetPane();
        this.noLetterPattern = Pattern.compile(AppPreferences.noLettersRegEx);
        this.setStartTime();
        this.initCount();
    }

    public void setAlignmentWorkflow(Workflow flow) {
        this.alignmentWorkflow = flow;
    }

    public void setPanes(JTextPane sPane, JTextPane tPane) {
        this.sourcePane = sPane;
        this.targetPane = tPane;
    }

    public void setTranslatable(Translatable translatable) {
        if (translatable != null) {
            this.translatable = translatable;
            if (translatable instanceof MSExcelDocument) {
                MSExcelDocument tr = (MSExcelDocument)translatable;
                this.commentsMap = tr.getCommentsMap();
            } else if (translatable instanceof SRTSubtitles) {
                SRTSubtitles tr = (SRTSubtitles)translatable;
                this.commentsMap = tr.getCommentsMap();
            } else if (translatable instanceof ITTSubtitles) {
                ITTSubtitles tr = (ITTSubtitles)translatable;
                this.commentsMap = tr.getCommentsMap();
            } else if (translatable instanceof TextDocument) {
                TextDocument tr = (TextDocument)translatable;
                this.unclean = tr.isUncleaned();
            }
        }
    }

    public Translatable getTranslatable() {
        return this.translatable;
    }

    void setTranslatableText() {
        if (this.translatable != null) {
            this.translatableText = this.translatable.getSourceContent();
            if (this.translatableText != null) {
                this.startPosition = this.translatable.getStartPosition();
                this.endPosition = this.translatable.getEndPosition();
            }
        }
    }

    void setTranslatableText(String s) {
        this.translatableText = s;
        this.startPosition = 0;
        this.endPosition = s.length();
    }

    public String getTranslatableText() {
        return this.translatableText;
    }

    void findFrequentWords(Frequencer freq) {
        freq.setHTMLPane();
        if (!this.unclean && this.translatableText != null && this.matcher != null && this.currentPosition < this.translatableText.length()) {
            freq.findUnsegmentedHFWords(this.translatableText, this.matcher, 0);
        } else {
            freq.findProjectHFWords();
        }
        freq.setFreqWordsTable();
    }

    private String getImageURL() {
        String href = null;
        TabView tview = this.topui.getTabView();
        Resource r = tview.getCurrentResource();
        if (r instanceof ImageResource) {
            ImageResource ir = (ImageResource)r;
            href = ir.getHref();
        }
        return href;
    }

    private void setProgressBar() {
        if (this.pb == null) {
            this.pb = this.topui.getProjectView().getProgressBar();
        }
        if (this.pb.isIndeterminate()) {
            this.pb.setIndeterminate(false);
            this.pb.setString(null);
        }
        if (this.startPosition >= 0) {
            this.pb.setMinimum(this.startPosition);
        }
        if (this.endPosition >= 0) {
            this.pb.setMaximum(this.endPosition);
        }
        if (this.currentPosition >= 0) {
            this.pb.setValue(this.currentPosition);
        }
    }

    private void segmentUncleanText(String text) {
        StringBuilder regx = new StringBuilder();
        String rtfFormat2 = "<\\d*\\}";
        String rtfFormat3 = "\\{\\d*>";
        String rtfFormat4 = "(" + AppPreferences.segFormat + ")*<\\d*\\}[^\\{]*\\{\\d*>(" + AppPreferences.segFormat + ")*";
        String rtfFormat = AppPreferences.segFormat;
        regx.append(rtfFormat4).append("|").append(rtfFormat).append("|").append(rtfFormat2).append("|").append(rtfFormat3);
        this.pattern = Pattern.compile(regx.toString());
        this.matcher = this.pattern.matcher(text);
    }

    private void segmentPropsText(String text, String format) {
        StringBuilder regx = new StringBuilder();
        StringBuilder noregx = new StringBuilder();
        if (format.length() > 0) {
            regx.append(format);
        }
        this.pattern = Pattern.compile(regx.toString(), 40);
        this.matcher = this.pattern.matcher(text);
        if (noregx.length() > 0) {
            this.noPattern = Pattern.compile(noregx.toString());
        }
        this.noPunctuation = true;
    }

    private void segmentText(String text, String format) {
        try {
            Segmentation seg;
            String filterSegmentation;
            Set abbr;
            StringBuilder regx = new StringBuilder();
            StringBuilder noregx = new StringBuilder();
            if (format.length() > 0) {
                regx.append(format);
                regx.append("|");
            }
            if ((abbr = Abbreviations.getAbbreviationsSet()) != null) {
                Iterator it = abbr.iterator();
                while (it.hasNext()) {
                    String ab = (String)it.next();
                    noregx.append("\\Q").append(ab).append("\\E");
                    if (!it.hasNext()) continue;
                    noregx.append("|");
                }
            }
            if ((filterSegmentation = (seg = this.topui.getSegmentation()).getFilterSegmentation()) != null) {
                regx.append(filterSegmentation);
            } else {
                String fileSegmentation = null;
                if (this.translatable != null) {
                    fileSegmentation = this.translatable.getSegmentationRule();
                }
                if (fileSegmentation != null) {
                    regx.append(fileSegmentation);
                } else if (AppPreferences.segmentation.endsWith(".srx")) {
                    String rule;
                    Iterator it;
                    List yesRules = seg.getYesRules();
                    List noRules = seg.getNoRules();
                    if (!yesRules.isEmpty()) {
                        it = yesRules.iterator();
                        while (it.hasNext()) {
                            rule = (String)it.next();
                            regx.append(rule);
                            if (it.hasNext()) {
                                regx.append("|");
                                continue;
                            }
                            regx.append("|\\z");
                        }
                    } else {
                        regx.append(AppPreferences.segmentation);
                    }
                    if (noregx.length() > 0 && !noRules.isEmpty()) {
                        noregx.append("|");
                    }
                    it = noRules.iterator();
                    while (it.hasNext()) {
                        rule = (String)it.next();
                        noregx.append(rule);
                        if (!it.hasNext()) continue;
                        noregx.append("|");
                    }
                } else {
                    regx.append(AppPreferences.segmentation);
                }
            }
            this.pattern = Pattern.compile(regx.toString());
            this.matcher = this.pattern.matcher(text);
            if (noregx.length() > 0) {
                this.noPattern = Pattern.compile(noregx.toString());
            }
            this.noPunctuation = AppPreferences.segmentation.equals(Segmentation.tagSeg);
        }
        catch (PatternSyntaxException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, ex.getDescription(), "Segmentation Error", 0);
        }
    }

    private String selectSegment(int from) {
        if (this.currentPosition >= this.endPosition) {
            if (!this.autoSegmentation) {
                this.setSource("", false);
            }
            return null;
        }
        if (this.bounds != null) {
            if (this.bounds.startsWith("<x") && this.bounds.endsWith("/>")) {
                this.firstTag = this.bounds;
                this.segBreak = null;
            } else {
                this.firstTag = null;
                this.segBreak = this.bounds;
                this.updateCount(this.segBreak);
            }
        } else {
            this.firstTag = null;
            this.segBreak = null;
        }
        String segment = null;
        int ifrom = from;
        String leadingBlanks = null;
        while (this.matcher.find(ifrom)) {
            this.bounds = this.matcher.group();
            if (ifrom == 0) {
                this.headBounds = this.bounds;
            }
            int start = this.matcher.start();
            int end = this.matcher.end();
            if (this.noPattern != null) {
                int offset = end - ifrom;
                int maxend = end + 25;
                String subsegment = maxend < this.translatableText.length() ? this.translatableText.substring(ifrom, maxend) : this.translatableText.substring(ifrom, end);
                Matcher noMatcher = this.noPattern.matcher(subsegment);
                boolean ex = false;
                int noend = -1;
                while (noMatcher.find()) {
                    String b = noMatcher.group();
                    int nostart = noMatcher.start();
                    if (nostart >= offset || b.indexOf("<x") != -1) break;
                    noend = noMatcher.end();
                    ex = true;
                }
                if (ex) {
                    ifrom += noend;
                    continue;
                }
            }
            if (!this.bounds.startsWith("<x") && !this.noPunctuation) {
                int off = 0;
                for (int i = 0; i < this.bounds.length(); ++i) {
                    char p = this.bounds.charAt(i);
                    int type = Character.getType(p);
                    if (type == 24) {
                        off = i + 1;
                        continue;
                    }
                    if (!Character.isWhitespace(p)) continue;
                    off = i;
                    break;
                }
                if (off > 0) {
                    start += off;
                    this.bounds = this.bounds.substring(off);
                }
            }
            segment = this.translatableText.substring(from, start);
            if (!this.autoSegmentation && this.translatable != null && segment.length() > 0) {
                this.translatable.highlightSegment(from, start, segment);
            }
            if (leadingBlanks != null) {
                segment = leadingBlanks + segment;
                int len = leadingBlanks.length();
                leadingBlanks = null;
                this.indexPosition = from - len;
            } else {
                this.indexPosition = from;
            }
            this.currentPosition = end;
            if (segment.trim().length() != 0) break;
            if (this.currentPosition >= this.endPosition) {
                return null;
            }
            if (start == 0) {
                String b = this.bounds;
                segment = this.selectSegment(this.currentPosition);
                if (b == null || b.indexOf("translatable=\"no\"") == -1) break;
                this.firstTag = this.bounds;
                from = this.currentPosition;
                ifrom = this.currentPosition;
                continue;
            }
            if (this.bounds.startsWith("<x") && this.bounds.endsWith("/>")) {
                if (this.currentSegment == null && this.bounds.indexOf("translatable=\"no\"") != -1) {
                    segment = this.selectSegment(this.currentPosition);
                }
                this.firstTag = this.bounds;
                from = this.currentPosition;
            } else if (this.currentSegment == null) {
                from = this.currentPosition;
                if (this.bounds != null && this.bounds.length() > 0 && this.firstTag != null && this.firstTag.startsWith("<x")) {
                    leadingBlanks = this.bounds;
                }
            }
            ifrom = this.currentPosition;
        }
        return segment;
    }

    public void prepareSegmentation() {
        if (!this.unclean) {
            String formatName = this.project.getXLIFF().getFormat();
            if (formatName.equals("Java Properties (*.properties)")) {
                String s = "\\A.+?=|$(\\s+#.+?$)+.+?=|$[^#]+?=|\\s*\\z";
                this.segmentPropsText(this.translatableText, s);
            } else if (formatName.equals("Windows .NET Resources (*.resx)")) {
                String s = AppPreferences.segFormat;
                this.segmentPropsText(this.translatableText, s);
            } else if (formatName.equals("Mac String Resources (*.strings)")) {
                this.commentRegEx = "/\\*.+?\\*/";
                String s = "((\\A\\s*|\";\\s+)(/\\*.+?\\*/\\s+)*.+?=[ ]*\")+|\";\\s*\\z";
                this.segmentPropsText(this.translatableText, s);
            } else if (formatName.equals("String resource header (*.loc)")) {
                String s = "\\A.+?=\\s*|$[^=]+?=\\s*|\\s*\\z";
                this.segmentPropsText(this.translatableText, s);
            } else if (formatName.startsWith("Text")) {
                String s = "";
                this.segmentText(this.translatableText, s);
            } else {
                String s = AppPreferences.segFormat;
                this.segmentText(this.translatableText, s);
            }
        } else {
            this.segmentUncleanText(this.translatableText);
        }
        this.currentPosition = this.startPosition;
        int lpos = -1;
        lpos = this.align ? this.project.getAlignmentPosition() : this.project.getLastPosition();
        if (lpos > this.startPosition && this.endPosition == this.translatableText.length() && lpos > 0) {
            this.currentPosition = lpos;
        }
    }

    private String selectUncleanSegment(int from) {
        if (this.currentPosition >= this.endPosition) {
            this.setSource("", false);
            return null;
        }
        String segment = null;
        int ifrom = from;
        while (this.matcher.find(ifrom)) {
            String newBounds = this.matcher.group();
            int start = this.matcher.start();
            int end = this.matcher.end();
            segment = this.translatableText.substring(ifrom, start);
            this.currentPosition = end;
            ifrom = end;
            this.indexPosition = from;
            if (segment.length() == 0) {
                this.bounds = this.bounds + newBounds;
                continue;
            }
            if (this.bounds == null) break;
            String xmlbounds = XMLHelper.resolveXMLEntities(this.bounds);
            segment = "<x id=\"" + xmlbounds + "\"/>" + segment;
            this.bounds = newBounds;
            break;
        }
        if (this.matcher.hitEnd()) {
            String s = "";
            if (this.currentPosition != -1 && this.currentPosition < this.translatableText.length()) {
                s = this.translatableText.substring(this.currentPosition);
            }
            this.currentPosition = this.translatableText.length();
            String xmlbounds = XMLHelper.resolveXMLEntities(this.bounds + s);
            segment = segment != null ? segment + "<x id=\"" + xmlbounds + "\"/>" : "<x id=\"" + xmlbounds + "\"/>";
        }
        return segment;
    }

    private String appendSegment(int from) {
        if (this.currentPosition >= this.endPosition) {
            if (!this.autoSegmentation) {
                this.setSource("", false);
            }
            return null;
        }
        String segment = null;
        int ifrom = from;
        while (this.matcher.find(ifrom)) {
            this.bounds = this.matcher.group();
            int start = this.matcher.start();
            int end = this.matcher.end();
            if (this.noPattern != null) {
                int offset = end - ifrom;
                int maxend = end + 25;
                String subsegment = maxend < this.translatableText.length() ? this.translatableText.substring(ifrom, maxend) : this.translatableText.substring(ifrom, end);
                Matcher noMatcher = this.noPattern.matcher(subsegment);
                boolean ex = false;
                int noend = -1;
                while (noMatcher.find()) {
                    String b = noMatcher.group();
                    int nostart = noMatcher.start();
                    if (nostart >= offset || b.indexOf("<x") != -1) break;
                    noend = noMatcher.end();
                    ex = true;
                }
                if (ex) {
                    ifrom += noend;
                    continue;
                }
            }
            if (!this.bounds.startsWith("<x") && !this.noPunctuation) {
                int off = 0;
                for (int i = 0; i < this.bounds.length(); ++i) {
                    char p = this.bounds.charAt(i);
                    int type = Character.getType(p);
                    if (type == 24) {
                        off = i + 1;
                        continue;
                    }
                    if (!Character.isWhitespace(p)) continue;
                    off = i;
                    break;
                }
                if (off > 0) {
                    start += off;
                    this.bounds = this.bounds.substring(off);
                }
            }
            segment = this.translatableText.substring(from, start);
            if (!this.autoSegmentation && this.translatable != null && segment.length() > 0) {
                this.translatable.highlightSegment(from, start, segment);
            }
            this.currentPosition = end;
            if (segment.length() != 0) break;
            String pbounds = this.bounds;
            segment = this.appendSegment(this.currentPosition);
            if (pbounds == null || segment == null) break;
            segment = pbounds + segment;
            break;
        }
        return segment;
    }

    private void appSourceSegment() {
        String nbounds = this.bounds;
        this.currentSegment = this.appendSegment(this.currentPosition);
        if (this.currentSegment == null) {
            this.currentPosition = -1;
            this.pb.setValue(this.pb.getMaximum());
            this.end();
        } else {
            while (this.bounds.startsWith("<x id=") && this.bounds.indexOf("x-break") == -1) {
                String prev = this.currentSegment + this.bounds;
                String seg = this.appendSegment(this.currentPosition);
                if (seg == null) break;
                this.currentSegment = prev + seg;
            }
            try {
                StyledDocument tdoc;
                String t;
                this.pb.setValue(this.currentPosition);
                StyledDocument sdoc = this.sourcePane.getStyledDocument();
                String prev = sdoc.getText(0, sdoc.getLength());
                prev = nbounds != null && prev.length() > 0 ? ((t = (tdoc = this.targetPane.getStyledDocument()).getText(0, tdoc.getLength())).endsWith(" ") ? prev + nbounds + " " + this.currentSegment : (t.endsWith("\n") ? prev + nbounds + "\n" + this.currentSegment : prev + nbounds + this.currentSegment)) : prev + this.currentSegment;
                this.setSource(prev, AppPreferences.automaticMatching);
                this.showfreqWords(this.currentSegment, true);
                this.currentSegment = prev;
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void setSourceSegment() {
        while (this.bounds != null && this.bounds.indexOf("translatable=\"no\"") != -1) {
            this.currentSegment = this.selectSegment(this.currentPosition);
            if (this.currentSegment != null) continue;
        }
        this.currentSegment = this.selectSegment(this.currentPosition);
        if (this.currentSegment == null) {
            this.currentPosition = -1;
            this.pb.setValue(this.pb.getMaximum());
            this.end();
        } else {
            while (this.bounds.startsWith("<x id=") && this.bounds.indexOf("x-break") == -1) {
                String prev = this.currentSegment + this.bounds;
                String seg = this.appendSegment(this.currentPosition);
                if (seg == null) break;
                this.currentSegment = prev + seg;
            }
            this.pb.setValue(this.currentPosition);
            this.setSource(this.currentSegment, AppPreferences.automaticMatching);
            this.showfreqWords(this.currentSegment, false);
        }
    }

    private void setUncleanSegment(int state) {
        String target;
        String source;
        if (this.bounds == null) {
            this.bounds = "";
        }
        if ((source = this.selectUncleanSegment(this.currentPosition)) != null) {
            String s;
            int op = this.bounds.indexOf("{");
            while (this.bounds.startsWith("<x") && this.bounds.endsWith("/>") && op == -1 && (s = this.selectUncleanSegment(this.currentPosition)) != null) {
                source = source + s;
                op = this.bounds.indexOf("{");
            }
        }
        if ((target = this.selectUncleanSegment(this.currentPosition)) != null) {
            String s;
            int op = this.bounds.indexOf("}");
            while (this.bounds.startsWith("<x") && this.bounds.endsWith("/>") && op == -1 && (s = this.selectUncleanSegment(this.currentPosition)) != null) {
                target = target + s;
                op = this.bounds.indexOf("}");
            }
            int len = target.length();
            if (len > 0) {
                this.updateCount(target);
            }
            this.project.prepareTransUnit();
            this.project.createTransUnit(source, target, null, this.indexPosition, this.currentPosition - this.indexPosition, state, null);
        } else {
            this.currentPosition = -1;
        }
    }

    public void showfreqWords(final String look, final boolean append) {
        if (AppPreferences.frequencer) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ Workflow this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    Frequencer freq = this.this$0.topui.getFrequencer();
                    if (freq == null) {
                        this.this$0.topui.setFrequencer();
                        freq = this.this$0.topui.getFrequencer();
                        this.this$0.findFrequentWords(freq);
                    }
                    freq.showSegmentFreqWords(look, append);
                }
            });
        }
    }

    private void lookUp() {
        if (this.segmentForTTS != null && this.segmentForTTS.length() > 0 && AppPreferences.ttsSpeak < 2) {
            this.topui.getResourceView().speak(this.segmentForTTS);
            this.segmentForTTS = null;
        }
        if (AppPreferences.clipboardSourceSegment && this.mode != 1) {
            this.topui.getResourceView().addStringToClipboard(this.segmentForMemory);
        }
        boolean hit = false;
        if (AppPreferences.propagateToCurrentSegment) {
            int tlength = this.targetPane.getDocument().getLength();
            Document sdoc = this.sourcePane.getDocument();
            int slength = sdoc.getLength();
            String source = null;
            String tar = this.project.getFromMemory(this.segmentForAutoAssembling, this.segmentTags);
            if (tar != null && tar.trim().length() > 0) {
                if (tlength == 0) {
                    this.setTarget(tar);
                }
                hit = true;
            } else if (AppPreferences.transferNontranslatables && tlength == 0 && slength > 0 && this.translatables != null) {
                try {
                    source = sdoc.getText(0, slength);
                    char[] chars = source.toCharArray();
                    if (chars.length == this.translatables.length) {
                        boolean hasLetter;
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < chars.length; ++i) {
                            if (this.translatables[i]) continue;
                            char aChar = chars[i];
                            sb.append(aChar);
                        }
                        if (AppPreferences.noWordSeparatorSourceLanguage) {
                            hasLetter = true;
                        } else {
                            hasLetter = false;
                            for (int i = 0; i < sb.length(); ++i) {
                                char c = sb.charAt(i);
                                if (!Character.isLetter(c)) continue;
                                hasLetter = true;
                                break;
                            }
                        }
                        if (sb.length() == 0 || !hasLetter) {
                            this.setTarget(source);
                            hit = true;
                        }
                    }
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!hit && AppPreferences.transferNoLetters && tlength == 0 && this.segmentForAutoAssembling != null) {
                Matcher m;
                boolean b;
                if (source == null) {
                    try {
                        source = sdoc.getText(0, slength);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (b = (m = this.noLetterPattern.matcher(this.segmentForAutoAssembling)).find()) {
                    this.setTarget(source);
                    hit = true;
                }
            }
        }
        if (!hit || AppPreferences.automaticMatching) {
            this.mview.translateSegment(this.segmentForMemory, this.segmentForGlossary, this.segmentForAutoAssembling, this.segmentTagged, true);
        }
        this.segmentForGlossary = null;
    }

    private void initCount() {
        this.wordCount = new WordCount();
    }

    public void updateCount(String target) {
        if (!this.align && this.wordCount != null) {
            if (!AppPreferences.noWordSeparatorTargetLanguage) {
                this.wordCount.doWordCount(target);
            } else {
                this.wordCount.doCJKVWordCount(target);
            }
        }
    }

    public WordCount getWordCount() {
        return this.wordCount;
    }

    public String getStartTime() {
        Date d = this.project.getDate();
        if (d != null) {
            return d.toString();
        }
        return this.startTimeSessionString;
    }

    public String[] getPace() {
        String paceHour;
        String paceMinute;
        long now = new Date().getTime();
        long diff = now - (this.startTimeSession + this.pauseTimeSession);
        long diffSeconds = diff / 1000L % 60L;
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L;
        float seconds = diffSeconds;
        float minutes = diffMinutes;
        float hours = diffHours;
        if ((double)seconds == 0.0 && (double)minutes == 0.0 && (double)hours == 0.0) {
            return null;
        }
        int hwords = (int)((float)this.wordCount.twords / (hours + minutes / 60.0f + seconds / 3600.0f));
        int hnowhitechars = (int)((float)this.wordCount.tnowhites / (hours + minutes / 60.0f + seconds / 3600.0f));
        int hchars = (int)((float)this.wordCount.tcharacters / (hours + minutes / 60.0f + seconds / 3600.0f));
        float mwords = (float)this.wordCount.twords / (hours * 60.0f + minutes + seconds / 60.0f);
        mwords = this.wordCount.round(mwords, 1);
        int mnowhitechars = (int)((float)this.wordCount.tnowhites / (hours * 60.0f + minutes + seconds / 60.0f));
        int mchars = (int)((float)this.wordCount.tcharacters / (hours * 60.0f + minutes + seconds / 60.0f));
        String billing = null;
        String billing2 = null;
        if (this.wordCount.tprice > 0.0f && this.wordCount.currency != null) {
            if ((double)hours > 0.0) {
                float hpprice = this.wordCount.tprice / (hours + minutes / 60.0f + seconds / 3600.0f);
                hpprice = this.wordCount.round(hpprice, 2);
                String hval = String.valueOf(hpprice);
                billing2 = hval + " " + this.wordCount.currency;
            }
            if ((double)(hours + minutes) > 0.0) {
                float mins = hours * 60.0f + minutes + seconds / 60.0f;
                float mpprice = this.wordCount.tprice / mins;
                mpprice = this.wordCount.round(mpprice, 2);
                String mval = String.valueOf(mpprice);
                billing = mval + " " + this.wordCount.currency;
            }
        }
        String paceTotal = this.wordCount.twords + " " + this.wordsName + "&nbsp;&nbsp;" + this.wordCount.tnowhites + "/" + this.wordCount.tcharacters + " " + this.charactersName;
        if (billing != null) {
            paceMinute = mwords + " " + this.wordsName + "&nbsp;&nbsp;" + mnowhitechars + "/" + mchars + " " + this.charactersName;
            paceMinute = paceMinute + "&nbsp;&nbsp;" + billing;
        } else {
            paceMinute = null;
        }
        if (billing2 != null) {
            paceHour = hwords + " " + this.wordsName + "&nbsp;&nbsp;" + hnowhitechars + "/" + hchars + " " + this.charactersName;
            paceHour = paceHour + "&nbsp;&nbsp;" + billing2;
        } else {
            paceHour = null;
        }
        String[] pace = new String[]{paceMinute, paceHour, paceTotal};
        return pace;
    }

    public String getProjectDuration() {
        long now = new Date().getTime();
        long diff = now - (this.startTimeSession + this.pauseTimeSession) + this.lastTimeSessions;
        long diffSeconds = diff / 1000L % 60L;
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        int seconds = (int)diffSeconds;
        int minutes = (int)diffMinutes;
        int hours = (int)diffHours;
        int days = (int)diffDays;
        String d = days < 2 ? this.dayName : this.daysName;
        String h = hours < 2 ? this.hourName : this.hoursName;
        String m = minutes < 2 ? this.minuteName : this.minutesName;
        String s = days > 0 ? days + " " + d + " " + hours + " " + h + " " + minutes + " " + m + " " + seconds + " " + this.secondsName : hours + " " + h + " " + minutes + " " + m + " " + seconds + " " + this.secondsName;
        return s;
    }

    public String getSessionDuration() {
        long now = new Date().getTime();
        long diff = now - (this.startTimeSession + this.pauseTimeSession);
        long diffSeconds = diff / 1000L % 60L;
        long diffMinutes = diff / 60000L % 60L;
        long diffHours = diff / 3600000L % 24L;
        long diffDays = diff / 86400000L;
        int seconds = (int)diffSeconds;
        int minutes = (int)diffMinutes;
        int hours = (int)diffHours;
        int days = (int)diffDays;
        String d = days < 2 ? this.dayName : this.daysName;
        String h = hours < 2 ? this.hourName : this.hoursName;
        String m = minutes < 2 ? this.minuteName : this.minutesName;
        String s = days > 0 ? days + " " + d + " " + hours + " " + h + " " + minutes + " " + m + " " + seconds + " " + this.secondsName : hours + " " + h + " " + minutes + " " + m + " " + seconds + " " + this.secondsName;
        return s;
    }

    public int getMode() {
        return this.mode;
    }

    public void pauseSessionTime(boolean pause) {
        Date date = new Date();
        long time = date.getTime();
        if (pause) {
            this.pauseSessionStart = date.getTime();
        } else {
            long pauseSessionEnd = time - this.pauseSessionStart;
            this.pauseTimeSession += pauseSessionEnd;
            this.pauseSessionStart = 0L;
        }
    }

    private void setStartTime() {
        Date date = new Date();
        this.startTimeSessionString = date.toString();
        this.startTimeSession = date.getTime();
        this.pauseTimeSession = 0L;
        String s = this.project.getDuration();
        if (s != null) {
            try {
                this.lastTimeSessions = Long.parseLong(s);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lastTimeSessions = 0L;
            }
        } else {
            this.lastTimeSessions = 0L;
        }
    }

    public long getTotalDuration() {
        long now = new Date().getTime();
        return now - this.startTimeSession + this.lastTimeSessions - this.pauseTimeSession;
    }

    private void listenToClipboard() {
        System.out.println("Listening...");
        this.mode = 1;
        this.firstTag = null;
        this.bounds = null;
        this.currentPosition = -1;
        this.topui.getResourceView().setClipboardSensitive(true);
        this.topui.togglePauseButton(true);
    }

    private void listenToClipboardPrev() {
        this.translatable = this.topui.getResourceView().newTextDocument(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLIPBOARD"));
        this.project.cancelBinaryMode();
        this.mode = 1;
        this.firstTag = null;
        this.bounds = null;
        this.currentPosition = -1;
        this.topui.getResourceView().setClipboardSensitive(true);
        TextDocument tr = (TextDocument)this.translatable;
        tr.setEditable(false);
        Document doc = tr.getDocument();
        StringBuffer sb = new StringBuffer();
        sb.append("Listening for source contents...");
        try {
            doc.insertString(0, sb.toString(), null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void sendToClipboard() {
        this.currentPosition = -1;
        this.currentSegment = null;
        if (this.translatable instanceof TextDocument) {
            TextDocument tr = (TextDocument)this.translatable;
            Document doc = tr.getDocument();
            try {
                String target = doc.getText(0, doc.getLength());
                if (!AppPreferences.clipboardHTMLExport) {
                    this.topui.getResourceView().addTargetToClipboard(target);
                    doc.remove(0, doc.getLength());
                } else {
                    this.topui.getResourceView().addHTMLTargetToClipboard(target);
                    doc.remove(0, doc.getLength());
                }
                String info = this.targetOut ? "Target contents sent out to the external application.\n\nListening for source contents..." : "Listening for source contents...";
                this.targetOut = false;
                doc.insertString(0, info, null);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.topui.toBack();
        }
    }

    private void end() {
        WorkflowManager manager;
        if (AppPreferences.autopilot && (manager = this.topui.getWorkflowView().getWorkflowManager()) != null) {
            manager.stopTimer();
        }
        if (this.mode == 1) {
            if (this.translatable != null) {
                // empty if block
            }
        } else {
            String phase = this.project.getPhase();
            if (this.project.align || phase != null && phase.equals("Alignment")) {
                this.topui.getWorkflowView().getWorkflowManager().reviewFirst();
                this.project.setPhase("Autoalignment");
                this.project.autoalign = true;
            } else if (phase != null && phase.equals("Review")) {
                this.topui.getWorkflowView().getWorkflowManager().reviewCurrent();
            } else {
                Object[] options = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT CURRENT DOCUMENT"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REVIEW SEGMENTS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK")};
                int i = JOptionPane.showOptionDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("READY TO EXPORT TRANSLATION."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT CURRENT DOCUMENT"), 1, 1, null, options, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT CURRENT DOCUMENT"));
                if (i == 0) {
                    this.topui.getWorkflowView().end();
                } else if (i == 1) {
                    this.topui.getWorkflowView().getWorkflowManager().reviewFirst();
                }
                this.project.setPhase("Review");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean start() {
        int n;
        block19: {
            block20: {
                XliffFile xfile;
                XliffFile xfile2;
                String format;
                XLIFF xliff = this.project.getXLIFF();
                if (!xliff.isCafeTranXLIFF) {
                    return false;
                }
                n = this.align ? 0 : (this.project.getCurrentTransUnit() == null ? this.project.mode : (this.project.getCurrentBinUnit() == null ? ((format = (xfile2 = xliff.getCurrentFile()).getAttribute("datatype")) != null && format.equals("x-clipboard") ? 3 : 0) : 2));
                if (n == 0 || n == 1) {
                    this.setTranslatableText();
                    if (this.translatable != null && this.translatableText != null) {
                        String href = this.translatable.getLocation();
                        String hhref = this.project.getSkeletonReference();
                        if (href != null) {
                            if (hhref != null) {
                                if (!hhref.equals(href) && !this.align) {
                                    JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THE SOURCE DOCUMENT IS ALREADY SET!"));
                                    return false;
                                }
                            } else {
                                this.project.setSkeletonReference(href);
                            }
                        }
                        this.project.cancelBinaryMode();
                        this.mode = 0;
                        this.firstTag = null;
                        this.bounds = null;
                        this.currentSegment = null;
                        this.prepareSegmentation();
                        this.setProgressBar();
                        break block19;
                    } else {
                        if (this.translatable == null) {
                            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO SOURCE DOCUMENT!"));
                        } else {
                            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO TEXT FOR IMPORT IN THE SOURCE DOCUMENT!"));
                        }
                        this.translatable = null;
                        return false;
                    }
                }
                if (n != 2) break block20;
                this.currentPosition = 0;
                this.translatable = null;
                String url = null;
                url = this.getImageURL();
                if (url != null) {
                    this.mode = 2;
                    if (xliff != null) {
                        xfile = xliff.getCurrentFile();
                        xfile.setAttribute("datatype", "x-image");
                    }
                } else {
                    if (xliff != null) {
                        xfile = xliff.getCurrentFile();
                        xfile.setAttribute("datatype", "x-image");
                    }
                    this.mode = 3;
                    url = "";
                }
                this.project.makeBinaryUnit(url);
                this.project.prepareTransUnit();
                Object[] options = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT SOURCE AND TARGET SEGMENTS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT TARGET SEGMENTS")};
                int i = JOptionPane.showOptionDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION OF IMAGES STARTED!"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE PAPER DOCUMENT"), 0, 1, null, options, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT TARGET SEGMENTS"));
                if (i == 0) {
                    this.topui.getSourcePane().setEditable(true);
                    AppPreferences.editSource = true;
                    break block19;
                } else if (i == 1) {
                    this.topui.setImageTranslationInterface();
                }
                break block19;
            }
            if (n != 3) return false;
            this.listenToClipboard();
        }
        this.indexPosition = 0;
        if (this.align) {
            if (this.justStarted) return true;
            this.align();
            return true;
        }
        this.targetPane.requestFocusInWindow();
        if (this.mode == 0 && n == 0) {
            this.nextSegment();
            if (this.unclean) return true;
            if (this.currentSegment != null) return true;
            return false;
        }
        this.project.updateViewMode(AppPreferences.projectView);
        return true;
    }

    public boolean setClipboardSource(String source) {
        if (source == null) {
            return false;
        }
        if (this.currentPosition == -1) {
            this.sourcePane.setCaretPosition(0);
            this.setTranslatableText(source);
            this.bounds = null;
            this.currentSegment = null;
            this.currentPosition = this.startPosition;
            this.indexPosition = 0;
            this.segmentText(this.translatableText, "");
            this.automate();
            return true;
        }
        return false;
    }

    public boolean setClipboardSourcePrev(String source) {
        if (source == null) {
            return false;
        }
        if (this.translatable instanceof TextDocument && this.currentPosition == -1) {
            TextDocument tr = (TextDocument)this.translatable;
            Document doc = tr.getDocument();
            try {
                this.sourceView.resetTagProtection();
                int len = doc.getLength();
                if (len > 0) {
                    doc.remove(0, len);
                }
                doc.insertString(0, source, null);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ResourceView.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.sourcePane.setCaretPosition(0);
            this.setTranslatableText();
            this.bounds = null;
            this.currentSegment = null;
            this.currentPosition = this.startPosition;
            this.indexPosition = 0;
            this.segmentText(this.translatableText, "");
            this.setProgressBar();
            List mems = this.mview.getLocalMemories();
            if (mems.size() > 0) {
                for (Object object : mems) {
                    List segs;
                    final Memory m = (Memory)object;
                    TermBase base = m.getTable();
                    if (base != null) {
                        m.loadDatabaseTM(base);
                    }
                    if (m.getWorkflowMode() != 1 || m.isActive() || (segs = this.getSegmentsList()) == null) continue;
                    SegmentParser cparser = m.getTMX().getParser();
                    cparser.clearCache();
                    this.mview.clearTMPane(m);
                    m.setPretranslated(true);
                    m.setActive(true);
                    MySwingWorker worker = new MySwingWorker(this){
                        final /* synthetic */ Workflow this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public Object construct() {
                            this.this$0.pretranslate(m, segs);
                            return null;
                        }

                        @Override
                        public void finished() {
                            m.removeMemoryProgress();
                            m.update();
                            m.setActive(false);
                        }
                    };
                    worker.start();
                }
            }
            return true;
        }
        return false;
    }

    public List getTags() {
        return this.tlist;
    }

    public List getPlaceables() {
        if (this.sortPlaceables && this.plist != null && this.plist.size() > 0) {
            this.sortPlaceables = false;
            Collections.sort(this.plist, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int i2;
                    Object[] a1 = (Object[])o1;
                    Object[] a2 = (Object[])o2;
                    int i1 = (Integer)a1[0];
                    if (i1 < (i2 = ((Integer)a2[0]).intValue())) {
                        return -1;
                    }
                    if (i1 == i2) {
                        String key1 = a1[1].toString();
                        String key2 = a2[1].toString();
                        if (key1.length() > key2.length()) {
                            return -1;
                        }
                        return 1;
                    }
                    return 1;
                }
            });
        }
        return this.plist;
    }

    public void addStringToPlaceables(String pl) {
        Placeables.addPlaceable(pl);
        Placeables.savePlaceables(pl);
    }

    private String markSourceTags(StyledDocument doc, String s) {
        this.segmentTags = new String[20];
        int arrIndex = 0;
        StringBuilder content = new StringBuilder();
        try {
            String con;
            Font font = this.sourcePane.getFont();
            Style style = doc.getStyle("");
            Style nstyle = doc.getStyle("Tags");
            Pattern tags = AppPreferences.mergeNeighboringTags ? XMLHelper.getTagGroupPattern() : XMLHelper.getTagsPattern();
            Matcher ma = tags.matcher(s);
            boolean spaceTag = false;
            boolean hideFormat = false;
            String format = null;
            int st = -1;
            int en = 0;
            int tagNo = 0;
            if (AppPreferences.projectType == 3 && AppPreferences.hideBoundaryTags) {
                format = this.project.getTagsFormat(null);
            }
            while (ma.find()) {
                st = ma.start();
                if (st >= en) {
                    String group;
                    con = s.substring(en, st);
                    if (con.length() > 0) {
                        if (AppPreferences.projectType == 1) {
                            if (!spaceTag && !con.startsWith(" ")) {
                                content.append(" ");
                            }
                            content.append(con);
                            spaceTag = con.endsWith(" ");
                        } else {
                            content.append(con);
                        }
                    }
                    if ((group = ma.group()).startsWith("<") && group.endsWith(">")) {
                        String sid;
                        int j;
                        boolean nontranslatableTag;
                        if (group.indexOf("xntr") != -1) {
                            nontranslatableTag = true;
                            hideFormat = true;
                        } else {
                            nontranslatableTag = false;
                        }
                        int i = group.indexOf("equiv-text=\"");
                        if (i != -1 && (j = group.indexOf("\"", i += 12)) != -1) {
                            String br = group.substring(i, j);
                            content.append(br);
                        }
                        if ((sid = Integer.toString(++tagNo)) != null) {
                            int fsize;
                            String n;
                            if (AppPreferences.projectType == 3 && group.indexOf("lock=") != -1) {
                                sid = sid + "L";
                            }
                            if (!AppPreferences.hideTagDetails && (n = this.project.getTagsXML(group, true)) != null && n.length() > 0) {
                                sid = sid + " " + n;
                            }
                            JLabel label = new JLabel(sid);
                            label.setHorizontalTextPosition(0);
                            label.setOpaque(false);
                            if (!AppPreferences.hideAllTags) {
                                label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                                fsize = AppPreferences.tagsfontsize;
                            } else {
                                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                                fsize = 0;
                            }
                            Font f = font.deriveFont(1, fsize);
                            label.setFont(f);
                            if (!nontranslatableTag) {
                                label.setForeground(new Color(AppPreferences.tagColor));
                            } else {
                                label.setForeground(new Color(AppPreferences.placeablesColor));
                            }
                            StyleConstants.setComponent(nstyle, label);
                        }
                        if (AppPreferences.projectType == 0) {
                            format = (String)formatMap.get(tagNo - 1);
                        }
                        if (format != null && !hideFormat) {
                            MutableAttributeSet fstyle = StyleHelper.getStyleForFormat(format);
                            doc.insertString(en, con, fstyle);
                            format = null;
                        } else {
                            doc.insertString(en, con, style);
                        }
                        doc.insertString(st, group, nstyle);
                        this.sourceView.protectTags(st, ma.end() - 1);
                        if (arrIndex < 20) {
                            this.segmentTags[arrIndex] = group;
                            ++arrIndex;
                        }
                        if (AppPreferences.projectType == 3) {
                            format = this.project.getTagsFormat(group);
                        }
                    } else {
                        content.append(" ");
                        doc.insertString(en, con, style);
                    }
                }
                en = ma.end();
            }
            if (st == -1) {
                if (AppPreferences.projectType == 0) {
                    format = (String)formatMap.get(tagNo);
                }
                if (format != null && !hideFormat) {
                    MutableAttributeSet fstyle = StyleHelper.getStyleForFormat(format);
                    doc.insertString(en, s, fstyle);
                } else {
                    doc.insertString(en, s, style);
                }
                content.append(s);
            } else if (en > 0 && en < s.length()) {
                con = s.substring(en);
                if (AppPreferences.projectType == 1) {
                    if (!spaceTag && !con.startsWith(" ")) {
                        content.append(" ");
                    }
                    content.append(con);
                } else {
                    content.append(con);
                }
                if (AppPreferences.projectType == 0) {
                    format = (String)formatMap.get(tagNo);
                }
                if (format != null && !hideFormat) {
                    MutableAttributeSet fstyle = StyleHelper.getStyleForFormat(format);
                    doc.insertString(en, con, fstyle);
                } else {
                    doc.insertString(en, con, style);
                }
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return content.toString();
    }

    public String markTargetTags(StyledDocument doc, String s) {
        StringBuilder content = new StringBuilder();
        try {
            Style style;
            Font font = this.targetPane.getFont();
            doc.putProperty("notags", true);
            Style nstyle = doc.getStyle("");
            Style tstyle = doc.getStyle("Tags");
            Style astyle = doc.getStyle("Added");
            Style dstyle = doc.getStyle("Deleted");
            Pattern tags = AppPreferences.mergeNeighboringTags ? XMLHelper.getTagGroupAndCustomTagsPattern() : XMLHelper.getTagsAndCustomTagsPattern();
            boolean spaceTag = false;
            boolean added = false;
            boolean deleted = false;
            String endTrackTag = null;
            Matcher ma = tags.matcher(s);
            int st = -1;
            int en = 0;
            int tagNo = 0;
            while (ma.find()) {
                style = added ? astyle : (deleted ? dstyle : nstyle);
                st = ma.start();
                boolean trackTagStart = false;
                boolean trackTagEnd = false;
                boolean locked = false;
                if (st >= en) {
                    String sid;
                    String con = s.substring(en, st);
                    if (AppPreferences.projectType == 1) {
                        if (!spaceTag && !con.startsWith(" ")) {
                            content.append(" ");
                        }
                        content.append(con);
                        spaceTag = con.endsWith(" ");
                    } else {
                        content.append(con);
                    }
                    String group = ma.group();
                    boolean nontranslatableTag = group.indexOf("xntr") != -1;
                    boolean endTag = false;
                    int i = group.indexOf(" track=");
                    if (i != -1 && group.indexOf("deleted", i) != -1) {
                        sid = "-";
                        deleted = true;
                        trackTagStart = true;
                        endTrackTag = "</" + group.substring(1, i) + ">";
                    } else if (i != -1 && group.indexOf("added", i) != -1) {
                        sid = "+";
                        added = true;
                        trackTagStart = true;
                        endTrackTag = "</" + group.substring(1, i) + ">";
                    } else if (group.endsWith("mark>")) {
                        sid = "m";
                        if (group.startsWith("</")) {
                            endTag = true;
                        }
                    } else if (group.endsWith("sub>")) {
                        sid = "s";
                        if (group.startsWith("</")) {
                            endTag = true;
                        }
                    } else if (group.endsWith("sup>")) {
                        sid = "r";
                        if (group.startsWith("</")) {
                            endTag = true;
                        }
                    } else if (group.endsWith("b>")) {
                        sid = "b";
                        if (group.startsWith("</")) {
                            endTag = true;
                        }
                    } else if (group.endsWith("i>")) {
                        sid = "i";
                        if (group.startsWith("</")) {
                            endTag = true;
                        }
                    } else if (group.endsWith("u>")) {
                        sid = "u";
                        if (group.startsWith("</")) {
                            endTag = true;
                        }
                    } else if (added && endTrackTag.equals(group)) {
                        sid = "+";
                        endTag = true;
                        added = false;
                        trackTagEnd = true;
                        endTrackTag = null;
                    } else if (deleted && endTrackTag.equals(group)) {
                        sid = "-";
                        endTag = true;
                        deleted = false;
                        trackTagEnd = true;
                        endTrackTag = null;
                    } else {
                        String n;
                        sid = Integer.toString(++tagNo);
                        if (AppPreferences.projectType == 3 && group.indexOf("lock=") != -1) {
                            locked = true;
                            sid = sid + "L";
                        }
                        if (!AppPreferences.hideTagDetails && (n = this.project.getTagsXML(group, false)) != null && n.length() > 0) {
                            sid = sid + " " + n;
                        }
                    }
                    doc.insertString(en, con, style);
                    if (sid != null) {
                        JLabel label = new JLabel(sid);
                        if (trackTagStart) {
                            label.putClientProperty("track", "start");
                        } else if (trackTagEnd) {
                            label.putClientProperty("track", "end");
                        } else if (added) {
                            label.putClientProperty("track", "added");
                        } else if (deleted) {
                            label.putClientProperty("track", "deleted");
                        }
                        label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
                        label.setHorizontalTextPosition(0);
                        label.setOpaque(false);
                        int fsize = AppPreferences.tagsfontsize;
                        Font f = endTag ? font.deriveFont(3, fsize) : font.deriveFont(1, fsize);
                        label.setFont(f);
                        if (!nontranslatableTag) {
                            label.setForeground(new Color(AppPreferences.tagColor));
                        } else {
                            label.setForeground(new Color(AppPreferences.placeablesColor));
                        }
                        StyleConstants.setComponent(tstyle, label);
                        doc.insertString(st, group, tstyle);
                    } else {
                        doc.insertString(st, group, tstyle);
                    }
                    if (trackTagStart || trackTagEnd || locked) {
                        this.targetView.protectTags(st, ma.end() - 1);
                    }
                }
                en = ma.end();
            }
            if (st == -1) {
                doc.insertString(0, s, null);
                content.append(s);
            } else if (en > 0 && en < s.length()) {
                style = added ? astyle : (deleted ? dstyle : nstyle);
                String con = s.substring(en);
                doc.insertString(en, con, style);
                if (AppPreferences.projectType == 1) {
                    if (!spaceTag && !con.startsWith(" ")) {
                        content.append(" ");
                    }
                    content.append(con);
                } else {
                    content.append(con);
                }
            }
            doc.putProperty("notags", null);
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            doc.putProperty("notags", null);
        }
        return content.toString();
    }

    private void findHistoryEntires() {
        LinkedHashMap emap = this.topui.getSourceView().getHistoryMap();
        if (emap != null) {
            Set elist = emap.keySet();
            try {
                for (String object : elist) {
                    object = object.substring(0, object.length()).toLowerCase();
                    StyledDocument doc = (StyledDocument)this.sourcePane.getDocument();
                    int len = doc.getLength();
                    String seg = doc.getText(0, len).toLowerCase();
                    int i = 0;
                    int ind = seg.indexOf(object, i);
                    while (ind != -1) {
                        Style style = doc.getStyle("highlight");
                        doc.setCharacterAttributes(ind, object.length(), style, true);
                        i = ind + object.length();
                        ind = seg.indexOf(object, i);
                    }
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean hasPlaceableInSegment(String key) {
        for (Object[] next : this.plist) {
            String p = next[1].toString();
            if (!p.equals(key)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPlaceableInAll(String key) {
        Matcher m;
        Set set = Placeables.getPlaceablesSet();
        if (set.contains(key)) {
            return true;
        }
        Pattern p = Placeables.getPlaceablePattern(key);
        return p != null && (m = p.matcher(key)).find();
    }

    private void findPlaceables(int offset, String seg, StyledDocument doc, HunSpellChecker spellchecher) {
        Set set = Placeables.getPlaceablesSet();
        Style style = doc.getStyle("Placeable");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Pattern p;
            String place = it.next().toString();
            if (place.charAt(0) != '|') {
                int start = seg.indexOf(place);
                if (start == -1) continue;
                p = Placeables.getPlaceablePattern(place);
                if (p == null) {
                    String sp = AppPreferences.noWordSeparatorSourceLanguage || place.length() < 2 ? "\\Q" + place + "\\E" : "\\b\\Q" + place + "\\E\\b";
                    p = Pattern.compile(sp);
                    Placeables.putPlaceablePattern(place, p);
                }
                Placeables.addCurrentPlaceablePattern(p);
                boolean masked = false;
                Matcher m = p.matcher(seg);
                while (m.find()) {
                    String cp;
                    int k;
                    start = m.start();
                    int end = m.end();
                    int offStart = offset + start;
                    int offEnd = offset + end;
                    Object ob = this.pmap.get(offStart);
                    if (ob != null && offEnd < (k = ((Integer)ob).intValue())) {
                        cp = Placeables.getPlaceablesForConversion(place);
                        if (cp == null) continue;
                        Placeables.addPlaceableToConversionMap(place, m);
                        continue;
                    }
                    this.markNontranslablePositions(offStart, offEnd);
                    Object[] o = new Object[]{offset + start, place};
                    this.plist.add(o);
                    this.pmap.put(offStart, offEnd);
                    cp = Placeables.getPlaceablesForConversion(place);
                    if (cp != null) {
                        Placeables.addPlaceableToConversionMap(place, m);
                    }
                    if (spellchecher != null) {
                        spellchecher.addPlaceableWord(place);
                    }
                    doc.setCharacterAttributes(offset + start, place.length(), style, false);
                    if (masked) continue;
                    Placeables.maskPlaceable(place);
                    masked = true;
                }
                continue;
            }
            String place2 = place.substring(1);
            p = Placeables.getPlaceablePattern(place);
            if (p == null) {
                p = Pattern.compile(place2);
                Placeables.putPlaceablePattern(place, p);
            }
            Placeables.addCurrentPlaceablePattern(p);
            Matcher m = p.matcher(seg);
            while (m.find()) {
                String cp;
                int k;
                String fplace = m.group();
                int start = m.start();
                int end = m.end();
                int offStart = offset + start;
                int offEnd = offset + end;
                Object ob = this.pmap.get(offStart);
                if (ob != null && offEnd < (k = ((Integer)ob).intValue())) {
                    cp = Placeables.getPlaceablesForConversion(place);
                    if (cp == null) continue;
                    Placeables.addPlaceableToConversionMap(fplace, m);
                    continue;
                }
                this.markNontranslablePositions(offStart, offEnd);
                Object[] o = new Object[]{offset + start, fplace};
                this.plist.add(o);
                this.pmap.put(offStart, offEnd);
                cp = Placeables.getPlaceablesForConversion(place);
                if (cp != null) {
                    Placeables.addPlaceableToConversionMap(fplace, m);
                }
                if (spellchecher != null) {
                    spellchecher.addPlaceableWord(fplace);
                }
                doc.setCharacterAttributes(offset + start, fplace.length(), style, false);
                Placeables.maskPlaceable(fplace);
            }
        }
    }

    private void markNontranslablePositions(int start, int end) {
        if (this.translatables != null && start < this.translatables.length && end < this.translatables.length) {
            for (int i = start; i < end; ++i) {
                this.translatables[i] = true;
            }
        }
    }

    void findPlaceablesAndTags() {
        try {
            Placeables.resetMasking();
            Placeables.clearCurrentPlaceables();
            this.plist.clear();
            this.pmap.clear();
            HunSpellChecker spellchecker = this.topui.getSpellChecker();
            if (spellchecker != null) {
                spellchecker.clearPlaceableWords();
            }
            this.tlist.clear();
            this.sortPlaceables = true;
            StyledDocument doc = (StyledDocument)this.sourcePane.getDocument();
            int len = doc.getLength();
            String seg = doc.getText(0, len);
            this.translatables = new boolean[seg.length()];
            Pattern tags = AppPreferences.mergeNeighboringTags ? XMLHelper.getTagGroupPattern() : XMLHelper.getTagsPattern();
            Matcher m = tags.matcher(seg);
            int tagNo = 0;
            int fstart = 0;
            int fend = 0;
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                this.markNontranslablePositions(start, end);
                fend = start;
                if (fend > fstart) {
                    String fragment = seg.substring(fstart, fend);
                    this.findPlaceables(fstart, fragment, doc, spellchecker);
                }
                fstart = end;
                String place = m.group();
                Object[] o = new Object[2];
                if (!place.startsWith("<") || !place.endsWith(">")) continue;
                o[0] = ++tagNo;
                o[1] = place;
                this.tlist.add(o);
            }
            if (seg.length() > fstart) {
                String fragment = seg.substring(fstart, seg.length());
                this.findPlaceables(fstart, fragment, doc, spellchecker);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    String autoAlign() {
        this.currentSegment = this.selectSegment(this.currentPosition);
        if (this.currentSegment != null) {
            while (this.bounds.startsWith("<x id=") && this.bounds.indexOf("x-break") == -1) {
                String prev = this.currentSegment + this.bounds;
                String seg = this.appendSegment(this.currentPosition);
                if (seg == null) break;
                this.currentSegment = prev + seg;
            }
        }
        return this.currentSegment;
    }

    String getCurrentSegment() {
        return this.currentSegment;
    }

    void setAlignmentPosition() {
        if (this.currentSegment != null) {
            int flen = 0;
            if (this.firstTag != null) {
                flen = this.firstTag.length();
            }
            this.project.setAlignmentPosition(this.indexPosition - flen, this.currentSegment.length() + flen, this.segBreak);
        }
    }

    void align() {
        while (this.bounds != null && this.bounds.indexOf("translatable=\"no\"") != -1) {
            this.currentSegment = this.selectSegment(this.currentPosition);
            if (this.currentSegment != null) continue;
        }
        this.currentSegment = this.selectSegment(this.currentPosition);
        if (this.currentSegment != null) {
            while (this.bounds.startsWith("<x id=") && this.bounds.indexOf("x-break") == -1) {
                String prev = this.currentSegment + this.bounds;
                String seg = this.appendSegment(this.currentPosition);
                if (seg == null) break;
                this.currentSegment = prev + seg;
            }
            if (!this.align) {
                this.sourceView.resetTagProtection();
            }
            try {
                String seg = this.currentSegment;
                StyledDocument sdoc = this.sourcePane.getStyledDocument();
                int len = sdoc.getLength();
                if (len > 0) {
                    sdoc.remove(0, len);
                }
                sdoc.insertString(0, seg, null);
                this.sourcePane.setCaretPosition(0);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    void appAlign() {
        String nbounds = this.bounds;
        this.currentSegment = this.appendSegment(this.currentPosition);
        if (this.currentSegment != null) {
            while (this.bounds.startsWith("<x id=") && this.bounds.indexOf("x-break") == -1) {
                String prev = this.currentSegment + this.bounds;
                String seg = this.appendSegment(this.currentPosition);
                if (seg == null) break;
                this.currentSegment = prev + seg;
            }
            if (!this.align) {
                this.sourceView.resetTagProtection();
            }
            try {
                StyledDocument sdoc = this.sourcePane.getStyledDocument();
                String prev = sdoc.getText(0, sdoc.getLength());
                prev = nbounds != null && prev.length() > 0 ? prev + nbounds + this.currentSegment : prev + this.currentSegment;
                int len = sdoc.getLength();
                if (len > 0) {
                    sdoc.remove(0, len);
                }
                sdoc.insertString(0, prev, null);
                this.sourcePane.setCaretPosition(0);
                this.currentSegment = prev;
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    void automateUncleaned() {
        if (this.translatable == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO SOURCE DOCUMENT!"));
            return;
        }
        while (this.currentPosition != -1) {
            this.setUncleanSegment(0);
        }
    }

    void automate() {
        if (this.translatable == null && this.translatableText == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO SOURCE DOCUMENT!"));
            return;
        }
        boolean ready = true;
        if (this.currentSegment != null) {
            ready = false;
        }
        boolean alignReady = true;
        boolean propagationSuspend = false;
        if (this.alignmentWorkflow != null) {
            if (this.alignmentWorkflow.getCurrentSegment() != null) {
                alignReady = false;
            }
            if (AppPreferences.propagate) {
                propagationSuspend = true;
                AppPreferences.propagate = false;
            }
        }
        Pattern commentPattern = null;
        if (this.commentRegEx != null) {
            commentPattern = Pattern.compile(this.commentRegEx);
        }
        this.autoSegmentation = true;
        while (true) {
            int len;
            String queryString;
            String comment = null;
            if (commentPattern != null && this.bounds != null) {
                Matcher m = commentPattern.matcher(this.bounds);
                while (m.find()) {
                    comment = m.group();
                }
            }
            while (this.bounds != null && this.bounds.indexOf("translatable=\"no\"") != -1) {
                this.currentSegment = this.selectSegment(this.currentPosition);
                if (this.currentSegment != null) continue;
            }
            if (ready) {
                this.currentSegment = this.selectSegment(this.currentPosition);
            } else {
                ready = true;
            }
            if (this.currentSegment == null) break;
            StringBuilder query = new StringBuilder(this.currentSegment);
            while (this.bounds.startsWith("<x id=") && this.bounds.indexOf("x-break") == -1) {
                int j;
                int i = this.bounds.indexOf("equiv-text=\"");
                if (i != -1 && (j = this.bounds.indexOf("\"", i += 12)) != -1) {
                    String br = this.bounds.substring(i, j);
                    query.append(br);
                }
                String prev = this.currentSegment + this.bounds;
                String seg = this.appendSegment(this.currentPosition);
                if (seg == null) break;
                query.append(seg);
                this.currentSegment = prev + seg;
            }
            this.project.prepareTransUnit();
            String value = null;
            if (this.alignmentWorkflow != null) {
                if (alignReady) {
                    value = this.alignmentWorkflow.autoAlign();
                } else {
                    value = this.alignmentWorkflow.getCurrentSegment();
                    alignReady = true;
                }
            } else if (AppPreferences.propagateToCurrentSegment && (value = this.project.getFromMemory(queryString = query.toString(), null)) == null && AppPreferences.autonumbers && NumbersHelper.isExtendedNumber(queryString)) {
                String fn;
                String rep;
                value = this.currentSegment;
                if (AppPreferences.replaceAtTransfer && !(rep = WorkflowView.replaceCharacters(value)).equals(value)) {
                    value = rep;
                }
                if (AppPreferences.formatnumbers && (fn = NumbersHelper.formatLocaleNumber(value)) != null) {
                    value = fn;
                }
            }
            String stag = "";
            String ttag = "";
            int flen = 0;
            if (this.firstTag != null) {
                flen = this.firstTag.length();
                stag = this.firstTag;
                ttag = this.firstTag;
            }
            String key = this.currentSegment;
            if (value == null) {
                value = AppPreferences.autosource ? this.currentSegment : "";
            }
            if ((len = value.length()) > 0) {
                this.updateCount(value);
            }
            if (this.alignmentWorkflow != null) {
                this.alignmentWorkflow.setAlignmentPosition();
            }
            if (commentPattern != null && this.headBounds != null) {
                Matcher m = commentPattern.matcher(this.headBounds);
                this.headBounds = null;
                while (m.find()) {
                    comment = m.group();
                }
            } else if (this.commentsMap != null && stag.length() > 0) {
                comment = (String)this.commentsMap.get(stag);
            }
            this.project.createTransUnit(stag + key, ttag + value, this.segBreak, this.indexPosition - flen, this.currentSegment.length() + flen, 0, comment);
        }
        this.currentPosition = -1;
        if (this.commentsMap != null) {
            this.commentsMap.clear();
        }
        this.autoSegmentation = false;
        if (propagationSuspend) {
            AppPreferences.propagate = true;
        }
    }

    void nextSegment() {
        String key = null;
        String value = null;
        try {
            if (!this.align) {
                this.sourceView.resetTagProtection();
                this.targetView.resetTagProtection();
            }
            StyledDocument sdoc = this.sourcePane.getStyledDocument();
            int slen = sdoc.getLength();
            key = sdoc.getText(0, slen);
            StyledDocument tdoc = this.targetPane.getStyledDocument();
            int tlen = tdoc.getLength();
            value = tdoc.getText(0, tlen);
            if (slen > 0) {
                sdoc.remove(0, slen);
            }
            if (tlen > 0) {
                tdoc.remove(0, tlen);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INTERNAL ERROR. TRY THIS SEGMENT AGAIN, PLEASE!"));
            this.setSource(key, false);
            this.setTarget(value);
            return;
        }
        if (key == null || value == null) {
            return;
        }
        if (this.translatable != null) {
            if (this.currentSegment != null) {
                this.nextTU(key, value);
            }
            if (this.unclean) {
                this.setUncleanSegment(0);
                return;
            }
            this.setSourceSegment();
            if (this.currentSegment != null) {
                this.project.prepareTransUnit();
            }
        } else {
            this.nextBU(key, value);
        }
        this.targetPane.requestFocusInWindow();
    }

    private void nextTU(String key, String value) {
        int len;
        String stag = "";
        int flen = 0;
        if (this.firstTag != null) {
            flen = this.firstTag.length();
            stag = this.firstTag;
        }
        if ((len = value.length()) == 0 && AppPreferences.projectView != -1) {
            if (AppPreferences.copysource) {
                value = key;
            }
        } else {
            this.targetOut = true;
        }
        this.updateCount(value);
        if (this.alignmentWorkflow != null) {
            this.alignmentWorkflow.setAlignmentPosition();
        }
        this.project.createTransUnit(stag + key, stag + value, this.segBreak, this.indexPosition - flen, this.currentSegment.length() + flen, this.targetView.getTUState(), null);
        if (AppPreferences.projectView != -1) {
            this.updateViews();
        }
        if (AppPreferences.clipboardTargetSegment) {
            if (!AppPreferences.clipboardHTMLExport) {
                this.topui.getResourceView().addTargetToClipboard(value);
            } else {
                XMLElement xml = this.project.getCurrentTransUnit();
                if (xml instanceof XLIFFUnit) {
                    XLIFFUnit tu = (XLIFFUnit)xml;
                    String htmlTarget = tu.getTargetXMLText();
                    this.topui.getResourceView().addHTMLTargetToClipboard(htmlTarget);
                }
            }
        }
    }

    private void nextBU(String key, String value) {
        MatchBoard mb;
        if (key.length() == 0) {
            key = value;
        }
        if (key.length() == 0) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EMPTY SEGMENT!"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORKFLOW ERROR"), 0);
            return;
        }
        this.updateCount(value);
        this.project.createTransUnit(key, value, null, this.indexPosition, key.length(), this.targetView.getTUState(), null);
        this.project.prepareTransUnit();
        if (AppPreferences.projectView != -1) {
            this.updateViews();
        }
        if ((mb = this.topui.getMatchBoard()) != null) {
            mb.clearMatchBoard();
        }
    }

    private void updateViews() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AppPreferences.projectView == 1) {
                    Workflow.this.project.updateSegmentView();
                } else if (AppPreferences.projectView == 0 || AppPreferences.projectView == 2) {
                    Workflow.this.project.updateContentView();
                }
            }
        });
    }

    void appSegment() {
        if (this.translatable == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO SOURCE SEGMENT!"));
            return;
        }
        this.appSourceSegment();
        this.targetPane.requestFocusInWindow();
    }

    void previewSegments(String path) {
        XLIFF xliff = this.project.getXLIFF();
        if (xliff != null && !xliff.isCafeTranXLIFF) {
            return;
        }
        if (xliff.isPO) {
            POHandler poh = new POHandler(this.project);
            poh.export(path);
            return;
        }
        if (this.mode > 0) {
            this.createDocument(path);
        } else {
            Translatable trans = this.translatable;
            if (trans == null) {
                ResourceView rv;
                Translatable[] tr;
                XliffFile xf;
                if (this.project.glue && (xf = xliff.getCurrentFile()) != null) {
                    this.project.openSkeleton(xf);
                }
                if ((trans = this.project.getTranslatable()) == null && (trans = (tr = (rv = this.topui.getResourceView()).getTranslatable())[0]) == null) {
                    trans = tr[1];
                }
            }
            if (trans != null) {
                trans.preview(this.project, path);
            } else {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot find the original source language document.");
            }
        }
    }

    boolean previewSegmentsWithNotes(String path) {
        ResourceView rv;
        Translatable[] tr;
        XLIFF xliff = this.project.getXLIFF();
        if (xliff != null && !xliff.isCafeTranXLIFF) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT WITH NOTES ONLY TO MS WORD, WRITER AND CALC DOCUMENTS"));
            return false;
        }
        if (this.mode > 0) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT WITH NOTES ONLY TO MS WORD, WRITER AND CALC DOCUMENTS"));
            return false;
        }
        Translatable trans = this.translatable;
        if (trans == null && (trans = this.project.getTranslatable()) == null && (trans = (tr = (rv = this.topui.getResourceView()).getTranslatable())[0]) == null) {
            trans = tr[1];
        }
        if (trans != null && trans instanceof MSOfficeDocument) {
            MSOfficeDocument mstrans = (MSOfficeDocument)trans;
            mstrans.previewWithNotes(this.project, path);
            return true;
        }
        if (trans != null && trans instanceof OpenOfficeDocument) {
            OpenOfficeDocument ootrans = (OpenOfficeDocument)trans;
            int appType = ootrans.getOfficeApplicationType();
            if (appType == 0 || appType == 1) {
                ootrans.previewWithNotes(this.project, path);
                return true;
            }
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT WITH NOTES ONLY TO MS WORD, WRITER AND CALC DOCUMENTS"));
            return false;
        }
        JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT WITH NOTES ONLY TO MS WORD, WRITER AND CALC DOCUMENTS"));
        return false;
    }

    private void createDocument(String spath) {
        ResourceView rv = this.topui.getResourceView();
        PlainDocument doc = new PlainDocument();
        this.project.translate(doc);
        String path = this.project.getProjectPath();
        if (path == null) {
            path = System.getProperty("user.home");
        } else {
            File file = new File(path);
            path = file.getParent();
        }
        String ext = ".doc";
        if (AppPreferences.imageExport == 0) {
            ext = ".doc";
        } else if (AppPreferences.imageExport == 1) {
            ext = ".odt";
        } else if (AppPreferences.imageExport == 2) {
            ext = ".txt";
        }
        path = spath == null ? path + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION") + ext : (spath.endsWith(ext) ? spath : spath + ext);
        if (path.endsWith(".doc") || path.endsWith(".odt")) {
            File file = new File(path);
            this.project.exportToWordProcessorHTML(file);
            rv.viewFile(file);
        } else {
            this.project.exportProject(3);
        }
        try {
            String target = doc.getText(0, doc.getLength());
            if (!AppPreferences.clipboardHTMLExport) {
                this.topui.getResourceView().addTargetToClipboard(target);
            } else {
                this.topui.getResourceView().addHTMLTargetToClipboard(target);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public List getSegmentsList() {
        if (this.translatable == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO SOURCE DOCUMENT!"));
            return null;
        }
        ArrayList<String> segments = new ArrayList<String>(100);
        int lpostion = this.currentPosition;
        int lindex = this.indexPosition;
        String lsegment = this.currentSegment;
        String lbounds = this.bounds;
        this.autoSegmentation = true;
        boolean ready = true;
        if (this.currentSegment != null) {
            ready = false;
        }
        while (true) {
            if (this.bounds != null && this.bounds.indexOf("translatable=\"no\"") != -1) {
                this.currentSegment = this.selectSegment(this.currentPosition);
                if (this.currentSegment != null) continue;
            }
            if (ready) {
                this.currentSegment = this.selectSegment(this.currentPosition);
            } else {
                ready = true;
            }
            if (this.currentSegment == null) break;
            StringBuilder query = new StringBuilder(this.currentSegment);
            while (this.bounds.startsWith("<x id=") && this.bounds.indexOf("x-break") == -1) {
                int j;
                int i = this.bounds.indexOf("equiv-text=\"");
                if (i != -1 && (j = this.bounds.indexOf("\"", i += 12)) != -1) {
                    String br = this.bounds.substring(i, j);
                    query.append(br);
                }
                String prev = this.currentSegment + this.bounds;
                String seg = this.appendSegment(this.currentPosition);
                if (seg == null) break;
                query.append(seg);
                this.currentSegment = prev + seg;
            }
            String queryString = query.toString();
            segments.add(queryString);
        }
        this.currentPosition = -1;
        this.currentPosition = lpostion;
        this.indexPosition = lindex;
        this.currentSegment = lsegment;
        this.bounds = lbounds;
        this.autoSegmentation = false;
        return segments;
    }

    public void pretranslate(Memory tm, List segments) {
        SegmentParser parser = tm.getTMX().getParser();
        String procName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING") + "...";
        tm.initMemoryProgress(0, segments.size(), procName);
        int count = 0;
        Iterator it = segments.iterator();
        while (it.hasNext() && !tm.isClosed()) {
            String cs;
            String segment = (String)it.next();
            if (segment.length() > 0 && (cs = parser.cleanSegment(segment)).trim().length() > 0) {
                parser.translate(segment, cs, null, true);
            }
            tm.update();
            if (++count % 10 != 0) continue;
            tm.updateMemoryProgress(count, tm.getName(), true);
        }
    }

    void startProgress(String m) {
        int min = 0;
        int max = 100;
        this.pm = new ProgressMonitor(this.topui, m, "", min, max);
        this.pm.setMillisToPopup(0);
        this.pm.setMillisToDecideToPopup(0);
    }

    boolean hasSegments() {
        return this.currentSource != null || this.currentTarget != null;
    }

    public void resetSegments() {
        if (this.currentSource != null) {
            this.setSource(this.currentSource, this.resetLookup);
            this.currentSource = null;
            this.resetLookup = false;
        }
        if (this.currentTarget != null) {
            this.setTarget(this.currentTarget);
            this.currentTarget = null;
        }
        if (this.currentPosition != -1 && this.mode < 2) {
            this.setProgressBar();
        }
    }

    public void saveCurrentContext() {
        this.currentSource = this.getSource();
        this.currentTarget = this.getTarget();
    }

    public void lookUpSegment() {
        if (this.segmentForMemory != null) {
            this.findHistoryEntires();
            this.findPlaceablesAndTags();
            this.sourcePane.setCaretPosition(0);
            if (AppPreferences.automaticMatching && this.segmentForMemory.length() > 0 && this.segmentForMemory.length() < 3001) {
                this.lookUp();
            }
            this.segmentForMemory = null;
            this.segmentForAutoAssembling = null;
        }
    }

    public void setLookupSegments(String m, String g, String aa) {
        this.segmentForMemory = m;
        this.segmentForGlossary = g;
        this.segmentForAutoAssembling = aa;
    }

    public void refreshTargetPane() {
        this.targetView.resetTagProtection();
        StyledDocument doc = (StyledDocument)this.targetPane.getDocument();
        int len = doc.getLength();
        if (len > 0) {
            try {
                String s = doc.getText(0, len);
                this.setTarget(s);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void refreshSourcePane() {
        StyledDocument doc = (StyledDocument)this.sourcePane.getDocument();
        int len = doc.getLength();
        if (len > 0) {
            if (!AppPreferences.sourceSegmentFormatting) {
                formatMap.clear();
            }
            this.sourceView.resetTagProtection();
            String source = null;
            try {
                source = doc.getText(0, len);
                doc.remove(0, len);
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (source != null) {
                this.markSourceTags(doc, source);
                this.findPlaceablesAndTags();
            }
        }
    }

    public void setSource(String source, boolean lookup) {
        StyledDocument doc = (StyledDocument)this.sourcePane.getDocument();
        try {
            this.sourceView.resetTagProtection();
            int len = doc.getLength();
            if (len > 0) {
                doc.remove(0, len);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (source.length() > 0) {
            if (AppPreferences.mouseTags && AppPreferences.mouseTagsDeactivation) {
                AppPreferences.mouseTags = false;
                this.topui.getWorkflowView().setMouseTagsMenu(AppPreferences.mouseTags);
                this.topui.getTargetView().toggleTagsButton(AppPreferences.mouseTags);
            }
            this.segmentTagged = source;
            String sourceSegment = this.markSourceTags(doc, source);
            if (this.mode == 1 || this.segmentForMemory == null) {
                this.segmentForMemory = sourceSegment;
                this.segmentForAutoAssembling = sourceSegment;
            }
            if (AppPreferences.ttsSpeak == 0) {
                this.segmentForTTS = sourceSegment;
            }
            this.findHistoryEntires();
            this.findPlaceablesAndTags();
            this.sourcePane.setCaretPosition(0);
            if (this.topui.getResourceLoader().isStartupLoading()) {
                this.topui.getResourceLoader().setStartupLoading(false);
                return;
            }
            if (!this.noLookup && lookup && this.segmentForMemory.length() > 0 && this.segmentForMemory.length() < 3001) {
                this.lookUp();
            }
        } else {
            this.segmentForMemory = "";
            this.segmentForAutoAssembling = "";
            this.segmentForGlossary = null;
        }
    }

    public void setTarget(String target) {
        StyledDocument doc;
        TrackingChanges trackingChanges = this.topui.getTrackingChanges();
        if (trackingChanges != null) {
            trackingChanges.track(false);
        }
        this.topui.getTargetView().getUndoHandler().resetUndoManager();
        if (!this.align) {
            this.targetView.resetTagProtection();
        }
        if ((doc = (StyledDocument)this.targetPane.getDocument()).getLength() > 0) {
            try {
                doc.remove(0, doc.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (target.length() > 0) {
            String s = this.markTargetTags(doc, target);
            if (AppPreferences.ttsSpeak == 1) {
                this.segmentForTTS = s;
            }
        }
        this.targetPane.setCaretPosition(0);
    }

    public String getSource() {
        Document doc = this.sourcePane.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public String getTarget() {
        Document doc = this.targetPane.getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(Workflow.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public StyledDocument getTargetDocument() {
        StyledDocument doc = (StyledDocument)this.targetPane.getDocument();
        return doc;
    }

    public String getSegmentForAutoAssembling() {
        if (this.segmentForAutoAssembling != null) {
            return this.segmentForAutoAssembling;
        }
        return this.segmentForMemory;
    }

    public Matcher getSegments() {
        return this.matcher;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }
}

