/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.Abbreviations;
import translator.AppPreferences;
import translator.KeyPreferences;
import translator.MT;
import translator.MainView;
import translator.MatchBoard;
import translator.Project;
import translator.Prompter;
import translator.Resource;
import translator.TranslatableHandler;
import translator.TranslationHandler;
import translator.Workflow;
import translator.WorkflowManager;
import translator.XMLElement;
import translator.XMLHelper;
import translator.ai.CTLinguist;
import translator.browser.WebResourceFX;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.ui.Colors;
import translator.xliff.FileHeader;
import translator.xliff.Skeleton;
import translator.xliff.XLIFF;
import translator.xliff.XliffFile;

public class WorkflowView
extends JPanel {
    private MainView topui;
    private JMenu translateMenu;
    private JMenu actionMenu;
    private JToolBar transBar;
    private WorkflowManager manager;
    private static String[] sourceReplaceArray;
    private static String[] targetReplaceArray;
    private static String[] sourcePunctReplaceArray;
    private static String[] targetPunctReplaceArray;
    JMenuItem addItem;
    JMenuItem addItemGoToUntranslated;
    JMenuItem addCheckedItem;
    JMenuItem addCheckedItemGoToUchecked;
    JMenuItem nextItem;
    JMenuItem previousItem;
    JMenuItem joinItem;
    JMenuItem splitItem;
    JMenuItem menuItemAutoComplete;
    JMenuItem firstFuzzyItem;
    JMenuItem secondFuzzyItem;
    JMenuItem thirdFuzzyItem;
    JMenuItem autoMatchItem;
    JMenuItem subsegmentItem;
    JMenuItem machineItem;
    JMenuItem transferSourceItem;
    JMenuItem transferWebMTItem;
    JMenuItem transferDeepLItem;
    JMenuItem transferGTItem;
    JMenuItem transferBingItem;
    JMenuItem transferMyMemoryItem;
    JMenuItem transferYandexItem;
    JMenuItem transferWatsonItem;
    JMenuItem transferAmazonItem;
    JMenuItem transferAIItem;
    JMenuItem tagsItem;
    JMenuItem currentTagItem;
    JCheckBoxMenuItem hideTagDetailsMenu;
    JCheckBoxMenuItem hideAllTagsMenu;
    JCheckBoxMenuItem hideBoundaryTagsMenu;
    JCheckBoxMenuItem mergeNeighboringMenu;
    JMenuItem talkToAIItem;
    JMenuItem translateSegmentItem;
    JMenuItem addTermMemoryItem;
    JMenuItem addTermResourceItem;
    JMenuItem altTranslationItem;
    JMenuItem noteItem;
    JMenuItem bookmarkItem;
    JCheckBoxMenuItem mouseTagsMenu;

    WorkflowView(MainView parent) {
        this.topui = parent;
        this.setLayout(new BorderLayout());
        this.transBar = new JToolBar();
        this.add((Component)this.transBar, "North");
        this.setTranslationMenu();
        this.setActionMenu();
        this.manager = new WorkflowManager(parent);
        WorkflowView.setReplacementArrays(AppPreferences.replaceSourceChars, AppPreferences.replaceTargetChars);
        WorkflowView.setPunctReplacementArrays(AppPreferences.replacePunctSourceChars, AppPreferences.replacePunctTargetChars);
    }

    public JMenu getTranslateMenu() {
        return this.translateMenu;
    }

    public JMenu getActionMenu() {
        return this.actionMenu;
    }

    private void setActionMenu() {
        this.actionMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION"));
        this.actionMenu.setName("MenuTransAction");
        this.addItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SEGMENT TO MEMORY AND GO TO NEXT SEGMENT"));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE_TO_GO, (int)this.addItem.getFont().getSize(), (Color)this.addItem.getForeground());
        this.addItem.setIcon((Icon)ficon);
        this.addItem.setName("MenuTransActionAddSegmentToMemoryAndGoToNext");
        KeyStroke ks = KeyPreferences.getKeyStroke("k1");
        if (ks != null) {
            this.addItem.setAccelerator(ks);
        }
        this.addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.add(0, false);
            }
        });
        this.actionMenu.add(this.addItem);
        this.addItemGoToUntranslated = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SEGMENT TO MEMORY AND GO TO NEXT UNTRANSLATED SEGMENT"));
        this.addItemGoToUntranslated.setName("MenuTransActionAddSegmentAndGoToNextUntranslated");
        ks = KeyPreferences.getKeyStroke("k52");
        if (ks != null) {
            this.addItemGoToUntranslated.setAccelerator(ks);
        }
        this.addItemGoToUntranslated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.add(0, true);
            }
        });
        this.actionMenu.add(this.addItemGoToUntranslated);
        this.addCheckedItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD CHECKED SEGMENT TO MEMORY AND GO TO NEXT SEGMENT"));
        this.addCheckedItem.setName("MenuTransActionAddCheckedSegmentAndGoToNext");
        ks = KeyPreferences.getKeyStroke("k81");
        if (ks != null) {
            this.addCheckedItem.setAccelerator(ks);
        }
        this.addCheckedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.addChecked(false);
            }
        });
        this.actionMenu.add(this.addCheckedItem);
        this.addCheckedItemGoToUchecked = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD CHECKED SEGMENT TO MEMORY AND GO TO NEXT UNCHECKED SEGMENT"));
        this.addCheckedItemGoToUchecked.setName("MenuTransActionAddCheckedSegmentAndGoToNextUnchecked");
        ks = KeyPreferences.getKeyStroke("k82");
        if (ks != null) {
            this.addCheckedItemGoToUchecked.setAccelerator(ks);
        }
        this.addCheckedItemGoToUchecked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.addChecked(true);
            }
        });
        this.actionMenu.add(this.addCheckedItemGoToUchecked);
        this.actionMenu.addSeparator();
        this.nextItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MOVE TO THE NEXT SEGMENT"));
        this.nextItem.setName("MenuTransActionNextSegment");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT_BOLD_CIRCLE_OUTLINE, (int)this.nextItem.getFont().getSize(), (Color)this.nextItem.getForeground());
        this.nextItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k2");
        if (ks != null) {
            this.nextItem.setAccelerator(ks);
        }
        this.nextItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.next(0);
            }
        });
        this.actionMenu.add(this.nextItem);
        this.previousItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MOVE TO THE PREVIOUS SEGMENT"));
        this.previousItem.setName("MenuTransActionPreviousSegment");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_LEFT_BOLD_CIRCLE_OUTLINE, (int)this.previousItem.getFont().getSize(), (Color)this.previousItem.getForeground());
        this.previousItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k3");
        if (ks != null) {
            this.previousItem.setAccelerator(ks);
        }
        this.previousItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.review();
            }
        });
        this.actionMenu.add(this.previousItem);
        this.joinItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOIN SEGMENTS"));
        this.joinItem.setName("MenuTransActionJoinSegments");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CALL_MERGE, (int)this.joinItem.getFont().getSize(), (Color)this.joinItem.getForeground());
        this.joinItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k4");
        if (ks != null) {
            this.joinItem.setAccelerator(ks);
        }
        this.joinItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.append(0);
            }
        });
        this.actionMenu.add(this.joinItem);
        this.splitItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPLIT SEGMENT"));
        this.splitItem.setName("MenuTransActionSplitSegments");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CALL_SPLIT, (int)this.splitItem.getFont().getSize(), (Color)this.splitItem.getForeground());
        this.splitItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k5");
        if (ks != null) {
            this.splitItem.setAccelerator(ks);
        }
        this.splitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = WorkflowView.this.topui.getProjectView().getProject();
                if (project != null) {
                    project.splitSegment();
                }
            }
        });
        this.actionMenu.add(this.splitItem);
        this.actionMenu.addSeparator();
        JCheckBoxMenuItem autoPilotMenu = new JCheckBoxMenuItem();
        autoPilotMenu.setSelected(AppPreferences.autopilot);
        autoPilotMenu.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOPILOT"));
        autoPilotMenu.setName("MenuAutopilot");
        autoPilotMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                if (state == 1) {
                    AppPreferences.autopilot = true;
                    WorkflowManager manager = WorkflowView.this.getWorkflowManager();
                    if (manager != null) {
                        manager.setTimer(AppPreferences.autopilot);
                        WorkflowView.this.topui.getTargetView().setTimerUI(true);
                    }
                } else {
                    AppPreferences.autopilot = false;
                    WorkflowManager manager = WorkflowView.this.getWorkflowManager();
                    if (manager != null) {
                        manager.setTimer(AppPreferences.autopilot);
                        WorkflowView.this.topui.getTargetView().setTimerUI(false);
                    }
                }
            }
        });
        JCheckBoxMenuItem automaticMatchingMenu = new JCheckBoxMenuItem();
        automaticMatchingMenu.setSelected(AppPreferences.automaticMatching);
        automaticMatchingMenu.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC SEARCHING"));
        automaticMatchingMenu.setName("MenuAutomaticSearching");
        automaticMatchingMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                if (state == 1) {
                    AppPreferences.automaticMatching = true;
                } else {
                    AppPreferences.automaticMatching = false;
                    MatchBoard mb = WorkflowView.this.topui.getMatchBoard();
                    if (mb != null) {
                        mb.clearMatchBoard();
                    }
                }
            }
        });
        this.actionMenu.add(autoPilotMenu);
        this.actionMenu.add(automaticMatchingMenu);
        this.actionMenu.addSeparator();
        JMenu tagsMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TAGS"));
        tagsMenu.setName("MenuTransTags");
        this.mouseTagsMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MOUSE TAG PLACEMENT"));
        this.mouseTagsMenu.setName("MenuTransTagsMouseTagPlacement");
        ks = KeyPreferences.getKeyStroke("k66");
        if (ks != null) {
            this.mouseTagsMenu.setAccelerator(ks);
        }
        this.mouseTagsMenu.setSelected(false);
        this.mouseTagsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppPreferences.mouseTags = !AppPreferences.mouseTags;
                WorkflowView.this.topui.getTargetView().toggleTagsButton(AppPreferences.mouseTags);
            }
        });
        JCheckBoxMenuItem mouseTagsDeactivationMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MOUSE TAG PLACEMENT AUTO DEACTIVATION"));
        mouseTagsDeactivationMenu.setName("MenuTransTagsMouseTagPlacementAutoDeactivation");
        mouseTagsDeactivationMenu.setSelected(AppPreferences.mouseTagsDeactivation);
        mouseTagsDeactivationMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppPreferences.mouseTagsDeactivation = !AppPreferences.mouseTagsDeactivation;
            }
        });
        this.tagsItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LIST TAGS"));
        this.tagsItem.setName("MenuTransTagsListTags");
        ks = KeyPreferences.getKeyStroke("k17");
        if (ks != null) {
            this.tagsItem.setAccelerator(ks);
        }
        this.tagsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension frmSize = WorkflowView.this.topui.getSize();
                Point loc = WorkflowView.this.topui.getLocation();
                int w = frmSize.width / 2;
                int x = w - w / 2 + loc.x;
                int y = frmSize.height / 2 + loc.y;
                WorkflowView.this.topui.getTargetView().showTagsPopUp(WorkflowView.this.topui, x, y);
            }
        });
        this.currentTagItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER CURRENT TAG"));
        this.currentTagItem.setName("MenuTransTagsTransferCurrentTag");
        ks = KeyPreferences.getKeyStroke("k18");
        if (ks != null) {
            this.currentTagItem.setAccelerator(ks);
        }
        this.currentTagItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getTargetView().transferCurrentTag();
            }
        });
        JCheckBoxMenuItem autoTransferTagsMenuItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC TRANSFER OF REMAINING TAGS"));
        autoTransferTagsMenuItem.setName("MenuTransTagsAutoTransferRemainingTags");
        autoTransferTagsMenuItem.setSelected(AppPreferences.autoTransferTags);
        autoTransferTagsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppPreferences.autoTransferTags = !AppPreferences.autoTransferTags;
            }
        });
        this.mergeNeighboringMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MERGE ADJACENT TAGS"));
        this.mergeNeighboringMenu.setName("MenuTransTagsMergeAdjacentTags");
        ks = KeyPreferences.getKeyStroke("k105");
        if (ks != null) {
            this.mergeNeighboringMenu.setAccelerator(ks);
        }
        this.mergeNeighboringMenu.setSelected(AppPreferences.mergeNeighboringTags);
        this.mergeNeighboringMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                AppPreferences.mergeNeighboringTags = !AppPreferences.mergeNeighboringTags;
                Project p = WorkflowView.this.topui.getProjectView().getProject();
                if (p != null && (i = p.getCurrenTUIndex()) != -1) {
                    p.edit("#" + Integer.toString(i));
                }
            }
        });
        this.hideBoundaryTagsMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIDE SEGMENT BOUNDARY TAGS"));
        this.hideBoundaryTagsMenu.setName("MenuTransTagsHideSegmentBoundaryTags");
        ks = KeyPreferences.getKeyStroke("k104");
        if (ks != null) {
            this.hideBoundaryTagsMenu.setAccelerator(ks);
        }
        this.hideBoundaryTagsMenu.setSelected(AppPreferences.hideBoundaryTags);
        this.hideBoundaryTagsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                AppPreferences.hideBoundaryTags = !AppPreferences.hideBoundaryTags;
                Project p = WorkflowView.this.topui.getProjectView().getProject();
                if (p != null && (i = p.getCurrenTUIndex()) != -1) {
                    p.edit("#" + Integer.toString(i));
                }
            }
        });
        this.hideTagDetailsMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIDE TAG DETAILS"));
        this.hideTagDetailsMenu.setName("MenuTransTagsHideDetails");
        ks = KeyPreferences.getKeyStroke("k97");
        if (ks != null) {
            this.hideTagDetailsMenu.setAccelerator(ks);
        }
        this.hideTagDetailsMenu.setSelected(AppPreferences.hideTagDetails);
        this.hideTagDetailsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppPreferences.hideTagDetails = !AppPreferences.hideTagDetails;
                WorkflowView.this.getWorkflowManager().getWorkflow().refreshSourcePane();
                WorkflowView.this.getWorkflowManager().getWorkflow().refreshTargetPane();
            }
        });
        this.hideAllTagsMenu = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIDE SOURCE SEGMENT TAGS"));
        this.hideAllTagsMenu.setName("MenuTransTagsHideSourceSegmentTags");
        this.hideAllTagsMenu.setSelected(AppPreferences.hideAllTags);
        this.hideAllTagsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppPreferences.hideAllTags = !AppPreferences.hideAllTags;
                WorkflowView.this.getWorkflowManager().getWorkflow().refreshSourcePane();
            }
        });
        tagsMenu.add(this.mouseTagsMenu);
        tagsMenu.add(mouseTagsDeactivationMenu);
        tagsMenu.add(this.tagsItem);
        tagsMenu.add(this.currentTagItem);
        tagsMenu.add(autoTransferTagsMenuItem);
        tagsMenu.addSeparator();
        tagsMenu.add(this.hideTagDetailsMenu);
        tagsMenu.add(this.hideBoundaryTagsMenu);
        tagsMenu.add(this.mergeNeighboringMenu);
        tagsMenu.add(this.hideAllTagsMenu);
        this.actionMenu.add(tagsMenu);
        this.actionMenu.addSeparator();
        JMenu jumpMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SKIP"));
        jumpMenu.setName("MenuTransJump");
        JCheckBoxMenuItem skipTranslatedItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATED SEGMENTS"));
        skipTranslatedItem.setName("MenuTransJumpTranslatedSegs");
        skipTranslatedItem.setSelected(AppPreferences.skipTranslated);
        skipTranslatedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipTranslated = item.isSelected();
            }
        });
        JCheckBoxMenuItem repeatItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REPEATED SEGMENTS"));
        repeatItem.setName("MenuTransJumpRepeatedSegs");
        repeatItem.setSelected(AppPreferences.skipRepetions);
        repeatItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipRepetions = item.isSelected();
            }
        });
        JCheckBoxMenuItem noLettersItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTS WITH NO LETTERS"));
        noLettersItem.setName("MenuTransJumpSegsWithNoLetters");
        noLettersItem.setSelected(AppPreferences.skipNoLetters);
        noLettersItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipNoLetters = item.isSelected();
            }
        });
        JCheckBoxMenuItem numberItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NUMBERS"));
        numberItem.setName("MenuTransJumpNumbers");
        numberItem.setSelected(AppPreferences.skipNumbers);
        numberItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipNumbers = item.isSelected();
            }
        });
        JCheckBoxMenuItem checkedItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECKED SEGMENTS"));
        checkedItem.setName("MenuTransJumpChecked");
        checkedItem.setSelected(AppPreferences.skipReviewed);
        checkedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipReviewed = item.isSelected();
            }
        });
        JCheckBoxMenuItem lockedItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOCKED SEGMENTS"));
        lockedItem.setName("MenuTransJumpLocked");
        lockedItem.setSelected(AppPreferences.skipLocked);
        lockedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipLocked = item.isSelected();
            }
        });
        JCheckBoxMenuItem perfectItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXACT MEMORY MATCHES"));
        perfectItem.setName("MenuTransJumpExactMemoryMatches");
        perfectItem.setSelected(AppPreferences.skipPerfectMatches);
        perfectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipPerfectMatches = item.isSelected();
            }
        });
        JCheckBoxMenuItem fuzzyItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOTRANSLATION AND FUZZY MATCHES"));
        fuzzyItem.setName("MenuTransJumpAutoAssemblingAndFuzzyMatches");
        fuzzyItem.setSelected(AppPreferences.skipAutoMatches);
        fuzzyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipAutoMatches = item.isSelected();
            }
        });
        JCheckBoxMenuItem noMatchItem = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO MATCHES"));
        noMatchItem.setName("MenuTransJumpNoMatches");
        noMatchItem.setSelected(AppPreferences.skipNoMatches);
        noMatchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                AppPreferences.skipNoMatches = item.isSelected();
            }
        });
        jumpMenu.add(skipTranslatedItem);
        jumpMenu.add(repeatItem);
        jumpMenu.add(noLettersItem);
        jumpMenu.add(numberItem);
        jumpMenu.addSeparator();
        jumpMenu.add(checkedItem);
        jumpMenu.add(lockedItem);
        jumpMenu.add(perfectItem);
        jumpMenu.add(fuzzyItem);
        jumpMenu.add(noMatchItem);
        this.actionMenu.add(jumpMenu);
        this.actionMenu.addSeparator();
        this.addTermMemoryItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD FRAGMENT TO MEMORY"));
        this.addTermMemoryItem.setName("MenuTransAddFragmentToMemory");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)this.addTermMemoryItem.getFont().getSize(), (Color)this.addTermMemoryItem.getForeground());
        this.addTermMemoryItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k26");
        if (ks != null) {
            this.addTermMemoryItem.setAccelerator(ks);
        }
        this.addTermMemoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.skipTermWindowShortcut) {
                    MemoryView mv = WorkflowView.this.topui.getMemoryView();
                    mv.addPhraseDirectToMemory();
                } else {
                    WorkflowView.this.addPhraseToMemory();
                }
            }
        });
        this.actionMenu.add(this.addTermMemoryItem);
        this.addTermResourceItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD TERM TO GLOSSARY"));
        this.addTermResourceItem.setName("MenuTransAddTermToGlossary");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_PENCIL, (int)this.addTermResourceItem.getFont().getSize(), (Color)this.addTermResourceItem.getForeground());
        this.addTermResourceItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k27");
        if (ks != null) {
            this.addTermResourceItem.setAccelerator(ks);
        }
        this.addTermResourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.skipTermWindowShortcut) {
                    WorkflowView.this.addDirectEntryToGlossary();
                } else {
                    WorkflowView.this.addEntryToGlossary();
                }
            }
        });
        this.actionMenu.add(this.addTermResourceItem);
        this.actionMenu.addSeparator();
        this.altTranslationItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ALTERNATIVE TRANSLATION"));
        this.altTranslationItem.setName("MenuTransAlternativeTranslation");
        ks = KeyPreferences.getKeyStroke("k28");
        if (ks != null) {
            this.altTranslationItem.setAccelerator(ks);
        }
        this.altTranslationItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = WorkflowView.this.topui.getProjectView().getProject();
                if (project != null) {
                    project.createAltTrans();
                }
            }
        });
        this.actionMenu.add(this.altTranslationItem);
        this.noteItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD SEGMENT NOTE"));
        this.noteItem.setName("MenuTransAddSegmentNote");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COMMENT, (int)this.noteItem.getFont().getSize(), (Color)this.noteItem.getForeground());
        this.noteItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k29");
        if (ks != null) {
            this.noteItem.setAccelerator(ks);
        }
        this.noteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = WorkflowView.this.topui.getProjectView().getProject();
                if (project != null) {
                    project.createNote();
                }
            }
        });
        this.actionMenu.add(this.noteItem);
        this.bookmarkItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BOOKMARK SEGMENT"));
        this.bookmarkItem.setName("MenuTransBookmarkSegment");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_BOOKMARK, (int)this.bookmarkItem.getFont().getSize(), (Color)this.bookmarkItem.getForeground());
        this.bookmarkItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k30");
        if (ks != null) {
            this.bookmarkItem.setAccelerator(ks);
        }
        this.bookmarkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project = WorkflowView.this.topui.getProjectView().getProject();
                if (project != null) {
                    project.toggleBookmark();
                }
            }
        });
        this.actionMenu.add(this.bookmarkItem);
    }

    private void setTranslationMenu() {
        this.translateMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE"));
        this.translateSegmentItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE SELECTED FRAGMENT"));
        this.translateSegmentItem.setName("MenuTransTranslateSelectedFragment");
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TRANSLATE, (int)this.translateSegmentItem.getFont().getSize(), (Color)this.translateSegmentItem.getForeground());
        this.translateSegmentItem.setIcon((Icon)ficon);
        KeyStroke ks = KeyPreferences.getKeyStroke("k25");
        if (ks != null) {
            this.translateSegmentItem.setAccelerator(ks);
        }
        this.translateSegmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.translate();
            }
        });
        this.translateMenu.add(this.translateSegmentItem);
        this.talkToAIItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TALK TO AI"));
        this.talkToAIItem.setName("MenuTransTalkToAI");
        ks = KeyPreferences.getKeyStroke("k122");
        if (ks != null) {
            this.talkToAIItem.setAccelerator(ks);
        }
        this.talkToAIItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getResourceView().speakToAI();
            }
        });
        this.translateMenu.add(this.talkToAIItem);
        this.translateMenu.addSeparator();
        this.machineItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LIST AUTOASSEMBLING AND FUZZY MATCHES"));
        this.machineItem.setName("MenuTransSegMatchesListAutoAssemblingAndFuzzyMatches");
        ks = KeyPreferences.getKeyStroke("k12");
        if (ks != null) {
            this.machineItem.setAccelerator(ks);
        }
        this.machineItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getMemoryView().showAutoTranslationPopUp();
            }
        });
        this.translateMenu.add(this.machineItem);
        this.subsegmentItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LIST SUBSEGMENT MATCHES"));
        this.subsegmentItem.setName("MenuTransSegMatchesListSubsegmentMatches");
        ks = KeyPreferences.getKeyStroke("k11");
        if (ks != null) {
            this.subsegmentItem.setAccelerator(ks);
        }
        this.subsegmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getMemoryView().showAutoMatchesPopUp();
            }
        });
        this.translateMenu.add(this.subsegmentItem);
        this.firstFuzzyItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BEST FUZZY MATCH 1"));
        this.firstFuzzyItem.setName("MenuTransSegMatchesInsertFuzzy1");
        ks = KeyPreferences.getKeyStroke("k7");
        if (ks != null) {
            this.firstFuzzyItem.setAccelerator(ks);
        }
        this.firstFuzzyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getMemoryView().insertFuzzyMatchOne();
            }
        });
        this.translateMenu.add(this.firstFuzzyItem);
        this.secondFuzzyItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BEST FUZZY MATCH 2"));
        this.secondFuzzyItem.setName("MenuTransSegMatchesInsertFuzzy2");
        ks = KeyPreferences.getKeyStroke("k8");
        if (ks != null) {
            this.secondFuzzyItem.setAccelerator(ks);
        }
        this.secondFuzzyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getMemoryView().insertFuzzyMatchTwo();
            }
        });
        this.translateMenu.add(this.secondFuzzyItem);
        this.thirdFuzzyItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BEST FUZZY MATCH 3"));
        this.thirdFuzzyItem.setName("MenuTransSegMatchesInsertFuzzy3");
        ks = KeyPreferences.getKeyStroke("k9");
        if (ks != null) {
            this.thirdFuzzyItem.setAccelerator(ks);
        }
        this.thirdFuzzyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getMemoryView().insertFuzzyMatchThree();
            }
        });
        this.translateMenu.add(this.thirdFuzzyItem);
        this.autoMatchItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC MATCH"));
        this.autoMatchItem.setName("MenuTransSegMatchesInsertAutoAssembling");
        ks = KeyPreferences.getKeyStroke("k10");
        if (ks != null) {
            this.autoMatchItem.setAccelerator(ks);
        }
        this.autoMatchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getMemoryView().insertAutotranslation();
            }
        });
        this.translateMenu.add(this.autoMatchItem);
        JCheckBoxMenuItem menuAAPopupBox = new JCheckBoxMenuItem();
        menuAAPopupBox.setSelected(AppPreferences.popupAutoassemblingPanel);
        menuAAPopupBox.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("POP UP AUTO-ASSEMBLING PANEL"));
        menuAAPopupBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int state = e.getStateChange();
                AppPreferences.popupAutoassemblingPanel = state == 1;
            }
        });
        this.translateMenu.add(menuAAPopupBox);
        this.transferSourceItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER SOURCE"));
        this.transferSourceItem.setName("TransferToTargetSegmentPane");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_DOWN_BOLD, (int)this.transferSourceItem.getFont().getSize(), (Color)this.transferSourceItem.getForeground());
        this.transferSourceItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k13");
        if (ks != null) {
            this.transferSourceItem.setAccelerator(ks);
        }
        this.transferSourceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.transferSegment();
            }
        });
        this.transferWebMTItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER MT FROM WEB PAGE"));
        this.transferWebMTItem.setName("MenuTransTransferWebMT");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_UP_BOLD, (int)this.transferWebMTItem.getFont().getSize(), (Color)this.transferWebMTItem.getForeground());
        this.transferWebMTItem.setIcon((Icon)ficon);
        ks = KeyPreferences.getKeyStroke("k110");
        if (ks != null) {
            this.transferWebMTItem.setAccelerator(ks);
        }
        this.transferWebMTItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.topui.getResourceView().transferMTFormWebPage();
            }
        });
        this.transferAIItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER CT-L1 TRANSLATION"));
        this.transferAIItem.setName("MenuTransTransferAI");
        ks = KeyPreferences.getKeyStroke("k120");
        if (ks != null) {
            this.transferAIItem.setAccelerator(ks);
        }
        this.transferAIItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTLinguist gpt = WorkflowView.this.topui.getResourceView().getCTLinguist();
                if (gpt != null) {
                    gpt.apply(false);
                }
            }
        });
        this.transferDeepLItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER DEEPL MT"));
        this.transferDeepLItem.setName("MenuTransTransferDeepLMT");
        ks = KeyPreferences.getKeyStroke("k111");
        if (ks != null) {
            this.transferDeepLItem.setAccelerator(ks);
        }
        this.transferDeepLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MT mt = WorkflowView.this.topui.getResourceView().getMT6();
                if (mt != null) {
                    mt.apply(false);
                }
            }
        });
        this.transferGTItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER GOOGLE MT"));
        this.transferGTItem.setName("MenuTransTransferGoogleMT");
        ks = KeyPreferences.getKeyStroke("k14");
        if (ks != null) {
            this.transferGTItem.setAccelerator(ks);
        }
        this.transferGTItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MT mt = WorkflowView.this.topui.getResourceView().getMT();
                if (mt != null) {
                    mt.apply(false);
                }
            }
        });
        this.transferBingItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER MICROSOFT MT"));
        this.transferBingItem.setName("MenuTransTransferMicrosoftMT");
        ks = KeyPreferences.getKeyStroke("k15");
        if (ks != null) {
            this.transferBingItem.setAccelerator(ks);
        }
        this.transferBingItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MT mt = WorkflowView.this.topui.getResourceView().getMT2();
                if (mt != null) {
                    mt.apply(false);
                }
            }
        });
        this.transferWatsonItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER IBM WATSON MT"));
        this.transferWatsonItem.setName("MenuTransTransferIBMWatsonMT");
        ks = KeyPreferences.getKeyStroke("k114");
        if (ks != null) {
            this.transferWatsonItem.setAccelerator(ks);
        }
        this.transferWatsonItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MT mt = WorkflowView.this.topui.getResourceView().getMT7();
                if (mt != null) {
                    mt.apply(false);
                }
            }
        });
        this.transferAmazonItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER AMAZON TRANSLATE MT"));
        this.transferAmazonItem.setName("MenuTransTransferAmazonTranslateMT");
        ks = KeyPreferences.getKeyStroke("k117");
        if (ks != null) {
            this.transferAmazonItem.setAccelerator(ks);
        }
        this.transferAmazonItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MT mt = WorkflowView.this.topui.getResourceView().getMT8();
                if (mt != null) {
                    mt.apply(false);
                }
            }
        });
        this.transferMyMemoryItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER MYMEMORY MT"));
        this.transferMyMemoryItem.setName("MenuTransTransferMyMemoryMT");
        ks = KeyPreferences.getKeyStroke("k16");
        if (ks != null) {
            this.transferMyMemoryItem.setAccelerator(ks);
        }
        this.transferMyMemoryItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MT mt = WorkflowView.this.topui.getResourceView().getMT3();
                if (mt != null) {
                    mt.apply(false);
                }
            }
        });
        this.transferYandexItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER YANDEX MT"));
        this.transferYandexItem.setName("MenuTransTransferYandexMT");
        ks = KeyPreferences.getKeyStroke("k98");
        if (ks != null) {
            this.transferYandexItem.setAccelerator(ks);
        }
        this.transferYandexItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MT mt = WorkflowView.this.topui.getResourceView().getMT5();
                if (mt != null) {
                    mt.apply(false);
                }
            }
        });
        this.translateMenu.addSeparator();
        this.translateMenu.add(this.transferSourceItem);
        this.translateMenu.add(this.transferWebMTItem);
        if (AppPreferences.aiServices != -1) {
            this.translateMenu.add(this.transferAIItem);
        }
        if (AppPreferences.mt6 != -1) {
            this.translateMenu.add(this.transferDeepLItem);
        }
        if (AppPreferences.mt != -1) {
            this.translateMenu.add(this.transferGTItem);
        }
        if (AppPreferences.mt2 != -1) {
            this.translateMenu.add(this.transferBingItem);
        }
        if (AppPreferences.mt7 != -1) {
            this.translateMenu.add(this.transferWatsonItem);
        }
        if (AppPreferences.mt8 != -1) {
            this.translateMenu.add(this.transferAmazonItem);
        }
        if (AppPreferences.mt5 != -1) {
            this.translateMenu.add(this.transferYandexItem);
        }
        if (AppPreferences.mt3 != -1) {
            this.translateMenu.add(this.transferMyMemoryItem);
        }
        this.translateMenu.addSeparator();
        this.menuItemAutoComplete = new JMenuItem();
        this.menuItemAutoComplete.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SUGGEST PHRASE"));
        this.menuItemAutoComplete.setName("MenuTransSuggestPhrase");
        ks = KeyPreferences.getKeyStroke("k70");
        if (ks != null) {
            this.menuItemAutoComplete.setAccelerator(ks);
        }
        this.menuItemAutoComplete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Prompter ac = WorkflowView.this.topui.getSourceView().getPrompter();
                if (ac != null) {
                    ac.autoSuggestExplicit();
                }
            }
        });
        this.translateMenu.add(this.menuItemAutoComplete);
        this.translateMenu.addSeparator();
        JMenuItem autoTranslateProjectItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSERT EXACT MATCHES"));
        autoTranslateProjectItem.setName("MenuTransInsertAllExactMatches");
        autoTranslateProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.autotranslateAllSegments();
            }
        });
        this.translateMenu.add(autoTranslateProjectItem);
        JMenuItem pretranslateDocumentItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MATCHING FROM CURRENT SEGMENT"));
        pretranslateDocumentItem.setName("MenuTransPreTranslateFromCurrentSegment");
        pretranslateDocumentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.pretranslateFromCurrentSegment();
            }
        });
        this.translateMenu.add(pretranslateDocumentItem);
        JMenuItem pretranslateAllProjectItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MATCHING ALL SEGMENTS"));
        pretranslateAllProjectItem.setName("MenuTransPreTranslateAllSegments");
        pretranslateAllProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.pretranslateAllSegments(true);
            }
        });
        this.translateMenu.add(pretranslateAllProjectItem);
        JMenuItem pretranslateUntranslatedProjectItem = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MATCHING UNTRANSLATED SEGMENTS"));
        pretranslateUntranslatedProjectItem.setName("MenuTransPreTranslateUntranslatedSegs");
        pretranslateUntranslatedProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowView.this.pretranslateAllSegments(false);
            }
        });
        this.translateMenu.add(pretranslateUntranslatedProjectItem);
    }

    public void end() {
        String title;
        String message;
        String exportCommand;
        WorkflowManager manager;
        if (AppPreferences.autopilot && (manager = this.getWorkflowManager()) != null) {
            manager.stopTimer();
        }
        boolean SDLProject = false;
        Project project = this.topui.getProjectView().getProject();
        XLIFF xliff = project.getXLIFF();
        if (xliff == null) {
            return;
        }
        if (xliff.isExternalToolXLIFF) {
            SDLProject = true;
        } else if (!xliff.isCafeTranXLIFF) {
            return;
        }
        if (project.glue) {
            if (SDLProject) {
                exportCommand = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FINALIZE PROJECT");
                message = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FINALIZE PROJECT");
                title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FINALIZE");
            } else {
                exportCommand = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT ALL DOCUMENTS");
                message = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CREATE TRANSLATED FILES");
                title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT");
            }
        } else if (SDLProject) {
            exportCommand = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FINALIZE PROJECT");
            message = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FINALIZE PROJECT");
            title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FINALIZE");
        } else {
            exportCommand = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT CURRENT DOCUMENT");
            message = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CREATE TRANSLATED FILE");
            title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT");
        }
        String QAquestion = project.isQAFilterWorkflow() ? (SDLProject ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STOP QA") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STOP QA BEFORE EXPORT?")) : (SDLProject ? ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("QA") : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PERFORM QA BEFORE EXPORT?"));
        Object[] options = new String[]{QAquestion, exportCommand, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL END")};
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TRANSFER, (int)(this.translateSegmentItem.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        int i = JOptionPane.showOptionDialog(this.topui, message, title, 1, 3, (Icon)ficon, options, exportCommand);
        if (i == 0) {
            if (!project.isQAFilterWorkflow()) {
                this.topui.getQAView().showCheckAllDialog();
            } else {
                this.topui.resetSegmentsFilter();
            }
        } else if (i == 1) {
            if (!project.glue) {
                this.export();
            } else {
                this.exportAll(false);
            }
        }
    }

    void exportToExternalView(final boolean notes) {
        String targetName;
        File f;
        String projectPath;
        this.topui.requestFocus();
        final Project project = this.topui.getProjectView().getProject();
        final String targetDir = AppPreferences.exportDirectory != null && AppPreferences.exportDirectory.length() > 0 ? AppPreferences.exportDirectory : ((projectPath = project.getProjectPath()) != null ? ((f = new File(projectPath)).exists() ? f.getParent() : AppPreferences.projectDirectory) : System.getProperty("user.home"));
        final XLIFF xliff = project.getXLIFF();
        TMX tmx = project.getTMX();
        if (xliff != null) {
            String fname = null;
            if (xliff.getFiles().size() == 1 || project.glue) {
                fname = "Bilingual_" + project.getName() + ".docx";
            } else {
                String shortName;
                XliffFile xfile = xliff.getCurrentFile();
                if (xfile != null && (shortName = xfile.getShortName()) != null && shortName.length() > 0) {
                    fname = shortName.endsWith(".docx") ? "Bilingual_" + shortName : "Bilingual_" + shortName + ".docx";
                }
            }
            targetName = fname == null ? "Bilingual_" + project.getName() + ".docx" : fname;
        } else if (tmx != null) {
            targetName = "Bilingual_" + project.getName() + ".docx";
        } else {
            return;
        }
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ WorkflowView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        File f;
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE TARGET DOCUMENT AS..."));
                        if (targetDir != null && (f = new File(targetDir)).exists() && f.isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if (targetName != null) {
                            fileChooser.setInitialFileName(targetName);
                        }
                        if ((file = fileChooser.showSaveDialog(null)) != null) {
                            AppPreferences.exportDirectory = file.getParent();
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 58 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    boolean success = this.this$1.this$0.manager.exportSegmentsToWord(file.getPath(), notes);
                                    if (success) {
                                        project.saveProject(false);
                                        if (!xliff.isCafeTranXLIFF) {
                                            JOptionPane.showMessageDialog(this.this$1.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT FROM EXTERNAL PROJECT TO BILINGUAL DOCUMENT IS WITHOUT RETURN IMPORTING."));
                                        }
                                        if (!Desktop.isDesktopSupported()) {
                                            JOptionPane.showMessageDialog(this.this$1.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                                        } else {
                                            this.this$1.this$0.showExportCompleteDialog(file);
                                        }
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 58 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            File targetFile;
            JFileChooser jFileChooser = new JFileChooser(targetDir);
            jFileChooser.setFileSelectionMode(0);
            String targetPath = targetDir + AppPreferences.fs + targetName;
            if (targetPath != null && (targetFile = new File(targetPath)).exists()) {
                jFileChooser.setSelectedFile(targetFile);
            }
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE TARGET DOCUMENT AS..."));
            jFileChooser.repaint();
            if (0 == jFileChooser.showSaveDialog(this.topui)) {
                final File file = jFileChooser.getSelectedFile();
                final String path = file.getPath();
                AppPreferences.exportDirectory = file.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ WorkflowView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        boolean success = this.this$0.manager.exportSegmentsToWord(path, notes);
                        if (success) {
                            project.saveProject(false);
                            if (!Desktop.isDesktopSupported()) {
                                JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                            } else {
                                this.this$0.showExportCompleteDialog(file);
                            }
                        }
                    }
                });
            }
        }
    }

    void importFromExternalView() {
        final Project project = this.topui.getProjectView().getProject();
        XLIFF xliff = project.getXLIFF();
        if (xliff != null && !xliff.isCafeTranXLIFF) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOT A CAFETRAN PROJECT FILE!"));
            return;
        }
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ WorkflowView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        File f;
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
                        if (AppPreferences.exportDirectory != null && AppPreferences.exportDirectory.length() > 0 && (f = new File(AppPreferences.exportDirectory)).isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if ((file = fileChooser.showOpenDialog(null)) != null) {
                            AppPreferences.exportDirectory = file.getParent();
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 60 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    boolean success = this.this$1.this$0.manager.importSegmentsFromWord(file.getPath());
                                    if (success) {
                                        project.edit("#0");
                                        project.saveProject(false);
                                        JOptionPane.showMessageDialog(this.this$1.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT COMPLETED"));
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 60 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"));
            jFileChooser.setSelectedFile(new File(""));
            if (AppPreferences.exportDirectory != null && AppPreferences.exportDirectory.length() > 0) {
                jFileChooser.setCurrentDirectory(new File(AppPreferences.exportDirectory));
            }
            jFileChooser.repaint();
            if (0 == jFileChooser.showOpenDialog(this.topui)) {
                File file = jFileChooser.getSelectedFile();
                final String path = file.getPath();
                AppPreferences.exportDirectory = file.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ WorkflowView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        boolean success = this.this$0.manager.importSegmentsFromWord(path);
                        if (success) {
                            project.edit("#0");
                            project.saveProject(false);
                            JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT COMPLETED"));
                        }
                    }
                });
            }
        }
    }

    void exportAll(final boolean withNotes) {
        this.topui.requestFocus();
        Project project = this.topui.getProjectView().getProject();
        XLIFF xliff = project.getXLIFF();
        if (xliff != null && xliff.isExternalToolXLIFF) {
            int i = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET TRANSLATED STATUS FOR SEGMENTS"), "Select an Option", 0);
            if (i == 0) {
                if (this.topui.getTaskView().setTranslatedStatus()) {
                    JOptionPane.showMessageDialog(this.topui, "Segments status is set to translated and the translated file is saved.");
                }
            } else if (i == 1) {
                this.topui.getProjectView().saveProject();
            }
            return;
        }
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ WorkflowView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        File f;
                        File exf;
                        DirectoryChooser fileChooser = new DirectoryChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FOLDER FOR TARGET DOCUMENTS"));
                        boolean sharedExportDir = false;
                        if (AppPreferences.sharedExport && AppPreferences.exportDirectory != null && AppPreferences.exportDirectory.length() > 0 && (exf = new File(AppPreferences.exportDirectory)).exists() && exf.isDirectory() && exf.canRead()) {
                            fileChooser.setInitialDirectory(exf);
                            sharedExportDir = true;
                        }
                        if (!sharedExportDir && AppPreferences.projectDirectory != null && (f = new File(AppPreferences.projectDirectory)).exists() && f.isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if ((file = fileChooser.showDialog(null)) != null) {
                            if (AppPreferences.sharedExport) {
                                AppPreferences.exportDirectory = file.getPath();
                            }
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 62 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    Project project = this.this$1.this$0.topui.getProjectView().getProject();
                                    TranslatableHandler handler = new TranslatableHandler(this.this$1.this$0.topui);
                                    boolean success = handler.autoExport(file.getPath(), project, withNotes);
                                    if (success) {
                                        project.saveProject(false);
                                        if (!Desktop.isDesktopSupported()) {
                                            JOptionPane.showMessageDialog(this.this$1.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                                        } else {
                                            this.this$1.this$0.showExportCompleteDialog(file);
                                        }
                                        this.this$1.this$0.topui.getResourceView().saveGlossaries();
                                        this.this$1.this$0.topui.getMemoryView().saveMemories();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 62 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            File cdir = new File(AppPreferences.projectDirectory);
            if (cdir.exists()) {
                jFileChooser.setCurrentDirectory(cdir);
            } else {
                jFileChooser.setCurrentDirectory(null);
            }
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FOLDER FOR TARGET DOCUMENTS"));
            jFileChooser.repaint();
            if (0 == jFileChooser.showSaveDialog(this.topui) && (file = jFileChooser.getSelectedFile()).isDirectory()) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ WorkflowView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        Project project = this.this$0.topui.getProjectView().getProject();
                        TranslatableHandler handler = new TranslatableHandler(this.this$0.topui);
                        boolean success = handler.autoExport(file.getPath(), project, withNotes);
                        if (success) {
                            project.saveProject(false);
                            if (!Desktop.isDesktopSupported()) {
                                JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                            } else {
                                this.this$0.showExportCompleteDialog(file);
                            }
                            this.this$0.topui.getResourceView().saveGlossaries();
                            this.this$0.topui.getMemoryView().saveMemories();
                        }
                    }
                });
            }
        }
    }

    void export() {
        this.topui.requestFocus();
        final Project project = this.topui.getProjectView().getProject();
        XLIFF xliff = project.getXLIFF();
        if (xliff != null) {
            if (xliff.isExternalToolXLIFF) {
                int i = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET TRANSLATED STATUS FOR SEGMENTS"), "Select an Option", 0);
                if (i == 0) {
                    if (this.topui.getTaskView().setTranslatedStatus()) {
                        JOptionPane.showMessageDialog(this.topui, "Segments status is set to translated and the translated file is saved.");
                    }
                } else if (i == 1) {
                    this.topui.getProjectView().saveProject();
                }
                return;
            }
            XliffFile xfile = xliff.getCurrentFile();
            if (xfile == null) {
                return;
            }
            String tool = xfile.getAttribute("tool-id");
            if (tool != null && tool.equals("CafeTran-LibreOffice")) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ WorkflowView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        boolean success = this.this$0.manager.previewTransDocument(null);
                        if (success) {
                            project.saveProject(false);
                            JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                            this.this$0.topui.getResourceView().saveGlossaries();
                            this.this$0.topui.getMemoryView().saveMemories();
                        }
                    }
                });
                return;
            }
            FileHeader h = xfile.getHeader();
            if (h != null) {
                XMLElement exf;
                String href = null;
                Skeleton sk = h.getSkeleton();
                if (sk != null && (exf = sk.getExternalFile()) != null) {
                    href = exf.getAttribute("href");
                }
                String zName = xfile.getAttribute("original");
                if (href == null || href.length() == 0) {
                    href = zName;
                }
                if (href != null) {
                    String targetName;
                    String targetDir;
                    final String dtype = xfile.getAttribute("datatype");
                    File f = new File(href);
                    String target = xfile.getAttribute("target-language");
                    if (target != null) {
                        String source = xfile.getAttribute("source-language");
                        String sourceName = f.getName();
                        if (source != null) {
                            int si;
                            File exf2 = null;
                            if (AppPreferences.sharedExport && AppPreferences.exportDirectory != null && AppPreferences.exportDirectory.length() > 0 && !(exf2 = new File(AppPreferences.exportDirectory)).exists()) {
                                exf2 = null;
                            }
                            targetDir = exf2 != null ? AppPreferences.exportDirectory : (f.exists() ? f.getParent() : AppPreferences.projectDirectory);
                            boolean transitFile = false;
                            if (dtype != null && dtype.equals("x-transit_xml")) {
                                transitFile = true;
                            }
                            targetName = (si = sourceName.lastIndexOf("_" + source)) != -1 ? (!transitFile ? sourceName.substring(0, si + 1) + target + sourceName.substring(si + source.length() + 1) : sourceName.substring(0, si) + sourceName.substring(si + source.length() + 1)) : (!transitFile ? sourceName : sourceName);
                        } else {
                            targetDir = AppPreferences.projectDirectory;
                            targetName = null;
                        }
                    } else {
                        targetDir = AppPreferences.projectDirectory;
                        targetName = null;
                    }
                    if (AppPreferences.isJavaFXReady()) {
                        Platform.runLater((Runnable)new Runnable(){
                            final /* synthetic */ WorkflowView this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                try {
                                    File file;
                                    File f;
                                    FileChooser fileChooser = new FileChooser();
                                    fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE TARGET DOCUMENT AS..."));
                                    if (targetDir != null && (f = new File(targetDir)).isDirectory() && f.canRead()) {
                                        fileChooser.setInitialDirectory(f);
                                    }
                                    if (targetName != null) {
                                        fileChooser.setInitialFileName(targetName);
                                    }
                                    if ((file = fileChooser.showSaveDialog(null)) != null) {
                                        final String path = file.getPath();
                                        if (AppPreferences.sharedExport) {
                                            AppPreferences.exportDirectory = file.getParent();
                                        }
                                        SwingUtilities.invokeLater(new Runnable(){
                                            final /* synthetic */ 65 this$1;
                                            {
                                                this.this$1 = this$1;
                                            }

                                            @Override
                                            public void run() {
                                                boolean success = this.this$1.this$0.manager.previewTransDocument(path);
                                                if (success) {
                                                    project.saveProject(false);
                                                    if (dtype != null && (dtype.equals("x-clipboard") || dtype.equals("x-image"))) {
                                                        JOptionPane.showMessageDialog(this.this$1.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION HAS BEEN EXPORTED TO CLIPBOARD. YOU CAN PASTE IT TO YOUR APPLICATION."));
                                                    } else if (!Desktop.isDesktopSupported()) {
                                                        JOptionPane.showMessageDialog(this.this$1.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                                                    } else {
                                                        this.this$1.this$0.showExportCompleteDialog(file);
                                                    }
                                                    this.this$1.this$0.topui.getResourceView().saveGlossaries();
                                                    this.this$1.this$0.topui.getMemoryView().saveMemories();
                                                }
                                            }
                                        });
                                    }
                                }
                                catch (Exception ex) {
                                    final String s = ex.getMessage();
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 65 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                                        }
                                    });
                                }
                            }
                        });
                    } else {
                        JFileChooser jFileChooser = new JFileChooser(targetDir);
                        jFileChooser.setFileSelectionMode(0);
                        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE TARGET DOCUMENT AS..."));
                        jFileChooser.repaint();
                        if (0 == jFileChooser.showSaveDialog(this.topui)) {
                            final File file = jFileChooser.getSelectedFile();
                            final String path = file.getPath();
                            if (AppPreferences.sharedExport) {
                                AppPreferences.exportDirectory = file.getParent();
                            }
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ WorkflowView this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public void run() {
                                    boolean success = this.this$0.manager.previewTransDocument(path);
                                    if (success) {
                                        project.saveProject(false);
                                        if (!Desktop.isDesktopSupported()) {
                                            JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                                        } else {
                                            this.this$0.showExportCompleteDialog(file);
                                        }
                                        this.this$0.topui.getResourceView().saveGlossaries();
                                        this.this$0.topui.getMemoryView().saveMemories();
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    void exportWithNotes() {
        this.topui.requestFocus();
        final Project project = this.topui.getProjectView().getProject();
        XLIFF xliff = project.getXLIFF();
        if (xliff != null) {
            if (xliff.isExternalToolXLIFF) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT WITH NOTES ONLY TO MS WORD, WRITER AND CALC DOCUMENTS"));
                return;
            }
            XliffFile xfile = xliff.getCurrentFile();
            if (xfile == null) {
                return;
            }
            String tool = xfile.getAttribute("tool-id");
            if (tool != null && tool.equals("CafeTran-LibreOffice")) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT WITH NOTES ONLY TO MS WORD, WRITER AND CALC DOCUMENTS"));
                return;
            }
            FileHeader h = xfile.getHeader();
            if (h != null) {
                XMLElement exf;
                String href = null;
                Skeleton sk = h.getSkeleton();
                if (sk != null && (exf = sk.getExternalFile()) != null) {
                    href = exf.getAttribute("href");
                }
                String zName = xfile.getAttribute("original");
                if (href == null || href.length() == 0) {
                    href = zName;
                }
                if (href != null) {
                    String targetPath;
                    String targetName;
                    String targetDir;
                    File f = new File(href);
                    String target = xfile.getAttribute("target-language");
                    if (target != null) {
                        String source = xfile.getAttribute("source-language");
                        String sourceName = f.getName();
                        if (source != null) {
                            int si;
                            targetDir = f.exists() ? f.getParent() : AppPreferences.projectDirectory;
                            boolean transitFile = false;
                            String dtype = xfile.getAttribute("datatype");
                            if (dtype != null && dtype.equals("x-transit_xml")) {
                                transitFile = true;
                            }
                            if ((si = sourceName.lastIndexOf("_" + source)) != -1) {
                                targetName = !transitFile ? sourceName.substring(0, si + 1) + target + sourceName.substring(si + source.length() + 1) : sourceName.substring(0, si) + sourceName.substring(si + source.length() + 1);
                                targetPath = targetDir + AppPreferences.fs + targetName;
                            } else if (!transitFile) {
                                targetPath = targetDir + AppPreferences.fs + target + "_" + sourceName;
                                targetName = sourceName;
                            } else {
                                targetPath = targetDir + AppPreferences.fs + sourceName;
                                targetName = sourceName;
                            }
                        } else {
                            targetDir = AppPreferences.projectDirectory;
                            targetPath = null;
                            targetName = null;
                        }
                    } else {
                        targetDir = AppPreferences.projectDirectory;
                        targetPath = null;
                        targetName = null;
                    }
                    if (AppPreferences.isJavaFXReady()) {
                        Platform.runLater((Runnable)new Runnable(){
                            final /* synthetic */ WorkflowView this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                try {
                                    File file;
                                    File f;
                                    FileChooser fileChooser = new FileChooser();
                                    fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE TARGET DOCUMENT AS..."));
                                    if (targetDir != null && (f = new File(targetDir)).isDirectory() && f.canRead()) {
                                        fileChooser.setInitialDirectory(f);
                                    }
                                    if (targetName != null) {
                                        fileChooser.setInitialFileName(targetName);
                                    }
                                    if ((file = fileChooser.showSaveDialog(null)) != null) {
                                        SwingUtilities.invokeLater(new Runnable(){
                                            final /* synthetic */ 67 this$1;
                                            {
                                                this.this$1 = this$1;
                                            }

                                            @Override
                                            public void run() {
                                                boolean success = this.this$1.this$0.manager.previewTransDocumentWithNotes(file.getPath());
                                                if (success) {
                                                    project.saveProject(false);
                                                    JOptionPane.showMessageDialog(this.this$1.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                                                    this.this$1.this$0.topui.getResourceView().saveGlossaries();
                                                    this.this$1.this$0.topui.getMemoryView().saveMemories();
                                                }
                                            }
                                        });
                                    }
                                }
                                catch (Exception ex) {
                                    final String s = ex.getMessage();
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 67 this$1;
                                        {
                                            this.this$1 = this$1;
                                        }

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                                        }
                                    });
                                }
                            }
                        });
                    } else {
                        JFileChooser jFileChooser = new JFileChooser(targetDir);
                        jFileChooser.setFileSelectionMode(0);
                        if (targetPath != null) {
                            File targetFile = new File(targetPath);
                            jFileChooser.setSelectedFile(targetFile);
                        }
                        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE TARGET DOCUMENT AS..."));
                        jFileChooser.repaint();
                        if (0 == jFileChooser.showSaveDialog(this.topui)) {
                            File file = jFileChooser.getSelectedFile();
                            final String path = file.getPath();
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ WorkflowView this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public void run() {
                                    boolean success = this.this$0.manager.previewTransDocumentWithNotes(path);
                                    if (success) {
                                        project.saveProject(false);
                                        JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"));
                                        this.this$0.topui.getResourceView().saveGlossaries();
                                        this.this$0.topui.getMemoryView().saveMemories();
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
    }

    void preview() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkflowView.this.manager.previewTransDocument(null);
            }
        });
    }

    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Workflow proc = WorkflowView.this.manager.getWorkflow();
                if (proc != null && proc.justStarted) {
                    WorkflowView.this.manager.nextSegment(false, 0, false);
                } else {
                    WorkflowView.this.manager.start();
                }
            }
        });
    }

    public void next(final int mask) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ WorkflowView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.manager.nextSegment(false, mask, false);
            }
        });
    }

    public void autoNext() {
        this.manager.nextSegment(false, 0, false);
    }

    public void add(final int mask, final boolean jump) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ WorkflowView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (jump) {
                    AppPreferences.skipTranslatedJump = true;
                }
                this.this$0.manager.nextSegment(true, mask, false);
            }
        });
    }

    void addChecked(final boolean jump) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ WorkflowView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (jump) {
                    AppPreferences.skipReviewedJump = true;
                }
                this.this$0.topui.getTargetView().setTUState(1);
                this.this$0.manager.nextSegment(true, 0, false);
                this.this$0.topui.getTargetView().setTUState(0);
            }
        });
    }

    void append(final int mask) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ WorkflowView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.manager.appSegment(mask, false);
            }
        });
    }

    void review() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkflowView.this.manager.reviewPrevious();
            }
        });
    }

    void delete() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WorkflowView.this.manager.delete();
            }
        });
    }

    void translate() {
        String q;
        String s;
        boolean searchWebMT = false;
        boolean searchQAMT = false;
        boolean searchAI = false;
        Resource r = this.topui.getTabView().getCurrentResource();
        if (r != null && r instanceof WebResourceFX) {
            WebResourceFX wr = (WebResourceFX)r;
            if (wr.isMTWebResurces()) {
                searchWebMT = true;
            } else if (wr.isQAWebResurces()) {
                searchQAMT = true;
            }
        }
        boolean selection = false;
        JTextPane tpane = this.topui.getSourcePane();
        if (searchQAMT) {
            String ss;
            JTextComponent jtc = this.topui.getFocusedTextComponent();
            if (jtc == null || !tpane.equals(jtc)) {
                tpane = this.topui.getTargetPane();
            }
            if ((ss = tpane.getText()) == null || ss.isEmpty()) {
                tpane = this.topui.getSourcePane();
            }
        }
        if ((s = tpane.getSelectedText()) == null) {
            Document doc = tpane.getDocument();
            try {
                s = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(WorkflowView.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            selection = true;
        }
        if ((q = XMLHelper.parseTags(s)).length() > 0) {
            if (!searchWebMT && !searchQAMT && selection) {
                MemoryView mv = this.topui.getMemoryView();
                mv.translateSegment(q, null, null, s, false);
            }
            if (!searchQAMT) {
                this.topui.getResourceView().searchMTWebResources(q);
            } else {
                this.topui.getResourceView().searchQAWebResources(q);
            }
            if (AppPreferences.chatGPTAction != 1) {
                this.topui.getResourceView().translateAIService(s);
            }
            if (!selection) {
                this.topui.getResourceView().translateMT(q);
            }
        }
    }

    void pretranslateFromCurrentSegment() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String s;
                XliffFile file;
                Project project = WorkflowView.this.topui.getProjectView().getProject();
                XLIFF xliff = project.getXLIFF();
                if (xliff != null && (file = xliff.getCurrentFile()) != null && (s = file.getCurrentPhase()) != null && s.equals("Alignment")) {
                    TranslationHandler handler = new TranslationHandler(WorkflowView.this.topui);
                    handler.pretranslateUnsegmentedDocument(project);
                    return;
                }
                TranslationHandler handler = new TranslationHandler(WorkflowView.this.topui);
                handler.pretranslateFromCurrentSegment(project);
            }
        });
    }

    void pretranslateAllSegments(final boolean all) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ WorkflowView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Project project = this.this$0.topui.getProjectView().getProject();
                if (project != null) {
                    TranslationHandler handler = new TranslationHandler(this.this$0.topui);
                    if (project.getXLIFF() != null) {
                        handler.pretranslateAllSegmentsXLIFF(project, all);
                    } else if (project.getTTX() != null) {
                        handler.pretranslateAllSegmentsTTX(project, all);
                    }
                }
            }
        });
    }

    void autotranslateAllSegments() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Project project = WorkflowView.this.topui.getProjectView().getProject();
                if (project != null) {
                    TranslationHandler handler = new TranslationHandler(WorkflowView.this.topui);
                    if (project.getXLIFF() != null) {
                        handler.autotranslateAllSegmentsXLIFF(project);
                    } else if (project.getTTX() != null) {
                        handler.autotranslateAllSegmentsTTX(project);
                    }
                }
            }
        });
    }

    void addPhraseToMemory() {
        MemoryView mv = this.topui.getMemoryView();
        mv.newMemoryEntry();
    }

    public void addPhraseToMemory(String s, String t) {
        MemoryView mv = this.topui.getMemoryView();
        mv.newMemoryEntry(s, t);
    }

    void addDirectEntryToGlossary() {
        this.topui.getResourceView().addTermToGlossariesDirect();
    }

    void addEntryToGlossary() {
        this.topui.getResourceView().addTermToGlossaries();
    }

    public void addEntryToGlossary(String key, String entry) {
        this.topui.getResourceView().addTermToGlossaries(key, entry);
    }

    public void addToPlaceables() {
        Workflow flow = this.getWorkflowManager().getWorkflow();
        if (flow != null) {
            Object o;
            String s = this.topui.getSourcePane().getSelectedText();
            if (s == null && (s = this.topui.getTargetPane().getSelectedText()) == null) {
                s = "";
            }
            if ((o = JOptionPane.showInputDialog(this.topui, null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NON-TRANSLATABLE FRAGMENTS"), -1, null, null, s)) != null && (s = o.toString()).trim().length() > 0) {
                flow.addStringToPlaceables(s);
            }
        }
    }

    public void addAbbreviation() {
        Workflow flow = this.getWorkflowManager().getWorkflow();
        if (flow != null) {
            Object o;
            String s = this.topui.getSourcePane().getSelectedText();
            if (s == null && (s = this.topui.getTargetPane().getSelectedText()) == null) {
                s = "";
            }
            if ((o = JOptionPane.showInputDialog(this.topui, null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ABBREVIATIONS"), -1, null, null, s)) != null && (s = o.toString()).length() > 0) {
                Abbreviations.addAbbreviation(s);
            }
        }
    }

    void transferSegment() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean replace;
                JTextPane spane = WorkflowView.this.topui.getSourcePane();
                JTextPane tpane = WorkflowView.this.topui.getTargetPane();
                String source = spane.getSelectedText();
                if (source == null) {
                    replace = true;
                    Document doc = spane.getDocument();
                    try {
                        source = doc.getText(0, doc.getLength());
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    replace = false;
                    int start = spane.getSelectionStart();
                    int end = spane.getSelectionEnd();
                    Document doc = spane.getDocument();
                    try {
                        source = doc.getText(start, end - start);
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
                if (source.length() > 0) {
                    int len;
                    if (tpane.getSelectedText() != null) {
                        int start = tpane.getSelectionStart();
                        int end = tpane.getSelectionEnd();
                        try {
                            tpane.getDocument().remove(start, end - start);
                        }
                        catch (BadLocationException ex) {
                            Logger.getLogger(WorkflowView.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else if (replace && (len = tpane.getDocument().getLength()) > 0) {
                        try {
                            tpane.getDocument().remove(0, len);
                        }
                        catch (BadLocationException ex) {
                            Logger.getLogger(WorkflowView.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    WorkflowView.this.topui.getTargetView().getUndoHandler().compoundEditBreak(true);
                    int pos = tpane.getCaretPosition();
                    try {
                        tpane.getDocument().insertString(pos, source, null);
                        if (replace) {
                            tpane.setCaretPosition(0);
                        }
                        tpane.requestFocusInWindow();
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public static void setReplacementArrays(String source, String target) {
        sourceReplaceArray = source.split("/-/");
        targetReplaceArray = target.split("/-/");
    }

    public static void setPunctReplacementArrays(String source, String target) {
        sourcePunctReplaceArray = source.split("/-/");
        targetPunctReplaceArray = target.split("/-/");
    }

    public static String replaceCharacters(String source) {
        for (int i = 0; i < sourceReplaceArray.length; ++i) {
            if (i >= targetReplaceArray.length) continue;
            String s = sourceReplaceArray[i];
            String t = targetReplaceArray[i];
            if (s.indexOf("|") != -1) {
                String[] arr = s.split("\\|");
                for (int j = 0; j < arr.length; ++j) {
                    String string = arr[j];
                    source = source.replace(string, t);
                }
                continue;
            }
            source = source.replace(s, t);
        }
        return source;
    }

    public static String replacePunctCharacters(String source) {
        for (int i = 0; i < sourcePunctReplaceArray.length; ++i) {
            if (i >= targetPunctReplaceArray.length) continue;
            String s = sourcePunctReplaceArray[i];
            String t = targetPunctReplaceArray[i];
            if (s.indexOf("|") != -1) {
                String[] arr = s.split("\\|");
                for (int j = 0; j < arr.length; ++j) {
                    String string = arr[j];
                    source = source.replace(string, t);
                }
                continue;
            }
            source = source.replace(s, t);
        }
        return source;
    }

    public WorkflowManager getWorkflowManager() {
        return this.manager;
    }

    public void append2() {
        Workflow proc1 = this.manager.getWorkflow();
        Workflow proc2 = this.manager.getAlignWorkflow();
        if (proc1 != null && proc1.getCurrentPosition() != -1) {
            proc1.canAppend2 = true;
            int i = AppPreferences.projectView;
            try {
                AppPreferences.projectView = -1;
                proc1.noLookup = true;
                this.manager.reviewNext(false);
                if (proc1.canAppend2) {
                    proc1.nextSegment();
                    if (proc2 != null) {
                        proc2.align();
                    }
                    this.manager.reviewPrevious();
                    this.manager.reviewPrevious();
                    AppPreferences.projectView = i;
                    proc1.noLookup = false;
                    this.manager.appSegment(0, false);
                    if (AppPreferences.automaticMatching) {
                        proc1.resetLookup = true;
                    }
                } else {
                    AppPreferences.projectView = i;
                    proc1.noLookup = false;
                }
            }
            catch (Exception e) {
                AppPreferences.projectView = i;
                proc1.noLookup = false;
            }
        }
    }

    public void splitTU() {
        Workflow proc1 = this.manager.getWorkflow();
        Workflow proc2 = this.manager.getAlignWorkflow();
        if (proc1 != null && proc1.getCurrentPosition() != -1) {
            int i = AppPreferences.projectView;
            try {
                AppPreferences.projectView = -1;
                int scaret = this.topui.getSourcePane().getCaretPosition();
                int tcaret = this.topui.getTargetPane().getCaretPosition();
                String source = proc1.getSource().substring(0, scaret);
                String target = proc1.getTarget().substring(0, tcaret);
                scaret = XMLHelper.getSplitPostion(source);
                tcaret = XMLHelper.getSplitPostion(target);
                proc1.noLookup = true;
                proc1.nextSegment();
                if (proc2 != null) {
                    proc2.align();
                }
                this.manager.reviewPrevious();
                source = proc1.getSource();
                target = proc1.getTarget();
                scaret = XMLHelper.setSplitPostion(source, scaret);
                tcaret = XMLHelper.setSplitPostion(target, tcaret);
                Project project = this.topui.getProjectView().getProject();
                AppPreferences.projectView = i;
                proc1.noLookup = false;
                if (project != null) {
                    project.splitSegment(scaret, tcaret);
                }
                if (AppPreferences.automaticMatching) {
                    proc1.resetLookup = true;
                }
            }
            catch (Exception e) {
                AppPreferences.projectView = i;
                proc1.noLookup = false;
            }
        }
    }

    public void setMouseTagsMenu(boolean flag) {
        this.mouseTagsMenu.setSelected(flag);
    }

    private void showExportCompleteDialog(File file) {
        Object[] options = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN DOCUMENT"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN FOLDER"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK")};
        int i = JOptionPane.showOptionDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"), "Coffee time!", 1, 1, null, options, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        if (i == 0) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException ex) {
                Logger.getLogger(WorkflowView.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (i == 1) {
            try {
                Desktop.getDesktop().open(file.getParentFile());
            }
            catch (IOException ex) {
                Logger.getLogger(WorkflowView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    void showProjectExportCompleteDialog(File file) {
        Object[] options = new String[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN FOLDER"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK")};
        int i = JOptionPane.showOptionDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EXPORT COMPLETED"), "Coffee time!", 0, 1, null, options, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        if (i == 0) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException ex) {
                Logger.getLogger(WorkflowView.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (i == 1) {
            // empty if block
        }
    }
}

