/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.MainView;
import translator.ResourceView;
import translator.XMLElement;
import translator.XMLHelper;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;
import translator.ui.UITools;

public class XMLElementEditor
extends JDialog
implements ActionListener {
    private MainView topui;
    private JMenuBar menuBar;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton jButton0;
    private JButton jButton2;
    private JButton jButton3;
    private JTextPane mainTArea;
    private JTextPane[] jtextAreas;
    private JTextPane[] jtextAreasNotes;
    private JTextField[] jfieldProperties;
    private Object xmle;
    private int status = -1;
    private boolean delete = true;

    public XMLElementEditor(MainView owner, Object xmle) {
        super(owner, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONTENTS"), true);
        this.setResizable(true);
        this.xmle = xmle;
        this.topui = owner;
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(new GridLayout(1, 3, 5, 3));
        this.jPanel3.setBorder(new EmptyBorder(new Insets(5, 0, 0, 0)));
        if (xmle instanceof XMLElement) {
            List elements;
            XMLElement x = (XMLElement)xmle;
            String xname = x.getName();
            int xsize = -1;
            if (!(xname.equals("prop") || xname.equals("note") || xname.equals("target") || xname.equals("tu") || xname.equals("mq:comment") || xname.equals("Comment") || xname.equals("comment") || xname.equals("gs4tr:note") || (elements = x.getChildren()) == null)) {
                xsize = elements.size();
                this.menuBar = new JMenuBar();
                this.setJMenuBar(this.menuBar);
                JMenu menu = new JMenu(x.getName().toUpperCase());
                Font font = menu.getFont().deriveFont(1);
                menu.setFont(font);
                this.menuBar.add(menu);
                this.setXMLMenu(x, elements, menu);
            }
            if (xmle instanceof TMXUnit) {
                List properties;
                JScrollPane jScrollPane;
                JTextPane jtextArea;
                TMXUnit tu = (TMXUnit)xmle;
                String aid = tu.getAttribute("creationid");
                String adate = tu.getAttribute("creationdate");
                if (aid != null || adate != null) {
                    this.jPanel1 = new JPanel();
                    this.jPanel1.setBorder(new EmptyBorder(5, 0, 0, 200));
                    this.jPanel1.setLayout(new GridLayout(0, 2, 5, 3));
                    if (aid != null && aid.length() > 0) {
                        JLabel label = new JLabel("Creation ID:");
                        label.setName("creationid");
                        label.setHorizontalAlignment(4);
                        JTextField field = new JTextField(aid);
                        this.jPanel1.add(label);
                        this.jPanel1.add(field);
                    }
                    if (adate != null && adate.length() > 0) {
                        StringBuilder builder = new StringBuilder();
                        char[] arr = adate.toCharArray();
                        int k = 0;
                        for (int i = 0; i < arr.length; ++i) {
                            char b = arr[i];
                            if (b == 'T') {
                                builder.append(", ");
                            } else if (k == 4 || k == 6) {
                                builder.append('-');
                                builder.append(b);
                            } else if (k == 11 || k == 13) {
                                builder.append(':');
                                builder.append(b);
                            } else if (b != 'Z') {
                                builder.append(b);
                            }
                            ++k;
                        }
                        JLabel label = new JLabel("Creation Date:");
                        label.setName("creationdate");
                        label.setHorizontalAlignment(4);
                        JTextField field = new JTextField(builder.toString());
                        field.setEditable(false);
                        this.jPanel1.add(label);
                        this.jPanel1.add(field);
                    }
                }
                Collection col = tu.getTMXUnitVariants();
                int size = col.size();
                this.jPanel4 = new JPanel();
                if (size > 6) {
                    this.jPanel4.setLayout(new GridLayout(0, 3, 5, 3));
                } else {
                    this.jPanel4.setLayout(new GridLayout(0, 2, 5, 3));
                }
                this.jPanel4.setBorder(new EmptyBorder(new Insets(5, 0, 5, 0)));
                int h = 170;
                this.jtextAreas = new JTextPane[size];
                int j = 0;
                for (TMXUnitVariant tuv : col) {
                    String text = tuv.getSegmentText();
                    if (text == null) continue;
                    String lang = tuv.getLanguage();
                    jtextArea = new JTextPane();
                    jtextArea.setDragEnabled(AppPreferences.draganddrop);
                    XMLElement xe = tuv.getSegment();
                    boolean inline = false;
                    if (xe != null) {
                        List list = xe.getChildren();
                        for (Object object : list) {
                            if (!(object instanceof XMLElement)) continue;
                            inline = true;
                            break;
                        }
                    }
                    if (inline) {
                        jtextArea.setEditable(false);
                    } else {
                        jtextArea.putClientProperty("xml", tuv.getSegment());
                    }
                    jtextArea.setFont(new Font(AppPreferences.fontname, 0, AppPreferences.fontsize));
                    if (AppPreferences.linuxGTK) {
                        jtextArea.setCaretColor(jtextArea.getForeground());
                    } else if (AppPreferences.background != 0) {
                        Color background = new Color(AppPreferences.background);
                        Color foreground = new Color(AppPreferences.foreground);
                        jtextArea.setCaretColor(foreground);
                        jtextArea.setBackground(background);
                        jtextArea.setForeground(foreground);
                    }
                    jtextArea.setMargin(new Insets(5, 5, 5, 5));
                    JScrollPane jScrollPane2 = new JScrollPane(jtextArea);
                    jScrollPane2.setOpaque(false);
                    jScrollPane2.getViewport().setOpaque(false);
                    jScrollPane2.setPreferredSize(new Dimension(450, h));
                    jScrollPane2.setBorder(BorderFactory.createTitledBorder(lang));
                    jtextArea.setText(text);
                    jtextArea.setCaretPosition(0);
                    this.jPanel4.add(jScrollPane2);
                    this.jtextAreas[j] = jtextArea;
                    ++j;
                }
                List notes = tu.getChildren("note");
                if (notes != null && notes.size() > 0) {
                    this.jtextAreasNotes = new JTextPane[notes.size()];
                    j = 0;
                    for (int i = 0; i < notes.size(); ++i) {
                        XMLElement xnote = (XMLElement)notes.get(i);
                        String text = xnote.getContent(0).toString();
                        jtextArea = new JTextPane();
                        jtextArea.setDragEnabled(AppPreferences.draganddrop);
                        jtextArea.putClientProperty("xml", xnote);
                        jtextArea.setFont(new Font(AppPreferences.fontname, 0, AppPreferences.fontsize));
                        if (AppPreferences.linuxGTK) {
                            jtextArea.setCaretColor(jtextArea.getForeground());
                        } else if (AppPreferences.background != 0) {
                            Color background = new Color(AppPreferences.background);
                            Color foreground = new Color(AppPreferences.foreground);
                            jtextArea.setCaretColor(foreground);
                            jtextArea.setBackground(background);
                            jtextArea.setForeground(foreground);
                        }
                        jtextArea.setMargin(new Insets(5, 5, 5, 5));
                        jScrollPane = new JScrollPane(jtextArea);
                        jScrollPane.setOpaque(false);
                        jScrollPane.getViewport().setOpaque(false);
                        jScrollPane.setPreferredSize(new Dimension(450, h));
                        jScrollPane.setBorder(BorderFactory.createTitledBorder("Note"));
                        jtextArea.setText(text);
                        jtextArea.setCaretPosition(0);
                        this.jPanel4.add(jScrollPane);
                        this.jtextAreasNotes[j] = jtextArea;
                        ++j;
                    }
                }
                if ((properties = tu.getChildren("prop")) != null && properties.size() > 0) {
                    XMLElement xprop;
                    String type;
                    boolean tagsPropertyOnly = false;
                    if (properties.size() == 1 && (type = (xprop = (XMLElement)properties.get(0)).getAttribute("type")) != null && type.equals("target_tags")) {
                        tagsPropertyOnly = true;
                    }
                    if (!tagsPropertyOnly) {
                        this.jfieldProperties = new JTextField[properties.size()];
                        JPanel propMainPanel = new JPanel();
                        propMainPanel.setLayout(new BorderLayout());
                        JPanel propPanel = new JPanel();
                        propPanel.setLayout(new SpringLayout());
                        propMainPanel.add((Component)propPanel, "North");
                        jScrollPane = new JScrollPane(propMainPanel);
                        jScrollPane.setPreferredSize(new Dimension(450, h));
                        jScrollPane.setBorder(BorderFactory.createTitledBorder("Properties"));
                        this.jPanel4.add(jScrollPane);
                        j = 0;
                        int rows = 0;
                        for (int i = 0; i < properties.size(); ++i) {
                            XMLElement xprop2 = (XMLElement)properties.get(i);
                            String type2 = xprop2.getAttribute("type");
                            if (type2 != null && !type2.equals("target_tags")) {
                                String text = xprop2.getContent(0).toString();
                                JTextField jtextField = new JTextField();
                                jtextField.setText(text);
                                jtextField.setCaretPosition(0);
                                jtextField.putClientProperty("xml", xprop2);
                                if (text != null && XMLHelper.isReferencePath(text)) {
                                    JButton open = new JButton(type2);
                                    open.setFont(open.getFont().deriveFont(1));
                                    open.putClientProperty("field", jtextField);
                                    String refString = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VIEW REFERENCE");
                                    open.setToolTipText(refString);
                                    FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_EYE, (int)open.getFont().getSize(), (Color)open.getForeground());
                                    open.setIcon((Icon)ficon);
                                    open.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            JButton open = (JButton)e.getSource();
                                            JTextField urlField = (JTextField)open.getClientProperty("field");
                                            String path = urlField.getText();
                                            if (path.startsWith("file")) {
                                                try {
                                                    File file = new File(new URI(path));
                                                    if (file.exists()) {
                                                        XMLElementEditor.this.topui.getResourceView().viewFile(file);
                                                    }
                                                }
                                                catch (URISyntaxException ex) {
                                                    Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            } else if (path.startsWith("http")) {
                                                try {
                                                    URI uri = new URI(path);
                                                    XMLElementEditor.this.topui.getResourceView();
                                                    ResourceView.browse(uri);
                                                }
                                                catch (URISyntaxException ex) {
                                                    Logger.getLogger(XMLElementEditor.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            } else {
                                                File file = new File(path);
                                                if (file.exists()) {
                                                    XMLElementEditor.this.topui.getResourceView().viewFile(file);
                                                }
                                            }
                                        }
                                    });
                                    propPanel.add(open);
                                    propPanel.add(jtextField);
                                } else {
                                    JLabel label = new JLabel(type2 + ":");
                                    label.setFont(label.getFont().deriveFont(1));
                                    label.setHorizontalAlignment(4);
                                    propPanel.add(label);
                                    propPanel.add(jtextField);
                                }
                                this.jfieldProperties[rows] = jtextField;
                                ++rows;
                            }
                            ++j;
                        }
                        if (rows > 0) {
                            UITools.makeCompactGrid(propPanel, rows, 2, 6, 6, 8, 4);
                        }
                    }
                }
            } else if ((xname.equals("prop") || xname.equals("note") || xname.equals("target") || xname.equals("mq:comment") || xname.equals("Comment") || xname.equals("comment") || xname.equals("gs4tr:note")) && xsize <= 1) {
                if (xname.equals("prop")) {
                    String type = x.getAttribute("type");
                    String s = type != null ? " (" + type + ")" : "";
                    this.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROPERTY") + s);
                } else if (xname.equals("note") || xname.equals("mq:comment") || xname.equals("comment") || xname.equals("gs4tr:note")) {
                    this.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTE"));
                } else if (xname.equals("Comment")) {
                    this.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTE"));
                } else {
                    this.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET SEGMENT"));
                }
                this.jPanel4 = new JPanel();
                this.jPanel4.setPreferredSize(new Dimension(500, 300));
                this.jPanel4.setLayout(new BorderLayout());
                this.jPanel4.setBorder(new EmptyBorder(new Insets(5, 0, 5, 0)));
                this.mainTArea = new JTextPane();
                this.mainTArea.setDragEnabled(AppPreferences.draganddrop);
                this.mainTArea.setFont(new Font(AppPreferences.fontname, 0, AppPreferences.fontsize));
                if (AppPreferences.linuxGTK) {
                    this.mainTArea.setCaretColor(this.mainTArea.getForeground());
                } else if (AppPreferences.background != 0) {
                    Color background = new Color(AppPreferences.background);
                    Color foreground = new Color(AppPreferences.foreground);
                    this.mainTArea.setCaretColor(foreground);
                    this.mainTArea.setBackground(background);
                    this.mainTArea.setForeground(foreground);
                }
                this.mainTArea.setMargin(new Insets(5, 5, 5, 5));
                JScrollPane jScrollPane = new JScrollPane(this.mainTArea);
                jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                jScrollPane.setOpaque(false);
                jScrollPane.getViewport().setOpaque(false);
                StringBuilder sb = new StringBuilder();
                List li = x.getChildren();
                for (Object next : li) {
                    if (!(next instanceof String)) continue;
                    sb.append(next.toString());
                }
                if (sb.length() > 0) {
                    this.mainTArea.setText(sb.toString());
                } else {
                    this.delete = false;
                }
                this.mainTArea.setCaretPosition(0);
                this.jPanel4.add(jScrollPane);
            }
        } else if (xmle instanceof StringBuffer) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setPreferredSize(new Dimension(400, 150));
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.setBorder(new EmptyBorder(new Insets(10, 0, 10, 0)));
            this.mainTArea = new JTextPane();
            this.mainTArea.setFont(new Font(AppPreferences.fontname, 0, AppPreferences.fontsize));
            if (AppPreferences.linuxGTK) {
                this.mainTArea.setCaretColor(this.mainTArea.getForeground());
            } else if (AppPreferences.background != 0) {
                Color background = new Color(AppPreferences.background);
                Color foreground = new Color(AppPreferences.foreground);
                this.mainTArea.setCaretColor(foreground);
                this.mainTArea.setBackground(background);
                this.mainTArea.setForeground(foreground);
            }
            this.mainTArea.setMargin(new Insets(5, 5, 5, 5));
            JScrollPane jScrollPane = new JScrollPane(this.mainTArea);
            jScrollPane.setBorder(BorderFactory.createRaisedBevelBorder());
            jScrollPane.setOpaque(false);
            jScrollPane.getViewport().setOpaque(false);
            this.mainTArea.setText(xmle.toString());
            this.mainTArea.setCaretPosition(0);
            this.jPanel4.add(jScrollPane);
        }
        this.jButton2 = new JButton();
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton3.addActionListener(this);
        this.jButton0 = new JButton();
        this.jButton0.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE"));
        this.jButton0.addActionListener(this);
        this.jPanel3.add(this.jButton2);
        if (this.delete) {
            this.jPanel3.add(this.jButton0);
        }
        this.jPanel3.add(this.jButton3);
        JPanel con = (JPanel)this.getContentPane();
        this.setContentPane(con);
        EmptyBorder border = new EmptyBorder(5, 10, 5, 10);
        con.setBorder(border);
        con.setLayout(new BorderLayout());
        if (this.jPanel1 != null) {
            con.add((Component)this.jPanel1, "North");
        }
        if (this.jPanel4 != null) {
            con.add((Component)this.jPanel4, "Center");
        }
        con.add((Component)this.jPanel3, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLElementEditor.this.jButton2.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLElementEditor.this.jButton3.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 128), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                XMLElementEditor.this.closeDialog();
            }
        });
        this.pack();
        if (this.mainTArea != null) {
            this.mainTArea.requestFocusInWindow();
        }
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton0) {
            this.status = 0;
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            if (this.xmle instanceof XMLElement) {
                XMLElement x = (XMLElement)this.xmle;
                String xname = x.getName();
                if (this.jPanel1 != null) {
                    Component[] comps = this.jPanel1.getComponents();
                    for (int i = 0; i < comps.length; ++i) {
                        JComponent field;
                        String type = null;
                        String value = null;
                        if (comps[i] instanceof JLabel) {
                            JLabel lab = (JLabel)comps[i];
                            type = lab.getName();
                            ++i;
                        }
                        if (comps[i] instanceof JTextField) {
                            field = (JTextField)comps[i];
                            if (((JTextComponent)field).isEditable()) {
                                value = ((JTextComponent)field).getText();
                            }
                        } else if (comps[i] instanceof JComboBox) {
                            field = (JComboBox)comps[i];
                            value = (String)((JComboBox)field).getSelectedItem();
                        }
                        if (type == null || value == null) continue;
                        x.setAttribute(type, value);
                    }
                }
                if (this.mainTArea != null) {
                    if (xname.equals("prop") || xname.equals("note") || xname.equals("target") || xname.equals("mq:comment") || xname.equals("Comment") || xname.equals("comment") || xname.equals("gs4tr:note")) {
                        String con = this.mainTArea.getText();
                        x.setContent(0, con);
                    }
                } else {
                    String text;
                    XMLElement xml;
                    if (this.jtextAreas != null) {
                        for (int j = 0; j < this.jtextAreas.length; ++j) {
                            JTextPane area = this.jtextAreas[j];
                            if (!area.isEditable()) continue;
                            xml = (XMLElement)area.getClientProperty("xml");
                            text = area.getText();
                            if (text.length() <= 0) continue;
                            xml.setContent(0, text);
                        }
                    }
                    if (this.jtextAreasNotes != null) {
                        for (int j = 0; j < this.jtextAreasNotes.length; ++j) {
                            JTextPane area = this.jtextAreasNotes[j];
                            if (!area.isEditable()) continue;
                            xml = (XMLElement)area.getClientProperty("xml");
                            text = area.getText();
                            if (text.length() <= 0) continue;
                            xml.setContent(0, text);
                        }
                    }
                    if (this.jfieldProperties != null) {
                        for (int j = 0; j < this.jfieldProperties.length; ++j) {
                            JTextField field = this.jfieldProperties[j];
                            if (field == null || !field.isEditable()) continue;
                            xml = (XMLElement)field.getClientProperty("xml");
                            text = field.getText().trim();
                            if (text.length() <= 0) continue;
                            xml.setContent(0, text);
                        }
                    }
                }
            } else if (this.xmle instanceof StringBuffer) {
                StringBuffer buffer = (StringBuffer)this.xmle;
                buffer.setLength(0);
                buffer.append(this.mainTArea.getText());
            }
            this.status = 1;
            this.closeDialog();
        } else if (e.getSource() == this.jButton3) {
            this.status = -1;
            this.closeDialog();
        }
    }

    private void setXMLMenu(XMLElement parent, List elements, JMenu menu) {
        if (elements != null) {
            int index = 0;
            for (Object o : elements) {
                Object elem;
                int eindex = index++;
                if (o instanceof XMLElement) {
                    elem = (XMLElement)o;
                    JMenu emenu = new JMenu(elem.getName().toUpperCase());
                    menu.add(emenu);
                    emenu.addItemListener(new ItemListener(){
                        final /* synthetic */ XMLElement val$elem;
                        final /* synthetic */ XMLElement val$parent;
                        final /* synthetic */ int val$eindex;
                        final /* synthetic */ XMLElementEditor this$0;
                        {
                            this.val$elem = xMLElement;
                            this.val$parent = xMLElement2;
                            this.val$eindex = n;
                            this.this$0 = this$0;
                        }

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            JMenu menu = (JMenu)e.getItem();
                            if (e.getStateChange() == 1) {
                                JMenuItem item = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT ELEMENT")){
                                    final /* synthetic */ 5 this$1;
                                    {
                                        this.this$1 = this$1;
                                        super(arg0);
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent a) {
                                        int st = this.this$1.this$0.showXMLElement(val$elem);
                                        if (st == 0) {
                                            val$parent.removeChild(val$elem);
                                        } else if (st == 1) {
                                            val$parent.setContent(val$eindex, val$elem);
                                        }
                                    }
                                });
                                menu.add(item);
                                List elems = this.val$elem.getChildren();
                                if (elems != null) {
                                    menu.addSeparator();
                                    this.this$0.setXMLMenu(this.val$elem, elems, menu);
                                }
                            } else if (e.getStateChange() == 2) {
                                menu.removeAll();
                            }
                        }
                    });
                    continue;
                }
                if (!(o instanceof String)) continue;
                elem = new StringBuffer(o.toString());
                JMenuItem item = new JMenuItem(new AbstractAction(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT TEXT"), (StringBuffer)elem, parent, eindex){
                    final /* synthetic */ StringBuffer val$elem;
                    final /* synthetic */ XMLElement val$parent;
                    final /* synthetic */ int val$eindex;
                    final /* synthetic */ XMLElementEditor this$0;
                    {
                        this.val$elem = stringBuffer;
                        this.val$parent = xMLElement;
                        this.val$eindex = n;
                        this.this$0 = this$0;
                        super(arg0);
                    }

                    @Override
                    public void actionPerformed(ActionEvent a) {
                        int st = this.this$0.showXMLElement(this.val$elem);
                        if (st == 0) {
                            this.val$parent.removeChild(this.val$elem.toString());
                        } else if (st == 1) {
                            this.val$parent.setContent(this.val$eindex, this.val$elem.toString());
                        }
                    }
                });
                if (((StringBuffer)elem).length() > 0) {
                    item.setText("<html><body width=500>" + ((StringBuffer)elem).toString() + "</body></html>");
                }
                menu.add(item);
            }
        }
    }

    private int showXMLElement(Object elem) {
        XMLElementEditor dlg = new XMLElementEditor(this.topui, elem);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        return dlg.getStatus();
    }

    public int getStatus() {
        return this.status;
    }
}

