/*
 * Decompiled with CFR 0.152.
 */
package translator.ai;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.GlossaryResource;
import translator.LanguageCodes;
import translator.MainView;
import translator.MatchBoard;
import translator.MySwingWorker;
import translator.Options;
import translator.Prompter;
import translator.ScrollPaneWatermark;
import translator.SourceView;
import translator.TabView;
import translator.TargetView;
import translator.XMLHelper;
import translator.ai.CTLinguistOptions;
import translator.ai.ChatGPTAPI;
import translator.ai.ClaudeAPI;
import translator.ai.DeepSeekAPI;
import translator.ai.GeminiAPI;
import translator.ai.GrokAPI;
import translator.ai.MistralAPI;
import translator.audio.VoiceCapture;
import translator.ui.GridPanel;
import translator.ui.HighlightCaret;
import translator.ui.UITools;
import translator.ui.kodo.KodoButton;
import translator.ui.kodo.KodoComboBoxRenderer;
import translator.ui.kodo.KodoComboBoxUI;
import translator.ui.kodo.KodoGlowingBorder;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class CTLinguist
extends DefaultResource {
    public static String TRANSLATE_VOICE_PROMPT = "Translate this {source} recording into {target}. Output only {target} translation, please.";
    public static String DICTATE_VOICE_PROMPT = "Transcribe this recording. Output only the transcrption, please.";
    private String resourceName = "CT-L1 Linguist";
    private GrokAPI grokAPI;
    private DeepSeekAPI deepSeekAPI;
    private MistralAPI mistralAPI;
    private ChatGPTAPI chatGPTAPI;
    private ClaudeAPI claudeAPI;
    private GeminiAPI geminiAPI;
    private MainView topui;
    private JPopupMenu pop;
    private TabView tview;
    private SourceView sourceview;
    private GridPanel mainPanel;
    private JPanel panelPrompts;
    private JPanel panelAPIs;
    private JTextPane chatPane;
    private JComboBox comboVoice;
    private KodoButton buttonVoice;
    private JRadioButton serviceAIButton1 = null;
    private JRadioButton serviceAIButton2 = null;
    private JRadioButton serviceAIButton3 = null;
    private JRadioButton serviceAIButton4 = null;
    private JRadioButton serviceAIButton5 = null;
    private JRadioButton serviceAIButton6 = null;
    private JButton translateButton;
    private JButton correctButton;
    private KodoButton newChatButton;
    private JButton mButton1;
    private JButton mButton2;
    private JButton mButton3;
    private JButton mButton4;
    private JButton mButton5;
    private JButton mButton6;
    private JButton mButton7;
    private JButton mButton8;
    private JButton mButton9;
    private JButton mButton10;
    private MySwingWorker worker;
    private String result;
    private String resultChatGTP;
    private String resultClaude;
    private String resultGemini;
    private String resultMistral;
    private String resultDeepSeek;
    private String resultGrok;
    private Timer timer;
    private boolean canLook = true;
    private String name = "ChatGPT";
    private String newChatString;
    private String[] prompts;
    private String source;
    private String prompt;
    private boolean chatMode;
    private LinkedHashMap<String, String> contexts;
    private List<String> promptHistory;
    private int prompIndex = 0;
    private int blinkRate;
    public static int selectedOptionsTab = 0;
    private int maxContextsSize = 2;
    private int speakCount;
    private int voicePromptIndex = 0;
    ActionListener timerAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CTLinguist.this.canLook = true;
        }
    };

    public CTLinguist() {
        this.setAPI();
        this.newChatString = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW CHAT");
        this.timer = new Timer(200, this.timerAction);
        this.timer.setRepeats(true);
        this.contexts = new LinkedHashMap<String, String>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > CTLinguist.this.maxContextsSize;
            }
        };
        this.promptHistory = new ArrayList<String>();
        this.prompts = new String[12];
        this.setPrompts();
    }

    private void setAPI() {
        if (!AppPreferences.integrateALLAIs) {
            this.chatGPTAPI = null;
            this.claudeAPI = null;
            this.geminiAPI = null;
            this.mistralAPI = null;
            this.deepSeekAPI = null;
            this.grokAPI = null;
        }
        if (AppPreferences.aiServiceChatGPT) {
            this.name = "ChatGPT";
            if (this.chatGPTAPI == null) {
                this.chatGPTAPI = new ChatGPTAPI();
            }
        } else if (AppPreferences.aiServiceClaude) {
            this.name = "Claude";
            if (this.claudeAPI == null) {
                this.claudeAPI = new ClaudeAPI();
            }
        } else if (AppPreferences.aiServiceGemini) {
            this.name = "Gemini";
            if (this.geminiAPI == null) {
                this.geminiAPI = new GeminiAPI();
            }
        } else if (AppPreferences.aiServiceMistral) {
            this.name = "Mistral";
            if (this.mistralAPI == null) {
                this.mistralAPI = new MistralAPI();
            }
        } else if (AppPreferences.aiServiceDeepSeek) {
            this.name = "DeepSeek";
            if (this.deepSeekAPI == null) {
                this.deepSeekAPI = new DeepSeekAPI();
            }
        } else if (AppPreferences.aiServiceGrok) {
            this.name = "Grok";
            if (this.grokAPI == null) {
                this.grokAPI = new GrokAPI();
            }
        } else {
            this.name = "ChatGPT";
            if (this.chatGPTAPI == null) {
                this.chatGPTAPI = new ChatGPTAPI();
            }
        }
    }

    void setPrompts() {
        this.prompts[0] = AppPreferences.chatGPTPromptTranslate;
        this.prompts[1] = AppPreferences.chatGPTPromptCheck;
        this.prompts[2] = AppPreferences.chatGPTPromptM1;
        this.prompts[3] = AppPreferences.chatGPTPromptM2;
        this.prompts[4] = AppPreferences.chatGPTPromptM3;
        this.prompts[5] = AppPreferences.chatGPTPromptM4;
        this.prompts[6] = AppPreferences.chatGPTPromptM5;
        this.prompts[7] = AppPreferences.chatGPTPromptM6;
        this.prompts[8] = AppPreferences.chatGPTPromptM7;
        this.prompts[9] = AppPreferences.chatGPTPromptM8;
        this.prompts[10] = AppPreferences.chatGPTPromptM9;
        this.prompts[11] = AppPreferences.chatGPTPromptM10;
    }

    void setButtonsText() {
        if (this.mButton1 == null) {
            return;
        }
        String title = this.getButtonTitle(AppPreferences.chatGPTPromptTranslate, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE"));
        this.translateButton.setText(title);
        this.translateButton.setToolTipText(AppPreferences.chatGPTPromptTranslate);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptCheck, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK"));
        this.correctButton.setText(title);
        this.correctButton.setToolTipText(AppPreferences.chatGPTPromptCheck);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM1, "M1");
        this.mButton1.setText(title);
        this.mButton1.setToolTipText(AppPreferences.chatGPTPromptM1);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM2, "M2");
        this.mButton2.setText(title);
        this.mButton2.setToolTipText(AppPreferences.chatGPTPromptM2);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM3, "M3");
        this.mButton3.setText(title);
        this.mButton3.setToolTipText(AppPreferences.chatGPTPromptM3);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM4, "M4");
        this.mButton4.setText(title);
        this.mButton4.setToolTipText(AppPreferences.chatGPTPromptM4);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM5, "M5");
        this.mButton5.setText(title);
        this.mButton5.setToolTipText(AppPreferences.chatGPTPromptM5);
        int rows = 2;
        if (AppPreferences.chatGPTPromptM6.length() > 0 || AppPreferences.chatGPTPromptM7.length() > 0 || AppPreferences.chatGPTPromptM8.length() > 0 || AppPreferences.chatGPTPromptM9.length() > 0 || AppPreferences.chatGPTPromptM10.length() > 0) {
            rows = 3;
        }
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM6, "M6");
        this.mButton6.setText(title);
        this.mButton6.setToolTipText(AppPreferences.chatGPTPromptM6);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM7, "M7");
        this.mButton7.setText(title);
        this.mButton7.setToolTipText(AppPreferences.chatGPTPromptM7);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM8, "M8");
        this.mButton8.setText(title);
        this.mButton8.setToolTipText(AppPreferences.chatGPTPromptM8);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM9, "M9");
        this.mButton9.setText(title);
        this.mButton9.setToolTipText(AppPreferences.chatGPTPromptM9);
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM10, "M10");
        this.mButton10.setText(title);
        this.mButton10.setToolTipText(AppPreferences.chatGPTPromptM10);
        this.panelPrompts.remove(this.mButton6);
        this.panelPrompts.remove(this.mButton7);
        this.panelPrompts.remove(this.mButton8);
        this.panelPrompts.remove(this.mButton9);
        this.panelPrompts.remove(this.mButton10);
        this.panelPrompts.setLayout(new GridLayout(rows, 5, 1, 1));
        if (rows == 3) {
            this.panelPrompts.add(this.mButton6);
            this.panelPrompts.add(this.mButton7);
            this.panelPrompts.add(this.mButton8);
            this.panelPrompts.add(this.mButton9);
            this.panelPrompts.add(this.mButton10);
        }
        this.panelPrompts.revalidate();
        this.panelPrompts.repaint();
    }

    public String getName() {
        return this.name;
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JCheckBoxMenuItem item1 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIDE BUTTONS"));
        item1.setSelected(AppPreferences.chatGPTHideButtons);
        item1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.chatGPTHideButtons = true;
                    CTLinguist.this.mainPanel.remove(CTLinguist.this.panelPrompts);
                } else {
                    AppPreferences.chatGPTHideButtons = false;
                    CTLinguist.this.mainPanel.add((Component)CTLinguist.this.panelPrompts, "South");
                }
                CTLinguist.this.mainPanel.revalidate();
                CTLinguist.this.mainPanel.repaint();
            }
        });
        JCheckBoxMenuItem item2 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PAUSE AI SERVICE"));
        item2.setSelected(AppPreferences.chatGPTPause);
        item2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.chatGPTPause = e.getStateChange() == 1;
            }
        });
        JMenuItem item = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLEAR"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTLinguist.this.showMessage("", false);
            }
        });
        this.pop.add(item);
        this.pop.add(item1);
        this.pop.add(item2);
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.sourceview = topui.getSourceView();
        this.mainPanel = new GridPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setOpaque(false);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0) {
            this.mainPanel.setOpaque(true);
            this.mainPanel.setBackground(GridPanel.darker(topui.getMainPanelBackgroundColor(), 0.92));
        }
        this.setPopup();
        this.setServicesPanel();
        this.setPromptsPanel();
        this.mainPanel.add((Component)this.createScrollPane(), "Center");
        this.tview.addTab(this, this.resourceName, this.mainPanel);
    }

    void setPromptsPanel() {
        this.panelPrompts = new JPanel();
        if (AppPreferences.alpha != -1) {
            this.panelPrompts.setOpaque(false);
        } else {
            this.panelPrompts.setOpaque(false);
        }
        if (AppPreferences.tbackground2 != 0) {
            if (!AppPreferences.backGrid) {
                this.panelPrompts.setBackground(this.topui.getMainPanelBackgroundColor());
            } else {
                this.panelPrompts.setBackground(GridPanel.darker(this.topui.getMainPanelBackgroundColor(), 0.92));
            }
        }
        this.panelPrompts.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        boolean nimbuslaf = false;
        if (AppPreferences.laf.equals("Nimbus")) {
            nimbuslaf = true;
        }
        String title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE");
        this.translateButton = new KodoButton(title);
        this.translateButton.setToolTipText(AppPreferences.chatGPTPromptTranslate);
        this.translateButton.setBackground(this.topui.getMainPanelBackgroundColor());
        this.translateButton.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.translateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = CTLinguist.this.getPrompt(true, false);
                if (s != null) {
                    CTLinguist.this.chatPane.requestFocusInWindow();
                    CTLinguist.this.translate(s, true, false);
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptCheck, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHECK"));
        this.correctButton = new KodoButton(title);
        this.correctButton.setToolTipText(AppPreferences.chatGPTPromptCheck);
        this.correctButton.setBackground(this.topui.getMainPanelBackgroundColor());
        this.correctButton.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.correctButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptCheck;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM1, "M1");
        this.mButton1 = new KodoButton(title);
        this.mButton1.setToolTipText(AppPreferences.chatGPTPromptM1);
        this.mButton1.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton1.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM1;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM2, "M2");
        this.mButton2 = new KodoButton(title);
        this.mButton2.setToolTipText(AppPreferences.chatGPTPromptM2);
        this.mButton2.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton2.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM2;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM3, "M3");
        this.mButton3 = new KodoButton(title);
        this.mButton3.setToolTipText(AppPreferences.chatGPTPromptM3);
        this.mButton3.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton3.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM3;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM4, "M4");
        this.mButton4 = new KodoButton(title);
        this.mButton4.setToolTipText(AppPreferences.chatGPTPromptM4);
        this.mButton4.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton4.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM4;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM5, "M5");
        this.mButton5 = new KodoButton(title);
        this.mButton5.setToolTipText(AppPreferences.chatGPTPromptM5);
        this.mButton5.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton5.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM5;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        int rows = 2;
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM6, "M6");
        this.mButton6 = new KodoButton(title);
        this.mButton6.setToolTipText(AppPreferences.chatGPTPromptM6);
        this.mButton6.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton6.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM6;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM7, "M7");
        this.mButton7 = new KodoButton(title);
        this.mButton7.setToolTipText(AppPreferences.chatGPTPromptM7);
        this.mButton7.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton7.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM7;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM8, "M8");
        this.mButton8 = new KodoButton(title);
        this.mButton8.setToolTipText(AppPreferences.chatGPTPromptM8);
        this.mButton8.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton8.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM8;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM9, "M9");
        this.mButton9 = new KodoButton(title);
        this.mButton9.setToolTipText(AppPreferences.chatGPTPromptM9);
        this.mButton9.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton9.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM9;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = this.getButtonTitle(AppPreferences.chatGPTPromptM10, "M10");
        this.mButton10 = new KodoButton(title);
        this.mButton10.setToolTipText(AppPreferences.chatGPTPromptM10);
        this.mButton10.setBackground(this.topui.getMainPanelBackgroundColor());
        this.mButton10.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.mButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String startPrompt = AppPreferences.chatGPTPromptM10;
                if (startPrompt.length() > 0) {
                    String s;
                    boolean sourceLang = false;
                    if (startPrompt.indexOf("{source}") != -1) {
                        sourceLang = true;
                    }
                    boolean targetLang = false;
                    if (startPrompt.indexOf("{target}") != -1) {
                        targetLang = true;
                    }
                    if ((s = CTLinguist.this.getPrompt(sourceLang, targetLang)) != null) {
                        CTLinguist.this.chat(startPrompt, s, true, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSFER");
        KodoButton transferButton = new KodoButton(title);
        ((JComponent)transferButton).setBackground(this.topui.getMainPanelBackgroundColor());
        transferButton.setForeground(new Color(AppPreferences.toolBarsForeground));
        transferButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTLinguist.this.applyResult(CTLinguist.this.result, false);
            }
        });
        title = this.newChatString;
        this.newChatButton = new KodoButton(title);
        this.newChatButton.setBackground(this.topui.getMainPanelBackgroundColor());
        this.newChatButton.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.newChatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTLinguist.this.newChat();
            }
        });
        title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPTIONS");
        KodoButton optionsButton = new KodoButton(title);
        ((JComponent)optionsButton).setBackground(this.topui.getMainPanelBackgroundColor());
        optionsButton.setForeground(new Color(AppPreferences.toolBarsForeground));
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTLinguist.this.setOptions(CTLinguist.this.topui);
            }
        });
        this.panelPrompts.setLayout(new GridLayout(rows, 5, 1, 1));
        this.panelPrompts.add(this.translateButton);
        this.panelPrompts.add(this.correctButton);
        this.panelPrompts.add(transferButton);
        this.panelPrompts.add(this.newChatButton);
        this.panelPrompts.add(optionsButton);
        this.panelPrompts.add(this.mButton1);
        this.panelPrompts.add(this.mButton2);
        this.panelPrompts.add(this.mButton3);
        this.panelPrompts.add(this.mButton4);
        this.panelPrompts.add(this.mButton5);
        if (rows == 3) {
            this.panelPrompts.add(this.mButton6);
            this.panelPrompts.add(this.mButton7);
            this.panelPrompts.add(this.mButton8);
            this.panelPrompts.add(this.mButton9);
            this.panelPrompts.add(this.mButton10);
        }
        if (!AppPreferences.chatGPTHideButtons) {
            this.mainPanel.add((Component)this.panelPrompts, "South");
        }
    }

    void setServicesPanel() {
        this.panelAPIs = new JPanel();
        this.panelAPIs.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.panelAPIs.setLayout(new BoxLayout(this.panelAPIs, 0));
        if (AppPreferences.alpha != -1) {
            this.panelAPIs.setOpaque(false);
        } else {
            this.panelAPIs.setOpaque(true);
        }
        this.panelAPIs.setBackground(this.topui.getMainPanelBackgroundColor());
        this.buttonVoice = new KodoButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TALK TO AI"));
        this.buttonVoice.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TALK TO AI"));
        if (AppPreferences.operatingSystem == 0) {
            this.buttonVoice.setFocusable(false);
        }
        this.buttonVoice.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.buttonVoice.setBackground(this.topui.getMainPanelBackgroundColor());
        this.buttonVoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTLinguist.this.topui.getResourceView().speakToAI();
            }
        });
        String[] voiceOptions = new String[]{"Translate", "Voice edit", "Transcribe", "Voice chat"};
        this.comboVoice = new JComboBox<String>(voiceOptions);
        this.comboVoice.setPreferredSize(new Dimension(150, this.comboVoice.getPreferredSize().height));
        this.comboVoice.setMaximumSize(new Dimension(150, this.comboVoice.getPreferredSize().height + 2));
        if (!AppPreferences.linuxGTK && !AppPreferences.theme.equals("System")) {
            this.comboVoice.setRenderer(new KodoComboBoxRenderer());
            KodoGlowingBorder border = new KodoGlowingBorder();
            int t = 180;
            Color c = new Color(AppPreferences.iconsColor);
            Color color = new Color(c.getRed(), c.getGreen(), c.getBlue(), t);
            border.setColors(new Color(200, 200, 200, t), new Color(200, 200, 200, t), color);
            this.comboVoice.setBorder(border);
            KodoComboBoxUI ui = new KodoComboBoxUI();
            this.comboVoice.setUI(ui);
            if (AppPreferences.tbackground != 0) {
                Color background = new Color(AppPreferences.tbackground);
                Color foreground = new Color(AppPreferences.tforeground);
                this.comboVoice.setBackground(background);
                this.comboVoice.setForeground(foreground);
                ui.setButtonColors(foreground, background);
            }
        }
        this.serviceAIButton1 = new JRadioButton("ChatGPT");
        this.serviceAIButton1.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.serviceAIButton1.setOpaque(false);
        this.serviceAIButton1.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.aiServiceChatGPT) {
            this.serviceAIButton1.setSelected(true);
        }
        this.serviceAIButton1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.aiServiceChatGPT = true;
                    AppPreferences.aiServiceClaude = false;
                    AppPreferences.aiServiceGemini = false;
                    AppPreferences.aiServiceMistral = false;
                    AppPreferences.aiServiceDeepSeek = false;
                    AppPreferences.aiServiceGrok = false;
                    CTLinguist.this.setAPI();
                    if (CTLinguist.this.prompt != null) {
                        CTLinguist.this.chat(CTLinguist.this.prompt, CTLinguist.this.source, CTLinguist.this.chatMode, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        this.serviceAIButton2 = new JRadioButton("Claude");
        this.serviceAIButton2.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.serviceAIButton2.setOpaque(false);
        this.serviceAIButton2.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.aiServiceClaude) {
            this.serviceAIButton2.setSelected(true);
        }
        this.serviceAIButton2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.aiServiceClaude = true;
                    AppPreferences.aiServiceChatGPT = false;
                    AppPreferences.aiServiceGemini = false;
                    AppPreferences.aiServiceMistral = false;
                    AppPreferences.aiServiceDeepSeek = false;
                    AppPreferences.aiServiceGrok = false;
                    CTLinguist.this.setAPI();
                    if (CTLinguist.this.prompt != null) {
                        CTLinguist.this.chat(CTLinguist.this.prompt, CTLinguist.this.source, CTLinguist.this.chatMode, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        this.serviceAIButton3 = new JRadioButton("Gemini");
        this.serviceAIButton3.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.serviceAIButton3.setOpaque(false);
        this.serviceAIButton3.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.aiServiceGemini) {
            this.serviceAIButton3.setSelected(true);
        }
        this.serviceAIButton3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.aiServiceGemini = true;
                    AppPreferences.aiServiceClaude = false;
                    AppPreferences.aiServiceChatGPT = false;
                    AppPreferences.aiServiceMistral = false;
                    AppPreferences.aiServiceDeepSeek = false;
                    AppPreferences.aiServiceGrok = false;
                    CTLinguist.this.setAPI();
                    if (CTLinguist.this.prompt != null) {
                        CTLinguist.this.chat(CTLinguist.this.prompt, CTLinguist.this.source, CTLinguist.this.chatMode, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        this.serviceAIButton4 = new JRadioButton("Mistral");
        this.serviceAIButton4.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.serviceAIButton4.setOpaque(false);
        this.serviceAIButton4.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.aiServiceMistral) {
            this.serviceAIButton4.setSelected(true);
        }
        this.serviceAIButton4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.aiServiceMistral = true;
                    AppPreferences.aiServiceClaude = false;
                    AppPreferences.aiServiceChatGPT = false;
                    AppPreferences.aiServiceGemini = false;
                    AppPreferences.aiServiceDeepSeek = false;
                    AppPreferences.aiServiceGrok = false;
                    CTLinguist.this.setAPI();
                    if (CTLinguist.this.prompt != null) {
                        CTLinguist.this.chat(CTLinguist.this.prompt, CTLinguist.this.source, CTLinguist.this.chatMode, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        this.serviceAIButton5 = new JRadioButton("DeepSeek");
        this.serviceAIButton5.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.serviceAIButton5.setOpaque(false);
        this.serviceAIButton5.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.aiServiceDeepSeek) {
            this.serviceAIButton5.setSelected(true);
        }
        this.serviceAIButton5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.aiServiceDeepSeek = true;
                    AppPreferences.aiServiceMistral = false;
                    AppPreferences.aiServiceClaude = false;
                    AppPreferences.aiServiceChatGPT = false;
                    AppPreferences.aiServiceGemini = false;
                    AppPreferences.aiServiceGrok = false;
                    CTLinguist.this.setAPI();
                    if (CTLinguist.this.prompt != null) {
                        CTLinguist.this.chat(CTLinguist.this.prompt, CTLinguist.this.source, CTLinguist.this.chatMode, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        this.serviceAIButton6 = new JRadioButton("Grok");
        this.serviceAIButton6.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.serviceAIButton6.setOpaque(false);
        this.serviceAIButton6.setForeground(new Color(AppPreferences.toolBarsForeground));
        if (AppPreferences.aiServiceGrok) {
            this.serviceAIButton6.setSelected(true);
        }
        this.serviceAIButton6.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.aiServiceGrok = true;
                    AppPreferences.aiServiceDeepSeek = false;
                    AppPreferences.aiServiceMistral = false;
                    AppPreferences.aiServiceClaude = false;
                    AppPreferences.aiServiceChatGPT = false;
                    AppPreferences.aiServiceGemini = false;
                    CTLinguist.this.setAPI();
                    if (CTLinguist.this.prompt != null) {
                        CTLinguist.this.chat(CTLinguist.this.prompt, CTLinguist.this.source, CTLinguist.this.chatMode, CTLinguist.this.chatPane);
                    }
                }
            }
        });
        ButtonGroup bgr = new ButtonGroup();
        bgr.add(this.serviceAIButton1);
        bgr.add(this.serviceAIButton2);
        bgr.add(this.serviceAIButton3);
        bgr.add(this.serviceAIButton4);
        bgr.add(this.serviceAIButton5);
        bgr.add(this.serviceAIButton6);
        this.panelAPIs.add(Box.createHorizontalGlue());
        this.addAIServiceCheckBoxes();
        this.panelAPIs.add(Box.createHorizontalStrut(25));
        this.panelAPIs.add(this.buttonVoice);
        this.panelAPIs.add(Box.createHorizontalStrut(5));
        this.panelAPIs.add(this.comboVoice);
        this.mainPanel.add((Component)this.panelAPIs, "North");
    }

    public void addAIServiceCheckBoxes() {
        if (this.panelAPIs != null) {
            int i = this.panelAPIs.getComponentCount();
            if (i > 1) {
                this.panelAPIs.remove(this.serviceAIButton1);
                this.panelAPIs.remove(this.serviceAIButton2);
                this.panelAPIs.remove(this.serviceAIButton3);
                this.panelAPIs.remove(this.serviceAIButton4);
                this.panelAPIs.remove(this.serviceAIButton5);
                this.panelAPIs.remove(this.serviceAIButton6);
            }
            int count = 1;
            if (AppPreferences.chatGPTAPIKey.length() > 0) {
                this.panelAPIs.add((Component)this.serviceAIButton1, count);
                ++count;
            }
            if (AppPreferences.claudeGPTAPIKey.length() > 0) {
                this.panelAPIs.add((Component)this.serviceAIButton2, count);
                ++count;
            }
            if (AppPreferences.geminiGPTAPIKey.length() > 0) {
                this.panelAPIs.add((Component)this.serviceAIButton3, count);
                ++count;
            }
            if (AppPreferences.mistralGPTAPIKey.length() > 0) {
                this.panelAPIs.add((Component)this.serviceAIButton4, count);
                ++count;
            }
            if (AppPreferences.deepSeekGPTAPIKey.length() > 0) {
                this.panelAPIs.add((Component)this.serviceAIButton5, count);
                ++count;
            }
            if (AppPreferences.grokGPTAPIKey.length() > 0) {
                this.panelAPIs.add((Component)this.serviceAIButton6, count);
                ++count;
            }
            if (i > 1) {
                this.panelAPIs.revalidate();
                this.panelAPIs.repaint();
            }
        }
    }

    private JScrollPane createScrollPane() {
        File file;
        this.chatPane = new JTextPane();
        this.chatPane.putClientProperty("type", "memory");
        Graphics g = this.chatPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.chatPane.setCaretColor(foreground);
            this.chatPane.setBackground(background);
            this.chatPane.setForeground(foreground);
            this.chatPane.setSelectionColor(selection);
            this.chatPane.setSelectedTextColor(foreground);
        }
        if (AppPreferences.laf != null && AppPreferences.laf.equals("Mac OS")) {
            this.chatPane.setCaret(new HighlightCaret());
        }
        this.chatPane.setFont(new Font(AppPreferences.tfontname, 1, AppPreferences.tfontsize));
        this.chatPane.setMargin(new Insets(8, 32, 16, 32));
        this.chatPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CTLinguist.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.chatPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    CTLinguist.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                boolean ctrl = UITools.isShortcutDown(evt);
                if (!ctrl && evt.getButton() == 1) {
                    String sel;
                    int cc = evt.getClickCount();
                    if (cc < 2 && (sel = CTLinguist.this.chatPane.getSelectedText()) != null && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                        try {
                            int spos = Utilities.getWordStart(CTLinguist.this.chatPane, CTLinguist.this.chatPane.getSelectionStart());
                            int epos = Utilities.getWordEnd(CTLinguist.this.chatPane, CTLinguist.this.chatPane.getSelectionEnd() - 1);
                            CTLinguist.this.chatPane.setSelectionStart(spos);
                            CTLinguist.this.chatPane.setSelectionEnd(epos);
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((sel = CTLinguist.this.chatPane.getSelectedText()) != null) {
                        if (AppPreferences.chatGPTAction == 2) {
                            CTLinguist.this.message(sel, true);
                        } else {
                            TargetView pview = CTLinguist.this.topui.getTargetView();
                            pview.grabSelection(sel);
                        }
                        if (AppPreferences.ttsSpeak == 2) {
                            CTLinguist.this.topui.getResourceView().speak(sel);
                        }
                        if (AppPreferences.selectionRecording && AppPreferences.autoSelectionRecording) {
                            CTLinguist.this.topui.getSourceView().addSelectedWord(sel, true);
                        }
                    }
                }
                if (evt.isPopupTrigger()) {
                    CTLinguist.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.chatPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keycode = e.getKeyCode();
                if (keycode == 10) {
                    e.consume();
                    CTLinguist.this.promptChat();
                } else if (keycode == 8) {
                    char c;
                    String t = CTLinguist.this.chatPane.getText();
                    int p = CTLinguist.this.chatPane.getCaretPosition();
                    if (p > 0 && (c = t.charAt(p - 1)) == '\n') {
                        e.consume();
                    }
                } else if (keycode == 38 && CTLinguist.this.promptHistory.size() > 0) {
                    String t = CTLinguist.this.chatPane.getText();
                    int p = CTLinguist.this.chatPane.getCaretPosition();
                    if (p == t.length()) {
                        String s;
                        CTLinguist.this.prompIndex--;
                        if (CTLinguist.this.prompIndex < 0) {
                            CTLinguist.this.prompIndex = -1;
                            s = "";
                        } else if (CTLinguist.this.prompIndex >= CTLinguist.this.promptHistory.size()) {
                            CTLinguist.this.prompIndex = CTLinguist.this.promptHistory.size();
                            s = (String)CTLinguist.this.promptHistory.get(CTLinguist.this.prompIndex);
                        } else {
                            s = (String)CTLinguist.this.promptHistory.get(CTLinguist.this.prompIndex);
                        }
                        StyledDocument doc = CTLinguist.this.chatPane.getStyledDocument();
                        if (t.length() == 0) {
                            try {
                                doc.insertString(0, s, null);
                            }
                            catch (BadLocationException ex) {
                                Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        } else {
                            int i = t.lastIndexOf("\n");
                            if (i == -1) {
                                i = 0;
                            } else {
                                s = "\n" + s;
                            }
                            if (i < t.length()) {
                                try {
                                    doc.remove(i, t.length() - i);
                                    doc.insertString(i, s, null);
                                }
                                catch (BadLocationException ex) {
                                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        }
                        e.consume();
                    }
                } else if (keycode == 40 && CTLinguist.this.promptHistory.size() > 0) {
                    String t = CTLinguist.this.chatPane.getText();
                    int p = CTLinguist.this.chatPane.getCaretPosition();
                    if (p == t.length()) {
                        String s;
                        CTLinguist.this.prompIndex++;
                        if (CTLinguist.this.prompIndex < 0) {
                            CTLinguist.this.prompIndex = 0;
                            s = (String)CTLinguist.this.promptHistory.get(CTLinguist.this.prompIndex);
                        } else if (CTLinguist.this.prompIndex >= CTLinguist.this.promptHistory.size()) {
                            CTLinguist.this.prompIndex = CTLinguist.this.promptHistory.size();
                            s = "";
                        } else {
                            s = (String)CTLinguist.this.promptHistory.get(CTLinguist.this.prompIndex);
                        }
                        StyledDocument doc = CTLinguist.this.chatPane.getStyledDocument();
                        if (t.length() == 0) {
                            try {
                                doc.insertString(0, s, null);
                            }
                            catch (BadLocationException ex) {
                                Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        } else {
                            int i = t.lastIndexOf("\n");
                            if (i == -1) {
                                i = 0;
                            } else {
                                s = "\n" + s;
                            }
                            if (i < t.length()) {
                                try {
                                    doc.remove(i, t.length() - i);
                                    doc.insertString(i, s, null);
                                }
                                catch (BadLocationException ex) {
                                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }
                        }
                        e.consume();
                    }
                }
            }
        });
        this.chatPane.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                final int dot = e.getDot();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 30 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        try {
                            Rectangle r = this.this$1.CTLinguist.this.chatPane.getVisibleRect();
                            Rectangle2D r0 = this.this$1.CTLinguist.this.chatPane.modelToView2D(dot);
                            int w = (int)r.getWidth();
                            int h = (int)r.getHeight();
                            int x = (int)r.getX();
                            int y = (int)r.getY();
                            int y0 = (int)r0.getY();
                            if (y0 - y + 40 >= h) {
                                r = new Rectangle(x, y0, w, h);
                                this.this$1.CTLinguist.this.chatPane.scrollRectToVisible(r);
                            } else if (y0 < 40) {
                                r = new Rectangle(0, 0, w, h);
                                this.this$1.CTLinguist.this.chatPane.scrollRectToVisible(r);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        StyledDocument document = this.chatPane.getStyledDocument();
        Style style = document.addStyle("chat", null);
        StyleConstants.setBold(style, false);
        style = document.addStyle("default", null);
        StyleConstants.setBold(style, true);
        document.addStyle("Tags", null);
        JScrollPane jScrollPane = new JScrollPane();
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.chatPane.setOpaque(false);
            this.chatPane.setBackground(new Color(0, 0, 0, 0));
        }
        jScrollPane.getViewport().add((Component)this.chatPane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.chatPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.chatPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.blinkRate = this.chatPane.getCaret().getBlinkRate();
        return jScrollPane;
    }

    public void clearSelection() {
        int i = this.chatPane.getSelectionEnd();
        if (i != -1) {
            this.chatPane.setCaretPosition(i);
        }
    }

    public JTextComponent getChatPane() {
        return this.chatPane;
    }

    public void setOptions(Options frame, int i) {
        CTLinguistOptions dlg = new CTLinguistOptions(frame, this, i);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = frame.getSize();
        Point loc = frame.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    public void setOptions(MainView frame) {
        CTLinguistOptions dlg = new CTLinguistOptions(frame, this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = frame.getSize();
        Point loc = frame.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    public void newChat() {
        this.contexts.clear();
        this.showMessage("", false);
    }

    private void showMessage(String mes, boolean append) {
        if (this.chatPane != null) {
            StyledDocument doc = this.chatPane.getStyledDocument();
            int len = doc.getLength();
            try {
                Style chatStyle = doc.getStyle("chat");
                Style defaultSyte = doc.getStyle("default");
                if (!append) {
                    if (len > 0) {
                        doc.remove(0, len);
                        len = 0;
                    }
                    if (mes != null && mes.length() > 0) {
                        doc.insertString(len, mes + "\n\n", chatStyle);
                        doc.setCharacterAttributes(doc.getLength(), 1, defaultSyte, true);
                    } else {
                        this.chatPane.requestFocusInWindow();
                    }
                } else if (mes != null) {
                    doc.insertString(len, mes + "\n\n", chatStyle);
                    doc.setCharacterAttributes(doc.getLength(), 1, defaultSyte, true);
                }
                if (this.chatPane.isEditable()) {
                    this.chatPane.setCaretPosition(doc.getLength());
                } else {
                    this.chatPane.setCaretPosition(0);
                }
                if (doc.getLength() > 1) {
                    Font font = this.chatPane.getFont();
                    font = font.deriveFont(1, AppPreferences.tagsfontsize);
                    XMLHelper.markTags(doc, font);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setMatchStatus() {
        XLIFFUnit tu;
        XLIFF xliff = this.topui.getProjectView().getProject().getXLIFF();
        if (xliff != null && (tu = xliff.getWorkflow().getCheckTransUnit()) != null) {
            this.topui.getTargetView().setEdited(false);
            tu.removeMatch(false);
            boolean storeMatch = false;
            if (xliff.isCafeTranXLIFF) {
                storeMatch = true;
            }
            tu.setMatch(-1, 0, storeMatch);
        }
    }

    public void apply(boolean auto) {
        this.applyResult(this.result, auto);
    }

    private void applyResult(String r, boolean auto) {
        if (r != null) {
            Document tdoc = this.topui.getTargetPane().getDocument();
            try {
                int len = tdoc.getLength();
                if (len > 0) {
                    if (!auto) {
                        tdoc.remove(0, len);
                    } else {
                        return;
                    }
                }
                tdoc.insertString(0, r, null);
                if (auto) {
                    this.topui.getTargetPane().selectAll();
                } else {
                    this.topui.getTargetPane().setCaretPosition(0);
                }
                this.setMatchStatus();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void message(String source, boolean chatMode) {
        if (AppPreferences.chatGPTDefaultPrompt == 0) {
            this.translate(source, true, chatMode);
        } else {
            String startPrompt = this.prompts[AppPreferences.chatGPTDefaultPrompt];
            if (startPrompt != null && startPrompt.length() > 0) {
                String s;
                boolean sourceLang = false;
                if (startPrompt.indexOf("{source}") != -1) {
                    sourceLang = true;
                }
                boolean targetLang = false;
                if (startPrompt.indexOf("{target}") != -1) {
                    targetLang = true;
                }
                if ((s = this.getPrompt(sourceLang, targetLang)) != null) {
                    this.chat(startPrompt, s, chatMode, this.chatPane);
                }
            }
        }
    }

    private void translate(String source, final boolean glossary, final boolean chatMode) {
        if (AppPreferences.isTrialVersion && AppPreferences.countAIPrompts >= 10) {
            String s = "CT-L1 Linguist trial version limit in one session has been reached.";
            this.showMessage(s, true);
            return;
        }
        if (!this.canLook || AppPreferences.chatGPTPause) {
            return;
        }
        this.prompt = AppPreferences.chatGPTPromptTranslate;
        this.source = source;
        this.chatMode = chatMode;
        final String key = source = source.replaceAll("\\s+", " ");
        this.newChatButton.setActive(true);
        this.chatPane.getCaret().setBlinkRate(200);
        this.worker = new MySwingWorker(this){
            final /* synthetic */ CTLinguist this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                if (LanguageCodes.sourceLanguage == null) {
                    LanguageCodes.setSourceLanguage();
                }
                if (LanguageCodes.targetLanguage == null) {
                    LanguageCodes.setTargetLanguage();
                }
                String myPrompt = AppPreferences.chatGPTPromptTranslate.replace("{source}", LanguageCodes.sourceLanguage);
                myPrompt = myPrompt.replace("{target}", LanguageCodes.targetLanguage);
                myPrompt = myPrompt.replace("*", "");
                myPrompt = myPrompt + "\n" + key;
                String terms = null;
                if (glossary) {
                    terms = this.this$0.getGlossaryPrompt();
                }
                this.this$0.result = "";
                this.this$0.resultChatGTP = "";
                this.this$0.resultClaude = "";
                this.this$0.resultGemini = "";
                this.this$0.resultMistral = "";
                this.this$0.resultDeepSeek = "";
                this.this$0.resultGrok = "";
                if (!chatMode && AppPreferences.integrateALLAIs) {
                    this.this$0.promptAll(myPrompt, terms, chatMode);
                } else {
                    this.this$0.prompt(myPrompt, terms, chatMode);
                }
                ++AppPreferences.countAIPrompts;
                return null;
            }

            @Override
            public void finished() {
                this.this$0.chatPane.getCaret().setBlinkRate(this.this$0.blinkRate);
                this.this$0.newChatButton.setActive(false);
                MatchBoard mb = this.this$0.topui.getMatchBoard();
                if (this.this$0.result != null && this.this$0.result.length() > 0) {
                    this.this$0.showMessage(this.this$0.result, chatMode);
                    if (AppPreferences.ttsSpeak == 3) {
                        this.this$0.topui.getResourceView().speak(this.this$0.result);
                    }
                    if (mb != null) {
                        mb.setMTMatch(this.this$0.result, this.this$0.name, "AI");
                    }
                    this.this$0.setAutotext(this.this$0.result);
                    if (AppPreferences.autoTransferMT.equals(this.this$0.name)) {
                        this.this$0.applyResult(this.this$0.result, true);
                    }
                }
                if (mb != null) {
                    if (this.this$0.resultChatGTP != null && this.this$0.resultChatGTP.length() > 0) {
                        mb.setMTMatch(this.this$0.resultChatGTP, "ChatGPT", "AI");
                    }
                    if (this.this$0.resultClaude != null && this.this$0.resultClaude.length() > 0) {
                        mb.setMTMatch(this.this$0.resultClaude, "Claude", "AI");
                    }
                    if (this.this$0.resultGemini != null && this.this$0.resultGemini.length() > 0) {
                        mb.setMTMatch(this.this$0.resultGemini, "Gemini", "AI");
                    }
                    if (this.this$0.resultMistral != null && this.this$0.resultMistral.length() > 0) {
                        mb.setMTMatch(this.this$0.resultMistral, "Mistral", "AI");
                    }
                    if (this.this$0.resultDeepSeek != null && this.this$0.resultDeepSeek.length() > 0) {
                        mb.setMTMatch(this.this$0.resultDeepSeek, "DeepSeek", "AI");
                    }
                    if (this.this$0.resultGrok != null && this.this$0.resultGrok.length() > 0) {
                        mb.setMTMatch(this.this$0.resultGrok, "Grok", "AI");
                    }
                }
            }
        };
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prompt(String prompt, String terms, boolean chatMode) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
        this.canLook = false;
        try {
            String response = null;
            if (AppPreferences.aiServiceChatGPT && this.chatGPTAPI != null) {
                response = this.chatGPTAPI.chat(prompt, terms, chatMode, this.contexts);
            } else if (AppPreferences.aiServiceClaude && this.claudeAPI != null) {
                response = this.claudeAPI.chat(prompt, terms, chatMode, this.contexts);
            } else if (AppPreferences.aiServiceGemini && this.geminiAPI != null) {
                response = this.geminiAPI.chat(prompt, terms, chatMode, this.contexts);
            } else if (AppPreferences.aiServiceMistral && this.mistralAPI != null) {
                response = this.mistralAPI.chat(prompt, terms, chatMode, this.contexts);
            } else if (AppPreferences.aiServiceDeepSeek && this.deepSeekAPI != null) {
                response = this.deepSeekAPI.chat(prompt, terms, chatMode, this.contexts);
            } else if (AppPreferences.aiServiceGrok && this.grokAPI != null) {
                response = this.grokAPI.chat(prompt, terms, chatMode, this.contexts);
            }
            if (response != null && response.length() > 0) {
                this.result = response;
                this.contexts.put(prompt, response);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
            String e = this.getErrorDescription();
            if (e == null) {
                e = ex.getMessage();
            }
            this.showMessage(e, false);
        }
        finally {
            this.canLook = true;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            if (this.chatGPTAPI != null) {
                this.chatGPTAPI.closeConnection();
            }
            if (this.claudeAPI != null) {
                this.claudeAPI.closeConnection();
            }
            if (this.geminiAPI != null) {
                this.geminiAPI.closeConnection();
            }
            if (this.mistralAPI != null) {
                this.mistralAPI.closeConnection();
            }
            if (this.deepSeekAPI != null) {
                this.deepSeekAPI.closeConnection();
            }
            if (this.grokAPI != null) {
                this.grokAPI.closeConnection();
            }
        }
    }

    private void promptAll(String prompt, String terms, boolean chatMode) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
        this.canLook = false;
        String response = null;
        String error = null;
        if (AppPreferences.chatGPTAPIKey.length() > 0) {
            block41: {
                if (this.chatGPTAPI == null) {
                    this.chatGPTAPI = new ChatGPTAPI();
                }
                try {
                    this.resultChatGTP = this.chatGPTAPI.chat(prompt, terms, chatMode, this.contexts);
                }
                catch (Exception ex) {
                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                    error = this.getErrorDescription();
                    if (error != null) break block41;
                    error = ex.getMessage();
                }
            }
            if (AppPreferences.aiServiceChatGPT) {
                response = this.resultChatGTP;
            }
        }
        if (AppPreferences.claudeGPTAPIKey.length() > 0) {
            block42: {
                if (this.claudeAPI == null) {
                    this.claudeAPI = new ClaudeAPI();
                }
                try {
                    this.resultClaude = this.claudeAPI.chat(prompt, terms, chatMode, this.contexts);
                }
                catch (Exception ex) {
                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                    error = this.getErrorDescription();
                    if (error != null) break block42;
                    error = ex.getMessage();
                }
            }
            if (AppPreferences.aiServiceClaude) {
                response = this.resultClaude;
            }
        }
        if (AppPreferences.geminiGPTAPIKey.length() > 0) {
            block43: {
                if (this.geminiAPI == null) {
                    this.geminiAPI = new GeminiAPI();
                }
                try {
                    this.resultGemini = this.geminiAPI.chat(prompt, terms, chatMode, this.contexts);
                }
                catch (Exception ex) {
                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                    error = this.getErrorDescription();
                    if (error != null) break block43;
                    error = ex.getMessage();
                }
            }
            if (AppPreferences.aiServiceGemini) {
                response = this.resultGemini;
            }
        }
        if (AppPreferences.mistralGPTAPIKey.length() > 0) {
            block44: {
                if (this.mistralAPI == null) {
                    this.mistralAPI = new MistralAPI();
                }
                try {
                    this.resultMistral = this.mistralAPI.chat(prompt, terms, chatMode, this.contexts);
                }
                catch (Exception ex) {
                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                    error = this.getErrorDescription();
                    if (error != null) break block44;
                    error = ex.getMessage();
                }
            }
            if (AppPreferences.aiServiceMistral) {
                response = this.resultMistral;
            }
        }
        if (AppPreferences.deepSeekGPTAPIKey.length() > 0) {
            block45: {
                if (this.deepSeekAPI == null) {
                    this.deepSeekAPI = new DeepSeekAPI();
                }
                try {
                    this.resultDeepSeek = this.deepSeekAPI.chat(prompt, terms, chatMode, this.contexts);
                }
                catch (Exception ex) {
                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                    error = this.getErrorDescription();
                    if (error != null) break block45;
                    error = ex.getMessage();
                }
            }
            if (AppPreferences.aiServiceDeepSeek) {
                response = this.resultDeepSeek;
            }
        }
        if (AppPreferences.grokGPTAPIKey.length() > 0) {
            block46: {
                if (this.grokAPI == null) {
                    this.grokAPI = new GrokAPI();
                }
                try {
                    this.resultGrok = this.grokAPI.chat(prompt, terms, chatMode, this.contexts);
                }
                catch (Exception ex) {
                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                    error = this.getErrorDescription();
                    if (error != null) break block46;
                    error = ex.getMessage();
                }
            }
            if (AppPreferences.aiServiceGrok) {
                response = this.resultGrok;
            }
        }
        if (response != null && response.length() > 0) {
            this.result = response;
            this.contexts.put(prompt, response);
        } else if (error != null) {
            this.showMessage(error, false);
        }
        this.canLook = true;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        if (this.chatGPTAPI != null) {
            this.chatGPTAPI.closeConnection();
        }
        if (this.claudeAPI != null) {
            this.claudeAPI.closeConnection();
        }
        if (this.geminiAPI != null) {
            this.geminiAPI.closeConnection();
        }
        if (this.mistralAPI != null) {
            this.mistralAPI.closeConnection();
        }
        if (this.deepSeekAPI != null) {
            this.deepSeekAPI.closeConnection();
        }
        if (this.grokAPI != null) {
            this.grokAPI.closeConnection();
        }
    }

    private void promptChat() {
        StyledDocument doc = this.chatPane.getStyledDocument();
        try {
            int len = doc.getLength();
            this.chatPane.setCaretPosition(len);
            String s = doc.getText(0, len);
            int i = s.lastIndexOf(10);
            if (i != -1) {
                s = s.substring(i).trim();
            }
            if (s.length() > 0) {
                Style chatStyle = doc.getStyle("chat");
                doc.insertString(len, "\n\n", chatStyle);
                this.chat(s, null, true, this.chatPane);
                this.promptHistory.remove(s);
                this.promptHistory.add(s);
                this.prompIndex = this.promptHistory.size();
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void promptChat(String s, JTextPane pane) {
        this.chat(s, null, true, pane);
        this.promptHistory.remove(s);
        this.promptHistory.add(s);
        this.prompIndex = this.promptHistory.size();
    }

    private void chat(String myPrompt, String phrase, final boolean chatMode, final JTextPane pane) {
        if (AppPreferences.isTrialVersion && AppPreferences.countAIPrompts >= 10) {
            String s = "CT-L1 Linguist trial version limit in one session has been reached.";
            this.showMessage(s, true);
            return;
        }
        if (!this.canLook || AppPreferences.chatGPTPause) {
            return;
        }
        this.prompt = myPrompt;
        this.source = phrase;
        this.chatMode = chatMode;
        if (LanguageCodes.sourceLanguage == null) {
            LanguageCodes.setSourceLanguage();
        }
        if (LanguageCodes.targetLanguage == null) {
            LanguageCodes.setTargetLanguage();
        }
        String prompt = myPrompt.replace("{source}", LanguageCodes.sourceLanguage);
        prompt = prompt.replace("{target}", LanguageCodes.targetLanguage);
        prompt = prompt.replace("*", "");
        final String text = phrase != null ? prompt + "\n" + phrase : prompt;
        this.result = "";
        this.resultChatGTP = "";
        this.resultClaude = "";
        this.resultGemini = "";
        this.resultMistral = "";
        this.resultDeepSeek = "";
        this.resultGrok = "";
        pane.requestFocusInWindow();
        pane.setCaretPosition(pane.getDocument().getLength());
        this.newChatButton.setActive(true);
        pane.getCaret().setBlinkRate(200);
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ CTLinguist this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                if (!chatMode && AppPreferences.integrateALLAIs) {
                    this.this$0.promptAll(text, null, chatMode);
                } else {
                    this.this$0.prompt(text, null, chatMode);
                }
                ++AppPreferences.countAIPrompts;
                return null;
            }

            @Override
            protected void done() {
                pane.getCaret().setBlinkRate(this.this$0.blinkRate);
                this.this$0.newChatButton.setActive(false);
                MatchBoard mb = this.this$0.topui.getMatchBoard();
                if (this.this$0.result != null && this.this$0.result.length() > 0) {
                    if (!chatMode) {
                        if (mb != null) {
                            mb.setMTMatch(this.this$0.result, this.this$0.name, "AI");
                        }
                        this.this$0.setAutotext(this.this$0.result);
                        if (AppPreferences.autoTransferMT.equals(this.this$0.name)) {
                            this.this$0.applyResult(this.this$0.result, true);
                        }
                    }
                    this.this$0.showMessage(this.this$0.result, chatMode);
                    if (AppPreferences.ttsSpeak == 3) {
                        this.this$0.topui.getResourceView().speak(this.this$0.result);
                    }
                }
                if (mb != null) {
                    if (this.this$0.resultChatGTP != null && this.this$0.resultChatGTP.length() > 0) {
                        mb.setMTMatch(this.this$0.resultChatGTP, "ChatGPT", "AI");
                    }
                    if (this.this$0.resultClaude != null && this.this$0.resultClaude.length() > 0) {
                        mb.setMTMatch(this.this$0.resultClaude, "Claude", "AI");
                    }
                    if (this.this$0.resultGemini != null && this.this$0.resultGemini.length() > 0) {
                        mb.setMTMatch(this.this$0.resultGemini, "Gemini", "AI");
                    }
                    if (this.this$0.resultMistral != null && this.this$0.resultMistral.length() > 0) {
                        mb.setMTMatch(this.this$0.resultMistral, "Mistral", "AI");
                    }
                    if (this.this$0.resultDeepSeek != null && this.this$0.resultDeepSeek.length() > 0) {
                        mb.setMTMatch(this.this$0.resultDeepSeek, "DeepSeek", "AI");
                    }
                    if (this.this$0.resultGrok != null && this.this$0.resultGrok.length() > 0) {
                        mb.setMTMatch(this.this$0.resultGrok, "Grok", "AI");
                    }
                }
            }
        };
        worker.execute();
    }

    public void talk(final String text) {
        if (AppPreferences.isTrialVersion && this.speakCount >= 15) {
            String s = "CafeTran trial version limit of 15 spoken segments has been reached.";
            this.showMessage(s, false);
            return;
        }
        if (this.chatGPTAPI == null) {
            return;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
        this.newChatButton.setActive(true);
        SwingWorker worker = new SwingWorker(this){
            String exception = null;
            final /* synthetic */ CTLinguist this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                try {
                    String model = AppPreferences.chatGPTModelTTS == 0 ? "tts-1" : "tts-1-hd";
                    String voice = AppPreferences.chatGPTVoiceTTS == 0 ? "alloy" : (AppPreferences.chatGPTVoiceTTS == 1 ? "echo" : (AppPreferences.chatGPTVoiceTTS == 2 ? "fable" : (AppPreferences.chatGPTVoiceTTS == 3 ? "onyx" : (AppPreferences.chatGPTVoiceTTS == 4 ? "nova" : (AppPreferences.chatGPTVoiceTTS == 5 ? "shimmer" : "nova")))));
                    this.this$0.chatGPTAPI.speak(text, voice, model);
                    this.this$0.speakCount++;
                }
                catch (Exception ex) {
                    this.exception = ex.getMessage();
                }
                finally {
                    if (this.this$0.chatGPTAPI != null) {
                        this.this$0.chatGPTAPI.closeAudioConnection();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.this$0.timer.isRunning()) {
                    this.this$0.timer.stop();
                }
                this.this$0.newChatButton.setActive(false);
                if (this.exception != null) {
                    this.this$0.showMessage(this.exception, true);
                }
            }
        };
        worker.execute();
    }

    public void voicePrompt() {
        if (AppPreferences.isTrialVersion && AppPreferences.countAIPrompts >= 10) {
            String s = "CT-L1 Linguist trial version limit in one session has been reached.";
            this.showMessage(s, true);
            return;
        }
        if (!this.canLook || AppPreferences.chatGPTPause) {
            return;
        }
        if (LanguageCodes.sourceLanguage == null) {
            LanguageCodes.setSourceLanguage();
        }
        if (LanguageCodes.targetLanguage == null) {
            LanguageCodes.setTargetLanguage();
        }
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
        }
        SwingWorker worker = new SwingWorker(){
            String audio = null;

            public String doInBackground() {
                if (!VoiceCapture.isRunning()) {
                    CTLinguist.this.buttonVoice.setActive(true);
                    this.audio = VoiceCapture.captureMic();
                } else {
                    VoiceCapture.stopCapture();
                }
                return null;
            }

            @Override
            protected void done() {
                CTLinguist.this.buttonVoice.setActive(false);
                if (this.audio != null) {
                    CTLinguist.this.sendVoicePrompt(this.audio);
                }
            }
        };
        worker.execute();
    }

    public void sendVoicePrompt(final String audio) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
        this.canLook = false;
        if (this.chatGPTAPI == null) {
            this.chatGPTAPI = new ChatGPTAPI();
        }
        this.result = "";
        this.newChatButton.setActive(true);
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ CTLinguist this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String doInBackground() {
                try {
                    int vmode = this.this$0.getVoiceOption();
                    String vp = null;
                    if (vmode == 0) {
                        vp = TRANSLATE_VOICE_PROMPT;
                    } else if (vmode == 2) {
                        vp = DICTATE_VOICE_PROMPT;
                    } else if (vmode == 1 && ((vp = this.this$0.topui.getTargetPane().getText()) == null || vp.length() == 0)) {
                        vp = this.this$0.topui.getSourcePane().getText();
                    }
                    if (vp != null) {
                        vp = vp.replace("{source}", LanguageCodes.sourceLanguage);
                        vp = vp.replace("{target}", LanguageCodes.targetLanguage);
                        vp = vp.replace("*", "");
                    }
                    boolean audioOut = false;
                    if (AppPreferences.ttsSpeak == 3) {
                        audioOut = true;
                    }
                    this.this$0.result = this.this$0.chatGPTAPI.speak(audio, vp, vmode, this.this$0.contexts, audioOut);
                    if (this.this$0.result != null && this.this$0.result.length() > 0 && vmode == 3) {
                        String no = "#" + Integer.toString(this.this$0.voicePromptIndex);
                        this.this$0.voicePromptIndex++;
                        this.this$0.contexts.putLast(no, this.this$0.result);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                    String e = this.this$0.getErrorDescription();
                    if (e == null) {
                        e = ex.getMessage();
                    }
                    this.this$0.showMessage(e, false);
                }
                finally {
                    this.this$0.canLook = true;
                    if (this.this$0.timer.isRunning()) {
                        this.this$0.timer.stop();
                    }
                    if (this.this$0.chatGPTAPI != null) {
                        this.this$0.chatGPTAPI.closeConnection();
                    }
                }
                ++AppPreferences.countAIPrompts;
                return null;
            }

            @Override
            protected void done() {
                this.this$0.newChatButton.setActive(false);
                if (this.this$0.result != null && this.this$0.result.length() > 0) {
                    String audio2;
                    int vmode = this.this$0.getVoiceOption();
                    if (vmode < 3) {
                        this.this$0.showMessage(this.this$0.result, false);
                    } else {
                        this.this$0.showMessage(this.this$0.result, true);
                    }
                    MatchBoard mb = this.this$0.topui.getMatchBoard();
                    if (vmode < 3) {
                        if (mb != null) {
                            mb.setMTMatch(this.this$0.result, "ChatGPT", "AI");
                        }
                        this.this$0.setAutotext(this.this$0.result);
                        if (AppPreferences.autoTransferMT.equals("ChatGPT")) {
                            this.this$0.applyResult(this.this$0.result, true);
                        }
                    }
                    if (AppPreferences.ttsSpeak == 3 && (audio2 = this.this$0.chatGPTAPI.getAudioData()) != null) {
                        this.this$0.playAIResponse(audio2);
                    }
                }
            }
        };
        worker.execute();
    }

    private void setAutotext(String entry) {
        Prompter auto = this.sourceview.getPrompter();
        if (auto != null) {
            auto.getMTPhrases(entry);
        }
    }

    private String getGlossaryPrompt() {
        GlossaryResource gr;
        StringBuffer sb = new StringBuffer();
        if (AppPreferences.chatGPTGlossary.length() > 0 && !AppPreferences.chatGPTGlossary.equals("None") && (gr = this.topui.getResourceView().getGlossary(AppPreferences.chatGPTGlossary)) != null) {
            Set targetSet = gr.getTargetSet();
            for (String next : targetSet) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("\"");
                sb.append(next);
                sb.append("\"");
            }
        }
        return sb.toString();
    }

    private String getContextForPrompt(String prompt) {
        String s;
        if (prompt.indexOf("{target}") != -1) {
            JTextPane targetPane = this.topui.getTargetPane();
            s = targetPane.getText();
            if (s.trim().length() == 0) {
                JTextPane sourcePane = this.topui.getSourcePane();
                s = sourcePane.getText();
            }
        } else {
            JTextPane sourcePane = this.topui.getSourcePane();
            s = sourcePane.getText();
        }
        if (s != null && s.length() > 0) {
            s = XMLHelper.parseTags(s);
            s = "In the following context:\n" + s;
            return s;
        }
        return null;
    }

    private String getSelectionContext() {
        String s = null;
        if (AppPreferences.selectionRecordingContext) {
            s = this.topui.getSourceView().getRecordedSelectionContext();
        }
        if (s != null && s.length() > 0) {
            s = "In the following context:\n" + s;
            return s;
        }
        return null;
    }

    private String getPrompt(boolean source, boolean target) {
        String c = this.chatPane.getSelectedText();
        if (c != null) {
            return c;
        }
        if (LanguageCodes.sourceLanguage == null) {
            LanguageCodes.setSourceLanguage();
        }
        if (LanguageCodes.targetLanguage == null) {
            LanguageCodes.setTargetLanguage();
        }
        JTextPane sourcePane = this.topui.getSourcePane();
        JTextPane targetPane = this.topui.getTargetPane();
        String s = sourcePane.getSelectedText();
        String t = targetPane.getSelectedText();
        StringBuffer sb = new StringBuffer();
        if (source && target) {
            if (s == null) {
                s = sourcePane.getText();
            }
            if (s.trim().length() > 0) {
                sb.append("\n" + LanguageCodes.sourceLanguage + " text:\n");
                sb.append(s);
            }
            if (t == null) {
                t = targetPane.getText();
            }
            if (t.trim().length() > 0) {
                sb.append("\n" + LanguageCodes.targetLanguage + " text:\n");
                sb.append(t);
            }
        } else if (source) {
            if (s == null) {
                s = sourcePane.getText();
            }
            if (s.trim().length() > 0) {
                sb.append(s);
            }
        } else if (target) {
            if (t == null) {
                t = targetPane.getText();
            }
            if (t.trim().length() > 0) {
                sb.append(t);
            }
        } else {
            s = sourcePane.getText();
            if (s.trim().length() > 0) {
                sb.append(s);
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private String getButtonTitle(String s, String def) {
        String t;
        int j = -1;
        int k = s.indexOf("*");
        StringBuilder sb = new StringBuilder();
        while (k != -1) {
            if (k > 0 && j != -1) {
                t = s.substring(j, k);
                sb.append(t);
                j = -1;
            } else {
                j = k + 1;
            }
            k = s.indexOf("*", k + 1);
        }
        if (sb.length() == 0) {
            int i = s.indexOf(" ");
            t = i != -1 ? s.substring(0, i) : def;
        } else {
            char lower = sb.charAt(0);
            if (Character.isLowerCase(lower)) {
                char upper = Character.toUpperCase(lower);
                sb.setCharAt(0, upper);
            }
            t = sb.toString();
        }
        return t;
    }

    @Override
    public void search(String key, String rep) {
        this.translate(key, false, false);
    }

    public void close() {
        this.contexts.clear();
        LanguageCodes.sourceLanguage = null;
        LanguageCodes.targetLanguage = null;
        if (this.chatPane != null) {
            this.chatPane.setText("");
        }
    }

    @Override
    public void closeResource() {
        this.topui.getResourceView().setCTLinguist(-1);
        this.tview.removeTab(this.resourceName);
    }

    @Override
    public void minusResource() {
        Font font = this.chatPane.getFont();
        float size = font.getSize() - 1;
        font = font.deriveFont(size);
        this.chatPane.setFont(font);
        MutableAttributeSet attr = this.chatPane.getInputAttributes();
        StyleConstants.setFontFamily(attr, font.getFamily());
        StyleConstants.setFontSize(attr, font.getSize());
        StyledDocument doc = this.chatPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), attr, false);
    }

    @Override
    public void plusResource() {
        Font font = this.chatPane.getFont();
        float size = font.getSize() + 1;
        font = font.deriveFont(size);
        this.chatPane.setFont(font);
        MutableAttributeSet attr = this.chatPane.getInputAttributes();
        StyleConstants.setFontFamily(attr, font.getFamily());
        StyleConstants.setFontSize(attr, font.getSize());
        StyledDocument doc = this.chatPane.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), attr, false);
    }

    private String getErrorDescription() {
        String e = null;
        if (this.chatGPTAPI != null && (e = this.chatGPTAPI.getError()) != null) {
            return e;
        }
        if (this.claudeAPI != null && (e = this.claudeAPI.getError()) != null) {
            return e;
        }
        if (this.geminiAPI != null && (e = this.geminiAPI.getError()) != null) {
            return e;
        }
        if (this.mistralAPI != null && (e = this.mistralAPI.getError()) != null) {
            return e;
        }
        if (this.deepSeekAPI != null && (e = this.deepSeekAPI.getError()) != null) {
            return e;
        }
        if (this.grokAPI != null && (e = this.grokAPI.getError()) != null) {
            return e;
        }
        return e;
    }

    private int getVoiceOption() {
        return this.comboVoice.getSelectedIndex();
    }

    private void playAIResponse(final String audio) {
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ CTLinguist this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                try {
                    VoiceCapture.playAIResponse(audio);
                }
                catch (Exception ex) {
                    Logger.getLogger(CTLinguist.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
    }

    private void highlightRowBackground(Graphics g, JTextPane textPane) {
        try {
            int caretPos = textPane.getCaretPosition();
            Rectangle r = textPane.modelToView(caretPos);
            if (r != null) {
                g.setColor(Color.BLACK);
                g.fillRect(0, r.y, textPane.getWidth(), r.height);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

