/*
 * Decompiled with CFR 0.152.
 */
package translator.ai;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import translator.AppPreferences;
import translator.GlossaryResource;
import translator.MainView;
import translator.Options;
import translator.ResourceView;
import translator.ai.CTLinguist;
import translator.ui.UITools;
import translator.web.AmazonTTS;

final class CTLinguistOptions
extends JDialog
implements ActionListener {
    private MainView parent;
    private JComboBox modelsBox;
    private JComboBox modelsBox2;
    private JComboBox modelsBox3;
    private JComboBox modelsBox4;
    private JComboBox modelsBox5;
    private JComboBox modelsBox6;
    private JComboBox audioModelsBox;
    private JComboBox voiceBox;
    private JComboBox speakBox;
    private JComboBox defaultBox;
    private JComboBox glossaryBox;
    private JComboBox actionBox;
    private JComboBox activationBox;
    private JCheckBox pollyBox;
    private JCheckBox speechBox;
    private JCheckBox secondaryAIBox;
    private JTextField APIKeyField = null;
    private JTextField APIKeyField2 = null;
    private JTextField APIKeyField3 = null;
    private JTextField APIKeyField4 = null;
    private JTextField APIKeyField5 = null;
    private JTextField APIKeyField6 = null;
    private JTextField translateField = null;
    private JTextField checkField = null;
    private JTextField m1Field = null;
    private JTextField m2Field = null;
    private JTextField m3Field = null;
    private JTextField m4Field = null;
    private JTextField m5Field = null;
    private JTextField m6Field = null;
    private JTextField m7Field = null;
    private JTextField m8Field = null;
    private JTextField m9Field = null;
    private JTextField m10Field = null;
    private JTextPane systemArea;
    private JTextPane assistantArea;
    private JButton jb1;
    private JButton jb2;
    private JButton jb3;
    private CTLinguist linguist;
    private int tabIndex = 0;

    public CTLinguistOptions(Options options, CTLinguist gpt, int tabIndex) {
        super(options, "CT-L1 Linguist", true);
        this.linguist = gpt;
        this.tabIndex = tabIndex;
        this.parent = options.getMainView();
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.enableEvents(64L);
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CTLinguistOptions(MainView parent, CTLinguist chatGPT) {
        super(parent, "CT-L1 Linguist", true);
        this.parent = parent;
        this.linguist = chatGPT;
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.enableEvents(64L);
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        AmazonTTS polly;
        JLabel keyLabel = new JLabel("API key:");
        this.APIKeyField = new JTextField();
        this.APIKeyField.setPreferredSize(new Dimension(600, this.APIKeyField.getPreferredSize().height));
        this.APIKeyField.setText(AppPreferences.chatGPTAPIKey);
        this.APIKeyField.setMargin(new Insets(0, 2, 0, 0));
        this.APIKeyField.setCaretPosition(0);
        JLabel keyLabel2 = new JLabel("API key:");
        this.APIKeyField2 = new JTextField();
        this.APIKeyField2.setPreferredSize(new Dimension(600, this.APIKeyField2.getPreferredSize().height));
        this.APIKeyField2.setText(AppPreferences.claudeGPTAPIKey);
        this.APIKeyField2.setMargin(new Insets(0, 2, 0, 0));
        this.APIKeyField2.setCaretPosition(0);
        JLabel keyLabel3 = new JLabel("API key:");
        this.APIKeyField3 = new JTextField();
        this.APIKeyField3.setPreferredSize(new Dimension(600, this.APIKeyField3.getPreferredSize().height));
        this.APIKeyField3.setText(AppPreferences.geminiGPTAPIKey);
        this.APIKeyField3.setMargin(new Insets(0, 2, 0, 0));
        this.APIKeyField3.setCaretPosition(0);
        JLabel keyLabel4 = new JLabel("API key:");
        this.APIKeyField4 = new JTextField();
        this.APIKeyField4.setPreferredSize(new Dimension(600, this.APIKeyField4.getPreferredSize().height));
        this.APIKeyField4.setText(AppPreferences.mistralGPTAPIKey);
        this.APIKeyField4.setMargin(new Insets(0, 2, 0, 0));
        this.APIKeyField4.setCaretPosition(0);
        JLabel keyLabel5 = new JLabel("API key:");
        this.APIKeyField5 = new JTextField();
        this.APIKeyField5.setPreferredSize(new Dimension(600, this.APIKeyField5.getPreferredSize().height));
        this.APIKeyField5.setText(AppPreferences.deepSeekGPTAPIKey);
        this.APIKeyField5.setMargin(new Insets(0, 2, 0, 0));
        this.APIKeyField5.setCaretPosition(0);
        JLabel keyLabel6 = new JLabel("API key:");
        this.APIKeyField6 = new JTextField();
        this.APIKeyField6.setPreferredSize(new Dimension(600, this.APIKeyField6.getPreferredSize().height));
        this.APIKeyField6.setText(AppPreferences.grokGPTAPIKey);
        this.APIKeyField6.setMargin(new Insets(0, 2, 0, 0));
        this.APIKeyField6.setCaretPosition(0);
        String[] modelsArr = new String[]{"gpt-5-mini", "gpt-4o-mini", "gpt-4o", ""};
        JLabel modelLabel = new JLabel("Model:");
        this.modelsBox = new JComboBox<String>(modelsArr);
        this.modelsBox.setEditable(true);
        if (AppPreferences.chatGPTModel.length() > 0) {
            this.modelsBox.setSelectedItem(AppPreferences.chatGPTModel);
        }
        String[] modelsArr2 = new String[]{"claude-haiku-4-5-20251001", "claude-sonnet-4-5-20250929", "claude-opus-4-1-20250805", ""};
        JLabel modelLabel2 = new JLabel("Model:");
        this.modelsBox2 = new JComboBox<String>(modelsArr2);
        this.modelsBox2.setEditable(true);
        if (AppPreferences.claudeGPTModel.length() > 0) {
            this.modelsBox2.setSelectedItem(AppPreferences.claudeGPTModel);
        }
        String[] modelsArr3 = new String[]{"gemini-1.5-flash", "gemini-2.0-flash", ""};
        JLabel modelLabel3 = new JLabel("Model:");
        this.modelsBox3 = new JComboBox<String>(modelsArr3);
        this.modelsBox3.setEditable(true);
        if (AppPreferences.geminiGPTModel.length() > 0) {
            this.modelsBox3.setSelectedItem(AppPreferences.geminiGPTModel);
        }
        String[] modelsArr4 = new String[]{"mistral-small-latest", ""};
        JLabel modelLabel4 = new JLabel("Model:");
        this.modelsBox4 = new JComboBox<String>(modelsArr4);
        this.modelsBox4.setEditable(true);
        if (AppPreferences.mistralGPTModel.length() > 0) {
            this.modelsBox4.setSelectedItem(AppPreferences.mistralGPTModel);
        }
        String[] modelsArr5 = new String[]{"deepseek-chat", ""};
        JLabel modelLabel5 = new JLabel("Model:");
        this.modelsBox5 = new JComboBox<String>(modelsArr5);
        this.modelsBox5.setEditable(true);
        if (AppPreferences.deepSeekGPTModel.length() > 0) {
            this.modelsBox5.setSelectedItem(AppPreferences.deepSeekGPTModel);
        }
        String[] modelsArr6 = new String[]{"grok-4-fast-reasoning", ""};
        JLabel modelLabel6 = new JLabel("Model:");
        this.modelsBox6 = new JComboBox<String>(modelsArr6);
        this.modelsBox6.setEditable(true);
        if (AppPreferences.grokGPTModel.length() > 0) {
            this.modelsBox6.setSelectedItem(AppPreferences.grokGPTModel);
        }
        String[] modelsAudioArr = new String[]{"tts-1 optimized for speed", "tts-1-hd optimized for quality"};
        JLabel modelAudioLabel = new JLabel("Audio model:");
        this.audioModelsBox = new JComboBox<String>(modelsAudioArr);
        this.audioModelsBox.setEditable(true);
        this.audioModelsBox.setSelectedIndex(AppPreferences.chatGPTModelTTS);
        String[] actions = new String[]{"Manual", "Automatic on the next segment", "Automatic on selection"};
        JLabel actionLabel = new JLabel("Action:");
        this.actionBox = new JComboBox<String>(actions);
        this.actionBox.setSelectedIndex(AppPreferences.chatGPTAction);
        String[] activations = new String[]{"Always", "By empty segment", "Below exact match", "Below fuzzy match 90%", "Below fuzzy match 80%", "Below fuzzy match 70%"};
        JLabel activationLabel = new JLabel("Prompt activation:");
        this.activationBox = new JComboBox<String>(activations);
        this.activationBox.setSelectedIndex(AppPreferences.aiServiceActivation);
        String[] defaultMessages = new String[]{"Prompt 1", "Prompt 2", "Prompt 3", "Prompt 4", "Prompt 5", "Prompt 6", "Prompt 7", "Prompt 8", "Prompt 9", "Prompt 10", "Prompt 11", "Prompt 12"};
        JLabel defaultLabel = new JLabel("Automatic prompt:");
        this.defaultBox = new JComboBox<String>(defaultMessages);
        this.defaultBox.setSelectedIndex(AppPreferences.chatGPTDefaultPrompt);
        JLabel speakLabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPEAK") + ":");
        String[] sp = new String[]{"Source", "Target", "Selection", "Response"};
        this.speakBox = new JComboBox<String>(sp);
        if (AppPreferences.ttsSpeak < sp.length) {
            this.speakBox.setSelectedIndex(AppPreferences.ttsSpeak);
        }
        JLabel voicesLabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VOICE") + ":");
        String[] voices = new String[]{"Alloy", "Echo", "Fable", "Onyx", "Nova", "Shimmer"};
        this.voiceBox = new JComboBox<String>(voices);
        if (AppPreferences.chatGPTVoiceTTS < voices.length) {
            this.voiceBox.setSelectedIndex(AppPreferences.chatGPTVoiceTTS);
        }
        JLabel glossaryLabel = new JLabel("Glossary:");
        this.glossaryBox = new JComboBox();
        this.glossaryBox.addItem("None");
        if (this.parent != null) {
            List glossaries = this.parent.getResourceView().getGlossaries();
            for (int i = 0; i < glossaries.size(); ++i) {
                GlossaryResource get = (GlossaryResource)glossaries.get(i);
                String name = get.getName();
                if (name == null || name.length() <= 0) continue;
                this.glossaryBox.addItem(name);
            }
        }
        this.glossaryBox.setSelectedItem(AppPreferences.chatGPTGlossary);
        this.systemArea = new JTextPane();
        this.systemArea.setText(AppPreferences.chatGPTPromptSystem);
        this.systemArea.setFont(new Font(AppPreferences.pfontname, AppPreferences.pfontstyle, AppPreferences.pfontsize));
        this.systemArea.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane jScrollPane1 = new JScrollPane(this.systemArea);
        if (AppPreferences.RTLSource) {
            jScrollPane1.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        jScrollPane1.setPreferredSize(new Dimension(600, 80));
        this.assistantArea = new JTextPane();
        this.assistantArea.setText(AppPreferences.chatGPTPromptAssistant);
        this.assistantArea.setFont(new Font(AppPreferences.pfontname, AppPreferences.pfontstyle, AppPreferences.pfontsize));
        this.assistantArea.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane jScrollPane2 = new JScrollPane(this.assistantArea);
        if (AppPreferences.RTLSource) {
            jScrollPane2.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        jScrollPane2.setPreferredSize(new Dimension(600, 80));
        JLabel contextLabel1 = new JLabel("General context:");
        contextLabel1.setHorizontalAlignment(0);
        JLabel contextLabel2 = new JLabel("Specific context:");
        contextLabel2.setHorizontalAlignment(0);
        JLabel translateLabel = new JLabel("Prompt 1:");
        this.translateField = new JTextField(AppPreferences.chatGPTPromptTranslate);
        this.translateField.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.translateField.setMargin(new Insets(0, 2, 0, 0));
        this.translateField.setCaretPosition(0);
        JLabel checkLabel = new JLabel("Prompt 2:");
        this.checkField = new JTextField(AppPreferences.chatGPTPromptCheck);
        this.checkField.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.checkField.setMargin(new Insets(0, 2, 0, 0));
        this.checkField.setCaretPosition(0);
        JLabel m1Label = new JLabel("Prompt 3:");
        this.m1Field = new JTextField(AppPreferences.chatGPTPromptM1);
        this.m1Field.setPreferredSize(new Dimension(600, this.APIKeyField.getPreferredSize().height));
        this.m1Field.setMargin(new Insets(0, 2, 0, 0));
        this.m1Field.setCaretPosition(0);
        JLabel m2Label = new JLabel("Prompt 4:");
        this.m2Field = new JTextField(AppPreferences.chatGPTPromptM2);
        this.m2Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m2Field.setMargin(new Insets(0, 2, 0, 0));
        this.m2Field.setCaretPosition(0);
        JLabel m3Label = new JLabel("Prompt 5:");
        this.m3Field = new JTextField(AppPreferences.chatGPTPromptM3);
        this.m3Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m3Field.setMargin(new Insets(0, 2, 0, 0));
        this.m3Field.setCaretPosition(0);
        JLabel m4Label = new JLabel("Prompt 6:");
        this.m4Field = new JTextField(AppPreferences.chatGPTPromptM4);
        this.m4Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m4Field.setMargin(new Insets(0, 2, 0, 0));
        this.m4Field.setCaretPosition(0);
        JLabel m5Label = new JLabel("Prompt 7:");
        this.m5Field = new JTextField(AppPreferences.chatGPTPromptM5);
        this.m5Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m5Field.setMargin(new Insets(0, 2, 0, 0));
        this.m5Field.setCaretPosition(0);
        JLabel m6Label = new JLabel("Prompt 8:");
        this.m6Field = new JTextField(AppPreferences.chatGPTPromptM6);
        this.m6Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m6Field.setMargin(new Insets(0, 2, 0, 0));
        this.m6Field.setCaretPosition(0);
        JLabel m7Label = new JLabel("Prompt 9:");
        this.m7Field = new JTextField(AppPreferences.chatGPTPromptM7);
        this.m7Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m7Field.setMargin(new Insets(0, 2, 0, 0));
        this.m7Field.setCaretPosition(0);
        JLabel m8Label = new JLabel("Prompt 10:");
        this.m8Field = new JTextField(AppPreferences.chatGPTPromptM8);
        this.m8Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m8Field.setMargin(new Insets(0, 2, 0, 0));
        this.m8Field.setCaretPosition(0);
        JLabel m9Label = new JLabel("Prompt 11:");
        this.m9Field = new JTextField(AppPreferences.chatGPTPromptM9);
        this.m9Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m9Field.setMargin(new Insets(0, 2, 0, 0));
        this.m9Field.setCaretPosition(0);
        JLabel m10Label = new JLabel("Prompt 12:");
        this.m10Field = new JTextField(AppPreferences.chatGPTPromptM10);
        this.m10Field.setPreferredSize(new Dimension(800, this.APIKeyField.getPreferredSize().height));
        this.m10Field.setMargin(new Insets(0, 2, 0, 0));
        this.m10Field.setCaretPosition(0);
        JCheckBox transferBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC TRANSFER TO TARGET SEGMENTS"));
        if (AppPreferences.autoTransferMT.equals(this.linguist.getName())) {
            transferBox.setSelected(true);
        }
        transferBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.autoTransferMT = CTLinguistOptions.this.linguist.getName();
                } else if (e.getStateChange() == 2) {
                    AppPreferences.autoTransferMT = "";
                }
            }
        });
        String m = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AI-GENERATED VOICE");
        this.speechBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPEAK") + " " + m + " (ChatGPT)");
        if (AppPreferences.chatGPTSpeak == 1) {
            this.speechBox.setSelected(true);
        }
        this.secondaryAIBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INTEGRATE SECONDARY AI SERVICES WITH THE MATCHBOARD"));
        this.secondaryAIBox.setSelected(AppPreferences.integrateALLAIs);
        int rows = 8;
        if (this.parent != null && (polly = this.parent.getResourceView().getAmazonTTSService()) != null) {
            this.pollyBox = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPEAK THROUGH AMAZON POLLY"));
            if (AppPreferences.chatGPTSpeak == 0) {
                this.pollyBox.setSelected(true);
            }
            ++rows;
        }
        JPanel integrationPanel = new JPanel();
        integrationPanel.setBorder(new EmptyBorder(10, 20, 0, 5));
        integrationPanel.setLayout(new SpringLayout());
        JPanel APIPanel1 = new JPanel();
        APIPanel1.setBorder(new EmptyBorder(10, 20, 0, 5));
        APIPanel1.setLayout(new SpringLayout());
        JPanel APIPanel2 = new JPanel();
        APIPanel2.setBorder(new EmptyBorder(10, 20, 0, 5));
        APIPanel2.setLayout(new SpringLayout());
        JPanel APIPanel3 = new JPanel();
        APIPanel3.setBorder(new EmptyBorder(10, 20, 0, 5));
        APIPanel3.setLayout(new SpringLayout());
        JPanel APIPanel4 = new JPanel();
        APIPanel4.setBorder(new EmptyBorder(10, 20, 0, 5));
        APIPanel4.setLayout(new SpringLayout());
        JPanel APIPanel5 = new JPanel();
        APIPanel5.setBorder(new EmptyBorder(10, 20, 0, 5));
        APIPanel5.setLayout(new SpringLayout());
        JPanel APIPanel6 = new JPanel();
        APIPanel6.setBorder(new EmptyBorder(10, 20, 0, 5));
        APIPanel6.setLayout(new SpringLayout());
        JPanel promptsPanel = new JPanel();
        promptsPanel.setBorder(new EmptyBorder(10, 20, 0, 5));
        promptsPanel.setLayout(new SpringLayout());
        JPanel topPanel1 = new JPanel();
        topPanel1.setLayout(new BorderLayout());
        topPanel1.add((Component)integrationPanel, "North");
        JPanel topPanel2 = new JPanel();
        topPanel2.setLayout(new BorderLayout());
        topPanel2.add((Component)APIPanel1, "North");
        JPanel topPanel3 = new JPanel();
        topPanel3.setLayout(new BorderLayout());
        topPanel3.add((Component)APIPanel2, "North");
        JPanel topPanel4 = new JPanel();
        topPanel4.setLayout(new BorderLayout());
        topPanel4.add((Component)APIPanel3, "North");
        JPanel topPanel5 = new JPanel();
        topPanel5.setLayout(new BorderLayout());
        topPanel5.add((Component)APIPanel4, "North");
        JPanel topPanel6 = new JPanel();
        topPanel6.setLayout(new BorderLayout());
        topPanel6.add((Component)APIPanel5, "North");
        JPanel topPanel7 = new JPanel();
        topPanel7.setLayout(new BorderLayout());
        topPanel7.add((Component)APIPanel6, "North");
        APIPanel1.add(keyLabel);
        APIPanel1.add(this.APIKeyField);
        APIPanel1.add(modelLabel);
        APIPanel1.add(this.modelsBox);
        APIPanel1.add(modelAudioLabel);
        APIPanel1.add(this.audioModelsBox);
        APIPanel1.add(voicesLabel);
        APIPanel1.add(this.voiceBox);
        APIPanel2.add(keyLabel2);
        APIPanel2.add(this.APIKeyField2);
        APIPanel2.add(modelLabel2);
        APIPanel2.add(this.modelsBox2);
        APIPanel3.add(keyLabel3);
        APIPanel3.add(this.APIKeyField3);
        APIPanel3.add(modelLabel3);
        APIPanel3.add(this.modelsBox3);
        APIPanel4.add(keyLabel4);
        APIPanel4.add(this.APIKeyField4);
        APIPanel4.add(modelLabel4);
        APIPanel4.add(this.modelsBox4);
        APIPanel5.add(keyLabel5);
        APIPanel5.add(this.APIKeyField5);
        APIPanel5.add(modelLabel5);
        APIPanel5.add(this.modelsBox5);
        APIPanel6.add(keyLabel6);
        APIPanel6.add(this.APIKeyField6);
        APIPanel6.add(modelLabel6);
        APIPanel6.add(this.modelsBox6);
        integrationPanel.add(actionLabel);
        integrationPanel.add(this.actionBox);
        integrationPanel.add(activationLabel);
        integrationPanel.add(this.activationBox);
        integrationPanel.add(defaultLabel);
        integrationPanel.add(this.defaultBox);
        promptsPanel.add(contextLabel1);
        promptsPanel.add(jScrollPane1);
        promptsPanel.add(contextLabel2);
        promptsPanel.add(jScrollPane2);
        promptsPanel.add(translateLabel);
        promptsPanel.add(this.translateField);
        promptsPanel.add(checkLabel);
        promptsPanel.add(this.checkField);
        promptsPanel.add(m1Label);
        promptsPanel.add(this.m1Field);
        promptsPanel.add(m2Label);
        promptsPanel.add(this.m2Field);
        promptsPanel.add(m3Label);
        promptsPanel.add(this.m3Field);
        promptsPanel.add(m4Label);
        promptsPanel.add(this.m4Field);
        promptsPanel.add(m5Label);
        promptsPanel.add(this.m5Field);
        promptsPanel.add(m6Label);
        promptsPanel.add(this.m6Field);
        promptsPanel.add(m7Label);
        promptsPanel.add(this.m7Field);
        promptsPanel.add(m8Label);
        promptsPanel.add(this.m8Field);
        promptsPanel.add(m9Label);
        promptsPanel.add(this.m9Field);
        promptsPanel.add(m10Label);
        promptsPanel.add(this.m10Field);
        integrationPanel.add(glossaryLabel);
        integrationPanel.add(this.glossaryBox);
        integrationPanel.add(speakLabel);
        integrationPanel.add(this.speakBox);
        integrationPanel.add(new JLabel(""));
        integrationPanel.add(this.speechBox);
        integrationPanel.add(new JLabel(""));
        integrationPanel.add(this.secondaryAIBox);
        if (this.pollyBox != null) {
            integrationPanel.add(new JLabel(""));
            integrationPanel.add(this.pollyBox);
        }
        integrationPanel.add(new JLabel(""));
        integrationPanel.add(transferBox);
        UITools.makeCompactGrid(integrationPanel, rows, 2, 0, 0, 10, 5);
        UITools.makeCompactGrid(promptsPanel, 14, 2, 0, 0, 10, 5);
        UITools.makeCompactGrid(APIPanel1, 4, 2, 0, 0, 10, 5);
        UITools.makeCompactGrid(APIPanel2, 2, 2, 0, 0, 10, 5);
        UITools.makeCompactGrid(APIPanel3, 2, 2, 0, 0, 10, 5);
        UITools.makeCompactGrid(APIPanel4, 2, 2, 0, 0, 10, 5);
        UITools.makeCompactGrid(APIPanel5, 2, 2, 0, 0, 10, 5);
        UITools.makeCompactGrid(APIPanel6, 2, 2, 0, 0, 10, 5);
        final JTabbedPane jTab = new JTabbedPane();
        jTab.addTab("Integration", topPanel1);
        jTab.addTab("Prompts", promptsPanel);
        jTab.addTab("ChatGPT API", topPanel2);
        jTab.addTab("Claude API", topPanel3);
        jTab.addTab("Gemini API", topPanel4);
        jTab.addTab("Mistral API", topPanel5);
        jTab.addTab("DeepSeek API", topPanel6);
        jTab.addTab("Grok API", topPanel7);
        jTab.setSelectedIndex(CTLinguist.selectedOptionsTab);
        jTab.addChangeListener(new ChangeListener(){
            final /* synthetic */ CTLinguistOptions this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    CTLinguist.selectedOptionsTab = jTab.getSelectedIndex();
                }
            }
        });
        JPanel southPanel = new JPanel(new FlowLayout(2));
        southPanel.setBorder(new EmptyBorder(5, 20, 5, 5));
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb3 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HELP"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        this.jb3.addActionListener(this);
        southPanel.add(this.jb1);
        southPanel.add(this.jb2);
        southPanel.add(this.jb3);
        this.add((Component)jTab, "Center");
        this.add((Component)southPanel, "South");
        jTab.setSelectedIndex(this.tabIndex);
        jTab.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CTLinguistOptions.this.jb1.doClick();
            }
        });
        jTab.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CTLinguistOptions.this.jb2.doClick();
            }
        });
        jTab.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        jTab.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb3) {
            try {
                String s = "https://cafetran.freshdesk.com/support/solutions/folders/6000242645";
                URI uri = new URI(s);
                this.parent.getResourceView();
                ResourceView.browse(uri);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(CTLinguistOptions.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            AppPreferences.grokGPTAPIKey = this.APIKeyField6.getText().trim();
            String mod = this.modelsBox6.getSelectedItem().toString();
            if (mod != null && mod.length() > 0) {
                AppPreferences.grokGPTModel = mod;
            }
            AppPreferences.deepSeekGPTAPIKey = this.APIKeyField5.getText().trim();
            mod = this.modelsBox5.getSelectedItem().toString();
            if (mod != null && mod.length() > 0) {
                AppPreferences.deepSeekGPTModel = mod;
            }
            AppPreferences.mistralGPTAPIKey = this.APIKeyField4.getText().trim();
            mod = this.modelsBox4.getSelectedItem().toString();
            if (mod != null && mod.length() > 0) {
                AppPreferences.mistralGPTModel = mod;
            }
            AppPreferences.geminiGPTAPIKey = this.APIKeyField3.getText().trim();
            mod = this.modelsBox3.getSelectedItem().toString();
            if (mod != null && mod.length() > 0) {
                AppPreferences.geminiGPTModel = mod;
            }
            AppPreferences.claudeGPTAPIKey = this.APIKeyField2.getText().trim();
            mod = this.modelsBox2.getSelectedItem().toString();
            if (mod != null && mod.length() > 0) {
                AppPreferences.claudeGPTModel = mod;
            }
            AppPreferences.chatGPTAPIKey = this.APIKeyField.getText().trim();
            mod = this.modelsBox.getSelectedItem().toString();
            if (mod != null && mod.length() > 0) {
                AppPreferences.chatGPTModel = mod;
            }
            AppPreferences.chatGPTModelTTS = this.audioModelsBox.getSelectedIndex();
            AppPreferences.chatGPTPromptTranslate = this.translateField.getText().trim();
            AppPreferences.chatGPTPromptCheck = this.checkField.getText().trim();
            AppPreferences.chatGPTPromptM1 = this.m1Field.getText().trim();
            AppPreferences.chatGPTPromptM2 = this.m2Field.getText().trim();
            AppPreferences.chatGPTPromptM3 = this.m3Field.getText().trim();
            AppPreferences.chatGPTPromptM4 = this.m4Field.getText().trim();
            AppPreferences.chatGPTPromptM5 = this.m5Field.getText().trim();
            AppPreferences.chatGPTPromptM6 = this.m6Field.getText().trim();
            AppPreferences.chatGPTPromptM7 = this.m7Field.getText().trim();
            AppPreferences.chatGPTPromptM8 = this.m8Field.getText().trim();
            AppPreferences.chatGPTPromptM9 = this.m9Field.getText().trim();
            AppPreferences.chatGPTPromptM10 = this.m10Field.getText().trim();
            AppPreferences.chatGPTPromptSystem = this.systemArea.getText().trim();
            AppPreferences.chatGPTPromptAssistant = this.assistantArea.getText().trim();
            AppPreferences.chatGPTDefaultPrompt = this.defaultBox.getSelectedIndex();
            AppPreferences.chatGPTGlossary = this.glossaryBox.getSelectedItem().toString();
            AppPreferences.chatGPTAction = this.actionBox.getSelectedIndex();
            AppPreferences.aiServiceActivation = this.activationBox.getSelectedIndex();
            AppPreferences.ttsSpeak = this.speakBox.getSelectedIndex();
            AppPreferences.chatGPTVoiceTTS = this.voiceBox.getSelectedIndex();
            AppPreferences.integrateALLAIs = this.secondaryAIBox.isSelected();
            AppPreferences.chatGPTDefaultContext = 0;
            AppPreferences.chatGPTSpeak = this.speechBox.isSelected() ? 1 : -1;
            if (this.pollyBox != null && this.pollyBox.isSelected()) {
                AppPreferences.chatGPTSpeak = 0;
            }
            this.linguist.setPrompts();
            this.linguist.setButtonsText();
            this.linguist.addAIServiceCheckBoxes();
            this.cancel();
        }
    }
}

