/*
 * Decompiled with CFR 0.152.
 */
package translator.ai;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.scene.media.AudioClip;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.json.JSONArray;
import translator.json.JSONObject;

class MistralAPI {
    private String SERVICE_URL = "https://api.mistral.ai/v1/chat/completions";
    private String TTS_URL = "https://api.openai.com/v1/audio/speech";
    public static int tokens = 0;
    private BufferedReader input;
    private InputStream audioInput;
    private FileOutputStream audioOutput;
    private AudioClip playSound;
    private File speechfile;
    private File tempSpeechDir;
    private Map audioPathsMap;
    private String APIKey = "";
    private int statusCode = -1;
    private String audioData;

    MistralAPI() {
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getAudioData() {
        return this.audioData;
    }

    public String speak(String base64, String prompt, int mode, LinkedHashMap<String, String> contexts, boolean audioOutput) throws Exception {
        String transcript;
        InputStream is;
        BufferedReader input;
        String output;
        JSONObject response;
        JSONArray jarr;
        JSONObject choiceObject;
        JSONObject messageObject;
        this.statusCode = -1;
        this.APIKey = AppPreferences.chatGPTAPIKey;
        if (this.APIKey == null || this.APIKey.length() == 0) {
            throw new RuntimeException("Please set ChatGPT API key");
        }
        this.audioData = null;
        base64 = JSONObject.quote(base64);
        String p = "";
        if (prompt != null) {
            p = JSONObject.quote(prompt);
            p = "{ \"type\": \"text\", \"text\": " + p + " },";
        }
        StringBuilder context = new StringBuilder();
        String systemContext = "";
        if (AppPreferences.chatGPTPromptSystem.length() > 0) {
            String s = AppPreferences.chatGPTPromptSystem.replace("{source}", LanguageCodes.sourceLanguage);
            systemContext = s.replace("{target}", LanguageCodes.targetLanguage);
            context.append(systemContext);
            systemContext = JSONObject.quote(systemContext);
        }
        String assistantContext = "";
        if (AppPreferences.chatGPTPromptAssistant.length() > 0 && mode == 0) {
            String s = AppPreferences.chatGPTPromptAssistant.replace("{source}", LanguageCodes.sourceLanguage);
            assistantContext = s.replace("{target}", LanguageCodes.targetLanguage);
            if (context.length() > 0) {
                context.append("\n");
            }
            context.append(assistantContext);
            assistantContext = JSONObject.quote(assistantContext);
        }
        StringBuilder roles = new StringBuilder();
        if (mode == 3 && contexts != null) {
            for (Map.Entry<String, String> entry : contexts.entrySet()) {
                String u = entry.getKey();
                if (!u.startsWith("#")) continue;
                String a2 = entry.getValue();
                a2 = JSONObject.quote(a2);
                roles.append(", {\"role\": \"assistant\", \"content\": " + a2 + "}");
            }
        } else if (mode == 0 && context.length() > 0) {
            String a3 = JSONObject.quote(context.toString());
            roles.append(", {\"role\": \"assistant\", \"content\": " + a3 + "}");
        } else if (mode == 1) {
            String s = "Please change the user's text content as specified in the provided input audio. Respond with the changed text only. Don't say what you have done to the text.";
            String a4 = JSONObject.quote(s);
            roles.append(", {\"role\": \"assistant\", \"content\": " + a4 + "}");
        }
        String modality = audioOutput ? "\"modalities\": [\"text\", \"audio\"],\"audio\": { \"voice\": \"shimmer\", \"format\": \"wav\" }," : "\"modalities\": [\"text\"],";
        String s = "{\"model\": \"gpt-4o-mini-audio-preview\"," + modality + "\"messages\": [{\"role\": \"user\",\"content\": [" + p + "{ \"type\": \"input_audio\", \"input_audio\": { \"data\": " + base64 + ", \"format\": \"wav\" }}]}" + roles.toString() + "]}";
        HttpURLConnection con = (HttpURLConnection)new URL(this.SERVICE_URL).openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", "Bearer " + this.APIKey);
        con.setDoOutput(true);
        con.getOutputStream().write(s.getBytes("UTF-8"));
        this.statusCode = con.getResponseCode();
        String enc = con.getContentEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        if ((messageObject = (choiceObject = (jarr = (response = new JSONObject(output = (input = new BufferedReader(new InputStreamReader(is = con.getInputStream(), enc))).lines().reduce((a, b) -> a + b).get())).getJSONArray("choices")).getJSONObject(0)).getJSONObject("message")).has("audio")) {
            String data;
            JSONObject audioObject = messageObject.getJSONObject("audio");
            if (audioObject.has("data") && (data = audioObject.getString("data")) != null) {
                this.audioData = data;
            }
            transcript = audioObject.getString("transcript");
        } else {
            transcript = messageObject.getString("content");
        }
        return transcript;
    }

    public String chat(String text, String terms, boolean chatMode, LinkedHashMap<String, String> contexts) throws Exception {
        this.statusCode = -1;
        text = JSONObject.quote(text);
        StringBuilder context = new StringBuilder();
        String systemContext = "";
        if (AppPreferences.chatGPTPromptSystem.length() > 0) {
            String s = AppPreferences.chatGPTPromptSystem.replace("{source}", LanguageCodes.sourceLanguage);
            systemContext = s.replace("{target}", LanguageCodes.targetLanguage);
            context.append(systemContext);
        }
        String assistantContext = "";
        if (AppPreferences.chatGPTPromptAssistant.length() > 0 && !chatMode) {
            String s = AppPreferences.chatGPTPromptAssistant.replace("{source}", LanguageCodes.sourceLanguage);
            assistantContext = s.replace("{target}", LanguageCodes.targetLanguage);
            if (context.length() > 0) {
                context.append("\n");
            }
            context.append(assistantContext);
            if (terms != null && terms.length() > 0) {
                String t = "\n- Use the following phrases: " + terms;
                context.append(t);
            }
        }
        this.APIKey = AppPreferences.mistralGPTAPIKey;
        String model = AppPreferences.mistralGPTModel.length() > 0 ? AppPreferences.mistralGPTModel : "mistral-small-latest";
        if (this.APIKey == null || this.APIKey.length() == 0) {
            throw new RuntimeException("Please set Mistral API key");
        }
        StringBuilder sb = new StringBuilder("{\"model\": \"" + model + "\", \"messages\": [\n");
        if (contexts != null && chatMode) {
            for (Map.Entry<String, String> entry : contexts.entrySet()) {
                String u = entry.getKey();
                String a2 = entry.getValue();
                u = JSONObject.quote(u);
                a2 = JSONObject.quote(a2);
                sb.append("{\"role\": \"user\", \"content\": " + u + "},\n");
                sb.append("{\"role\": \"assistant\", \"content\": " + a2 + "},\n");
            }
        } else if (!chatMode && context.length() > 0) {
            String a3 = JSONObject.quote(context.toString());
            sb.append("{\"role\": \"assistant\", \"content\": " + a3 + "},\n");
        }
        sb.append("{\"role\": \"user\", \"content\": " + text + "}]}");
        String s = sb.toString();
        HttpURLConnection con = (HttpURLConnection)new URL(this.SERVICE_URL).openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", "Bearer " + this.APIKey);
        con.setDoOutput(true);
        con.getOutputStream().write(s.getBytes("UTF-8"));
        this.statusCode = con.getResponseCode();
        String enc = con.getContentEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        InputStream is = con.getInputStream();
        this.input = new BufferedReader(new InputStreamReader(is, enc));
        String outputString = this.input.lines().reduce((a, b) -> a + b).get();
        JSONObject response = new JSONObject(outputString);
        JSONArray jarr = response.getJSONArray("choices");
        JSONObject choiceObject = jarr.getJSONObject(0);
        JSONObject messageObject = choiceObject.getJSONObject("message");
        String content = messageObject.getString("content");
        return content;
    }

    private boolean speakCache(String s) {
        String uri;
        if (this.audioPathsMap == null) {
            this.audioPathsMap = new HashMap();
        }
        if ((uri = (String)this.audioPathsMap.get(s)) != null) {
            this.playSound = new AudioClip(uri);
            this.playSound.play();
            return true;
        }
        return false;
    }

    public void speak(String text, String voice, String model) throws Exception {
        String key;
        if (this.playSound != null && this.playSound.isPlaying()) {
            this.playSound.stop();
        }
        if (this.speakCache(key = text + voice + model)) {
            return;
        }
        text = JSONObject.quote(text);
        String s = "{\"model\": \"" + model + "\", \"input\": " + text + ", \"voice\": \"" + voice + "\"}";
        HttpURLConnection con = (HttpURLConnection)new URL(this.TTS_URL).openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", "Bearer " + AppPreferences.chatGPTAPIKey);
        con.setDoOutput(true);
        con.getOutputStream().write(s.getBytes("UTF-8"));
        int response = con.getResponseCode();
        if (response == 200) {
            int bytesRead;
            this.audioInput = con.getInputStream();
            if (this.tempSpeechDir == null) {
                this.tempSpeechDir = new File(AppPreferences.projectDirectory);
            }
            this.speechfile = File.createTempFile("speech", ".mp3", this.tempSpeechDir);
            this.speechfile.deleteOnExit();
            this.audioOutput = new FileOutputStream(this.speechfile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = this.audioInput.read(buffer)) != -1) {
                this.audioOutput.write(buffer, 0, bytesRead);
            }
        } else {
            String m = response == 429 ? "Connection error 429 - too many requests in a short period of time." : "Connection error " + response;
            System.out.println("Error: " + response);
            throw new Exception(m);
        }
        String uri = this.speechfile.toURI().toURL().toString();
        this.playSound = new AudioClip(uri);
        this.playSound.play();
        this.audioPathsMap.put(key, uri);
    }

    void closeConnection() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void closeAudioConnection() {
        try {
            if (this.audioInput != null) {
                this.audioInput.close();
            }
            if (this.audioOutput != null) {
                this.audioOutput.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getError() {
        String e = null;
        if (this.statusCode == 200) {
            return e;
        }
        if (this.statusCode != -1) {
            e = "ChatGPT API message: ";
        }
        if (this.statusCode == 400) {
            e = e + "there was an issue with the format or content of your request.";
        } else if (this.statusCode == 401) {
            e = e + "there\u2019s an issue with your API key.";
        } else if (this.statusCode == 403) {
            e = e + "your API key does not have permission to use the specified resource.";
        } else if (this.statusCode == 404) {
            e = e + "the requested resource was not found.";
        } else if (this.statusCode == 413) {
            e = e + "request exceeds the maximum allowed number of bytes";
        } else if (this.statusCode == 429) {
            e = e + "a rate limit has been hit.";
        } else if (this.statusCode == 500) {
            e = e + "an unexpected error has occurred internal to Mistral AI systems.";
        } else if (this.statusCode == 529) {
            e = e + "Mistral API is temporarily overloaded.";
        } else if (this.statusCode != -1) {
            e = "Mistral API error " + Integer.toString(this.statusCode);
        }
        return e;
    }
}

