/*
 * Decompiled with CFR 0.152.
 */
package translator.audio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;

public class VoiceCapture {
    private static final int SAMPLE_RATE = 16000;
    private static final int BUFFER_SIZE = 4096;
    private static final int SILENCE_THRESHOLD = 500;
    private static final int SILENCE_DURATION = 3000;
    private static TargetDataLine microphone;

    public static String captureMic() {
        try {
            AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                System.out.println("Microphone not supported!");
                return null;
            }
            microphone = (TargetDataLine)AudioSystem.getLine(info);
            microphone.open(format);
            microphone.start();
            System.out.println("Recording...");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            long lastSoundTime = System.currentTimeMillis();
            boolean soundDetected = false;
            while (true) {
                int bytesRead = microphone.read(buffer, 0, buffer.length);
                out.write(buffer, 0, bytesRead);
                if (VoiceCapture.isSilent(buffer)) {
                    if (System.currentTimeMillis() - lastSoundTime <= 3000L) continue;
                    break;
                }
                lastSoundTime = System.currentTimeMillis();
                soundDetected = true;
            }
            microphone.stop();
            microphone.close();
            System.out.println("Converting wave...");
            byte[] audioData = out.toByteArray();
            byte[] audioWav = VoiceCapture.convertPcmToWav(audioData, 16000, 16, 1);
            String base64Wav = Base64.getEncoder().encodeToString(audioWav);
            System.out.println("Done.");
            if (soundDetected) {
                return base64Wav;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isRunning() {
        return microphone != null && microphone.isRunning();
    }

    public static void stopCapture() {
        if (microphone != null && microphone.isRunning()) {
            microphone.stop();
            microphone.close();
            System.out.println("Stopped recording");
        }
    }

    private static void saveToWav(byte[] audioData, AudioFormat format, String filename) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(audioData);
        AudioInputStream audioInputStream = new AudioInputStream(bais, format, audioData.length / format.getFrameSize());
        File wavFile = new File(filename);
        AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, wavFile);
        audioInputStream.close();
        System.out.println("WAV file saved: " + wavFile.getAbsolutePath());
    }

    private static String encodeWavToBase64(String filename) throws IOException, Exception {
        byte[] wavBytes = Files.readAllBytes(Paths.get(filename, new String[0]));
        return Base64.getEncoder().encodeToString(wavBytes);
    }

    private static boolean isSilent(byte[] buffer) {
        int sum = 0;
        for (int i = 0; i < buffer.length; i += 2) {
            int sample = buffer[i + 1] << 8 | buffer[i] & 0xFF;
            sum += Math.abs(sample);
        }
        int average = sum / (buffer.length / 2);
        return average < 500;
    }

    private static void playWavBytes(byte[] audioBytes) throws Exception {
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 24000.0f, 16, 1, 2, 24000.0f, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
        line.open(format);
        line.start();
        VoiceCapture.applyFadeIn(audioBytes, 500);
        line.write(audioBytes, 0, audioBytes.length);
        line.drain();
        line.stop();
        line.close();
        System.out.println("Playback finished.");
    }

    private static void applyFadeIn(byte[] audio, int fadeSamples) {
        for (int i = 0; i < fadeSamples && i * 2 < audio.length; ++i) {
            float gain = (float)i / (float)fadeSamples;
            int index = i * 2;
            short sample = (short)(audio[index + 1] << 8 | audio[index] & 0xFF);
            sample = (short)((float)sample * gain);
            audio[index] = (byte)(sample & 0xFF);
            audio[index + 1] = (byte)(sample >> 8 & 0xFF);
        }
    }

    public static void playAIResponse(String base64Audio) throws Exception {
        byte[] audioBytes = Base64.getDecoder().decode(base64Audio.getBytes("UTF-8"));
        VoiceCapture.playWavBytes(audioBytes);
    }

    public static byte[] convertPcmToWav(byte[] pcmData, int sampleRate, int bitsPerSample, int channels) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        int byteRate = sampleRate * channels * (bitsPerSample / 8);
        int subChunk2Size = pcmData.length;
        int chunkSize = 36 + subChunk2Size;
        dataOutputStream.writeBytes("RIFF");
        dataOutputStream.writeInt(Integer.reverseBytes(chunkSize));
        dataOutputStream.writeBytes("WAVE");
        dataOutputStream.writeBytes("fmt ");
        dataOutputStream.writeInt(Integer.reverseBytes(16));
        dataOutputStream.writeShort(Short.reverseBytes((short)1));
        dataOutputStream.writeShort(Short.reverseBytes((short)channels));
        dataOutputStream.writeInt(Integer.reverseBytes(sampleRate));
        dataOutputStream.writeInt(Integer.reverseBytes(byteRate));
        dataOutputStream.writeShort(Short.reverseBytes((short)(channels * (bitsPerSample / 8))));
        dataOutputStream.writeShort(Short.reverseBytes((short)bitsPerSample));
        dataOutputStream.writeBytes("data");
        dataOutputStream.writeInt(Integer.reverseBytes(subChunk2Size));
        dataOutputStream.write(pcmData);
        dataOutputStream.flush();
        return outputStream.toByteArray();
    }
}

