/*
 * Decompiled with CFR 0.152.
 */
package translator.browser;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;

public class Helpers {
    public static <T> T doTask(final Callable<T> task) {
        final CountDownLatch barrier = new CountDownLatch(1);
        final AtomicReference resultRef = new AtomicReference();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    resultRef.set(task.call());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    barrier.countDown();
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
        while (barrier.getCount() > 0L) {
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return (T)resultRef.get();
    }

    public static void doAction(final Runnable action) {
        final CountDownLatch barrier = new CountDownLatch(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                finally {
                    barrier.countDown();
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
        while (barrier.getCount() > 0L) {
            try {
                barrier.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

