/*
 * Decompiled with CFR 0.152.
 */
package translator.browser;

import java.net.URI;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.html.HTMLTextAreaElement;

public class JScriptSearchExecutor {
    public static void executeFocusJScript(WebEngine engine) {
        HTMLTextAreaElement elem = (HTMLTextAreaElement)engine.getDocument().getElementsByTagName("textarea").item(0);
        if (elem != null) {
            elem.focus();
        }
    }

    public static void executeSearchJScript(URI uri, String word, WebEngine engine) {
        String host = uri.getHost();
        if (host != null) {
            if (host.equals("www.proz.com")) {
                String s = uri.toString();
                if (s.startsWith("https://www.proz.com/search/")) {
                    JScriptSearchExecutor.searchProzTerms(word, engine);
                } else if (s.startsWith("https://www.proz.com/kudoz/")) {
                    JScriptSearchExecutor.searchProzQuestions(word, engine);
                }
            } else if (host.startsWith("www.linguee.")) {
                JScriptSearchExecutor.searchLinguee(word, engine);
            } else if (host.equals("www.bing.com")) {
                JScriptSearchExecutor.searchBingTranslator(word, engine);
            } else if (host.equals("fanyi.youdao.com")) {
                JScriptSearchExecutor.searchYoudaoTranslator(word, engine);
            } else if (host.equals("www.tm-town.com")) {
                JScriptSearchExecutor.searchTMTown(word, engine);
            } else if (host.startsWith("www.euroglotonline.nl")) {
                JScriptSearchExecutor.searchEuroglot(word, engine);
            } else if (host.startsWith("languagetool.org")) {
                JScriptSearchExecutor.searchLanguageTool(word, engine);
            } else if (host.startsWith("mymemory.translated.net")) {
                JScriptSearchExecutor.searchMyMemory(word, engine);
            } else if (host.startsWith("www.modernmt.com")) {
                JScriptSearchExecutor.searchModernMT(word, engine);
            } else if (host.startsWith("translate.systran.net")) {
                JScriptSearchExecutor.searchSystran(word, engine);
            } else {
                JScriptSearchExecutor.searchDefault(word, engine);
            }
        }
    }

    private static void searchModernMT(String word, WebEngine engine) {
        word = word.replace("'", "\\'");
        word = word.replace("\n", "\\n");
        boolean i = false;
        HTMLTextAreaElement elem = (HTMLTextAreaElement)engine.getDocument().getElementsByTagName("textarea").item(0);
        elem.focus();
        elem.setValue(word);
    }

    private static void searchSystran(String word, WebEngine engine) {
        word = word.replace("'", "\\'");
        word = word.replace("\n", "\\n");
        boolean i = false;
        HTMLTextAreaElement elem = (HTMLTextAreaElement)engine.getDocument().getElementsByTagName("textarea").item(0);
        elem.focus();
        elem.setValue(word);
    }

    private static void searchMyMemory(String word, WebEngine engine) {
        Element elem;
        Document doc = engine.getDocument();
        if (doc != null && (elem = doc.getElementById("text")) != null) {
            elem.setAttribute("value", word);
            JSObject js = (JSObject)engine.executeScript("document.getElementById('search-button')");
            if (js != null) {
                js.call("click", new Object[0]);
            }
        }
    }

    private static void searchLanguageTool(String word, WebEngine engine) {
        word = word.replace("'", "\\'");
        word = word.replace("\n", "\\n");
        int i = 0;
        engine.executeScript("document.getElementsByClassName('lt-textarea__textarea welcome-editor__textarea')[" + i + "].innerHTML='" + word + "'");
    }

    private static void searchProzTerms(String word, WebEngine engine) {
        Element elem;
        Document doc = engine.getDocument();
        if (doc != null && (elem = doc.getElementById("term")) != null) {
            elem.setAttribute("value", word);
            JSObject js = (JSObject)engine.executeScript("document.getElementById('ksearch_submit')");
            if (js != null) {
                js.call("click", new Object[0]);
            }
        }
    }

    private static void searchProzQuestions(String word, WebEngine engine) {
        word = word.replace("'", "\\'");
        word = word.replace("\n", "\\n");
        int i = 0;
        int j = 2;
        engine.executeScript("document.getElementsByName('keyword_kudoz')[" + i + "].value='" + word + "'");
        JSObject js = (JSObject)engine.executeScript("document.getElementsByName('submit')[" + j + "]");
        if (js != null) {
            js.call("click", new Object[0]);
        }
    }

    private static void searchTMTown(String word, WebEngine engine) {
        Element elem;
        Document doc = engine.getDocument();
        if (doc != null && (elem = doc.getElementById("main_search_input")) != null) {
            elem.setAttribute("value", word);
            JSObject js = (JSObject)engine.executeScript("document.getElementById('search')");
            if (js != null) {
                js.call("submit", new Object[0]);
            }
        }
    }

    private static void searchGoogleTranslate(String word, WebEngine engine) {
        word = word.replace("'", "\\'");
        word = word.replace("\n", "\\n");
        int i = 0;
        HTMLTextAreaElement elem = (HTMLTextAreaElement)engine.getDocument().getElementsByTagName("textarea").item(0);
        if (elem != null) {
            elem.focus();
            elem.setValue(word);
            engine.executeScript("document.getElementsByTagName('textarea')[" + i + "].dispatchEvent(new Event('keypress'))");
            engine.executeScript("document.getElementsByTagName('textarea')[" + i + "].dispatchEvent(new Event('change'))");
        } else {
            engine.executeScript("document.execCommand('insertText', false, '" + word + "');");
        }
    }

    private static void searchBingTranslator(String word, WebEngine engine) {
        Document doc = engine.getDocument();
        if (doc != null) {
            word = word.replace("'", "\\'");
            word = word.replace("\n", "\\n");
            Element elem = doc.getElementById("tta_input_ta");
            if (elem != null) {
                elem.setTextContent(word);
                JSObject js = (JSObject)engine.executeScript("document.getElementById('tta_input_ta')");
                if (js != null) {
                    js.call("click", new Object[0]);
                }
            } else {
                JScriptSearchExecutor.searchDefault(word, engine);
            }
        }
    }

    private static void searchDeepL(String word, WebEngine engine) {
        word = word.replace("'", "\\'");
        word = word.replace("\n", "\\n");
        engine.executeScript("document.execCommand('insertText', false, '" + word + "');");
    }

    private static void searchLinguee(String word, WebEngine engine) {
        Element elem;
        Document doc = engine.getDocument();
        if (doc != null && (elem = doc.getElementById("queryinput")) != null) {
            elem.setAttribute("value", word);
            JSObject js = (JSObject)engine.executeScript("document.getElementsByTagName('button')[2]");
            if (js != null) {
                js.call("click", new Object[0]);
            }
        }
    }

    private static void searchEuroglot(String word, WebEngine engine) {
        Element elem;
        Document doc = engine.getDocument();
        if (doc != null && (elem = doc.getElementById("searchword")) != null) {
            elem.setAttribute("value", word);
            JSObject js = (JSObject)engine.executeScript("document.getElementById('searchbutton')");
            if (js != null) {
                js.call("click", new Object[0]);
            }
        }
    }

    private static void searchYoudaoTranslator(String word, WebEngine engine) {
        Document doc = engine.getDocument();
        if (doc != null) {
            Element elem = doc.getElementById("inputText");
            if (elem != null) {
                elem.setTextContent(word);
                JSObject js = (JSObject)engine.executeScript("document.getElementById('translateBtn')");
                if (js != null) {
                    js.call("click", new Object[0]);
                }
            } else {
                elem = doc.getElementById("inputOriginal");
                if (elem != null) {
                    elem.setTextContent(word);
                    JSObject js = (JSObject)engine.executeScript("document.getElementById('transMachine')");
                    if (js != null) {
                        js.call("click", new Object[0]);
                    }
                }
            }
        }
    }

    private static void searchDefault(String word, WebEngine engine) {
        word = word.replace("'", "\\'");
        word = word.replace("\n", "\\n");
        engine.executeScript("document.execCommand('insertText', false, '" + word + "');");
        engine.executeScript("document.execCommand('selectAll');");
    }
}

