/*
 * Decompiled with CFR 0.152.
 */
package translator.html;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.HTMLEditor;
import javax.swing.JPanel;

public class HTMLPane
extends JPanel {
    private HTMLEditor htmlEditor;
    private final JFXPanel jfxPanel = new JFXPanel();

    public HTMLPane() {
        super(new BorderLayout());
        String jfxversion = (String)System.getProperties().get("javafx.runtime.version");
        if (jfxversion != null) {
            String jfxver = jfxversion.substring(0, 3);
            int ifxversion = Integer.parseInt(jfxver = jfxver.replaceFirst("\\.", ""));
            if (ifxversion >= 22) {
                Platform.setImplicitExit((boolean)false);
            }
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HTMLPane.this.htmlEditor = new HTMLEditor();
                HTMLPane.this.htmlEditor.setPrefSize(500.0, 245.0);
                BorderPane pane = new BorderPane();
                Scene scene = new Scene((Parent)pane);
                pane.setCenter((Node)HTMLPane.this.htmlEditor);
                HTMLPane.this.jfxPanel.setScene(scene);
            }
        });
        KeyboardFocusManager kfm = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == HTMLPane.this.jfxPanel && e.getID() == 400 && e.getKeyChar() == '\n') {
                    e.setKeyChar('\r');
                }
                return false;
            }
        });
        this.add("Center", (Component)this.jfxPanel);
    }

    public void setText(String text) {
        this.htmlEditor.setHtmlText(text);
    }

    public String getText() {
        return this.htmlEditor.getHtmlText();
    }

    public HTMLEditor getHTMLEditor() {
        return this.htmlEditor;
    }

    public void disposeComponent() {
        this.jfxPanel.setScene(null);
    }
}

