/*
 * Decompiled with CFR 0.152.
 */
package translator.hunspell;

import java.util.List;
import translator.hunspell.Hunspell;

public class HunspellMain {
    private static void println(String msg) {
        System.err.println(msg);
    }

    private static void print(String msg) {
        System.err.print(msg);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 1 && args[0].equals("-libname")) {
                System.out.println(Hunspell.libName());
            } else {
                System.err.println("Loading Hunspell");
                String dir = "C:/workplace/Java/hunspell/danish/";
                Hunspell.Dictionary d = Hunspell.getInstance().getDictionary(dir + "daa_DK");
                System.err.println("Hunspell library and dictionary loaded");
                String[] words = new String[]{"Test", "Hest", "guest", "ombudsmandshat", "ombudsman", "ymerfest", "gr\u0102\u00b8ftegraver", "h\u0102\u00a6ngeplante", "garageport", "postbil", "huskop", "arne", "pladderballe", "Doctor", "Leo", "Lummerkrog", "Barnevognsbrand", "barnehovedbekl\u0102\u00a6dning", "ymer", "drys", "ymerdrys", "\u0102\u00a6sel", "m\u0102\u00a6lk", "\u0102\u00a6selm\u0102\u00a6lk"};
                for (int i = 0; i < words.length; ++i) {
                    String word = words[i];
                    if (d.misspelled(word)) {
                        List<String> suggestions = d.suggest(word);
                        HunspellMain.print("misspelled: " + word);
                        if (suggestions.isEmpty()) {
                            HunspellMain.print("\tNo suggestions.");
                        } else {
                            HunspellMain.print("\tTry:");
                            for (String s : suggestions) {
                                HunspellMain.print(" " + s);
                            }
                        }
                        HunspellMain.println("");
                        continue;
                    }
                    HunspellMain.println("ok: " + word);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HunspellMain.println("Failed: " + e);
        }
    }
}

