/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.TranslateClientBuilder;
import software.amazon.awssdk.services.translate.model.TranslateException;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.services.translate.model.TranslateTextResponse;
import translator.AppPreferences;

class AmazonTranslateAPI {
    private String accessKey = "";
    private TranslateClient translateClient;

    AmazonTranslateAPI() {
    }

    public void setAccessKey(String key) {
        this.accessKey = key;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    private void validate(String text) throws Exception {
    }

    public String translate(String text, String from, String to) throws Exception {
        if (this.accessKey.length() == 0) {
            throw new RuntimeException("Please set the Amazon Translate API access key");
        }
        if (AppPreferences.amazonAPISecretKey.length() == 0) {
            throw new RuntimeException("Please set the Amazon Translate API secret key");
        }
        if (AppPreferences.amazonAPIRegion.length() == 0) {
            AppPreferences.amazonAPIRegion = "eu-central-1";
        }
        if (this.translateClient == null) {
            AwsBasicCredentials awsBasicCreds = AwsBasicCredentials.create((String)this.accessKey, (String)AppPreferences.amazonAPISecretKey);
            StaticCredentialsProvider staticCreds = StaticCredentialsProvider.create((AwsCredentials)awsBasicCreds);
            Region region = Region.of((String)AppPreferences.amazonAPIRegion);
            this.translateClient = (TranslateClient)((TranslateClientBuilder)((TranslateClientBuilder)TranslateClient.builder().credentialsProvider((AwsCredentialsProvider)staticCreds)).region(region)).build();
        }
        String r = null;
        try {
            TranslateTextRequest textRequest = (TranslateTextRequest)TranslateTextRequest.builder().sourceLanguageCode(from).targetLanguageCode(to).text(text).build();
            TranslateTextResponse textResponse = this.translateClient.translateText(textRequest);
            r = textResponse.translatedText();
        }
        catch (TranslateException e) {
            if (this.translateClient != null) {
                this.translateClient.close();
                this.translateClient = null;
            }
            throw new Exception(e.getMessage());
        }
        return r;
    }

    public void close() {
        if (this.translateClient != null) {
            this.translateClient.close();
            this.translateClient = null;
        }
    }
}

