/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import software.amazon.awssdk.regions.Region;
import translator.AppPreferences;
import translator.MT;
import translator.MainView;
import translator.Options;
import translator.ui.UITools;

final class AmazonTranslateOptions
extends JDialog
implements ActionListener {
    private JComboBox mtSLangs;
    private JComboBox mtTLangs;
    private JComboBox regionsBox;
    private JCheckBox autoMT = null;
    private JTextField keyField = null;
    private JTextField keyField2 = null;
    private JButton jb1;
    private JButton jb2;
    private MT mt;
    private MainView topui;
    private TreeMap<String, String> regionsMap;

    AmazonTranslateOptions(Options parent, MT mt, String title) {
        super(parent, title, true);
        this.mt = mt;
        this.topui = parent.getMainView();
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.enableEvents(64L);
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        Object des;
        this.regionsMap = new TreeMap();
        List regions = Region.regions();
        int j = 0;
        Object selectedRegion = null;
        for (int i = 0; i < regions.size(); ++i) {
            Region reg = (Region)regions.get(i);
            if (reg.isGlobalRegion() || (des = reg.metadata().description()) == null) continue;
            String id = reg.id();
            this.regionsMap.put((String)des, id);
            if (id.equals(AppPreferences.amazonAPIRegion)) {
                selectedRegion = des;
            }
            ++j;
        }
        String[] regionsArr = new String[this.regionsMap.size()];
        int i = 0;
        des = this.regionsMap.keySet().iterator();
        while (des.hasNext()) {
            String str;
            regionsArr[i] = str = (String)des.next();
            ++i;
        }
        this.mtSLangs = new JComboBox<String>(this.mt.getLanguages());
        this.mtTLangs = new JComboBox<String>(this.mt.getLanguages());
        if (AppPreferences.mtSource8 != null && AppPreferences.mtSource8.length() > 0) {
            this.mtSLangs.setSelectedItem(AppPreferences.mtSource8);
        }
        if (AppPreferences.mtTarget8 != null && AppPreferences.mtTarget8.length() > 0) {
            this.mtTLangs.setSelectedItem(AppPreferences.mtTarget8);
        }
        this.autoMT = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC"));
        this.autoMT.setSelected(AppPreferences.autoMT8);
        JLabel keyLabel = new JLabel("API Access key:");
        this.keyField = new JTextField();
        this.keyField.setPreferredSize(new Dimension(600, this.keyField.getPreferredSize().height));
        this.keyField.setText(AppPreferences.amazonAPIAccessKey);
        this.keyField.setMargin(new Insets(0, 2, 0, 0));
        this.keyField.setCaretPosition(0);
        JLabel keyLabel2 = new JLabel("API Secret key:");
        this.keyField2 = new JTextField();
        this.keyField2.setPreferredSize(new Dimension(600, this.keyField.getPreferredSize().height));
        this.keyField2.setText(AppPreferences.amazonAPISecretKey);
        this.keyField2.setMargin(new Insets(0, 2, 0, 0));
        this.keyField2.setCaretPosition(0);
        JLabel regionLabel = new JLabel("Region:");
        this.regionsBox = new JComboBox<String>(regionsArr);
        this.regionsBox.setSelectedItem(selectedRegion);
        JPanel panel1 = new JPanel();
        panel1.setBorder(new EmptyBorder(5, 5, 0, 5));
        panel1.setOpaque(false);
        panel1.setLayout(new FlowLayout());
        panel1.add(this.mtSLangs);
        panel1.add(this.mtTLangs);
        panel1.add(this.autoMT);
        JPanel panel2 = new JPanel();
        panel2.setBorder(new EmptyBorder(5, 5, 0, 5));
        panel2.setLayout(new SpringLayout());
        panel2.setOpaque(false);
        panel2.add(keyLabel);
        panel2.add(this.keyField);
        panel2.add(keyLabel2);
        panel2.add(this.keyField2);
        panel2.add(regionLabel);
        panel2.add(this.regionsBox);
        UITools.makeCompactGrid(panel2, 3, 2, 0, 0, 10, 5);
        JPanel panel3 = new JPanel(new FlowLayout(2));
        panel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        panel3.add(this.jb1);
        panel3.add(this.jb2);
        this.add((Component)panel1, "North");
        this.add((Component)panel2, "Center");
        this.add((Component)panel3, "South");
        panel3.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmazonTranslateOptions.this.jb1.doClick();
            }
        });
        panel3.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AmazonTranslateOptions.this.jb2.doClick();
            }
        });
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            MT mtrans;
            String code;
            String reg;
            Object ob = this.mtSLangs.getSelectedItem();
            if (ob != null) {
                AppPreferences.mtSource8 = ob.toString();
            }
            if ((ob = this.mtTLangs.getSelectedItem()) != null) {
                AppPreferences.mtTarget8 = ob.toString();
            }
            if ((reg = this.regionsBox.getSelectedItem().toString()) != null && (code = this.regionsMap.get(reg)) != null) {
                AppPreferences.amazonAPIRegion = code;
            }
            if ((mtrans = this.topui.getResourceView().getMT8()) != null) {
                mtrans.setLanguagePair(AppPreferences.mtSource8, AppPreferences.mtTarget8);
            }
            AppPreferences.amazonAPIAccessKey = this.keyField.getText().trim();
            AppPreferences.amazonAPISecretKey = this.keyField2.getText().trim();
            AppPreferences.autoMT8 = this.autoMT.isSelected();
            this.cancel();
        }
    }
}

