/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.MT;
import translator.MainView;
import translator.Options;

final class BingOptions
extends JDialog
implements ActionListener {
    private JComboBox mtSLangs;
    private JComboBox mtTLangs;
    private JCheckBox autoMT = null;
    private JTextField keyField = null;
    private JButton jb1;
    private JButton jb2;
    private MT mt;
    private MainView topui;

    BingOptions(Options parent, MT mt, String title) {
        super(parent, title, true);
        this.mt = mt;
        this.topui = parent.getMainView();
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.enableEvents(64L);
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.mtSLangs = new JComboBox<String>(this.mt.getLanguages());
        this.mtTLangs = new JComboBox<String>(this.mt.getLanguages());
        if (AppPreferences.mtSource2 != null && AppPreferences.mtSource2.length() > 0) {
            this.mtSLangs.setSelectedItem(AppPreferences.mtSource2);
        }
        if (AppPreferences.mtTarget2 != null && AppPreferences.mtTarget2.length() > 0) {
            this.mtTLangs.setSelectedItem(AppPreferences.mtTarget2);
        }
        this.autoMT = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC"));
        this.autoMT.setSelected(AppPreferences.autoMT2);
        JLabel keylabeL = new JLabel("API key:");
        this.keyField = new JTextField();
        this.keyField.setPreferredSize(new Dimension(600, this.keyField.getPreferredSize().height));
        this.keyField.setText(AppPreferences.bingAPIKey);
        this.keyField.setMargin(new Insets(0, 2, 0, 0));
        this.keyField.setCaretPosition(0);
        JPanel panel1 = new JPanel();
        panel1.setBorder(new EmptyBorder(5, 5, 0, 5));
        panel1.setOpaque(false);
        panel1.setLayout(new FlowLayout());
        panel1.add(this.mtSLangs);
        panel1.add(this.mtTLangs);
        panel1.add(this.autoMT);
        JPanel panel2 = new JPanel();
        panel2.setBorder(new EmptyBorder(5, 5, 0, 5));
        panel2.setLayout(new FlowLayout(0));
        panel2.setOpaque(false);
        panel2.add(keylabeL);
        panel2.add(this.keyField);
        JPanel panel3 = new JPanel(new FlowLayout(2));
        panel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        panel3.add(this.jb1);
        panel3.add(this.jb2);
        this.add((Component)panel1, "North");
        this.add((Component)panel2, "Center");
        this.add((Component)panel3, "South");
        panel3.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BingOptions.this.jb1.doClick();
            }
        });
        panel3.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BingOptions.this.jb2.doClick();
            }
        });
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            MT mtrans;
            Object ob = this.mtSLangs.getSelectedItem();
            if (ob != null) {
                AppPreferences.mtSource2 = ob.toString();
            }
            if ((ob = this.mtTLangs.getSelectedItem()) != null) {
                AppPreferences.mtTarget2 = ob.toString();
            }
            if ((mtrans = this.topui.getResourceView().getMT2()) != null) {
                mtrans.setLanguagePair(AppPreferences.mtSource2, AppPreferences.mtTarget2);
            }
            AppPreferences.bingAPIKey = this.keyField.getText().trim();
            AppPreferences.autoMT2 = this.autoMT.isSelected();
            this.cancel();
        }
    }
}

