/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import translator.AppPreferences;

class IBMWatsonAPI {
    private String apiKey;
    private String ENCODING = "UTF-8";

    IBMWatsonAPI() {
    }

    public void setKey(String pKey) {
        this.apiKey = pKey;
    }

    public String getKey() {
        return this.apiKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(URL url, String text, String from, String to) throws Exception {
        from = "\"" + from + "\"";
        to = "\"" + to + "\"";
        String body = "{\"text\": [\"" + text + "\"], \"source\":" + from + ", \"target\":" + to + "}";
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("Content-Type", "application/json");
        uc.setRequestProperty("charset", "utf-8");
        String userpass = "apikey:" + this.apiKey;
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes()));
        uc.setRequestProperty("Authorization", basicAuth);
        uc.setRequestMethod("POST");
        uc.setDoOutput(true);
        try {
            uc.getOutputStream().write(body.getBytes("UTF-8"));
            int responseCode = uc.getResponseCode();
            String result = this.readStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error from API: " + result);
            }
            String string = result;
            return string;
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
    }

    private String getResponseString(URL url, String text, String from, String to) throws Exception {
        try {
            String response = this.getResponse(url, text, from, to);
            return response;
        }
        catch (Exception ex) {
            throw new Exception("Connection error: " + ex.getMessage(), ex);
        }
    }

    private String readStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.ENCODING));
                while (null != (string = reader.readLine())) {
                    outputBuilder.append(string);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Connection error: " + ex.getMessage(), ex);
        }
        String r = outputBuilder.toString();
        r = r.replace("\\/", "/");
        return r;
    }

    private void validate(String text) throws Exception {
        if (this.apiKey != null && this.apiKey.length() < 16) {
            throw new RuntimeException("Please set the IBM Watson Language Translator key");
        }
    }

    public String translate(String text, String from, String to) throws Exception {
        this.validate(text);
        if (AppPreferences.watsonTranslatorURL == null || AppPreferences.watsonTranslatorURL.length() <= 0) {
            throw new Exception("Please provide the valid URL address in MT Preferences!");
        }
        String SERVICE_URL = AppPreferences.watsonTranslatorURL + "/v3/translate?version=2018-05-01";
        URL url = new URL(SERVICE_URL);
        String r = this.getResponseString(url, text, from, to);
        return r;
    }
}

