/*
 * Decompiled with CFR 0.152.
 */
package translator.player;

import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import translator.AppPreferences;

public class VideoControl
extends BorderPane {
    private MediaPlayer player;
    private MediaView mediaView;
    private final boolean repeat = false;
    private boolean stopRequest = false;
    private boolean atEnd = false;
    private Duration duration;
    private Slider timeSlider;
    private Label playTimeLabel;
    private Slider volumeSlider;
    private HBox mediaBar;

    public VideoControl(final MediaPlayer mp) {
        String cstyle = "-fx-background-color: black; -fx-font-size: " + Integer.toString(AppPreferences.toolBarButtonsFontSize - 2) + "pt; ";
        this.player = mp;
        this.setStyle(cstyle);
        this.mediaView = new MediaView(mp);
        this.mediaView.setPreserveRatio(true);
        this.mediaView.setSmooth(true);
        Pane mvPane = new Pane();
        mvPane.getChildren().add((Object)this.mediaView);
        mvPane.setStyle("-fx-background-color: black;");
        this.mediaView.fitWidthProperty().bind((ObservableValue)mvPane.widthProperty());
        this.mediaView.fitHeightProperty().bind((ObservableValue)mvPane.heightProperty());
        this.setCenter((Node)mvPane);
        this.mediaBar = new HBox();
        this.mediaBar.setAlignment(Pos.CENTER);
        this.mediaBar.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        BorderPane.setAlignment((Node)this.mediaBar, (Pos)Pos.CENTER);
        final Button playButton = new Button("\u25b6");
        playButton.setStyle("-fx-pref-width: 50px; -fx-background-color: black; -fx-text-fill: white; -fx-font-weight: bold;");
        playButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){
            final /* synthetic */ VideoControl this$0;
            {
                this.this$0 = this$0;
            }

            public void handle(ActionEvent e) {
                MediaPlayer.Status status = mp.getStatus();
                if (status == MediaPlayer.Status.UNKNOWN || status == MediaPlayer.Status.HALTED) {
                    return;
                }
                if (status == MediaPlayer.Status.PAUSED || status == MediaPlayer.Status.READY || status == MediaPlayer.Status.STOPPED) {
                    if (this.this$0.atEnd) {
                        mp.seek(mp.getStartTime());
                        this.this$0.atEnd = false;
                    }
                    mp.play();
                } else {
                    mp.pause();
                }
            }
        });
        mp.currentTimeProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable ov) {
                VideoControl.this.updateTimeValues();
            }
        });
        mp.setOnPlaying(new Runnable(){
            final /* synthetic */ VideoControl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.stopRequest) {
                    mp.pause();
                    this.this$0.stopRequest = false;
                } else {
                    playButton.setText("||");
                }
            }
        });
        mp.setOnPaused(new Runnable(){
            final /* synthetic */ VideoControl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                playButton.setText("\u25b6");
            }
        });
        mp.setOnReady(new Runnable(){
            final /* synthetic */ VideoControl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.duration = mp.getMedia().getDuration();
                this.this$0.updateTimeValues();
            }
        });
        mp.setCycleCount(1);
        mp.setOnEndOfMedia(new Runnable(){
            final /* synthetic */ VideoControl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                playButton.setText("\u25b6");
                this.this$0.stopRequest = true;
                this.this$0.atEnd = true;
            }
        });
        this.mediaBar.getChildren().add((Object)playButton);
        Label spacer = new Label("   ");
        this.mediaBar.getChildren().add((Object)spacer);
        this.timeSlider = new Slider();
        HBox.setHgrow((Node)this.timeSlider, (Priority)Priority.ALWAYS);
        this.timeSlider.setMinWidth(50.0);
        this.timeSlider.setMaxWidth(Double.MAX_VALUE);
        this.timeSlider.valueProperty().addListener(new InvalidationListener(){
            final /* synthetic */ VideoControl this$0;
            {
                this.this$0 = this$0;
            }

            public void invalidated(Observable ov) {
                if (this.this$0.timeSlider.isValueChanging()) {
                    mp.seek(this.this$0.duration.multiply(this.this$0.timeSlider.getValue() / 100.0));
                }
            }
        });
        this.mediaBar.getChildren().add((Object)this.timeSlider);
        this.playTimeLabel = new Label();
        this.playTimeLabel.setStyle("-fx-text-fill: rgb(200, 200, 200);");
        this.playTimeLabel.setPrefWidth(150.0);
        this.playTimeLabel.setMinWidth(50.0);
        this.mediaBar.getChildren().add((Object)this.playTimeLabel);
        Label volumeLabel = new Label("Vol: ");
        volumeLabel.setStyle("-fx-text-fill: rgb(200, 200, 200);");
        this.mediaBar.getChildren().add((Object)volumeLabel);
        this.volumeSlider = new Slider();
        this.volumeSlider.setPrefWidth(70.0);
        this.volumeSlider.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.volumeSlider.setMinWidth(30.0);
        this.volumeSlider.valueProperty().addListener(new InvalidationListener(){
            final /* synthetic */ VideoControl this$0;
            {
                this.this$0 = this$0;
            }

            public void invalidated(Observable ov) {
                if (this.this$0.volumeSlider.isValueChanging()) {
                    mp.setVolume(this.this$0.volumeSlider.getValue() / 100.0);
                }
            }
        });
        this.mediaBar.getChildren().add((Object)this.volumeSlider);
        this.setBottom((Node)this.mediaBar);
    }

    private void updateTimeValues() {
        if (this.playTimeLabel != null && this.timeSlider != null && this.volumeSlider != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Duration currentTime = VideoControl.this.player.getCurrentTime();
                    VideoControl.this.playTimeLabel.setText(VideoControl.this.formatTimeValue(currentTime));
                    VideoControl.this.timeSlider.setDisable(VideoControl.this.duration.isUnknown());
                    if (!VideoControl.this.timeSlider.isDisabled() && VideoControl.this.duration.greaterThan(Duration.ZERO) && !VideoControl.this.timeSlider.isValueChanging()) {
                        VideoControl.this.timeSlider.setValue(currentTime.divide(VideoControl.this.duration).toMillis() * 100.0);
                    }
                    if (!VideoControl.this.volumeSlider.isValueChanging()) {
                        VideoControl.this.volumeSlider.setValue((double)((int)Math.round(VideoControl.this.player.getVolume() * 100.0)));
                    }
                }
            });
        }
    }

    private String formatTimeValue(Duration elapsedTime) {
        int intElapsedTime = (int)Math.floor(elapsedTime.toSeconds());
        int hours = intElapsedTime / 3600;
        if (hours > 0) {
            intElapsedTime -= hours * 60 * 60;
        }
        int minutes = intElapsedTime / 60;
        int seconds = intElapsedTime - hours * 60 * 60 - minutes * 60;
        if (this.duration.greaterThan(Duration.ZERO)) {
            int durationTime = (int)Math.floor(this.duration.toSeconds());
            int durationHours = durationTime / 3600;
            if (durationHours > 0) {
                durationTime -= durationHours * 60 * 60;
            }
            int durationMinutes = durationTime / 60;
            int durationSeconds = durationTime - durationHours * 60 * 60 - durationMinutes * 60;
            if (durationHours > 0) {
                return String.format("%d:%02d:%02d / %d:%02d:%02d", hours, minutes, seconds, durationHours, durationMinutes, durationSeconds);
            }
            return String.format("%02d:%02d / %02d:%02d", minutes, seconds, durationMinutes, durationSeconds);
        }
        if (hours > 0) {
            return String.format("%d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }
}

