/*
 * Decompiled with CFR 0.152.
 */
package translator.player;

import java.io.File;
import java.net.MalformedURLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.MainView;
import translator.MySwingWorker;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.TabView;
import translator.javafx.FX;
import translator.player.VideoPane;

public class VideoResourceFX
extends DefaultResource {
    private MainView topui;
    private TabView tview;
    private String infopath;
    private String path;
    private String resourceName;
    private MySwingWorker worker;
    private VideoPane videoPane;
    private String uid;

    public VideoResourceFX(File file, String name) {
        try {
            this.path = file.toURI().toURL().toExternalForm();
            this.uid = Integer.toString(ResourceView.uniqueResourceID++);
            this.infopath = null;
            this.resourceName = name != null ? name : file.getName();
        }
        catch (MalformedURLException ex) {
            JOptionPane.showMessageDialog(this.topui, ex.getMessage());
            Logger.getLogger(VideoResourceFX.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public VideoResourceFX(ResourceInfo ri) {
        this.uid = Integer.toString(ResourceView.uniqueResourceID++);
        this.path = ri.getResourceAddress();
        this.infopath = ri.getInfoPath();
        int i = this.infopath.lastIndexOf(AppPreferences.fs);
        if (i == -1) {
            i = this.infopath.lastIndexOf(47);
        }
        this.resourceName = i != -1 ? this.infopath.substring(i + 1, this.infopath.length() - 4) : this.path;
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.createHTMLTab();
    }

    @Override
    public void search(String okey, String rep) {
    }

    private void next() {
    }

    private void previous() {
    }

    @Override
    public void stopSearch() {
    }

    private void createHTMLTab() {
        if (this.path != null) {
            if (this.path.startsWith("www")) {
                this.path = "http://" + this.path;
            }
            if (this.path.startsWith("http") || this.path.startsWith("file:")) {
                this.videoPane = new VideoPane(this.path);
            }
        }
        this.videoPane.setName(this.uid);
        this.tview.addTab(this, this.resourceName, this.videoPane);
    }

    @Override
    public void newResource() {
    }

    @Override
    public void openResource() {
    }

    @Override
    public void saveResource() {
    }

    @Override
    public void saveAsResource() {
    }

    @Override
    public void closeResource() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
        if (this.infopath != null) {
            List loader = this.topui.getResourceLoader().getResourceLoaderList();
            loader.remove(this.infopath);
            this.topui.getProjectView().removeReference(this.infopath);
            this.topui.getResourceLoader().removeLastSessionResource(this.infopath);
        }
        this.topui.getResourceView().removeWebResource(this);
        if (FX.canImplicitExitSet) {
            this.tview.removeTab(this.uid, this.resourceName);
        }
        if (this.videoPane != null && FX.canImplicitExitSet) {
            this.videoPane.disposeComponent();
        }
    }

    @Override
    public void nextResource() {
        this.next();
    }

    @Override
    public void previousResource() {
        this.previous();
    }

    @Override
    public void plusResource() {
    }

    @Override
    public void minusResource() {
    }

    @Override
    public String getInfoPath() {
        return this.infopath;
    }

    @Override
    public String getLocation() {
        return this.resourceName;
    }

    public String getResourceAddress() {
        return this.path;
    }
}

