/*
 * Decompiled with CFR 0.152.
 */
package translator.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Segment;

class CTSegmentCache {
    private static CTSegmentCache sharedCache = new CTSegmentCache();
    private List<Segment> segments = new ArrayList<Segment>(11);

    public static CTSegmentCache getSharedInstance() {
        return sharedCache;
    }

    public static Segment getSharedSegment() {
        return CTSegmentCache.getSharedInstance().getSegment();
    }

    public static void releaseSharedSegment(Segment segment) {
        CTSegmentCache.getSharedInstance().releaseSegment(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment() {
        CTSegmentCache cTSegmentCache = this;
        synchronized (cTSegmentCache) {
            int size = this.segments.size();
            if (size > 0) {
                return this.segments.remove(size - 1);
            }
        }
        return new CachedSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSegment(Segment segment) {
        if (segment instanceof CachedSegment) {
            CTSegmentCache cTSegmentCache = this;
            synchronized (cTSegmentCache) {
                segment.array = null;
                segment.count = 0;
                this.segments.add(segment);
            }
        }
    }

    private static class CachedSegment
    extends Segment {
        private CachedSegment() {
        }
    }
}

