/*
 * Decompiled with CFR 0.152.
 */
package translator.text;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ProtectedDocument {
    private AbstractDocument doc;
    private Map<Position, Position> positions = new HashMap<Position, Position>();
    private boolean trackChanges;
    private JTextComponent textPane;

    public ProtectedDocument(JTextComponent component) {
        this.textPane = component;
        this.doc = (AbstractDocument)component.getDocument();
        this.doc.setDocumentFilter(new ProtectedDocumentFilter());
        component.setNavigationFilter(new ProtectedNavigationFilter(component));
    }

    public void removeProtection() {
        this.reset();
        this.doc.setDocumentFilter(null);
        this.textPane.setNavigationFilter(null);
    }

    public void trackChanges(boolean tc) {
        this.trackChanges = tc;
    }

    public void protect(int start, int end) {
        try {
            this.positions.put(this.doc.createPosition(start), this.doc.createPosition(end));
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
    }

    public void reset() {
        this.positions.clear();
    }

    class ProtectedDocumentFilter
    extends DocumentFilter {
        ProtectedDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String str, AttributeSet a) throws BadLocationException {
            if (this.isInsertProtected(offset)) {
                Toolkit.getDefaultToolkit().beep();
            } else if (ProtectedDocument.this.trackChanges) {
                Object ob;
                String n;
                int track = -1;
                StyledDocument doc = (StyledDocument)fb.getDocument();
                Element e = doc.getCharacterElement(offset);
                MutableAttributeSet attr = (MutableAttributeSet)e.getAttributes();
                if (attr != null && (n = (String)attr.getAttribute("track")) != null) {
                    if (n.equals("added")) {
                        track = 0;
                    } else if (n.equals("deleted")) {
                        track = 1;
                    }
                }
                if (a != null && (ob = a.getAttribute(StyleConstants.ComponentAttribute)) != null) {
                    JLabel label = (JLabel)ob;
                    if (track == -1) {
                        label.putClientProperty("track", "add");
                        String s = label.getText();
                        label.setText(s + "+");
                    } else if (track == 0) {
                        label.putClientProperty("track", "added");
                    } else if (track == 1) {
                        label.putClientProperty("track", "deleted");
                    }
                    super.insertString(fb, offset, str, a);
                    return;
                }
                if (track != -1) {
                    super.insertString(fb, offset, str, attr);
                    return;
                }
                Style style = doc.getStyle("Add");
                super.insertString(fb, offset, str, style);
            } else {
                super.insertString(fb, offset, str, a);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String str, AttributeSet a) throws BadLocationException {
            if (length != 0 && this.isRemoveProtected(offset, length)) {
                Toolkit.getDefaultToolkit().beep();
            } else if (this.isInsertProtected(offset)) {
                Toolkit.getDefaultToolkit().beep();
            } else if (ProtectedDocument.this.trackChanges) {
                Object ob;
                int track = -1;
                StyledDocument doc = (StyledDocument)fb.getDocument();
                Element e = doc.getCharacterElement(offset);
                MutableAttributeSet attr = (MutableAttributeSet)e.getAttributes();
                if (attr != null) {
                    String n = (String)attr.getAttribute("track");
                    if (n != null) {
                        if (n.equals("added")) {
                            track = 0;
                        } else if (n.equals("deleted")) {
                            track = 1;
                        }
                    } else {
                        Element e2;
                        MutableAttributeSet attr2;
                        JLabel label;
                        String prop;
                        Object ob2 = attr.getAttribute(StyleConstants.ComponentAttribute);
                        if (ob2 != null && (prop = (String)(label = (JLabel)ob2).getClientProperty("track")) != null && prop.equals("end") && offset > 0 && (attr2 = (MutableAttributeSet)(e2 = doc.getCharacterElement(offset - 1)).getAttributes()) != null) {
                            super.replace(fb, offset, length, str, attr2);
                            return;
                        }
                    }
                }
                if (a != null && (ob = a.getAttribute(StyleConstants.ComponentAttribute)) != null) {
                    JLabel label = (JLabel)ob;
                    if (track == -1) {
                        label.putClientProperty("track", "add");
                        String s = label.getText();
                        label.setText(s + "+");
                    } else if (track == 0) {
                        label.putClientProperty("track", "added");
                    } else if (track == 1) {
                        label.putClientProperty("track", "deleted");
                    }
                    super.replace(fb, offset, length, str, a);
                    return;
                }
                if (track != -1) {
                    super.replace(fb, offset, length, str, attr);
                    return;
                }
                int i = ProtectedDocument.this.textPane.getSelectionEnd();
                if (i > 0) {
                    Style dstyle = doc.getStyle("Delete");
                    doc.setCharacterAttributes(offset, length, dstyle, true);
                    ProtectedDocument.this.textPane.setCaretPosition(i);
                    Style style = doc.getStyle("Add");
                    super.insertString(fb, i, str, style);
                } else {
                    Style style = doc.getStyle("Add");
                    super.replace(fb, offset, length, str, style);
                }
            } else {
                super.replace(fb, offset, length, str, a);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (length == 0) {
                ++length;
            }
            if (this.isRemoveProtected(offset, length)) {
                Toolkit.getDefaultToolkit().beep();
            } else if (ProtectedDocument.this.trackChanges) {
                boolean replace = true;
                StyledDocument doc = (StyledDocument)fb.getDocument();
                Style style = null;
                Element e = doc.getCharacterElement(offset);
                AttributeSet a = e.getAttributes();
                if (a != null) {
                    String n;
                    MutableAttributeSet attr = (MutableAttributeSet)a;
                    Object ob = attr.getAttribute(StyleConstants.ComponentAttribute);
                    if (ob != null) {
                        JLabel label = (JLabel)ob;
                        Object oprop = label.getClientProperty("track");
                        if (oprop != null) {
                            String prop = oprop.toString();
                            if (prop.equals("added") || prop.equals("add") || prop.equals("deleted")) {
                                super.remove(fb, offset, length);
                                return;
                            }
                            if (prop.equals("delete")) {
                                label.putClientProperty("track", null);
                                String s = label.getText();
                                if (s.endsWith("-")) {
                                    label.setText(s.substring(0, s.length() - 1));
                                }
                            }
                        } else {
                            label.putClientProperty("track", "delete");
                            String s = label.getText();
                            label.setText(s + "-");
                        }
                        replace = false;
                    }
                    if (attr != null && (n = (String)attr.getAttribute("track")) != null) {
                        if (n.equals("added") || n.equals("add")) {
                            super.remove(fb, offset, length);
                            return;
                        }
                        if (n.equals("deleted")) {
                            super.remove(fb, offset, length);
                            return;
                        }
                        if (n.equals("delete")) {
                            style = doc.getStyle("");
                        }
                    }
                }
                if (style == null) {
                    style = doc.getStyle("Delete");
                }
                doc.setCharacterAttributes(offset, length, style, replace);
                int cp = ProtectedDocument.this.textPane.getCaretPosition();
                if (offset == cp) {
                    ProtectedDocument.this.textPane.setCaretPosition(offset + 1);
                } else {
                    ProtectedDocument.this.textPane.setCaretPosition(offset);
                }
            } else {
                super.remove(fb, offset, length);
            }
        }

        private boolean isRemoveProtected(int start, int length) {
            int end = start + length - 1;
            for (Map.Entry me : ProtectedDocument.this.positions.entrySet()) {
                int positionStart = ((Position)me.getKey()).getOffset();
                int positionEnd = ((Position)me.getValue()).getOffset();
                if (start >= positionStart && start <= positionEnd) {
                    return true;
                }
                if (end >= positionStart && end <= positionEnd) {
                    return true;
                }
                if (start >= positionStart || end <= positionEnd) continue;
                return true;
            }
            return false;
        }

        private boolean isInsertProtected(int start) {
            for (Map.Entry me : ProtectedDocument.this.positions.entrySet()) {
                int positionStart = ((Position)me.getKey()).getOffset();
                int positionEnd = ((Position)me.getValue()).getOffset();
                if (start == 0 && positionStart == 0) {
                    return true;
                }
                if (start <= positionStart || start > positionEnd) continue;
                return true;
            }
            return false;
        }
    }

    class ProtectedNavigationFilter
    extends NavigationFilter
    implements MouseListener {
        private JTextComponent component;
        private boolean isMousePressed = false;
        private int mouseDot = -1;
        private int lastDot = -1;

        public ProtectedNavigationFilter(JTextComponent component) {
            this.component = component;
            this.component.addMouseListener(this);
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            if (dot > this.lastDot) {
                dot = this.getForwardDot(dot);
                super.setDot(fb, dot, bias);
            } else {
                dot = this.getBackwardDot(dot);
                super.setDot(fb, dot, bias);
            }
            this.lastDot = dot;
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            int n = this.lastDot = this.isMousePressed ? this.mouseDot : this.lastDot;
            if (dot > this.lastDot) {
                this.lastDot = dot;
                dot = this.getForwardDot(dot);
                super.moveDot(fb, dot, bias);
            } else {
                this.lastDot = dot;
                dot = this.getBackwardDot(dot);
                super.moveDot(fb, dot, bias);
            }
            this.lastDot = dot;
        }

        private int getForwardDot(int dot) {
            for (Map.Entry me : ProtectedDocument.this.positions.entrySet()) {
                int positionStart = ((Position)me.getKey()).getOffset();
                int positionEnd = ((Position)me.getValue()).getOffset();
                if (dot <= positionStart || dot > positionEnd) continue;
                return positionEnd + 1;
            }
            return dot;
        }

        private int getBackwardDot(int dot) {
            for (Map.Entry me : ProtectedDocument.this.positions.entrySet()) {
                int positionStart = ((Position)me.getKey()).getOffset();
                int positionEnd = ((Position)me.getValue()).getOffset();
                if (dot > positionEnd || dot < positionStart) continue;
                return positionStart;
            }
            return dot;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.isMousePressed = true;
            this.mouseDot = this.component.getCaretPosition();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.isMousePressed = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }
}

