/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import translator.AppPreferences;
import translator.Frequencer;
import translator.MainView;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLElement;
import translator.database.DBConnection;
import translator.database.Term;
import translator.database.TermBase;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXUnit;

public class DatabaseHandler {
    private Memory memory;
    private TermBase base;
    private Map properties;
    private String regularExp;
    private String regularExpNote;
    private boolean identicalFilter;
    private boolean emptySegmentFilter;
    private List allTablesNames;

    public DatabaseHandler(Memory memory, TermBase base) {
        this.memory = memory;
        this.base = base;
    }

    public void setTableNames(List names) {
        this.allTablesNames = names;
    }

    void setIdenticalFilter(boolean filter) {
        this.identicalFilter = filter;
    }

    void setEmptySegmentFilter(boolean filter) {
        this.emptySegmentFilter = filter;
    }

    void setProperties(Map p) {
        this.properties = p;
    }

    void setRegularExpression(String reg) {
        this.regularExp = reg;
    }

    void setRegularExpressionNote(String reg) {
        this.regularExpNote = reg;
    }

    void loadToFilteredMemory(boolean closeConnetion) throws SQLException {
        String baseName = this.base.getName();
        boolean TR = false;
        if (baseName != null && baseName.equals("Total Recall")) {
            TR = true;
        }
        DBConnection connection = this.base.getConnection();
        if (AppPreferences.isTrialVersion) {
            int i;
            if (!TR) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(baseName);
                i = connection.countRows(list);
            } else {
                i = connection.countRows(this.allTablesNames);
            }
            if (i == -1) {
                return;
            }
            if (i > 1000) {
                String cont;
                String message = "The free version of CafeTran Espresso allows you to work with translation memories (TM's) up to 1000 translation units (TU's)\nin size (in total among all TM's), and with glossary files with up to 500 terms (in total). You have reached one of those limits.\nTo unlock the program for use with these larger resources, it is necessary to purchase a license file from the CafeTran.com website.\nOnce you load the license file into the program you will be able to use the program with TM's and glossaries of unlimited size.";
                String s = "Trial Version Limit";
                String buy = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PURCHASE LICENSE");
                Object[] options = new String[]{buy, cont = "Continue to use free version, with limits"};
                int o = JOptionPane.showOptionDialog(null, message, s, 0, 1, null, options, buy);
                if (o == 0) {
                    try {
                        URI uri = new URI(AppPreferences.purchase_url);
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DatabaseHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                return;
            }
        }
        MainView topui = this.base.getTopUI();
        int hits = this.memory.getRecallHitsInContext();
        if (hits == -1 && TR) {
            hits = 1000000;
        }
        String[] queries = new String[1];
        int sqlType = connection.getSQLType();
        if ((sqlType == 0 || sqlType == 1 || sqlType == 2) && hits > 0) {
            Frequencer fr = new Frequencer(topui);
            Set set = fr.getProjectUniqueWords();
            String[] q = null;
            if (sqlType == 0) {
                q = connection.getH2QueriesForWords(set, hits, TR);
            } else if (sqlType == 1) {
                q = !TR ? connection.getSQLiteQueriesForWords(set, hits, null) : connection.getSQLiteQueriesForWords(set, hits, this.allTablesNames);
            } else if (sqlType == 2) {
                q = !TR ? connection.getMySQLQueriesForWords(set, hits, null) : connection.getMySQLQueriesForWords(set, hits, this.allTablesNames);
            }
            if (q != null && q.length > 0) {
                queries = q;
            } else {
                queries[0] = null;
            }
        } else {
            queries[0] = "all";
        }
        for (int k = 0; k < queries.length; ++k) {
            String rcol;
            String ccol;
            String ncol;
            String fcol;
            String idcol;
            String tcol;
            String query = queries[k];
            if (query == null) continue;
            if (query.equals("all")) {
                connection.selectAllRows();
            } else {
                connection.selectRows(query);
            }
            ResultSet rs = connection.getResultSet();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            String[] cnames = new String[columnCount];
            String scol = connection.getSourceLang();
            if (scol.indexOf("-") != -1) {
                scol = scol.replaceAll("-", "_");
            }
            if ((tcol = connection.getTargetLang()).indexOf("-") != -1) {
                tcol = tcol.replaceAll("-", "_");
            }
            if ((idcol = connection.getClientIDName()).indexOf("-") != -1) {
                idcol = idcol.replaceAll("-", "_");
            }
            if ((fcol = connection.getFieldName()).indexOf("-") != -1) {
                fcol = fcol.replaceAll("-", "_");
            }
            if ((ncol = connection.getNotesName()).indexOf("-") != -1) {
                ncol = ncol.replaceAll("-", "_");
            }
            if ((ccol = connection.getContextName()).indexOf("-") != -1) {
                ccol = ccol.replaceAll("-", "_");
            }
            if ((rcol = connection.getReferenceName()).indexOf("-") != -1) {
                rcol = rcol.replaceAll("-", "_");
            }
            int srcCol = -1;
            int trgCol = -1;
            int idCol = -1;
            int noteCol = -1;
            int fieldCol = -1;
            int contextCol = -1;
            int referenceCol = -1;
            boolean id = false;
            boolean note = false;
            boolean field = false;
            boolean context = false;
            boolean reference = false;
            int filteredPropCol = -1;
            int filteredPropCol2 = -1;
            String propValue1 = "";
            String propValue2 = "";
            int filteredRegExCol = -1;
            int filteredRegExNoteCol = -1;
            for (int i = 1; i <= columnCount; ++i) {
                int type;
                String s;
                String name = meta.getColumnName(i);
                if (this.properties != null && (s = (String)this.properties.get(name.toLowerCase())) != null) {
                    if (filteredPropCol == -1) {
                        filteredPropCol = i;
                        propValue1 = s;
                    } else if (filteredPropCol2 == -1) {
                        filteredPropCol2 = i;
                        propValue2 = s;
                    }
                }
                if ((type = meta.getColumnType(i)) != -9 && type != 12) continue;
                if (name.equalsIgnoreCase(idcol)) {
                    id = true;
                    idCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(fcol)) {
                    field = true;
                    fieldCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(ccol)) {
                    context = true;
                    contextCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(rcol)) {
                    reference = true;
                    referenceCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(ncol)) {
                    note = true;
                    noteCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(scol)) {
                    srcCol = i;
                    continue;
                }
                if (!name.equalsIgnoreCase(tcol)) continue;
                trgCol = i;
            }
            if (srcCol != -1 && this.regularExp != null) {
                filteredRegExCol = srcCol;
            }
            if (noteCol != -1 && this.regularExpNote != null) {
                filteredRegExNoteCol = noteCol;
            }
            while (rs.next()) {
                String n;
                String n2;
                String n3;
                String n4;
                String n5;
                String f;
                boolean load = false;
                boolean propload = false;
                if (this.identicalFilter || this.emptySegmentFilter) {
                    load = true;
                }
                if (filteredPropCol != -1 && (f = rs.getString(filteredPropCol)) != null && propValue1.equals(f.toLowerCase())) {
                    propload = true;
                }
                if (filteredPropCol2 != -1 && !propload && (f = rs.getString(filteredPropCol2)) != null && propValue2.equals(f.toLowerCase())) {
                    propload = true;
                }
                if (!load && filteredRegExNoteCol != -1) {
                    f = rs.getString(filteredRegExNoteCol);
                    load = f != null && f.matches(this.regularExpNote);
                }
                if (!load && filteredRegExCol != -1) {
                    f = rs.getString(filteredRegExCol);
                    load = f != null && f.matches(this.regularExp);
                }
                if (!load && !propload) continue;
                String source = rs.getString(srcCol);
                String target = rs.getString(trgCol);
                if (source == null || source.length() <= 0 || target == null || this.identicalFilter && source.equals(target) || this.emptySegmentFilter && (source.trim().length() == 0 || target.trim().length() == 0)) continue;
                String snote = null;
                if (note && (n5 = rs.getString(noteCol)) != null && n5.length() > 0) {
                    snote = n5;
                }
                String sfield = null;
                if (field && (n4 = rs.getString(fieldCol)) != null && n4.length() > 0) {
                    sfield = n4;
                }
                String scontext = null;
                if (context && (n3 = rs.getString(contextCol)) != null && n3.length() > 0) {
                    scontext = n3;
                }
                String sreference = null;
                if (reference && (n2 = rs.getString(referenceCol)) != null && n2.length() > 0) {
                    sreference = n2;
                }
                String sid = null;
                if (id && (n = rs.getString(idCol)) != null && n.length() > 0) {
                    sid = n;
                }
                this.memory.updateDataBaseMemory(source, target, snote, sfield, scontext, sid, sreference);
            }
        }
        if (this.base.isLoaded()) {
            connection.refresh();
        } else if (closeConnetion) {
            this.base.closeResource();
        }
    }

    void loadToMemory(boolean closeConnetion) throws SQLException {
        String baseName = this.base.getName();
        boolean TR = false;
        if (baseName != null && baseName.equals("Total Recall")) {
            TR = true;
        }
        DBConnection connection = this.base.getConnection();
        if (AppPreferences.isTrialVersion) {
            int i;
            if (!TR) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(baseName);
                i = connection.countRows(list);
            } else {
                i = connection.countRows(this.allTablesNames);
            }
            if (i == -1) {
                return;
            }
            if (i > 1000) {
                String cont;
                String message = "The free version of CafeTran Espresso allows you to work with translation memories (TM's) up to 1000 translation units (TU's)\nin size (in total among all TM's), and with glossary files with up to 500 terms (in total). You have reached one of those limits.\nTo unlock the program for use with these larger resources, it is necessary to purchase a license file from the CafeTran.com website.\nOnce you load the license file into the program you will be able to use the program with TM's and glossaries of unlimited size.";
                String s = "Trial Version Limit";
                String buy = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PURCHASE LICENSE");
                Object[] options = new String[]{buy, cont = "Continue to use free version, with limits"};
                int o = JOptionPane.showOptionDialog(null, message, s, 0, 1, null, options, buy);
                if (o == 0) {
                    try {
                        URI uri = new URI(AppPreferences.purchase_url);
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DatabaseHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                return;
            }
        }
        MainView topui = this.base.getTopUI();
        int hits = this.memory.getRecallHitsInContext();
        if (hits == -1 && TR) {
            hits = 1000000;
        }
        String[] queries = new String[1];
        int sqlType = connection.getSQLType();
        if ((sqlType == 0 || sqlType == 1 || sqlType == 2) && hits > 0) {
            Frequencer fr = new Frequencer(topui);
            Set set = fr.getProjectUniqueWords();
            String[] q = null;
            if (sqlType == 0) {
                q = connection.getH2QueriesForWords(set, hits, TR);
            } else if (sqlType == 1) {
                q = !TR ? connection.getSQLiteQueriesForWords(set, hits, null) : connection.getSQLiteQueriesForWords(set, hits, this.allTablesNames);
            } else if (sqlType == 2) {
                q = !TR ? connection.getMySQLQueriesForWords(set, hits, null) : connection.getMySQLQueriesForWords(set, hits, this.allTablesNames);
            }
            if (q != null && q.length > 0) {
                queries = q;
            } else {
                queries[0] = null;
            }
        } else {
            queries[0] = "all";
        }
        for (int k = 0; k < queries.length; ++k) {
            String rcol;
            String ccol;
            String ncol;
            String idcol;
            String fcol;
            String tcol;
            String query = queries[k];
            if (query == null) continue;
            if (query.equals("all")) {
                connection.selectAllRows();
            } else {
                connection.selectRows(query);
            }
            ResultSet rs = connection.getResultSet();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            String scol = connection.getSourceLang();
            if (scol.indexOf("-") != -1) {
                scol = scol.replaceAll("-", "_");
            }
            if ((tcol = connection.getTargetLang()).indexOf("-") != -1) {
                tcol = tcol.replaceAll("-", "_");
            }
            if ((fcol = connection.getFieldName()).indexOf("-") != -1) {
                fcol = fcol.replaceAll("-", "_");
            }
            if ((idcol = connection.getClientIDName()).indexOf("-") != -1) {
                idcol = idcol.replaceAll("-", "_");
            }
            if ((ncol = connection.getNotesName()).indexOf("-") != -1) {
                ncol = ncol.replaceAll("-", "_");
            }
            if ((ccol = connection.getContextName()).indexOf("-") != -1) {
                ccol = ccol.replaceAll("-", "_");
            }
            if ((rcol = connection.getReferenceName()).indexOf("-") != -1) {
                rcol = rcol.replaceAll("-", "_");
            }
            int srcCol = -1;
            int trgCol = -1;
            int fieldCol = -1;
            int contextCol = -1;
            int idCol = -1;
            int notesCol = -1;
            int referenceCol = -1;
            boolean field = false;
            boolean context = false;
            boolean id = false;
            boolean notes = false;
            boolean reference = false;
            for (int i = 1; i <= columnCount; ++i) {
                String name = meta.getColumnName(i);
                int type = meta.getColumnType(i);
                if (type != -9 && type != 12) continue;
                if (name.equalsIgnoreCase(scol)) {
                    srcCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(tcol)) {
                    trgCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(fcol)) {
                    field = true;
                    fieldCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(ccol)) {
                    context = true;
                    contextCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(rcol)) {
                    reference = true;
                    referenceCol = i;
                    continue;
                }
                if (name.equalsIgnoreCase(ncol)) {
                    notes = true;
                    notesCol = i;
                    continue;
                }
                if (!name.equalsIgnoreCase(idcol)) continue;
                id = true;
                idCol = i;
            }
            if (srcCol == -1 || trgCol == -1) continue;
            while (rs.next()) {
                String n;
                String n2;
                String n3;
                String n4;
                String n5;
                String source = rs.getString(srcCol);
                String target = rs.getString(trgCol);
                if (source == null || source.length() <= 0 || target == null) continue;
                String sfield = null;
                if (field && (n5 = rs.getString(fieldCol)) != null && n5.length() > 0) {
                    sfield = n5;
                }
                String scontext = null;
                if (context && (n4 = rs.getString(contextCol)) != null && n4.length() > 0) {
                    scontext = n4;
                }
                String sreference = null;
                if (reference && (n3 = rs.getString(referenceCol)) != null && n3.length() > 0) {
                    sreference = n3;
                }
                String snote = null;
                if (notes && (n2 = rs.getString(notesCol)) != null && n2.length() > 0) {
                    snote = n2;
                }
                String sid = null;
                if (id && (n = rs.getString(idCol)) != null && n.length() > 0) {
                    sid = n;
                }
                this.memory.updateDataBaseMemory(source, target, snote, sfield, scontext, sid, sreference);
            }
        }
        if (this.base.isLoaded()) {
            connection.refresh();
        } else if (closeConnetion) {
            this.base.closeResource();
        }
    }

    void loadTMToDatabase() throws SQLException {
        String rcol;
        String ccol;
        String ncol;
        String fcol;
        String idcol;
        String s;
        int j;
        String colNameTrg;
        DBConnection connectionDB = this.base.getConnection();
        String driver = connectionDB.getDriverClassName();
        String nq = connectionDB.getNextRowsQuery();
        if (nq == null) {
            connectionDB.selectAllRows();
        } else {
            connectionDB.selectRows(nq);
        }
        ResultSet rs = connectionDB.getResultSet();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        Connection connection = connectionDB.getConnection();
        String[] columnNames = connectionDB.getColumnNamesArray();
        String tableName = connectionDB.getTableName();
        int scrollType = rs.getType();
        Statement stmt = null;
        if (scrollType == 1003) {
            stmt = connection.createStatement();
        } else if (driver != null && driver.equals("org.mariadb.jdbc.Driver")) {
            stmt = connection.createStatement();
        }
        String colNameSrc = connectionDB.getSourceLang();
        if (colNameSrc.indexOf("-") != -1) {
            colNameSrc = colNameSrc.replaceAll("-", "_");
        }
        if ((colNameTrg = connectionDB.getTargetLang()).indexOf("-") != -1) {
            colNameTrg = colNameTrg.replaceAll("-", "_");
        }
        boolean sourceLangSet = false;
        boolean targetLangSet = false;
        ArrayList<String> arr = new ArrayList<String>();
        try {
            DatabaseMetaData dmeta = connection.getMetaData();
            ResultSet rset = dmeta.getColumns(null, null, tableName, null);
            while (rset.next()) {
                String name = rset.getString("COLUMN_NAME");
                if (name == null) continue;
                arr.add(name);
                if (name.equals(colNameSrc)) {
                    sourceLangSet = true;
                    continue;
                }
                if (!name.equals(colNameTrg)) continue;
                targetLangSet = true;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!sourceLangSet) {
            int i = colNameSrc.lastIndexOf(95);
            if (i != -1) {
                colNameSrc = colNameSrc.substring(0, i);
            }
            for (String next : arr) {
                j = next.lastIndexOf(95);
                if (j == -1 || !colNameSrc.equals(s = next.substring(0, j))) continue;
                colNameSrc = next;
                connectionDB.setSourceLang(next);
                break;
            }
        }
        if (!targetLangSet) {
            int i = colNameTrg.lastIndexOf(95);
            if (i != -1) {
                colNameTrg = colNameTrg.substring(0, i);
            }
            for (String next : arr) {
                j = next.lastIndexOf(95);
                if (j == -1 || !colNameTrg.equals(s = next.substring(0, j))) continue;
                colNameTrg = next;
                connectionDB.setTargetLang(next);
                break;
            }
        }
        if ((idcol = connectionDB.getClientIDName()).indexOf("-") != -1) {
            idcol = idcol.replaceAll("-", "_");
        }
        if ((fcol = connectionDB.getFieldName()).indexOf("-") != -1) {
            fcol = fcol.replaceAll("-", "_");
        }
        if ((ncol = connectionDB.getNotesName()).indexOf("-") != -1) {
            ncol = ncol.replaceAll("-", "_");
        }
        if ((ccol = connectionDB.getContextName()).indexOf("-") != -1) {
            ccol = ccol.replaceAll("-", "_");
        }
        if ((rcol = connectionDB.getReferenceName()).indexOf("-") != -1) {
            rcol = rcol.replaceAll("-", "_");
        }
        boolean autoincrement = connectionDB.autoIncrementNull;
        int srcCol = -1;
        int trgCol = -1;
        boolean id = false;
        boolean note = false;
        boolean field = false;
        boolean context = false;
        boolean reference = false;
        for (int i = 1; i <= columnCount; ++i) {
            String name = meta.getColumnName(i);
            int type = meta.getColumnType(i);
            if (type != -9 && type != 12) continue;
            if (name.equalsIgnoreCase(idcol)) {
                id = true;
                continue;
            }
            if (name.equalsIgnoreCase(fcol)) {
                field = true;
                continue;
            }
            if (name.equalsIgnoreCase(ccol)) {
                context = true;
                continue;
            }
            if (name.equalsIgnoreCase(rcol)) {
                reference = true;
                continue;
            }
            if (name.equalsIgnoreCase(ncol)) {
                note = true;
                continue;
            }
            if (name.equalsIgnoreCase(colNameSrc)) {
                srcCol = i;
                continue;
            }
            if (!name.equalsIgnoreCase(colNameTrg)) continue;
            trgCol = i;
        }
        TMX tmx = this.memory.getTMX();
        TranslationUnitMap tmap = tmx.getTUMap();
        Collection col = tmx.getTranslationUnits();
        String slang = this.memory.getSourceLangCode();
        String tlang = this.memory.getTargetLangCode();
        String source = null;
        String target = null;
        int count = 0;
        for (TranslationUnit tu : col) {
            TMXUnit tux;
            List list;
            source = tu.getSegment(slang);
            target = tu.getSegment(tlang);
            if (source == null || target == null || source.length() > AppPreferences.columnSize || target.length() > AppPreferences.columnSize) continue;
            Term term = connectionDB.newTerm();
            term.setSource(source);
            term.setTarget(target);
            if (note && tu instanceof TMXUnit && (list = (tux = (TMXUnit)tu).getChildren("note")) != null) {
                for (XMLElement object : list) {
                    String con = object.getContent(0).toString();
                    if (con == null) continue;
                    term.setNote(con);
                    break;
                }
            }
            if ((field || context || id || reference) && tu instanceof TMXUnit && (list = (tux = (TMXUnit)tu).getChildren("prop")) != null) {
                for (XMLElement object : list) {
                    String con;
                    String attr = object.getAttribute("type");
                    if (attr != null && attr.equalsIgnoreCase(AppPreferences.dbFieldCol)) {
                        con = object.getContent(0).toString();
                        if (con == null) continue;
                        term.setField(con);
                        continue;
                    }
                    if (attr != null && attr.equalsIgnoreCase(AppPreferences.dbContextCol)) {
                        con = object.getContent(0).toString();
                        if (con == null) continue;
                        term.setContext(con);
                        continue;
                    }
                    if (attr != null && attr.equalsIgnoreCase(AppPreferences.dbClientCol)) {
                        con = object.getContent(0).toString();
                        if (con == null) continue;
                        term.setId(con);
                        continue;
                    }
                    if (attr == null || !attr.equalsIgnoreCase(AppPreferences.dbURLCol) || (con = object.getContent(0).toString()) == null) continue;
                    term.setReference(con);
                }
            }
            List values = term.getValues();
            int[] types = term.getTypes();
            int ti = 0;
            if (stmt == null) {
                rs.moveToInsertRow();
                for (Object object : values) {
                    java.util.Date t;
                    int type = types[ti];
                    if (type == -9 || type == 12) {
                        String s2 = (String)object;
                        rs.updateString(ti + 1, s2);
                    } else if (type == 4) {
                        if (!meta.isAutoIncrement(ti + 1)) {
                            int i = (Integer)object;
                            rs.updateInt(ti + 1, i);
                        } else if (autoincrement) {
                            rs.updateObject(ti + 1, null);
                        }
                    } else if (type == 91) {
                        Date d = (Date)object;
                        rs.updateDate(ti + 1, d);
                    } else if (type == 92) {
                        t = (Time)object;
                        rs.updateTime(ti + 1, (Time)t);
                    } else if (type == 93) {
                        t = (Timestamp)object;
                        rs.updateTimestamp(ti + 1, (Timestamp)t);
                    }
                    ++ti;
                }
                rs.insertRow();
            } else {
                StringBuilder sqlColumns = new StringBuilder("(");
                StringBuilder sqlValues = new StringBuilder("(");
                for (Object object : values) {
                    int type = types[ti];
                    String columnName = columnNames[ti];
                    if (type == -9 || type == 12) {
                        String s3 = (String)object;
                        if (s3.indexOf(39) != -1) {
                            s3 = s3.replaceAll("'", "''");
                        }
                        sqlColumns.append(columnName);
                        sqlColumns.append(",");
                        sqlValues.append("'");
                        sqlValues.append(s3);
                        sqlValues.append("', ");
                    } else if (type != 4) {
                        java.util.Date t;
                        String s4;
                        if (type == 91) {
                            Date d = (Date)object;
                            s4 = d.toString();
                            if (s4.length() > 0) {
                                sqlColumns.append(columnName);
                                sqlColumns.append(",");
                                sqlValues.append('\'');
                                sqlValues.append(s4);
                                sqlValues.append('\'');
                                sqlValues.append(", ");
                            }
                        } else if (type == 92) {
                            t = (Time)object;
                            s4 = ((Time)t).toString();
                            if (s4.length() > 0) {
                                sqlColumns.append(columnName);
                                sqlColumns.append(",");
                                sqlValues.append(s4);
                                sqlValues.append(", ");
                            }
                        } else if (type == 93 && (s4 = ((Timestamp)(t = (Timestamp)object)).toString()).length() > 0) {
                            sqlColumns.append(columnName);
                            sqlColumns.append(",");
                            sqlValues.append(s4);
                            sqlValues.append(", ");
                        }
                    }
                    ++ti;
                }
                if (sqlColumns.length() > 1) {
                    sqlColumns.setLength(sqlColumns.length() - 1);
                    sqlColumns.append(")");
                }
                if (sqlValues.length() > 2) {
                    sqlValues.setLength(sqlValues.length() - 2);
                    sqlValues.append(")");
                }
                String sql = "INSERT INTO " + tableName + " " + sqlColumns.toString() + " VALUES " + sqlValues.toString() + ";";
                stmt.executeUpdate(sql);
            }
            if (++count % 100 != 0) continue;
            tmap.updateProgress(count);
        }
        if (stmt != null) {
            stmt.close();
        }
        if (this.base.isLoaded()) {
            connectionDB.refresh();
        } else {
            this.base.closeResource();
        }
    }
}

