/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.DictionaryResource;
import translator.MainView;
import translator.Project;
import translator.database.DatabaseView;
import translator.database.TermBase;
import translator.tmx.Memory;
import translator.ui.GridPanel;

public final class DatabaseSaveChooser
extends JDialog
implements ActionListener {
    private JComboBox tables;
    private JButton jb1;
    private JButton jb2;
    private MainView parent;
    private Memory memory;
    private DictionaryResource glossary;

    public DatabaseSaveChooser(MainView parent, String title, Memory memory) {
        super(parent, title, true);
        this.parent = parent;
        this.memory = memory;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DatabaseSaveChooser(MainView parent, String title, DictionaryResource glossary) {
        super(parent, title, true);
        this.parent = parent;
        this.glossary = glossary;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public DatabaseSaveChooser(MainView parent, String title, Project project) {
        super(parent, title, true);
        this.parent = parent;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DatabaseView dv = this.parent.getDatabaseView();
        List list = dv.getTableNames();
        this.tables = new JComboBox<Object>(list.toArray());
        TermBase base = dv.getTermBase();
        if (base != null) {
            this.tables.setSelectedItem(base.getName());
        } else {
            this.tables.setSelectedItem(AppPreferences.memoryTable);
        }
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(1, 10, 10));
        panel1.setOpaque(false);
        panel1.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        GridPanel panel3 = new GridPanel();
        this.setContentPane(panel3);
        panel3.setLayout(new BorderLayout());
        this.setResizable(false);
        panel1.add(this.jb2);
        panel1.add(this.tables);
        panel1.add(this.jb1);
        panel3.add((Component)panel1, "North");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            String baseName = (String)this.tables.getSelectedItem();
            if (baseName != null) {
                DatabaseView dv = this.parent.getDatabaseView();
                TermBase base = dv.getTermBase();
                if (base != null) {
                    String name = base.getName();
                    if (name.equalsIgnoreCase(baseName)) {
                        if (this.memory != null) {
                            this.memory.saveDatabaseTM(base);
                        } else if (this.glossary != null) {
                            this.glossary.toDatabase(base);
                        }
                    }
                } else if (this.memory != null) {
                    base = dv.connectToTermBase(baseName, this.memory.getSourceLangCode(), this.memory.getTargetLangCode());
                    if (base != null) {
                        base.setMainView(this.parent);
                        this.memory.saveDatabaseTM(base);
                    }
                } else if (this.glossary != null && (base = dv.connectToTermBase(baseName, AppPreferences.fileSLang, AppPreferences.fileTLang)) != null) {
                    base.setMainView(this.parent);
                    this.glossary.toDatabase(base);
                }
            }
            this.dispose();
        }
    }
}

