/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.html.HTMLDocument;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import translator.AppPreferences;
import translator.DashboardView;
import translator.DefaultXMLElement;
import translator.FileFilters;
import translator.MainView;
import translator.MemoryStatistics;
import translator.ProgressBarUpdater;
import translator.Project;
import translator.ResourceInfo;
import translator.ResourceLoader;
import translator.ResourceView;
import translator.SegmentParser;
import translator.TabView;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLElement;
import translator.database.DatabaseView;
import translator.database.TermBase;
import translator.tmx.AppleGlossaryHandler;
import translator.tmx.BitextHandler;
import translator.tmx.DatabaseHandler;
import translator.tmx.DatabaseSaveChooser;
import translator.tmx.ExcelTMHandler;
import translator.tmx.MultitermXMLHandler;
import translator.tmx.SDLTBHandler;
import translator.tmx.SDLTMHandler;
import translator.tmx.TBXHandler;
import translator.tmx.TMX;
import translator.tmx.TMXBody;
import translator.tmx.TMXFilterHandler;
import translator.tmx.TMXHandler;
import translator.tmx.TMXHeader;
import translator.tmx.TMXImportDialog;
import translator.tmx.TMXReadOnlyHandler;
import translator.tmx.TMXReadOnlyUnitMap;
import translator.tmx.TMXResult;
import translator.tmx.TMXStartDialog;
import translator.tmx.TMXToTableHandler;
import translator.tmx.TMXUnitMap;
import translator.tmx.TMXView;
import translator.tmx.TXTHandler;
import translator.tmx.TabbedTMHandler;
import translator.ttx.TTX;
import translator.ttx.TTXWorkflow;
import translator.ui.HTMLFormat;
import translator.xliff.XLIFF;
import translator.xliff.XliffWorkflow;

public class Memory {
    private TMX tmx;
    private MainView topui;
    private ProgressMonitor pm;
    private String name;
    private String creationid;
    private String path;
    private String importedPath;
    private String infoPath;
    public String encoding;
    private String slang;
    private String tlang;
    private String userID;
    private Map propertiesCondition;
    private String noteCondition;
    private String regExp;
    private boolean filter = false;
    private boolean langFilter = false;
    private boolean identicalFilter = false;
    private boolean emptySegmentFilter = false;
    private boolean internalTagsFilter = false;
    private boolean foreignCodesFilter = false;
    private boolean startLoad = true;
    private boolean conditionSaved = true;
    private boolean isUpdated = false;
    private boolean pretrans = false;
    private HTMLDocument htmldoc;
    private JTextPane mpane;
    int snumber = 0;
    private boolean editMode = true;
    private int flowMode = 0;
    private int matchType = -1;
    private boolean greedyMatching = true;
    private boolean prefixMatch = false;
    private int prefixAccuracy = -1;
    private boolean caseMatch = false;
    boolean isActive = false;
    boolean readOnly = false;
    boolean loadedReadOnly = false;
    boolean pretranslateOnly = false;
    boolean tagsPositions = false;
    private int remDuplicates = 0;
    private List updates;
    private boolean isTerms = true;
    private boolean termsCheck = false;
    private boolean isSegments = true;
    private boolean isBlocked = false;
    private boolean isTaskReady = false;
    private boolean isCompareTargets;
    private MemoryStatistics stats;
    boolean fromDatabase = false;
    private TermBase table;
    boolean toDatabase = false;
    private int priority = 1;
    private int imported = -1;
    private String saxErrorMessage;
    public boolean multitermTM = false;
    public boolean sdlTM = false;
    public boolean wfTM = false;
    public boolean tabbedTM = false;
    private int recallHitsInContext = AppPreferences.recallInContextHits;
    private boolean singleTM = true;
    public static int totalTUsLoaded = 0;
    public static boolean trialMessageDisplayed;
    private boolean optionChanged = true;
    private boolean isNewlyAdded = false;
    private boolean autoAssemblingStopped;
    private Project project;
    private ArrayList databaseTableNames;
    private boolean closed = false;
    private String uid = Integer.toString(ResourceView.uniqueResourceID++);
    private JProgressBar bar;

    public Memory(ResourceInfo ri) {
        this.name = ri.getName();
        this.path = ri.getResourcePath();
        this.infoPath = ri.getInfoPath();
        this.userID = this.creationid = ri.getAuthor();
        if (this.name == null) {
            if (this.path != null) {
                int i = this.path.lastIndexOf(System.getProperty("file.separator"));
                if (i == -1) {
                    i = this.path.lastIndexOf("/");
                }
                this.name = i != -1 ? this.path.substring(i + 1) : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY") + ".tmx";
            }
        } else if (this.path == null) {
            this.path = AppPreferences.packagePath + "resources/memories/";
        }
        this.slang = ri.getSource();
        this.tlang = ri.getTarget();
        this.encoding = ri.getEncoding();
        if (!this.encoding.startsWith("UTF")) {
            this.encoding = "UTF-8";
        }
        this.stats = new MemoryStatistics();
        this.caseMatch = AppPreferences.memCaseMatch;
        this.remDuplicates = AppPreferences.duplicatesType;
        this.isCompareTargets = AppPreferences.compareTargets;
        this.flowMode = AppPreferences.workflowModeMemory;
        this.matchType = AppPreferences.matchType;
    }

    public Memory(String lpath) {
        this.path = lpath;
        this.userID = this.creationid = "";
        if (this.path != null && this.path.length() > 0) {
            int i = this.path.lastIndexOf(System.getProperty("file.separator"));
            if (i == -1) {
                i = this.path.lastIndexOf("/");
            }
            if (i != -1) {
                this.name = this.path.substring(i + 1);
            }
        }
        this.encoding = AppPreferences.encodingTMX;
        if (!this.encoding.startsWith("UTF")) {
            this.encoding = "UTF-8";
        }
        this.stats = new MemoryStatistics();
        this.caseMatch = AppPreferences.memCaseMatch;
        this.remDuplicates = AppPreferences.duplicatesType;
        this.isCompareTargets = AppPreferences.compareTargets;
        this.flowMode = AppPreferences.workflowModeMemory;
        this.matchType = AppPreferences.matchType;
    }

    public String getUID() {
        return this.uid;
    }

    public void setDatabaseTableNames(ArrayList l) {
        this.databaseTableNames = l;
    }

    public ArrayList getDatabaseTableNames() {
        return this.databaseTableNames;
    }

    public void setProject(Project p) {
        this.project = p;
    }

    public Project getProject() {
        return this.project;
    }

    public void setNewlyAdded(boolean added) {
        this.isNewlyAdded = added;
    }

    public boolean isNewlyAdded() {
        return this.isNewlyAdded;
    }

    public boolean isSingleTM() {
        return this.singleTM;
    }

    public void stopAutoassembling(boolean AAstop) {
        this.autoAssemblingStopped = AAstop;
        this.optionChanged = true;
    }

    public boolean isAutoAssemblingStopped() {
        return this.autoAssemblingStopped;
    }

    public void setImported(int i) {
        this.imported = i;
        if (i == 0) {
            this.importedPath = this.path;
        }
    }

    public void setPriority(int p) {
        SegmentParser parser;
        this.priority = p;
        if (this.tmx != null && (parser = this.tmx.getParser()) != null) {
            parser.setPriority(p);
        }
        this.optionChanged = true;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getSize() {
        Collection col;
        if (this.tmx != null && (col = this.tmx.getTranslationUnits()) != null) {
            return col.size();
        }
        return -1;
    }

    public void setPath(String p) {
        this.path = p;
        if (this.path != null && this.path.length() > 0) {
            int i = this.path.lastIndexOf(System.getProperty("file.separator"));
            if (i == -1) {
                i = this.path.lastIndexOf("/");
            }
            if (i != -1) {
                this.name = this.path.substring(i + 1);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    void showPopUp(Component comp, int x, int y) {
        JPopupMenu pop = new JPopupMenu();
        JMenuItem nextTUs = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BROWSE MEMORY") + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FORWARD"));
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_RIGHT, (int)nextTUs.getFont().getSize(), (Color)nextTUs.getForeground());
        nextTUs.setIcon((Icon)ficon);
        nextTUs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Memory.this.nextTUS();
            }
        });
        JMenuItem previousTUs = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BROWSE MEMORY") + " - " + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BACK"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_ARROW_LEFT, (int)previousTUs.getFont().getSize(), (Color)previousTUs.getForeground());
        previousTUs.setIcon((Icon)ficon);
        previousTUs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Memory.this.previousTUS();
            }
        });
        pop.add(nextTUs);
        pop.add(previousTUs);
        pop.addSeparator();
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENTS MEMORY"));
        item.setSelected(this.isSegments);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.setSegmentsMode(true);
                } else {
                    Memory.this.setSegmentsMode(false);
                }
                if (!Memory.this.readOnly) {
                    Memory.this.isUpdated = true;
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENTS MEMORY"));
        item.setSelected(this.isTerms);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.setTermsMode(true);
                } else {
                    Memory.this.setTermsMode(false);
                }
                if (!Memory.this.readOnly) {
                    Memory.this.isUpdated = true;
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FRAGMENTS CONSISTENCY CHECK"));
        item.setSelected(this.termsCheck);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.setTermsCheck(true);
                } else {
                    Memory.this.setTermsCheck(false);
                }
                if (!Memory.this.readOnly) {
                    Memory.this.isUpdated = true;
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("READ ONLY MEMORY"));
        item.setSelected(this.readOnly);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.setReadOnly(true);
                    Memory.this.isUpdated = true;
                } else if (Memory.this.loadedReadOnly) {
                    int i = JOptionPane.showConfirmDialog(Memory.this.topui, "Reload the memory in write mode?", "Reload", 0);
                    if (i == 0) {
                        if (AppPreferences.isTrialVersion && totalTUsLoaded >= 1000) {
                            JOptionPane.showMessageDialog(Memory.this.topui, "The trial version limit of 1000 translation units has been reached.");
                        } else {
                            Memory.this.setReadOnly(false);
                            Memory.this.isUpdated = true;
                            Memory.this.setReadOnlyLoaded(false);
                            Memory.this.setNewlyAdded(true);
                            Memory.this.reloadMemory();
                        }
                    }
                } else {
                    Memory.this.setReadOnly(false);
                    Memory.this.isUpdated = true;
                }
            }
        });
        if (this.fromDatabase) {
            item.setEnabled(false);
        }
        pop.add(item);
        pop.addSeparator();
        int prio = this.getPriority();
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOW PRIORITY"));
        if (prio == 0) {
            item.setSelected(true);
        }
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.setPriority(0);
                    if (!Memory.this.readOnly) {
                        Memory.this.isUpdated = true;
                    }
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEDIUM PRIORITY"));
        if (prio == 1) {
            item.setSelected(true);
        }
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.setPriority(1);
                    if (!Memory.this.readOnly) {
                        Memory.this.isUpdated = true;
                    }
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("HIGH PRIORITY"));
        if (prio == 2) {
            item.setSelected(true);
        }
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.setPriority(2);
                    if (!Memory.this.readOnly) {
                        Memory.this.isUpdated = true;
                    }
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("KEEP OUT OF AUTO-ASSEMBLING"));
        item.setEnabled(true);
        item.setSelected(this.autoAssemblingStopped);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.stopAutoassembling(true);
                } else {
                    Memory.this.stopAutoassembling(false);
                }
                if (!Memory.this.readOnly) {
                    Memory.this.isUpdated = true;
                }
            }
        });
        pop.add(item);
        item = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("COMPARE WITH TARGET SEGMENT"));
        item.setSelected(this.isCompareTargets);
        item.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Memory.this.setCompareTargets(true);
                } else {
                    Memory.this.setCompareTargets(false);
                }
            }
        });
        pop.addSeparator();
        pop.add(item);
        JMenuItem storeTM = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STORE MEMORY IN TOTAL RECALL..."));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DATABASE, (int)storeTM.getFont().getSize(), (Color)storeTM.getForeground());
        storeTM.setIcon((Icon)ficon);
        storeTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Memory.this.storeToDatabase();
            }
        });
        JMenuItem recallTM = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RECALL MEMORY..."));
        recallTM.setName("MenuTRRecallToMemory");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)recallTM.getFont().getSize(), (Color)recallTM.getForeground());
        recallTM.setIcon((Icon)ficon);
        recallTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Memory.this.topui.getMemoryView().TotalRecallToMemory();
            }
        });
        pop.addSeparator();
        pop.add(recallTM);
        pop.add(storeTM);
        JMenuItem optionsTM = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPTIONS"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_SETTINGS, (int)optionsTM.getFont().getSize(), (Color)optionsTM.getForeground());
        optionsTM.setIcon((Icon)ficon);
        optionsTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Memory.this.showStartDialog(Memory.this.name);
                if (!Memory.this.readOnly) {
                    Memory.this.optionChanged = true;
                    Memory.this.isUpdated = true;
                }
            }
        });
        if (this.readOnly) {
            optionsTM.setEnabled(false);
        }
        pop.addSeparator();
        pop.add(optionsTM);
        pop.show(comp, x, y);
    }

    public MemoryStatistics getMemoryStatistics() {
        return this.stats;
    }

    public void setRecallInContext(int hits) {
        this.recallHitsInContext = hits;
    }

    public int getRecallHitsInContext() {
        return this.recallHitsInContext;
    }

    public void setTable(TermBase table) {
        this.table = table;
    }

    public TermBase getTable() {
        return this.table;
    }

    public void setTermsCheck(boolean mode) {
        this.termsCheck = mode;
        this.optionChanged = true;
    }

    public boolean getTermsCheck() {
        return this.termsCheck;
    }

    public void setTermsMode(boolean mode) {
        this.isTerms = mode;
        this.optionChanged = true;
    }

    public boolean getTermsMode() {
        return this.isTerms;
    }

    public void setSegmentsMode(boolean mode) {
        TranslationUnitMap tumap;
        this.isSegments = mode;
        if (this.tmx != null && (tumap = this.tmx.getTUMap()) != null) {
            tumap.setSegmentsMode(this.isSegments);
        }
        this.optionChanged = true;
    }

    public boolean getSegmentsMode() {
        return this.isSegments;
    }

    public void setEditMode(boolean mode) {
        this.editMode = mode;
    }

    public boolean getEditMode() {
        return this.editMode;
    }

    public void setWorkflowMode(int mode) {
        this.flowMode = mode;
        this.optionChanged = true;
    }

    public int getWorkflowMode() {
        return this.flowMode;
    }

    public void setMatchType(int type) {
        this.matchType = AppPreferences.noWordSeparatorSourceLanguage && !AppPreferences.userBreakIteratorTokenizer ? 2 : (type == 2 ? 0 : type);
    }

    public int getMatchType() {
        return this.matchType;
    }

    public void setPrefixMatch(boolean pmatch) {
        this.prefixMatch = pmatch;
    }

    public void setPrefixAccuracy(int accur) {
        this.prefixAccuracy = accur;
    }

    public boolean getPrefixMatch() {
        return this.prefixMatch;
    }

    public int getPrefixAccuracy() {
        return this.prefixAccuracy;
    }

    public void setCaseMatch(boolean cmatch) {
        this.caseMatch = cmatch;
        this.optionChanged = true;
    }

    public boolean getCaseMatch() {
        return this.caseMatch;
    }

    public void setGreedyMatching(boolean gmatch) {
        this.greedyMatching = gmatch;
        this.optionChanged = true;
    }

    public boolean isGreedyMatching() {
        return this.greedyMatching;
    }

    public void resetParserOptions() {
        SegmentParser parser;
        if (this.tmx != null && (parser = this.tmx.getParser()) != null) {
            parser.setMatchingType(this.matchType, this.prefixMatch, this.caseMatch);
        }
    }

    public void setTMX(TMX tm) {
        Project project;
        this.tmx = tm;
        TMXView view = new TMXView(this.topui, this);
        this.tmx.setView(view);
        TranslationUnitMap tumap = tm.getTUMap();
        tumap.setSegmentsMode(this.isSegments);
        tumap.setPrefixMatching(this.prefixAccuracy);
        tumap.setCaseMatching(this.caseMatch);
        tumap.setLanguagePair(this.slang, this.tlang);
        this.tmx.setLocale(this.tlang);
        this.tmx.setSrcLocale(this.slang);
        SegmentParser parser = new SegmentParser(this);
        parser.setCompareTargets(this.isCompareTargets);
        parser.setPriority(this.priority);
        parser.setMatchingType(this.matchType, this.prefixMatch, this.caseMatch);
        parser.setTUMap(tumap);
        parser.setMemoryStatistics(this.stats);
        if (tumap instanceof TMXUnitMap) {
            TMXUnitMap tuxmap = (TMXUnitMap)tumap;
            tuxmap.setSegmentParser(parser);
        }
        if ((project = this.topui.getProjectView().getProject()) != null) {
            Locale locale = project.getSrcLocale();
            if (locale == null) {
                locale = this.tmx.getSrcLocale();
            }
            parser.setSourceLocale(locale);
        }
        if (tumap.getProgresBar() == null) {
            tumap.setProgressMonitor(this.pm);
        }
        this.tmx.setParser(parser);
    }

    public TMX getTMX() {
        return this.tmx;
    }

    public String getSourceLangCode() {
        return this.slang;
    }

    public String getTargetLangCode() {
        return this.tlang;
    }

    public void setSourceLangCode(String s) {
        this.slang = s;
    }

    public void setTargetLangCode(String t) {
        this.tlang = t;
    }

    public JTextPane getMemoryPane() {
        return this.mpane;
    }

    public void setMemoryPane(JTextPane pane) {
        this.mpane = pane;
        this.mpane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Memory.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Memory.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    Memory.this.topui.getMemoryView().addPhraseDirectToMemory(Memory.this);
                }
            }
        });
        this.htmldoc = (HTMLDocument)this.mpane.getDocument();
    }

    public HTMLDocument getMemoryDoc() {
        return this.htmldoc;
    }

    public String getMemorySizeHTML() {
        int size = this.getSize();
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startTMXResultHTML);
        html.append("<tr>");
        html.append(HTMLFormat.AALeftCol);
        html.append("<b><a href=");
        html.append("\"").append("next").append("\"").append(">");
        html.append("Size: " + size);
        html.append("</a>");
        if (this.isReadOnly()) {
            html.append("<br>read only");
        }
        html.append("</b>");
        html.append("</td>");
        html.append("</tr>");
        html.append("</table></body></html>");
        return html.toString();
    }

    public void showStartDialog(String title) {
        if (title == null) {
            title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TMX MEMORY");
        }
        TMXStartDialog dlg = new TMXStartDialog(this.topui, this, title);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    public void showImportDialog(String title) {
        if (title == null) {
            title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TMX MEMORY");
        }
        TMXImportDialog dlg = new TMXImportDialog(this.topui, this, title);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    public void setMainView(MainView topui) {
        this.topui = topui;
        String s = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LOADING SEGMENTS");
        if (this.name != null && this.name.length() > 0) {
            s = this.name + ": " + s;
        }
        this.pm = new ProgressMonitor(topui, s, "1000", 0, 10000);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.pm;
    }

    public void initMemoryProgress(int currentPos, int endPos, String processName) {
        if (this.bar == null) {
            this.bar = this.topui.getPretranslateProgressBar();
        }
        this.bar.setMinimum(currentPos);
        this.bar.setMaximum(endPos);
        this.bar.setStringPainted(true);
        this.bar.setString(processName);
    }

    public void updateMemoryProgress(int ifrom, String s, boolean process) {
        StringBuilder sb = new StringBuilder(s);
        sb.append(" - ");
        if (process) {
            sb.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PRELIMINARY MEMORY MATCHING")).append("...");
        } else {
            sb.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENT ANALYSIS..."));
        }
        String n = Integer.toString(ifrom);
        sb.append(n);
        this.bar.setString(sb.toString());
        ProgressBarUpdater updater = new ProgressBarUpdater(this.bar, ifrom);
        SwingUtilities.invokeLater(updater);
    }

    public void removeMemoryProgress() {
        if (this.bar != null) {
            this.topui.removePretranslateProgressBar(this.bar);
            this.bar = null;
        }
    }

    private DefaultHandler getLGHandler() {
        return new AppleGlossaryHandler(this);
    }

    private DefaultHandler getBitextHandler() {
        return new BitextHandler(this);
    }

    private DefaultHandler getTMXHandler() {
        DefaultHandler handler = null;
        if (this.imported == 0) {
            this.newTM(AppPreferences.initialCapacity);
            handler = new TBXHandler(this);
            int dot = this.path.lastIndexOf(".");
            if (dot != -1) {
                this.path = this.path.substring(0, dot);
            }
            this.path = this.path + ".tmx";
            this.conditionSaved = true;
        } else if (this.toDatabase) {
            if (this.table != null) {
                handler = new TMXToTableHandler(this, this.table);
            }
        } else if (!this.filter) {
            handler = !this.readOnly && !this.tabbedTM ? new TMXHandler(this) : new TMXReadOnlyHandler(this);
        } else {
            TMXFilterHandler fhandler = new TMXFilterHandler(this);
            if (this.propertiesCondition != null) {
                fhandler.setPoperties(this.propertiesCondition);
                if (this.name != null) {
                    this.name = "Filtered_" + this.name;
                }
            }
            if (this.noteCondition != null) {
                fhandler.setRegularExpressionNote(this.noteCondition);
                if (this.name != null) {
                    this.name = "Filtered_" + this.name;
                }
            }
            if (this.regExp != null) {
                fhandler.setRegularExpression(this.regExp);
                if (this.name != null) {
                    this.name = "Filtered_" + this.name;
                }
            }
            if (this.langFilter) {
                fhandler.setLangFilter(this.langFilter);
            }
            if (this.identicalFilter) {
                fhandler.setIdenticalFilter(this.identicalFilter);
            }
            if (this.emptySegmentFilter) {
                fhandler.setEmptySegmentFilter(this.emptySegmentFilter);
            }
            if (this.internalTagsFilter) {
                fhandler.setInternalTagsFilter(this.internalTagsFilter);
            }
            if (this.foreignCodesFilter) {
                fhandler.setForeignCodesFilter(this.foreignCodesFilter);
            }
            if (this.readOnly) {
                fhandler.setReadOnly(this.readOnly);
            }
            handler = fhandler;
        }
        return handler;
    }

    public void loadZippedTM(File file, String encoding, String ext) {
        String s;
        ZipEntry entry;
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        int i = 0;
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            s = entry.getName();
            if (s.endsWith(".sdlproj")) {
                String[] languagePair = Project.getSDLLanguagePair(zipFile, entry, "UTF-8");
                String sourceLang = languagePair[0];
                String targetLang = languagePair[1];
                if (sourceLang == null || targetLang == null) break;
                if (!this.slang.equals(sourceLang)) {
                    if (!this.tlang.equals(sourceLang)) {
                        if (this.slang.equals(targetLang)) {
                            this.tlang = sourceLang;
                            break;
                        }
                        this.slang = sourceLang;
                        this.tlang = targetLang;
                        break;
                    }
                    this.slang = targetLang;
                    this.tlang = sourceLang;
                    break;
                }
                if (this.tlang.equals(targetLang)) break;
                this.tlang = targetLang;
                break;
            }
            ++i;
        }
        entries = zipFile.entries();
        i = 0;
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            s = entry.getName();
            if (s.endsWith(ext)) {
                if (this.tmx == null) {
                    this.newTM(AppPreferences.initialCapacity);
                }
                SDLTMHandler sdlhandler = new SDLTMHandler(this);
                sdlhandler.loadZippedTextFile(zipFile, s, "UTF-8");
                sdlhandler.parse();
            }
            ++i;
        }
        int dot = this.path.lastIndexOf(".");
        this.path = this.path.substring(0, dot);
        this.path = this.path + ".tmx";
        this.conditionSaved = true;
    }

    private void loadForPretranslationOnly(File[] files) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser saxParser = factory.newSAXParser();
        DefaultHandler handler = this.getTMXHandler();
        if (handler != null) {
            for (int i = 0; i < files.length; ++i) {
                block31: {
                    File file = files[i];
                    String fname = file.getName().toLowerCase();
                    if (file.isDirectory()) {
                        File[] dfiles = file.listFiles();
                        this.loadMemories(dfiles, true);
                    } else {
                        Object sdlhandler;
                        if (fname.endsWith(".tmx")) {
                            FileInputStream fis = new FileInputStream(file);
                            InputSource is = new InputSource(fis);
                            is.setSystemId("file:" + AppPreferences.packagePath);
                            try {
                                saxParser.parse(is, handler);
                                break block31;
                            }
                            catch (SAXException e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(this.topui, e.getMessage());
                                continue;
                            }
                        }
                        if (fname.endsWith(".txt")) {
                            if (this.tmx == null) {
                                this.newTM(AppPreferences.initialCapacity);
                            }
                            if (this.sdlTM) {
                                TXTHandler txthandler = new TXTHandler(this);
                                txthandler.setTXTString(file);
                                txthandler.parse();
                            } else {
                                TabbedTMHandler ttxhandler = new TabbedTMHandler(this);
                                ttxhandler.parse(file, this.encoding);
                            }
                        } else if (fname.endsWith(".xlsx")) {
                            if (this.tmx == null) {
                                this.newTM(AppPreferences.initialCapacity);
                            }
                            sdlhandler = new ExcelTMHandler(this);
                            ((ExcelTMHandler)sdlhandler).parse(file);
                        } else if (fname.endsWith(".sdltm")) {
                            if (this.tmx == null) {
                                this.newTM(AppPreferences.initialCapacity);
                            }
                            sdlhandler = new SDLTMHandler(this);
                            ((SDLTMHandler)sdlhandler).loadTextFile(file, "UTF-8");
                            ((SDLTMHandler)sdlhandler).parse();
                        } else if (fname.endsWith(".sdltb")) {
                            if (this.tmx == null) {
                                this.newTM(AppPreferences.initialCapacity);
                            }
                            sdlhandler = new SDLTBHandler(this);
                            ((SDLTBHandler)sdlhandler).loadDatabaseFile(file);
                            ((SDLTBHandler)sdlhandler).parse();
                        } else {
                            InputSource is;
                            FileInputStream fis;
                            if (fname.endsWith(".lg")) {
                                if (this.tmx == null) {
                                    this.newTM(AppPreferences.initialCapacity);
                                }
                                DefaultHandler lghandler = this.getLGHandler();
                                fis = new FileInputStream(file);
                                is = new InputSource(fis);
                                is.setSystemId("file:" + AppPreferences.packagePath);
                                try {
                                    saxParser.parse(is, lghandler);
                                    break block31;
                                }
                                catch (SAXException e) {
                                    e.printStackTrace();
                                    JOptionPane.showMessageDialog(this.topui, e.getMessage());
                                    continue;
                                }
                            }
                            if (fname.endsWith(".xml")) {
                                if (this.tmx == null) {
                                    this.newTM(AppPreferences.initialCapacity);
                                }
                                if (this.multitermTM) {
                                    MultitermXMLHandler mhandler = new MultitermXMLHandler(this);
                                    mhandler.loadTextFile(file, "UTF-16");
                                    mhandler.parse();
                                } else {
                                    DefaultHandler bitexthandler = this.getBitextHandler();
                                    fis = new FileInputStream(file);
                                    is = new InputSource(fis);
                                    is.setSystemId("file:" + AppPreferences.packagePath);
                                    try {
                                        saxParser.parse(is, bitexthandler);
                                    }
                                    catch (SAXException e) {
                                        e.printStackTrace();
                                        JOptionPane.showMessageDialog(this.topui, e.getMessage());
                                        continue;
                                    }
                                }
                            }
                        }
                    }
                }
                this.setFunctionWords();
            }
        }
    }

    private void loadMemories(File[] files, boolean topLevel) throws SAXException, ParserConfigurationException, IOException {
        this.singleTM = false;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser saxParser = factory.newSAXParser();
        DefaultHandler handler = this.getTMXHandler();
        if (handler != null) {
            for (int i = 0; i < files.length; ++i) {
                InputSource is;
                FileInputStream fis;
                Object sdlhandler;
                File file = files[i];
                String fname = file.getName().toLowerCase();
                if (file.isDirectory()) {
                    File[] dfiles = file.listFiles();
                    this.loadMemories(dfiles, false);
                    continue;
                }
                if (fname.endsWith(".tmx")) {
                    FileInputStream fis2 = new FileInputStream(file);
                    InputSource is2 = new InputSource(fis2);
                    is2.setSystemId("file:" + AppPreferences.packagePath);
                    try {
                        saxParser.parse(is2, handler);
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this.topui, e.getMessage());
                    }
                    continue;
                }
                if (fname.endsWith(".txt")) {
                    if (this.tmx == null) {
                        this.newTM(AppPreferences.initialCapacity);
                    }
                    if (this.sdlTM) {
                        TXTHandler txthandler = new TXTHandler(this);
                        txthandler.setTXTString(file);
                        txthandler.parse();
                        continue;
                    }
                    TabbedTMHandler ttxhandler = new TabbedTMHandler(this);
                    ttxhandler.parse(file, this.encoding);
                    continue;
                }
                if (fname.endsWith(".xlsx")) {
                    if (this.tmx == null) {
                        this.newTM(AppPreferences.initialCapacity);
                    }
                    sdlhandler = new ExcelTMHandler(this);
                    ((ExcelTMHandler)sdlhandler).parse(file);
                    continue;
                }
                if (fname.endsWith(".sdltm")) {
                    if (this.tmx == null) {
                        this.newTM(AppPreferences.initialCapacity);
                    }
                    sdlhandler = new SDLTMHandler(this);
                    ((SDLTMHandler)sdlhandler).loadTextFile(file, "UTF-8");
                    ((SDLTMHandler)sdlhandler).parse();
                    continue;
                }
                if (fname.endsWith(".sdltb")) {
                    if (this.tmx == null) {
                        this.newTM(AppPreferences.initialCapacity);
                    }
                    sdlhandler = new SDLTBHandler(this);
                    ((SDLTBHandler)sdlhandler).loadDatabaseFile(file);
                    ((SDLTBHandler)sdlhandler).parse();
                    continue;
                }
                if (fname.endsWith(".lg")) {
                    if (this.tmx == null) {
                        this.newTM(AppPreferences.initialCapacity);
                    }
                    DefaultHandler lghandler = this.getLGHandler();
                    fis = new FileInputStream(file);
                    is = new InputSource(fis);
                    is.setSystemId("file:" + AppPreferences.packagePath);
                    try {
                        saxParser.parse(is, lghandler);
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this.topui, e.getMessage());
                    }
                    continue;
                }
                if (!fname.endsWith(".xml")) continue;
                if (this.tmx == null) {
                    this.newTM(AppPreferences.initialCapacity);
                }
                if (this.multitermTM) {
                    MultitermXMLHandler mhandler = new MultitermXMLHandler(this);
                    mhandler.loadTextFile(file, "UTF-16");
                    mhandler.parse();
                    continue;
                }
                DefaultHandler bitexthandler = this.getBitextHandler();
                fis = new FileInputStream(file);
                is = new InputSource(fis);
                is.setSystemId("file:" + AppPreferences.packagePath);
                try {
                    saxParser.parse(is, bitexthandler);
                    continue;
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.topui, e.getMessage());
                }
            }
            if (topLevel && handler instanceof TMXToTableHandler) {
                TMXToTableHandler h = (TMXToTableHandler)handler;
                h.endLoading();
            }
        }
    }

    private void importMemories(String mpath, boolean pretranslate) {
        File file;
        if (!mpath.startsWith("file:")) {
            file = new File(mpath);
        } else {
            URI uri;
            try {
                uri = new URI(mpath);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
            file = new File(uri);
        }
        File[] files = file.isDirectory() ? file.listFiles() : new File[]{file};
        try {
            if (!pretranslate) {
                this.loadMemories(files, true);
            } else {
                this.loadForPretranslationOnly(files);
            }
        }
        catch (SAXException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadMemory() {
        boolean urip = false;
        File file = null;
        InputStream fis = null;
        DefaultHandler handler = null;
        boolean isReadOnly = false;
        try {
            block78: {
                block80: {
                    block79: {
                        block77: {
                            if (!this.path.startsWith("http:") && !this.path.startsWith("ftp:")) break block77;
                            URI uri = new URI(this.path);
                            URL url = uri.toURL();
                            fis = url.openStream();
                            break block78;
                        }
                        if (!this.path.startsWith("file:")) {
                            file = new File(this.path);
                        } else {
                            URI uri = new URI(this.path);
                            file = new File(uri);
                            urip = true;
                        }
                        if (!file.isDirectory()) break block79;
                        String dname = file.getName();
                        if (this.name != null && !dname.equalsIgnoreCase(this.name)) {
                            if (!this.name.endsWith(".tmx") && !this.name.endsWith(".TMX")) {
                                this.name = this.name + ".tmx";
                            }
                            this.path = this.path + this.name;
                            if (urip) {
                                URI uri = new URI(this.path);
                                file = new File(uri);
                            } else {
                                file = new File(this.path);
                            }
                            if (!file.exists() && file.createNewFile()) {
                                this.createNewMemory(file);
                            }
                            break block80;
                        } else {
                            File[] files = null;
                            files = file.listFiles();
                            this.loadMemories(files, true);
                            if (this.name == null || this.name.length() == 0) {
                                this.name = "TM";
                            }
                            this.conditionSaved = false;
                            return;
                        }
                    }
                    if (!file.exists() && file.createNewFile()) {
                        this.createNewMemory(file);
                    }
                }
                if (this.path.endsWith(".sdlppx")) {
                    this.loadZippedTM(file, this.encoding, ".sdltm");
                    return;
                }
                if (this.path.endsWith(".txt") || this.path.endsWith(".TXT")) {
                    this.newTM(AppPreferences.initialCapacity);
                    if (this.sdlTM) {
                        TXTHandler txthandler = new TXTHandler(this);
                        txthandler.setTXTString(file);
                        txthandler.parse();
                    } else {
                        TabbedTMHandler ttxhandler = new TabbedTMHandler(this);
                        ttxhandler.parse(file, this.encoding);
                    }
                    if (!this.tabbedTM) {
                        int dot = this.path.lastIndexOf(".");
                        this.path = this.path.substring(0, dot);
                        this.path = this.path + ".tmx";
                    }
                    this.conditionSaved = true;
                    return;
                }
                if (this.path.endsWith(".xlsx") || this.path.endsWith(".XLSX")) {
                    this.newTM(AppPreferences.initialCapacity);
                    ExcelTMHandler exhandler = new ExcelTMHandler(this);
                    exhandler.parse(file);
                    int dot = this.path.lastIndexOf(".");
                    this.path = this.path.substring(0, dot);
                    this.path = this.path + ".tmx";
                    this.conditionSaved = true;
                    return;
                }
                if (this.path.endsWith(".sdltm") || this.path.endsWith(".SDLTM")) {
                    this.newTM(AppPreferences.initialCapacity);
                    SDLTMHandler sdltmhandler = new SDLTMHandler(this);
                    sdltmhandler.loadTextFile(file, "UTF-8");
                    sdltmhandler.parse();
                    int dot = this.path.lastIndexOf(".");
                    this.path = this.path.substring(0, dot);
                    this.path = this.path + ".tmx";
                    this.conditionSaved = true;
                    return;
                }
                if (this.path.endsWith(".sdltb") || this.path.endsWith(".SDLTB")) {
                    this.newTM(AppPreferences.initialCapacity);
                    SDLTBHandler sdltbhandler = new SDLTBHandler(this);
                    sdltbhandler.loadDatabaseFile(file);
                    sdltbhandler.parse();
                    int dot = this.path.lastIndexOf(".");
                    this.path = this.path.substring(0, dot);
                    this.path = this.path + ".tmx";
                    this.conditionSaved = true;
                    return;
                }
                if (this.path.endsWith(".lg") || this.path.endsWith(".LG")) {
                    this.newTM(AppPreferences.initialCapacity);
                    handler = new AppleGlossaryHandler(this);
                    int dot = this.path.lastIndexOf(".");
                    if (dot != -1) {
                        this.path = this.path.substring(0, dot);
                    }
                    this.path = this.path + ".tmx";
                    this.conditionSaved = true;
                } else if (this.imported == -1 && (this.path.endsWith(".xml") || this.path.endsWith(".XML"))) {
                    if (this.multitermTM) {
                        this.newTM(AppPreferences.initialCapacity);
                        MultitermXMLHandler mhandler = new MultitermXMLHandler(this);
                        mhandler.loadTextFile(file, "UTF-16");
                        mhandler.parse();
                        int dot = this.path.lastIndexOf(".");
                        this.path = this.path.substring(0, dot);
                        this.path = this.path + ".tmx";
                        this.conditionSaved = true;
                    } else {
                        this.newTM(AppPreferences.initialCapacity);
                        handler = new BitextHandler(this);
                        int dot = this.path.lastIndexOf(".");
                        if (dot != -1) {
                            this.path = this.path.substring(0, dot);
                        }
                        this.path = this.path + ".tmx";
                        this.conditionSaved = true;
                    }
                } else if (this.path.toLowerCase().endsWith(".xls")) {
                    JOptionPane.showMessageDialog(this.topui, "Please save this MS Excel .xls file in the new MS Excel .xlsx format and start again.");
                    return;
                }
                fis = new FileInputStream(file);
            }
            InputSource is = new InputSource(fis);
            is.setSystemId("file:" + AppPreferences.packagePath);
            if (handler == null) {
                handler = this.getTMXHandler();
            }
            if (handler == null) return;
            if (this.imported == -1) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(is, handler);
                return;
            }
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xr.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            xr.setContentHandler(handler);
            xr.parse(is);
            return;
        }
        catch (SAXException e) {
            String m = e.getMessage();
            if (!m.equals("Read only TMX")) {
                e.printStackTrace();
                this.saxErrorMessage = m;
                this.clearMemory();
                return;
            }
            isReadOnly = true;
            return;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Memory.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WRONG URI SYNTAX"));
                    Memory.this.path = null;
                }
            });
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Memory.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING") + " " + Memory.this.path);
                    Memory.this.path = null;
                }
            });
            return;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(Memory.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WRONG PARSER"));
                    Memory.this.path = null;
                }
            });
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (isReadOnly) {
                this.loadMemory();
            }
        }
    }

    public void collectPretranslatedTUs(Set set) {
        SegmentParser parser;
        TMX tmx = this.getTMX();
        if (tmx != null && (parser = tmx.getParser()) != null) {
            ConcurrentHashMap map = parser.getCacheMap();
            Collection results = map.values();
            for (TMXResult result : results) {
                Collection units = result.getTranslationUnits();
                for (TranslationUnit tu : units) {
                    set.add(tu);
                }
            }
        }
    }

    public void saveMemory(String mpath) {
        this.path = mpath;
        this.conditionSaved = true;
        this.saveMemory(false);
    }

    public void saveNewMemory() {
        String wloc;
        File f;
        final String dir = AppPreferences.memoryDirectory != null && AppPreferences.memoryDirectory.length() > 0 ? AppPreferences.memoryDirectory : (AppPreferences.operatingSystem == 0 ? ((f = new File(wloc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists() ? wloc : System.getProperty("user.home")) : System.getProperty("user.home"));
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ Memory this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        File f;
                        String fileName = "";
                        if (this.this$0.name != null) {
                            fileName = this.this$0.name;
                        }
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE MEMORY") + " " + fileName);
                        if (dir != null && (f = new File(dir)).isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if (fileName != null && fileName.length() > 0) {
                            fileChooser.setInitialFileName(fileName);
                        }
                        if ((file = fileChooser.showSaveDialog(null)) != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 20 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    AppPreferences.memoryDirectory = file.getParent();
                                    this.this$1.this$0.path = file.getPath();
                                    if (!this.this$1.this$0.path.endsWith(".tmx") && !this.this$1.this$0.path.endsWith(".TMX")) {
                                        this.this$1.this$0.path = this.this$1.this$0.path + ".tmx";
                                    }
                                    this.this$1.this$0.newTM(1);
                                    this.this$1.this$0.storeTMXMemory();
                                    this.this$1.this$0.conditionSaved = true;
                                    DashboardView dsh = this.this$1.this$0.topui.getDashboardView();
                                    if (dsh != null) {
                                        dsh.addNewMemory(this.this$1.this$0);
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 20 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            File f2 = new File(dir);
            String n = "";
            if (this.name != null) {
                n = this.name;
            }
            JFileChooser jFileChooser = new JFileChooser();
            String[] mem = new String[]{"Memories"};
            FileFilters filters = new FileFilters();
            filters.setFileFilters(mem, "Memories", jFileChooser);
            jFileChooser.setSelectedFile(new File(n));
            jFileChooser.setCurrentDirectory(f2);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE MEMORY") + " " + n);
            if (0 == jFileChooser.showSaveDialog(this.topui)) {
                File newFile = jFileChooser.getSelectedFile();
                AppPreferences.memoryDirectory = newFile.getParent();
                this.path = newFile.getPath();
                if (!this.path.endsWith(".tmx") && !this.path.endsWith(".TMX")) {
                    this.path = this.path + ".tmx";
                }
                this.newTM(1);
                this.storeTMXMemory();
                this.conditionSaved = true;
                DashboardView dsh = this.topui.getDashboardView();
                if (dsh != null) {
                    dsh.addNewMemory(this);
                }
            }
        }
    }

    public void saveMemory(boolean as) {
        if (AppPreferences.isTrialVersion && totalTUsLoaded >= 1000) {
            return;
        }
        if (this.loadedReadOnly) {
            return;
        }
        if (this.fromDatabase) {
            if (as) {
                this.showFileChooser(false);
            }
            return;
        }
        if (!this.readOnly || this.optionChanged) {
            if (!this.conditionSaved || as) {
                this.showFileChooser(false);
            } else if (!this.tabbedTM) {
                this.storeTMXMemory();
            } else {
                this.storeTXTMemory();
            }
        } else if (as) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("READ ONLY MEMORY"));
        }
    }

    private void showFileChooser(final boolean exit) {
        String wloc;
        File f;
        final String dir = AppPreferences.memoryDirectory != null && AppPreferences.memoryDirectory.length() > 0 ? AppPreferences.memoryDirectory : (AppPreferences.operatingSystem == 0 ? ((f = new File(wloc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists() ? wloc : System.getProperty("user.home")) : System.getProperty("user.home"));
        if (AppPreferences.isJavaFXReady() && !exit) {
            this.topui.requestFocus();
            Platform.runLater((Runnable)new Runnable(){
                final /* synthetic */ Memory this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        File file;
                        File f;
                        String fileName = "";
                        if (this.this$0.name != null) {
                            fileName = this.this$0.name;
                        }
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE MEMORY") + " " + fileName);
                        if (dir != null && (f = new File(dir)).isDirectory() && f.canRead()) {
                            fileChooser.setInitialDirectory(f);
                        }
                        if (fileName != null && fileName.length() > 0) {
                            fileChooser.setInitialFileName(fileName);
                        }
                        if ((file = fileChooser.showSaveDialog(null)) != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 21 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    this.this$1.this$0.saveTM(file, exit);
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 21 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.this$0.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            String[] mem = new String[]{"Memories"};
            FileFilters filters = new FileFilters();
            filters.setFileFilters(mem, "Memories", jFileChooser);
            String fileName = "";
            if (this.name != null) {
                fileName = this.name;
            }
            jFileChooser.setSelectedFile(new File(fileName));
            File f2 = new File(dir);
            jFileChooser.setCurrentDirectory(f2);
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE MEMORY") + " " + fileName);
            jFileChooser.repaint();
            if (0 == jFileChooser.showSaveDialog(this.topui)) {
                File newFile = jFileChooser.getSelectedFile();
                this.saveTM(newFile, exit);
            }
        }
    }

    private void saveTM(File newFile, boolean exit) {
        AppPreferences.memoryDirectory = newFile.getParent();
        String oldPath = this.path;
        this.path = newFile.getPath();
        if (!(this.path.endsWith(".tmx") || this.path.endsWith(".TMX") || this.tabbedTM)) {
            if (this.path.endsWith(".txt") || this.path.endsWith(".TXT")) {
                this.tabbedTM = true;
            } else {
                this.path = this.path + ".tmx";
            }
        }
        if (!exit) {
            TabView tabview = this.topui.getTabView();
            if (this.name != null && tabview.tabExists(this.name)) {
                tabview.selectTab(this.name);
                this.name = newFile.getName();
                tabview.setCurrentName(this.getName());
            } else {
                this.name = newFile.getName();
            }
        } else {
            this.name = newFile.getName();
        }
        if (oldPath != null && oldPath.length() == 0) {
            ResourceLoader rl = this.topui.getResourceLoader();
            rl.setMemoryReference(this.path, this.name);
            rl.addSegmentMemory(this.path);
            rl.addLastSessionResource(this.path);
        }
        this.conditionSaved = true;
        if (!this.tabbedTM) {
            if (!exit) {
                this.storeTMXMemory();
            } else {
                this.storeTMXMemoryAtExit();
            }
        } else if (!exit) {
            this.storeTXTMemory();
        } else {
            this.storeTXTMemoryAtExit();
        }
    }

    public void saveMemoryAtExit() {
        if (AppPreferences.isTrialVersion && totalTUsLoaded >= 1000) {
            return;
        }
        if (this.loadedReadOnly || this.fromDatabase) {
            return;
        }
        if (!this.readOnly && this.isSetToSave()) {
            if (!this.conditionSaved) {
                this.showFileChooser(true);
            } else if (!this.tabbedTM) {
                this.storeTMXMemoryAtExit();
            } else {
                this.storeTXTMemoryAtExit();
            }
        }
    }

    private synchronized void store(FileOutputStream out) throws IOException {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        XMLElement header = this.tmx.getHeader();
        if (header == null) {
            header = new TMXHeader();
            header.setName("header");
            this.tmx.setHeader(header);
        }
        header.setAttribute("changedate", date);
        header.setAttribute("changeid", this.userID);
        if (this.optionChanged) {
            this.storeOptions();
            this.optionChanged = false;
        }
        int total = 1000;
        TranslationUnitMap tumap = this.tmx.getTUMap();
        if (tumap != null) {
            total = tumap.getTotalSize();
        } else {
            Set set = this.tmx.getBody().getTUPretranslationSet();
            if (set != null) {
                total = set.size();
            }
        }
        List notes = header.getChildren("note");
        for (DefaultXMLElement elem : notes) {
            String s;
            Object o = elem.getContent(0);
            if (o == null || !(s = o.toString()).startsWith("size=")) continue;
            header.removeChild(elem);
        }
        DefaultXMLElement elem = new DefaultXMLElement();
        elem.setName("note");
        String stotal = String.valueOf(total);
        elem.setContent(0, "size=" + stotal);
        header.addChild(elem);
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, this.encoding));
        if (this.encoding != null && this.encoding.startsWith("UTF-16")) {
            awriter.write("<?xml version=\"1.0\" encoding=\"utf-16\"?>" + AppPreferences.ls);
        } else {
            awriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>" + AppPreferences.ls);
        }
        this.tmx.writeXMLFormat(awriter);
        awriter.close();
        this.isUpdated = false;
    }

    private void storeTMXMemoryAtExit() {
        try {
            File file;
            this.snumber = 0;
            if (!this.path.startsWith("http:") && !this.path.startsWith("file:")) {
                file = new File(this.path);
            } else {
                URI uri = new URI(this.path);
                file = new File(uri);
            }
            String backupName = "BackUp";
            File tempFile = File.createTempFile(backupName, ".tmx", file.getParentFile());
            FileOutputStream fout = new FileOutputStream(tempFile);
            this.store(fout);
            fout.close();
            if (file.exists()) {
                file.delete();
            }
            if (!tempFile.renameTo(file)) {
                throw new IOException();
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING MEMORY!"));
        }
        catch (IOException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING MEMORY!"));
        }
    }

    private void storeTMXMemory() {
        SwingUtilities.invokeLater(new Runnable(){
            JProgressBar bar;
            {
                this.bar = Memory.this.topui.getProjectActionProgressBar();
            }

            @Override
            public void run() {
                try {
                    File file;
                    this.bar.setIndeterminate(true);
                    this.bar.setStringPainted(true);
                    this.bar.setString(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVING") + " " + Memory.this.name);
                    Memory.this.snumber = 0;
                    if (!Memory.this.path.startsWith("http:") && !Memory.this.path.startsWith("file:")) {
                        file = new File(Memory.this.path);
                    } else {
                        URI uri = new URI(Memory.this.path);
                        file = new File(uri);
                    }
                    String backupName = "BackUp";
                    File tempFile = File.createTempFile(backupName, ".tmx", file.getParentFile());
                    FileOutputStream fout = new FileOutputStream(tempFile);
                    Memory.this.store(fout);
                    fout.close();
                    if (file.exists()) {
                        file.delete();
                    }
                    if (!tempFile.renameTo(file)) {
                        throw new IOException();
                    }
                    Memory.this.topui.removeProjectActionProgressBar(this.bar);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(Memory.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING MEMORY!"));
                    Memory.this.topui.removeProjectActionProgressBar(this.bar);
                }
                catch (IOException ex) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(Memory.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING MEMORY!"));
                    Memory.this.topui.removeProjectActionProgressBar(this.bar);
                }
            }
        });
    }

    private synchronized void storeTXT(FileOutputStream out) throws IOException {
        char separator = '\t';
        char newLine = '\n';
        char space = ' ';
        TranslationUnitMap tumap = this.tmx.getTUMap();
        String srcLang = tumap.getSourceLang();
        String trgLang = tumap.getTargetLang();
        StringBuilder sb = new StringBuilder();
        String h = this.tmx.getTabbedTextHeader();
        if (h != null) {
            sb.append(h);
            sb.append(AppPreferences.ls);
        }
        Collection col = tumap.getMapTranslationUnits();
        for (TranslationUnit tu : col) {
            if (tu.hasParent()) continue;
            String s = tu.getSegment(srcLang);
            s = s.replace(newLine, space);
            String t = tu.getSegment(trgLang);
            t = t.replace(newLine, space);
            sb.append(s);
            sb.append(separator);
            sb.append(t);
            Object[] props = tu.getProperties();
            if (props != null) {
                for (int i = 0; i < props.length; ++i) {
                    String[] arr;
                    String type;
                    Object object = props[i];
                    if (object == null || (type = (arr = (String[])object)[0]).equals("target_tags")) continue;
                    String cont = arr[1];
                    sb.append(separator);
                    sb.append(cont);
                }
            }
            sb.append(AppPreferences.ls);
        }
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, this.encoding));
        awriter.write(sb.toString());
        awriter.close();
        this.isUpdated = false;
    }

    private void storeTXTMemory() {
        SwingUtilities.invokeLater(new Runnable(){
            JProgressBar bar;
            {
                this.bar = Memory.this.topui.getProjectActionProgressBar();
            }

            @Override
            public void run() {
                try {
                    File file;
                    this.bar.setIndeterminate(true);
                    this.bar.setStringPainted(true);
                    this.bar.setString(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVING") + " " + Memory.this.name);
                    Memory.this.snumber = 0;
                    if (!Memory.this.path.startsWith("http:") && !Memory.this.path.startsWith("file:")) {
                        file = new File(Memory.this.path);
                    } else {
                        URI uri = new URI(Memory.this.path);
                        file = new File(uri);
                    }
                    String backupName = "BackUp";
                    File tempFile = File.createTempFile(backupName, ".txt", file.getParentFile());
                    FileOutputStream fout = new FileOutputStream(tempFile);
                    Memory.this.storeTXT(fout);
                    fout.close();
                    if (file.exists()) {
                        file.delete();
                    }
                    if (!tempFile.renameTo(file)) {
                        throw new IOException();
                    }
                    Memory.this.topui.removeProjectActionProgressBar(this.bar);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(Memory.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING MEMORY!"));
                    Memory.this.topui.removeProjectActionProgressBar(this.bar);
                }
                catch (IOException ex) {
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(Memory.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING MEMORY!"));
                    Memory.this.topui.removeProjectActionProgressBar(this.bar);
                }
            }
        });
    }

    private void storeTXTMemoryAtExit() {
        try {
            File file;
            this.snumber = 0;
            if (!this.path.startsWith("http:") && !this.path.startsWith("file:")) {
                file = new File(this.path);
            } else {
                URI uri = new URI(this.path);
                file = new File(uri);
            }
            String backupName = "BackUp";
            File tempFile = File.createTempFile(backupName, ".txt", file.getParentFile());
            FileOutputStream fout = new FileOutputStream(tempFile);
            this.storeTXT(fout);
            fout.close();
            if (file.exists()) {
                file.delete();
            }
            if (!tempFile.renameTo(file)) {
                throw new IOException();
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING MEMORY!"));
        }
        catch (IOException ex) {
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR SAVING MEMORY!"));
        }
    }

    public boolean isSetToSave() {
        if (this.tmx != null && !this.tmx.saved) {
            return true;
        }
        return this.isUpdated;
    }

    public void setToSave(boolean flag) {
        this.isUpdated = flag;
    }

    private void createNewMemory(File file) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        String xml = "<?xml version=\"1.0\"?><tmx version=\"1.4\">  <header    creationtool=\"CafeTran\"    creationtoolversion=\"2.0\"    datatype=\"PlainText\"    segtype=\"sentence\"    o-tmf=\"CafeTran TMX\"    adminlang=\"EN-US\"    srclang=\"" + this.slang + "\"    creationdate=\"" + date + "\"    creationid=\"" + this.creationid + "\"    changedate=\"" + date + "\"    changeid=\"" + this.creationid + "\"  >  </header>  <body>  </body></tmx>";
        try {
            FileOutputStream fos = new FileOutputStream(file);
            Charset charset = Charset.forName(this.encoding);
            CharsetEncoder encoder = charset.newEncoder();
            FileChannel fc = fos.getChannel();
            CharBuffer cb = CharBuffer.wrap(xml.toCharArray());
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            fc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void update() {
        if (this.updates != null && this.updates.size() > 0 && !this.readOnly) {
            LinkedHashMap attrs = null;
            Project pro = this.topui.getProjectView().getProject();
            if (pro != null) {
                attrs = pro.getSegmentAttributes();
            }
            for (Object object : this.updates) {
                Object[] pair = (Object[])object;
                String key = null;
                String value = null;
                String note = null;
                if (pair[0] != null) {
                    key = pair[0].toString();
                }
                if (pair[1] != null) {
                    value = pair[1].toString();
                }
                if (pair[2] != null) {
                    note = pair[2].toString();
                }
                int[] tags = (int[])pair[3];
                this.tmx.update(key, value, note, attrs, tags, this.remDuplicates);
                this.setNewTU();
                this.isUpdated = true;
            }
            this.updates.clear();
            this.checkTrialVersionLimit();
        }
    }

    public synchronized void updateMemory(String key, String value, String note, Map attrs) {
        if (!this.isActive) {
            Project pro;
            if (attrs == null && (pro = this.topui.getProjectView().getProject()) != null) {
                attrs = pro.getSegmentAttributes();
            }
            if (this.project != null) {
                TranslationUnit ntu;
                TranslationUnitMap map;
                TMX ptmx = this.project.getTMX();
                this.setNewTU(ptmx);
                ptmx.update(key, value, note, attrs, null, this.remDuplicates);
                ptmx.saved = false;
                this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(1);
                if (this.project.getProjects() != null && (map = ptmx.getTUMap()) != null && (ntu = map.getNewTU()) != null) {
                    this.tmx.getView();
                    List tunits = TMXView.getFilteredUnits();
                    if (tunits != null) {
                        tunits.add(ntu);
                    }
                    if ((tunits = this.tmx.getView().getGluedUnits()) != null) {
                        tunits.add(ntu);
                    }
                }
                this.setNewTU(ptmx);
            } else {
                this.tmx.update(key, value, note, attrs, null, this.remDuplicates);
                this.setNewTU();
                this.isUpdated = true;
                if (AppPreferences.mautosave > 0) {
                    ++this.snumber;
                    if (this.snumber >= AppPreferences.mautosave) {
                        this.saveMemory(false);
                    }
                }
            }
            this.checkTrialVersionLimit();
        } else {
            if (this.updates == null) {
                this.updates = new ArrayList();
            }
            Object[] pair = new Object[]{key, value, note, null};
            this.updates.add(pair);
            this.isUpdated = true;
            ++this.snumber;
        }
    }

    public synchronized void updateMemoryWithTags(String key, String value, int[] tags) {
        if (!this.isActive) {
            LinkedHashMap attrs = null;
            Project pro = this.topui.getProjectView().getProject();
            if (pro != null) {
                attrs = pro.getSegmentAttributes();
            }
            this.tmx.update(key, value, null, attrs, tags, this.remDuplicates);
            this.setNewTU();
            this.isUpdated = true;
            if (AppPreferences.mautosave > 0) {
                ++this.snumber;
                if (this.snumber >= AppPreferences.mautosave) {
                    this.saveMemory(false);
                }
            }
            this.checkTrialVersionLimit();
        } else {
            if (this.updates == null) {
                this.updates = new ArrayList();
            }
            Object[] pair = new Object[]{key, value, null, tags};
            this.updates.add(pair);
            this.isUpdated = true;
            ++this.snumber;
        }
    }

    public void updateDataBaseMemory(String key, String value, String note, String field, String context, String client, String reference) {
        LinkedHashMap<String, String> attrs = null;
        if (field != null) {
            attrs = new LinkedHashMap<String, String>(1);
            attrs.put(AppPreferences.dbFieldCol, field);
        }
        if (context != null) {
            if (attrs == null) {
                attrs = new LinkedHashMap(1);
            }
            attrs.put(AppPreferences.dbContextCol, context);
        }
        if (client != null) {
            if (attrs == null) {
                attrs = new LinkedHashMap(1);
            }
            attrs.put(AppPreferences.dbClientCol, client);
        }
        if (reference != null) {
            if (attrs == null) {
                attrs = new LinkedHashMap(1);
            }
            attrs.put(AppPreferences.dbURLCol, reference);
        }
        this.tmx.update(key, value, note, attrs, null, this.remDuplicates);
        this.setNewTU();
        this.isUpdated = true;
    }

    public void setNewTU() {
        if (this.tmx != null) {
            this.tmx.createNewTU(this.userID);
        }
    }

    public void setNewTU(TMX tmx) {
        tmx.createNewTU(this.userID);
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public void setUserID(String id) {
        this.userID = id;
    }

    public String getUserID() {
        return this.userID;
    }

    void setPropertiesCondition(Map props) {
        this.propertiesCondition = props;
        this.conditionSaved = false;
        this.filter = true;
    }

    void setNoteCondition(String note) {
        this.noteCondition = note;
        this.conditionSaved = false;
        this.filter = true;
    }

    void setRegExpCondition(String reg) {
        this.regExp = reg;
        this.conditionSaved = false;
        this.filter = true;
    }

    void setLangFilter(boolean f) {
        this.langFilter = f;
        this.conditionSaved = false;
        this.filter = true;
    }

    void setIdenticalFilter(boolean f) {
        this.identicalFilter = f;
        this.conditionSaved = false;
        this.filter = true;
    }

    void setEmptySegmentFilter(boolean f) {
        this.emptySegmentFilter = f;
        this.conditionSaved = false;
        this.filter = true;
    }

    void setInternalTagsFilter(boolean f) {
        this.internalTagsFilter = f;
        this.conditionSaved = false;
        this.filter = true;
    }

    void setForeignCodesFilter(boolean f) {
        this.foreignCodesFilter = f;
        this.conditionSaved = false;
        this.filter = true;
    }

    public void setPretranslateOnly(boolean po) {
        this.pretranslateOnly = po;
        if (po) {
            this.setReadOnly(true);
            this.setWorkflowMode(1);
        }
        this.optionChanged = true;
    }

    public boolean isPretranslateOnly() {
        return this.pretranslateOnly;
    }

    public void setReadOnlyLoaded(boolean ro) {
        this.loadedReadOnly = ro;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
        this.optionChanged = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean hasTagPostions() {
        return this.tagsPositions;
    }

    public void setWithTagPositions(boolean tagPos) {
        this.tagsPositions = tagPos;
        this.optionChanged = true;
    }

    public void setBlocked(boolean b) {
        this.isBlocked = b;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void setTaskReady(boolean b) {
        this.isTaskReady = b;
    }

    public boolean isTaskReady() {
        return this.isTaskReady;
    }

    public void setDuplicatesMode(int dup) {
        this.remDuplicates = dup;
        this.optionChanged = true;
    }

    public int getDuplicatesMode() {
        return this.remDuplicates;
    }

    public boolean isCompareTargets() {
        return this.isCompareTargets;
    }

    public void setCompareTargets(boolean compare) {
        SegmentParser parser;
        this.isCompareTargets = compare;
        if (this.tmx != null && (parser = this.tmx.getParser()) != null) {
            parser.setCompareTargets(this.isCompareTargets);
        }
    }

    public void storeOptions() {
        XMLElement header = this.tmx.getHeader();
        List properties = header.getChildren();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            XMLElement next;
            String n;
            Object o = iterator.next();
            if (!(o instanceof XMLElement) || (n = (next = (XMLElement)o).getName()) == null || !n.equals("prop")) continue;
            iterator.remove();
        }
        DefaultXMLElement newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-segments");
        newProperty.setContent(0, Boolean.toString(this.isSegments));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-terms");
        newProperty.setContent(0, Boolean.toString(this.isTerms));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-processing_tags");
        newProperty.setContent(0, Boolean.toString(this.tagsPositions));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-read_only");
        newProperty.setContent(0, Boolean.toString(this.readOnly));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-stop_autoassembling");
        newProperty.setContent(0, Boolean.toString(this.autoAssemblingStopped));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-pretranslate_only");
        newProperty.setContent(0, Boolean.toString(this.pretranslateOnly));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-terms_consistency_check");
        newProperty.setContent(0, Boolean.toString(this.termsCheck));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-priority");
        newProperty.setContent(0, Integer.toString(this.priority));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-integration");
        newProperty.setContent(0, Integer.toString(this.flowMode));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-prefix_matching");
        newProperty.setContent(0, Boolean.toString(this.prefixMatch));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-case_match");
        newProperty.setContent(0, Boolean.toString(this.caseMatch));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-duplicates");
        newProperty.setContent(0, Integer.toString(this.remDuplicates));
        header.addChild(newProperty);
        newProperty = new DefaultXMLElement();
        newProperty.setName("prop");
        newProperty.setAttribute("type", "x-greedy_exact_match");
        newProperty.setContent(0, Boolean.toString(this.greedyMatching));
        header.addChild(newProperty);
    }

    public void setSavedStatus(boolean status) {
        this.conditionSaved = status;
    }

    void cancelLoad() {
        this.startLoad = false;
    }

    public boolean canLoad() {
        return this.startLoad;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        String s = this.name.indexOf(".tmx") != -1 ? this.name.substring(0, this.name.lastIndexOf(".tmx")) : (this.name.indexOf(".TMX") != -1 ? this.name.substring(0, this.name.lastIndexOf(".TMX")) : (this.name.indexOf(".txt") != -1 ? this.name.substring(0, this.name.lastIndexOf(".txt")) : (this.name.indexOf(".TXT") != -1 ? this.name.substring(0, this.name.lastIndexOf(".TXT")) : this.name)));
        return s;
    }

    public String getInfoPath() {
        return this.infoPath;
    }

    public void newTM(int size) {
        TMXUnitMap map;
        TMXBody body;
        TMX tmx = new TMX();
        tmx.setAttribute("version", "1.4");
        tmx.setName("tmx");
        if (this.fromDatabase || !this.readOnly && !this.tabbedTM) {
            body = new TMXBody(1, size);
            map = new TMXUnitMap(size);
            tmx.setTUMap(map);
            body.setTUMap(map);
        } else {
            body = new TMXBody(1, 1);
            map = new TMXReadOnlyUnitMap(size);
            tmx.setTUMap(map);
        }
        body.setName("body");
        tmx.setBody(body);
        TMXHeader tmh = new TMXHeader();
        tmh.setName("header");
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        tmh.setAttribute("creationtool", "CafeTran");
        tmh.setAttribute("creationtoolversion", "2.0");
        tmh.setAttribute("datatype", "plaintext");
        tmh.setAttribute("segtype", "sentence");
        tmh.setAttribute("o-tmf", "CafeTran TMX");
        tmh.setAttribute("adminlang", "EN-US");
        tmh.setAttribute("srclang", this.slang);
        tmh.setAttribute("creationdate", date);
        tmh.setAttribute("creationid", this.userID);
        tmx.setHeader(tmh);
        this.setEditMode(false);
        this.setTMX(tmx);
        this.setNewTU();
        this.conditionSaved = false;
    }

    public void newTMX() {
        this.tmx = new TMX();
        this.tmx.setAttribute("version", "1.4");
        this.tmx.setName("tmx");
        TMXBody body = new TMXBody(1, 1);
        body.setName("body");
        this.tmx.setBody(body);
        TMXHeader tmh = new TMXHeader();
        tmh.setName("header");
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        String date = sdf.format(cal.getTime()).toString();
        tmh.setAttribute("creationtool", "CafeTran");
        tmh.setAttribute("creationtoolversion", "2.0");
        tmh.setAttribute("datatype", "plaintext");
        tmh.setAttribute("segtype", "sentence");
        tmh.setAttribute("o-tmf", "CafeTran TMX");
        tmh.setAttribute("adminlang", "EN-US");
        tmh.setAttribute("srclang", this.slang);
        tmh.setAttribute("creationdate", date);
        tmh.setAttribute("creationid", this.userID);
        this.tmx.setHeader(tmh);
    }

    private void setFunctionWords() {
        SwingWorker worker = new SwingWorker(){

            public String doInBackground() {
                Memory.this.tmx.setFunctionWords();
                return null;
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
    }

    public void switchProjectTM() {
        TranslationUnitMap tumap = this.tmx.getTUMap();
        tumap.setLanguagePair(this.slang, this.tlang);
        this.tmx.setLocale(this.tlang);
        this.tmx.setSrcLocale(this.slang);
        this.tmx.switchDirection();
        this.resetParserOptions();
    }

    private void changeLangaugePairAndReload() {
        if (this.tmx != null) {
            this.tmx.getTranslationUnits().clear();
            this.tmx.getChildren().clear();
        }
        String n = "";
        if (this.name != null) {
            n = " - " + this.name;
        }
        this.showStartDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE SOURCE AND TARGET LANGUAGES") + n);
        if (this.canLoad()) {
            this.tmx = null;
            SwingWorker worker = new SwingWorker(){

                public String doInBackground() {
                    Memory.this.loadTM();
                    return null;
                }

                @Override
                protected void done() {
                    Memory.this.finishLoadTM();
                }
            };
            worker.execute();
        }
    }

    private void reloadMemory() {
        if (this.tmx != null) {
            this.tmx.getTranslationUnits().clear();
            this.tmx.getChildren().clear();
            this.tmx = null;
        }
        SwingWorker worker = new SwingWorker(){

            public String doInBackground() {
                Memory.this.loadTM();
                return null;
            }

            @Override
            protected void done() {
                Memory.this.finishLoadTM();
            }
        };
        worker.execute();
    }

    public void loadMemoryForPretranslation() {
        String mpath = this.path;
        this.importMemories(mpath, true);
        this.setNewTU();
        TranslationUnitMap tumap = this.tmx.getTUMap();
        this.pm.close();
        tumap.cancelProgress();
        this.checkTrialVersionLimit();
    }

    public void loadTM() {
        this.setEditMode(false);
        this.loadMemory();
        this.setNewTU();
    }

    public void finishLoadTM() {
        if (this.saxErrorMessage != null) {
            String mes = this.saxErrorMessage;
            this.saxErrorMessage = null;
            Object[] options = new Object[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE INVALID XML CHARACTERS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL")};
            int n = JOptionPane.showOptionDialog(this.topui, mes, "Error message from: " + this.name, 2, 0, null, options, options[0]);
            if (n == 0) {
                if (this.importedPath != null) {
                    this.path = this.importedPath;
                }
                this.removeInvalidXMLChars(mes);
                SwingWorker worker = new SwingWorker(){

                    public String doInBackground() {
                        Memory.this.loadTM();
                        return null;
                    }

                    @Override
                    protected void done() {
                        Memory.this.finishLoadTM();
                    }
                };
                worker.execute();
            }
            return;
        }
        this.previousTUS();
        this.pm.close();
        TranslationUnitMap tumap = this.tmx.getTUMap();
        int total = tumap.getTotalSize();
        int msize = tumap.getLoadedSize();
        if (total > 0 && msize == 0) {
            if (!this.hasTagPostions()) {
                this.changeLanguagePair();
            } else {
                this.changeLangaugePairAndReload();
            }
        } else {
            tumap.cancelProgress();
            this.setFunctionWords();
            if (this.flowMode == 0 && msize > AppPreferences.forcedPreliminaryMatchingThreshold) {
                this.switchToPreliminaryMatchingMode();
            }
        }
        this.checkTrialVersionLimit();
    }

    private void switchToPreliminaryMatchingMode() {
        this.flowMode = 1;
        Project project = this.topui.getProjectView().getProject();
        if (project != null) {
            XLIFF xliff = project.getXLIFF();
            if (xliff != null) {
                XliffWorkflow wf = xliff.getWorkflow();
                if (wf != null) {
                    wf.setPretransationStarted(false);
                }
            } else {
                TTXWorkflow wf;
                TTX ttx = project.getTTX();
                if (ttx != null && (wf = ttx.getWorkflow()) != null) {
                    wf.setPretransationStarted(false);
                }
            }
        }
    }

    public void importTM(final String mpath) {
        TranslationUnitMap tumap = this.tmx.getTUMap();
        tumap.initProgress(0, 10000, "1000");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Memory this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.importMemories(mpath, false);
                this.this$0.setNewTU();
                return null;
            }

            @Override
            protected void done() {
                this.this$0.setToSave(true);
                TranslationUnitMap tumap = this.this$0.tmx.getTUMap();
                int total = tumap.getTotalSize();
                int msize = tumap.getLoadedSize();
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NUMBER OF UNITS IN MEMORY:") + msize);
                this.this$0.previousTUS();
                this.this$0.pm.close();
                tumap.cancelProgress();
                this.this$0.setFunctionWords();
                this.this$0.checkTrialVersionLimit();
            }
        };
        worker.execute();
    }

    public void loadToTable() {
        SwingWorker worker = new SwingWorker(){

            public String doInBackground() {
                Memory.this.loadMemory();
                return null;
            }

            @Override
            protected void done() {
                if (Memory.this.saxErrorMessage != null) {
                    String mes = Memory.this.saxErrorMessage;
                    Memory.this.saxErrorMessage = null;
                    Object[] options = new Object[]{ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE INVALID XML CHARACTERS"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL")};
                    int n = JOptionPane.showOptionDialog(Memory.this.topui, mes, "Error message from: " + Memory.this.name, 2, 0, null, options, options[0]);
                    if (n == 0) {
                        if (Memory.this.importedPath != null) {
                            Memory.this.path = Memory.this.importedPath;
                        }
                        Memory.this.removeInvalidXMLChars(mes);
                        Memory.this.loadToTable();
                    }
                    return;
                }
                JOptionPane.showMessageDialog(Memory.this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
            }
        };
        worker.execute();
    }

    public int loadTMXProject() {
        if (this.isReadOnly()) {
            this.setReadOnly(false);
        }
        this.loadMemory();
        if (this.saxErrorMessage != null) {
            String mes = this.saxErrorMessage;
            this.saxErrorMessage = null;
            this.removeInvalidXMLChars(mes);
            this.loadMemory();
        }
        if (this.saxErrorMessage != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String mes = Memory.this.saxErrorMessage;
                    Memory.this.saxErrorMessage = null;
                    JOptionPane.showMessageDialog(Memory.this.topui, mes);
                }
            });
        }
        this.setNewTU();
        TranslationUnitMap tumap = this.tmx.getTUMap();
        int msize = tumap.getLoadedSize();
        this.pm.close();
        this.checkTrialVersionLimit();
        return msize;
    }

    public void loadDatabaseTM(TermBase base) {
        this.setEditMode(false);
        DatabaseHandler handler = new DatabaseHandler(this, base);
        DatabaseView dbview = this.topui.getDatabaseView();
        boolean closeConnection = true;
        Project project = this.topui.getProjectView().getProject();
        if (project != null && project.mode == 3) {
            closeConnection = false;
        }
        List tnames = this.databaseTableNames != null && !this.databaseTableNames.isEmpty() ? this.databaseTableNames : dbview.getTableNames();
        handler.setTableNames(tnames);
        try {
            boolean filter = false;
            if (this.propertiesCondition != null) {
                handler.setProperties(this.propertiesCondition);
                filter = true;
            }
            if (this.noteCondition != null) {
                handler.setRegularExpressionNote(this.noteCondition);
                filter = true;
            }
            if (this.regExp != null) {
                handler.setRegularExpression(this.regExp);
                filter = true;
            }
            if (this.identicalFilter) {
                handler.setIdenticalFilter(this.identicalFilter);
                filter = true;
            }
            if (this.emptySegmentFilter) {
                handler.setEmptySegmentFilter(this.emptySegmentFilter);
                filter = true;
            }
            if (!filter) {
                handler.loadToMemory(closeConnection);
            } else {
                handler.loadToFilteredMemory(closeConnection);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.topui, ex.toString());
            Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setNewTU();
        TranslationUnitMap tumap = this.tmx.getTUMap();
        int total = tumap.getTotalSize();
        int msize = tumap.getLoadedSize();
        this.previousTUS();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Memory.this.pm.close();
                Memory.this.checkTrialVersionLimit();
            }
        });
        if (total > 0 && msize == 0) {
            this.changeLanguagePair();
        } else {
            this.setFunctionWords();
            if (this.flowMode == 0 && msize > AppPreferences.forcedPreliminaryMatchingThreshold) {
                this.switchToPreliminaryMatchingMode();
            }
        }
    }

    public void saveDatabaseTM(final TermBase base) {
        TMX tmx = this.getTMX();
        TranslationUnitMap tmap = tmx.getTUMap();
        Collection col = tmx.getTranslationUnits();
        tmap.initProgress(0, col.size(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SENDING MEMORY SEGMENTS TO DATABASE"));
        final ProgressMonitor pbar = tmap.getProgresBar();
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ Memory this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                DatabaseHandler handler = new DatabaseHandler(this.this$0, base);
                try {
                    handler.loadTMToDatabase();
                }
                catch (SQLException ex) {
                    JOptionPane.showMessageDialog(this.this$0.topui, ex.toString());
                    Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
                }
                return null;
            }

            @Override
            protected void done() {
                if (pbar != null) {
                    pbar.close();
                }
                JOptionPane.showMessageDialog(this.this$0.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ACTION COMPLETED"));
            }
        };
        worker.execute();
    }

    public void storeToDatabase() {
        DatabaseView dbview = this.topui.getDatabaseView();
        List list = dbview.getTableNames();
        if (list.isEmpty()) {
            dbview.makeTable();
            list = dbview.getTableNames();
            if (list.isEmpty()) {
                return;
            }
        }
        String n = this.getName();
        DatabaseSaveChooser dlg = new DatabaseSaveChooser(this.topui, n + " -> Total Recall", this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.topui.getSize();
        Point loc = this.topui.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    public void changeLanguagePair() {
        String n = "";
        if (this.name != null) {
            n = " - " + this.name;
        }
        this.showStartDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE SOURCE AND TARGET LANGUAGES") + n);
        if (this.canLoad()) {
            SwingWorker worker = new SwingWorker(){

                public String doInBackground() {
                    TranslationUnitMap tumap = Memory.this.tmx.getTUMap();
                    tumap.setSegmentsMode(Memory.this.isSegments);
                    tumap.setPrefixMatching(Memory.this.prefixAccuracy);
                    tumap.setCaseMatching(Memory.this.caseMatch);
                    tumap.setLanguagePair(Memory.this.slang, Memory.this.tlang);
                    Memory.this.tmx.setLocale(Memory.this.tlang);
                    Memory.this.tmx.setSrcLocale(Memory.this.slang);
                    Memory.this.tmx.switchDirection();
                    Memory.this.resetParserOptions();
                    Memory.this.setNewTU();
                    return null;
                }

                @Override
                protected void done() {
                    TranslationUnitMap tumap = Memory.this.tmx.getTUMap();
                    Memory.this.nextTUS();
                    tumap.cancelProgress();
                    Memory.this.setFunctionWords();
                    int msize = tumap.getLoadedSize();
                    if (Memory.this.flowMode == 0 && msize > AppPreferences.forcedPreliminaryMatchingThreshold) {
                        Memory.this.switchToPreliminaryMatchingMode();
                    }
                }
            };
            worker.execute();
        }
    }

    public void nextTUS() {
        if (this.tmx != null) {
            TMXView view = this.tmx.getView();
            view.nextTUS();
        }
    }

    public void previousTUS() {
        if (this.tmx != null) {
            TMXView view = this.tmx.getView();
            view.previousTUS();
        }
    }

    public void searchMemory(String s, String r, int mode) {
        if (this.tmx != null) {
            this.tmx.searchFile(s, r, mode);
        }
    }

    public void edit(String s) {
        if (this.tmx != null) {
            this.tmx.editElement(s);
        }
        this.topui.getTargetPane().requestFocusInWindow();
    }

    private boolean okToAbandon() {
        if (!this.isUpdated || this.readOnly) {
            return true;
        }
        String title = this.getName();
        if (title == null || title.length() == 0) {
            title = "CafeTran Espresso";
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE CHANGES IN THE MEMORY?"), title, 1);
        switch (value) {
            case 0: {
                this.saveMemory(false);
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void closeMemory() {
        if (this.okToAbandon()) {
            String n;
            ResourceLoader rl = this.topui.getResourceLoader();
            if (this.infoPath != null) {
                List loader = rl.getResourceLoaderList();
                loader.remove(this.infoPath);
            }
            if (this.path != null) {
                rl.removeMemoryReference(this.path);
            }
            if ((n = this.getName()) != null) {
                String uid = this.getUID();
                this.topui.getTabView().removeTab(uid, n);
            }
            this.topui.getMemoryView().removeLocalMemory(this);
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setPretranslated(boolean p) {
        this.pretrans = p;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isPretranslated() {
        return this.pretrans;
    }

    public void clearMemory() {
        if (this.tmx != null) {
            this.tmx.getTUMap().clearMap();
            Collection c = this.tmx.getTranslationUnits();
            if (c != null) {
                c.clear();
            }
        }
    }

    private void removeInvalidXMLChars(String errorMessage) {
        File file = null;
        if (!this.path.startsWith("file:")) {
            file = new File(this.path);
        } else {
            try {
                URI uri = new URI(this.path);
                file = new File(uri);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(Memory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (file != null) {
            if (errorMessage.indexOf("&#") != -1) {
                Project.searchAndReplaceInFile(file, this.encoding, "&#.*?;", "");
            } else {
                String xml11pattern = "[^ -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]+";
                Project.searchAndReplaceInFile(file, this.encoding, xml11pattern, "");
            }
        }
    }

    public void checkTrialVersionLimit() {
        if (AppPreferences.isTrialVersion && totalTUsLoaded >= 1000) {
            this.readOnly = true;
            if (!trialMessageDisplayed) {
                String cont;
                trialMessageDisplayed = true;
                String message = "The free version of CafeTran Espresso allows you to work with translation memories (TM's) up to 1000 translation units (TU's)\nin size (in total among all TM's), and with glossary files with up to 500 terms (in total). You have reached one of those limits.\nTo unlock the program for use with these larger resources, it is necessary to purchase a license file from the CafeTran.com website.\nOnce you load the license file into the program you will be able to use the program with TM's and glossaries of unlimited size.";
                String s = "Trial Version Limit";
                String buy = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PURCHASE LICENSE");
                Object[] options = new String[]{buy, cont = "Continue to use free version, with limits"};
                int i = JOptionPane.showOptionDialog(this.topui, message, s, 0, 1, null, options, buy);
                if (i == 0) {
                    try {
                        URI uri = new URI(AppPreferences.purchase_url);
                        this.topui.getResourceView();
                        ResourceView.browse(uri);
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(MainView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

