/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;

public class SDLTBHandler {
    private TMXReadOnlyUnitMap romap;
    private String slang;
    private String tlang;
    private String slangVariant;
    private String tlangVariant;
    Memory memory;
    boolean readOnly;
    TMX tmx;
    String txtString;
    String enc;
    Pattern pipePattern;

    public SDLTBHandler(Memory memory) {
        this.memory = memory;
        this.slang = memory.getSourceLangCode();
        int i = this.slang.indexOf(45);
        if (i != -1) {
            this.slangVariant = this.slang;
            this.slang = this.slang.substring(0, i);
        }
        this.tlang = memory.getTargetLangCode();
        i = this.tlang.indexOf(45);
        if (i != -1) {
            this.tlangVariant = this.tlang;
            this.tlang = this.tlang.substring(0, i);
        }
        this.readOnly = memory.isReadOnly();
        this.enc = memory.encoding;
        this.pipePattern = Pattern.compile("|", 16);
    }

    public void loadDatabaseFile(File file) {
        StringBuilder sb = new StringBuilder(AppPreferences.initialCapacity);
        try {
            Database db = DatabaseBuilder.open((File)file);
            Table table = db.getTable("mtConcepts");
            if (table != null) {
                boolean firstRow = true;
                for (Row row : table) {
                    String s = row.getString("text");
                    if (s == null) continue;
                    sb.append(s);
                    if (!firstRow) continue;
                    firstRow = false;
                    if (this.slangVariant != null) {
                        if (s.indexOf(this.slangVariant.toUpperCase()) == -1) {
                            this.slangVariant = null;
                        } else {
                            this.slang = null;
                        }
                    }
                    if (this.tlangVariant == null) continue;
                    if (s.indexOf(this.tlangVariant.toUpperCase()) == -1) {
                        this.tlangVariant = null;
                        continue;
                    }
                    this.tlang = null;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (sb.length() > 0) {
            this.txtString = sb.toString();
        }
    }

    public void parse() {
        this.tmx = this.memory.getTMX();
        if (this.readOnly) {
            this.romap = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
        }
        String languageGroup = "<lG.+?</lG>";
        String termformat = "<tG.+?</tG>";
        String languageformat = "<l .+?>";
        String conceptGroup = "<cG.+?</cG>";
        Pattern conceptGroupP = Pattern.compile(conceptGroup, 34);
        Pattern languageGroupP = Pattern.compile(languageGroup, 34);
        Pattern languageP = Pattern.compile(languageformat, 34);
        Pattern termP = Pattern.compile(termformat, 2);
        Matcher conceptGroupMatcher = conceptGroupP.matcher(this.txtString);
        while (conceptGroupMatcher.find()) {
            String conceptGrp = conceptGroupMatcher.group();
            Matcher langGrp = languageGroupP.matcher(conceptGrp);
            String source = null;
            String target = null;
            String note = null;
            while (langGrp.find()) {
                String sslang = null;
                String ttlang = null;
                String gr = langGrp.group();
                Matcher m = languageP.matcher(gr);
                if (m.find()) {
                    String la;
                    String lgroup = m.group();
                    int si = lgroup.indexOf("lang=\"");
                    if (si == -1) continue;
                    int ei = lgroup.indexOf("\"", si + 6);
                    String lav = la = lgroup.substring(si + 6, ei);
                    int i = la.indexOf(45);
                    if (i != -1) {
                        la = la.substring(0, i);
                    }
                    if (this.slangVariant != null && lav.equalsIgnoreCase(this.slangVariant)) {
                        sslang = lav;
                    } else if (this.tlangVariant != null && lav.equalsIgnoreCase(this.tlangVariant)) {
                        ttlang = lav;
                    } else if (this.slang != null && la.equalsIgnoreCase(this.slang)) {
                        sslang = la;
                    } else if (this.tlang != null && la.equalsIgnoreCase(this.tlang)) {
                        ttlang = la;
                    }
                }
                Matcher mm = termP.matcher(gr);
                StringBuilder content = new StringBuilder();
                while (mm.find()) {
                    int j;
                    String sgr = mm.group();
                    int k = sgr.indexOf("</t>", j = sgr.indexOf("<t>"));
                    if (k == -1) continue;
                    sgr = sgr.substring(j + 3, k);
                    sgr = XMLHelper.resolveEntitiesXML(sgr);
                    if (content.length() > 0) {
                        content.append('|');
                    }
                    content.append(sgr);
                }
                if (sslang != null && this.slang != null && sslang.equalsIgnoreCase(this.slang)) {
                    source = content.toString();
                    continue;
                }
                if (ttlang != null && this.tlang != null && ttlang.equalsIgnoreCase(this.tlang)) {
                    target = content.toString();
                    continue;
                }
                if (sslang != null && this.slangVariant != null && sslang.equalsIgnoreCase(this.slangVariant)) {
                    source = content.toString();
                    continue;
                }
                if (ttlang == null || this.tlangVariant == null || !ttlang.equalsIgnoreCase(this.tlangVariant)) continue;
                target = content.toString();
            }
            if (source == null || target == null) continue;
            String[] sArray = source.indexOf(124) != -1 ? this.pipePattern.split(source) : new String[]{source};
            String[] tArray = target.indexOf(124) != -1 ? this.pipePattern.split(target) : new String[]{target};
            for (int i = 0; i < sArray.length; ++i) {
                String s = sArray[i];
                for (int j = 0; j < tArray.length; ++j) {
                    String t = tArray[j];
                    if (this.readOnly) {
                        TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
                        if (this.slang != null) {
                            tu.setSegment(this.slang, s);
                        } else if (this.slangVariant != null) {
                            tu.setSegment(this.slangVariant, s);
                        }
                        if (this.tlang != null) {
                            tu.setSegment(this.tlang, t);
                        } else if (this.tlangVariant != null) {
                            tu.setSegment(this.tlangVariant, t);
                        }
                        this.romap.load(tu);
                        continue;
                    }
                    int dup = this.memory.getDuplicatesMode();
                    this.tmx.update(s, t, note, null, null, dup);
                    this.memory.setNewTU();
                }
            }
        }
    }
}

