/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import translator.AppPreferences;
import translator.MainView;
import translator.Project;
import translator.tmx.Memory;
import translator.ui.GridPanel;

public class TMXFilterDialog
extends JDialog
implements ActionListener {
    private JCheckBox langFilter = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILTER LANGUAGES"));
    private JCheckBox identFilter = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE SOURCE=TARGET"));
    private JCheckBox emptySegFilter = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE EMPTY SEGMENTS"));
    private JCheckBox internalTagsFilter = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE INTERNAL TAGS"));
    private JCheckBox foreignCodesFilter = new JCheckBox(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLEAN FOREIGN CODES"));
    private JButton jButton1;
    private JButton jButton3;
    private JTextField jTextField8 = null;
    private JTextField jTextField3 = null;
    private Memory tm;
    private MainView parent;
    private JPanel propsPanel;

    public TMXFilterDialog(JDialog owner, MainView parent, Memory tm, String title) {
        super(owner, title, true);
        this.parent = parent;
        this.tm = tm;
        this.langFilter.setOpaque(false);
        this.identFilter.setOpaque(false);
        this.emptySegFilter.setOpaque(false);
        this.internalTagsFilter.setOpaque(false);
        this.foreignCodesFilter.setOpaque(false);
        JPanel jPanel0 = new JPanel();
        jPanel0.setLayout(new GridLayout(0, 2, 10, 0));
        jPanel0.setOpaque(false);
        jPanel0.setBorder(new EmptyBorder(new Insets(10, 2, 0, 2)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(false);
        jPanel5.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENT FILTERS")));
        jPanel5.setLayout(new GridLayout(0, 2, 10, 3));
        jPanel5.add(this.langFilter);
        jPanel5.add(this.identFilter);
        jPanel5.add(this.emptySegFilter);
        jPanel5.add(this.internalTagsFilter);
        jPanel5.add(this.foreignCodesFilter);
        jPanel5.add(new JLabel());
        JLabel label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SEGMENT NOTE:"));
        label.setHorizontalAlignment(4);
        this.jTextField3 = new JTextField();
        this.jTextField3.setMargin(new Insets(0, 2, 0, 0));
        this.jTextField3.setPreferredSize(new Dimension(200, this.jTextField3.getPreferredSize().height));
        jPanel5.add(label);
        jPanel5.add(this.jTextField3);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REGULAR EXPRESSION") + ":");
        label.setHorizontalAlignment(4);
        this.jTextField8 = new JTextField();
        this.jTextField8.setMargin(new Insets(0, 2, 0, 0));
        this.jTextField8.setPreferredSize(new Dimension(200, this.jTextField8.getPreferredSize().height));
        jPanel5.add(label);
        jPanel5.add(this.jTextField8);
        this.propsPanel = new JPanel();
        this.propsPanel.setOpaque(false);
        this.propsPanel.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROPERTIES FILTER")));
        this.propsPanel.setLayout(new GridLayout(0, 2, 5, 5));
        LinkedHashMap<String, String> segAttrs = new LinkedHashMap<String, String>(4);
        String[] at = AppPreferences.segmentAttributes.split(";");
        if (at != null) {
            for (int i = 0; i < at.length; ++i) {
                String string = at[i];
                if (string.length() <= 0) continue;
                segAttrs.put(string, "");
            }
        }
        if (segAttrs.size() < 1) {
            segAttrs.put("Project", "");
        }
        if (segAttrs.size() < 2 && AppPreferences.dbFieldCol.length() > 0) {
            segAttrs.put(AppPreferences.dbFieldCol, "");
        }
        if (segAttrs.size() < 3) {
            segAttrs.put("Client", "");
        }
        if (segAttrs.size() < 4) {
            segAttrs.put("Property", "");
        }
        for (String n : segAttrs.keySet()) {
            Object[] o;
            JComboBox<Object> box = null;
            JTextField field = null;
            if (n.equalsIgnoreCase(AppPreferences.dbFieldCol)) {
                List subjects = Project.getSubjectList();
                if (subjects != null && subjects.size() > 0) {
                    o = subjects.toArray();
                    box = new JComboBox<Object>(o);
                    box.setEditable(true);
                    box.insertItemAt("", 0);
                    box.setSelectedIndex(0);
                } else {
                    box = new JComboBox<String>();
                    box.setEditable(true);
                    box.insertItemAt("", 0);
                    box.setSelectedIndex(0);
                }
            } else if (n.equalsIgnoreCase(AppPreferences.dbClientCol)) {
                List cilents = Project.getClientList();
                if (cilents != null && cilents.size() > 0) {
                    o = cilents.toArray();
                    box = new JComboBox<Object>(o);
                    box.setEditable(true);
                    box.insertItemAt("", 0);
                    box.setSelectedIndex(0);
                } else {
                    box = new JComboBox();
                    box.setEditable(true);
                    box.insertItemAt("", 0);
                    box.setSelectedIndex(0);
                }
            } else {
                field = new JTextField();
                field.setCaretPosition(0);
                field.setMargin(new Insets(0, 2, 0, 0));
                field.setFont(field.getFont().deriveFont(1));
            }
            JButton jb = new JButton();
            String display = n.substring(0, 1).toUpperCase() + n.substring(1);
            jb.setText(display);
            jb.setName(n);
            jb.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SET A PROPERTY NAME"));
            jb.setHorizontalAlignment(2);
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton)e.getSource();
                    String org = button.getName();
                    String n = JOptionPane.showInputDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET A PROPERTY NAME:"), (Object)org);
                    if (n != null && n.length() > 0) {
                        String display = n.substring(0, 1).toUpperCase() + n.substring(1);
                        button.setText(display);
                        button.setName(n);
                    }
                }
            });
            this.propsPanel.add(jb);
            if (field != null) {
                this.propsPanel.add(field);
                continue;
            }
            this.propsPanel.add(box);
        }
        this.setResizable(false);
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton3.addActionListener(this);
        jPanel0.add(this.jButton1);
        jPanel0.add(this.jButton3);
        GridPanel con = new GridPanel();
        this.setContentPane(con);
        EmptyBorder border = new EmptyBorder(10, 20, 10, 20);
        con.setBorder(border);
        con.setLayout(new BorderLayout());
        con.add((Component)jPanel5, "Center");
        con.add((Component)this.propsPanel, "North");
        con.add((Component)jPanel0, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXFilterDialog.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TMXFilterDialog.this.jButton3.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TMXFilterDialog.this.cancel();
            }
        });
        this.pack();
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.closeDialog();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            String reg;
            String note;
            Map props = this.getFilterProperties();
            if (!props.isEmpty()) {
                this.tm.setPropertiesCondition(props);
            }
            if ((note = this.jTextField3.getText()).length() > 0) {
                this.tm.setNoteCondition(note);
            }
            if ((reg = this.jTextField8.getText()).length() > 0) {
                this.tm.setRegExpCondition(reg);
            }
            if (this.langFilter.isSelected()) {
                this.tm.setLangFilter(true);
            }
            if (this.identFilter.isSelected()) {
                this.tm.setIdenticalFilter(true);
            }
            if (this.emptySegFilter.isSelected()) {
                this.tm.setEmptySegmentFilter(true);
            }
            if (this.internalTagsFilter.isSelected()) {
                this.tm.setInternalTagsFilter(true);
            }
            if (this.foreignCodesFilter.isSelected()) {
                this.tm.setForeignCodesFilter(true);
            }
            this.closeDialog();
        } else {
            this.cancel();
        }
    }

    private Map getFilterProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        Component[] comps = this.propsPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            JComboBox box;
            JButton but;
            Component component = comps[i];
            String name = null;
            String value = null;
            if (!(component instanceof JButton) || (name = (but = (JButton)component).getName()) == null) continue;
            name = name.trim();
            component = comps[i + 1];
            ++i;
            if (name.length() <= 0) continue;
            if (component instanceof JTextField) {
                JTextField field = (JTextField)component;
                value = field.getText().trim();
                if (value.length() <= 0) continue;
                properties.put(name.toLowerCase(), value.toLowerCase());
                continue;
            }
            if (!(component instanceof JComboBox) || (value = (box = (JComboBox)component).getSelectedItem().toString()).length() <= 0) continue;
            properties.put(name.toLowerCase(), value.toLowerCase());
        }
        return properties;
    }
}

