/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.CharArrayWriter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.Project;
import translator.XMLElement;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXBody;
import translator.tmx.TMXHeader;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitMap;
import translator.tmx.TMXUnitVariant;

public class TMXHandler
extends DefaultHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    protected Memory memory;
    protected TMX tmx;
    protected TMXHeader header;
    protected String slang;
    protected String tlang;
    protected boolean isProjectTM = false;
    protected Project project;
    private Locator2 locator;

    public TMXHandler(Memory memory) {
        String name;
        this.memory = memory;
        this.project = memory.getProject();
        this.slang = memory.getSourceLangCode();
        int i = this.slang.indexOf(45);
        if (i != -1) {
            this.slang = this.slang.substring(0, i);
        }
        this.tlang = memory.getTargetLangCode();
        i = this.tlang.indexOf(45);
        if (i != -1) {
            this.tlang = this.tlang.substring(0, i);
        }
        if ((name = memory.getName()) != null && name.equalsIgnoreCase("ProjectTM")) {
            this.isProjectTM = true;
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (locator instanceof Locator2) {
            this.locator = (Locator2)locator;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.locator != null) {
            String enc = this.locator.getEncoding();
            if (enc != null && enc.startsWith("UTF-16")) {
                enc = "UTF-16";
            }
            this.memory.encoding = enc;
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        DefaultXMLElement xml;
        if (qName.equals("tuv")) {
            xml = new TMXUnitVariant();
        } else if (qName.equals("tu")) {
            xml = new TMXUnit(this.tmx.getID());
        } else if (qName.equals("tmx")) {
            if (this.project != null) {
                this.tmx = new TMX();
                this.project.setTMX(this.tmx);
            } else {
                this.tmx = this.memory.getTMX();
                if (this.tmx == null) {
                    this.tmx = new TMX();
                }
            }
            xml = this.tmx;
        } else if (qName.equals("header")) {
            this.header = new TMXHeader();
            xml = this.header;
        } else if (qName.equals("body")) {
            TMXBody tmb;
            if (this.header != null && !this.memory.isNewlyAdded()) {
                List properties = this.header.getChildren("prop");
                for (XMLElement next : properties) {
                    Object o;
                    String type = next.getAttribute("type");
                    if (type == null || (o = next.getContent(0)) == null) continue;
                    String value = o.toString();
                    if (type.equals("x-processing_tags")) {
                        this.memory.setWithTagPositions(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-segments")) {
                        this.memory.setSegmentsMode(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-terms")) {
                        this.memory.setTermsMode(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-read_only")) {
                        this.memory.setReadOnly(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-pretranslate_only")) {
                        this.memory.setPretranslateOnly(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-terms_consistency_check")) {
                        this.memory.setTermsCheck(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-priority")) {
                        this.memory.setPriority(Integer.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-integration")) {
                        this.memory.setWorkflowMode(Integer.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-case_match")) {
                        this.memory.setCaseMatch(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-greedy_exact_match")) {
                        this.memory.setGreedyMatching(Boolean.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-duplicates")) {
                        this.memory.setDuplicatesMode(Integer.valueOf(value));
                        continue;
                    }
                    if (type.equals("x-stop_autoassembling")) {
                        this.memory.stopAutoassembling(Boolean.valueOf(value));
                        continue;
                    }
                    if (!type.equals("x-prefix_matching")) continue;
                    boolean pm = Boolean.valueOf(value);
                    this.memory.setPrefixMatch(pm);
                    if (!pm) continue;
                    this.memory.setPrefixAccuracy(AppPreferences.memPrefixAccuracy);
                }
                if (this.memory.isReadOnly()) {
                    throw new SAXException("Read only TMX");
                }
            }
            if ((tmb = this.tmx.getBody()) == null) {
                TMX tmTMX;
                int cap = AppPreferences.initialCapacity;
                if (this.tmx.capacity != -1) {
                    cap = this.tmx.capacity;
                }
                tmb = new TMXBody(1, cap);
                TMXUnitMap map = this.project != null ? ((tmTMX = this.memory.getTMX()) != null ? (TMXUnitMap)tmTMX.getTUMap() : new TMXUnitMap(cap)) : new TMXUnitMap(cap);
                map.setProjectID(this.tmx.getID());
                tmb.setTUMap(map);
                this.tmx.setTUMap(map);
                this.tmx.setBody(tmb);
                this.memory.setTMX(this.tmx);
            }
            xml = tmb;
        } else {
            xml = new DefaultXMLElement(attr.getLength(), 1);
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
        }
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            pxml.addChild(this.contents.toString());
        }
        xml.setName(qName);
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            childXml.addChild(this.contents.toString());
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            if (this.memory.hasTagPostions()) {
                if (xml instanceof TMXUnit) {
                    if (childXml.getName().equals("prop")) {
                        this.setTagPostions(xml, childXml);
                    }
                } else if (!this.isProjectTM && childXml instanceof TMXUnit) {
                    TMXUnit tu = (TMXUnit)childXml;
                    this.setForeignTagPositions(tu);
                }
            }
            xml.addChild(childXml);
        }
        this.contents.reset();
    }

    public void setTagPostions(XMLElement tu, XMLElement prop) {
        String positions;
        String pvalue = prop.getAttribute("type");
        if (pvalue != null && pvalue.equals("target_tags") && (positions = prop.getContent(0).toString()) != null && positions.length() > 0) {
            String[] pos = positions.split(",");
            int[] tags = new int[pos.length];
            for (int i = 0; i < pos.length; ++i) {
                int intPos;
                String stringPos = pos[i];
                tags[i] = intPos = Integer.parseInt(stringPos);
            }
            TMXUnit tux = (TMXUnit)tu;
            tux.setTags(tags);
        }
    }

    public void setForeignTagPositions(TMXUnit tu) {
        XMLElement seg;
        TMXUnitVariant tuv = tu.getTUV(this.tlang);
        if (tuv != null && (seg = tuv.getSegment()) != null) {
            boolean hastags = false;
            boolean isTag = false;
            List list = seg.getChildren();
            StringBuilder sb = new StringBuilder();
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                if (object instanceof String) {
                    if (isTag) {
                        int currentPos = sb.length();
                        if (currentPos > 0) {
                            set.add(currentPos);
                        }
                        isTag = false;
                    }
                    String s = object.toString();
                    sb.append(s);
                    continue;
                }
                isTag = true;
                hastags = true;
            }
            if (set.size() > 0) {
                int[] tags = new int[set.size()];
                int counter = 0;
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    int pos;
                    tags[counter] = pos = ((Integer)it.next()).intValue();
                    ++counter;
                }
                tu.setTags(tags);
                StringBuilder tsb = new StringBuilder();
                for (int j = 0; j < tags.length; ++j) {
                    int k = tags[j];
                    tsb.append(k);
                    if (j + 1 >= tags.length) continue;
                    tsb.append(',');
                }
                DefaultXMLElement elem = new DefaultXMLElement(1, 1);
                elem.setContent(0, tsb.toString());
                elem.setName("prop");
                elem.setAttribute("type", "target_tags");
                tu.getChildren().add(0, elem);
            }
            if (hastags) {
                list.clear();
                seg.setContent(0, sb.toString());
            }
        }
        if ((tuv = tu.getTUV(this.slang)) != null && (seg = tuv.getSegment()) != null) {
            List list = seg.getChildren();
            StringBuilder sb = new StringBuilder();
            boolean hastags = false;
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                if (object instanceof String) {
                    String s = object.toString();
                    sb.append(s);
                    continue;
                }
                hastags = true;
            }
            if (hastags) {
                list.clear();
                seg.setContent(0, sb.toString());
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }
}

